/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.SimpleITKJNI;
import org.itk.simple.VectorString;

public class Version {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Version(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Version version) {
        return version == null ? 0L : version.swigCPtr;
    }

    protected static long swigRelease(Version version) {
        long l = 0L;
        if (version != null) {
            if (!version.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = version.swigCPtr;
            version.swigCMemOwn = false;
            version.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_Version(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static long majorVersion() {
        return SimpleITKJNI.Version_majorVersion();
    }

    public static long minorVersion() {
        return SimpleITKJNI.Version_minorVersion();
    }

    public static long patchVersion() {
        return SimpleITKJNI.Version_patchVersion();
    }

    public static long tweakVersion() {
        return SimpleITKJNI.Version_tweakVersion();
    }

    public static String versionString() {
        return SimpleITKJNI.Version_versionString();
    }

    public static String buildDate() {
        return SimpleITKJNI.Version_buildDate();
    }

    public static long iTKMajorVersion() {
        return SimpleITKJNI.Version_iTKMajorVersion();
    }

    public static long iTKMinorVersion() {
        return SimpleITKJNI.Version_iTKMinorVersion();
    }

    public static long iTKPatchVersion() {
        return SimpleITKJNI.Version_iTKPatchVersion();
    }

    public static String iTKVersionString() {
        return SimpleITKJNI.Version_iTKVersionString();
    }

    public static VectorString iTKModulesEnabled() {
        return new VectorString(SimpleITKJNI.Version_iTKModulesEnabled(), true);
    }

    public static String extendedVersionString() {
        return SimpleITKJNI.Version_extendedVersionString();
    }

    public String toString() {
        return SimpleITKJNI.Version_toString(this.swigCPtr, this);
    }

    public Version() {
        this(SimpleITKJNI.new_Version(), true);
    }
}

