/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtilsRt;
import org.jetbrains.kotlin.com.intellij.util.containers.HashingStrategy;
import org.jetbrains.kotlin.com.intellij.util.containers.RefValueHashMapUtil;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.HashCommon;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;

abstract class RefHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final MyMap myMap;
    private final ReferenceQueue<K> myReferenceQueue;
    private final HardKey myHardKeyInstance;
    @NotNull
    private final HashingStrategy<? super K> myStrategy;
    private Set<Map.Entry<K, V>> entrySet;

    RefHashMap(int initialCapacity, float loadFactor, @NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            RefHashMap.$$$reportNull$$$0(0);
        }
        this.myReferenceQueue = new ReferenceQueue();
        this.myHardKeyInstance = new HardKey();
        this.myStrategy = strategy;
        this.myMap = new MyMap(initialCapacity, loadFactor);
    }

    private RefHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, HashingStrategy.canonical());
    }

    RefHashMap(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    static <K> boolean keysEqual(K k1, K k2, @NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            RefHashMap.$$$reportNull$$$0(2);
        }
        return k1 == k2 || strategy.equals(k1, k2);
    }

    @NotNull
    protected abstract <T> Key<T> createKey(@NotNull T var1, @NotNull HashingStrategy<? super T> var2, @NotNull ReferenceQueue<? super T> var3);

    boolean processQueue() {
        Key wk;
        boolean processed = false;
        while ((wk = (Key)((Object)this.myReferenceQueue.poll())) != null) {
            this.removeKey(wk);
            processed = true;
        }
        return processed;
    }

    V removeKey(@NotNull Key<K> key) {
        if (key == null) {
            RefHashMap.$$$reportNull$$$0(3);
        }
        return this.myMap.remove(key);
    }

    @NotNull
    Key<K> createKey(@NotNull K key) {
        if (key == null) {
            RefHashMap.$$$reportNull$$$0(4);
        }
        Key<? super K> key2 = this.createKey(key, this.myStrategy, this.myReferenceQueue);
        if (key2 == null) {
            RefHashMap.$$$reportNull$$$0(5);
        }
        return key2;
    }

    V putKey(@NotNull Key<K> weakKey, V value2) {
        if (weakKey == null) {
            RefHashMap.$$$reportNull$$$0(6);
        }
        return this.myMap.put(weakKey, value2);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty() || this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(@NotNull Object key) {
        if (key == null) {
            RefHashMap.$$$reportNull$$$0(7);
        }
        this.myHardKeyInstance.set(key);
        try {
            boolean bl = this.myMap.containsKey(this.myHardKeyInstance);
            return bl;
        }
        finally {
            this.myHardKeyInstance.clear();
        }
    }

    @Override
    public boolean containsValue(Object value2) {
        throw RefValueHashMapUtil.pointlessContainsValue();
    }

    @Override
    public V get(@NotNull Object key) {
        if (key == null) {
            RefHashMap.$$$reportNull$$$0(8);
        }
        this.myHardKeyInstance.set(key);
        try {
            Object v2 = this.myMap.get(this.myHardKeyInstance);
            return v2;
        }
        finally {
            this.myHardKeyInstance.clear();
        }
    }

    @Override
    public V put(@NotNull K key, V value2) {
        if (key == null) {
            RefHashMap.$$$reportNull$$$0(9);
        }
        this.processQueue();
        return this.putKey(this.createKey(key), value2);
    }

    @Override
    public V remove(@NotNull Object key) {
        if (key == null) {
            RefHashMap.$$$reportNull$$$0(10);
        }
        this.processQueue();
        this.myHardKeyInstance.set(key);
        try {
            Object v2 = this.myMap.remove(this.myHardKeyInstance);
            return v2;
        }
        finally {
            this.myHardKeyInstance.clear();
        }
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myMap.clear();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        if (es == null) {
            this.entrySet = es = new EntrySet();
        }
        EntrySet entrySet = es;
        if (entrySet == null) {
            RefHashMap.$$$reportNull$$$0(11);
        }
        return entrySet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/RefHashMap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weakKey";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/RefHashMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createKey";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "keysEqual";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeKey";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createKey";
                break;
            }
            case 5: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putKey";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class HardKey
    implements Key<K> {
        private K myObject;
        private int myHash;

        private HardKey() {
        }

        @Override
        public K get() {
            return this.myObject;
        }

        private void set(@NotNull K object) {
            if (object == null) {
                HardKey.$$$reportNull$$$0(0);
            }
            this.myObject = object;
            this.myHash = RefHashMap.this.myStrategy.hashCode(object);
        }

        private void clear() {
            this.myObject = null;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof Key)) {
                return false;
            }
            Object t2 = this.myObject;
            Object u2 = ((Key)o2).get();
            return RefHashMap.keysEqual(t2, u2, RefHashMap.this.myStrategy);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/kotlin/com/intellij/util/containers/RefHashMap$HardKey", "set"));
        }
    }

    private class MyMap
    extends Object2ObjectOpenHashMap<Key<K>, V> {
        private MyMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor);
        }

        @Override
        protected void rehash(int newN) {
            assert (newN != 0);
            Object[] key = this.key;
            Object[] value2 = this.value;
            int mask = newN - 1;
            Key[] newKey = new Key[newN + 1];
            Object[] newValue = new Object[newN + 1];
            int keysToProcess = this.size;
            for (int i2 = this.n; i2 >= 0 && keysToProcess > 0; --i2) {
                Key k2 = (Key)key[i2];
                if (k2 == null) continue;
                --keysToProcess;
                Object referent = k2.get();
                if (referent == null) {
                    --this.size;
                    continue;
                }
                int pos = HashCommon.mix(k2.hashCode()) & mask;
                if (newKey[pos] != null) {
                    while (newKey[pos = pos + 1 & mask] != null) {
                    }
                }
                newKey[pos] = k2;
                newValue[pos] = value2[i2];
                ObjectUtilsRt.reachabilityFence(referent);
            }
            newValue[newN] = value2[this.n];
            this.n = newN;
            this.mask = mask;
            this.maxFill = HashCommon.maxFill(this.n, this.f);
            this.key = newKey;
            this.value = newValue;
        }
    }

    @FunctionalInterface
    static interface Key<T> {
        public T get();

        public int hashCode();
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<Key<K>, V>> hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = RefHashMap.this.myMap.entrySet();
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private final Iterator<Map.Entry<Key<K>, V>> hashIterator;
                private MyEntry<K, V> next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        Key wk = ent.getKey();
                        Object k2 = wk.get();
                        if (k2 == null) continue;
                        this.next = new MyEntry(ent, k2, wk.hashCode(), RefHashMap.this.myStrategy);
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    MyEntry e2 = this.next;
                    this.next = null;
                    return e2;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j2 = 0;
            Iterator i2 = this.iterator();
            while (i2.hasNext()) {
                ++j2;
                i2.next();
            }
            return j2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o2) {
            boolean toRemove;
            RefHashMap.this.processQueue();
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            Object ev = e2.getValue();
            HardKey key = RefHashMap.this.myHardKeyInstance;
            try {
                key.set(e2.getKey());
                Object hv = RefHashMap.this.myMap.get(key);
                boolean bl = hv == null ? ev == null && RefHashMap.this.myMap.containsKey(key) : (toRemove = hv.equals(ev));
                if (toRemove) {
                    RefHashMap.this.myMap.remove(key);
                }
            }
            finally {
                key.clear();
            }
            return toRemove;
        }

        @Override
        public int hashCode() {
            int h2 = 0;
            for (Map.Entry entry : this.hashEntrySet) {
                Object v2;
                Key wk = entry.getKey();
                if (wk == null) continue;
                h2 += wk.hashCode() ^ ((v2 = entry.getValue()) == null ? 0 : v2.hashCode());
            }
            return h2;
        }
    }

    private static final class MyEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<?, V> ent;
        private final K key;
        private final int myKeyHashCode;
        @NotNull
        private final HashingStrategy<? super K> myStrategy;

        private MyEntry(@NotNull Map.Entry<?, V> ent, @NotNull K key, int keyHashCode, @NotNull HashingStrategy<? super K> strategy) {
            if (ent == null) {
                MyEntry.$$$reportNull$$$0(0);
            }
            if (key == null) {
                MyEntry.$$$reportNull$$$0(1);
            }
            if (strategy == null) {
                MyEntry.$$$reportNull$$$0(2);
            }
            this.ent = ent;
            this.key = key;
            this.myKeyHashCode = keyHashCode;
            this.myStrategy = strategy;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.ent.getValue();
        }

        @Override
        public V setValue(V value2) {
            return this.ent.setValue(value2);
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return RefHashMap.keysEqual(this.key, e2.getKey(), this.myStrategy) && Objects.equals(this.getValue(), e2.getValue());
        }

        @Override
        public int hashCode() {
            V v2 = this.getValue();
            return this.myKeyHashCode ^ (v2 == null ? 0 : v2.hashCode());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "strategy";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/util/containers/RefHashMap$MyEntry";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

