/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.builtins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.org.jline.builtins.Commands;
import org.jetbrains.kotlin.org.jline.builtins.SyntaxHighlighter;
import org.jetbrains.kotlin.org.jline.keymap.BindingReader;
import org.jetbrains.kotlin.org.jline.keymap.KeyMap;
import org.jetbrains.kotlin.org.jline.reader.Editor;
import org.jetbrains.kotlin.org.jline.terminal.Attributes;
import org.jetbrains.kotlin.org.jline.terminal.MouseEvent;
import org.jetbrains.kotlin.org.jline.terminal.Size;
import org.jetbrains.kotlin.org.jline.terminal.Terminal;
import org.jetbrains.kotlin.org.jline.utils.AttributedString;
import org.jetbrains.kotlin.org.jline.utils.AttributedStringBuilder;
import org.jetbrains.kotlin.org.jline.utils.AttributedStyle;
import org.jetbrains.kotlin.org.jline.utils.Display;
import org.jetbrains.kotlin.org.jline.utils.InfoCmp;
import org.mozilla.universalchardet.UniversalDetector;

public class Nano
implements Editor {
    protected final Terminal terminal;
    protected final Display display;
    protected final BindingReader bindingReader;
    protected final Size size;
    protected final Path root;
    protected final int vsusp;
    private final List<Path> syntaxFiles;
    protected KeyMap<Operation> keys;
    public String title;
    public boolean printLineNumbers;
    public boolean wrapping;
    public boolean smoothScrolling;
    public boolean mouseSupport;
    public boolean oneMoreLine;
    public boolean constantCursor;
    public boolean quickBlank;
    public int tabs;
    public String matchBrackets;
    private boolean restricted;
    private String syntaxName;
    private boolean writeBackup;
    private boolean atBlanks;
    private boolean view;
    private boolean cut2end;
    private boolean tempFile;
    private boolean tabsToSpaces;
    private boolean autoIndent;
    protected final List<Buffer> buffers;
    protected int bufferIndex;
    protected Buffer buffer;
    protected String message;
    protected String errorMessage;
    protected int nbBindings;
    protected LinkedHashMap<String, String> shortcuts;
    protected String editMessage;
    protected final StringBuilder editBuffer;
    protected boolean searchCaseSensitive;
    protected boolean searchRegexp;
    protected boolean searchBackwards;
    protected String searchTerm;
    protected int matchedLength;
    protected PatternHistory patternHistory;
    protected WriteMode writeMode;
    protected List<String> cutbuffer;
    protected boolean mark;
    protected boolean highlight;
    private boolean searchToReplace;
    protected boolean readNewBuffer;
    private boolean nanorcIgnoreErrors;
    private final boolean windowsTerminal;

    @Override
    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    @Override
    public void open(List<String> files2) throws IOException {
        for (String file : files2) {
            String string = file = file.startsWith("~") ? file.replace("~", System.getProperty("user.home")) : file;
            if (file.contains("*") || file.contains("?")) {
                for (Path p2 : Commands.findFiles(this.root, file)) {
                    this.buffers.add(new Buffer(p2.toString()));
                }
                continue;
            }
            this.buffers.add(new Buffer(file));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int editInputBuffer(Operation operation, int curPos) {
        switch (operation.ordinal()) {
            case 16: {
                this.editBuffer.insert(curPos++, this.bindingReader.getLastBinding());
                break;
            }
            case 17: {
                if (curPos <= 0) break;
                this.editBuffer.deleteCharAt(--curPos);
                break;
            }
            case 14: {
                if (curPos <= 0) break;
                --curPos;
                break;
            }
            case 15: {
                if (curPos >= this.editBuffer.length()) break;
                ++curPos;
            }
        }
        return curPos;
    }

    boolean write() throws IOException {
        KeyMap<Operation> writeKeyMap = new KeyMap<Operation>();
        if (!this.restricted) {
            char i2;
            writeKeyMap.setUnicode(Operation.INSERT);
            for (i2 = ' '; i2 < '\u0100'; i2 = (char)(i2 + '\u0001')) {
                writeKeyMap.bind(Operation.INSERT, (CharSequence)Character.toString(i2));
            }
            for (i2 = 'A'; i2 <= 'Z'; i2 = (char)(i2 + '\u0001')) {
                writeKeyMap.bind(Operation.DO_LOWER_CASE, (CharSequence)KeyMap.alt(i2));
            }
            writeKeyMap.bind(Operation.BACKSPACE, (CharSequence)KeyMap.del());
            writeKeyMap.bind(Operation.APPEND_MODE, (CharSequence)KeyMap.alt('a'));
            writeKeyMap.bind(Operation.PREPEND_MODE, (CharSequence)KeyMap.alt('p'));
            writeKeyMap.bind(Operation.BACKUP, (CharSequence)KeyMap.alt('b'));
            writeKeyMap.bind(Operation.TO_FILES, (CharSequence)KeyMap.ctrl('T'));
        }
        writeKeyMap.bind(Operation.MAC_FORMAT, (CharSequence)KeyMap.alt('m'));
        writeKeyMap.bind(Operation.DOS_FORMAT, (CharSequence)KeyMap.alt('d'));
        writeKeyMap.bind(Operation.ACCEPT, (CharSequence)"\r");
        writeKeyMap.bind(Operation.CANCEL, (CharSequence)KeyMap.ctrl('C'));
        writeKeyMap.bind(Operation.HELP, KeyMap.ctrl('G'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f1));
        writeKeyMap.bind(Operation.MOUSE_EVENT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_mouse));
        writeKeyMap.bind(Operation.TOGGLE_SUSPENSION, (CharSequence)KeyMap.alt('z'));
        writeKeyMap.bind(Operation.RIGHT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_right));
        writeKeyMap.bind(Operation.LEFT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_left));
        this.editMessage = this.getWriteMessage();
        this.editBuffer.setLength(0);
        this.editBuffer.append(this.buffer.file == null ? "" : this.buffer.file);
        int curPos = this.editBuffer.length();
        this.shortcuts = this.writeShortcuts();
        this.display(curPos);
        while (true) {
            Operation op = this.readOperation(writeKeyMap);
            switch (op.ordinal()) {
                case 36: {
                    this.editMessage = null;
                    this.shortcuts = this.standardShortcuts();
                    return false;
                }
                case 35: {
                    this.editMessage = null;
                    if (this.save(this.editBuffer.toString())) {
                        this.shortcuts = this.standardShortcuts();
                        return true;
                    }
                    return false;
                }
                case 20: {
                    this.help("nano-write-help.txt");
                    break;
                }
                case 39: {
                    this.buffer.format = this.buffer.format == WriteFormat.MAC ? WriteFormat.UNIX : WriteFormat.MAC;
                    break;
                }
                case 40: {
                    this.buffer.format = this.buffer.format == WriteFormat.DOS ? WriteFormat.UNIX : WriteFormat.DOS;
                    break;
                }
                case 41: {
                    this.writeMode = this.writeMode == WriteMode.APPEND ? WriteMode.WRITE : WriteMode.APPEND;
                    break;
                }
                case 42: {
                    this.writeMode = this.writeMode == WriteMode.PREPEND ? WriteMode.WRITE : WriteMode.PREPEND;
                    break;
                }
                case 43: {
                    this.writeBackup = !this.writeBackup;
                    break;
                }
                case 75: {
                    this.mouseEvent();
                    break;
                }
                case 76: {
                    this.toggleSuspension();
                    break;
                }
                default: {
                    curPos = this.editInputBuffer(op, curPos);
                }
            }
            this.editMessage = this.getWriteMessage();
            this.display(curPos);
        }
    }

    private Operation readOperation(KeyMap<Operation> keymap) {
        Operation op;
        while ((op = this.bindingReader.readBinding(keymap)) == Operation.DO_LOWER_CASE) {
            this.bindingReader.runMacro(this.bindingReader.getLastBinding().toLowerCase());
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save(String name2) throws IOException {
        boolean isSame;
        Path orgPath = this.buffer.file != null ? this.root.resolve(this.buffer.file) : null;
        Path newPath = this.root.resolve(name2);
        boolean bl = isSame = orgPath != null && Files.exists(orgPath, new LinkOption[0]) && Files.exists(newPath, new LinkOption[0]) && Files.isSameFile(orgPath, newPath);
        if (!isSame && Files.exists(Paths.get(name2, new String[0]), new LinkOption[0]) && this.writeMode == WriteMode.WRITE) {
            Operation op = this.getYNC("File exists, OVERWRITE ? ");
            if (op != Operation.YES) {
                return false;
            }
        } else if (!Files.exists(newPath, new LinkOption[0])) {
            newPath.toFile().createNewFile();
        }
        Path t2 = Files.createTempFile("jline-", ".temp", new FileAttribute[0]);
        try {
            boolean bl2;
            block25: {
                OutputStream os = Files.newOutputStream(t2, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                try {
                    if (this.writeMode == WriteMode.APPEND && Files.isReadable(newPath)) {
                        Files.copy(newPath, os);
                    }
                    OutputStreamWriter w2 = new OutputStreamWriter(os, this.buffer.charset);
                    block15: for (int i2 = 0; i2 < this.buffer.lines.size(); ++i2) {
                        w2.write(this.buffer.lines.get(i2));
                        switch (this.buffer.format.ordinal()) {
                            case 0: {
                                w2.write("\n");
                                continue block15;
                            }
                            case 1: {
                                w2.write("\r\n");
                                continue block15;
                            }
                            case 2: {
                                w2.write("\r");
                            }
                        }
                    }
                    ((Writer)w2).flush();
                    if (this.writeMode == WriteMode.PREPEND && Files.isReadable(newPath)) {
                        Files.copy(newPath, os);
                    }
                    if (this.writeBackup) {
                        Files.move(newPath, newPath.resolveSibling(newPath.getFileName().toString() + "~"), StandardCopyOption.REPLACE_EXISTING);
                    }
                    Files.move(t2, newPath, StandardCopyOption.REPLACE_EXISTING);
                    if (this.writeMode == WriteMode.WRITE) {
                        this.buffer.file = name2;
                        this.buffer.dirty = false;
                    }
                    this.setMessage("Wrote " + this.buffer.lines.size() + " lines");
                    bl2 = true;
                    if (os == null) break block25;
                }
                catch (Throwable throwable) {
                    try {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e2) {
                        this.setMessage("Error writing " + name2 + ": " + e2.toString());
                        boolean bl3 = false;
                        return bl3;
                    }
                }
                os.close();
            }
            return bl2;
        }
        finally {
            Files.deleteIfExists(t2);
            this.writeMode = WriteMode.WRITE;
        }
    }

    private Operation getYNC(String message2) {
        return this.getYNC(message2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Operation getYNC(String message2, boolean andAll) {
        String oldEditMessage = this.editMessage;
        String oldEditBuffer = this.editBuffer.toString();
        LinkedHashMap<String, String> oldShortcuts = this.shortcuts;
        try {
            this.editMessage = message2;
            this.editBuffer.setLength(0);
            KeyMap<Operation> yncKeyMap = new KeyMap<Operation>();
            yncKeyMap.bind(Operation.YES, "y", "Y");
            if (andAll) {
                yncKeyMap.bind(Operation.ALL, "a", "A");
            }
            yncKeyMap.bind(Operation.NO, "n", "N");
            yncKeyMap.bind(Operation.CANCEL, (CharSequence)KeyMap.ctrl('C'));
            this.shortcuts = new LinkedHashMap();
            this.shortcuts.put(" Y", "Yes");
            if (andAll) {
                this.shortcuts.put(" A", "All");
            }
            this.shortcuts.put(" N", "No");
            this.shortcuts.put("^C", "Cancel");
            this.display();
            Operation operation = this.readOperation(yncKeyMap);
            return operation;
        }
        finally {
            this.editMessage = oldEditMessage;
            this.editBuffer.append(oldEditBuffer);
            this.shortcuts = oldShortcuts;
        }
    }

    private String getWriteMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("File Name to ");
        switch (this.writeMode.ordinal()) {
            case 0: {
                sb.append("Write");
                break;
            }
            case 1: {
                sb.append("Append");
                break;
            }
            case 2: {
                sb.append("Prepend");
            }
        }
        switch (this.buffer.format.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                sb.append(" [DOS Format]");
                break;
            }
            case 2: {
                sb.append(" [Mac Format]");
            }
        }
        if (this.writeBackup) {
            sb.append(" [Backup]");
        }
        sb.append(": ");
        return sb.toString();
    }

    void read() {
        char i2;
        KeyMap<Operation> readKeyMap = new KeyMap<Operation>();
        readKeyMap.setUnicode(Operation.INSERT);
        for (i2 = ' '; i2 < '\u0100'; i2 = (char)(i2 + '\u0001')) {
            readKeyMap.bind(Operation.INSERT, (CharSequence)Character.toString(i2));
        }
        for (i2 = 'A'; i2 <= 'Z'; i2 = (char)(i2 + '\u0001')) {
            readKeyMap.bind(Operation.DO_LOWER_CASE, (CharSequence)KeyMap.alt(i2));
        }
        readKeyMap.bind(Operation.BACKSPACE, (CharSequence)KeyMap.del());
        readKeyMap.bind(Operation.NEW_BUFFER, (CharSequence)KeyMap.alt('f'));
        readKeyMap.bind(Operation.TO_FILES, (CharSequence)KeyMap.ctrl('T'));
        readKeyMap.bind(Operation.EXECUTE, (CharSequence)KeyMap.ctrl('X'));
        readKeyMap.bind(Operation.ACCEPT, (CharSequence)"\r");
        readKeyMap.bind(Operation.CANCEL, (CharSequence)KeyMap.ctrl('C'));
        readKeyMap.bind(Operation.HELP, KeyMap.ctrl('G'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f1));
        readKeyMap.bind(Operation.MOUSE_EVENT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_mouse));
        readKeyMap.bind(Operation.RIGHT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_right));
        readKeyMap.bind(Operation.LEFT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_left));
        this.editMessage = this.getReadMessage();
        this.editBuffer.setLength(0);
        int curPos = this.editBuffer.length();
        this.shortcuts = this.readShortcuts();
        this.display(curPos);
        while (true) {
            Operation op = this.readOperation(readKeyMap);
            switch (op.ordinal()) {
                case 36: {
                    this.editMessage = null;
                    this.shortcuts = this.standardShortcuts();
                    return;
                }
                case 35: {
                    Path p2;
                    this.editMessage = null;
                    String file = this.editBuffer.toString();
                    boolean empty = file.isEmpty();
                    Path path = p2 = empty ? null : this.root.resolve(file);
                    if (!(this.readNewBuffer || empty || Files.exists(p2, new LinkOption[0]))) {
                        this.setMessage("\"" + file + "\" not found");
                    } else if (!empty && Files.isDirectory(p2, new LinkOption[0])) {
                        this.setMessage("\"" + file + "\" is a directory");
                    } else if (!empty && !Files.isRegularFile(p2, new LinkOption[0])) {
                        this.setMessage("\"" + file + "\" is not a regular file");
                    } else {
                        Buffer buf = new Buffer(empty ? null : file);
                        try {
                            buf.open();
                            if (this.readNewBuffer) {
                                this.buffers.add(++this.bufferIndex, buf);
                                this.buffer = buf;
                            } else {
                                this.buffer.insert(String.join((CharSequence)"\n", buf.lines));
                            }
                            this.setMessage(null);
                        }
                        catch (IOException e2) {
                            this.setMessage("Error reading " + file + ": " + e2.getMessage());
                        }
                    }
                    this.shortcuts = this.standardShortcuts();
                    return;
                }
                case 20: {
                    this.help("nano-read-help.txt");
                    break;
                }
                case 48: {
                    this.readNewBuffer = !this.readNewBuffer;
                    break;
                }
                case 75: {
                    this.mouseEvent();
                    break;
                }
                default: {
                    curPos = this.editInputBuffer(op, curPos);
                }
            }
            this.editMessage = this.getReadMessage();
            this.display(curPos);
        }
    }

    private String getReadMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("File to insert");
        if (this.readNewBuffer) {
            sb.append(" into new buffer");
        }
        sb.append(" [from ./]: ");
        return sb.toString();
    }

    void gotoLine() throws IOException {
        KeyMap<Operation> readKeyMap = new KeyMap<Operation>();
        readKeyMap.setUnicode(Operation.INSERT);
        for (char i2 = ' '; i2 < '\u0100'; i2 = (char)(i2 + '\u0001')) {
            readKeyMap.bind(Operation.INSERT, (CharSequence)Character.toString(i2));
        }
        readKeyMap.bind(Operation.BACKSPACE, (CharSequence)KeyMap.del());
        readKeyMap.bind(Operation.ACCEPT, (CharSequence)"\r");
        readKeyMap.bind(Operation.HELP, KeyMap.ctrl('G'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f1));
        readKeyMap.bind(Operation.CANCEL, (CharSequence)KeyMap.ctrl('C'));
        readKeyMap.bind(Operation.RIGHT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_right));
        readKeyMap.bind(Operation.LEFT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_left));
        readKeyMap.bind(Operation.FIRST_LINE, (CharSequence)KeyMap.ctrl('Y'));
        readKeyMap.bind(Operation.LAST_LINE, (CharSequence)KeyMap.ctrl('V'));
        readKeyMap.bind(Operation.SEARCH, (CharSequence)KeyMap.ctrl('T'));
        this.editMessage = "Enter line number, column number: ";
        this.editBuffer.setLength(0);
        int curPos = this.editBuffer.length();
        this.shortcuts = this.gotoShortcuts();
        this.display(curPos);
        while (true) {
            Operation op = this.readOperation(readKeyMap);
            switch (op.ordinal()) {
                case 36: {
                    this.editMessage = null;
                    this.shortcuts = this.standardShortcuts();
                    return;
                }
                case 29: {
                    this.editMessage = null;
                    this.buffer.firstLine();
                    this.shortcuts = this.standardShortcuts();
                    return;
                }
                case 30: {
                    this.editMessage = null;
                    this.buffer.lastLine();
                    this.shortcuts = this.standardShortcuts();
                    return;
                }
                case 37: {
                    this.searchToReplace = false;
                    this.searchAndReplace();
                    return;
                }
                case 35: {
                    this.editMessage = null;
                    String[] pos = this.editBuffer.toString().split(",", 2);
                    int[] args = new int[]{0, 0};
                    try {
                        for (int i3 = 0; i3 < pos.length; ++i3) {
                            if (pos[i3].trim().length() <= 0) continue;
                            args[i3] = Integer.parseInt(pos[i3]) - 1;
                            if (args[i3] >= 0) continue;
                            throw new NumberFormatException();
                        }
                        this.buffer.gotoLine(args[1], args[0]);
                    }
                    catch (NumberFormatException ex) {
                        this.setMessage("Invalid line or column number");
                    }
                    catch (Exception ex) {
                        this.setMessage("Internal error: " + ex.getMessage());
                    }
                    this.shortcuts = this.standardShortcuts();
                    return;
                }
                case 20: {
                    this.help("nano-goto-help.txt");
                    break;
                }
                default: {
                    curPos = this.editInputBuffer(op, curPos);
                }
            }
            this.display(curPos);
        }
    }

    private LinkedHashMap<String, String> gotoShortcuts() {
        LinkedHashMap<String, String> shortcuts = new LinkedHashMap<String, String>();
        shortcuts.put("^G", "Get Help");
        shortcuts.put("^Y", "First Line");
        shortcuts.put("^T", "Go To Text");
        shortcuts.put("^C", "Cancel");
        shortcuts.put("^V", "Last Line");
        return shortcuts;
    }

    private LinkedHashMap<String, String> readShortcuts() {
        LinkedHashMap<String, String> shortcuts = new LinkedHashMap<String, String>();
        shortcuts.put("^G", "Get Help");
        shortcuts.put("^T", "To Files");
        shortcuts.put("M-F", "New Buffer");
        shortcuts.put("^C", "Cancel");
        shortcuts.put("^X", "Execute Command");
        return shortcuts;
    }

    private LinkedHashMap<String, String> writeShortcuts() {
        LinkedHashMap<String, String> s2 = new LinkedHashMap<String, String>();
        s2.put("^G", "Get Help");
        s2.put("M-M", "Mac Format");
        s2.put("^C", "Cancel");
        s2.put("M-D", "DOS Format");
        if (!this.restricted) {
            s2.put("^T", "To Files");
            s2.put("M-P", "Prepend");
            s2.put("M-A", "Append");
            s2.put("M-B", "Backup File");
        }
        return s2;
    }

    private LinkedHashMap<String, String> helpShortcuts() {
        LinkedHashMap<String, String> s2 = new LinkedHashMap<String, String>();
        s2.put("^L", "Refresh");
        s2.put("^Y", "Prev Page");
        s2.put("^P", "Prev Line");
        s2.put("M-\\", "First Line");
        s2.put("^X", "Exit");
        s2.put("^V", "Next Page");
        s2.put("^N", "Next Line");
        s2.put("M-/", "Last Line");
        return s2;
    }

    private LinkedHashMap<String, String> searchShortcuts() {
        LinkedHashMap<String, String> s2 = new LinkedHashMap<String, String>();
        s2.put("^G", "Get Help");
        s2.put("^Y", "First Line");
        if (this.searchToReplace) {
            s2.put("^R", "No Replace");
        } else {
            s2.put("^R", "Replace");
            s2.put("^W", "Beg of Par");
        }
        s2.put("M-C", "Case Sens");
        s2.put("M-R", "Regexp");
        s2.put("^C", "Cancel");
        s2.put("^V", "Last Line");
        s2.put("^T", "Go To Line");
        if (!this.searchToReplace) {
            s2.put("^O", "End of Par");
        }
        s2.put("M-B", "Backwards");
        s2.put("^P", "PrevHstory");
        return s2;
    }

    private LinkedHashMap<String, String> replaceShortcuts() {
        LinkedHashMap<String, String> s2 = new LinkedHashMap<String, String>();
        s2.put("^G", "Get Help");
        s2.put("^Y", "First Line");
        s2.put("^P", "PrevHstory");
        s2.put("^C", "Cancel");
        s2.put("^V", "Last Line");
        s2.put("^N", "NextHstory");
        return s2;
    }

    private LinkedHashMap<String, String> standardShortcuts() {
        LinkedHashMap<String, String> s2 = new LinkedHashMap<String, String>();
        s2.put("^G", "Get Help");
        if (!this.view) {
            s2.put("^O", "WriteOut");
        }
        s2.put("^R", "Read File");
        s2.put("^Y", "Prev Page");
        if (!this.view) {
            s2.put("^K", "Cut Text");
        }
        s2.put("^C", "Cur Pos");
        s2.put("^X", "Exit");
        if (!this.view) {
            s2.put("^J", "Justify");
        }
        s2.put("^W", "Where Is");
        s2.put("^V", "Next Page");
        if (!this.view) {
            s2.put("^U", "UnCut Text");
        }
        s2.put("^T", "To Spell");
        return s2;
    }

    void help(String help) {
        Buffer org = this.buffer;
        Buffer newBuf = new Buffer(null);
        try (InputStream is = this.getClass().getResourceAsStream(help);){
            newBuf.open(is);
        }
        catch (IOException e2) {
            this.setMessage("Unable to read help");
            return;
        }
        LinkedHashMap<String, String> oldShortcuts = this.shortcuts;
        this.shortcuts = this.helpShortcuts();
        boolean oldWrapping = this.wrapping;
        boolean oldPrintLineNumbers = this.printLineNumbers;
        boolean oldConstantCursor = this.constantCursor;
        boolean oldAtBlanks = this.atBlanks;
        boolean oldHighlight = this.highlight;
        String oldEditMessage = this.editMessage;
        this.editMessage = "";
        this.wrapping = true;
        this.atBlanks = true;
        this.printLineNumbers = false;
        this.constantCursor = false;
        this.highlight = false;
        this.buffer = newBuf;
        if (!oldWrapping) {
            this.buffer.computeAllOffsets();
        }
        try {
            this.message = null;
            this.terminal.puts(InfoCmp.Capability.cursor_invisible, new Object[0]);
            this.display();
            while (true) {
                switch (this.readOperation(this.keys).ordinal()) {
                    case 1: {
                        return;
                    }
                    case 29: {
                        this.buffer.firstLine();
                        break;
                    }
                    case 30: {
                        this.buffer.lastLine();
                        break;
                    }
                    case 22: {
                        this.buffer.prevPage();
                        break;
                    }
                    case 21: {
                        this.buffer.nextPage();
                        break;
                    }
                    case 12: {
                        this.buffer.scrollUp(1);
                        break;
                    }
                    case 13: {
                        this.buffer.scrollDown(1);
                        break;
                    }
                    case 11: {
                        this.clearScreen();
                        break;
                    }
                    case 75: {
                        this.mouseEvent();
                        break;
                    }
                    case 76: {
                        this.toggleSuspension();
                    }
                }
                this.display();
            }
        }
        finally {
            this.buffer = org;
            this.wrapping = oldWrapping;
            this.printLineNumbers = oldPrintLineNumbers;
            this.constantCursor = oldConstantCursor;
            this.shortcuts = oldShortcuts;
            this.atBlanks = oldAtBlanks;
            this.highlight = oldHighlight;
            this.editMessage = oldEditMessage;
            this.terminal.puts(InfoCmp.Capability.cursor_visible, new Object[0]);
            if (!oldWrapping) {
                this.buffer.computeAllOffsets();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void searchAndReplace() {
        try {
            this.search();
            if (!this.searchToReplace) {
                return;
            }
            String replaceTerm = this.replace();
            int replaced = 0;
            boolean all = false;
            boolean found = true;
            ArrayList<Integer> matches = new ArrayList<Integer>();
            Operation op = Operation.NO;
            block11: while (found) {
                found = this.buffer.nextSearch();
                if (found) {
                    int col;
                    int[] re = this.buffer.highlightStart();
                    int match = re[0] * 10000 + (col = this.searchBackwards ? this.buffer.length(this.buffer.getLine(re[0])) - re[1] : re[1]);
                    if (matches.contains(match)) break;
                    matches.add(match);
                    if (!all) {
                        op = this.getYNC("Replace this instance? ", true);
                    }
                } else {
                    op = Operation.NO;
                }
                switch (op.ordinal()) {
                    case 47: {
                        all = true;
                        this.buffer.replaceFromCursor(this.matchedLength, replaceTerm);
                        ++replaced;
                        continue block11;
                    }
                    case 45: {
                        this.buffer.replaceFromCursor(this.matchedLength, replaceTerm);
                        ++replaced;
                        continue block11;
                    }
                    case 46: {
                        continue block11;
                    }
                    case 36: {
                        found = false;
                        continue block11;
                    }
                }
            }
            this.message = "Replaced " + replaced + " occurrences";
        }
        catch (Exception exception) {
        }
        finally {
            this.searchToReplace = false;
            this.matchedLength = -1;
            this.shortcuts = this.standardShortcuts();
            this.editMessage = null;
        }
    }

    void search() throws IOException {
        char i2;
        KeyMap<Operation> searchKeyMap = new KeyMap<Operation>();
        searchKeyMap.setUnicode(Operation.INSERT);
        for (i2 = ' '; i2 < '\u0100'; i2 = (char)(i2 + '\u0001')) {
            searchKeyMap.bind(Operation.INSERT, (CharSequence)Character.toString(i2));
        }
        for (i2 = 'A'; i2 <= 'Z'; i2 = (char)(i2 + '\u0001')) {
            searchKeyMap.bind(Operation.DO_LOWER_CASE, (CharSequence)KeyMap.alt(i2));
        }
        searchKeyMap.bind(Operation.BACKSPACE, (CharSequence)KeyMap.del());
        searchKeyMap.bind(Operation.CASE_SENSITIVE, (CharSequence)KeyMap.alt('c'));
        searchKeyMap.bind(Operation.BACKWARDS, (CharSequence)KeyMap.alt('b'));
        searchKeyMap.bind(Operation.REGEXP, (CharSequence)KeyMap.alt('r'));
        searchKeyMap.bind(Operation.ACCEPT, (CharSequence)"\r");
        searchKeyMap.bind(Operation.CANCEL, (CharSequence)KeyMap.ctrl('C'));
        searchKeyMap.bind(Operation.HELP, KeyMap.ctrl('G'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f1));
        searchKeyMap.bind(Operation.FIRST_LINE, (CharSequence)KeyMap.ctrl('Y'));
        searchKeyMap.bind(Operation.LAST_LINE, (CharSequence)KeyMap.ctrl('V'));
        searchKeyMap.bind(Operation.MOUSE_EVENT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_mouse));
        searchKeyMap.bind(Operation.RIGHT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_right));
        searchKeyMap.bind(Operation.LEFT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_left));
        searchKeyMap.bind(Operation.UP, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_up));
        searchKeyMap.bind(Operation.DOWN, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_down));
        searchKeyMap.bind(Operation.TOGGLE_REPLACE, (CharSequence)KeyMap.ctrl('R'));
        this.editMessage = this.getSearchMessage();
        this.editBuffer.setLength(0);
        String currentBuffer = this.editBuffer.toString();
        int curPos = this.editBuffer.length();
        this.shortcuts = this.searchShortcuts();
        this.display(curPos);
        try {
            while (true) {
                Operation op = this.readOperation(searchKeyMap);
                switch (op.ordinal()) {
                    case 12: {
                        this.editBuffer.setLength(0);
                        this.editBuffer.append(this.patternHistory.up(currentBuffer));
                        curPos = this.editBuffer.length();
                        break;
                    }
                    case 13: {
                        this.editBuffer.setLength(0);
                        this.editBuffer.append(this.patternHistory.down(currentBuffer));
                        curPos = this.editBuffer.length();
                        break;
                    }
                    case 32: {
                        this.searchCaseSensitive = !this.searchCaseSensitive;
                        break;
                    }
                    case 33: {
                        this.searchBackwards = !this.searchBackwards;
                        break;
                    }
                    case 34: {
                        this.searchRegexp = !this.searchRegexp;
                        break;
                    }
                    case 36: {
                        throw new IllegalArgumentException();
                    }
                    case 35: {
                        if (this.editBuffer.length() > 0) {
                            this.searchTerm = this.editBuffer.toString();
                        }
                        if (this.searchTerm == null || this.searchTerm.isEmpty()) {
                            this.setMessage("Cancelled");
                            throw new IllegalArgumentException();
                        }
                        this.patternHistory.add(this.searchTerm);
                        if (!this.searchToReplace) {
                            this.buffer.nextSearch();
                        }
                        return;
                    }
                    case 20: {
                        if (this.searchToReplace) {
                            this.help("nano-search-replace-help.txt");
                            break;
                        }
                        this.help("nano-search-help.txt");
                        break;
                    }
                    case 29: {
                        this.buffer.firstLine();
                        break;
                    }
                    case 30: {
                        this.buffer.lastLine();
                        break;
                    }
                    case 75: {
                        this.mouseEvent();
                        break;
                    }
                    case 38: {
                        this.searchToReplace = !this.searchToReplace;
                        this.shortcuts = this.searchShortcuts();
                        break;
                    }
                    default: {
                        curPos = this.editInputBuffer(op, curPos);
                        currentBuffer = this.editBuffer.toString();
                    }
                }
                this.editMessage = this.getSearchMessage();
                this.display(curPos);
            }
        }
        finally {
            this.shortcuts = this.standardShortcuts();
            this.editMessage = null;
        }
    }

    String replace() throws IOException {
        char i2;
        KeyMap<Operation> keyMap = new KeyMap<Operation>();
        keyMap.setUnicode(Operation.INSERT);
        for (i2 = ' '; i2 < '\u0100'; i2 = (char)(i2 + '\u0001')) {
            keyMap.bind(Operation.INSERT, (CharSequence)Character.toString(i2));
        }
        for (i2 = 'A'; i2 <= 'Z'; i2 = (char)(i2 + '\u0001')) {
            keyMap.bind(Operation.DO_LOWER_CASE, (CharSequence)KeyMap.alt(i2));
        }
        keyMap.bind(Operation.BACKSPACE, (CharSequence)KeyMap.del());
        keyMap.bind(Operation.ACCEPT, (CharSequence)"\r");
        keyMap.bind(Operation.CANCEL, (CharSequence)KeyMap.ctrl('C'));
        keyMap.bind(Operation.HELP, KeyMap.ctrl('G'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f1));
        keyMap.bind(Operation.FIRST_LINE, (CharSequence)KeyMap.ctrl('Y'));
        keyMap.bind(Operation.LAST_LINE, (CharSequence)KeyMap.ctrl('V'));
        keyMap.bind(Operation.RIGHT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_right));
        keyMap.bind(Operation.LEFT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_left));
        keyMap.bind(Operation.UP, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_up));
        keyMap.bind(Operation.DOWN, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_down));
        this.editMessage = "Replace with: ";
        this.editBuffer.setLength(0);
        String currentBuffer = this.editBuffer.toString();
        int curPos = this.editBuffer.length();
        this.shortcuts = this.replaceShortcuts();
        this.display(curPos);
        try {
            while (true) {
                Operation op = this.readOperation(keyMap);
                switch (op.ordinal()) {
                    case 12: {
                        this.editBuffer.setLength(0);
                        this.editBuffer.append(this.patternHistory.up(currentBuffer));
                        curPos = this.editBuffer.length();
                        break;
                    }
                    case 13: {
                        this.editBuffer.setLength(0);
                        this.editBuffer.append(this.patternHistory.down(currentBuffer));
                        curPos = this.editBuffer.length();
                        break;
                    }
                    case 36: {
                        throw new IllegalArgumentException();
                    }
                    case 35: {
                        String replaceTerm = "";
                        if (this.editBuffer.length() > 0) {
                            replaceTerm = this.editBuffer.toString();
                        }
                        if (replaceTerm == null) {
                            this.setMessage("Cancelled");
                            throw new IllegalArgumentException();
                        }
                        this.patternHistory.add(replaceTerm);
                        String string = replaceTerm;
                        return string;
                    }
                    case 20: {
                        this.help("nano-replace-help.txt");
                        break;
                    }
                    case 29: {
                        this.buffer.firstLine();
                        break;
                    }
                    case 30: {
                        this.buffer.lastLine();
                        break;
                    }
                    case 75: {
                        this.mouseEvent();
                        break;
                    }
                    default: {
                        curPos = this.editInputBuffer(op, curPos);
                        currentBuffer = this.editBuffer.toString();
                    }
                }
                this.display(curPos);
            }
        }
        finally {
            this.shortcuts = this.standardShortcuts();
            this.editMessage = null;
        }
    }

    private String getSearchMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Search");
        if (this.searchToReplace) {
            sb.append(" (to replace)");
        }
        if (this.searchCaseSensitive) {
            sb.append(" [Case Sensitive]");
        }
        if (this.searchRegexp) {
            sb.append(" [Regexp]");
        }
        if (this.searchBackwards) {
            sb.append(" [Backwards]");
        }
        if (this.searchTerm != null) {
            sb.append(" [");
            sb.append(this.searchTerm);
            sb.append("]");
        }
        sb.append(": ");
        return sb.toString();
    }

    String computeCurPos() {
        int chari = 0;
        int chart = 0;
        for (int i2 = 0; i2 < this.buffer.lines.size(); ++i2) {
            int l2 = this.buffer.lines.get(i2).length() + 1;
            if (i2 < this.buffer.line) {
                chari += l2;
            } else if (i2 == this.buffer.line) {
                chari += this.buffer.offsetInLine + this.buffer.column;
            }
            chart += l2;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("line ");
        sb.append(this.buffer.line + 1);
        sb.append("/");
        sb.append(this.buffer.lines.size());
        sb.append(" (");
        sb.append(Math.round(100.0 * (double)this.buffer.line / (double)this.buffer.lines.size()));
        sb.append("%), ");
        sb.append("col ");
        sb.append(this.buffer.offsetInLine + this.buffer.column + 1);
        sb.append("/");
        sb.append(this.buffer.length(this.buffer.lines.get(this.buffer.line)) + 1);
        sb.append(" (");
        if (this.buffer.lines.get(this.buffer.line).length() > 0) {
            sb.append(Math.round(100.0 * (double)(this.buffer.offsetInLine + this.buffer.column) / (double)this.buffer.length(this.buffer.lines.get(this.buffer.line))));
        } else {
            sb.append("100");
        }
        sb.append("%), ");
        sb.append("char ");
        sb.append(chari + 1);
        sb.append("/");
        sb.append(chart);
        sb.append(" (");
        sb.append(Math.round(100.0 * (double)chari / (double)chart));
        sb.append("%)");
        return sb.toString();
    }

    void curPos() {
        this.setMessage(this.computeCurPos());
    }

    void prevBuffer() throws IOException {
        if (this.buffers.size() > 1) {
            this.bufferIndex = (this.bufferIndex + this.buffers.size() - 1) % this.buffers.size();
            this.buffer = this.buffers.get(this.bufferIndex);
            this.setMessage("Switched to " + this.buffer.getTitle());
            this.buffer.open();
            this.display.clear();
        } else {
            this.setMessage("No more open file buffers");
        }
    }

    void nextBuffer() throws IOException {
        if (this.buffers.size() > 1) {
            this.bufferIndex = (this.bufferIndex + 1) % this.buffers.size();
            this.buffer = this.buffers.get(this.bufferIndex);
            this.setMessage("Switched to " + this.buffer.getTitle());
            this.buffer.open();
            this.display.clear();
        } else {
            this.setMessage("No more open file buffers");
        }
    }

    void setMessage(String message2) {
        this.message = message2;
        this.nbBindings = this.quickBlank ? 2 : 25;
    }

    boolean quit() throws IOException {
        if (this.buffer.dirty) {
            if (this.tempFile) {
                if (!this.write()) {
                    return false;
                }
            } else {
                Operation op = this.getYNC("Save modified buffer (ANSWERING \"No\" WILL DESTROY CHANGES) ? ");
                switch (op.ordinal()) {
                    case 36: {
                        return false;
                    }
                    case 46: {
                        break;
                    }
                    case 45: {
                        if (this.write()) break;
                        return false;
                    }
                }
            }
        }
        this.buffers.remove(this.bufferIndex);
        if (this.bufferIndex == this.buffers.size() && this.bufferIndex > 0) {
            this.bufferIndex = this.buffers.size() - 1;
        }
        if (this.buffers.isEmpty()) {
            this.buffer = null;
            return true;
        }
        this.buffer = this.buffers.get(this.bufferIndex);
        this.buffer.open();
        this.display.clear();
        this.setMessage("Switched to " + this.buffer.getTitle());
        return false;
    }

    void numbers() {
        this.printLineNumbers = !this.printLineNumbers;
        this.resetDisplay();
        this.setMessage("Lines numbering " + (this.printLineNumbers ? "enabled" : "disabled"));
    }

    void smoothScrolling() {
        this.smoothScrolling = !this.smoothScrolling;
        this.setMessage("Smooth scrolling " + (this.smoothScrolling ? "enabled" : "disabled"));
    }

    void mouseSupport() throws IOException {
        this.mouseSupport = !this.mouseSupport;
        this.setMessage("Mouse support " + (this.mouseSupport ? "enabled" : "disabled"));
        this.terminal.trackMouse(this.mouseSupport ? Terminal.MouseTracking.Normal : Terminal.MouseTracking.Off);
    }

    void constantCursor() {
        this.constantCursor = !this.constantCursor;
        this.setMessage("Constant cursor position display " + (this.constantCursor ? "enabled" : "disabled"));
    }

    void oneMoreLine() {
        this.oneMoreLine = !this.oneMoreLine;
        this.setMessage("Use of one more line for editing " + (this.oneMoreLine ? "enabled" : "disabled"));
    }

    void wrap() {
        this.wrapping = !this.wrapping;
        this.buffer.computeAllOffsets();
        this.resetDisplay();
        this.setMessage("Lines wrapping " + (this.wrapping ? "enabled" : "disabled"));
    }

    void clearScreen() {
        this.resetDisplay();
    }

    void mouseEvent() {
        MouseEvent event = this.terminal.readMouseEvent();
        if (event.getModifiers().isEmpty() && event.getType() == MouseEvent.Type.Released && event.getButton() == MouseEvent.Button.Button1) {
            int x2 = event.getX();
            int y2 = event.getY();
            int hdr = this.buffer.computeHeader().size();
            int ftr = this.computeFooter().size();
            if (y2 >= hdr) {
                if (y2 < this.size.getRows() - ftr) {
                    this.buffer.moveTo(x2, y2 - hdr);
                } else {
                    int cols = (this.shortcuts.size() + 1) / 2;
                    int cw = this.size.getColumns() / cols;
                    int l2 = y2 - (this.size.getRows() - ftr) - 1;
                    int si = l2 * cols + x2 / cw;
                    String shortcut = null;
                    Iterator<String> it = this.shortcuts.keySet().iterator();
                    while (si-- >= 0 && it.hasNext()) {
                        shortcut = it.next();
                    }
                    if (shortcut != null) {
                        shortcut = shortcut.replaceAll("M-", "\\\\E");
                        String seq = KeyMap.translate(shortcut);
                        this.bindingReader.runMacro(seq);
                    }
                }
            }
        } else if (event.getType() == MouseEvent.Type.Wheel) {
            if (event.getButton() == MouseEvent.Button.WheelDown) {
                this.buffer.moveDown(1);
            } else if (event.getButton() == MouseEvent.Button.WheelUp) {
                this.buffer.moveUp(1);
            }
        }
    }

    void toggleSuspension() {
        if (this.restricted) {
            this.setMessage("This function is disabled in restricted mode");
        } else if (this.vsusp < 0) {
            this.setMessage("This function is disabled");
        } else {
            Attributes attrs = this.terminal.getAttributes();
            int toggle = this.vsusp;
            String message2 = "enabled";
            if (attrs.getControlChar(Attributes.ControlChar.VSUSP) > 0) {
                toggle = 0;
                message2 = "disabled";
            }
            attrs.setControlChar(Attributes.ControlChar.VSUSP, toggle);
            this.terminal.setAttributes(attrs);
            this.setMessage("Suspension " + message2);
        }
    }

    public String getTitle() {
        return this.title;
    }

    void resetDisplay() {
        this.display.clear();
        this.display.resize(this.size.getRows(), this.size.getColumns());
        for (Buffer buffer : this.buffers) {
            buffer.resetDisplay();
        }
    }

    synchronized void display() {
        this.display(null);
    }

    synchronized void display(Integer editCursor) {
        int cursor;
        if (this.nbBindings > 0 && --this.nbBindings == 0) {
            this.message = null;
        }
        List<AttributedString> header = this.buffer.computeHeader();
        List<AttributedString> footer = this.computeFooter();
        int nbLines = this.size.getRows() - header.size() - footer.size();
        List<AttributedString> newLines = this.buffer.getDisplayedLines(nbLines);
        newLines.addAll(0, header);
        newLines.addAll(footer);
        if (this.editMessage != null) {
            int crsr = editCursor != null ? editCursor.intValue() : this.editBuffer.length();
            cursor = this.editMessage.length() + crsr;
            cursor = this.size.cursorPos(this.size.getRows() - footer.size(), cursor);
        } else {
            cursor = this.size.cursorPos(header.size(), this.buffer.getDisplayedCursor());
        }
        this.display.update(newLines, cursor);
        if (this.windowsTerminal) {
            this.resetDisplay();
        }
    }

    protected List<AttributedString> computeFooter() {
        ArrayList<AttributedString> footer = new ArrayList<AttributedString>();
        if (this.editMessage != null) {
            AttributedStringBuilder sb = new AttributedStringBuilder();
            sb.style(AttributedStyle.INVERSE);
            sb.append(this.editMessage);
            sb.append(this.editBuffer);
            for (int i2 = this.editMessage.length() + this.editBuffer.length(); i2 < this.size.getColumns(); ++i2) {
                sb.append(' ');
            }
            sb.append('\n');
            footer.add(sb.toAttributedString());
        } else if (this.message != null || this.constantCursor) {
            int rwidth = this.size.getColumns();
            String text = "[ " + (this.message == null ? this.computeCurPos() : this.message) + " ]";
            int len = text.length();
            AttributedStringBuilder sb = new AttributedStringBuilder();
            for (int i3 = 0; i3 < (rwidth - len) / 2; ++i3) {
                sb.append(' ');
            }
            sb.style(AttributedStyle.INVERSE);
            sb.append(text);
            sb.append('\n');
            footer.add(sb.toAttributedString());
        } else {
            footer.add(new AttributedString("\n"));
        }
        Iterator<Map.Entry<String, String>> sit = this.shortcuts.entrySet().iterator();
        int cols = (this.shortcuts.size() + 1) / 2;
        int cw = (this.size.getColumns() - 1) / cols;
        int rem = (this.size.getColumns() - 1) % cols;
        for (int l2 = 0; l2 < 2; ++l2) {
            AttributedStringBuilder sb = new AttributedStringBuilder();
            for (int c2 = 0; c2 < cols; ++c2) {
                Map.Entry<String, String> entry = sit.hasNext() ? sit.next() : null;
                String key = entry != null ? entry.getKey() : "";
                String val = entry != null ? entry.getValue() : "";
                sb.style(AttributedStyle.INVERSE);
                sb.append(key);
                sb.style(AttributedStyle.DEFAULT);
                sb.append(" ");
                int nb = cw - key.length() - 1 + (c2 < rem ? 1 : 0);
                if (val.length() > nb) {
                    sb.append(val.substring(0, nb));
                    continue;
                }
                sb.append(val);
                if (c2 >= cols - 1) continue;
                for (int i4 = 0; i4 < nb - val.length(); ++i4) {
                    sb.append(" ");
                }
            }
            sb.append('\n');
            footer.add(sb.toAttributedString());
        }
        return footer;
    }

    protected void handle(Terminal.Signal signal) {
        if (this.buffer != null) {
            this.size.copy(this.terminal.getSize());
            this.buffer.computeAllOffsets();
            this.buffer.moveToChar(this.buffer.offsetInLine + this.buffer.column);
            this.resetDisplay();
            this.display();
        }
    }

    protected static class PatternHistory {
        private final Path historyFile;
        private List<String> patterns;
        private int patternId;
        private boolean lastMoveUp;

        public String up(String hint) {
            String out = hint;
            if (this.patterns.size() > 0 && this.patternId < this.patterns.size()) {
                if (!this.lastMoveUp && this.patternId > 0 && this.patternId < this.patterns.size() - 1) {
                    ++this.patternId;
                }
                if (this.patternId < 0) {
                    this.patternId = 0;
                }
                boolean found = false;
                for (int pid = this.patternId; pid < this.patterns.size(); ++pid) {
                    if (hint.length() != 0 && !this.patterns.get(pid).startsWith(hint)) continue;
                    this.patternId = pid + 1;
                    out = this.patterns.get(pid);
                    found = true;
                    break;
                }
                if (!found) {
                    this.patternId = this.patterns.size();
                }
            }
            this.lastMoveUp = true;
            return out;
        }

        public String down(String hint) {
            String out = hint;
            if (this.patterns.size() > 0) {
                if (this.lastMoveUp) {
                    --this.patternId;
                }
                if (this.patternId < 0) {
                    this.patternId = -1;
                } else {
                    boolean found = false;
                    for (int pid = this.patternId; pid >= 0; --pid) {
                        if (hint.length() != 0 && !this.patterns.get(pid).startsWith(hint)) continue;
                        this.patternId = pid - 1;
                        out = this.patterns.get(pid);
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.patternId = -1;
                    }
                }
            }
            this.lastMoveUp = false;
            return out;
        }

        public void add(String pattern) {
            if (pattern.trim().length() == 0) {
                return;
            }
            this.patterns.remove(pattern);
            if (this.patterns.size() > 100) {
                this.patterns.remove(this.patterns.size() - 1);
            }
            this.patterns.add(0, pattern);
            this.patternId = -1;
        }

        public void persist() {
            if (this.historyFile == null) {
                return;
            }
            try (BufferedWriter writer = Files.newBufferedWriter(this.historyFile.toAbsolutePath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
                for (String s2 : this.patterns) {
                    if (s2.trim().length() <= 0) continue;
                    writer.append(s2);
                    writer.newLine();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static enum WriteMode {
        WRITE,
        APPEND,
        PREPEND;

    }

    protected class Buffer {
        String file;
        Charset charset;
        WriteFormat format = WriteFormat.UNIX;
        List<String> lines;
        int firstLineToDisplay;
        int firstColumnToDisplay = 0;
        int offsetInLineToDisplay;
        int line;
        List<LinkedList<Integer>> offsets = new ArrayList<LinkedList<Integer>>();
        int offsetInLine;
        int column;
        int wantedColumn;
        boolean uncut = false;
        int[] markPos = new int[]{-1, -1};
        SyntaxHighlighter syntaxHighlighter;
        boolean dirty;

        protected Buffer(String file) {
            this.file = file;
            this.syntaxHighlighter = SyntaxHighlighter.build(Nano.this.syntaxFiles, file, Nano.this.syntaxName, Nano.this.nanorcIgnoreErrors);
        }

        void open() throws IOException {
            if (this.lines != null) {
                return;
            }
            this.lines = new ArrayList<String>();
            this.lines.add("");
            this.charset = Charset.defaultCharset();
            this.computeAllOffsets();
            if (this.file == null) {
                return;
            }
            Path path = Nano.this.root.resolve(this.file);
            if (Files.isDirectory(path, new LinkOption[0])) {
                Nano.this.setMessage("\"" + this.file + "\" is a directory");
                return;
            }
            try (InputStream fis = Files.newInputStream(path, new OpenOption[0]);){
                this.read(fis);
            }
            catch (IOException e2) {
                Nano.this.setMessage("Error reading " + this.file + ": " + e2.getMessage());
            }
        }

        void open(InputStream is) throws IOException {
            if (this.lines != null) {
                return;
            }
            this.lines = new ArrayList<String>();
            this.lines.add("");
            this.charset = Charset.defaultCharset();
            this.computeAllOffsets();
            this.read(is);
        }

        void read(InputStream fis) throws IOException {
            int remaining;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((remaining = fis.read(buffer)) > 0) {
                bos.write(buffer, 0, remaining);
            }
            byte[] bytes = bos.toByteArray();
            try {
                UniversalDetector detector = new UniversalDetector(null);
                detector.handleData(bytes, 0, bytes.length);
                detector.dataEnd();
                if (detector.getDetectedCharset() != null) {
                    this.charset = Charset.forName(detector.getDetectedCharset());
                }
            }
            catch (Throwable detector) {
                // empty catch block
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), this.charset));){
                String line;
                this.lines.clear();
                while ((line = reader.readLine()) != null) {
                    this.lines.add(line);
                }
            }
            if (this.lines.isEmpty()) {
                this.lines.add("");
            }
            this.computeAllOffsets();
            this.moveToChar(0);
        }

        private int charPosition(int displayPosition) {
            return this.charPosition(this.line, displayPosition, CursorMovement.STILL);
        }

        private int charPosition(int displayPosition, CursorMovement move2) {
            return this.charPosition(this.line, displayPosition, move2);
        }

        private int charPosition(int line, int displayPosition) {
            return this.charPosition(line, displayPosition, CursorMovement.STILL);
        }

        private int charPosition(int line, int displayPosition, CursorMovement move2) {
            int out = this.lines.get(line).length();
            if (!this.lines.get(line).contains("\t") || displayPosition == 0) {
                out = displayPosition;
            } else if (displayPosition < this.length(this.lines.get(line))) {
                int rdiff = 0;
                int ldiff = 0;
                for (int i2 = 0; i2 < this.lines.get(line).length(); ++i2) {
                    int dp = this.length(this.lines.get(line).substring(0, i2));
                    if (move2 == CursorMovement.LEFT) {
                        if (dp > displayPosition) break;
                        out = i2;
                        continue;
                    }
                    if (move2 == CursorMovement.RIGHT) {
                        if (dp < displayPosition) continue;
                        out = i2;
                        break;
                    }
                    if (move2 != CursorMovement.STILL) continue;
                    if (dp <= displayPosition) {
                        ldiff = displayPosition - dp;
                        out = i2;
                        continue;
                    }
                    if (dp < displayPosition) continue;
                    rdiff = dp - displayPosition;
                    if (rdiff >= ldiff) break;
                    out = i2;
                    break;
                }
            }
            return out;
        }

        String blanks(int nb) {
            StringBuilder sb = new StringBuilder();
            for (int i2 = 0; i2 < nb; ++i2) {
                sb.append(' ');
            }
            return sb.toString();
        }

        void insert(String insert) {
            String mod;
            String text = this.lines.get(this.line);
            int pos = this.charPosition(this.offsetInLine + this.column);
            insert = insert.replaceAll("\r\n", "\n");
            insert = insert.replaceAll("\r", "\n");
            if (Nano.this.tabsToSpaces && insert.length() == 1 && insert.charAt(0) == '\t') {
                int len = pos == text.length() ? this.length(text + insert) : this.length(text.substring(0, pos) + insert);
                insert = this.blanks(len - this.offsetInLine - this.column);
            }
            if (Nano.this.autoIndent && insert.length() == 1 && insert.charAt(0) == '\n') {
                for (char c2 : this.lines.get(this.line).toCharArray()) {
                    if (c2 == ' ') {
                        insert = insert + c2;
                        continue;
                    }
                    if (c2 != '\t') break;
                    insert = insert + c2;
                }
            }
            String tail = "";
            if (pos == text.length()) {
                mod = text + insert;
            } else {
                mod = text.substring(0, pos) + insert;
                tail = text.substring(pos);
            }
            ArrayList<String> ins = new ArrayList<String>();
            int last = 0;
            int idx = mod.indexOf(10, last);
            while (idx >= 0) {
                ins.add(mod.substring(last, idx));
                last = idx + 1;
                idx = mod.indexOf(10, last);
            }
            ins.add(mod.substring(last) + tail);
            int curPos = this.length(mod.substring(last));
            this.lines.set(this.line, (String)ins.get(0));
            this.offsets.set(this.line, this.computeOffsets((String)ins.get(0)));
            for (int i2 = 1; i2 < ins.size(); ++i2) {
                ++this.line;
                this.lines.add(this.line, (String)ins.get(i2));
                this.offsets.add(this.line, this.computeOffsets((String)ins.get(i2)));
            }
            this.moveToChar(curPos);
            this.ensureCursorVisible();
            this.dirty = true;
        }

        void computeAllOffsets() {
            this.offsets.clear();
            for (String text : this.lines) {
                this.offsets.add(this.computeOffsets(text));
            }
        }

        LinkedList<Integer> computeOffsets(String line) {
            String text = new AttributedStringBuilder().tabs(Nano.this.tabs).append(line).toString();
            int width = Nano.this.size.getColumns() - (Nano.this.printLineNumbers ? 8 : 0);
            LinkedList<Integer> offsets = new LinkedList<Integer>();
            offsets.add(0);
            if (Nano.this.wrapping) {
                int last = 0;
                int prevword = 0;
                boolean inspace = false;
                for (int i2 = 0; i2 < text.length(); ++i2) {
                    if (this.isBreakable(text.charAt(i2))) {
                        inspace = true;
                    } else if (inspace) {
                        prevword = i2;
                        inspace = false;
                    }
                    if (i2 != last + width - 1) continue;
                    if (prevword == last) {
                        prevword = i2;
                    }
                    offsets.add(prevword);
                    last = prevword;
                }
            }
            return offsets;
        }

        boolean isBreakable(char ch) {
            return !Nano.this.atBlanks || ch == ' ';
        }

        void moveToChar(int pos) {
            this.moveToChar(pos, CursorMovement.STILL);
        }

        void moveToChar(int pos, CursorMovement move2) {
            if (!Nano.this.wrapping) {
                if (pos > this.column && pos - this.firstColumnToDisplay + 1 > this.width()) {
                    this.firstColumnToDisplay = this.offsetInLine + this.column - 6;
                } else if (pos < this.column && this.firstColumnToDisplay + 5 > pos) {
                    this.firstColumnToDisplay = Math.max(0, this.firstColumnToDisplay - this.width() + 5);
                }
            }
            if (this.lines.get(this.line).contains("\t")) {
                int cpos = this.charPosition(pos, move2);
                pos = cpos < this.lines.get(this.line).length() ? this.length(this.lines.get(this.line).substring(0, cpos)) : this.length(this.lines.get(this.line));
            }
            this.offsetInLine = this.prevLineOffset(this.line, pos + 1).get();
            this.column = pos - this.offsetInLine;
        }

        void delete(int count) {
            while (--count >= 0 && this.moveRight(1) && this.backspace(1)) {
            }
        }

        boolean backspace(int count) {
            while (count > 0) {
                String text = this.lines.get(this.line);
                int pos = this.charPosition(this.offsetInLine + this.column);
                if (pos == 0) {
                    if (this.line == 0) {
                        this.bof();
                        return false;
                    }
                    String prev = this.lines.get(--this.line);
                    this.lines.set(this.line, prev + text);
                    this.offsets.set(this.line, this.computeOffsets(prev + text));
                    this.moveToChar(this.length(prev));
                    this.lines.remove(this.line + 1);
                    this.offsets.remove(this.line + 1);
                    --count;
                } else {
                    int nb = Math.min(pos, count);
                    int curPos = this.length(text.substring(0, pos - nb));
                    text = text.substring(0, pos - nb) + text.substring(pos);
                    this.lines.set(this.line, text);
                    this.offsets.set(this.line, this.computeOffsets(text));
                    this.moveToChar(curPos);
                    count -= nb;
                }
                this.dirty = true;
            }
            this.ensureCursorVisible();
            return true;
        }

        boolean moveLeft(int chars) {
            boolean ret = true;
            while (--chars >= 0) {
                if (this.offsetInLine + this.column > 0) {
                    this.moveToChar(this.offsetInLine + this.column - 1, CursorMovement.LEFT);
                    continue;
                }
                if (this.line > 0) {
                    --this.line;
                    this.moveToChar(this.length(this.getLine(this.line)));
                    continue;
                }
                this.bof();
                ret = false;
                break;
            }
            this.wantedColumn = this.column;
            this.ensureCursorVisible();
            return ret;
        }

        boolean moveRight(int chars) {
            return this.moveRight(chars, false);
        }

        int width() {
            return Nano.this.size.getColumns() - (Nano.this.printLineNumbers ? 8 : 0) - (Nano.this.wrapping ? 0 : 1) - (this.firstColumnToDisplay > 0 ? 1 : 0);
        }

        boolean moveRight(int chars, boolean fromBeginning) {
            if (fromBeginning) {
                this.firstColumnToDisplay = 0;
                this.offsetInLine = 0;
                this.column = 0;
                chars = Math.min(chars, this.length(this.getLine(this.line)));
            }
            boolean ret = true;
            while (--chars >= 0) {
                int len = this.length(this.getLine(this.line));
                if (this.offsetInLine + this.column + 1 <= len) {
                    this.moveToChar(this.offsetInLine + this.column + 1, CursorMovement.RIGHT);
                    continue;
                }
                if (this.getLine(this.line + 1) != null) {
                    ++this.line;
                    this.firstColumnToDisplay = 0;
                    this.offsetInLine = 0;
                    this.column = 0;
                    continue;
                }
                this.eof();
                ret = false;
                break;
            }
            this.wantedColumn = this.column;
            this.ensureCursorVisible();
            return ret;
        }

        void moveDown(int lines) {
            this.cursorDown(lines);
            this.ensureCursorVisible();
        }

        void moveUp(int lines) {
            this.cursorUp(lines);
            this.ensureCursorVisible();
        }

        private Optional<Integer> prevLineOffset(int line, int offsetInLine) {
            if (line >= this.offsets.size()) {
                return Optional.empty();
            }
            Iterator<Integer> it = this.offsets.get(line).descendingIterator();
            while (it.hasNext()) {
                int off = it.next();
                if (off >= offsetInLine) continue;
                return Optional.of(off);
            }
            return Optional.empty();
        }

        private Optional<Integer> nextLineOffset(int line, int offsetInLine) {
            if (line >= this.offsets.size()) {
                return Optional.empty();
            }
            return this.offsets.get(line).stream().filter(o2 -> o2 > offsetInLine).findFirst();
        }

        void moveDisplayDown(int lines) {
            int height = Nano.this.size.getRows() - this.computeHeader().size() - Nano.this.computeFooter().size();
            while (--lines >= 0) {
                int lastLineToDisplay = this.firstLineToDisplay;
                if (!Nano.this.wrapping) {
                    lastLineToDisplay += height - 1;
                } else {
                    int off = this.offsetInLineToDisplay;
                    for (int l2 = 0; l2 < height - 1; ++l2) {
                        Optional<Integer> next = this.nextLineOffset(lastLineToDisplay, off);
                        if (next.isPresent()) {
                            off = next.get();
                            continue;
                        }
                        off = 0;
                        ++lastLineToDisplay;
                    }
                }
                if (this.getLine(lastLineToDisplay) == null) {
                    this.eof();
                    return;
                }
                Optional<Integer> next = this.nextLineOffset(this.firstLineToDisplay, this.offsetInLineToDisplay);
                if (next.isPresent()) {
                    this.offsetInLineToDisplay = next.get();
                    continue;
                }
                this.offsetInLineToDisplay = 0;
                ++this.firstLineToDisplay;
            }
        }

        void moveDisplayUp(int lines) {
            int width = Nano.this.size.getColumns() - (Nano.this.printLineNumbers ? 8 : 0);
            while (--lines >= 0) {
                if (this.offsetInLineToDisplay > 0) {
                    this.offsetInLineToDisplay = Math.max(0, this.offsetInLineToDisplay - (width - 1));
                    continue;
                }
                if (this.firstLineToDisplay > 0) {
                    --this.firstLineToDisplay;
                    this.offsetInLineToDisplay = this.prevLineOffset(this.firstLineToDisplay, Integer.MAX_VALUE).get();
                    continue;
                }
                this.bof();
                return;
            }
        }

        private void cursorDown(int lines) {
            this.firstColumnToDisplay = 0;
            while (--lines >= 0) {
                if (!Nano.this.wrapping) {
                    if (this.getLine(this.line + 1) != null) {
                        ++this.line;
                        this.offsetInLine = 0;
                        this.column = Math.min(this.length(this.getLine(this.line)), this.wantedColumn);
                        continue;
                    }
                    this.bof();
                    break;
                }
                String txt = this.getLine(this.line);
                Optional<Integer> off = this.nextLineOffset(this.line, this.offsetInLine);
                if (off.isPresent()) {
                    this.offsetInLine = off.get();
                } else {
                    if (this.getLine(this.line + 1) == null) {
                        this.eof();
                        break;
                    }
                    ++this.line;
                    this.offsetInLine = 0;
                    txt = this.getLine(this.line);
                }
                int next = this.nextLineOffset(this.line, this.offsetInLine).orElse(this.length(txt));
                this.column = Math.min(this.wantedColumn, next - this.offsetInLine);
            }
            this.moveToChar(this.offsetInLine + this.column);
        }

        private void cursorUp(int lines) {
            this.firstColumnToDisplay = 0;
            while (--lines >= 0) {
                if (!Nano.this.wrapping) {
                    if (this.line > 0) {
                        --this.line;
                        this.column = Math.min(this.length(this.getLine(this.line)) - this.offsetInLine, this.wantedColumn);
                        continue;
                    }
                    this.bof();
                    break;
                }
                Optional<Integer> prev = this.prevLineOffset(this.line, this.offsetInLine);
                if (prev.isPresent()) {
                    this.offsetInLine = prev.get();
                    continue;
                }
                if (this.line > 0) {
                    --this.line;
                    this.offsetInLine = this.prevLineOffset(this.line, Integer.MAX_VALUE).get();
                    int next = this.nextLineOffset(this.line, this.offsetInLine).orElse(this.length(this.getLine(this.line)));
                    this.column = Math.min(this.wantedColumn, next - this.offsetInLine);
                    continue;
                }
                this.bof();
                break;
            }
            this.moveToChar(this.offsetInLine + this.column);
        }

        void ensureCursorVisible() {
            int cursor;
            List<AttributedString> header = this.computeHeader();
            int rwidth = Nano.this.size.getColumns();
            int height = Nano.this.size.getRows() - header.size() - Nano.this.computeFooter().size();
            while (this.line < this.firstLineToDisplay || this.line == this.firstLineToDisplay && this.offsetInLine < this.offsetInLineToDisplay) {
                this.moveDisplayUp(Nano.this.smoothScrolling ? 1 : height / 2);
            }
            while ((cursor = this.computeCursorPosition(header.size() * Nano.this.size.getColumns() + (Nano.this.printLineNumbers ? 8 : 0), rwidth)) >= (height + header.size()) * rwidth) {
                this.moveDisplayDown(Nano.this.smoothScrolling ? 1 : height / 2);
            }
        }

        void eof() {
        }

        void bof() {
        }

        void resetDisplay() {
            this.column = this.offsetInLine + this.column;
            this.moveRight(this.column, true);
        }

        String getLine(int line) {
            return line < this.lines.size() ? this.lines.get(line) : null;
        }

        String getTitle() {
            return this.file != null ? "File: " + this.file : "New Buffer";
        }

        List<AttributedString> computeHeader() {
            String left = Nano.this.getTitle();
            String middle = null;
            String right = this.dirty ? "Modified" : "        ";
            int width = Nano.this.size.getColumns();
            int mstart = 2 + left.length() + 1;
            int mend = width - 2 - 8;
            if (this.file == null) {
                middle = "New Buffer";
            } else {
                int max = mend - mstart;
                String src = this.file;
                if ("File: ".length() + src.length() > max) {
                    int lastSep = src.lastIndexOf(47);
                    if (lastSep > 0) {
                        String p1 = src.substring(lastSep);
                        String p0 = src.substring(0, lastSep);
                        while (p0.startsWith(".")) {
                            p0 = p0.substring(1);
                        }
                        int nb = max - p1.length() - "File: ...".length();
                        int cut = Math.max(0, Math.min(p0.length(), p0.length() - nb));
                        middle = "File: ..." + p0.substring(cut) + p1;
                    }
                    if (middle == null || middle.length() > max) {
                        left = null;
                        max = mend - 2;
                        int nb = max - "File: ...".length();
                        int cut = Math.max(0, Math.min(src.length(), src.length() - nb));
                        middle = "File: ..." + src.substring(cut);
                        if (middle.length() > max) {
                            middle = middle.substring(0, max);
                        }
                    }
                } else {
                    middle = "File: " + src;
                }
            }
            int pos = 0;
            AttributedStringBuilder sb = new AttributedStringBuilder();
            sb.style(AttributedStyle.INVERSE);
            sb.append("  ");
            pos += 2;
            if (left != null) {
                sb.append(left);
                pos += left.length();
                sb.append(" ");
                ++pos;
                for (int i2 = 1; i2 < (Nano.this.size.getColumns() - middle.length()) / 2 - left.length() - 1 - 2; ++i2) {
                    sb.append(" ");
                    ++pos;
                }
            }
            sb.append(middle);
            pos += middle.length();
            while (pos < width - 8 - 2) {
                sb.append(" ");
                ++pos;
            }
            sb.append(right);
            sb.append("  \n");
            if (Nano.this.oneMoreLine) {
                return Collections.singletonList(sb.toAttributedString());
            }
            return Arrays.asList(sb.toAttributedString(), new AttributedString("\n"));
        }

        void highlightDisplayedLine(int curLine, int curOffset, int nextOffset, AttributedStringBuilder line) {
            AttributedString disp = Nano.this.highlight ? this.syntaxHighlighter.highlight(new AttributedStringBuilder().tabs(Nano.this.tabs).append(this.getLine(curLine))) : new AttributedStringBuilder().tabs(Nano.this.tabs).append(this.getLine(curLine)).toAttributedString();
            int[] hls = this.highlightStart();
            int[] hle = this.highlightEnd();
            if (hls[0] == -1 || hle[0] == -1) {
                line.append(disp.columnSubSequence(curOffset, nextOffset));
            } else if (hls[0] == hle[0]) {
                if (curLine == hls[0]) {
                    if (hls[1] > nextOffset) {
                        line.append(disp.columnSubSequence(curOffset, nextOffset));
                    } else if (hls[1] < curOffset) {
                        if (hle[1] > nextOffset) {
                            line.append(disp.columnSubSequence(curOffset, nextOffset), AttributedStyle.INVERSE);
                        } else if (hle[1] > curOffset) {
                            line.append(disp.columnSubSequence(curOffset, hle[1]), AttributedStyle.INVERSE);
                            line.append(disp.columnSubSequence(hle[1], nextOffset));
                        } else {
                            line.append(disp.columnSubSequence(curOffset, nextOffset));
                        }
                    } else {
                        line.append(disp.columnSubSequence(curOffset, hls[1]));
                        if (hle[1] > nextOffset) {
                            line.append(disp.columnSubSequence(hls[1], nextOffset), AttributedStyle.INVERSE);
                        } else {
                            line.append(disp.columnSubSequence(hls[1], hle[1]), AttributedStyle.INVERSE);
                            line.append(disp.columnSubSequence(hle[1], nextOffset));
                        }
                    }
                } else {
                    line.append(disp.columnSubSequence(curOffset, nextOffset));
                }
            } else if (curLine > hls[0] && curLine < hle[0]) {
                line.append(disp.columnSubSequence(curOffset, nextOffset), AttributedStyle.INVERSE);
            } else if (curLine == hls[0]) {
                if (hls[1] > nextOffset) {
                    line.append(disp.columnSubSequence(curOffset, nextOffset));
                } else if (hls[1] < curOffset) {
                    line.append(disp.columnSubSequence(curOffset, nextOffset), AttributedStyle.INVERSE);
                } else {
                    line.append(disp.columnSubSequence(curOffset, hls[1]));
                    line.append(disp.columnSubSequence(hls[1], nextOffset), AttributedStyle.INVERSE);
                }
            } else if (curLine == hle[0]) {
                if (hle[1] < curOffset) {
                    line.append(disp.columnSubSequence(curOffset, nextOffset));
                } else if (hle[1] > nextOffset) {
                    line.append(disp.columnSubSequence(curOffset, nextOffset), AttributedStyle.INVERSE);
                } else {
                    line.append(disp.columnSubSequence(curOffset, hle[1]), AttributedStyle.INVERSE);
                    line.append(disp.columnSubSequence(hle[1], nextOffset));
                }
            } else {
                line.append(disp.columnSubSequence(curOffset, nextOffset));
            }
        }

        List<AttributedString> getDisplayedLines(int nbLines) {
            AttributedStyle s2 = AttributedStyle.DEFAULT.foreground(8);
            AttributedString cut = new AttributedString("\u2026", s2);
            AttributedString ret = new AttributedString("\u21a9", s2);
            ArrayList<AttributedString> newLines = new ArrayList<AttributedString>();
            int rwidth = Nano.this.size.getColumns();
            int width = rwidth - (Nano.this.printLineNumbers ? 8 : 0);
            int curLine = this.firstLineToDisplay;
            int curOffset = this.offsetInLineToDisplay;
            int prevLine = -1;
            if (Nano.this.highlight) {
                this.syntaxHighlighter.reset();
                for (int i2 = Math.max(0, curLine - nbLines); i2 < curLine; ++i2) {
                    this.syntaxHighlighter.highlight(this.getLine(i2));
                }
            }
            for (int terminalLine = 0; terminalLine < nbLines; ++terminalLine) {
                AttributedStringBuilder line = new AttributedStringBuilder().tabs(Nano.this.tabs);
                if (Nano.this.printLineNumbers && curLine < this.lines.size()) {
                    line.style(s2);
                    if (curLine != prevLine) {
                        line.append(String.format("%7d ", curLine + 1));
                    } else {
                        line.append("      \u2027 ");
                    }
                    line.style(AttributedStyle.DEFAULT);
                    prevLine = curLine;
                }
                if (curLine < this.lines.size()) {
                    if (!Nano.this.wrapping) {
                        AttributedString disp = new AttributedStringBuilder().tabs(Nano.this.tabs).append(this.getLine(curLine)).toAttributedString();
                        if (this.line == curLine) {
                            int cutCount = 1;
                            if (this.firstColumnToDisplay > 0) {
                                line.append(cut);
                                cutCount = 2;
                            }
                            if (disp.columnLength() - this.firstColumnToDisplay >= width - (cutCount - 1) * cut.columnLength()) {
                                this.highlightDisplayedLine(curLine, this.firstColumnToDisplay, this.firstColumnToDisplay + width - cutCount * cut.columnLength(), line);
                                line.append(cut);
                            } else {
                                this.highlightDisplayedLine(curLine, this.firstColumnToDisplay, disp.columnLength(), line);
                            }
                        } else if (disp.columnLength() >= width) {
                            this.highlightDisplayedLine(curLine, 0, width - cut.columnLength(), line);
                            line.append(cut);
                        } else {
                            this.highlightDisplayedLine(curLine, 0, disp.columnLength(), line);
                        }
                        ++curLine;
                    } else {
                        Optional<Integer> nextOffset = this.nextLineOffset(curLine, curOffset);
                        if (nextOffset.isPresent()) {
                            this.highlightDisplayedLine(curLine, curOffset, nextOffset.get(), line);
                            line.append(ret);
                            curOffset = nextOffset.get();
                        } else {
                            this.highlightDisplayedLine(curLine, curOffset, Integer.MAX_VALUE, line);
                            ++curLine;
                            curOffset = 0;
                        }
                    }
                }
                line.append('\n');
                newLines.add(line.toAttributedString());
            }
            return newLines;
        }

        public void moveTo(int x2, int y2) {
            if (Nano.this.printLineNumbers) {
                x2 = Math.max(x2 - 8, 0);
            }
            this.line = this.firstLineToDisplay;
            this.offsetInLine = this.offsetInLineToDisplay;
            this.wantedColumn = x2;
            this.cursorDown(y2);
        }

        public void gotoLine(int x2, int y2) {
            this.line = y2 < this.lines.size() ? y2 : this.lines.size() - 1;
            x2 = Math.min(x2, this.length(this.lines.get(this.line)));
            this.firstLineToDisplay = this.line > 0 ? this.line - 1 : this.line;
            this.offsetInLine = 0;
            this.offsetInLineToDisplay = 0;
            this.column = 0;
            this.moveRight(x2);
        }

        public int getDisplayedCursor() {
            return this.computeCursorPosition(Nano.this.printLineNumbers ? 8 : 0, Nano.this.size.getColumns() + 1);
        }

        private int computeCursorPosition(int cursor, int rwidth) {
            int cur = this.firstLineToDisplay;
            int off = this.offsetInLineToDisplay;
            while (cur < this.line || off < this.offsetInLine) {
                if (!Nano.this.wrapping) {
                    cursor += rwidth;
                    ++cur;
                    continue;
                }
                cursor += rwidth;
                Optional<Integer> next = this.nextLineOffset(cur, off);
                if (next.isPresent()) {
                    off = next.get();
                    continue;
                }
                ++cur;
                off = 0;
            }
            if (cur == this.line) {
                if (!Nano.this.wrapping && this.column > this.firstColumnToDisplay + this.width()) {
                    while (this.column > this.firstColumnToDisplay + this.width()) {
                        this.firstColumnToDisplay += this.width();
                    }
                }
            } else {
                throw new IllegalStateException();
            }
            return cursor += this.column - this.firstColumnToDisplay + (this.firstColumnToDisplay > 0 ? 1 : 0);
        }

        char getCurrentChar() {
            String str = this.lines.get(this.line);
            if (this.column + this.offsetInLine < str.length()) {
                return str.charAt(this.column + this.offsetInLine);
            }
            if (this.line < this.lines.size() - 1) {
                return '\n';
            }
            return '\u0000';
        }

        public void prevWord() {
            while (Character.isAlphabetic(this.getCurrentChar()) && this.moveLeft(1)) {
            }
            while (!Character.isAlphabetic(this.getCurrentChar()) && this.moveLeft(1)) {
            }
            while (Character.isAlphabetic(this.getCurrentChar()) && this.moveLeft(1)) {
            }
            this.moveRight(1);
        }

        public void nextWord() {
            while (Character.isAlphabetic(this.getCurrentChar()) && this.moveRight(1)) {
            }
            while (!Character.isAlphabetic(this.getCurrentChar()) && this.moveRight(1)) {
            }
        }

        public void beginningOfLine() {
            this.offsetInLine = 0;
            this.column = 0;
            this.wantedColumn = 0;
            this.ensureCursorVisible();
        }

        public void endOfLine() {
            int x2 = this.length(this.lines.get(this.line));
            this.moveRight(x2, true);
        }

        public void prevPage() {
            int height = Nano.this.size.getRows() - this.computeHeader().size() - Nano.this.computeFooter().size();
            this.scrollUp(height - 2);
            this.column = 0;
            this.firstLineToDisplay = this.line;
            this.offsetInLineToDisplay = this.offsetInLine;
        }

        public void nextPage() {
            int height = Nano.this.size.getRows() - this.computeHeader().size() - Nano.this.computeFooter().size();
            this.scrollDown(height - 2);
            this.column = 0;
            this.firstLineToDisplay = this.line;
            this.offsetInLineToDisplay = this.offsetInLine;
        }

        public void scrollUp(int lines) {
            this.cursorUp(lines);
            this.moveDisplayUp(lines);
        }

        public void scrollDown(int lines) {
            this.cursorDown(lines);
            this.moveDisplayDown(lines);
        }

        public void firstLine() {
            this.line = 0;
            this.column = 0;
            this.offsetInLine = 0;
            this.ensureCursorVisible();
        }

        public void lastLine() {
            this.line = this.lines.size() - 1;
            this.column = 0;
            this.offsetInLine = 0;
            this.ensureCursorVisible();
        }

        boolean nextSearch() {
            boolean out = false;
            if (Nano.this.searchTerm == null) {
                Nano.this.setMessage("No current search pattern");
                return false;
            }
            Nano.this.setMessage(null);
            int cur = this.line;
            int dir2 = Nano.this.searchBackwards ? -1 : 1;
            int newPos = -1;
            int newLine = -1;
            List<Integer> curRes = this.doSearch(this.lines.get(this.line));
            if (Nano.this.searchBackwards) {
                Collections.reverse(curRes);
            }
            for (int r2 : curRes) {
                if (!(Nano.this.searchBackwards ? r2 < this.offsetInLine + this.column : r2 > this.offsetInLine + this.column)) continue;
                newPos = r2;
                newLine = this.line;
                break;
            }
            if (newPos < 0) {
                while ((cur = (cur + dir2 + this.lines.size()) % this.lines.size()) != this.line) {
                    List<Integer> res2 = this.doSearch(this.lines.get(cur));
                    if (res2.isEmpty()) continue;
                    newPos = Nano.this.searchBackwards ? res2.get(res2.size() - 1) : res2.get(0);
                    newLine = cur;
                    break;
                }
            }
            if (newPos < 0 && !curRes.isEmpty()) {
                newPos = curRes.get(0);
                newLine = this.line;
            }
            if (newPos >= 0) {
                if (newLine == this.line && newPos == this.offsetInLine + this.column) {
                    Nano.this.setMessage("This is the only occurence");
                    return false;
                }
                if (Nano.this.searchBackwards && (newLine > this.line || newLine == this.line && newPos > this.offsetInLine + this.column) || !Nano.this.searchBackwards && (newLine < this.line || newLine == this.line && newPos < this.offsetInLine + this.column)) {
                    Nano.this.setMessage("Search Wrapped");
                }
                this.line = newLine;
                this.moveRight(newPos, true);
                out = true;
            } else {
                Nano.this.setMessage("\"" + Nano.this.searchTerm + "\" not found");
            }
            return out;
        }

        private List<Integer> doSearch(String text) {
            Pattern pat = Pattern.compile(Nano.this.searchTerm, (Nano.this.searchCaseSensitive ? 0 : 66) | (Nano.this.searchRegexp ? 0 : 16));
            Matcher m2 = pat.matcher(text);
            ArrayList<Integer> res2 = new ArrayList<Integer>();
            while (m2.find()) {
                res2.add(m2.start());
                Nano.this.matchedLength = m2.group(0).length();
            }
            return res2;
        }

        protected int[] highlightStart() {
            int[] out = new int[]{-1, -1};
            if (Nano.this.mark) {
                out = this.getMarkStart();
            } else if (Nano.this.searchToReplace) {
                out[0] = this.line;
                out[1] = this.offsetInLine + this.column;
            }
            return out;
        }

        protected int[] highlightEnd() {
            int[] out = new int[]{-1, -1};
            if (Nano.this.mark) {
                out = this.getMarkEnd();
            } else if (Nano.this.searchToReplace && Nano.this.matchedLength > 0) {
                out[0] = this.line;
                int col = this.charPosition(this.offsetInLine + this.column) + Nano.this.matchedLength;
                out[1] = col < this.lines.get(this.line).length() ? this.length(this.lines.get(this.line).substring(0, col)) : this.length(this.lines.get(this.line));
            }
            return out;
        }

        public void matching() {
            char opening = this.getCurrentChar();
            int idx = Nano.this.matchBrackets.indexOf(opening);
            if (idx >= 0) {
                int dir2 = idx >= Nano.this.matchBrackets.length() / 2 ? -1 : 1;
                char closing = Nano.this.matchBrackets.charAt((idx + Nano.this.matchBrackets.length() / 2) % Nano.this.matchBrackets.length());
                int lvl = 1;
                int cur = this.line;
                int pos = this.offsetInLine + this.column;
                while (true) {
                    if (pos + dir2 >= 0 && pos + dir2 < this.getLine(cur).length()) {
                        pos += dir2;
                    } else if (cur + dir2 >= 0 && cur + dir2 < this.lines.size()) {
                        pos = dir2 > 0 ? 0 : this.lines.get(cur += dir2).length() - 1;
                        if (pos < 0 || pos >= this.lines.get(cur).length()) {
                            continue;
                        }
                    } else {
                        Nano.this.setMessage("No matching bracket");
                        return;
                    }
                    char c2 = this.lines.get(cur).charAt(pos);
                    if (c2 == opening) {
                        ++lvl;
                        continue;
                    }
                    if (c2 == closing && --lvl == 0) break;
                }
                this.line = cur;
                this.moveToChar(pos);
                this.ensureCursorVisible();
                return;
            }
            Nano.this.setMessage("Not a bracket");
        }

        private int length(String line) {
            return new AttributedStringBuilder().tabs(Nano.this.tabs).append(line).columnLength();
        }

        void copy() {
            if (this.uncut || Nano.this.cut2end || Nano.this.mark) {
                Nano.this.cutbuffer = new ArrayList<String>();
            }
            if (Nano.this.mark) {
                int[] e2;
                int[] s2 = this.getMarkStart();
                if (s2[0] == (e2 = this.getMarkEnd())[0]) {
                    Nano.this.cutbuffer.add(this.lines.get(s2[0]).substring(this.charPosition(s2[0], s2[1]), this.charPosition(e2[0], e2[1])));
                } else {
                    if (s2[1] != 0) {
                        Nano.this.cutbuffer.add(this.lines.get(s2[0]).substring(this.charPosition(s2[0], s2[1])));
                        s2[0] = s2[0] + 1;
                    }
                    for (int i2 = s2[0]; i2 < e2[0]; ++i2) {
                        Nano.this.cutbuffer.add(this.lines.get(i2));
                    }
                    if (e2[1] != 0) {
                        Nano.this.cutbuffer.add(this.lines.get(e2[0]).substring(0, this.charPosition(e2[0], e2[1])));
                    }
                }
                Nano.this.mark = false;
                this.mark();
            } else if (Nano.this.cut2end) {
                String l2 = this.lines.get(this.line);
                int col = this.charPosition(this.offsetInLine + this.column);
                Nano.this.cutbuffer.add(l2.substring(col));
                this.moveRight(l2.substring(col).length());
            } else {
                Nano.this.cutbuffer.add(this.lines.get(this.line));
                this.cursorDown(1);
            }
            this.uncut = false;
        }

        void cut() {
            this.cut(false);
        }

        void cut(boolean toEnd) {
            if (this.lines.size() > 1) {
                if (this.uncut || Nano.this.cut2end || toEnd || Nano.this.mark) {
                    Nano.this.cutbuffer = new ArrayList<String>();
                }
                if (Nano.this.mark) {
                    int[] e2;
                    int[] s2 = this.getMarkStart();
                    if (s2[0] == (e2 = this.getMarkEnd())[0]) {
                        String l2 = this.lines.get(s2[0]);
                        int cols = this.charPosition(s2[0], s2[1]);
                        int cole = this.charPosition(e2[0], e2[1]);
                        Nano.this.cutbuffer.add(l2.substring(cols, cole));
                        this.lines.set(s2[0], l2.substring(0, cols) + l2.substring(cole));
                        this.computeAllOffsets();
                        this.moveRight(cols, true);
                    } else {
                        int ls = s2[0];
                        int cs = this.charPosition(s2[0], s2[1]);
                        if (s2[1] != 0) {
                            String l3 = this.lines.get(s2[0]);
                            Nano.this.cutbuffer.add(l3.substring(cs));
                            this.lines.set(s2[0], l3.substring(0, cs));
                            s2[0] = s2[0] + 1;
                        }
                        for (int i2 = s2[0]; i2 < e2[0]; ++i2) {
                            Nano.this.cutbuffer.add(this.lines.get(s2[0]));
                            this.lines.remove(s2[0]);
                        }
                        if (e2[1] != 0) {
                            String l4 = this.lines.get(s2[0]);
                            int col = this.charPosition(e2[0], e2[1]);
                            Nano.this.cutbuffer.add(l4.substring(0, col));
                            this.lines.set(s2[0], l4.substring(col));
                        }
                        this.computeAllOffsets();
                        this.gotoLine(cs, ls);
                    }
                    Nano.this.mark = false;
                    this.mark();
                } else if (Nano.this.cut2end || toEnd) {
                    String l5 = this.lines.get(this.line);
                    int col = this.charPosition(this.offsetInLine + this.column);
                    Nano.this.cutbuffer.add(l5.substring(col));
                    this.lines.set(this.line, l5.substring(0, col));
                    if (toEnd) {
                        ++this.line;
                        do {
                            Nano.this.cutbuffer.add(this.lines.get(this.line));
                            this.lines.remove(this.line);
                        } while (this.line <= this.lines.size() - 1);
                        --this.line;
                    }
                } else {
                    Nano.this.cutbuffer.add(this.lines.get(this.line));
                    this.lines.remove(this.line);
                    this.offsetInLine = 0;
                    if (this.line > this.lines.size() - 1) {
                        --this.line;
                    }
                }
                Nano.this.display.clear();
                this.computeAllOffsets();
                this.dirty = true;
                this.uncut = false;
            }
        }

        void uncut() {
            if (Nano.this.cutbuffer.isEmpty()) {
                return;
            }
            String l2 = this.lines.get(this.line);
            int col = this.charPosition(this.offsetInLine + this.column);
            if (Nano.this.cut2end) {
                this.lines.set(this.line, l2.substring(0, col) + Nano.this.cutbuffer.get(0) + l2.substring(col));
                this.computeAllOffsets();
                this.moveRight(col + Nano.this.cutbuffer.get(0).length(), true);
            } else if (col == 0) {
                this.lines.addAll(this.line, Nano.this.cutbuffer);
                this.computeAllOffsets();
                if (Nano.this.cutbuffer.size() > 1) {
                    this.gotoLine(Nano.this.cutbuffer.get(Nano.this.cutbuffer.size() - 1).length(), this.line + Nano.this.cutbuffer.size());
                } else {
                    this.moveRight(Nano.this.cutbuffer.get(0).length(), true);
                }
            } else {
                int gotol = this.line;
                if (Nano.this.cutbuffer.size() == 1) {
                    this.lines.set(this.line, l2.substring(0, col) + Nano.this.cutbuffer.get(0) + l2.substring(col));
                } else {
                    this.lines.set(this.line++, l2.substring(0, col) + Nano.this.cutbuffer.get(0));
                    gotol = this.line;
                    this.lines.add(this.line, Nano.this.cutbuffer.get(Nano.this.cutbuffer.size() - 1) + l2.substring(col));
                    for (int i2 = Nano.this.cutbuffer.size() - 2; i2 > 0; --i2) {
                        ++gotol;
                        this.lines.add(this.line, Nano.this.cutbuffer.get(i2));
                    }
                }
                this.computeAllOffsets();
                if (Nano.this.cutbuffer.size() > 1) {
                    this.gotoLine(Nano.this.cutbuffer.get(Nano.this.cutbuffer.size() - 1).length(), gotol);
                } else {
                    this.moveRight(col + Nano.this.cutbuffer.get(0).length(), true);
                }
            }
            Nano.this.display.clear();
            this.dirty = true;
            this.uncut = true;
        }

        void mark() {
            if (Nano.this.mark) {
                this.markPos[0] = this.line;
                this.markPos[1] = this.offsetInLine + this.column;
            } else {
                this.markPos[0] = -1;
                this.markPos[1] = -1;
            }
        }

        int[] getMarkStart() {
            int[] out = new int[]{-1, -1};
            if (!Nano.this.mark) {
                return out;
            }
            if (this.markPos[0] > this.line || this.markPos[0] == this.line && this.markPos[1] > this.offsetInLine + this.column) {
                out[0] = this.line;
                out[1] = this.offsetInLine + this.column;
            } else {
                out = this.markPos;
            }
            return out;
        }

        int[] getMarkEnd() {
            int[] out = new int[]{-1, -1};
            if (!Nano.this.mark) {
                return out;
            }
            if (this.markPos[0] > this.line || this.markPos[0] == this.line && this.markPos[1] > this.offsetInLine + this.column) {
                out = this.markPos;
            } else {
                out[0] = this.line;
                out[1] = this.offsetInLine + this.column;
            }
            return out;
        }

        void replaceFromCursor(int chars, String string) {
            int pos = this.charPosition(this.offsetInLine + this.column);
            String text = this.lines.get(this.line);
            String mod = text.substring(0, pos) + string;
            if (chars + pos < text.length()) {
                mod = mod + text.substring(chars + pos);
            }
            this.lines.set(this.line, mod);
            this.dirty = true;
        }
    }

    protected static enum Operation {
        DO_LOWER_CASE,
        QUIT,
        WRITE,
        READ,
        GOTO,
        FIND,
        WRAP,
        NUMBERS,
        SMOOTH_SCROLLING,
        MOUSE_SUPPORT,
        ONE_MORE_LINE,
        CLEAR_SCREEN,
        UP,
        DOWN,
        LEFT,
        RIGHT,
        INSERT,
        BACKSPACE,
        NEXT_BUFFER,
        PREV_BUFFER,
        HELP,
        NEXT_PAGE,
        PREV_PAGE,
        SCROLL_UP,
        SCROLL_DOWN,
        NEXT_WORD,
        PREV_WORD,
        BEGINNING_OF_LINE,
        END_OF_LINE,
        FIRST_LINE,
        LAST_LINE,
        CUR_POS,
        CASE_SENSITIVE,
        BACKWARDS,
        REGEXP,
        ACCEPT,
        CANCEL,
        SEARCH,
        TOGGLE_REPLACE,
        MAC_FORMAT,
        DOS_FORMAT,
        APPEND_MODE,
        PREPEND_MODE,
        BACKUP,
        TO_FILES,
        YES,
        NO,
        ALL,
        NEW_BUFFER,
        EXECUTE,
        NEXT_SEARCH,
        MATCHING,
        VERBATIM,
        DELETE,
        JUSTIFY_PARAGRAPH,
        TO_SPELL,
        CUT,
        REPLACE,
        MARK,
        COPY,
        INDENT,
        UNINDENT,
        BEGINNING_OF_PARAGRAPH,
        END_OF_PARAGRAPH,
        CUT_TO_END,
        JUSTIFY_FILE,
        COUNT,
        CONSTANT_CURSOR,
        WHITESPACE,
        HIGHLIGHT,
        SMART_HOME_KEY,
        AUTO_INDENT,
        CUT_TO_END_TOGGLE,
        TABS_TO_SPACE,
        UNCUT,
        MOUSE_EVENT,
        TOGGLE_SUSPENSION;

    }

    protected static enum WriteFormat {
        UNIX,
        DOS,
        MAC;

    }

    protected static enum CursorMovement {
        RIGHT,
        LEFT,
        STILL;

    }
}

