/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependencies.internal;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.result.DefaultResolvedComponentResult;
import org.gradle.api.reporting.dependencies.internal.StrictDependencyResultSpec;
import org.gradle.api.tasks.diagnostics.internal.ConfigurationDetails;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.AbstractRenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableModuleResult;
import org.gradle.api.tasks.diagnostics.internal.insight.DependencyInsightReporter;
import org.gradle.internal.Actions;
import org.gradle.util.GradleVersion;
import org.jspecify.annotations.Nullable;

class JsonProjectDependencyRenderer {
    private final VersionSelectorScheme versionSelectorScheme;
    private final VersionComparator versionComparator;
    private final VersionParser versionParser;

    public JsonProjectDependencyRenderer(VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator, VersionParser versionParser) {
        this.versionSelectorScheme = versionSelectorScheme;
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
    }

    public void render(ProjectDetails.ProjectNameAndPath project, Iterable<ConfigurationDetails> configurations, Writer writer) throws IOException {
        JsonWriter json = new JsonWriter(writer);
        this.writeProject(project, configurations, json);
    }

    private void writeProject(ProjectDetails.ProjectNameAndPath project, Iterable<ConfigurationDetails> configurations, JsonWriter json) throws IOException {
        json.beginObject();
        json.name("gradleVersion").value(GradleVersion.current().toString());
        json.name("generationDate").value(new Date().toString());
        json.name("project");
        json.beginObject();
        json.name("name").value(project.getName());
        json.name("description").value(project.getDescription());
        json.name("configurations");
        json.beginArray();
        for (ConfigurationDetails configuration : configurations) {
            json.beginObject();
            json.name("name").value(configuration.getName());
            json.name("description").value(configuration.getDescription());
            this.writeDependencies(configuration, json);
            this.writeModuleInsights(configuration, json);
            json.endObject();
        }
        json.endArray();
        json.endObject();
        json.endObject();
    }

    private void writeDependencies(ConfigurationDetails configuration, JsonWriter json) throws IOException {
        if (configuration.isCanBeResolved()) {
            RenderableModuleResult root = new RenderableModuleResult((ResolvedComponentResult)configuration.getResolutionResultRoot().get());
            this.writeDependencyChildren(root, new HashSet<Object>(), json, "dependencies");
        } else {
            this.writeDependencyChildren(configuration.getUnresolvableResult(), new HashSet<Object>(), json, "dependencies");
        }
    }

    private void writeDependencyChildren(RenderableDependency dependency, Set<Object> visited, JsonWriter json, String fieldName) throws IOException {
        Set<? extends RenderableDependency> children = dependency.getChildren();
        json.name(fieldName);
        json.beginArray();
        for (RenderableDependency renderableDependency : children) {
            json.beginObject();
            boolean alreadyVisited = !visited.add(renderableDependency.getId());
            boolean alreadyRendered = alreadyVisited && !renderableDependency.getChildren().isEmpty();
            String name = this.replaceArrow(renderableDependency.getName());
            boolean hasConflict = !name.equals(renderableDependency.getName());
            ModuleIdentifier moduleIdentifier = this.getModuleIdentifier(renderableDependency);
            json.name("module").value(moduleIdentifier == null ? null : moduleIdentifier.toString());
            json.name("name").value(name);
            json.name("resolvable").value(renderableDependency.getResolutionState().toString());
            json.name("hasConflict").value(hasConflict);
            json.name("alreadyRendered").value(alreadyRendered);
            if (!alreadyRendered) {
                this.writeDependencyChildren(renderableDependency, visited, json, "children");
            } else {
                json.name("children");
                json.beginArray();
                json.endArray();
            }
            json.endObject();
        }
        json.endArray();
    }

    private @Nullable ModuleIdentifier getModuleIdentifier(RenderableDependency renderableDependency) {
        if (renderableDependency.getId() instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier id = (ModuleComponentIdentifier)renderableDependency.getId();
            return id.getModuleIdentifier();
        }
        return null;
    }

    private void writeModuleInsights(ConfigurationDetails configuration, JsonWriter json) throws IOException {
        json.name("moduleInsights");
        json.beginArray();
        for (ModuleIdentifier module : this.collectModules(configuration)) {
            json.beginObject();
            this.writeModuleInsight(module, configuration, json);
            json.endObject();
        }
        json.endArray();
    }

    private Set<ModuleIdentifier> collectModules(ConfigurationDetails configuration) {
        AbstractRenderableDependency root = configuration.isCanBeResolved() ? new RenderableModuleResult((ResolvedComponentResult)configuration.getResolutionResultRoot().get()) : configuration.getUnresolvableResult();
        HashSet<ModuleIdentifier> modules = new HashSet<ModuleIdentifier>();
        HashSet<ComponentIdentifier> visited = new HashSet<ComponentIdentifier>();
        this.populateModulesWithChildDependencies(root, visited, modules);
        return modules;
    }

    private void populateModulesWithChildDependencies(RenderableDependency dependency, Set<ComponentIdentifier> visited, Set<ModuleIdentifier> modules) {
        for (RenderableDependency renderableDependency : dependency.getChildren()) {
            ModuleIdentifier moduleId = this.getModuleIdentifier(renderableDependency);
            if (moduleId == null) continue;
            modules.add(moduleId);
            boolean alreadyVisited = !visited.add((ComponentIdentifier)renderableDependency.getId());
            if (alreadyVisited) continue;
            this.populateModulesWithChildDependencies(renderableDependency, visited, modules);
        }
    }

    private void writeModuleInsight(ModuleIdentifier module, ConfigurationDetails configuration, JsonWriter json) throws IOException {
        json.name("module").value(module.toString());
        json.name("insight");
        this.writeInsight(module, configuration.getName(), (ResolvedComponentResult)configuration.getResolutionResultRoot().get(), json);
    }

    private void writeInsight(ModuleIdentifier module, String configurationName, ResolvedComponentResult incomingResolution, JsonWriter json) throws IOException {
        json.beginArray();
        StrictDependencyResultSpec dependencySpec = new StrictDependencyResultSpec(module);
        LinkedHashSet<DependencyResult> selectedDependencies = new LinkedHashSet<DependencyResult>();
        DefaultResolvedComponentResult.eachElement((ResolvedComponentResult)incomingResolution, (Action)Actions.doNothing(), it -> {
            if (dependencySpec.isSatisfiedBy(it)) {
                selectedDependencies.add((DependencyResult)it);
            }
        }, new HashSet());
        Collection<RenderableDependency> sortedDeps = new DependencyInsightReporter(this.versionSelectorScheme, this.versionComparator, this.versionParser).convertToRenderableItems(selectedDependencies, false);
        for (RenderableDependency dependency : sortedDeps) {
            json.beginObject();
            String name = this.replaceArrow(dependency.getName());
            json.name("name").value(this.replaceArrow(dependency.getName()));
            json.name("description").value(dependency.getDescription());
            json.name("resolvable").value(dependency.getResolutionState().toString());
            json.name("hasConflict").value(!name.equals(dependency.getName()));
            json.name("children");
            this.writeInsightDependencyChildren(dependency, new HashSet<Object>(), configurationName, json);
            json.endObject();
        }
        json.endArray();
    }

    private void writeInsightDependencyChildren(RenderableDependency dependency, Set<Object> visited, String configurationName, JsonWriter json) throws IOException {
        json.beginArray();
        Set<? extends RenderableDependency> children = dependency.getChildren();
        for (RenderableDependency renderableDependency : children) {
            json.beginObject();
            boolean alreadyVisited = !visited.add(renderableDependency.getId());
            boolean leaf = renderableDependency.getChildren().isEmpty();
            boolean alreadyRendered = alreadyVisited && !leaf;
            String childName = this.replaceArrow(renderableDependency.getName());
            boolean hasConflict = !childName.equals(renderableDependency.getName());
            String name = leaf ? configurationName : childName;
            json.name("name").value(name);
            json.name("resolvable").value(renderableDependency.getResolutionState().toString());
            json.name("hasConflict").value(hasConflict);
            json.name("alreadyRendered").value(alreadyRendered);
            json.name("isLeaf").value(leaf);
            json.name("children");
            if (!alreadyRendered) {
                this.writeInsightDependencyChildren(renderableDependency, visited, configurationName, json);
            } else {
                json.beginArray();
                json.endArray();
            }
            json.endObject();
        }
        json.endArray();
    }

    private String replaceArrow(String name) {
        return name.replace(" -> ", " \u27a1 ");
    }
}

