/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.store;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.DynamoDBEncryptor;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.EncryptionContext;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.EncryptionMaterialsProvider;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.WrappedMaterialsProvider;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.store.ProviderStore;
import com.amazonaws.services.dynamodbv2.datamodeling.internal.Utils;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.spec.SecretKeySpec;

public class MetaStore
extends ProviderStore {
    private static final String INTEGRITY_ALGORITHM_FIELD = "intAlg";
    private static final String INTEGRITY_KEY_FIELD = "int";
    private static final String ENCRYPTION_ALGORITHM_FIELD = "encAlg";
    private static final String ENCRYPTION_KEY_FIELD = "enc";
    private static final Pattern COMBINED_PATTERN = Pattern.compile("([^#]+)#(\\d*)");
    private static final String DEFAULT_INTEGRITY = "HmacSHA256";
    private static final String DEFAULT_ENCRYPTION = "AES";
    private static final String MATERIAL_TYPE_VERSION = "t";
    private static final String META_ID = "amzn-ddb-meta-id";
    private static final String DEFAULT_HASH_KEY = "N";
    private static final String DEFAULT_RANGE_KEY = "V";
    private static final EmptyExtraDataSupplier EMPTY_EXTRA_DATA_SUPPLIER = new EmptyExtraDataSupplier();
    private static final Set<String> ENCRYPTED_FIELDS;
    private final Map<String, ExpectedAttributeValue> doesNotExist;
    private final Set<String> doNotEncrypt;
    private final String tableName;
    private final AmazonDynamoDB ddb;
    private final DynamoDBEncryptor encryptor;
    private final EncryptionContext ddbCtx;
    private final ExtraDataSupplier extraDataSupplier;

    public MetaStore(AmazonDynamoDB ddb, String tableName, DynamoDBEncryptor encryptor) {
        this(ddb, tableName, encryptor, EMPTY_EXTRA_DATA_SUPPLIER);
    }

    public MetaStore(AmazonDynamoDB ddb, String tableName, DynamoDBEncryptor encryptor, ExtraDataSupplier extraDataSupplier) {
        this.ddb = MetaStore.checkNotNull(ddb, "ddb must not be null");
        this.tableName = MetaStore.checkNotNull(tableName, "tableName must not be null");
        this.encryptor = MetaStore.checkNotNull(encryptor, "encryptor must not be null");
        this.extraDataSupplier = MetaStore.checkNotNull(extraDataSupplier, "extraDataSupplier must not be null");
        this.ddbCtx = new EncryptionContext.Builder().withTableName(this.tableName).withHashKeyName(DEFAULT_HASH_KEY).withRangeKeyName(DEFAULT_RANGE_KEY).build();
        HashMap<String, ExpectedAttributeValue> tmpExpected = new HashMap<String, ExpectedAttributeValue>();
        tmpExpected.put(DEFAULT_HASH_KEY, new ExpectedAttributeValue().withExists(Boolean.valueOf(false)));
        tmpExpected.put(DEFAULT_RANGE_KEY, new ExpectedAttributeValue().withExists(Boolean.valueOf(false)));
        this.doesNotExist = Collections.unmodifiableMap(tmpExpected);
        this.doNotEncrypt = MetaStore.getSignedOnlyFields(extraDataSupplier);
    }

    @Override
    public EncryptionMaterialsProvider getProvider(String materialName, long version) {
        Map<String, AttributeValue> item = this.getMaterialItem(materialName, version);
        return this.decryptProvider(item);
    }

    @Override
    public EncryptionMaterialsProvider getOrCreate(String materialName, long nextId) {
        Map<String, AttributeValue> plaintext = this.createMaterialItem(materialName, nextId);
        Map<String, AttributeValue> ciphertext = this.conditionalPut(this.getEncryptedText(plaintext));
        return this.decryptProvider(ciphertext);
    }

    @Override
    public long getMaxVersion(String materialName) {
        List items = this.ddb.query(new QueryRequest().withTableName(this.tableName).withConsistentRead(Boolean.TRUE).withKeyConditions(Collections.singletonMap(DEFAULT_HASH_KEY, new Condition().withComparisonOperator(ComparisonOperator.EQ).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(materialName)}))).withLimit(Integer.valueOf(1)).withScanIndexForward(Boolean.valueOf(false)).withAttributesToGet(new String[]{DEFAULT_RANGE_KEY})).getItems();
        if (items.isEmpty()) {
            return -1L;
        }
        return Long.parseLong(((AttributeValue)((Map)items.get(0)).get(DEFAULT_RANGE_KEY)).getN());
    }

    @Override
    public long getVersionFromMaterialDescription(Map<String, String> description) {
        Matcher m = COMBINED_PATTERN.matcher(description.get(META_ID));
        if (m.matches()) {
            return Long.parseLong(m.group(2));
        }
        throw new IllegalArgumentException("No meta id found");
    }

    public void replicate(String materialName, long version, MetaStore targetMetaStore) {
        try {
            Map<String, AttributeValue> item = this.getMaterialItem(materialName, version);
            Map<String, AttributeValue> plainText = this.getPlainText(item);
            Map<String, AttributeValue> encryptedText = targetMetaStore.getEncryptedText(plainText);
            PutItemRequest put = new PutItemRequest().withTableName(targetMetaStore.tableName).withItem(encryptedText).withExpected(this.doesNotExist);
            targetMetaStore.ddb.putItem(put);
        }
        catch (ConditionalCheckFailedException conditionalCheckFailedException) {
            // empty catch block
        }
    }

    private Map<String, AttributeValue> getMaterialItem(String materialName, long version) {
        HashMap<String, AttributeValue> ddbKey = new HashMap<String, AttributeValue>();
        ddbKey.put(DEFAULT_HASH_KEY, new AttributeValue().withS(materialName));
        ddbKey.put(DEFAULT_RANGE_KEY, new AttributeValue().withN(Long.toString(version)));
        Map<String, AttributeValue> item = this.ddbGet(ddbKey);
        if (item == null || item.isEmpty()) {
            throw new IndexOutOfBoundsException("No material found: " + materialName + "#" + version);
        }
        return item;
    }

    public static CreateTableResult createTable(AmazonDynamoDB ddb, String tableName, ProvisionedThroughput provisionedThroughput) {
        return ddb.createTable(Arrays.asList(new AttributeDefinition(DEFAULT_HASH_KEY, ScalarAttributeType.S), new AttributeDefinition(DEFAULT_RANGE_KEY, ScalarAttributeType.N)), tableName, Arrays.asList(new KeySchemaElement(DEFAULT_HASH_KEY, KeyType.HASH), new KeySchemaElement(DEFAULT_RANGE_KEY, KeyType.RANGE)), provisionedThroughput);
    }

    private static Set<String> getSignedOnlyFields(ExtraDataSupplier extraDataSupplier) {
        Set<String> signedOnlyFields = extraDataSupplier.getSignedOnlyFieldNames();
        for (String signedOnlyField : signedOnlyFields) {
            if (!ENCRYPTED_FIELDS.contains(signedOnlyField)) continue;
            throw new IllegalArgumentException(signedOnlyField + " must be encrypted");
        }
        HashSet<String> doNotEncryptFields = new HashSet<String>();
        doNotEncryptFields.add(DEFAULT_HASH_KEY);
        doNotEncryptFields.add(DEFAULT_RANGE_KEY);
        doNotEncryptFields.addAll(signedOnlyFields);
        return Collections.unmodifiableSet(doNotEncryptFields);
    }

    private Map<String, AttributeValue> conditionalPut(Map<String, AttributeValue> item) {
        try {
            PutItemRequest put = new PutItemRequest().withTableName(this.tableName).withItem(item).withExpected(this.doesNotExist);
            this.ddb.putItem(put);
            return item;
        }
        catch (ConditionalCheckFailedException ex) {
            HashMap<String, AttributeValue> ddbKey = new HashMap<String, AttributeValue>();
            ddbKey.put(DEFAULT_HASH_KEY, item.get(DEFAULT_HASH_KEY));
            ddbKey.put(DEFAULT_RANGE_KEY, item.get(DEFAULT_RANGE_KEY));
            return this.ddbGet(ddbKey);
        }
    }

    private Map<String, AttributeValue> ddbGet(Map<String, AttributeValue> ddbKey) {
        return this.ddb.getItem(new GetItemRequest().withTableName(this.tableName).withConsistentRead(Boolean.valueOf(true)).withKey(ddbKey)).getItem();
    }

    private Map<String, AttributeValue> createMaterialItem(String materialName, long version) {
        SecretKeySpec encryptionKey = new SecretKeySpec(Utils.getRandom(32), DEFAULT_ENCRYPTION);
        SecretKeySpec integrityKey = new SecretKeySpec(Utils.getRandom(32), DEFAULT_INTEGRITY);
        HashMap<String, AttributeValue> plaintext = new HashMap<String, AttributeValue>();
        plaintext.put(DEFAULT_HASH_KEY, new AttributeValue().withS(materialName));
        plaintext.put(DEFAULT_RANGE_KEY, new AttributeValue().withN(Long.toString(version)));
        plaintext.put(MATERIAL_TYPE_VERSION, new AttributeValue().withS("0"));
        plaintext.put(ENCRYPTION_KEY_FIELD, new AttributeValue().withB(ByteBuffer.wrap(encryptionKey.getEncoded())));
        plaintext.put(ENCRYPTION_ALGORITHM_FIELD, new AttributeValue().withS(encryptionKey.getAlgorithm()));
        plaintext.put(INTEGRITY_KEY_FIELD, new AttributeValue().withB(ByteBuffer.wrap(integrityKey.getEncoded())));
        plaintext.put(INTEGRITY_ALGORITHM_FIELD, new AttributeValue().withS(integrityKey.getAlgorithm()));
        plaintext.putAll(this.extraDataSupplier.getAttributes(materialName, version));
        return plaintext;
    }

    private EncryptionMaterialsProvider decryptProvider(Map<String, AttributeValue> item) {
        SecretKeySpec integrityKey;
        SecretKeySpec encryptionKey;
        String type;
        Map<String, AttributeValue> plaintext = this.getPlainText(item);
        switch (type = plaintext.get(MATERIAL_TYPE_VERSION).getS()) {
            case "0": {
                encryptionKey = new SecretKeySpec(plaintext.get(ENCRYPTION_KEY_FIELD).getB().array(), plaintext.get(ENCRYPTION_ALGORITHM_FIELD).getS());
                integrityKey = new SecretKeySpec(plaintext.get(INTEGRITY_KEY_FIELD).getB().array(), plaintext.get(INTEGRITY_ALGORITHM_FIELD).getS());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported material type: " + type);
            }
        }
        return new WrappedMaterialsProvider((Key)encryptionKey, (Key)encryptionKey, integrityKey, this.buildDescription(plaintext));
    }

    private Map<String, AttributeValue> getPlainText(Map<String, AttributeValue> ciphertext) {
        try {
            return this.encryptor.decryptAllFieldsExcept(ciphertext, this.ddbCtx, this.doNotEncrypt);
        }
        catch (GeneralSecurityException e) {
            throw new AmazonClientException((Throwable)e);
        }
    }

    private Map<String, AttributeValue> getEncryptedText(Map<String, AttributeValue> plaintext) {
        try {
            return this.encryptor.encryptAllFieldsExcept(plaintext, this.ddbCtx, this.doNotEncrypt);
        }
        catch (GeneralSecurityException e) {
            throw new AmazonClientException((Throwable)e);
        }
    }

    private Map<String, String> buildDescription(Map<String, AttributeValue> plaintext) {
        return Collections.singletonMap(META_ID, plaintext.get(DEFAULT_HASH_KEY).getS() + "#" + plaintext.get(DEFAULT_RANGE_KEY).getN());
    }

    private static <V> V checkNotNull(V ref, String errMsg) {
        if (ref == null) {
            throw new NullPointerException(errMsg);
        }
        return ref;
    }

    static {
        HashSet<String> tempEncryptedFields = new HashSet<String>();
        tempEncryptedFields.add(MATERIAL_TYPE_VERSION);
        tempEncryptedFields.add(ENCRYPTION_KEY_FIELD);
        tempEncryptedFields.add(ENCRYPTION_ALGORITHM_FIELD);
        tempEncryptedFields.add(INTEGRITY_KEY_FIELD);
        tempEncryptedFields.add(INTEGRITY_ALGORITHM_FIELD);
        ENCRYPTED_FIELDS = tempEncryptedFields;
    }

    private static class EmptyExtraDataSupplier
    implements ExtraDataSupplier {
        private EmptyExtraDataSupplier() {
        }

        @Override
        public Map<String, AttributeValue> getAttributes(String materialName, long version) {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> getSignedOnlyFieldNames() {
            return Collections.emptySet();
        }
    }

    public static interface ExtraDataSupplier {
        public Map<String, AttributeValue> getAttributes(String var1, long var2);

        public Set<String> getSignedOnlyFieldNames();
    }
}

