/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.opensearch.Version;
import org.opensearch.common.SetOnce;
import org.opensearch.common.network.NetworkModule;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.PageCacheRecycler;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.http.HttpServerTransport;
import org.opensearch.http.HttpTransportSettings;
import org.opensearch.http.netty4.Netty4CompositeHttpServerTransport;
import org.opensearch.http.netty4.Netty4Http3ServerTransport;
import org.opensearch.http.netty4.Netty4HttpServerTransport;
import org.opensearch.http.netty4.http3.Http3Utils;
import org.opensearch.http.netty4.ssl.SecureNetty4HttpServerTransport;
import org.opensearch.plugins.NetworkPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SecureHttpTransportSettingsProvider;
import org.opensearch.plugins.SecureTransportSettingsProvider;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.SharedGroupFactory;
import org.opensearch.transport.Transport;
import org.opensearch.transport.netty4.Netty4Transport;
import org.opensearch.transport.netty4.ssl.SecureNetty4Transport;

public class Netty4ModulePlugin
extends Plugin
implements NetworkPlugin {
    public static final String NETTY_TRANSPORT_NAME = "netty4";
    public static final String NETTY_SECURE_TRANSPORT_NAME = "netty4-secure";
    public static final String NETTY_HTTP_TRANSPORT_NAME = "netty4";
    public static final String NETTY_SECURE_HTTP_TRANSPORT_NAME = "netty4-secure";
    private final SetOnce<SharedGroupFactory> groupFactory = new SetOnce();

    public List<Setting<?>> getSettings() {
        return Arrays.asList(Netty4HttpServerTransport.SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS, Netty4HttpServerTransport.SETTING_HTTP_WORKER_COUNT, Netty4HttpServerTransport.SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE, Netty4Transport.WORKER_COUNT, Netty4Transport.NETTY_RECEIVE_PREDICTOR_SIZE, Netty4Transport.NETTY_RECEIVE_PREDICTOR_MIN, Netty4Transport.NETTY_RECEIVE_PREDICTOR_MAX, Netty4Transport.NETTY_BOSS_COUNT);
    }

    public Settings additionalSettings() {
        return Settings.builder().put(NetworkModule.HTTP_DEFAULT_TYPE_SETTING.getKey(), "netty4").put(NetworkModule.TRANSPORT_DEFAULT_TYPE_SETTING.getKey(), "netty4").build();
    }

    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService, Tracer tracer) {
        return Collections.singletonMap("netty4", () -> new Netty4Transport(settings, Version.CURRENT, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, this.getSharedGroupFactory(settings), tracer));
    }

    public Map<String, Supplier<HttpServerTransport>> getHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, Tracer tracer) {
        return Collections.singletonMap("netty4", () -> new Netty4HttpServerTransport(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher, clusterSettings, this.getSharedGroupFactory(settings), tracer));
    }

    public Map<String, Supplier<HttpServerTransport>> getSecureHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, SecureHttpTransportSettingsProvider secureHttpTransportSettingsProvider, Tracer tracer) {
        if (Http3Utils.isHttp3Available() && ((Boolean)HttpTransportSettings.SETTING_HTTP_HTTP3_ENABLED.get(settings)).booleanValue()) {
            return Collections.singletonMap("netty4-secure", () -> new Netty4CompositeHttpServerTransport(new SecureNetty4HttpServerTransport(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher, clusterSettings, this.getSharedGroupFactory(settings), secureHttpTransportSettingsProvider, tracer), new Netty4Http3ServerTransport(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher, clusterSettings, this.getSharedGroupFactory(settings), secureHttpTransportSettingsProvider, tracer)));
        }
        return Collections.singletonMap("netty4-secure", () -> new SecureNetty4HttpServerTransport(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher, clusterSettings, this.getSharedGroupFactory(settings), secureHttpTransportSettingsProvider, tracer));
    }

    public Map<String, Supplier<Transport>> getSecureTransports(Settings settings, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService, SecureTransportSettingsProvider secureTransportSettingsProvider, Tracer tracer) {
        return Collections.singletonMap("netty4-secure", () -> new SecureNetty4Transport(settings, Version.CURRENT, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, this.getSharedGroupFactory(settings), secureTransportSettingsProvider, tracer));
    }

    SharedGroupFactory getSharedGroupFactory(Settings settings) {
        SharedGroupFactory groupFactory = (SharedGroupFactory)this.groupFactory.get();
        if (groupFactory != null) {
            assert (groupFactory.getSettings().equals((Object)settings)) : "Different settings than originally provided";
            return groupFactory;
        }
        this.groupFactory.set((Object)new SharedGroupFactory(settings));
        return (SharedGroupFactory)this.groupFactory.get();
    }
}

