/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.ViewExpanders;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Holder;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensearch.sql.analysis.DataSourceSchemaIdentifierNameResolver;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.AstNodeUtils;
import org.opensearch.sql.ast.EmptySourcePropagateVisitor;
import org.opensearch.sql.ast.analysis.FieldResolutionResult;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.expression.AggregateFunction;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.AllFields;
import org.opensearch.sql.ast.expression.AllFieldsExcludeMeta;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Function;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.Map;
import org.opensearch.sql.ast.expression.ParseMethod;
import org.opensearch.sql.ast.expression.PatternMethod;
import org.opensearch.sql.ast.expression.PatternMode;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.Span;
import org.opensearch.sql.ast.expression.SpanUnit;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.expression.WindowFrame;
import org.opensearch.sql.ast.expression.WindowFunction;
import org.opensearch.sql.ast.tree.AD;
import org.opensearch.sql.ast.tree.AddColTotals;
import org.opensearch.sql.ast.tree.AddTotals;
import org.opensearch.sql.ast.tree.Aggregation;
import org.opensearch.sql.ast.tree.Append;
import org.opensearch.sql.ast.tree.AppendCol;
import org.opensearch.sql.ast.tree.AppendPipe;
import org.opensearch.sql.ast.tree.Bin;
import org.opensearch.sql.ast.tree.Chart;
import org.opensearch.sql.ast.tree.CloseCursor;
import org.opensearch.sql.ast.tree.Dedupe;
import org.opensearch.sql.ast.tree.Eval;
import org.opensearch.sql.ast.tree.Expand;
import org.opensearch.sql.ast.tree.FetchCursor;
import org.opensearch.sql.ast.tree.FillNull;
import org.opensearch.sql.ast.tree.Filter;
import org.opensearch.sql.ast.tree.Flatten;
import org.opensearch.sql.ast.tree.Head;
import org.opensearch.sql.ast.tree.Join;
import org.opensearch.sql.ast.tree.Kmeans;
import org.opensearch.sql.ast.tree.Lookup;
import org.opensearch.sql.ast.tree.ML;
import org.opensearch.sql.ast.tree.Multisearch;
import org.opensearch.sql.ast.tree.MvCombine;
import org.opensearch.sql.ast.tree.Paginate;
import org.opensearch.sql.ast.tree.Parse;
import org.opensearch.sql.ast.tree.Patterns;
import org.opensearch.sql.ast.tree.Project;
import org.opensearch.sql.ast.tree.RareTopN;
import org.opensearch.sql.ast.tree.Regex;
import org.opensearch.sql.ast.tree.Relation;
import org.opensearch.sql.ast.tree.Rename;
import org.opensearch.sql.ast.tree.Replace;
import org.opensearch.sql.ast.tree.ReplacePair;
import org.opensearch.sql.ast.tree.Reverse;
import org.opensearch.sql.ast.tree.Rex;
import org.opensearch.sql.ast.tree.SPath;
import org.opensearch.sql.ast.tree.Search;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.ast.tree.StreamWindow;
import org.opensearch.sql.ast.tree.SubqueryAlias;
import org.opensearch.sql.ast.tree.TableFunction;
import org.opensearch.sql.ast.tree.Transpose;
import org.opensearch.sql.ast.tree.Trendline;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.ast.tree.Values;
import org.opensearch.sql.ast.tree.Window;
import org.opensearch.sql.calcite.CalciteAggCallVisitor;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.CalciteRexNodeVisitor;
import org.opensearch.sql.calcite.DynamicFieldsHelper;
import org.opensearch.sql.calcite.ExtendedRexBuilder;
import org.opensearch.sql.calcite.SchemaUnifier;
import org.opensearch.sql.calcite.plan.AliasFieldsWrappable;
import org.opensearch.sql.calcite.plan.OpenSearchConstants;
import org.opensearch.sql.calcite.plan.rel.LogicalSystemLimit;
import org.opensearch.sql.calcite.plan.rule.PPLDedupConvertRule;
import org.opensearch.sql.calcite.utils.BinUtils;
import org.opensearch.sql.calcite.utils.CalciteToolsHelper;
import org.opensearch.sql.calcite.utils.JoinAndLookupUtils;
import org.opensearch.sql.calcite.utils.PPLHintUtils;
import org.opensearch.sql.calcite.utils.PlanUtils;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.calcite.utils.WildcardUtils;
import org.opensearch.sql.common.patterns.PatternUtils;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.exception.CalciteUnsupportedException;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.PPLFuncImpTable;
import org.opensearch.sql.expression.parse.RegexCommonUtils;
import org.opensearch.sql.utils.ParseUtils;
import org.opensearch.sql.utils.WildcardRenameUtils;

public class CalciteRelNodeVisitor
extends AbstractNodeVisitor<RelNode, CalcitePlanContext> {
    private final CalciteRexNodeVisitor rexVisitor = new CalciteRexNodeVisitor(this);
    private final CalciteAggCallVisitor aggVisitor = new CalciteAggCallVisitor(this.rexVisitor);
    private final DataSourceService dataSourceService;
    private static final String REVERSE_ROW_NUM = "__reverse_row_num__";

    public CalciteRelNodeVisitor(DataSourceService dataSourceService) {
        this.dataSourceService = dataSourceService;
    }

    public RelNode analyze(UnresolvedPlan unresolved, CalcitePlanContext context) {
        return unresolved.accept(this, context);
    }

    @Override
    public RelNode visitRelation(Relation node, CalcitePlanContext context) {
        DataSourceSchemaIdentifierNameResolver nameResolver = new DataSourceSchemaIdentifierNameResolver(this.dataSourceService, node.getTableQualifiedName().getParts());
        if (!nameResolver.getDataSourceName().equals("@opensearch")) {
            throw new CalciteUnsupportedException("Datasource " + nameResolver.getDataSourceName() + " is unsupported in Calcite");
        }
        if (nameResolver.getIdentifierName().equals(".DATASOURCES")) {
            throw new CalciteUnsupportedException("SHOW DATASOURCES is unsupported in Calcite");
        }
        if (nameResolver.getSchemaName().equals("information_schema")) {
            throw new CalciteUnsupportedException("information_schema is unsupported in Calcite");
        }
        context.relBuilder.scan(node.getTableQualifiedName().getParts());
        RelNode scan = context.relBuilder.peek();
        if (scan instanceof AliasFieldsWrappable) {
            return ((AliasFieldsWrappable)scan).wrapProjectForAliasFields(context.relBuilder);
        }
        return scan;
    }

    private RelBuilder scan(RelOptTable tableSchema, CalcitePlanContext context) {
        RelNode scan = context.relBuilder.getScanFactory().createScan(ViewExpanders.simpleContext((RelOptCluster)context.relBuilder.getCluster()), tableSchema);
        context.relBuilder.push(scan);
        return context.relBuilder;
    }

    @Override
    public RelNode visitSearch(Search node, CalcitePlanContext context) {
        node.getChild().get(0).accept(this, context);
        Function queryStringFunc = AstDSL.function("query_string", AstDSL.unresolvedArg("query", AstDSL.stringLiteral(node.getQueryString())));
        RexNode queryStringRex = this.rexVisitor.analyze(queryStringFunc, context);
        context.relBuilder.filter(new RexNode[]{queryStringRex});
        return context.relBuilder.peek();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public RelNode visitFilter(Filter node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        boolean containsSubqueryExpression = AstNodeUtils.containsSubqueryExpression(node.getCondition());
        @Nullable Holder v = Holder.empty();
        if (containsSubqueryExpression) {
            context.relBuilder.variable(arg_0 -> ((Holder)v).set(arg_0));
            context.pushCorrelVar((RexCorrelVariable)v.get());
        }
        RexNode condition = this.rexVisitor.analyze(node.getCondition(), context);
        if (containsSubqueryExpression) {
            context.relBuilder.filter((Iterable)ImmutableList.of((Object)((RexCorrelVariable)v.get()).id), new RexNode[]{condition});
            context.popCorrelVar();
        } else {
            context.relBuilder.filter(new RexNode[]{condition});
        }
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitAppendPipe(AppendPipe node, CalcitePlanContext context) {
        UnresolvedPlan subqueryPlan;
        this.visitChildren(node, context);
        UnresolvedPlan childNode = subqueryPlan = node.getSubQuery();
        while (childNode.getChild() != null && !childNode.getChild().isEmpty() && !(childNode.getChild().getFirst() instanceof Values)) {
            if (childNode.getChild().size() > 1) {
                throw new RuntimeException("AppendPipe doesn't support multiply children subquery.");
            }
            childNode = (UnresolvedPlan)childNode.getChild().getFirst();
        }
        childNode.attach(node.getChild().getFirst());
        subqueryPlan.accept(this, context);
        RelNode subPipelineNode = context.relBuilder.build();
        RelNode mainNode = context.relBuilder.build();
        return this.mergeTableAndResolveColumnConflict(mainNode, subPipelineNode, context);
    }

    @Override
    public RelNode visitRegex(Regex node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        RexNode fieldRex = this.rexVisitor.analyze(node.getField(), context);
        RexNode patternRex = this.rexVisitor.analyze(node.getPattern(), context);
        if (!SqlTypeFamily.CHARACTER.contains(fieldRex.getType())) {
            throw new IllegalArgumentException(String.format("Regex command requires field of string type, but got %s for field '%s'", fieldRex.getType().getSqlTypeName(), node.getField().toString()));
        }
        RexNode regexCondition = context.rexBuilder.makeCall((SqlOperator)SqlLibraryOperators.REGEXP_CONTAINS, new RexNode[]{fieldRex, patternRex});
        if (node.isNegated()) {
            regexCondition = context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{regexCondition});
        }
        context.relBuilder.filter(new RexNode[]{regexCondition});
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitRex(Rex node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        RexNode fieldRex = this.rexVisitor.analyze(node.getField(), context);
        String patternStr = (String)node.getPattern().getValue();
        if (node.getMode() == Rex.RexMode.SED) {
            RexNode sedCall = this.createOptimizedSedCall(fieldRex, patternStr, context);
            String fieldName = node.getField().toString();
            this.projectPlusOverriding(List.of(sedCall), List.of(fieldName), context);
            return context.relBuilder.peek();
        }
        List<String> namedGroups = RegexCommonUtils.getNamedGroupCandidates(patternStr);
        if (namedGroups.isEmpty()) {
            throw new IllegalArgumentException("Rex pattern must contain at least one named capture group");
        }
        ArrayList<RexNode> newFields = new ArrayList<RexNode>();
        ArrayList<String> newFieldNames = new ArrayList<String>();
        for (String groupName : namedGroups) {
            RexNode extractCall = node.getMaxMatch().isPresent() && node.getMaxMatch().get() > 1 ? PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.REX_EXTRACT_MULTI, new RexNode[]{fieldRex, context.rexBuilder.makeLiteral(patternStr), context.rexBuilder.makeLiteral(groupName), context.relBuilder.literal(node.getMaxMatch().get())}) : PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.REX_EXTRACT, new RexNode[]{fieldRex, context.rexBuilder.makeLiteral(patternStr), context.rexBuilder.makeLiteral(groupName)});
            newFields.add(extractCall);
            newFieldNames.add(groupName);
        }
        if (node.getOffsetField().isPresent()) {
            RexNode offsetCall = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.REX_OFFSET, new RexNode[]{fieldRex, context.rexBuilder.makeLiteral(patternStr)});
            newFields.add(offsetCall);
            newFieldNames.add(node.getOffsetField().get());
        }
        this.projectPlusOverriding(newFields, newFieldNames, context);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitProject(Project node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        if (this.isSingleAllFieldsProject(node)) {
            return this.handleAllFieldsProject(node, context);
        }
        if (DynamicFieldsHelper.isDynamicFieldsExists(context)) {
            this.rejectWildcardNotAtTheEnd(node);
        }
        List currentFields = context.relBuilder.peek().getRowType().getFieldNames();
        List<RexNode> expandedFields = this.expandProjectFields(node.getProjectList(), currentFields, context);
        if (node.isExcluded()) {
            this.validateExclusion(expandedFields, currentFields);
            context.relBuilder.projectExcept(expandedFields);
        } else {
            if (!context.isResolvingSubquery()) {
                context.setProjectVisited(true);
            }
            context.relBuilder.project(expandedFields);
        }
        return context.relBuilder.peek();
    }

    private void rejectWildcardNotAtTheEnd(Project node) {
        List<UnresolvedExpression> list = node.getProjectList();
        for (int i = 0; i < list.size() - 1; ++i) {
            if (!(list.get(i) instanceof AllFields)) continue;
            throw new IllegalArgumentException("Wildcard can be placed only at the end of the fields list (limit of spath command).");
        }
    }

    private boolean isSingleAllFieldsProject(Project node) {
        return node.getProjectList().size() == 1 && node.getProjectList().getFirst() instanceof AllFields;
    }

    private RelNode handleAllFieldsProject(Project node, CalcitePlanContext context) {
        if (node.isExcluded()) {
            throw new IllegalArgumentException("Invalid field exclusion: operation would exclude all fields from the result set");
        }
        AllFields allFields = (AllFields)node.getProjectList().getFirst();
        if (!(allFields instanceof AllFieldsExcludeMeta)) {
            CalciteRelNodeVisitor.tryToRemoveNestedFields(context);
        }
        CalciteRelNodeVisitor.tryToRemoveMetaFields(context, allFields instanceof AllFieldsExcludeMeta);
        return context.relBuilder.peek();
    }

    private List<RexNode> expandProjectFields(List<UnresolvedExpression> projectList, List<String> currentFields, CalcitePlanContext context) {
        ArrayList<RexNode> expandedFields = new ArrayList<RexNode>();
        HashSet<String> addedFields = new HashSet<String>();
        block4: for (UnresolvedExpression expr : projectList) {
            UnresolvedExpression unresolvedExpression;
            Objects.requireNonNull(expr);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Field.class, AllFields.class}, (Object)unresolvedExpression, n)) {
                case 0: {
                    Field field2 = (Field)unresolvedExpression;
                    String fieldName = field2.getField().toString();
                    if (WildcardUtils.containsWildcard(fieldName)) {
                        List<String> matchingFields = WildcardUtils.expandWildcardPattern(fieldName, currentFields).stream().filter(f -> !CalciteRelNodeVisitor.isMetadataField(f) && !f.equals("_MAP")).filter(addedFields::add).toList();
                        if (matchingFields.isEmpty()) continue block4;
                        matchingFields.forEach(f -> expandedFields.add((RexNode)context.relBuilder.field((String)f)));
                        break;
                    }
                    if (!addedFields.add(fieldName)) continue block4;
                    expandedFields.add(this.rexVisitor.analyze(field2, context));
                    break;
                }
                case 1: {
                    AllFields ignored = (AllFields)unresolvedExpression;
                    currentFields.stream().filter(field -> !CalciteRelNodeVisitor.isMetadataField(field)).filter(addedFields::add).forEach(field -> expandedFields.add((RexNode)context.relBuilder.field((String)field)));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected expression type in project list: " + expr.getClass().getSimpleName());
                }
            }
        }
        if (expandedFields.isEmpty()) {
            this.validateWildcardPatterns(projectList, currentFields);
        }
        return expandedFields;
    }

    private void validateExclusion(List<RexNode> fieldsToExclude, List<String> currentFields) {
        Set nonMetaFields = currentFields.stream().filter(field -> !CalciteRelNodeVisitor.isMetadataField(field)).collect(Collectors.toSet());
        if (fieldsToExclude.size() >= nonMetaFields.size()) {
            throw new IllegalArgumentException("Invalid field exclusion: operation would exclude all fields from the result set");
        }
    }

    private void validateWildcardPatterns(List<UnresolvedExpression> projectList, List<String> currentFields) {
        String firstWildcardPattern = projectList.stream().filter(expr -> {
            Field field;
            return expr instanceof Field && WildcardUtils.containsWildcard((field = (Field)expr).getField().toString());
        }).map(expr -> ((Field)expr).getField().toString()).findFirst().orElse(null);
        if (firstWildcardPattern != null) {
            throw new IllegalArgumentException(String.format("wildcard pattern [%s] matches no fields", firstWildcardPattern));
        }
    }

    private static boolean isMetadataField(String fieldName) {
        return OpenSearchConstants.METADATAFIELD_TYPE_MAP.containsKey(fieldName);
    }

    private static void tryToRemoveNestedFields(CalcitePlanContext context) {
        HashSet allFields = new HashSet(context.relBuilder.peek().getRowType().getFieldNames());
        List<RexNode> duplicatedNestedFields = allFields.stream().filter(field -> {
            int lastDot = field.lastIndexOf(".");
            return -1 != lastDot && allFields.contains(field.substring(0, lastDot));
        }).map(field -> context.relBuilder.field((String)field)).toList();
        if (!duplicatedNestedFields.isEmpty()) {
            CalciteRelNodeVisitor.forceProjectExcept(context.relBuilder, duplicatedNestedFields);
        }
    }

    private static void forceProjectExcept(RelBuilder relBuilder, Iterable<RexNode> expressions) {
        ArrayList allExpressions = new ArrayList(relBuilder.fields());
        HashSet<RexNode> excludeExpressions = new HashSet<RexNode>();
        for (RexNode excludeExp : expressions) {
            if (!excludeExpressions.add(excludeExp)) {
                throw new IllegalArgumentException("Input list contains duplicates. Expression " + String.valueOf(excludeExp) + " exists multiple times.");
            }
            if (allExpressions.remove(excludeExp)) continue;
            throw new IllegalArgumentException("Expression " + excludeExp.toString() + " not found.");
        }
        relBuilder.project(allExpressions, (Iterable)ImmutableList.of(), true);
    }

    private static void tryToRemoveMetaFields(CalcitePlanContext context, boolean excludeByForce) {
        if (excludeByForce || !context.isProjectVisited()) {
            List originalFields = context.relBuilder.peek().getRowType().getFieldNames();
            List<RexNode> metaFieldsRef = originalFields.stream().filter(OpenSearchConstants.METADATAFIELD_TYPE_MAP::containsKey).map(metaField -> context.relBuilder.field((String)metaField)).toList();
            if (!metaFieldsRef.isEmpty() && metaFieldsRef.size() != originalFields.size()) {
                context.relBuilder.projectExcept(metaFieldsRef);
            }
        }
    }

    @Override
    public RelNode visitRename(Rename node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List originalNames = context.relBuilder.peek().getRowType().getFieldNames();
        ArrayList<String> newNames = new ArrayList<String>(originalNames);
        for (Map renameMap : node.getRenameList()) {
            if (!(renameMap.getTarget() instanceof Field)) {
                throw new SemanticCheckException(String.format("the target expected to be field, but is %s", renameMap.getTarget()));
            }
            String sourcePattern = ((Field)renameMap.getOrigin()).getField().toString();
            String targetPattern = ((Field)renameMap.getTarget()).getField().toString();
            if (WildcardRenameUtils.isWildcardPattern(sourcePattern) && !WildcardRenameUtils.validatePatternCompatibility(sourcePattern, targetPattern)) {
                throw new SemanticCheckException("Source and target patterns have different wildcard counts");
            }
            List<String> matchingFields = WildcardRenameUtils.matchFieldNames(sourcePattern, newNames);
            for (String fieldName : matchingFields) {
                int fieldIndex;
                String newName = WildcardRenameUtils.applyWildcardTransformation(sourcePattern, targetPattern, fieldName);
                if (newNames.contains(newName) && !newName.equals(fieldName)) {
                    this.removeFieldIfExists(newName, newNames, context);
                }
                if ((fieldIndex = newNames.indexOf(fieldName)) == -1) continue;
                newNames.set(fieldIndex, newName);
            }
            if (!matchingFields.isEmpty() || !newNames.contains(targetPattern)) continue;
            this.removeFieldIfExists(targetPattern, newNames, context);
            context.relBuilder.rename(newNames);
        }
        context.relBuilder.rename(newNames);
        return context.relBuilder.peek();
    }

    private void removeFieldIfExists(String fieldName, List<String> newNames, CalcitePlanContext context) {
        newNames.remove(fieldName);
        context.relBuilder.projectExcept(new RexNode[]{context.relBuilder.field(fieldName)});
    }

    @Override
    public RelNode visitSort(Sort node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List sortList = node.getSortList().stream().map(expr -> {
            RexNode sortField = this.rexVisitor.analyze((UnresolvedExpression)expr, context);
            Sort.SortOption sortOption = this.analyzeSortOption(expr.getFieldArgs());
            if (sortOption.getSortOrder() == Sort.SortOrder.DESC) {
                sortField = context.relBuilder.desc(sortField);
            }
            sortField = sortOption.getNullOrder() == Sort.NullOrder.NULL_LAST ? context.relBuilder.nullsLast(sortField) : context.relBuilder.nullsFirst(sortField);
            return sortField;
        }).collect(Collectors.toList());
        context.relBuilder.sort(sortList);
        if (node.getCount() != 0) {
            context.relBuilder.limit(0, node.getCount());
        }
        return context.relBuilder.peek();
    }

    private Sort.SortOption analyzeSortOption(List<Argument> fieldArgs) {
        Boolean asc = (Boolean)fieldArgs.get(0).getValue().getValue();
        Optional<Argument> nullFirst = fieldArgs.stream().filter(option -> "nullFirst".equals(option.getArgName())).findFirst();
        if (nullFirst.isPresent()) {
            Boolean isNullFirst = (Boolean)nullFirst.get().getValue().getValue();
            return new Sort.SortOption(asc != false ? Sort.SortOrder.ASC : Sort.SortOrder.DESC, isNullFirst != false ? Sort.NullOrder.NULL_FIRST : Sort.NullOrder.NULL_LAST);
        }
        return asc != false ? Sort.SortOption.DEFAULT_ASC : Sort.SortOption.DEFAULT_DESC;
    }

    @Override
    public RelNode visitHead(Head node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        context.relBuilder.limit(node.getFrom(), node.getSize());
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitReverse(Reverse node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        RexNode rowNumber = context.relBuilder.aggregateCall((SqlAggFunction)SqlStdOperatorTable.ROW_NUMBER, new RexNode[0]).over().rowsTo(RexWindowBounds.CURRENT_ROW).as(REVERSE_ROW_NUM);
        context.relBuilder.projectPlus(new RexNode[]{rowNumber});
        context.relBuilder.sort(new RexNode[]{context.relBuilder.desc((RexNode)context.relBuilder.field(REVERSE_ROW_NUM))});
        context.relBuilder.projectExcept(new RexNode[]{context.relBuilder.field(REVERSE_ROW_NUM)});
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitTranspose(Transpose node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        int maxRows = Optional.ofNullable(node.getMaxRows()).filter(r -> r > 0).orElseThrow(() -> new IllegalArgumentException("maxRows must be positive"));
        String columnName = node.getColumnName();
        List<String> fieldNames = context.relBuilder.peek().getRowType().getFieldNames().stream().filter(fieldName -> !CalciteRelNodeVisitor.isMetadataField(fieldName)).toList();
        CalciteToolsHelper.OpenSearchRelBuilder b = context.relBuilder;
        ExtendedRexBuilder rx = context.rexBuilder;
        RelDataType varchar = rx.getTypeFactory().createSqlType(SqlTypeName.VARCHAR);
        b.projectPlus(new RexNode[]{b.aggregateCall((SqlAggFunction)SqlStdOperatorTable.ROW_NUMBER, new RexNode[0]).over().rowsTo(RexWindowBounds.CURRENT_ROW).as("_row_number_transpose_")});
        b.unpivot(false, (Iterable)ImmutableList.of((Object)"value"), (Iterable)ImmutableList.of((Object)columnName), fieldNames.stream().map(f -> java.util.Map.entry(ImmutableList.of((Object)rx.makeLiteral((String)f)), ImmutableList.of((Object)rx.makeCast(varchar, (RexNode)b.field((String)f), true)))).collect(Collectors.toList()));
        RexNode trimmedColumnName = context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{context.rexBuilder.makeFlag((Enum)SqlTrimFunction.Flag.BOTH), context.rexBuilder.makeLiteral(" "), b.field(columnName)});
        b.pivot(b.groupKey(new RexNode[]{trimmedColumnName}), (Iterable)ImmutableList.of((Object)b.max((RexNode)b.field("value"))), (Iterable)ImmutableList.of((Object)b.field("_row_number_transpose_")), IntStream.rangeClosed(1, maxRows).mapToObj(i -> java.util.Map.entry("row " + i, ImmutableList.of((Object)b.literal(i)))).collect(Collectors.toList()));
        ArrayList<Object> cleanNames = new ArrayList<Object>();
        cleanNames.add(columnName);
        for (int i2 = 1; i2 <= maxRows; ++i2) {
            cleanNames.add("row " + i2);
        }
        b.rename(cleanNames);
        return b.peek();
    }

    @Override
    public RelNode visitBin(Bin node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        RexNode fieldExpr = this.rexVisitor.analyze(node.getField(), context);
        String fieldName = BinUtils.extractFieldName(node);
        RexNode binExpression = BinUtils.createBinExpression(node, fieldExpr, context, this.rexVisitor);
        String alias = node.getAlias() != null ? node.getAlias() : fieldName;
        this.projectPlusOverriding(List.of(binExpression), List.of(alias), context);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitParse(Parse node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        this.buildParseRelNode(node, context);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitSpath(SPath node, CalcitePlanContext context) {
        if (node.getPath() != null) {
            return this.visitEval(node.rewriteAsEval(), context);
        }
        return this.spathExtractAll(node, context);
    }

    private RelNode spathExtractAll(SPath node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        FieldResolutionResult resolutionResult = context.resolveFields(node);
        RexNode inField = this.rexVisitor.analyze(AstDSL.field(node.getInField()), context);
        RexNode map = context.rexBuilder.makeCall(BuiltinFunctionName.JSON_EXTRACT_ALL, inField);
        HashSet<String> existingFields = new HashSet<String>(DynamicFieldsHelper.getStaticFields(context));
        List<String> sortedRegularFieldNames = resolutionResult.getRegularFields().stream().sorted().collect(Collectors.toList());
        List<RexNode> fields = DynamicFieldsHelper.buildRegularFieldProjections(map, sortedRegularFieldNames, existingFields, context);
        if (resolutionResult.hasWildcards()) {
            RexNode dynamicMapField = DynamicFieldsHelper.buildDynamicMapFieldProjection(map, sortedRegularFieldNames, existingFields, context);
            fields.add(context.relBuilder.alias(dynamicMapField, "_MAP"));
        }
        context.relBuilder.project(fields);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitPatterns(Patterns node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        RexNode showNumberedTokenExpr = this.rexVisitor.analyze(node.getShowNumberedToken(), context);
        Boolean showNumberedToken = Boolean.TRUE.equals(((RexLiteral)showNumberedTokenExpr).getValueAs(Boolean.class));
        if (PatternMethod.SIMPLE_PATTERN.equals((Object)node.getPatternMethod())) {
            Parse parseNode = new Parse(ParseMethod.PATTERNS, node.getSourceField(), node.getArguments().getOrDefault("pattern", AstDSL.stringLiteral("")), node.getArguments());
            this.buildParseRelNode(parseNode, context);
            if (PatternMode.AGGREGATION.equals((Object)node.getPatternMode())) {
                Field patternField = AstDSL.field(node.getAlias());
                List<RelBuilder.AggCall> aggCalls = Stream.of(new Alias("pattern_count", new AggregateFunction(BuiltinFunctionName.COUNT.name(), patternField)), new Alias("sample_logs", new AggregateFunction(BuiltinFunctionName.TAKE.name(), node.getSourceField(), (List<UnresolvedExpression>)ImmutableList.of((Object)node.getPatternMaxSampleCount())))).map(aggFun -> this.aggVisitor.analyze((UnresolvedExpression)aggFun, context)).toList();
                ArrayList<RexNode> groupByList = new ArrayList<RexNode>();
                groupByList.add(this.rexVisitor.analyze(patternField, context));
                groupByList.addAll(node.getPartitionByList().stream().map(expr -> this.rexVisitor.analyze((UnresolvedExpression)expr, context)).toList());
                context.relBuilder.aggregate(context.relBuilder.groupKey(groupByList), aggCalls);
                if (showNumberedToken.booleanValue()) {
                    RexNode parsedNode = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_PATTERN_PARSER, new RexNode[]{context.relBuilder.field(node.getAlias()), context.relBuilder.field("sample_logs")});
                    this.flattenParsedPattern(node.getAlias(), parsedNode, context, false, true);
                    this.projectPlusOverriding(List.of(context.relBuilder.field(node.getAlias()), context.relBuilder.field("pattern_count"), context.relBuilder.field("tokens"), context.relBuilder.field("sample_logs")), List.of(node.getAlias(), "pattern_count", "tokens", "sample_logs"), context);
                }
            } else if (showNumberedToken.booleanValue()) {
                RexNode parsedNode = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_PATTERN_PARSER, new RexNode[]{context.relBuilder.field(node.getAlias()), this.rexVisitor.analyze(node.getSourceField(), context)});
                this.flattenParsedPattern(node.getAlias(), parsedNode, context, false, true);
            }
        } else {
            ArrayList<UnresolvedExpression> funcParamList = new ArrayList<UnresolvedExpression>();
            funcParamList.add(node.getSourceField());
            funcParamList.add(node.getPatternMaxSampleCount());
            funcParamList.add(node.getPatternBufferLimit());
            funcParamList.add(node.getShowNumberedToken());
            funcParamList.addAll(node.getArguments().entrySet().stream().filter(entry -> PatternUtils.VALID_BRAIN_PARAMETERS.contains(entry.getKey())).map(entry -> new Argument((String)entry.getKey(), (Literal)entry.getValue())).sorted(Comparator.comparing(Argument::getArgName)).toList());
            if (PatternMode.LABEL.equals((Object)node.getPatternMode())) {
                RexNode windowNode = this.rexVisitor.analyze(new WindowFunction(new Function(BuiltinFunctionName.INTERNAL_PATTERN.getName().getFunctionName(), funcParamList), node.getPartitionByList(), List.of()), context);
                RexNode nestedNode = context.relBuilder.alias(PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_PATTERN_PARSER, this.rexVisitor.analyze(node.getSourceField(), context), windowNode, showNumberedTokenExpr), node.getAlias());
                context.relBuilder.projectPlus(new RexNode[]{nestedNode});
                this.flattenParsedPattern(node.getAlias(), (RexNode)context.relBuilder.field(node.getAlias()), context, false, showNumberedToken);
            } else {
                RelBuilder.AggCall aggCall = this.aggVisitor.analyze(new Function(BuiltinFunctionName.INTERNAL_PATTERN.getName().getFunctionName(), funcParamList), context).as(node.getAlias());
                List<RexNode> groupByList = node.getPartitionByList().stream().map(expr -> this.rexVisitor.analyze((UnresolvedExpression)expr, context)).toList();
                context.relBuilder.aggregate(context.relBuilder.groupKey(groupByList), new RelBuilder.AggCall[]{aggCall});
                this.buildExpandRelNode(context.relBuilder.field(node.getAlias()), node.getAlias(), node.getAlias(), context);
                this.flattenParsedPattern(node.getAlias(), (RexNode)context.relBuilder.field(node.getAlias()), context, true, showNumberedToken);
            }
        }
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitEval(Eval node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        node.getExpressionList().forEach(expr -> {
            boolean containsSubqueryExpression = AstNodeUtils.containsSubqueryExpression(expr);
            @Nullable Holder v = Holder.empty();
            if (containsSubqueryExpression) {
                context.relBuilder.variable(arg_0 -> ((Holder)v).set(arg_0));
                context.pushCorrelVar((RexCorrelVariable)v.get());
            }
            RexNode eval = this.rexVisitor.analyze((UnresolvedExpression)expr, context);
            if (containsSubqueryExpression) {
                context.relBuilder.project(Iterables.concat((Iterable)context.relBuilder.fields(), (Iterable)ImmutableList.of((Object)eval)), (Iterable)ImmutableList.of(), false, (Iterable)ImmutableList.of((Object)((RexCorrelVariable)v.get()).id));
                context.popCorrelVar();
            } else {
                String alias = (String)((RexLiteral)((RexCall)eval).getOperands().get(1)).getValueAs(String.class);
                this.projectPlusOverriding(List.of(eval), List.of(alias), context);
            }
        });
        return context.relBuilder.peek();
    }

    private void projectPlusOverriding(List<RexNode> newFields, List<String> newNames, CalcitePlanContext context) {
        List originalFieldNames = context.relBuilder.peek().getRowType().getFieldNames();
        List<RexNode> toOverrideList = originalFieldNames.stream().filter(originalName -> this.shouldOverrideField((String)originalName, newNames)).map(a -> context.relBuilder.field((String)a)).toList();
        context.relBuilder.projectPlus(newFields);
        if (!toOverrideList.isEmpty()) {
            context.relBuilder.projectExcept(toOverrideList);
        }
        List currentFields = context.relBuilder.peek().getRowType().getFieldNames();
        int length = currentFields.size();
        ArrayList<String> expectedRenameFields = new ArrayList<String>(currentFields.subList(0, length - newNames.size()));
        expectedRenameFields.addAll(newNames);
        context.relBuilder.rename(expectedRenameFields);
    }

    private boolean shouldOverrideField(String originalName, List<String> newNames) {
        return newNames.stream().anyMatch(newName -> newName.equals(originalName) || newName.startsWith(originalName + "."));
    }

    private List<List<RexInputRef>> extractInputRefList(List<RelBuilder.AggCall> aggCalls) {
        return aggCalls.stream().map(RelBuilder.AggCall::over).map(RelBuilder.OverCall::toRex).map(node -> PlanUtils.getRexCall(node, this::isCountField)).map(list -> list.isEmpty() ? null : (RexCall)list.getFirst()).map(PlanUtils::getInputRefs).toList();
    }

    private boolean isCountField(RexCall call) {
        return call.isA(SqlKind.COUNT) && call.getOperands().size() == 1 && call.getOperands().get(0) instanceof RexInputRef;
    }

    private Pair<List<RexNode>, List<RelBuilder.AggCall>> aggregateWithTrimming(List<UnresolvedExpression> groupExprList, List<UnresolvedExpression> aggExprList, CalcitePlanContext context, boolean hintIgnoreNullBucket) {
        Pair<List<RexNode>, List<RelBuilder.AggCall>> resolved = this.resolveAttributesForAggregation(groupExprList, aggExprList, context);
        List resolvedGroupByList = (List)resolved.getLeft();
        List resolvedAggCallList = (List)resolved.getRight();
        if (resolvedGroupByList.isEmpty()) {
            List<Object> distinctRefsOfCounts;
            List<List<RexInputRef>> refsPerCount = this.extractInputRefList(resolvedAggCallList);
            RelNode relNode = context.relBuilder.peek();
            if (relNode instanceof org.apache.calcite.rel.core.Project) {
                org.apache.calcite.rel.core.Project project = (org.apache.calcite.rel.core.Project)relNode;
                List<RexNode> mappedInProject = refsPerCount.stream().flatMap(Collection::stream).map(ref -> (RexNode)project.getProjects().get(ref.getIndex())).toList();
                distinctRefsOfCounts = mappedInProject.stream().allMatch(RexInputRef.class::isInstance) ? mappedInProject.stream().map(RexInputRef.class::cast).distinct().toList() : List.of();
            } else {
                distinctRefsOfCounts = refsPerCount.stream().flatMap(Collection::stream).distinct().toList();
            }
            if (distinctRefsOfCounts.size() == 1 && refsPerCount.stream().noneMatch(List::isEmpty)) {
                context.relBuilder.filter(new RexNode[]{context.relBuilder.isNotNull((RexNode)distinctRefsOfCounts.getFirst())});
            }
        }
        ArrayList<RexInputRef> trimmedRefs = new ArrayList<RexInputRef>();
        trimmedRefs.addAll(PlanUtils.getInputRefs(resolvedGroupByList));
        List<RexInputRef> aggCallRefs = PlanUtils.getInputRefsFromAggCall(resolvedAggCallList);
        boolean hintNestedAgg = this.containsNestedAggregator(context.relBuilder, aggCallRefs);
        trimmedRefs.addAll(aggCallRefs);
        context.relBuilder.project(trimmedRefs);
        Pair<List<RexNode>, List<RelBuilder.AggCall>> reResolved = this.resolveAttributesForAggregation(groupExprList, aggExprList, context);
        List<String> intendedGroupKeyAliases = this.getGroupKeyNamesAfterAggregation((List)reResolved.getLeft());
        context.relBuilder.aggregate(context.relBuilder.groupKey((Iterable)reResolved.getLeft()), (Iterable)reResolved.getRight());
        if (hintIgnoreNullBucket) {
            PPLHintUtils.addIgnoreNullBucketHintToAggregate(context.relBuilder);
        }
        if (hintNestedAgg) {
            PPLHintUtils.addNestedAggCallHintToAggregate(context.relBuilder);
        }
        context.relBuilder.rename(intendedGroupKeyAliases);
        return Pair.of((Object)((List)reResolved.getLeft()), (Object)((List)reResolved.getRight()));
    }

    private boolean containsNestedAggregator(RelBuilder relBuilder, List<RexInputRef> aggCallRefs) {
        return aggCallRefs.stream().map(r -> (String)relBuilder.peek().getRowType().getFieldNames().get(r.getIndex())).map(name -> StringUtils.substringBefore((String)name, (String)".")).anyMatch(root -> relBuilder.field(root).getType().getSqlTypeName() == SqlTypeName.ARRAY);
    }

    private List<String> getGroupKeyNamesAfterAggregation(List<RexNode> nodes) {
        ArrayList<Object> reordered = new ArrayList<Object>();
        ArrayList<RexNode> left = new ArrayList<RexNode>();
        for (RexNode n : nodes) {
            if (reordered.contains(n) || left.contains(n)) continue;
            if (this.isInputRef(n)) {
                reordered.add(n);
                continue;
            }
            left.add(n);
        }
        reordered.addAll(left);
        return reordered.stream().map(this::extractAliasLiteral).flatMap(Optional::stream).map(RexLiteral::stringValue).toList();
    }

    private boolean isInputRef(RexNode node) {
        return switch (node.getKind()) {
            case SqlKind.AS, SqlKind.DESCENDING, SqlKind.NULLS_FIRST, SqlKind.NULLS_LAST -> {
                ImmutableList operands = ((RexCall)node).operands;
                yield this.isInputRef((RexNode)operands.getFirst());
            }
            default -> node instanceof RexInputRef;
        };
    }

    private Pair<List<RexNode>, List<RelBuilder.AggCall>> resolveAttributesForAggregation(List<UnresolvedExpression> groupExprList, List<UnresolvedExpression> aggExprList, CalcitePlanContext context) {
        List<RelBuilder.AggCall> aggCallList = aggExprList.stream().map(expr -> this.aggVisitor.analyze((UnresolvedExpression)expr, context)).toList();
        List<RexNode> groupByList = groupExprList.stream().map(expr -> this.rexVisitor.analyze((UnresolvedExpression)expr, context)).toList();
        return Pair.of(groupByList, aggCallList);
    }

    @Override
    public RelNode visitAggregation(Aggregation node, CalcitePlanContext context) {
        Argument.ArgumentMap statsArgs = Argument.ArgumentMap.of(node.getArgExprList());
        Boolean bucketNullable = (Boolean)statsArgs.get("bucket_nullable").getValue();
        int nGroup = node.getGroupExprList().size() + (Objects.nonNull(node.getSpan()) ? 1 : 0);
        BitSet nonNullGroupMask = new BitSet(nGroup);
        if (!bucketNullable.booleanValue()) {
            nonNullGroupMask.set(0, nGroup);
        }
        this.visitAggregation(node, context, nonNullGroupMask, true, false);
        return context.relBuilder.peek();
    }

    private void visitAggregation(Aggregation node, CalcitePlanContext context, BitSet nonNullGroupMask, boolean metricsFirst, boolean includeAggFieldsInNullFilter) {
        this.visitChildren(node, context);
        List<UnresolvedExpression> aggExprList = node.getAggExprList();
        ArrayList<UnresolvedExpression> groupExprList = new ArrayList<UnresolvedExpression>();
        UnresolvedExpression span = node.getSpan();
        if (Objects.nonNull(span)) {
            groupExprList.add(span);
            if (this.getTimeSpanField(span).isPresent()) {
                nonNullGroupMask.set(0);
            }
        }
        groupExprList.addAll(node.getGroupExprList());
        boolean hintIgnoreNullBucket = !groupExprList.isEmpty() && nonNullGroupMask.nextClearBit(0) >= groupExprList.size();
        List nonNullCandidates = groupExprList.stream().map(expr -> this.rexVisitor.analyze((UnresolvedExpression)expr, context)).collect(Collectors.toCollection(ArrayList::new));
        if (includeAggFieldsInNullFilter) {
            nonNullCandidates.addAll(PlanUtils.getInputRefsFromAggCall(aggExprList.stream().map(expr -> this.aggVisitor.analyze((UnresolvedExpression)expr, context)).toList()));
            nonNullGroupMask.set(groupExprList.size(), nonNullCandidates.size());
        }
        List<RexNode> nonNullFields = IntStream.range(0, nonNullCandidates.size()).filter(nonNullGroupMask::get).mapToObj(nonNullCandidates::get).toList();
        if (!nonNullFields.isEmpty()) {
            context.relBuilder.filter(PlanUtils.getSelectColumns(nonNullFields).stream().map(arg_0 -> ((CalciteToolsHelper.OpenSearchRelBuilder)context.relBuilder).field(arg_0)).map(arg_0 -> ((CalciteToolsHelper.OpenSearchRelBuilder)context.relBuilder).isNotNull(arg_0)).toList());
        }
        Pair<List<RexNode>, List<RelBuilder.AggCall>> aggregationAttributes = this.aggregateWithTrimming(groupExprList, aggExprList, context, hintIgnoreNullBucket);
        ImmutableList outputFields = context.relBuilder.fields();
        int numOfOutputFields = outputFields.size();
        int numOfAggList = aggExprList.size();
        ArrayList reordered = new ArrayList(numOfOutputFields);
        List aggRexList = outputFields.subList(numOfOutputFields - numOfAggList, numOfOutputFields);
        List<RexNode> aliasedGroupByList = ((List)aggregationAttributes.getLeft()).stream().map(this::extractAliasLiteral).flatMap(Optional::stream).map(ref -> (String)ref.getValueAs(String.class)).map(arg_0 -> ((CalciteToolsHelper.OpenSearchRelBuilder)context.relBuilder).field(arg_0)).map(f -> f).toList();
        if (metricsFirst) {
            reordered.addAll(aggRexList);
            reordered.addAll(aliasedGroupByList);
        } else {
            reordered.addAll(aliasedGroupByList);
            reordered.addAll(aggRexList);
        }
        context.relBuilder.project(reordered);
    }

    private Optional<UnresolvedExpression> getTimeSpanField(UnresolvedExpression expr) {
        Span span;
        if (Objects.isNull(expr)) {
            return Optional.empty();
        }
        if (expr instanceof Span && SpanUnit.isTimeUnit((span = (Span)expr).getUnit())) {
            return Optional.of(span.getField());
        }
        if (expr instanceof Alias) {
            Alias alias = (Alias)expr;
            return this.getTimeSpanField(alias.getDelegated());
        }
        return Optional.empty();
    }

    private Optional<RexLiteral> extractAliasLiteral(RexNode node) {
        if (node == null) {
            return Optional.empty();
        }
        if (node.getKind() == SqlKind.AS) {
            return Optional.of((RexLiteral)((RexCall)node).getOperands().get(1));
        }
        return Optional.empty();
    }

    @Override
    public RelNode visitJoin(Join node, CalcitePlanContext context) {
        List<UnresolvedPlan> children = node.getChildren();
        children.forEach(c -> this.analyze((UnresolvedPlan)c, context));
        DynamicFieldsHelper.adjustJoinInputsForDynamicFields(node.getLeftAlias(), node.getRightAlias(), context);
        if (node.getJoinCondition().isEmpty()) {
            List<String> leftColumns = DynamicFieldsHelper.getLeftStaticFields(context);
            List<String> rightColumns = DynamicFieldsHelper.getRightStaticFields(context);
            List<String> duplicatedFieldNames = leftColumns.stream().filter(column -> !DynamicFieldsHelper.isDynamicFieldMap(column) && rightColumns.contains(column)).toList();
            RexNode joinCondition = node.getJoinFields().isPresent() ? node.getJoinFields().get().stream().map(field -> CalciteRelNodeVisitor.buildJoinConditionByFieldName(context, field.getField().toString())).reduce(context.rexBuilder::and).orElse((RexNode)context.relBuilder.literal(true)) : duplicatedFieldNames.stream().map(fieldName -> CalciteRelNodeVisitor.buildJoinConditionByFieldName(context, fieldName)).reduce(context.rexBuilder::and).orElse((RexNode)context.relBuilder.literal(true));
            if (node.getJoinType() == Join.JoinType.SEMI || node.getJoinType() == Join.JoinType.ANTI) {
                context.relBuilder.join(JoinAndLookupUtils.translateJoinType(node.getJoinType()), joinCondition);
                return context.relBuilder.peek();
            }
            List<RexNode> toBeRemovedFields = node.isOverwrite() ? duplicatedFieldNames.stream().map(field -> JoinAndLookupUtils.analyzeFieldsForLookUp(field, true, context)).toList() : duplicatedFieldNames.stream().map(field -> JoinAndLookupUtils.analyzeFieldsForLookUp(field, false, context)).toList();
            Literal max = node.getArgumentMap().get("max");
            if (max != null && !max.equals(Literal.ZERO)) {
                Integer allowedDuplication = (Integer)max.getValue();
                if (allowedDuplication < 0) {
                    throw new SemanticCheckException("max option must be a positive integer");
                }
                List<RexNode> dedupeFields = node.getJoinFields().isPresent() ? node.getJoinFields().get().stream().map(a -> context.relBuilder.field(a.getField().toString())).toList() : duplicatedFieldNames.stream().map(a -> context.relBuilder.field((String)a)).toList();
                PPLDedupConvertRule.buildDedupNotNull(context.relBuilder, dedupeFields, allowedDuplication);
            }
            CalciteRelNodeVisitor.addSysLimitForJoinSubsearch(context);
            context.relBuilder.join(JoinAndLookupUtils.translateJoinType(node.getJoinType()), joinCondition);
            if (!toBeRemovedFields.isEmpty()) {
                context.relBuilder.projectExcept(toBeRemovedFields);
            }
            JoinAndLookupUtils.mergeDynamicFieldsAsNeeded(context, node.isOverwrite() ? JoinAndLookupUtils.OverwriteMode.RIGHT_WINS : JoinAndLookupUtils.OverwriteMode.LEFT_WINS);
        } else {
            RexNode joinCondition = node.getJoinCondition().map(c -> this.rexVisitor.analyzeJoinCondition((UnresolvedExpression)c, context)).orElse((RexNode)context.relBuilder.literal(true));
            if (node.getJoinType() == Join.JoinType.SEMI || node.getJoinType() == Join.JoinType.ANTI) {
                context.relBuilder.join(JoinAndLookupUtils.translateJoinType(node.getJoinType()), joinCondition);
                return context.relBuilder.peek();
            }
            List<String> leftColumns = DynamicFieldsHelper.getLeftStaticFields(context);
            List<String> rightColumns = DynamicFieldsHelper.getRightStaticFields(context);
            List rightTableName = PlanUtils.findTable(context.relBuilder.peek()).getQualifiedName();
            String rightTableQualifiedName = (String)rightTableName.getLast();
            List<String> rightColumnsWithAliasIfConflict = rightColumns.stream().map(col -> !DynamicFieldsHelper.isDynamicFieldMap(col) && leftColumns.contains(col) ? node.getRightAlias().map(a -> a + "." + col).orElse(rightTableQualifiedName + "." + col) : col).toList();
            Literal max = node.getArgumentMap().get("max");
            if (max != null && !max.equals(Literal.ZERO)) {
                Integer allowedDuplication = (Integer)max.getValue();
                if (allowedDuplication < 0) {
                    throw new SemanticCheckException("max option must be a positive integer");
                }
                List<RexNode> dedupeFields = this.getRightColumnsInJoinCriteria(context.relBuilder, joinCondition);
                PPLDedupConvertRule.buildDedupNotNull(context.relBuilder, dedupeFields, allowedDuplication);
            }
            CalciteRelNodeVisitor.addSysLimitForJoinSubsearch(context);
            context.relBuilder.join(JoinAndLookupUtils.translateJoinType(node.getJoinType()), joinCondition);
            JoinAndLookupUtils.mergeDynamicFieldsAsNeeded(context, JoinAndLookupUtils.OverwriteMode.LEFT_WINS);
            JoinAndLookupUtils.renameToExpectedFields(rightColumnsWithAliasIfConflict, leftColumns.size(), context);
        }
        return context.relBuilder.peek();
    }

    private static void addSysLimitForJoinSubsearch(CalcitePlanContext context) {
        if (context.sysLimit.joinSubsearchLimit() > 0) {
            PlanUtils.replaceTop(context.relBuilder, (RelNode)LogicalSystemLimit.create(LogicalSystemLimit.SystemLimitType.JOIN_SUBSEARCH_MAXOUT, context.relBuilder.peek(), (RexNode)context.relBuilder.literal(context.sysLimit.joinSubsearchLimit())));
        }
    }

    private List<RexNode> getRightColumnsInJoinCriteria(RelBuilder relBuilder, RexNode joinCondition) {
        int stackSize = relBuilder.size();
        final int leftFieldCount = relBuilder.peek(stackSize - 1).getRowType().getFieldCount();
        RelNode right = relBuilder.peek(stackSize - 2);
        List allColumnNamesOfRight = right.getRowType().getFieldNames();
        final ArrayList rightColumnIndexes = new ArrayList();
        joinCondition.accept((RexVisitor)new RexVisitorImpl<Void>(this, true){

            public Void visitInputRef(RexInputRef inputRef) {
                if (inputRef.getIndex() >= leftFieldCount) {
                    rightColumnIndexes.add(inputRef.getIndex() - leftFieldCount);
                }
                return (Void)super.visitInputRef(inputRef);
            }
        });
        return rightColumnIndexes.stream().map(allColumnNamesOfRight::get).map(n -> relBuilder.field(n)).toList();
    }

    private static RexNode buildJoinConditionByFieldName(CalcitePlanContext context, String fieldName) {
        RexNode lookupKey = JoinAndLookupUtils.analyzeFieldsForLookUp(fieldName, false, context);
        RexNode sourceKey = JoinAndLookupUtils.analyzeFieldsForLookUp(fieldName, true, context);
        return context.rexBuilder.equals(sourceKey, lookupKey);
    }

    @Override
    public RelNode visitSubqueryAlias(SubqueryAlias node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        context.relBuilder.as(node.getAlias());
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitLookup(Lookup node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List sourceFieldsNames = context.relBuilder.peek().getRowType().getFieldNames();
        this.analyze(node.getLookupRelation(), context);
        JoinAndLookupUtils.addProjectionIfNecessary(node, context);
        List lookupTableFieldNames = context.relBuilder.peek().getRowType().getFieldNames();
        List<String> toBeRemovedLookupFieldNames = node.getMappingAliasMap().keySet().stream().filter(k -> !node.getOutputAliasMap().containsKey(k)).toList();
        List<String> providedFieldNames = lookupTableFieldNames.stream().filter(k -> !toBeRemovedLookupFieldNames.contains(k)).toList();
        List<RexNode> toBeRemovedLookupFields = toBeRemovedLookupFieldNames.stream().map(d -> context.relBuilder.field(2, 1, (String)d)).toList();
        ArrayList<RexNode> toBeRemovedFields = new ArrayList<RexNode>(toBeRemovedLookupFields);
        java.util.Map<String, String> duplicatedFieldNamesMap = JoinAndLookupUtils.findDuplicatedFields(node, sourceFieldsNames, providedFieldNames);
        List<RexNode> duplicatedSourceFields = duplicatedFieldNamesMap.keySet().stream().map(field -> JoinAndLookupUtils.analyzeFieldsForLookUp(field, true, context)).toList();
        toBeRemovedFields.addAll(duplicatedSourceFields);
        List<String> expectedProvidedFieldNames = providedFieldNames.stream().map(k -> node.getOutputAliasMap().getOrDefault(k, (String)k)).toList();
        ArrayList<RexNode> newCoalesceList = new ArrayList<RexNode>();
        if (!duplicatedFieldNamesMap.isEmpty() && node.getOutputStrategy() == Lookup.OutputStrategy.APPEND) {
            List<RexNode> duplicatedProvidedFields = duplicatedFieldNamesMap.values().stream().map(field -> JoinAndLookupUtils.analyzeFieldsForLookUp(field, false, context)).toList();
            for (int i = 0; i < duplicatedProvidedFields.size(); ++i) {
                newCoalesceList.add(context.rexBuilder.coalesce(duplicatedSourceFields.get(i), duplicatedProvidedFields.get(i)));
            }
            toBeRemovedFields.addAll(duplicatedProvidedFields);
            ArrayList<String> newExpectedFieldNames = new ArrayList<String>(expectedProvidedFieldNames.stream().filter(k -> !duplicatedFieldNamesMap.containsKey(k)).toList());
            newExpectedFieldNames.addAll(duplicatedFieldNamesMap.keySet());
            expectedProvidedFieldNames = newExpectedFieldNames;
        }
        JoinAndLookupUtils.addJoinForLookUp(node, context);
        if (!newCoalesceList.isEmpty()) {
            context.relBuilder.projectPlus(newCoalesceList);
        }
        if (!toBeRemovedFields.isEmpty()) {
            context.relBuilder.projectExcept(toBeRemovedFields);
        }
        JoinAndLookupUtils.renameToExpectedFields(expectedProvidedFieldNames, sourceFieldsNames.size() - duplicatedSourceFields.size(), context);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitDedupe(Dedupe node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List<Argument> options = node.getOptions();
        Integer allowedDuplication = (Integer)options.get(0).getValue().getValue();
        Boolean keepEmpty = (Boolean)options.get(1).getValue().getValue();
        Boolean consecutive = (Boolean)options.get(2).getValue().getValue();
        if (allowedDuplication <= 0) {
            throw new IllegalArgumentException("Number of duplicate events must be greater than 0");
        }
        if (consecutive.booleanValue()) {
            throw new CalciteUnsupportedException("Consecutive deduplication is unsupported in Calcite");
        }
        List<RexNode> dedupeFields = node.getFields().stream().map(f -> this.rexVisitor.analyze((UnresolvedExpression)f, context)).toList();
        if (keepEmpty.booleanValue()) {
            PPLDedupConvertRule.buildDedupOrNull(context.relBuilder, dedupeFields, allowedDuplication);
        } else {
            PPLDedupConvertRule.buildDedupNotNull(context.relBuilder, dedupeFields, allowedDuplication);
        }
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitWindow(Window node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List<UnresolvedExpression> groupList = node.getGroupList();
        boolean hasGroup = groupList != null && !groupList.isEmpty();
        boolean bucketNullable = node.isBucketNullable();
        List<RexNode> overExpressions = node.getWindowFunctionList().stream().map(w -> this.rexVisitor.analyze((UnresolvedExpression)w, context)).toList();
        if (hasGroup && !bucketNullable) {
            List<RexNode> groupByList = groupList.stream().map(expr -> this.rexVisitor.analyze((UnresolvedExpression)expr, context)).toList();
            List<RexNode> notNullList = PlanUtils.getSelectColumns(groupByList).stream().map(arg_0 -> ((CalciteToolsHelper.OpenSearchRelBuilder)context.relBuilder).field(arg_0)).map(arg_0 -> ((CalciteToolsHelper.OpenSearchRelBuilder)context.relBuilder).isNotNull(arg_0)).toList();
            RexNode groupNotNull = context.relBuilder.and(notNullList);
            List<RexNode> wrappedOverExprs = this.wrapWindowFunctionsWithGroupNotNull(overExpressions, groupNotNull, context);
            context.relBuilder.projectPlus(wrappedOverExprs);
        } else {
            context.relBuilder.projectPlus(overExpressions);
        }
        return context.relBuilder.peek();
    }

    private void validateFillNullTypeCompatibility(RexNode replacement, RexNode fieldRef, String fieldName) {
        RelDataTypeFamily replacementFamily = replacement.getType().getFamily();
        RelDataTypeFamily fieldFamily = fieldRef.getType().getFamily();
        if (fieldFamily != replacementFamily && fieldFamily != SqlTypeFamily.NULL && replacementFamily != SqlTypeFamily.NULL) {
            throw new SemanticCheckException(String.format("fillnull failed: replacement value type %s is not compatible with field '%s' (type: %s). The replacement value type must match the field type.", replacement.getType().getSqlTypeName(), fieldName, fieldRef.getType().getSqlTypeName()));
        }
    }

    @Override
    public RelNode visitStreamWindow(StreamWindow node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List<UnresolvedExpression> groupList = node.getGroupList();
        boolean hasGroup = groupList != null && !groupList.isEmpty();
        boolean hasWindow = node.getWindow() > 0;
        boolean hasReset = node.getResetBefore() != null || node.getResetAfter() != null;
        String RESET_BEFORE_FLAG_COL = "__reset_before_flag__";
        String RESET_AFTER_FLAG_COL = "__reset_after_flag__";
        String SEGMENT_ID_COL = "__seg_id__";
        if (hasReset) {
            RelNode leftWithSeg = this.buildResetHelperColumns(context, node);
            return this.buildStreamWindowJoinPlan(context, leftWithSeg, node, groupList, "__stream_seq__", "__seg_id__", new String[]{"__stream_seq__", "__reset_before_flag__", "__reset_after_flag__", "__seg_id__"});
        }
        if (node.isGlobal() && hasWindow && hasGroup) {
            RexNode streamSeq = context.relBuilder.aggregateCall((SqlAggFunction)SqlStdOperatorTable.ROW_NUMBER, new RexNode[0]).over().rowsTo(RexWindowBounds.CURRENT_ROW).as("__stream_seq__");
            context.relBuilder.projectPlus(new RexNode[]{streamSeq});
            RelNode left = context.relBuilder.build();
            return this.buildStreamWindowJoinPlan(context, left, node, groupList, "__stream_seq__", null, new String[]{"__stream_seq__"});
        }
        List<RexNode> overExpressions = node.getWindowFunctionList().stream().map(w -> this.rexVisitor.analyze((UnresolvedExpression)w, context)).toList();
        if (hasGroup) {
            RexNode streamSeq = context.relBuilder.aggregateCall((SqlAggFunction)SqlStdOperatorTable.ROW_NUMBER, new RexNode[0]).over().rowsTo(RexWindowBounds.CURRENT_ROW).as("__stream_seq__");
            context.relBuilder.projectPlus(new RexNode[]{streamSeq});
            if (!node.isBucketNullable()) {
                List<RexNode> groupByList = groupList.stream().map(expr -> this.rexVisitor.analyze((UnresolvedExpression)expr, context)).toList();
                List<RexNode> notNullList = PlanUtils.getSelectColumns(groupByList).stream().map(arg_0 -> ((CalciteToolsHelper.OpenSearchRelBuilder)context.relBuilder).field(arg_0)).map(arg_0 -> ((CalciteToolsHelper.OpenSearchRelBuilder)context.relBuilder).isNotNull(arg_0)).toList();
                RexNode groupNotNull = context.relBuilder.and(notNullList);
                List<RexNode> wrappedOverExprs = this.wrapWindowFunctionsWithGroupNotNull(overExpressions, groupNotNull, context);
                context.relBuilder.projectPlus(wrappedOverExprs);
            } else {
                context.relBuilder.projectPlus(overExpressions);
            }
            context.relBuilder.sort(new RexNode[]{context.relBuilder.field("__stream_seq__")});
            context.relBuilder.projectExcept(new RexNode[]{context.relBuilder.field("__stream_seq__")});
        } else {
            context.relBuilder.projectPlus(overExpressions);
        }
        return context.relBuilder.peek();
    }

    private List<RexNode> wrapWindowFunctionsWithGroupNotNull(List<RexNode> overExpressions, RexNode groupNotNull, CalcitePlanContext context) {
        ArrayList<RexNode> wrappedOverExprs = new ArrayList<RexNode>(overExpressions.size());
        Iterator<RexNode> iterator = overExpressions.iterator();
        while (iterator.hasNext()) {
            RexCall rc;
            RexNode overExpr;
            RexNode rawExpr = overExpr = iterator.next();
            String aliasName = null;
            if (overExpr instanceof RexCall && (rc = (RexCall)overExpr).getOperator() == SqlStdOperatorTable.AS) {
                Object e;
                rawExpr = (RexNode)rc.getOperands().get(0);
                if (rc.getOperands().size() >= 2 && (e = rc.getOperands().get(1)) instanceof RexLiteral) {
                    RexLiteral lit = (RexLiteral)e;
                    aliasName = (String)lit.getValueAs(String.class);
                }
            }
            RexLiteral nullLiteral = context.rexBuilder.makeNullLiteral(rawExpr.getType());
            RexNode caseExpr = context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{groupNotNull, rawExpr, nullLiteral});
            if (aliasName != null) {
                caseExpr = context.relBuilder.alias(caseExpr, aliasName);
            }
            wrappedOverExprs.add(caseExpr);
        }
        return wrappedOverExprs;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private RelNode buildStreamWindowJoinPlan(CalcitePlanContext context, RelNode leftWithHelpers, StreamWindow node, List<UnresolvedExpression> groupList, String seqCol, String segmentCol, String[] helperColsToCleanup) {
        boolean hasGroup;
        RexNode filter;
        @Nullable Holder v = Holder.empty();
        context.relBuilder.push(leftWithHelpers);
        context.relBuilder.variable(arg_0 -> ((Holder)v).set(arg_0));
        RexInputRef rightSeq = context.relBuilder.field(seqCol);
        RexNode outerSeq = context.relBuilder.field((RexNode)v.get(), seqCol);
        if (segmentCol != null) {
            RexInputRef segRight = context.relBuilder.field(segmentCol);
            RexNode segOuter = context.relBuilder.field((RexNode)v.get(), segmentCol);
            RexNode frame = this.buildResetFrameFilter(context, node, outerSeq, (RexNode)rightSeq, segOuter, (RexNode)segRight);
            RexNode group = this.buildGroupFilter(context, node, groupList, (RexCorrelVariable)v.get());
            filter = group == null ? frame : context.relBuilder.and(new RexNode[]{frame, group});
        } else {
            RexNode frame = this.buildFrameFilter(context, node, outerSeq, (RexNode)rightSeq);
            RexNode group = this.buildGroupFilter(context, node, groupList, (RexCorrelVariable)v.get());
            filter = context.relBuilder.and(new RexNode[]{frame, group});
        }
        context.relBuilder.filter(new RexNode[]{filter});
        this.aggregateWithTrimming(List.of(), node.getWindowFunctionList(), context, false);
        RelNode rightAgg = context.relBuilder.build();
        context.relBuilder.push(leftWithHelpers);
        context.relBuilder.push(rightAgg);
        List<RexNode> requiredLeft = this.buildRequiredLeft(context, seqCol, groupList);
        if (segmentCol != null) {
            requiredLeft = new ArrayList<RexNode>(requiredLeft);
            requiredLeft.add((RexNode)context.relBuilder.field(2, 0, segmentCol));
        }
        context.relBuilder.correlate(JoinRelType.LEFT, ((RexCorrelVariable)v.get()).id, requiredLeft);
        boolean bl = hasGroup = !groupList.isEmpty();
        if (hasGroup) {
            context.relBuilder.sort(new RexNode[]{context.relBuilder.field(seqCol)});
        }
        ArrayList<RexInputRef> cleanup = new ArrayList<RexInputRef>();
        for (String c : helperColsToCleanup) {
            cleanup.add(context.relBuilder.field(c));
        }
        context.relBuilder.projectExcept(cleanup);
        return context.relBuilder.peek();
    }

    private RelNode buildResetHelperColumns(CalcitePlanContext context, StreamWindow node) {
        RexNode rowNum = context.relBuilder.aggregateCall((SqlAggFunction)SqlStdOperatorTable.ROW_NUMBER, new RexNode[0]).over().rowsTo(RexWindowBounds.CURRENT_ROW).as("__stream_seq__");
        context.relBuilder.projectPlus(new RexNode[]{rowNum});
        RexLiteral beforePred = node.getResetBefore() == null ? context.relBuilder.literal(false) : this.rexVisitor.analyze(node.getResetBefore(), context);
        RexLiteral afterPred = node.getResetAfter() == null ? context.relBuilder.literal(false) : this.rexVisitor.analyze(node.getResetAfter(), context);
        RexNode beforeFlag = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{beforePred, context.relBuilder.literal(1), context.relBuilder.literal(0)});
        RexNode afterFlag = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{afterPred, context.relBuilder.literal(1), context.relBuilder.literal(0)});
        context.relBuilder.projectPlus(new RexNode[]{context.relBuilder.alias(beforeFlag, "__reset_before_flag__")});
        context.relBuilder.projectPlus(new RexNode[]{context.relBuilder.alias(afterFlag, "__reset_after_flag__")});
        RexNode sumBefore = context.relBuilder.aggregateCall(SqlStdOperatorTable.SUM, new RexNode[]{context.relBuilder.field("__reset_before_flag__")}).over().rowsTo(RexWindowBounds.CURRENT_ROW).toRex();
        RexNode sumAfterPrev = context.relBuilder.aggregateCall(SqlStdOperatorTable.SUM, new RexNode[]{context.relBuilder.field("__reset_after_flag__")}).over().rowsBetween(RexWindowBounds.UNBOUNDED_PRECEDING, RexWindowBounds.preceding((RexNode)context.relBuilder.literal(1))).toRex();
        sumBefore = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.COALESCE, new RexNode[]{sumBefore, context.relBuilder.literal(0)});
        sumAfterPrev = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.COALESCE, new RexNode[]{sumAfterPrev, context.relBuilder.literal(0)});
        RexNode segId = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{sumBefore, sumAfterPrev});
        context.relBuilder.projectPlus(new RexNode[]{context.relBuilder.alias(segId, "__seg_id__")});
        return context.relBuilder.build();
    }

    private RexNode buildFrameFilter(CalcitePlanContext context, StreamWindow node, RexNode outerSeq, RexNode rightSeq) {
        if (node.isCurrent()) {
            RexNode lower = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{outerSeq, context.relBuilder.literal(node.getWindow() - 1)});
            return context.relBuilder.between(rightSeq, lower, outerSeq);
        }
        RexNode lower = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{outerSeq, context.relBuilder.literal(node.getWindow())});
        RexNode upper = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{outerSeq, context.relBuilder.literal(1)});
        return context.relBuilder.between(rightSeq, lower, upper);
    }

    private RexNode buildResetFrameFilter(CalcitePlanContext context, StreamWindow node, RexNode outerSeq, RexNode rightSeq, RexNode segIdOuter, RexNode segIdRight) {
        RexNode seqFilter = node.getWindow() == 0 ? (node.isCurrent() ? context.relBuilder.lessThanOrEqual(rightSeq, outerSeq) : context.relBuilder.lessThan(rightSeq, outerSeq)) : this.buildFrameFilter(context, node, outerSeq, rightSeq);
        RexNode segFilter = context.relBuilder.equals(segIdRight, segIdOuter);
        return context.relBuilder.and(new RexNode[]{seqFilter, segFilter});
    }

    private RexNode buildGroupFilter(CalcitePlanContext context, StreamWindow node, List<UnresolvedExpression> groupList, RexCorrelVariable correl) {
        if (groupList.isEmpty()) {
            return null;
        }
        List<RexNode> equalsList = groupList.stream().map(expr -> {
            String groupName = this.extractGroupFieldName((UnresolvedExpression)expr);
            RexInputRef rightGroup = context.relBuilder.field(groupName);
            RexNode outerGroup = context.relBuilder.field((RexNode)correl, groupName);
            RexNode equalCondition = context.relBuilder.equals((RexNode)rightGroup, outerGroup);
            if (!node.isBucketNullable()) {
                return equalCondition;
            }
            RexNode bothNull = context.relBuilder.and(new RexNode[]{context.relBuilder.isNull((RexNode)rightGroup), context.relBuilder.isNull(outerGroup)});
            return context.relBuilder.or(new RexNode[]{equalCondition, bothNull});
        }).toList();
        return context.relBuilder.and(equalsList);
    }

    private String extractGroupFieldName(UnresolvedExpression groupExpr) {
        Alias groupAlias;
        UnresolvedExpression unresolvedExpression;
        if (groupExpr instanceof Alias && (unresolvedExpression = (groupAlias = (Alias)groupExpr).getDelegated()) instanceof Field) {
            Field groupField = (Field)unresolvedExpression;
            return groupField.getField().toString();
        }
        if (groupExpr instanceof Field) {
            Field groupField = (Field)groupExpr;
            return groupField.getField().toString();
        }
        throw new IllegalArgumentException("Unsupported group expression: only field or alias(field) is supported");
    }

    private List<RexNode> buildRequiredLeft(CalcitePlanContext context, String seqCol, List<UnresolvedExpression> groupList) {
        ArrayList<RexNode> requiredLeft = new ArrayList<RexNode>();
        requiredLeft.add((RexNode)context.relBuilder.field(2, 0, seqCol));
        for (UnresolvedExpression groupExpr : groupList) {
            String groupName = this.extractGroupFieldName(groupExpr);
            requiredLeft.add((RexNode)context.relBuilder.field(2, 0, groupName));
        }
        return requiredLeft;
    }

    @Override
    public RelNode visitFillNull(FillNull node, CalcitePlanContext context) {
        RexInputRef fieldRef;
        this.visitChildren(node, context);
        if (node.getFields().size() != new HashSet<String>(node.getFields().stream().map(f -> f.getField().toString()).toList()).size()) {
            throw new IllegalArgumentException("The field list cannot be duplicated in fillnull");
        }
        if (node.getReplacementForAll().isPresent()) {
            List fieldsList = context.relBuilder.peek().getRowType().getFieldList();
            RexNode replacement = this.rexVisitor.analyze(node.getReplacementForAll().get(), context);
            for (RelDataTypeField field : fieldsList) {
                fieldRef = context.rexBuilder.makeInputRef(field.getType(), field.getIndex());
                this.validateFillNullTypeCompatibility(replacement, (RexNode)fieldRef, field.getName());
            }
        }
        ArrayList<Object> projects = new ArrayList<Object>();
        List fieldsList = context.relBuilder.peek().getRowType().getFieldList();
        for (RelDataTypeField field : fieldsList) {
            fieldRef = context.rexBuilder.makeInputRef(field.getType(), field.getIndex());
            boolean toReplace = false;
            for (Pair<Field, UnresolvedExpression> pair : node.getReplacementPairs()) {
                if (!field.getName().equalsIgnoreCase(((Field)pair.getLeft()).getField().toString())) continue;
                RexNode replacement = this.rexVisitor.analyze((UnresolvedExpression)pair.getRight(), context);
                this.validateFillNullTypeCompatibility(replacement, (RexNode)fieldRef, field.getName());
                RexNode coalesce = context.rexBuilder.coalesce(new RexNode[]{fieldRef, replacement});
                RexNode coalesceWithAlias = context.relBuilder.alias(coalesce, field.getName());
                projects.add(coalesceWithAlias);
                toReplace = true;
                break;
            }
            if (!toReplace && node.getReplacementForAll().isEmpty()) {
                projects.add(fieldRef);
                continue;
            }
            if (!node.getReplacementForAll().isPresent()) continue;
            RexNode replacement = this.rexVisitor.analyze(node.getReplacementForAll().get(), context);
            RexNode coalesce = context.rexBuilder.coalesce(new RexNode[]{fieldRef, replacement});
            RexNode coalesceWithAlias = context.relBuilder.alias(coalesce, field.getName());
            projects.add(coalesceWithAlias);
        }
        context.relBuilder.project(projects);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitAppendCol(AppendCol node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        RexNode mainRowNumber = PlanUtils.makeOver(context, BuiltinFunctionName.ROW_NUMBER, null, List.of(), List.of(), List.of(), WindowFrame.toCurrentRow());
        context.relBuilder.projectPlus(new RexNode[]{context.relBuilder.alias(mainRowNumber, "_row_number_main_")});
        UnresolvedPlan relation = PlanUtils.getRelation(node);
        PlanUtils.transformPlanToAttachChild(node.getSubSearch(), relation);
        node.getSubSearch().accept(this, context);
        RexNode subsearchRowNumber = PlanUtils.makeOver(context, BuiltinFunctionName.ROW_NUMBER, null, List.of(), List.of(), List.of(), WindowFrame.toCurrentRow());
        context.relBuilder.projectPlus(new RexNode[]{context.relBuilder.alias(subsearchRowNumber, "_row_number_subsearch_")});
        List subsearchFields = context.relBuilder.peek().getRowType().getFieldNames();
        List mainFields = context.relBuilder.peek(1).getRowType().getFieldNames();
        if (!node.isOverride()) {
            List<String> subsearchProjectList = subsearchFields.stream().filter(r -> !mainFields.contains(r)).toList();
            context.relBuilder.project((Iterable)context.relBuilder.fields(subsearchProjectList));
        }
        RexNode joinCondition = context.relBuilder.equals((RexNode)context.relBuilder.field(2, 0, "_row_number_main_"), (RexNode)context.relBuilder.field(2, 1, "_row_number_subsearch_"));
        context.relBuilder.join(JoinAndLookupUtils.translateJoinType(Join.JoinType.FULL), joinCondition);
        if (!node.isOverride()) {
            context.relBuilder.projectExcept(List.of(context.relBuilder.field("_row_number_main_"), context.relBuilder.field("_row_number_subsearch_")));
            return context.relBuilder.peek();
        }
        ArrayList<Object> finalProjections = new ArrayList<Object>();
        ArrayList<String> finalFieldNames = new ArrayList<String>();
        int mainFieldCount = mainFields.size();
        Set duplicatedFields = mainFields.stream().filter(subsearchFields::contains).collect(Collectors.toSet());
        RexNode caseCondition = context.relBuilder.equals((RexNode)context.relBuilder.field("_row_number_main_"), (RexNode)context.relBuilder.field("_row_number_subsearch_"));
        for (int mainFieldIndex = 0; mainFieldIndex < mainFields.size(); ++mainFieldIndex) {
            String mainFieldName = (String)mainFields.get(mainFieldIndex);
            if (mainFieldName.equals("_row_number_main_")) continue;
            finalFieldNames.add(mainFieldName);
            if (duplicatedFields.contains(mainFieldName)) {
                int subsearchFieldIndex = mainFieldCount + subsearchFields.indexOf(mainFieldName);
                RexNode caseExpr = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{caseCondition, context.relBuilder.field(subsearchFieldIndex), context.relBuilder.field(mainFieldIndex)});
                finalProjections.add(caseExpr);
                continue;
            }
            finalProjections.add(context.relBuilder.field(mainFieldIndex));
        }
        for (int subsearchFieldIndex = 0; subsearchFieldIndex < subsearchFields.size(); ++subsearchFieldIndex) {
            String subsearchFieldName = (String)subsearchFields.get(subsearchFieldIndex);
            if (subsearchFieldName.equals("_row_number_subsearch_") || duplicatedFields.contains(subsearchFieldName)) continue;
            finalProjections.add(context.relBuilder.field(mainFieldCount + subsearchFieldIndex));
            finalFieldNames.add(subsearchFieldName);
        }
        context.relBuilder.project(finalProjections, finalFieldNames);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitAppend(Append node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        UnresolvedPlan prunedSubSearch = node.getSubSearch().accept(new EmptySourcePropagateVisitor(), null);
        prunedSubSearch.accept(this, context);
        RelNode subsearchNode = context.relBuilder.build();
        RelNode mainNode = context.relBuilder.build();
        return this.mergeTableAndResolveColumnConflict(mainNode, subsearchNode, context);
    }

    private RelNode mergeTableAndResolveColumnConflict(RelNode mainNode, RelNode subqueryNode, CalcitePlanContext context) {
        mainNode = DynamicFieldsHelper.adjustFieldsForDynamicFields(mainNode, subqueryNode, context);
        subqueryNode = DynamicFieldsHelper.adjustFieldsForDynamicFields(subqueryNode, mainNode, context);
        List<RelNode> nodesToMerge = Arrays.asList(mainNode, subqueryNode);
        List<RelNode> projectedNodes = SchemaUnifier.buildUnifiedSchemaWithConflictResolution(nodesToMerge, context);
        for (RelNode projectedNode : projectedNodes) {
            context.relBuilder.push(projectedNode);
        }
        context.relBuilder.union(true);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitMultisearch(Multisearch node, CalcitePlanContext context) {
        RelDataTypeField timestampFieldRef;
        List<RelNode> subsearchNodes = new ArrayList<RelNode>();
        for (UnresolvedPlan unresolvedPlan : node.getSubsearches()) {
            UnresolvedPlan prunedSubSearch = unresolvedPlan.accept(new EmptySourcePropagateVisitor(), null);
            prunedSubSearch.accept(this, context);
            subsearchNodes.add(context.relBuilder.build());
        }
        subsearchNodes = DynamicFieldsHelper.adjustInputsForDynamicFields(subsearchNodes, context);
        List<RelNode> alignedNodes = SchemaUnifier.buildUnifiedSchemaWithConflictResolution(subsearchNodes, context);
        for (RelNode alignedNode : alignedNodes) {
            context.relBuilder.push(alignedNode);
        }
        context.relBuilder.union(true, alignedNodes.size());
        RelDataType relDataType = context.relBuilder.peek().getRowType();
        String timestampField = this.findTimestampField(relDataType);
        if (timestampField != null && (timestampFieldRef = relDataType.getField(timestampField, false, false)) != null) {
            RexInputRef timestampRef = context.rexBuilder.makeInputRef(context.relBuilder.peek(), timestampFieldRef.getIndex());
            context.relBuilder.sort(new RexNode[]{context.relBuilder.desc((RexNode)timestampRef)});
        }
        return context.relBuilder.peek();
    }

    private String findTimestampField(RelDataType rowType) {
        RelDataTypeField field = rowType.getField("@timestamp", false, false);
        if (field != null) {
            return "@timestamp";
        }
        return null;
    }

    @Override
    public RelNode visitAD(AD node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("AD command is unsupported in Calcite");
    }

    @Override
    public RelNode visitCloseCursor(CloseCursor closeCursor, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Close cursor operation is unsupported in Calcite");
    }

    @Override
    public RelNode visitFetchCursor(FetchCursor cursor, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Fetch cursor operation is unsupported in Calcite");
    }

    @Override
    public RelNode visitML(ML node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("ML command is unsupported in Calcite");
    }

    @Override
    public RelNode visitPaginate(Paginate paginate, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Paginate operation is unsupported in Calcite");
    }

    @Override
    public RelNode visitKmeans(Kmeans node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Kmeans command is unsupported in Calcite");
    }

    @Override
    public RelNode visitRareTopN(RareTopN node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        Argument.ArgumentMap argumentMap = Argument.ArgumentMap.of(node.getArguments());
        String countFieldName = (String)argumentMap.get(RareTopN.Option.countField.name()).getValue();
        if (context.relBuilder.peek().getRowType().getFieldNames().contains(countFieldName)) {
            throw new IllegalArgumentException("Field `" + countFieldName + "` is existed, change the count field by setting countfield='xyz'");
        }
        ArrayList<UnresolvedExpression> groupExprList = new ArrayList<UnresolvedExpression>(node.getGroupExprList());
        List<UnresolvedExpression> fieldList = node.getFields().stream().map(f -> f).toList();
        groupExprList.addAll(fieldList);
        List<UnresolvedExpression> aggExprList = List.of(AstDSL.alias(countFieldName, AstDSL.aggregate("count", null)));
        Boolean bucketNullable = (Boolean)argumentMap.get(RareTopN.Option.useNull.name()).getValue();
        boolean hintIgnoreNullBucket = false;
        if (!bucketNullable.booleanValue() && !groupExprList.isEmpty()) {
            hintIgnoreNullBucket = true;
            List<RexNode> groupByList = groupExprList.stream().map(expr -> this.rexVisitor.analyze((UnresolvedExpression)expr, context)).toList();
            context.relBuilder.filter(PlanUtils.getSelectColumns(groupByList).stream().map(arg_0 -> ((CalciteToolsHelper.OpenSearchRelBuilder)context.relBuilder).field(arg_0)).map(arg_0 -> ((CalciteToolsHelper.OpenSearchRelBuilder)context.relBuilder).isNotNull(arg_0)).toList());
        }
        this.aggregateWithTrimming(groupExprList, aggExprList, context, hintIgnoreNullBucket);
        List<RexNode> partitionKeys = this.rexVisitor.analyze(node.getGroupExprList(), context);
        Object countField = node.getCommandType() == RareTopN.CommandType.TOP ? context.relBuilder.desc((RexNode)context.relBuilder.field(countFieldName)) : context.relBuilder.field(countFieldName);
        RexNode rowNumberWindowOver = PlanUtils.makeOver(context, BuiltinFunctionName.ROW_NUMBER, null, List.of(), partitionKeys, List.of(countField), WindowFrame.toCurrentRow());
        context.relBuilder.projectPlus(new RexNode[]{context.relBuilder.alias(rowNumberWindowOver, "_row_number_rare_top_")});
        int k = node.getNoOfResults();
        context.relBuilder.filter(new RexNode[]{context.relBuilder.lessThanOrEqual((RexNode)context.relBuilder.field("_row_number_rare_top_"), (RexNode)context.relBuilder.literal(k))});
        Boolean showCount = (Boolean)argumentMap.get(RareTopN.Option.showCount.name()).getValue();
        if (showCount.booleanValue()) {
            context.relBuilder.projectExcept(new RexNode[]{context.relBuilder.field("_row_number_rare_top_")});
        } else {
            context.relBuilder.projectExcept(new RexNode[]{context.relBuilder.field("_row_number_rare_top_"), context.relBuilder.field(countFieldName)});
        }
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitTableFunction(TableFunction node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Table function is unsupported in Calcite");
    }

    @Override
    public RelNode visitFlatten(Flatten node, CalcitePlanContext context) {
        List<String> expandedFieldNames;
        this.visitChildren(node, context);
        CalciteToolsHelper.OpenSearchRelBuilder relBuilder = context.relBuilder;
        String fieldName = node.getField().getField().toString();
        List<RelDataTypeField> fieldsToExpand = relBuilder.peek().getRowType().getFieldList().stream().filter(f -> f.getName().startsWith(fieldName + ".")).toList();
        if (node.getAliases() != null) {
            if (node.getAliases().size() != fieldsToExpand.size()) {
                throw new IllegalArgumentException(String.format("The number of aliases has to match the number of flattened fields. Expected %d (%s), got %d (%s)", fieldsToExpand.size(), fieldsToExpand.stream().map(RelDataTypeField::getName).collect(Collectors.joining(", ")), node.getAliases().size(), String.join((CharSequence)", ", node.getAliases())));
            }
            expandedFieldNames = node.getAliases();
        } else {
            expandedFieldNames = fieldsToExpand.stream().map(RelDataTypeField::getName).map(name -> name.substring(fieldName.length() + 1)).collect(Collectors.toList());
        }
        List expandedFields = Streams.zip(fieldsToExpand.stream(), expandedFieldNames.stream(), (f, n) -> relBuilder.alias((RexNode)relBuilder.field(f.getName()), (String)n)).collect(Collectors.toList());
        relBuilder.projectPlus(expandedFields);
        return relBuilder.peek();
    }

    private String getAggFieldAlias(UnresolvedExpression aggregateFunction) {
        if (aggregateFunction instanceof Alias) {
            return ((Alias)aggregateFunction).getName();
        }
        if (!(aggregateFunction instanceof AggregateFunction)) {
            return "value";
        }
        AggregateFunction aggFunc = (AggregateFunction)aggregateFunction;
        String funcName = aggFunc.getFuncName().toLowerCase();
        ArrayList<UnresolvedExpression> args = new ArrayList<UnresolvedExpression>();
        if (aggFunc.getField() != null) {
            args.add(aggFunc.getField());
        }
        if (aggFunc.getArgList() != null) {
            args.addAll(aggFunc.getArgList());
        }
        if (args.isEmpty() || funcName.equals("count")) {
            return "count";
        }
        StringBuilder sb = new StringBuilder(funcName).append("(");
        for (int i = 0; i < args.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (args.get(i) instanceof Field) {
                sb.append(((Field)args.get(i)).getField().toString());
                continue;
            }
            sb.append(((UnresolvedExpression)args.get(i)).toString());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public RelNode visitAddColTotals(AddColTotals node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        java.util.Map<String, Literal> options = node.getOptions();
        String label = this.getOptionValue(options, "label", "Total");
        String labelField = this.getOptionValue(options, "labelfield", null);
        List<Field> fieldsToAggregate = node.getFieldList();
        return this.buildAddRowTotalAggregate(context, fieldsToAggregate, false, true, null, labelField, label);
    }

    public RexNode getAggregateDataTypeFieldRef(CalcitePlanContext context, RexNode fieldRef, RelDataTypeField fieldDataType) {
        RexNode castFieldRef = fieldRef;
        if (fieldDataType.getType().getSqlTypeName() == SqlTypeName.INTEGER) {
            castFieldRef = context.relBuilder.cast(fieldRef, SqlTypeName.BIGINT);
        } else if (fieldDataType.getType().getSqlTypeName() == SqlTypeName.FLOAT || fieldDataType.getType().getSqlTypeName() == SqlTypeName.REAL) {
            castFieldRef = context.relBuilder.cast(fieldRef, SqlTypeName.DOUBLE);
        }
        return castFieldRef;
    }

    public RelNode buildAddRowTotalAggregate(CalcitePlanContext context, List<Field> fieldsToAggregate, boolean addTotalsForEachRow, boolean addTotalsForEachColumn, String newColTotalsFieldName, String labelField, String label) {
        boolean extraColTotalField = false;
        RexNode sumExpression = null;
        ArrayList<RelBuilder.AggCall> aggCalls = new ArrayList<RelBuilder.AggCall>();
        ArrayList<String> fieldNameToSum = new ArrayList<String>();
        RelNode originalData = context.relBuilder.peek();
        List fieldNames = originalData.getRowType().getFieldNames();
        boolean foundLabelField = false;
        int labelLength = labelField != null && labelField.length() > label.length() ? labelField.length() : label.length();
        RelDataType labelVarcharType = context.relBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, labelLength);
        if (fieldsToAggregate.isEmpty()) {
            fieldsToAggregate = this.getAllNumericFields(originalData, context);
        }
        ArrayList<Object> orginalDataProjectedFields = new ArrayList<Object>();
        ArrayList<RexInputRef> fieldsToSum = new ArrayList<RexInputRef>();
        List fieldList = originalData.getRowType().getFieldList();
        for (Object fieldDataType : fieldList) {
            RexInputRef fieldRef = context.relBuilder.field(fieldDataType.getName());
            boolean columnAddedToNewProject = false;
            if (this.shouldAggregateField(fieldDataType.getName(), fieldsToAggregate) && this.isNumericField((RexNode)fieldRef, context)) {
                fieldsToSum.add(fieldRef);
                if (addTotalsForEachColumn) {
                    RexNode castFieldRef = this.getAggregateDataTypeFieldRef(context, (RexNode)fieldRef, (RelDataTypeField)fieldDataType);
                    orginalDataProjectedFields.add(castFieldRef);
                    columnAddedToNewProject = true;
                    RelBuilder.AggCall sumCall = context.relBuilder.sum(castFieldRef).as(fieldDataType.getName());
                    aggCalls.add(sumCall);
                }
                fieldNameToSum.add(fieldDataType.getName());
                if (addTotalsForEachRow) {
                    RexNode rowCastFieldRef = this.getAggregateDataTypeFieldRef(context, (RexNode)fieldRef, (RelDataTypeField)fieldDataType);
                    sumExpression = sumExpression == null ? rowCastFieldRef : context.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{sumExpression, rowCastFieldRef});
                }
            }
            if (!columnAddedToNewProject) {
                orginalDataProjectedFields.add(fieldRef);
            }
            if (!addTotalsForEachColumn || !fieldDataType.getName().equals(labelField)) continue;
            foundLabelField = true;
        }
        context.relBuilder.project(orginalDataProjectedFields, fieldNames);
        if (addTotalsForEachRow && !fieldsToSum.isEmpty()) {
            context.relBuilder.projectPlus(new RexNode[]{context.relBuilder.alias(sumExpression, newColTotalsFieldName)});
            if (newColTotalsFieldName.equals(labelField)) {
                foundLabelField = true;
            }
        }
        if (addTotalsForEachColumn && !foundLabelField && labelField != null) {
            context.relBuilder.projectPlus(new RexNode[]{context.relBuilder.alias((RexNode)context.relBuilder.getRexBuilder().makeNullLiteral(labelVarcharType), labelField)});
            extraColTotalField = true;
        }
        originalData = context.relBuilder.build();
        context.relBuilder.push(originalData);
        if (addTotalsForEachColumn) {
            context.relBuilder.aggregate(context.relBuilder.groupKey(), aggCalls);
            ArrayList<RexNode> selectList = new ArrayList<RexNode>();
            fieldList = originalData.getRowType().getFieldList();
            for (RelDataTypeField fieldDataType : fieldList) {
                if (fieldNameToSum.contains(fieldDataType.getName())) {
                    selectList.add(context.relBuilder.alias((RexNode)context.relBuilder.field(fieldDataType.getName()), fieldDataType.getName()));
                    continue;
                }
                if (fieldDataType.getName().equals(labelField) && (extraColTotalField || fieldDataType.getType().getFamily() == SqlTypeFamily.CHARACTER)) {
                    RexNode labelLiteral = context.relBuilder.getRexBuilder().makeLiteral((Object)label, fieldDataType.getType(), true);
                    selectList.add(context.relBuilder.alias(labelLiteral, fieldDataType.getName()));
                    continue;
                }
                selectList.add(context.relBuilder.alias((RexNode)context.relBuilder.getRexBuilder().makeNullLiteral(fieldDataType.getType()), fieldDataType.getName()));
            }
            context.relBuilder.project(selectList);
            RelNode totalsRow = context.relBuilder.build();
            context.relBuilder.push(originalData);
            context.relBuilder.push(totalsRow);
            context.relBuilder.union(true);
        }
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitAddTotals(AddTotals node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        java.util.Map<String, Literal> options = node.getOptions();
        String label = this.getOptionValue(options, "label", "Total");
        String labelField = this.getOptionValue(options, "labelfield", null);
        String newColTotalsFieldName = this.getOptionValue(options, "fieldname", "Total");
        boolean addTotalsForEachRow = this.getBooleanOptionValue(options, "row", true);
        boolean addTotalsForEachColumn = this.getBooleanOptionValue(options, "col", false);
        List<Field> fieldsToAggregate = node.getFieldList();
        return this.buildAddRowTotalAggregate(context, fieldsToAggregate, addTotalsForEachRow, addTotalsForEachColumn, newColTotalsFieldName, labelField, label);
    }

    private String getOptionValue(java.util.Map<String, Literal> options, String key, String defaultValue) {
        Literal literal = options.get(key);
        if (literal == null) {
            return defaultValue;
        }
        Object value = literal.getValue();
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    private boolean getBooleanOptionValue(java.util.Map<String, Literal> options, String key, boolean defaultValue) {
        if (options.containsKey(key)) {
            Object value = options.get(key).getValue();
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
        }
        return defaultValue;
    }

    private List<Field> getAllNumericFields(RelNode relNode, CalcitePlanContext context) {
        ArrayList<Field> numericFields = new ArrayList<Field>();
        for (String fieldName : relNode.getRowType().getFieldNames()) {
            if (!this.isNumericFieldName(fieldName, relNode)) continue;
            numericFields.add(new Field(new QualifiedName(fieldName)));
        }
        return numericFields;
    }

    private boolean shouldAggregateField(String fieldName, List<Field> fieldsToAggregate) {
        if (fieldsToAggregate.isEmpty()) {
            return true;
        }
        return fieldsToAggregate.stream().anyMatch(field -> field.getField().toString().equals(fieldName));
    }

    private boolean isNumericField(RexNode rexNode, CalcitePlanContext context) {
        return rexNode.getType().getSqlTypeName().getFamily() == SqlTypeFamily.NUMERIC;
    }

    private boolean isNumericFieldName(String fieldName, RelNode relNode) {
        try {
            RelDataTypeField field = relNode.getRowType().getField(fieldName, false, false);
            return field != null && field.getType().getSqlTypeName().getFamily() == SqlTypeFamily.NUMERIC;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public RelNode visitChart(Chart node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        Argument.ArgumentMap argMap = Argument.ArgumentMap.of(node.getArguments());
        ChartConfig config = ChartConfig.fromArguments(argMap);
        List<UnresolvedExpression> groupExprList = Stream.of(node.getRowSplit(), node.getColumnSplit()).filter(Objects::nonNull).toList();
        Aggregation aggregation = new Aggregation(List.of(node.getAggregationFunction()), List.of(), groupExprList, null, List.of());
        BitSet nonNullGroupMask = new BitSet(groupExprList.size());
        if (config.useNull) {
            nonNullGroupMask.set(0);
        } else {
            nonNullGroupMask.set(0, groupExprList.size());
        }
        this.visitAggregation(aggregation, context, nonNullGroupMask, false, true);
        CalciteToolsHelper.OpenSearchRelBuilder relBuilder = context.relBuilder;
        if (node.getRowSplit() == null || node.getColumnSplit() == null || Objects.equals(config.limit, 0)) {
            relBuilder.sort(new RexNode[]{relBuilder.field(0)});
            return relBuilder.peek();
        }
        RexInputRef colSplit = relBuilder.field(1);
        String columnSplitName = (String)relBuilder.peek().getRowType().getFieldNames().get(1);
        if (!SqlTypeUtil.isCharacter((RelDataType)colSplit.getType())) {
            colSplit = relBuilder.alias(context.rexBuilder.makeCast(UserDefinedFunctionUtils.NULLABLE_STRING, (RexNode)colSplit, true, true), columnSplitName);
        }
        relBuilder.project(new RexNode[]{relBuilder.field(0), colSplit, relBuilder.field(2)});
        RelNode aggregated = relBuilder.peek();
        RelNode ranked = this.rankByColumnSplit(context, 1, 2, config.top);
        relBuilder.push(aggregated);
        relBuilder.push(ranked);
        relBuilder.join(JoinRelType.LEFT, relBuilder.equals((RexNode)relBuilder.field(2, 0, 1), (RexNode)relBuilder.field(2, 1, 0)));
        RexInputRef colSplitPostJoin = relBuilder.field(1);
        RexNode lteCondition = relBuilder.call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{relBuilder.field("_row_number_chart_"), relBuilder.literal(config.limit)});
        if (!config.useOther) {
            relBuilder.filter(new RexNode[]{lteCondition});
        }
        RexNode nullCondition = relBuilder.isNull((RexNode)colSplitPostJoin);
        RexNode columnSplitExpr = config.useNull ? relBuilder.call((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{nullCondition, relBuilder.literal(config.nullStr), lteCondition, relBuilder.field(1), relBuilder.literal(config.otherStr)}) : relBuilder.call((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{lteCondition, relBuilder.field(1), relBuilder.literal(config.otherStr)});
        String aggFieldName = (String)relBuilder.peek().getRowType().getFieldNames().get(2);
        relBuilder.project(new RexNode[]{relBuilder.field(0), relBuilder.alias(columnSplitExpr, columnSplitName), relBuilder.field(2)});
        relBuilder.aggregate(relBuilder.groupKey(new RexNode[]{relBuilder.field(0), relBuilder.field(1)}), new RelBuilder.AggCall[]{this.buildAggCall(context.relBuilder, this.getAggFunctionName(node.getAggregationFunction()), (RexNode)relBuilder.field(2)).as(aggFieldName)});
        relBuilder.sort(new RexNode[]{relBuilder.field(0), relBuilder.field(1)});
        return relBuilder.peek();
    }

    private RelNode rankByColumnSplit(CalcitePlanContext context, int columnSplitOrdinal, int aggOrdinal, boolean top) {
        CalciteToolsHelper.OpenSearchRelBuilder relBuilder = context.relBuilder;
        relBuilder.project(new RexNode[]{relBuilder.field(columnSplitOrdinal), relBuilder.field(aggOrdinal)});
        relBuilder.filter(new RexNode[]{relBuilder.isNotNull((RexNode)relBuilder.field(0))});
        String GRAND_TOTAL_COL = "__grand_total__";
        relBuilder.aggregate(relBuilder.groupKey(new RexNode[]{relBuilder.field(0)}), new RelBuilder.AggCall[]{relBuilder.sum((RexNode)relBuilder.field(1)).as("__grand_total__")});
        RexInputRef grandTotal = relBuilder.field("__grand_total__");
        if (top) {
            grandTotal = relBuilder.desc((RexNode)grandTotal);
        }
        grandTotal = relBuilder.nullsLast((RexNode)grandTotal);
        RexNode rowNum = PlanUtils.makeOver(context, BuiltinFunctionName.ROW_NUMBER, (RexNode)relBuilder.literal(1), List.of(), List.of(), List.of(grandTotal), WindowFrame.toCurrentRow());
        relBuilder.projectPlus(new RexNode[]{relBuilder.alias(rowNum, "_row_number_chart_")});
        return relBuilder.build();
    }

    private RelBuilder.AggCall buildAggCall(RelBuilder relBuilder, String aggFunctionName, RexNode node) {
        BuiltinFunctionName aggFunction = BuiltinFunctionName.ofAggregation(aggFunctionName).orElseThrow(() -> new IllegalArgumentException(org.opensearch.sql.common.utils.StringUtils.format((String)"Unrecognized aggregation function: %s", (Object[])new Object[]{aggFunctionName})));
        return switch (aggFunction) {
            case BuiltinFunctionName.MIN, BuiltinFunctionName.EARLIEST -> relBuilder.min(node);
            case BuiltinFunctionName.MAX, BuiltinFunctionName.LATEST -> relBuilder.max(node);
            case BuiltinFunctionName.AVG -> relBuilder.avg(node);
            default -> relBuilder.sum(node);
        };
    }

    private String getAggFunctionName(UnresolvedExpression aggregateFunction) {
        if (aggregateFunction instanceof Alias) {
            Alias alias = (Alias)aggregateFunction;
            return this.getAggFunctionName(alias.getDelegated());
        }
        return ((AggregateFunction)aggregateFunction).getFuncName();
    }

    @Override
    public RelNode visitTrendline(Trendline node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        node.getSortByField().ifPresent(sortField -> {
            Sort.SortOption sortOption = this.analyzeSortOption(sortField.getFieldArgs());
            RexNode field = this.rexVisitor.analyze((UnresolvedExpression)sortField, context);
            if (sortOption == Sort.SortOption.DEFAULT_DESC) {
                context.relBuilder.sort(new RexNode[]{context.relBuilder.desc(field)});
            } else {
                context.relBuilder.sort(new RexNode[]{field});
            }
        });
        ArrayList<RexNode> trendlineNodes = new ArrayList<RexNode>();
        ArrayList<String> aliases = new ArrayList<String>();
        node.getComputations().forEach(trendlineComputation -> {
            RexNode field = this.rexVisitor.analyze(trendlineComputation.getDataField(), context);
            context.relBuilder.filter(new RexNode[]{context.relBuilder.isNotNull(field)});
            WindowFrame windowFrame = WindowFrame.of(WindowFrame.FrameType.ROWS, org.opensearch.sql.common.utils.StringUtils.format((String)"%d PRECEDING", (Object[])new Object[]{trendlineComputation.getNumberOfDataPoints() - 1}), "CURRENT ROW");
            RexNode countExpr = PlanUtils.makeOver(context, BuiltinFunctionName.COUNT, null, List.of(), List.of(), List.of(), windowFrame);
            RexNode whenConditionExpr = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, ">", new RexNode[]{countExpr, context.relBuilder.literal(trendlineComputation.getNumberOfDataPoints() - 1)});
            RexNode thenExpr = switch (trendlineComputation.getComputationType()) {
                case Trendline.TrendlineType.SMA -> PlanUtils.makeOver(context, BuiltinFunctionName.AVG, field, List.of(), List.of(), List.of(), windowFrame);
                case Trendline.TrendlineType.WMA -> this.buildWmaRexNode(field, trendlineComputation.getNumberOfDataPoints(), windowFrame, context);
                default -> throw new IllegalStateException("Unsupported trendline type");
            };
            RexLiteral elseExpr = context.relBuilder.literal(null);
            ArrayList<Object> caseOperands = new ArrayList<Object>();
            caseOperands.add(whenConditionExpr);
            caseOperands.add(thenExpr);
            caseOperands.add(elseExpr);
            RexNode trendlineNode = context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, caseOperands);
            trendlineNodes.add(trendlineNode);
            aliases.add(trendlineComputation.getAlias());
        });
        this.projectPlusOverriding(trendlineNodes, aliases, context);
        return context.relBuilder.peek();
    }

    private RexNode buildWmaRexNode(RexNode field, Integer numberOfDataPoints, WindowFrame windowFrame, CalcitePlanContext context) {
        RexLiteral divisor = context.relBuilder.literal(numberOfDataPoints * (numberOfDataPoints + 1) / 2);
        RexLiteral divider = context.relBuilder.literal(0);
        for (int i = 1; i <= numberOfDataPoints; ++i) {
            RexNode nthValueExpr = PlanUtils.makeOver(context, BuiltinFunctionName.NTH_VALUE, field, List.of(context.relBuilder.literal(i)), List.of(), List.of(), windowFrame);
            divider = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{divider, context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{nthValueExpr, context.relBuilder.literal(i)})});
        }
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, new RexNode[]{divider, context.relBuilder.cast((RexNode)divisor, SqlTypeName.DOUBLE)});
    }

    @Override
    public RelNode visitExpand(Expand expand, CalcitePlanContext context) {
        this.visitChildren(expand, context);
        Field arrayField = expand.getField();
        RexInputRef arrayFieldRex = (RexInputRef)this.rexVisitor.analyze(arrayField, context);
        String alias = expand.getAlias();
        this.buildExpandRelNode(arrayFieldRex, arrayField.getField().toString(), alias, context);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitMvCombine(MvCombine node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        CalciteToolsHelper.OpenSearchRelBuilder relBuilder = context.relBuilder;
        RelNode input = relBuilder.peek();
        List inputFieldNames = input.getRowType().getFieldNames();
        List<RelDataType> inputFieldTypes = input.getRowType().getFieldList().stream().map(RelDataTypeField::getType).toList();
        boolean includeMetaFields = context.isProjectVisited();
        Field targetField = node.getField();
        int targetIndex = this.resolveTargetIndex(targetField, context);
        String targetName = (String)inputFieldNames.get(targetIndex);
        List<RexNode> groupExprs = this.buildGroupExpressionsExcludingTarget(targetIndex, inputFieldNames, relBuilder, includeMetaFields);
        this.performArrayAggAggregation(relBuilder, targetIndex, targetName, groupExprs);
        this.restoreColumnOrderAfterArrayAgg(relBuilder, inputFieldNames, inputFieldTypes, targetIndex, groupExprs, includeMetaFields);
        return relBuilder.peek();
    }

    private int resolveTargetIndex(Field targetField, CalcitePlanContext context) {
        RexNode targetRex;
        try {
            targetRex = this.rexVisitor.analyze(targetField, context);
        }
        catch (IllegalArgumentException e) {
            throw new SemanticCheckException("mvcombine target field not found: " + targetField.getField().toString(), e);
        }
        if (!this.isInputRef(targetRex)) {
            throw new SemanticCheckException("mvcombine target must be a direct field reference, but got: " + String.valueOf(targetField));
        }
        int index = ((RexInputRef)targetRex).getIndex();
        RelDataType fieldType = ((RelDataTypeField)context.relBuilder.peek().getRowType().getFieldList().get(index)).getType();
        if (SqlTypeUtil.isArray((RelDataType)fieldType) || SqlTypeUtil.isMultiset((RelDataType)fieldType)) {
            throw new SemanticCheckException("mvcombine target cannot be an array/multivalue type, but got: " + String.valueOf(fieldType));
        }
        return index;
    }

    private List<RexNode> buildGroupExpressionsExcludingTarget(int targetIndex, List<String> inputFieldNames, RelBuilder relBuilder, boolean includeMetaFields) {
        ArrayList<RexNode> groupExprs = new ArrayList<RexNode>(Math.max(0, inputFieldNames.size() - 1));
        for (int i = 0; i < inputFieldNames.size(); ++i) {
            if (i == targetIndex || CalciteRelNodeVisitor.isMetadataField(inputFieldNames.get(i)) && !includeMetaFields) continue;
            groupExprs.add((RexNode)relBuilder.field(i));
        }
        return groupExprs;
    }

    private void performArrayAggAggregation(RelBuilder relBuilder, int targetIndex, String targetName, List<RexNode> groupExprs) {
        RexInputRef targetRef = relBuilder.field(targetIndex);
        RexNode notNullTarget = relBuilder.isNotNull((RexNode)targetRef);
        RelBuilder.AggCall aggCall = relBuilder.aggregateCall(SqlLibraryOperators.ARRAY_AGG, new RexNode[]{targetRef}).filter(notNullTarget).as(targetName);
        relBuilder.aggregate(relBuilder.groupKey(groupExprs), new RelBuilder.AggCall[]{aggCall});
    }

    private void restoreColumnOrderAfterArrayAgg(RelBuilder relBuilder, List<String> inputFieldNames, List<RelDataType> inputFieldTypes, int targetIndex, List<RexNode> groupExprs, boolean includeMetaFields) {
        int aggregatedTargetPos = groupExprs.size();
        ArrayList<Object> projections = new ArrayList<Object>(inputFieldNames.size());
        ArrayList<String> projectionNames = new ArrayList<String>(inputFieldNames.size());
        int groupPos = 0;
        for (int i = 0; i < inputFieldNames.size(); ++i) {
            String fieldName = inputFieldNames.get(i);
            projectionNames.add(fieldName);
            if (i == targetIndex) {
                projections.add(relBuilder.field(aggregatedTargetPos));
                continue;
            }
            if (CalciteRelNodeVisitor.isMetadataField(fieldName) && !includeMetaFields) {
                projections.add(relBuilder.getRexBuilder().makeNullLiteral(inputFieldTypes.get(i)));
                continue;
            }
            projections.add(relBuilder.field(groupPos));
            ++groupPos;
        }
        relBuilder.project(projections, projectionNames, true);
    }

    @Override
    public RelNode visitValues(Values values, CalcitePlanContext context) {
        if (values.getValues() == null || values.getValues().isEmpty()) {
            context.relBuilder.values(context.relBuilder.getTypeFactory().builder().build());
            return context.relBuilder.peek();
        }
        throw new CalciteUnsupportedException("Explicit values node is unsupported in Calcite");
    }

    @Override
    public RelNode visitReplace(Replace node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List fieldNames = context.relBuilder.peek().getRowType().getFieldNames();
        Set fieldsToReplace = node.getFieldList().stream().map(f -> f.getField().toString()).collect(Collectors.toSet());
        for (String fieldToReplace : fieldsToReplace) {
            context.relBuilder.field(fieldToReplace);
        }
        ArrayList<RexInputRef> projectList = new ArrayList<RexInputRef>();
        for (String fieldName : fieldNames) {
            if (fieldsToReplace.contains(fieldName)) {
                RexInputRef fieldRef = context.relBuilder.field(fieldName);
                for (ReplacePair pair : node.getReplacePairs()) {
                    RexNode patternNode = this.rexVisitor.analyze(pair.getPattern(), context);
                    RexNode replacementNode = this.rexVisitor.analyze(pair.getReplacement(), context);
                    String patternStr = pair.getPattern().getValue().toString();
                    String replacementStr = pair.getReplacement().getValue().toString();
                    if (patternStr.contains("*")) {
                        WildcardUtils.validateWildcardSymmetry(patternStr, replacementStr);
                        String regexPattern = WildcardUtils.convertWildcardPatternToRegex(patternStr);
                        String regexReplacement = WildcardUtils.convertWildcardReplacementToRegex(replacementStr);
                        RexNode regexPatternNode = context.rexBuilder.makeLiteral(regexPattern, context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), true);
                        RexNode regexReplacementNode = context.rexBuilder.makeLiteral(regexReplacement, context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), true);
                        fieldRef = context.rexBuilder.makeCall((SqlOperator)SqlLibraryOperators.REGEXP_REPLACE_3, new RexNode[]{fieldRef, regexPatternNode, regexReplacementNode});
                        continue;
                    }
                    fieldRef = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.REPLACE, new RexNode[]{fieldRef, patternNode, replacementNode});
                }
                projectList.add(fieldRef);
                continue;
            }
            projectList.add(context.relBuilder.field(fieldName));
        }
        context.relBuilder.project(projectList, fieldNames);
        return context.relBuilder.peek();
    }

    private void buildParseRelNode(Parse node, CalcitePlanContext context) {
        RexNode sourceField = this.rexVisitor.analyze(node.getSourceField(), context);
        ParseMethod parseMethod = node.getParseMethod();
        java.util.Map<String, Literal> arguments = node.getArguments();
        String patternValue = (String)node.getPattern().getValue();
        String pattern = ParseMethod.PATTERNS.equals((Object)parseMethod) && Strings.isNullOrEmpty((String)patternValue) ? "[a-zA-Z0-9]+" : patternValue;
        List<String> groupCandidates = ParseUtils.getNamedGroupCandidates(parseMethod, pattern, arguments);
        Object[] rexNodeList = new RexNode[]{sourceField, context.rexBuilder.makeLiteral(pattern, context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), true)};
        rexNodeList = ParseMethod.PATTERNS.equals((Object)parseMethod) ? (RexNode[])ArrayUtils.add((Object[])rexNodeList, (Object)context.rexBuilder.makeLiteral("<*>", context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), true)) : (RexNode[])ArrayUtils.add((Object[])rexNodeList, (Object)context.rexBuilder.makeLiteral(parseMethod.getName(), context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), true));
        ArrayList<RexNode> newFields = new ArrayList<RexNode>();
        for (String groupCandidate : groupCandidates) {
            RexNode innerRex = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, ParseUtils.BUILTIN_FUNCTION_MAP.get((Object)parseMethod), (RexNode[])rexNodeList);
            if (!ParseMethod.PATTERNS.equals((Object)parseMethod)) {
                newFields.add(PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_ITEM, innerRex, context.rexBuilder.makeLiteral(groupCandidate, context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), true)));
                continue;
            }
            RexNode emptyString = context.rexBuilder.makeLiteral("", context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), true);
            RexNode isEmptyCondition = context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{sourceField, emptyString});
            RexNode isNullCondition = context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{sourceField});
            newFields.add(context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{isNullCondition, emptyString, isEmptyCondition, emptyString, innerRex}));
        }
        this.projectPlusOverriding(newFields, groupCandidates, context);
    }

    private RexNode explicitMapType(CalcitePlanContext context, RexNode origin, SqlTypeName targetType) {
        MapSqlType originalMapType = (MapSqlType)origin.getType();
        ArraySqlType newValueType = new ArraySqlType(context.rexBuilder.getTypeFactory().createSqlType(targetType), true);
        MapSqlType newMapType = new MapSqlType(originalMapType.getKeyType(), (RelDataType)newValueType, true);
        return new RexInputRef(((RexInputRef)origin).getIndex(), (RelDataType)newMapType);
    }

    private void flattenParsedPattern(String originalPatternResultAlias, RexNode parsedNode, CalcitePlanContext context, boolean flattenPatternAggResult, Boolean showNumberedToken) {
        ArrayList<RexNode> fattenedNodes = new ArrayList<RexNode>();
        ArrayList<String> projectNames = new ArrayList<String>();
        RexNode patternExpr = context.rexBuilder.makeCast(context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_ITEM, new RexNode[]{parsedNode, context.rexBuilder.makeLiteral("pattern")}), true, true);
        fattenedNodes.add(context.relBuilder.alias(patternExpr, originalPatternResultAlias));
        projectNames.add(originalPatternResultAlias);
        if (flattenPatternAggResult) {
            RexNode patternCountExpr = context.rexBuilder.makeCast(context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BIGINT), PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_ITEM, new RexNode[]{parsedNode, context.rexBuilder.makeLiteral("pattern_count")}), true, true);
            fattenedNodes.add(context.relBuilder.alias(patternCountExpr, "pattern_count"));
            projectNames.add("pattern_count");
        }
        if (showNumberedToken.booleanValue()) {
            RexNode tokensExpr = context.rexBuilder.makeCast(UserDefinedFunctionUtils.tokensMap, PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_ITEM, new RexNode[]{parsedNode, context.rexBuilder.makeLiteral("tokens")}), true, true);
            fattenedNodes.add(context.relBuilder.alias(tokensExpr, "tokens"));
            projectNames.add("tokens");
        }
        if (flattenPatternAggResult) {
            RexNode sampleLogsExpr = context.rexBuilder.makeCast(context.rexBuilder.getTypeFactory().createArrayType(context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), -1L), PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_ITEM, new RexNode[]{this.explicitMapType(context, parsedNode, SqlTypeName.VARCHAR), context.rexBuilder.makeLiteral("sample_logs")}), true, true);
            fattenedNodes.add(context.relBuilder.alias(sampleLogsExpr, "sample_logs"));
            projectNames.add("sample_logs");
        }
        this.projectPlusOverriding(fattenedNodes, projectNames, context);
    }

    private void buildExpandRelNode(RexInputRef arrayFieldRex, String arrayFieldName, String alias, CalcitePlanContext context) {
        Holder correlVariable = Holder.empty();
        context.relBuilder.variable(arg_0 -> ((Holder)correlVariable).set(arg_0));
        RexNode correlArrayFieldAccess = context.relBuilder.field(context.rexBuilder.makeCorrel(context.relBuilder.peek().getRowType(), ((RexCorrelVariable)correlVariable.get()).id), arrayFieldRex.getIndex());
        RelNode leftNode = context.relBuilder.build();
        RelNode rightNode = context.relBuilder.push((RelNode)LogicalValues.createOneRow((RelOptCluster)context.relBuilder.getCluster())).project(List.of(correlArrayFieldAccess), List.of(arrayFieldName)).uncollect(List.of(), false).build();
        context.relBuilder.push(leftNode).push(rightNode).correlate(JoinRelType.INNER, ((RexCorrelVariable)correlVariable.get()).id, List.of(arrayFieldRex)).projectExcept(new RexNode[]{arrayFieldRex});
        if (alias != null) {
            CalciteRelNodeVisitor.tryToRemoveNestedFields(context);
            RexInputRef expandedField = context.relBuilder.field(arrayFieldName);
            ArrayList<String> names = new ArrayList<String>(context.relBuilder.peek().getRowType().getFieldNames());
            names.set(expandedField.getIndex(), alias);
            context.relBuilder.rename(names);
        }
    }

    private RexNode createOptimizedSedCall(RexNode fieldRex, String sedExpression, CalcitePlanContext context) {
        if (sedExpression.startsWith("s/")) {
            return this.createOptimizedSubstitution(fieldRex, sedExpression, context);
        }
        if (sedExpression.startsWith("y/")) {
            return this.createOptimizedTransliteration(fieldRex, sedExpression, context);
        }
        throw new RuntimeException("Unsupported sed pattern: " + sedExpression);
    }

    private RexNode createOptimizedSubstitution(RexNode fieldRex, String sedExpression, CalcitePlanContext context) {
        try {
            if (!sedExpression.matches("s/.+/.*/.*")) {
                throw new IllegalArgumentException("Invalid sed substitution format");
            }
            int firstDelimiter = sedExpression.indexOf(47, 2);
            int secondDelimiter = sedExpression.indexOf(47, firstDelimiter + 1);
            int thirdDelimiter = sedExpression.indexOf(47, secondDelimiter + 1);
            if (firstDelimiter == -1 || secondDelimiter == -1) {
                throw new IllegalArgumentException("Invalid sed substitution format");
            }
            String pattern = sedExpression.substring(2, firstDelimiter);
            String replacement = sedExpression.substring(firstDelimiter + 1, secondDelimiter);
            String flags = secondDelimiter + 1 < sedExpression.length() ? sedExpression.substring(secondDelimiter + 1) : "";
            String javaReplacement = replacement.replaceAll("\\\\(\\d+)", "\\$$1");
            if (flags.isEmpty()) {
                return PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.REPLACE, new RexNode[]{fieldRex, context.rexBuilder.makeLiteral(pattern), context.rexBuilder.makeLiteral(javaReplacement)});
            }
            if (flags.matches("[gi]+")) {
                return PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_REGEXP_REPLACE_PG_4, new RexNode[]{fieldRex, context.rexBuilder.makeLiteral(pattern), context.rexBuilder.makeLiteral(javaReplacement), context.rexBuilder.makeLiteral(flags)});
            }
            if (flags.matches("\\d+")) {
                int occurrence = Integer.parseInt(flags);
                return PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_REGEXP_REPLACE_5, new RexNode[]{fieldRex, context.rexBuilder.makeLiteral(pattern), context.rexBuilder.makeLiteral(javaReplacement), context.relBuilder.literal(1), context.relBuilder.literal(occurrence)});
            }
            throw new RuntimeException("Unsupported sed flags: " + flags + " in expression: " + sedExpression);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to optimize sed expression: " + sedExpression, e);
        }
    }

    private RexNode createOptimizedTransliteration(RexNode fieldRex, String sedExpression, CalcitePlanContext context) {
        try {
            if (!sedExpression.matches("y/.+/.*/.*")) {
                throw new IllegalArgumentException("Invalid sed transliteration format");
            }
            int firstSlash = sedExpression.indexOf(47, 1);
            int secondSlash = sedExpression.indexOf(47, firstSlash + 1);
            int thirdSlash = sedExpression.indexOf(47, secondSlash + 1);
            if (firstSlash == -1 || secondSlash == -1) {
                throw new IllegalArgumentException("Invalid sed transliteration format");
            }
            String from = sedExpression.substring(firstSlash + 1, secondSlash);
            String to = sedExpression.substring(secondSlash + 1, thirdSlash != -1 ? thirdSlash : sedExpression.length());
            return PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_TRANSLATE3, new RexNode[]{fieldRex, context.rexBuilder.makeLiteral(from), context.rexBuilder.makeLiteral(to)});
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to optimize sed expression: " + sedExpression, e);
        }
    }

    private static class ChartConfig {
        private final int limit;
        private final boolean top;
        private final boolean useOther;
        private final boolean useNull;
        private final String otherStr;
        private final String nullStr;

        static ChartConfig fromArguments(Argument.ArgumentMap argMap) {
            int limit = (Integer)argMap.getOrDefault("limit", Chart.DEFAULT_LIMIT).getValue();
            boolean top = (Boolean)argMap.getOrDefault("top", Chart.DEFAULT_TOP).getValue();
            boolean useOther = (Boolean)argMap.getOrDefault("useother", Chart.DEFAULT_USE_OTHER).getValue();
            boolean useNull = (Boolean)argMap.getOrDefault("usenull", Chart.DEFAULT_USE_NULL).getValue();
            String otherStr = (String)argMap.getOrDefault("otherstr", Chart.DEFAULT_OTHER_STR).getValue();
            String nullStr = (String)argMap.getOrDefault("nullstr", Chart.DEFAULT_NULL_STR).getValue();
            return new ChartConfig(limit, top, useOther, useNull, otherStr, nullStr);
        }

        @Generated
        public ChartConfig(int limit, boolean top, boolean useOther, boolean useNull, String otherStr, String nullStr) {
            this.limit = limit;
            this.top = top;
            this.useOther = useOther;
            this.useNull = useNull;
            this.otherStr = otherStr;
            this.nullStr = nullStr;
        }
    }
}

