/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia.basic;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;
import javax.swing.plaf.basic.BasicButtonUI;
import org.jsampler.view.fantasia.basic.FantasiaPainter;
import org.jsampler.view.fantasia.basic.FantasiaSubPanel;

public class FantasiaToggleButtonsPanel
extends FantasiaSubPanel {
    public final Vector<JToggleButton> buttons = new Vector();
    protected final ButtonGroup buttonGroup = new ButtonGroup();
    protected boolean dark;

    public FantasiaToggleButtonsPanel(int n) {
        this(n, true);
    }

    public FantasiaToggleButtonsPanel(int n, boolean bl) {
        super(true, false, false);
        this.dark = bl;
        this.setLayout(new BoxLayout(this, 0));
        this.setButtonNumber(n);
    }

    public void setButtonNumber(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("button number should be greater than 0");
        }
        this.buttons.removeAllElements();
        this.buttons.add(new FirstButton());
        for (int i = 1; i < n - 1; ++i) {
            this.buttons.add(new MiddleButton());
        }
        if (n > 1) {
            this.buttons.add(new LastButton());
        }
        this.removeAll();
        for (JToggleButton jToggleButton : this.buttons) {
            this.buttonGroup.add(jToggleButton);
            this.add(jToggleButton);
        }
    }

    private class LastButton
    extends BasicButton {
        private LastButton() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            FantasiaPainter.RoundCorners roundCorners = new FantasiaPainter.RoundCorners(false, false, true, true);
            this.paintButton(graphics, roundCorners);
        }
    }

    private class MiddleButton
    extends BasicButton {
        private MiddleButton() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            FantasiaPainter.RoundCorners roundCorners = new FantasiaPainter.RoundCorners(false, false, false, false);
            this.paintButton(graphics, roundCorners);
        }
    }

    private class FirstButton
    extends BasicButton {
        private FirstButton() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            FantasiaPainter.RoundCorners roundCorners = new FantasiaPainter.RoundCorners(true, true, false, false);
            this.paintButton(graphics, roundCorners);
        }
    }

    private class BasicButton
    extends JToggleButton {
        BasicButton() {
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setRolloverEnabled(true);
            if (!FantasiaToggleButtonsPanel.this.dark) {
                this.setForeground(new Color(0xD4D4D4));
            }
            this.setFont(this.getFont().deriveFont(11.0f));
        }

        @Override
        public void updateUI() {
            this.setUI(new BasicButtonUI());
        }

        protected void paintButton(Graphics graphics, FantasiaPainter.RoundCorners roundCorners) {
            Color color;
            Color color2;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            Composite composite = graphics2D.getComposite();
            double d = this.getSize().getWidth();
            double d2 = this.getSize().getHeight();
            if (FantasiaToggleButtonsPanel.this.dark) {
                color2 = this.getModel().isRollover() ? FantasiaPainter.color4 : FantasiaPainter.color2;
                Color color3 = color = this.getModel().isRollover() ? FantasiaPainter.color2 : FantasiaPainter.color1;
                if (this.getModel().isSelected() || this.getModel().isPressed()) {
                    color2 = FantasiaPainter.color2;
                    color = FantasiaPainter.color4;
                }
            } else {
                color2 = this.getModel().isRollover() ? FantasiaPainter.color6 : FantasiaPainter.color5;
                Color color4 = color = this.getModel().isRollover() ? FantasiaPainter.color5 : FantasiaPainter.color4;
                if (this.getModel().isSelected() || this.getModel().isPressed()) {
                    color2 = FantasiaPainter.color6;
                    color = FantasiaPainter.color7;
                }
            }
            FantasiaPainter.paintGradient(graphics2D, 0.0, 0.0, d - 1.0, d2 - 1.0, color2, color);
            if (this.getModel().isPressed()) {
                FantasiaPainter.paintInnerBorder(graphics2D, 0.0, 0.0, d - 1.0, d2 - 1.0, false, 0.5f, 1.0f);
            } else {
                FantasiaPainter.paintOuterBorder(graphics2D, 0.0, 0.0, d - 1.0, d2 - 1.0, roundCorners);
            }
            graphics2D.setComposite(composite);
            graphics2D.setPaint(paint);
            super.paintComponent(graphics);
        }
    }
}

