/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.oql;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.heapviewer.java.ClassNode;
import org.graalvm.visualvm.heapviewer.java.ClassesContainer;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.InstancesContainer;
import org.graalvm.visualvm.heapviewer.model.ContainerNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.ProgressNode;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.model.TextNode;
import org.graalvm.visualvm.heapviewer.oql.Bundle;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.heapviewer.utils.HeapUtils;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.oql.engine.api.OQLEngine;
import org.graalvm.visualvm.lib.profiler.oql.engine.api.OQLException;
import org.graalvm.visualvm.lib.profiler.oql.engine.api.ReferenceChain;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.openide.util.RequestProcessor;

class OQLQueryExecutor {
    private final OQLEngine engine;
    private boolean collectObjects = true;
    private volatile boolean hasObjectsResults;
    private Set<Object> queryObjects;
    private boolean collectHTML = true;
    private int htmlResultsLimit;
    private volatile boolean hasHTMLResults;
    private String queryHTML;
    private final AtomicBoolean queryRunning;
    private final ExecutorService progressUpdater;
    private static final String INSTANCE_LINK_PREFIX = "<a href='file://instance/";
    private static final String STRING_INSTANCE_LINK_NAME_PREFIX = "' name='";
    private static final String INSTANCE_LINK_SUFFIX = "</a>";
    private static final String CLASS_LINK_PREFIX = "<a href='file://class/";
    private static final String STRING_CLASS_LINK_NAME_PREFIX = "' name='";
    private static final String CLASS_LINK_SUFFIX = "</a>";

    OQLQueryExecutor(OQLEngine engine) {
        this.engine = engine;
        this.queryHTML = OQLQueryExecutor.htmlize(Bundle.OQLQueryExecutor_NothingExecuted());
        this.queryRunning = new AtomicBoolean(false);
        this.progressUpdater = Executors.newSingleThreadExecutor();
    }

    void runQuery(String queryString, boolean collectObjects, boolean collectHTML, int htmlResultsLimit) {
        this.collectObjects = collectObjects;
        this.collectHTML = collectHTML;
        this.htmlResultsLimit = htmlResultsLimit;
        this.runQuery(queryString);
    }

    void cancelQuery() {
        String errorMessage = null;
        try {
            this.engine.cancelQuery();
        }
        catch (OQLException e) {
            errorMessage = e.getLocalizedMessage().replace("\n", "<br>").replace("\r", "<br>");
        }
        this.queryRunning.compareAndSet(true, false);
        this.queryFinished(this.hasObjectsResults, this.hasHTMLResults, errorMessage);
    }

    boolean isQueryRunning() {
        return this.queryRunning.get();
    }

    protected void queryStarted(BoundedRangeModel model) {
    }

    protected void queryFinished(boolean hasObjectsResults, boolean hasHTMLResults, String errorMessage) {
    }

    HeapViewerNode[] getQueryObjects(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress, int aggregation) throws InterruptedException {
        if (!this.collectObjects) {
            return new HeapViewerNode[]{new TextNode(Bundle.OQLQueryExecutor_ObjectsNotCollected())};
        }
        if (this.queryObjects == null) {
            return new HeapViewerNode[]{new TextNode(Bundle.OQLQueryExecutor_NothingExecuted())};
        }
        if (this.isQueryRunning()) {
            return new HeapViewerNode[]{new ProgressNode(Bundle.OQLQueryExecutor_QueryRunning())};
        }
        return this.getObjects(root, heap, viewID, viewFilter, dataTypes, sortOrders, progress, aggregation);
    }

    String getQueryHTML() {
        return this.queryHTML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HeapViewerNode[] getObjects(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress, int aggregation) throws InterruptedException {
        if (aggregation == 0) {
            HeapViewerNode[] heapViewerNodeArray;
            NodesComputer<Object> computer = new NodesComputer<Object>(this.queryObjects.size(), UIThresholds.MAX_OQL_TOPLEVEL_INSTANCES){

                @Override
                protected boolean sorts(DataType dataType) {
                    return true;
                }

                @Override
                protected HeapViewerNode createNode(Object object) {
                    return object instanceof Instance ? new InstanceNode((Instance)object) : new ClassNode((JavaClass)object);
                }

                @Override
                protected ProgressIterator<Object> objectsIterator(int index, Progress progress) {
                    Iterator iterator = OQLQueryExecutor.this.queryObjects.iterator();
                    return new ProgressIterator<Object>(iterator, index, true, progress);
                }

                @Override
                protected String getMoreNodesString(String moreNodesCount) {
                    return Messages.getMoreNodesString(moreNodesCount);
                }

                @Override
                protected String getSamplesContainerString(String objectsCount) {
                    return Messages.getSamplesContainerString(objectsCount);
                }

                @Override
                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Messages.getNodesContainerString(firstNodeIdx, lastNodeIdx);
                }
            };
            HeapViewerNode[] nodes = computer.computeNodes(root, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
            if (nodes.length == 0) {
                HeapViewerNode[] heapViewerNodeArray2 = new HeapViewerNode[1];
                heapViewerNodeArray = heapViewerNodeArray2;
                heapViewerNodeArray2[0] = new TextNode(Messages.getNoObjectsString(viewFilter));
            } else {
                heapViewerNodeArray = nodes;
            }
            return heapViewerNodeArray;
        }
        try {
            HeapViewerNode[] heapViewerNodeArray;
            String className;
            progress.setupUnknownSteps();
            ArrayList<InstancesContainer.Objects> cnodes = new ArrayList<InstancesContainer.Objects>();
            HashMap<String, InstancesContainer.Objects> classes = new HashMap<String, InstancesContainer.Objects>();
            for (Object object : this.queryObjects) {
                JavaClass javaClass;
                progress.step();
                Instance instance = object instanceof Instance ? (Instance)object : null;
                JavaClass javaClass2 = javaClass = instance != null ? instance.getJavaClass() : (JavaClass)object;
                if (viewFilter != null && !viewFilter.passes(new ClassNode(javaClass), heap)) continue;
                className = javaClass.getName();
                InstancesContainer.Objects cnode = (InstancesContainer.Objects)((Object)classes.get(className));
                if (cnode == null) {
                    cnode = new InstancesContainer.Objects(className, javaClass){

                        @Override
                        protected String getMoreNodesString(String moreNodesCount) {
                            return Messages.getMoreNodesString(moreNodesCount);
                        }

                        @Override
                        protected String getSamplesContainerString(String objectsCount) {
                            return Messages.getSamplesContainerString(objectsCount);
                        }

                        @Override
                        protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                            return Messages.getNodesContainerString(firstNodeIdx, lastNodeIdx);
                        }
                    };
                    classes.put(className, cnode);
                    cnodes.add(cnode);
                }
                if (instance == null) continue;
                cnode.add(instance, heap);
            }
            if (aggregation == 1) {
                HeapViewerNode[] heapViewerNodeArray3;
                if (cnodes.isEmpty()) {
                    HeapViewerNode[] heapViewerNodeArray4 = new HeapViewerNode[1];
                    heapViewerNodeArray3 = heapViewerNodeArray4;
                    heapViewerNodeArray4[0] = new TextNode(Messages.getNoObjectsString(viewFilter));
                } else {
                    heapViewerNodeArray3 = cnodes.toArray(HeapViewerNode.NO_NODES);
                }
                HeapViewerNode[] heapViewerNodeArray5 = heapViewerNodeArray3;
                return heapViewerNodeArray5;
            }
            ArrayList<ContainerNode> pnodes = new ArrayList<ContainerNode>();
            HashMap<String, ClassesContainer.ContainerNodes> packages = new HashMap<String, ClassesContainer.ContainerNodes>();
            for (InstancesContainer.Objects cnode : cnodes) {
                className = cnode.getName();
                int nameIdx = className.lastIndexOf(46);
                if (nameIdx == -1) {
                    pnodes.add(cnode);
                    continue;
                }
                String pkgName = className.substring(0, nameIdx);
                ClassesContainer.ContainerNodes node = (ClassesContainer.ContainerNodes)((Object)packages.get(pkgName));
                if (node == null) {
                    node = new ClassesContainer.ContainerNodes(pkgName);
                    pnodes.add(node);
                    packages.put(pkgName, node);
                }
                node.add(cnode, heap);
            }
            if (pnodes.isEmpty()) {
                HeapViewerNode[] heapViewerNodeArray6 = new HeapViewerNode[1];
                heapViewerNodeArray = heapViewerNodeArray6;
                heapViewerNodeArray6[0] = new TextNode(Messages.getNoObjectsString(viewFilter));
            } else {
                heapViewerNodeArray = pnodes.toArray(HeapViewerNode.NO_NODES);
            }
            HeapViewerNode[] heapViewerNodeArray7 = heapViewerNodeArray;
            return heapViewerNodeArray7;
        }
        finally {
            progress.finish();
        }
    }

    private void runQuery(final String queryString) {
        new RequestProcessor("OQL Query Processor").post(new Runnable(){

            @Override
            public void run() {
                if (OQLQueryExecutor.this.queryObjects == null) {
                    OQLQueryExecutor.this.queryObjects = new HashSet();
                }
                OQLQueryExecutor.this.queryObjects.clear();
                OQLQueryExecutor.this.hasObjectsResults = false;
                OQLQueryExecutor.this.queryHTML = !OQLQueryExecutor.this.collectHTML ? OQLQueryExecutor.htmlize(Bundle.OQLQueryExecutor_ObjectsNotCollected()) : OQLQueryExecutor.htmlize(Bundle.OQLQueryExecutor_QueryRunning());
                OQLQueryExecutor.this.hasHTMLResults = false;
                DefaultBoundedRangeModel progressModel = new DefaultBoundedRangeModel(0, 10, 0, 100);
                final AtomicInteger counter = new AtomicInteger(OQLQueryExecutor.this.htmlResultsLimit);
                progressModel.setMaximum(100);
                final StringBuilder sb = new StringBuilder();
                final boolean[] oddRow = new boolean[1];
                Color oddRowBackground = UIUtils.getDarker((Color)UIUtils.getProfilerResultsBackground());
                final String oddRowBackgroundString = "rgb(" + oddRowBackground.getRed() + "," + oddRowBackground.getGreen() + "," + oddRowBackground.getBlue() + ")";
                sb.append("<table border='0' width='100%'>");
                try {
                    OQLQueryExecutor.this.queryRunning.compareAndSet(false, true);
                    OQLQueryExecutor.this.queryStarted(progressModel);
                    OQLQueryExecutor.this.progressUpdater.submit(new ProgressUpdater(progressModel));
                    OQLQueryExecutor.this.engine.executeQuery(queryString, new OQLEngine.ObjectVisitor(){

                        public boolean visit(Object o) {
                            boolean collectingHtml;
                            boolean bl = collectingHtml = OQLQueryExecutor.this.collectHTML && counter.decrementAndGet() >= 0;
                            if (collectingHtml) {
                                sb.append(oddRow[0] ? "<tr><td style='background-color: " + oddRowBackgroundString + ";'>" : "<tr><td>");
                                oddRow[0] = !oddRow[0];
                            }
                            OQLQueryExecutor.this.dump(o, collectingHtml ? sb : null);
                            if (collectingHtml) {
                                sb.append("</td></tr>");
                            }
                            return OQLQueryExecutor.this.engine.isCancelled();
                        }
                    });
                    int count = counter.get();
                    if (count < 0) {
                        sb.append("<tr><td>");
                        sb.append("&lt;" + Bundle.OQLQueryExecutor_TooManyResults(OQLQueryExecutor.this.htmlResultsLimit) + "&gt;");
                        sb.append("</td></tr>");
                    }
                    sb.append("</table>");
                    OQLQueryExecutor.this.queryHTML = count != OQLQueryExecutor.this.htmlResultsLimit ? sb.toString() : OQLQueryExecutor.htmlize(Bundle.OQLQueryExecutor_NoResults());
                    OQLQueryExecutor.this.queryRunning.compareAndSet(true, false);
                    OQLQueryExecutor.this.queryFinished(OQLQueryExecutor.this.hasObjectsResults, OQLQueryExecutor.this.hasHTMLResults, null);
                }
                catch (OQLException oQLException) {
                    Logger.getLogger(OQLQueryExecutor.class.getName()).log(Level.INFO, "Error executing OQL", oQLException);
                    StringBuilder errorMessage = new StringBuilder();
                    errorMessage.append("<h2>").append(Bundle.OQLQueryExecutor_QueryError()).append("</h2>");
                    errorMessage.append(Bundle.OQLQueryExecutor_BadQuery());
                    errorMessage.append("<hr>");
                    errorMessage.append(oQLException.getLocalizedMessage().replace("\n", "<br>").replace("\r", "<br>"));
                    OQLQueryExecutor.this.queryRunning.compareAndSet(true, false);
                    OQLQueryExecutor.this.queryFinished(OQLQueryExecutor.this.hasObjectsResults, OQLQueryExecutor.this.hasHTMLResults, errorMessage.toString());
                }
            }
        });
    }

    private void dump(Object o, StringBuilder sb) {
        if (o == null) {
            return;
        }
        if (o instanceof Instance) {
            Instance i = (Instance)o;
            this.queryObjects.add(i);
            this.hasObjectsResults = true;
            if (sb != null) {
                sb.append(HeapUtils.instanceToHtml(i, true, null));
                this.hasHTMLResults = true;
            }
        } else if (o instanceof JavaClass) {
            JavaClass c = (JavaClass)o;
            this.queryObjects.add(c);
            this.hasObjectsResults = true;
            if (sb != null) {
                sb.append(HeapUtils.classToHtml(c));
                this.hasHTMLResults = true;
            }
        } else if (o instanceof ReferenceChain) {
            boolean first = true;
            for (ReferenceChain rc = (ReferenceChain)o; rc != null; rc = rc.getNext()) {
                if (!first) {
                    if (sb != null) {
                        sb.append("-&gt;");
                    }
                } else {
                    first = false;
                }
                if ((o = rc.getObj()) instanceof Instance) {
                    Instance i = (Instance)o;
                    this.queryObjects.add(i);
                    this.hasObjectsResults = true;
                    if (sb == null) continue;
                    sb.append(HeapUtils.instanceToHtml(i, true, null));
                    this.hasHTMLResults = true;
                    continue;
                }
                if (!(o instanceof JavaClass)) continue;
                JavaClass c = (JavaClass)o;
                this.queryObjects.add(c);
                this.hasObjectsResults = true;
                if (sb == null) continue;
                sb.append(HeapUtils.classToHtml(c));
                this.hasHTMLResults = true;
            }
        } else if (o instanceof Map) {
            Set entries = ((Map)o).entrySet();
            if (sb != null) {
                sb.append("<span><b>{</b><br/>");
                this.hasHTMLResults = true;
            }
            boolean first = true;
            for (Map.Entry entry : entries) {
                if (!first) {
                    if (sb != null) {
                        sb.append(",<br/>");
                    }
                } else {
                    first = false;
                }
                if (sb != null) {
                    sb.append(entry.getKey().toString().replace("<", "&lt;").replace(">", "&gt;"));
                    sb.append(" = ");
                }
                this.dump(this.unwrap(entry.getValue()), sb);
            }
            if (sb != null) {
                sb.append("<br/><b>}</b></span>");
            }
        } else if (o instanceof Object[]) {
            if (sb != null) {
                sb.append("<span><b>[</b>&nbsp;");
                this.hasHTMLResults = true;
            }
            boolean first = true;
            for (Object obj1 : (Object[])o) {
                if (!first) {
                    if (sb != null) {
                        sb.append(", ");
                    }
                } else {
                    first = false;
                }
                this.dump(this.unwrap(obj1), sb);
            }
            if (sb != null) {
                sb.append("&nbsp;<b>]</b></span>");
            }
        } else {
            String s = o.toString();
            if (sb != null) {
                sb.append(s);
                this.hasHTMLResults = true;
            }
            if (this.collectObjects) {
                this.extractObjects(s);
            }
        }
    }

    private void extractObjects(String s) {
        int classIdx;
        int instanceIdx = s.indexOf(INSTANCE_LINK_PREFIX);
        int n = classIdx = instanceIdx != -1 ? -1 : s.indexOf(CLASS_LINK_PREFIX);
        while (instanceIdx != -1 || classIdx != -1) {
            if (instanceIdx != -1) {
                s = s.substring(instanceIdx + INSTANCE_LINK_PREFIX.length());
                String instanceNumber = s.substring(0, s.indexOf("' name='"));
                s = s.substring(s.indexOf("</a>") + "</a>".length());
                long instanceID = Long.parseLong(instanceNumber);
                Instance i = this.engine.getHeap().getInstanceByID(instanceID);
                if (i != null) {
                    this.queryObjects.add(i);
                    this.hasObjectsResults = true;
                }
            } else {
                s = s.substring(classIdx + CLASS_LINK_PREFIX.length());
                String classNumber = s.substring(0, s.indexOf("' name='"));
                s = s.substring(s.indexOf("</a>") + "</a>".length());
                long classID = Long.parseLong(classNumber);
                JavaClass c = this.engine.getHeap().getJavaClassByID(classID);
                if (c != null) {
                    this.queryObjects.add(c);
                    this.hasObjectsResults = true;
                }
            }
            instanceIdx = s.indexOf(INSTANCE_LINK_PREFIX);
            classIdx = instanceIdx != -1 ? -1 : s.indexOf(CLASS_LINK_PREFIX);
        }
    }

    private Object unwrap(Object obj1) {
        Object obj2 = this.engine.unwrapJavaObject(obj1, true);
        return obj2 != null ? obj2 : obj1;
    }

    private static String htmlize(String s) {
        return "<p>&nbsp;&nbsp" + s.replace("<", "&lt;").replace(">", "&gt;") + "</p>";
    }

    private class ProgressUpdater
    implements Runnable {
        private final BoundedRangeModel progressModel;

        ProgressUpdater(BoundedRangeModel model) {
            this.progressModel = model;
        }

        @Override
        public void run() {
            while (OQLQueryExecutor.this.queryRunning.get()) {
                int val = this.progressModel.getValue() + 10;
                if (val > this.progressModel.getMaximum()) {
                    val = this.progressModel.getMinimum();
                }
                final int newVal = val;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressUpdater.this.progressModel.setValue(newVal);
                    }
                });
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static class Messages {
        private Messages() {
        }

        static String getMoreNodesString(String moreNodesCount) {
            return Bundle.OQLQueryExecutor_MoreNodes(moreNodesCount);
        }

        static String getSamplesContainerString(String objectsCount) {
            return Bundle.OQLQueryExecutor_SamplesContainer(objectsCount);
        }

        static String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
            return Bundle.OQLQueryExecutor_NodesContainer(firstNodeIdx, lastNodeIdx);
        }

        static String getNoObjectsString(HeapViewerNodeFilter viewFilter) {
            return viewFilter == null ? Bundle.OQLQueryExecutor_NoClasses() : Bundle.OQLQueryExecutor_NoClassesFilter();
        }
    }
}

