/* $NoKeywords:$ */
/**
 * @file
 *
 * Collectively assign unique filecodes for assert and debug to each source file.
 *
 * Publish values for decorated filenames, which can be used for
 * ASSERT and debug support using a preprocessor define like:
 * @n <tt> \#define FILECODE MY_C_FILENAME_FILECODE </tt> @n
 * This file serves as a reference for debugging to associate the code and filename.
 *
 * @xrefitem bom "File Content Label" "Release Content"
 * @e project:      AGESA
 * @e sub-project:  Include
 * @e \$Revision: 56033 $   @e \$Date: 2011-07-06 01:12:20 -0600 (Wed, 06 Jul 2011) $
 */
/*****************************************************************************
 *
 * Copyright (C) 2012 Advanced Micro Devices, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Advanced Micro Devices, Inc. nor the names of
 *       its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL ADVANCED MICRO DEVICES, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 ***************************************************************************/

#ifndef _FILECODE_H_
#define _FILECODE_H_

#define UNASSIGNED_FILE_FILECODE                                         (0xFFFF)

/// For debug use in any Platform's options C file.
/// Can be reused for platforms and image builds, since only one options file can be built.
#define PLATFORM_SPECIFIC_OPTIONS_FILECODE                               (0xBBBB)


#define PROC_GNB_COMMON_GNBLIBFEATURES_FILECODE                          (0xA001)
#define PROC_GNB_GFX_FAMILY_LN_F12GFXSERVICES_FILECODE                   (0xA002)
#define PROC_GNB_GFX_FAMILY_ON_F14GFXSERVICES_FILECODE                   (0xA003)
#define PROC_GNB_GFX_GFXCONFIGDATA_FILECODE                              (0xA004)
#define PROC_GNB_GFX_GFXGMCINIT_FILECODE                                 (0xA006)
#define PROC_GNB_GFX_GFXINITATENVPOST_FILECODE                           (0xA010)
#define PROC_GNB_GFX_GFXINITATMIDPOST_FILECODE                           (0xA011)
#define PROC_GNB_GFX_GFXINITATPOST_FILECODE                              (0xA012)
#define PROC_GNB_GFX_GFXINTEGRATEDINFOTABLEINIT_FILECODE                 (0xA013)
#define PROC_GNB_GFX_GFXLIB_FILECODE                                     (0xA014)
#define PROC_GNB_GFX_GFXREGISTERACC_FILECODE                             (0xA015)
#define PROC_GNB_GFX_GFXSTRAPSINIT_FILECODE                              (0xA016)
#define PROC_GNB_GNBINITATEARLY_FILECODE                                 (0xA017)
#define PROC_GNB_GNBINITATENV_FILECODE                                   (0xA020)
#define PROC_GNB_GNBINITATLATE_FILECODE                                  (0xA021)
#define PROC_GNB_GNBINITATMID_FILECODE                                   (0xA022)
#define PROC_GNB_GNBINITATPOST_FILECODE                                  (0xA023)
#define PROC_GNB_GNBINITATRESET_FILECODE                                 (0xA024)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIB_FILECODE                    (0xA025)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBCPUACC_FILECODE              (0xA026)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBHEAP_FILECODE                (0xA027)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBIOACC_FILECODE               (0xA028)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBMEMACC_FILECODE              (0xA029)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBPCI_FILECODE                 (0xA02A)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBPCIACC_FILECODE              (0xA030)
#define PROC_GNB_MODULES_GNBGFXINITLIBV1_GFXCARDINFO_FILECODE            (0xA031)
#define PROC_GNB_MODULES_GNBGFXINITLIBV1_GFXENUMCONNECTORS_FILECODE      (0xA032)
#define PROC_GNB_MODULES_GNBGFXINITLIBV1_GFXPOWERPLAYTABLE_FILECODE      (0xA033)
#define PROC_GNB_MODULES_GNBNBINITLIBV1_GNBNBINITLIBV1_FILECODE          (0xA034)
#define PROC_GNB_MODULES_GNBPCIEALIBV1_PCIEALIB_FILECODE                 (0xA035)
#define PROC_GNB_MODULES_GNBPCIECONFIG_PCIECONFIGDATA_FILECODE           (0xA036)
#define PROC_GNB_MODULES_GNBPCIECONFIG_PCIECONFIGLIB_FILECODE            (0xA037)
#define PROC_GNB_MODULES_GNBPCIECONFIG_PCIEINPUTPARSER_FILECODE          (0xA038)
#define PROC_GNB_MODULES_GNBPCIECONFIG_PCIEMAPTOPOLOGY_FILECODE          (0xA039)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEASPM_FILECODE              (0xA03A)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEASPMBLACKLIST_FILECODE     (0xA03B)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEASPMEXITLATENCY_FILECODE   (0xA03C)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPHYSERVICES_FILECODE       (0xA03D)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPIFSERVICES_FILECODE       (0xA03E)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPORTREGACC_FILECODE        (0xA03F)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPORTSERVICES_FILECODE      (0xA041)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPOWERMGMT_FILECODE         (0xA043)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIESILICONSERVICES_FILECODE   (0xA045)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIETIMER_FILECODE             (0xA046)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIETOPOLOGYSERVICES_FILECODE  (0xA047)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEUTILITYLIB_FILECODE        (0xA048)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEWRAPPERREGACC_FILECODE     (0xA049)
#define PROC_GNB_MODULES_GNBPCIETRAININGV1_PCIETRAINING_FILECODE         (0xA04A)
#define PROC_GNB_MODULES_GNBPCIETRAININGV1_PCIEWORKAROUNDS_FILECODE      (0xA04B)
#define PROC_GNB_NB_FAMILY_LN_F12NBPOWERGATE_FILECODE                  (0xA04C)
#define PROC_GNB_NB_FAMILY_LN_F12NBSERVICES_FILECODE                   (0xA04D)
#define PROC_GNB_NB_FAMILY_LN_F12NBSMU_FILECODE                        (0xA04E)
#define PROC_GNB_NB_FAMILY_ON_F14NBLCLKNCLKRATIO_FILECODE                (0xA04F)
#define PROC_GNB_NB_FAMILY_ON_F14NBPOWERGATE_FILECODE                    (0xA050)
#define PROC_GNB_NB_FAMILY_ON_F14NBSERVICES_FILECODE                     (0xA051)
#define PROC_GNB_NB_FAMILY_ON_F14NBSMU_FILECODE                          (0xA052)
#define PROC_GNB_NB_FEATURE_NBFUSETABLE_FILECODE                         (0xA053)
#define PROC_GNB_NB_FEATURE_NBLCLKDPM_FILECODE                           (0xA054)
#define PROC_GNB_NB_FAMILY_LN_F12NBLCLKDPM_FILECODE                    (0xA055)
#define PROC_GNB_NB_FAMILY_ON_F14NBLCLKDPM_FILECODE                      (0xA056)
#define PROC_GNB_NB_NBCONFIGDATA_FILECODE                                (0xA060)
#define PROC_GNB_NB_NBINIT_FILECODE                                      (0xA061)
#define PROC_GNB_NB_NBINITATEARLY_FILECODE                               (0xA062)
#define PROC_GNB_NB_NBINITATENV_FILECODE                                 (0xA063)
#define PROC_GNB_NB_NBINITATLATEPOST_FILECODE                            (0xA070)
#define PROC_GNB_NB_NBINITATPOST_FILECODE                                (0xA071)
#define PROC_GNB_NB_NBINITATRESET_FILECODE                               (0xA072)
#define PROC_GNB_NB_NBPOWERMGMT_FILECODE                                 (0xA073)
#define PROC_GNB_NB_NBSMULIB_FILECODE                                    (0xA074)
#define PROC_GNB_PCIE_FAMILY_LN_F12PCIEALIB_FILECODE                   (0xA075)
#define PROC_GNB_PCIE_FAMILY_LN_F12PCIECOMPLEXCONFIG_FILECODE          (0xA076)
#define PROC_GNB_PCIE_FAMILY_LN_F12PCIECOMPLEXSERVICES_FILECODE        (0xA077)
#define PROC_GNB_PCIE_FAMILY_LN_F12PCIEPHYSERVICES_FILECODE            (0xA078)
#define PROC_GNB_PCIE_FAMILY_LN_F12PCIEPIFSERVICES_FILECODE            (0xA079)
#define PROC_GNB_PCIE_FAMILY_LN_F12PCIEWRAPPERSERVICES_FILECODE        (0xA07A)
#define PROC_GNB_PCIE_FAMILY_ON_F14PCIEALIB_FILECODE                     (0xA07D)
#define PROC_GNB_PCIE_FAMILY_ON_F14PCIECOMPLEXCONFIG_FILECODE            (0xA07E)
#define PROC_GNB_PCIE_FAMILY_ON_F14PCIECOMPLEXSERVICES_FILECODE          (0xA07F)
#define PROC_GNB_PCIE_FAMILY_ON_F14PCIEPHYSERVICES_FILECODE              (0xA080)
#define PROC_GNB_PCIE_FAMILY_ON_F14PCIEPIFSERVICES_FILECODE              (0xA081)
#define PROC_GNB_PCIE_FAMILY_ON_F14PCIEWRAPPERSERVICES_FILECODE          (0xA082)
#define PROC_GNB_PCIE_FEATURE_PCIEPOWERGATE_FILECODE                     (0xA083)
#define PROC_GNB_PCIE_PCIEINIT_FILECODE                                  (0xA084)
#define PROC_GNB_PCIE_PCIEINITATEARLYPOST_FILECODE                       (0xA085)
#define PROC_GNB_PCIE_PCIEINITATENV_FILECODE                             (0xA086)
#define PROC_GNB_PCIE_PCIEINITATLATEPOST_FILECODE                        (0xA087)
#define PROC_GNB_PCIE_PCIEINITATPOST_FILECODE                            (0xA088)
#define PROC_GNB_PCIE_PCIELATEINIT_FILECODE                              (0xA089)
#define PROC_GNB_PCIE_PCIEPORTINIT_FILECODE                              (0xA08B)
#define PROC_GNB_PCIE_PCIEPORTLATEINIT_FILECODE                          (0xA08C)
#define PROC_GNB_MODULES_GNBCABLESAFE_GNBCABLESAFE_FILECODE              (0xA08D)
#define PROC_GNB_MODULES_GNBGFXCONFIG_GFXCONFIGENV_FILECODE              (0xA08E)
#define PROC_GNB_MODULES_GNBGFXCONFIG_GFXCONFIGPOST_FILECODE             (0xA08F)
#define PROC_GNB_MODULES_GNBTABLE_GNBTABLE_FILECODE                      (0xA090)
#define PROC_GNB_MODULES_GNBGFXINITLIBV1_GNBGFXINITLIBV1_FILECODE        (0xA091)
#define PROC_GNB_MODULES_GNBINITTN_GFXENVINITTN_FILECODE                 (0xA092)
#define PROC_GNB_MODULES_GNBGFXCONFIG_GFXCONFIGLIB_FILECODE              (0xA093)
#define PROC_GNB_MODULES_GNBINITTN_GFXGMCINITTN_FILECODE                 (0xA094)
#define PROC_GNB_MODULES_GNBINITTN_GFXINTEGRATEDINFOTABLETN_FILECODE     (0xA095)
#define PROC_GNB_MODULES_GNBINITTN_GFXLIBTN_FILECODE                     (0xA096)
#define PROC_GNB_MODULES_GNBINITTN_GFXMIDINITTN_FILECODE                 (0xA097)
#define PROC_GNB_MODULES_GNBINITTN_GNBPOSTINITTN_FILECODE                (0xA098)
#define PROC_GNB_MODULES_GNBINITTN_GNBEARLYINITTN_FILECODE               (0xA09A)
#define PROC_GNB_MODULES_GNBINITTN_GNBENVINITTN_FILECODE                 (0xA09B)
#define PROC_GNB_MODULES_GNBINITTN_GNBFUSETABLETN_FILECODE               (0xA09C)
#define PROC_GNB_MODULES_GNBINITTN_GNBMIDINITTN_FILECODE                 (0xA09D)
#define PROC_GNB_MODULES_GNBINITTN_GFXPOSTINITTN_FILECODE                (0xA09E)
#define PROC_GNB_MODULES_GNBINITTN_GNBREGISTERACCTN_FILECODE             (0xA09F)
#define PROC_GNB_MODULES_GNBINITTN_PCIECONFIGTN_FILECODE                 (0xA0A0)
#define PROC_GNB_MODULES_GNBINITTN_PCIEEARLYINITTN_FILECODE              (0xA0A1)
#define PROC_GNB_MODULES_GNBINITTN_PCIEENVINITTN_FILECODE                (0xA0A2)
#define PROC_GNB_MODULES_GNBINITTN_PCIELIBTN_FILECODE                    (0xA0A3)
#define PROC_GNB_MODULES_GNBINITTN_PCIEMIDINITTN_FILECODE                (0xA0A4)
#define PROC_GNB_MODULES_GNBINITTN_PCIEPOSTINITTN_FILECODE               (0xA0A5)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV4_PCIEWRAPPERSERVICESV4_FILECODE (0xA0A6)
#define PROC_GNB_MODULES_GNBIOMMUIVRS_GNBIOMMUIVRS_FILECODE              (0xA0A7)
#define PROC_GNB_MODULES_GNBIVRSLIB_GNBIVRSLIB_FILECODE                  (0xA0A8)
#define PROC_GNB_MODULES_GNBNBINITLIBV4_GNBNBINITLIBV4_FILECODE          (0xA0A9)
#define PROC_GNB_MODULES_GNBFAMTRANSLATION_GNBPCIETRANSLATION_FILECODE   (0xA0AA)
#define PROC_GNB_MODULES_GNBINITTN_GNBIOMMUIVRSTN_FILECODE               (0xA0AB)
#define PROC_GNB_GFX_FAMILY_KR_KRGFXSERVICES_FILECODE                    (0xA0AC)
#define PROC_GNB_NB_FAMILY_KR_KRNBSMU_FILECODE                           (0xA0AD)
#define PROC_GNB_NB_FAMILY_KR_KRNBPOWERGATE_FILECODE                     (0xA0AE)
#define PROC_GNB_NB_FAMILY_KR_KRNBSERVICES_FILECODE                      (0xA0AF)
#define PROC_GNB_NB_FAMILY_KR_KRNBLCLKNCLKRATIO_FILECODE                 (0xA0B0)
#define PROC_GNB_NB_FAMILY_KR_KRNBLCLKDPM_FILECODE                       (0xA0B1)
#define PROC_GNB_PCIE_FAMILY_KR_KRPCIEALIB_FILECODE                      (0xA0B2)
#define PROC_GNB_PCIE_FAMILY_KR_KRPCIECOMPLEXCONFIG_FILECODE             (0xA0B3)
#define PROC_GNB_PCIE_FAMILY_KR_KRPCIECOMPLEXSERVICES_FILECODE           (0xA0B4)
#define PROC_GNB_PCIE_FAMILY_KR_KRPCIEPHYSERVICES_FILECODE               (0xA0B5)
#define PROC_GNB_PCIE_FAMILY_KR_KRPCIEWRAPPERSERVICES_FILECODE           (0xA0B6)
#define PROC_GNB_PCIE_FAMILY_KR_KRPCIEPIFSERVICES_FILECODE               (0xA0B7)
#define PROC_GNB_MODULES_GNBINITTN_PCIEPOWERGATETN_FILECODE              (0xA0B8)
#define PROC_GNB_MODULES_GNBINITTN_PCIEALIBTN_FILECODE                   (0xA0B9)
#define PROC_GNB_MODULES_GNBSBLIB_GNBSBPCIE_FILECODE                     (0xA0BA)
#define PROC_GNB_MODULES_GNBSBLIB_GNBSBLIB_FILECODE                      (0xA0BB)
#define PROC_GNB_MODULES_GNBSBIOMMULIB_GNBSBIOMMULIB_FILECODE            (0xA0BC)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBSTALL_FILECODE               (0xA0BD)
#define PROC_GNB_MODULES_GNBMSOCKETLIB_GNBMSOCKETLIB_FILECODE            (0xA0BE)
#define PROC_GNB_MODULES_GNBSSOCKETLIB_GNBSSOCKETLIB_FILECODE            (0xA0BF)
#define PROC_GNB_MODULES_GNBPCIECONFIG_GNBHANDLELIB_FILECODE             (0xA0C0)

#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEPHYSERVICESV5_FILECODE     (0xA0C5)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEPIFSERVICESV5_FILECODE     (0xA0C6)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEPORTSERVICESV5_FILECODE    (0xA0C7)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEPOWERMGMTV5_FILECODE       (0xA0C8)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIESILICONSERVICESV5_FILECODE (0xA0C9)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEWRAPPERSERVICESV5_FILECODE (0xA0CA)
#define PROC_GNB_MODULES_GNBNBINITLIBV5_GNBNBINITLIBV5_FILECODE          (0xA0CB)

#define PROC_GNB_MODULES_GNBINITKM_GNBEARLYINITKM_FILECODE               (0xA0CC)
#define PROC_GNB_MODULES_GNBINITKM_GNBENVINITKM_FILECODE                 (0xA0CD)
#define PROC_GNB_MODULES_GNBINITKM_GNBIOMMUIVRSKM_FILECODE               (0xA0CE)
#define PROC_GNB_MODULES_GNBINITKM_GNBMIDINITKM_FILECODE                 (0xA0CF)
#define PROC_GNB_MODULES_GNBINITKM_GNBPOSTINITKM_FILECODE                (0xA0D0)
#define PROC_GNB_MODULES_GNBINITKM_GNBREGISTERACCKM_FILECODE             (0xA0D1)
#define PROC_GNB_MODULES_GNBINITKM_PCIECOMPLEXDATAKMC2012_FILECODE       (0xA0D2)
#define PROC_GNB_MODULES_GNBINITKM_PCIECOMPLEXDATAKMFM2_FILECODE         (0xA0D3)
#define PROC_GNB_MODULES_GNBINITKM_PCIECOMPLEXDATAKMG2012_FILECODE       (0xA0D4)
#define PROC_GNB_MODULES_GNBINITKM_PCIECONFIGKM_FILECODE                 (0xA0D5)
#define PROC_GNB_MODULES_GNBINITKM_PCIEEARLYINITKM_FILECODE              (0xA0D6)
#define PROC_GNB_MODULES_GNBINITKM_PCIEENVINITKM_FILECODE                (0xA0D7)
#define PROC_GNB_MODULES_GNBINITKM_PCIELIBKM_FILECODE                    (0xA0D8)
#define PROC_GNB_MODULES_GNBINITKM_PCIEMIDINITKM_FILECODE                (0xA0D9)
#define PROC_GNB_MODULES_GNBINITKM_PCIEPOSTINITKM_FILECODE               (0xA0DA)
#define PROC_GNB_MODULES_GNBFAMTRANSLATION_GNBTRANSLATION_FILECODE       (0xA0DB)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV4_PCIEPOWERMGMTV4_FILECODE       (0xA0DC)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV4_PCIEPORTSERVICESV4_FILECODE    (0xA0DD)

#define PROC_RECOVERY_GNB_GNBRECOVERY_FILECODE                           (0xAE01)
#define PROC_RECOVERY_GNB_NBINITRECOVERY_FILECODE                        (0xAE02)

// FCH
#define PROC_FCH_AZALIA_AZALIARESET_FILECODE                             (0xB001)
#define PROC_FCH_AZALIA_AZALIAENV_FILECODE                               (0xB002)
#define PROC_FCH_AZALIA_AZALIAMID_FILECODE                               (0xB003)
#define PROC_FCH_AZALIA_AZALIALATE_FILECODE                              (0xB004)
#define PROC_FCH_COMMON_ACPILIB_FILECODE                                 (0xB010)
#define PROC_FCH_COMMON_FCHLIB_FILECODE                                  (0xB011)
#define PROC_FCH_COMMON_FCHCOMMON_FILECODE                               (0xB012)
#define PROC_FCH_COMMON_FCHCOMMONSMM_FILECODE                            (0xB013)
#define PROC_FCH_COMMON_MEMLIB_FILECODE                                  (0xB014)
#define PROC_FCH_COMMON_PCILIB_FILECODE                                  (0xB015)
#define PROC_FCH_COMMON_FCHPELIB_FILECODE                                (0xB016)
#define PROC_FCH_GEC_GECRESET_FILECODE                                   (0xB020)
#define PROC_FCH_GEC_GECENV_FILECODE                                     (0xB021)
#define PROC_FCH_GEC_GECMID_FILECODE                                     (0xB022)
#define PROC_FCH_GEC_GECLATE_FILECODE                                    (0xB023)
#define PROC_FCH_GEC_FAMILY_HUDSON2_HUDSON2GECSERVICE_FILECODE           (0xB024)
#define PROC_FCH_GEC_FAMILY_HUDSON2_HUDSON2GECENVSERVICE_FILECODE        (0xB025)
#define PROC_FCH_GEC_FAMILY_YUBA_YUBAGECSERVICE_FILECODE                 (0xB026)
#define PROC_FCH_GEC_FAMILY_YUBA_YUBAGECENVSERVICE_FILECODE              (0xB027)
#define PROC_FCH_HWACPI_HWACPIRESET_FILECODE                             (0xB030)
#define PROC_FCH_HWACPI_HWACPIENV_FILECODE                               (0xB031)
#define PROC_FCH_HWACPI_HWACPIMID_FILECODE                               (0xB032)
#define PROC_FCH_HWACPI_HWACPILATE_FILECODE                              (0xB033)
#define PROC_FCH_HWACPI_FAMILY_HUDSON2_HUDSON2HWACPIENVSERVICE_FILECODE  (0xB034)
#define PROC_FCH_HWACPI_FAMILY_HUDSON2_HUDSON2HWACPIMIDSERVICE_FILECODE  (0xB035)
#define PROC_FCH_HWACPI_FAMILY_HUDSON2_HUDSON2HWACPILATESERVICE_FILECODE (0xB036)
#define PROC_FCH_HWACPI_FAMILY_HUDSON2_HUDSON2SSSERVICE_FILECODE         (0xB037)
#define PROC_FCH_HWACPI_FAMILY_YUBA_YUBAHWACPIENVSERVICE_FILECODE        (0xB038)
#define PROC_FCH_HWACPI_FAMILY_YUBA_YUBAHWACPIMIDSERVICE_FILECODE        (0xB039)
#define PROC_FCH_HWACPI_FAMILY_YUBA_YUBAHWACPILATESERVICE_FILECODE       (0xB03A)
#define PROC_FCH_HWACPI_FAMILY_YUBA_YUBASSSERVICE_FILECODE               (0xB03B)
#define PROC_FCH_HWM_HWMRESET_FILECODE                                   (0xB040)
#define PROC_FCH_HWM_HWMENV_FILECODE                                     (0xB041)
#define PROC_FCH_HWM_HWMMID_FILECODE                                     (0xB042)
#define PROC_FCH_HWM_HWMLATE_FILECODE                                    (0xB043)
#define PROC_FCH_HWM_FAMILY_HUDSON2_HUDSON2HWMENVSERVICE_FILECODE        (0xB044)
#define PROC_FCH_HWM_FAMILY_HUDSON2_HUDSON2HWMMIDSERVICE_FILECODE        (0xB045)
#define PROC_FCH_HWM_FAMILY_HUDSON2_HUDSON2HWMLATESERVICE_FILECODE       (0xB046)
#define PROC_FCH_HWM_FAMILY_YUBA_YUBAHWMENVSERVICE_FILECODE              (0xB047)
#define PROC_FCH_HWM_FAMILY_YUBA_YUBAHWMMIDSERVICE_FILECODE              (0xB048)
#define PROC_FCH_HWM_FAMILY_YUBA_YUBAHWMLATESERVICE_FILECODE             (0xB049)
#define PROC_FCH_IDE_IDEENV_FILECODE                                     (0xB050)
#define PROC_FCH_IDE_IDEMID_FILECODE                                     (0xB051)
#define PROC_FCH_IDE_IDELATE_FILECODE                                    (0xB052)
#define PROC_FCH_IMC_IMCENV_FILECODE                                     (0xB060)
#define PROC_FCH_IMC_IMCMID_FILECODE                                     (0xB061)
#define PROC_FCH_IMC_IMCLATE_FILECODE                                    (0xB062)
#define PROC_FCH_IMC_IMCLIB_FILECODE                                     (0xB063)
#define PROC_FCH_IMC_IMCRESET_FILECODE                                   (0xB064)
#define PROC_FCH_IMC_FCHECENV_FILECODE                                   (0xB065)
#define PROC_FCH_IMC_FCHECMID_FILECODE                                   (0xB066)
#define PROC_FCH_IMC_FCHECLATE_FILECODE                                  (0xB067)
#define PROC_FCH_IMC_FCHECRESET_FILECODE                                 (0xB068)
#define PROC_FCH_IMC_FAMILY_HUDSON2_HUDSON2IMCSERVICE_FILECODE           (0xB069)
#define PROC_FCH_IMC_FAMILY_YUBA_YUBAIMCSERVICE_FILECODE                 (0xB06A)
#define PROC_FCH_INTERFACE_INITRESETDEF_FILECODE                         (0xB070)
#define PROC_FCH_INTERFACE_INITENVDEF_FILECODE                           (0xB071)
#define PROC_FCH_INTERFACE_FCHINITRESET_FILECODE                         (0xB072)
#define PROC_FCH_INTERFACE_FCHINITENV_FILECODE                           (0xB073)
#define PROC_FCH_INTERFACE_FCHINITLATE_FILECODE                          (0xB074)
#define PROC_FCH_INTERFACE_FCHINITMID_FILECODE                           (0xB075)
#define PROC_FCH_INTERFACE_FCHINITS3_FILECODE                            (0xB076)
#define PROC_FCH_INTERFACE_FCHTASKLAUNCHER_FILECODE                      (0xB077)
#define PROC_FCH_IR_IRENV_FILECODE                                       (0xB080)
#define PROC_FCH_IR_IRMID_FILECODE                                       (0xB081)
#define PROC_FCH_IR_IRLATE_FILECODE                                      (0xB082)
#define PROC_FCH_PCIB_PCIBRESET_FILECODE                                 (0xB090)
#define PROC_FCH_PCIB_PCIBENV_FILECODE                                   (0xB091)
#define PROC_FCH_PCIB_PCIBMID_FILECODE                                   (0xB092)
#define PROC_FCH_PCIB_PCIBLATE_FILECODE                                  (0xB093)
#define PROC_FCH_PCIE_ABRESET_FILECODE                                   (0xB0A0)
#define PROC_FCH_PCIE_ABENV_FILECODE                                     (0xB0A1)
#define PROC_FCH_PCIE_ABMID_FILECODE                                     (0xB0A2)
#define PROC_FCH_PCIE_ABLATE_FILECODE                                    (0xB0A3)
#define PROC_FCH_PCIE_GPPHP_FILECODE                                     (0xB0A4)
#define PROC_FCH_PCIE_GPPLIB_FILECODE                                    (0xB0A5)
#define PROC_FCH_PCIE_GPPRESET_FILECODE                                  (0xB0A6)
#define PROC_FCH_PCIE_GPPENV_FILECODE                                    (0xB0A7)
#define PROC_FCH_PCIE_GPPMID_FILECODE                                    (0xB0A8)
#define PROC_FCH_PCIE_GPPLATE_FILECODE                                   (0xB0A9)
#define PROC_FCH_PCIE_PCIERESET_FILECODE                                 (0xB0AA)
#define PROC_FCH_PCIE_PCIEENV_FILECODE                                   (0xB0AB)
#define PROC_FCH_PCIE_PCIEMID_FILECODE                                   (0xB0AC)
#define PROC_FCH_PCIE_PCIELATE_FILECODE                                  (0xB0AD)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2ABRESETSERVICE_FILECODE      (0xB0AE)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2ABENVSERVICE_FILECODE        (0xB0AF)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2ABSERVICE_FILECODE           (0xB0B0)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2GPPRESETSERVICE_FILECODE     (0xB0B1)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2GPPSERVICE_FILECODE          (0xB0B2)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2PCIEENVSERVICE_FILECODE      (0xB0B3)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2PCIESERVICE_FILECODE         (0xB0B4)
#define PROC_FCH_PCIE_FAMILY_YUBA_YUBAABRESETSERVICE_FILECODE            (0xB0B5)
#define PROC_FCH_PCIE_FAMILY_YUBA_YUBAABENVSERVICE_FILECODE              (0xB0B6)
#define PROC_FCH_PCIE_FAMILY_YUBA_YUBAABSERVICE_FILECODE                 (0xB0B7)
#define PROC_FCH_SATA_AHCIENV_FILECODE                                   (0xB0C0)
#define PROC_FCH_SATA_AHCIMID_FILECODE                                   (0xB0C1)
#define PROC_FCH_SATA_AHCILATE_FILECODE                                  (0xB0C2)
#define PROC_FCH_SATA_AHCILIB_FILECODE                                   (0xB0C3)
#define PROC_FCH_SATA_IDE2AHCIENV_FILECODE                               (0xB0C4)
#define PROC_FCH_SATA_IDE2AHCIMID_FILECODE                               (0xB0C5)
#define PROC_FCH_SATA_IDE2AHCILATE_FILECODE                              (0xB0C6)
#define PROC_FCH_SATA_IDE2AHCILIB_FILECODE                               (0xB0C7)
#define PROC_FCH_SATA_RAIDENV_FILECODE                                   (0xB0C8)
#define PROC_FCH_SATA_RAIDMID_FILECODE                                   (0xB0C9)
#define PROC_FCH_SATA_RAIDLATE_FILECODE                                  (0xB0CA)
#define PROC_FCH_SATA_RAIDLIB_FILECODE                                   (0xB0CB)
#define PROC_FCH_SATA_SATAENV_FILECODE                                   (0xB0CC)
#define PROC_FCH_SATA_SATAENVLIB_FILECODE                                (0xB0CD)
#define PROC_FCH_SATA_SATAIDEENV_FILECODE                                (0xB0CE)
#define PROC_FCH_SATA_SATAIDEMID_FILECODE                                (0xB0CF)
#define PROC_FCH_SATA_SATAIDELATE_FILECODE                               (0xB0D0)
#define PROC_FCH_SATA_SATAIDELIB_FILECODE                                (0xB0D1)
#define PROC_FCH_SATA_SATAMID_FILECODE                                   (0xB0D2)
#define PROC_FCH_SATA_SATALATE_FILECODE                                  (0xB0D3)
#define PROC_FCH_SATA_SATALIB_FILECODE                                   (0xB0D4)
#define PROC_FCH_SATA_SATARESET_FILECODE                                 (0xB0D5)
#define PROC_FCH_SATA_FAMILY_HUDSON2_HUDSON2SATARESETSERVICE_FILECODE    (0xB0D6)
#define PROC_FCH_SATA_FAMILY_HUDSON2_HUDSON2SATAENVSERVICE_FILECODE      (0xB0D7)
#define PROC_FCH_SATA_FAMILY_HUDSON2_HUDSON2SATASERVICE_FILECODE         (0xB0D8)
#define PROC_FCH_SATA_FAMILY_YUBA_YUBASATARESETSERVICE_FILECODE          (0xB0D9)
#define PROC_FCH_SATA_FAMILY_YUBA_YUBASATAENVSERVICE_FILECODE            (0xB0DA)
#define PROC_FCH_SATA_FAMILY_YUBA_YUBASATASERVICE_FILECODE               (0xB0DB)
#define PROC_FCH_SD_SDENV_FILECODE                                       (0xB0E0)
#define PROC_FCH_SD_SDMID_FILECODE                                       (0xB0E1)
#define PROC_FCH_SD_SDLATE_FILECODE                                      (0xB0E2)
#define PROC_FCH_SD_FAMILY_HUDSON2_HUDSON2SDSERVICE_FILECODE             (0xB0E3)
#define PROC_FCH_SD_FAMILY_HUDSON2_HUDSON2SDRESETSERVICE_FILECODE        (0xB0E4)
#define PROC_FCH_SD_FAMILY_HUDSON2_HUDSON2SDENVSERVICE_FILECODE          (0xB0E5)
#define PROC_FCH_SD_FAMILY_YUBA_YUBASDSERVICE_FILECODE                   (0xB0E6)
#define PROC_FCH_SD_FAMILY_YUBA_YUBASDRESETSERVICE_FILECODE              (0xB0E7)
#define PROC_FCH_SD_FAMILY_YUBA_YUBASDENVSERVICE_FILECODE                (0xB0E8)
#define PROC_FCH_SPI_LPCRESET_FILECODE                                   (0xB0F0)
#define PROC_FCH_SPI_LPCENV_FILECODE                                     (0xB0F1)
#define PROC_FCH_SPI_LPCMID_FILECODE                                     (0xB0F2)
#define PROC_FCH_SPI_LPCLATE_FILECODE                                    (0xB0F3)
#define PROC_FCH_SPI_SPIRESET_FILECODE                                   (0xB0F4)
#define PROC_FCH_SPI_SPIENV_FILECODE                                     (0xB0F5)
#define PROC_FCH_SPI_SPIMID_FILECODE                                     (0xB0F6)
#define PROC_FCH_SPI_SPILATE_FILECODE                                    (0xB0F7)
#define PROC_FCH_USB_EHCIRESET_FILECODE                                  (0xB100)
#define PROC_FCH_USB_EHCIENV_FILECODE                                    (0xB101)
#define PROC_FCH_USB_EHCIMID_FILECODE                                    (0xB102)
#define PROC_FCH_USB_EHCILATE_FILECODE                                   (0xB103)
#define PROC_FCH_USB_OHCIRESET_FILECODE                                  (0xB104)
#define PROC_FCH_USB_OHCIENV_FILECODE                                    (0xB105)
#define PROC_FCH_USB_OHCIMID_FILECODE                                    (0xB106)
#define PROC_FCH_USB_OHCILATE_FILECODE                                   (0xB107)
#define PROC_FCH_USB_USBRESET_FILECODE                                   (0xB108)
#define PROC_FCH_USB_USBENV_FILECODE                                     (0xB109)
#define PROC_FCH_USB_USBMID_FILECODE                                     (0xB10A)
#define PROC_FCH_USB_USBLATE_FILECODE                                    (0xB10B)
#define PROC_FCH_USB_XHCIRESET_FILECODE                                  (0xB10C)
#define PROC_FCH_USB_XHCIENV_FILECODE                                    (0xB10D)
#define PROC_FCH_USB_XHCIMID_FILECODE                                    (0xB10E)
#define PROC_FCH_USB_XHCILATE_FILECODE                                   (0xB10F)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2EHCIENVSERVICE_FILECODE       (0xB110)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2EHCIMIDSERVICE_FILECODE       (0xB111)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2EHCILATESERVICE_FILECODE      (0xB112)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2OHCIENVSERVICE_FILECODE       (0xB113)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2OHCIMIDSERVICE_FILECODE       (0xB114)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2OHCILATESERVICE_FILECODE      (0xB115)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2XHCIRESETSERVICE_FILECODE     (0xB116)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2XHCIENVSERVICE_FILECODE       (0xB117)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2XHCIMIDSERVICE_FILECODE       (0xB118)
#define PROC_FCH_USB_FAMILY_HUDSON2_HUDSON2XHCILATESERVICE_FILECODE      (0xB119)
#define PROC_FCH_USB_FAMILY_YUBA_YUBAEHCIENVSERVICE_FILECODE          (0xB11A)
#define PROC_FCH_USB_FAMILY_YUBA_YUBAEHCIMIDSERVICE_FILECODE          (0xB11B)
#define PROC_FCH_USB_FAMILY_YUBA_YUBAEHCILATESERVICE_FILECODE         (0xB11C)
#define PROC_FCH_USB_FAMILY_YUBA_YUBAOHCIENVSERVICE_FILECODE          (0xB11D)
#define PROC_FCH_USB_FAMILY_YUBA_YUBAOHCIMIDSERVICE_FILECODE          (0xB11E)
#define PROC_FCH_USB_FAMILY_YUBA_YUBAOHCILATESERVICE_FILECODE         (0xB11F)
#define PROC_FCH_USB_FAMILY_YUBA_YUBAXHCIRESETSERVICE_FILECODE        (0xB120)
#define PROC_FCH_USB_FAMILY_YUBA_YUBAXHCIENVSERVICE_FILECODE          (0xB121)
#define PROC_FCH_USB_FAMILY_YUBA_YUBAXHCIMIDSERVICE_FILECODE          (0xB122)
#define PROC_FCH_USB_FAMILY_YUBA_YUBAXHCILATESERVICE_FILECODE         (0xB123)
#define PROC_FCH_USB_XHCIRECOVERY_FILECODE                            (0xB124)
#define PROC_FCH_PCIE_GPPPORTINIT_FILECODE                            (0xB125)

#define UEFI_DXE_FCHDXE_FCHDXE_FILECODE                              (0xB200)
#define UEFI_DXE_CF9RESET_CF9RESET_FILECODE                              (0xB220)
#define UEFI_DXE_CF9RESET_IA32_IA32CF9RESET_FILECODE                     (0xB221)
#define UEFI_DXE_CF9RESET_X64_X64CF9RESET_FILECODE                       (0xB222)
#define UEFI_DXE_LEGACYINTERRUPT_LEGACYINTERRUPT_FILECODE                (0xB230)
#define UEFI_DXE_SMMCONTROL_SMMCONTROL_FILECODE                          (0xB240)
#define UEFI_SMM_FCHSMMLIB_FCHDXECOMMON_FILECODE              (0xB250)
#define UEFI_SMM_FCHSMMLIB_FCHSMMLIB_FILECODE                 (0xB251)
#define UEFI_DXE_FCHDXELIB_FCHDXELIB_FILECODE                        (0xB252)
#define UEFI_PEI_FCHPEI_FCHPEI_FILECODE                              (0xB260)
#define UEFI_PEI_FCHPEI_FCHRESET_FILECODE                               (0xB261)
#define UEFI_PEI_FCHPEI_FCHSTALL_FILECODE                               (0xB262)
#define UEFI_PEI_FCHPEI_LIBAMDPEI_FILECODE                              (0xB263)
#define UEFI_PEI_SMBUS_SMBUS_FILECODE                                   (0xB270)
#define UEFI_SMM_FCHSMM_FCHSMM_FILECODE                              (0xB280)
#define UEFI_SMM_FCHSMM_GPESMI_FILECODE                                (0xB282)
#define UEFI_SMM_FCHSMM_IOTRAPSMI_FILECODE                             (0xB283)
#define UEFI_SMM_FCHSMM_MISCSMI_FILECODE                               (0xB284)
#define UEFI_SMM_FCHSMM_PERIODICTIMERSMI_FILECODE                      (0xB285)
#define UEFI_SMM_FCHSMM_POWERBUTTONSMI_FILECODE                        (0xB286)
#define UEFI_SMM_FCHSMM_SWSMI_FILECODE                                 (0xB287)
#define UEFI_SMM_FCHSMM_SXSMI_FILECODE                                 (0xB288)
#define UEFI_DXE_SMBUS_SMBUSLIGHT_FILECODE                               (0xB2A0)
#define UEFI_SMM_FCHSMMDISPATCHER_FCHSMMDISPATCHER_FILECODE                     (0xB290)
#define UEFI_SMM_FCHSMMDISPATCHER_FCHSMMGPEDISPATCHER_FCHSMMGPEDISPATCHER_FILECODE        (0xB292)
#define UEFI_SMM_FCHSMMDISPATCHER_FCHSMMIOTRAPDISPATCHER_FCHSMMIOTRAPDISPATCHER_FILECODE  (0xB293)
#define UEFI_SMM_FCHSMMDISPATCHER_FCHSMMMISCDISPATCHER_FCHSMMMISCDISPATCHER_FILECODE      (0xB294)
#define UEFI_SMM_FCHSMMDISPATCHER_FCHSMMPERIODICALDISPATCHER_FCHSMMPERIODICALDISPATCHER_FILECODE (0xB295)
#define UEFI_SMM_FCHSMMDISPATCHER_FCHSMMPWRBTNDISPATCHER_FCHSMMPWRBTNDISPATCHER_FILECODE  (0xB296)
#define UEFI_SMM_FCHSMMDISPATCHER_FCHSMMSWDISPATCHER_FCHSMMSWDISPATCHER_FILECODE          (0xB297)
#define UEFI_SMM_FCHSMMDISPATCHER_FCHSMMSXDISPATCHER_FCHSMMSXDISPATCHER_FILECODE          (0xB298)
#define UEFI_SMM_FCHSMMDISPATCHER_FCHSMMUSBDISPATCHER_FCHSMMUSBDISPATCHER_FILECODE        (0xB299)

#define LIB_AMDLIB_FILECODE                                              (0xC001)

#define LEGACY_PROC_AGESACALLOUTS_FILECODE                               (0xC010)
#define LEGACY_PROC_HOBTRANSFER_FILECODE                                 (0xC011)
#define LEGACY_PROC_DISPATCHER_FILECODE                                  (0xC012)

#define UEFI_DXE_AMDAGESADXEDRIVER_AMDAGESADXEDRIVER_FILECODE            (0xC120)

#define UEFI_PEI_AMDINITPOSTPEIM_AMDINITPOSTPEIM_FILECODE                (0xC140)
#define UEFI_PEI_AMDPROCESSORINITPEIM_AMDPROCESSORINITPEIM_FILECODE      (0xC141)
#define UEFI_PEI_AMDRESETMANAGER_AMDRESETMANAGER_FILECODE                (0xC142)
#define UEFI_PROC_HOBTRANSFERUEFI_FILECODE                               (0xC162)

#define PROC_COMMON_AMDINITEARLY_FILECODE                                (0xC020)
#define PROC_COMMON_AMDINITENV_FILECODE                                  (0xC021)
#define PROC_COMMON_AMDINITLATE_FILECODE                                 (0xC022)
#define PROC_COMMON_AMDINITMID_FILECODE                                  (0xC023)
#define PROC_COMMON_AMDINITPOST_FILECODE                                 (0xC024)
#define PROC_COMMON_AMDINITRECOVERY_FILECODE                             (0xC025)
#define PROC_COMMON_AMDINITRESET_FILECODE                                (0xC026)
#define PROC_COMMON_AMDINITRESUME_FILECODE                               (0xC027)
#define PROC_COMMON_AMDS3LATERESTORE_FILECODE                            (0xC028)
#define PROC_COMMON_AMDS3SAVE_FILECODE                                   (0xC029)
#define PROC_COMMON_AMDLATERUNAPTASK_FILECODE                            (0xC02A)

#define PROC_COMMON_COMMONRETURNS_FILECODE                               (0xC0C0)
#define PROC_COMMON_CREATESTRUCT_FILECODE                                (0xC0D0)
#define PROC_COMMON_COMMONINITS_FILECODE                                 (0xC0F0)
#define PROC_COMMON_S3RESTORESTATE_FILECODE                              (0xC0F8)
#define PROC_COMMON_S3SAVESTATE_FILECODE                                 (0xC0F9)

#define PROC_CPU_CPUAPICUTILITIES_FILECODE                               (0xC401)
#define PROC_CPU_CPUBRANDID_FILECODE                                     (0xC402)
#define PROC_CPU_TABLE_FILECODE                                          (0xC403)
#define PROC_CPU_CPUEARLYINIT_FILECODE                                   (0xC405)
#define PROC_CPU_CPUEVENTLOG_FILECODE                                    (0xC406)
#define PROC_CPU_CPUFAMILYTRANSLATION_FILECODE                           (0xC407)
#define PROC_CPU_CPUGENERALSERVICES_FILECODE                             (0xC408)
#define PROC_CPU_CPUINITEARLYTABLE_FILECODE                              (0xC409)
#define PROC_CPU_CPULATEINIT_FILECODE                                    (0xC40A)
#define PROC_CPU_CPUMICROCODEPATCH_FILECODE                              (0xC40B)
#define PROC_CPU_CPUWARMRESET_FILECODE                                   (0xC40C)
#define PROC_CPU_HEAPMANAGER_FILECODE                                    (0xC40D)
#define PROC_CPU_CPUBIST_FILECODE                                        (0xC40E)

#define PROC_CPU_CPUPOSTINIT_FILECODE                                    (0xC420)
#define PROC_CPU_CPUPOWERMGMT_FILECODE                                   (0xC430)
#define PROC_CPU_CPUPOWERMGMTMULTISOCKET_FILECODE                        (0xC431)
#define PROC_CPU_CPUPOWERMGMTSINGLESOCKET_FILECODE                       (0xC432)
#define PROC_CPU_S3_FILECODE                                             (0xC460)

// Family 10h
#define PROC_CPU_FAMILY_0X10_CPUCOMMONF10UTILITIES_FILECODE              (0xC801)
#define PROC_CPU_FAMILY_0X10_CPUF10BRANDID_FILECODE                      (0xC802)
#define PROC_CPU_FAMILY_0X10_CPUF10CACHEDEFAULTS_FILECODE                (0xC803)
#define PROC_CPU_FAMILY_0X10_CPUF10CACHEFLUSHONHALT_FILECODE             (0xC804)
#define PROC_CPU_FAMILY_0X10_CPUF10DMI_FILECODE                          (0xC805)
#define PROC_CPU_FAMILY_0X10_CPUF10EARLYINIT_FILECODE                    (0xC806)
#define PROC_CPU_FAMILY_0X10_CPUF10FEATURELEVELING_FILECODE              (0xC807)
#define PROC_CPU_FAMILY_0X10_CPUF10HTPHYTABLES_FILECODE                  (0xC808)
#define PROC_CPU_FAMILY_0X10_CPUF10MSRTABLES_FILECODE                    (0xC809)
#define PROC_CPU_FAMILY_0X10_CPUF10PCITABLES_FILECODE                    (0xC80A)
#define PROC_CPU_FAMILY_0X10_CPUF10POWERCHECK_FILECODE                   (0xC80B)
#define PROC_CPU_FAMILY_0X10_CPUF10POWERMGMTSYSTEMTABLES_FILECODE        (0xC80C)
#define PROC_CPU_FAMILY_0X10_CPUF10POWERPLANE_FILECODE                   (0xC80D)
#define PROC_CPU_FAMILY_0X10_CPUF10SOFTWARETHERMAL_FILECODE              (0xC80E)
#define PROC_CPU_FAMILY_0X10_CPUF10UTILITIES_FILECODE                    (0xC80F)
#define PROC_CPU_FAMILY_0X10_CPUF10WHEAINITDATATABLES_FILECODE           (0xC810)
#define PROC_CPU_FAMILY_0X10_CPUF10PSTATE_FILECODE                       (0xC811)
#define PROC_CPU_FAMILY_0X10_CPUF10CPB_FILECODE                          (0xC812)
#define PROC_CPU_FAMILY_0X10_CPUF10WORKAROUNDSTABLE_FILECODE             (0xC813)
#define PROC_CPU_FAMILY_0X10_F10PMNBCOFVIDINIT_FILECODE                  (0xC820)
#define PROC_CPU_FAMILY_0X10_F10SINGLELINKPCITABLES_FILECODE             (0xC821)
#define PROC_CPU_FAMILY_0X10_F10MULTILINKPCITABLES_FILECODE              (0xC822)
#define PROC_CPU_FAMILY_0X10_F10PMNBPSTATEINIT_FILECODE                  (0xC823)
#define PROC_CPU_FAMILY_0X10_F10PMASYMBOOSTINIT_FILECODE                 (0xC824)
#define PROC_CPU_FAMILY_0X10_F10INITEARLYTABLE_FILECODE                  (0xC825)
#define PROC_CPU_FAMILY_0X10_F10PMDUALPLANEONLYSUPPORT_FILECODE          (0xC826)
#define PROC_CPU_FAMILY_0X10_F10IOCSTATE_FILECODE                        (0xC827)
#define PROC_CPU_FAMILY_0X10_REVC_F10REVCUTILITIES_FILECODE              (0xC830)
#define PROC_CPU_FAMILY_0X10_REVC_F10REVCHWC1E_FILECODE                  (0xC831)
#define PROC_CPU_FAMILY_0X10_REVC_F10REVCSWC1E_FILECODE                  (0xC832)
#define PROC_CPU_FAMILY_0X10_REVC_F10REVCPCITABLES_FILECODE              (0xC833)
#define PROC_CPU_FAMILY_0X10_REVC_F10REVCMSRTABLES_FILECODE              (0xC834)
#define PROC_CPU_FAMILY_0X10_REVC_F10REVCHTPHYTABLES_FILECODE            (0xC835)
#define PROC_CPU_FAMILY_0X10_REVC_BL_F10BLHTPHYTABLES_FILECODE           (0xC836)
#define PROC_CPU_FAMILY_0X10_REVC_BL_F10BLLOGICALIDTABLES_FILECODE       (0xC837)
#define PROC_CPU_FAMILY_0X10_REVC_BL_F10BLMICROCODEPATCHTABLES_FILECODE  (0xC838)
#define PROC_CPU_FAMILY_0X10_REVC_BL_F10BLMSRTABLES_FILECODE             (0xC839)
#define PROC_CPU_FAMILY_0X10_REVC_BL_F10BLEQUIVALENCETABLE_FILECODE      (0xC83A)
#define PROC_CPU_FAMILY_0X10_REVC_BL_F10BLPCITABLES_FILECODE             (0xC83B)
#define PROC_CPU_FAMILY_0X10_REVC_BL_F10BLCACHEFLUSHONHALT_FILECODE      (0xC83C)
#define PROC_CPU_FAMILY_0X10_REVC_DA_F10DAHTPHYTABLES_FILECODE           (0xC83D)
#define PROC_CPU_FAMILY_0X10_REVC_DA_F10DALOGICALIDTABLES_FILECODE       (0xC83E)
#define PROC_CPU_FAMILY_0X10_REVC_DA_F10DAMICROCODEPATCHTABLES_FILECODE  (0xC83F)
#define PROC_CPU_FAMILY_0X10_REVC_DA_F10DAMSRTABLES_FILECODE             (0xC840)
#define PROC_CPU_FAMILY_0X10_REVC_DA_F10DAEQUIVALENCETABLE_FILECODE      (0xC841)
#define PROC_CPU_FAMILY_0X10_REVC_DA_F10DAPCITABLES_FILECODE             (0xC842)
#define PROC_CPU_FAMILY_0X10_REVC_DA_F10DACACHEFLUSHONHALT_FILECODE      (0xC843)
#define PROC_CPU_FAMILY_0X10_REVC_RB_F10RBHTPHYTABLES_FILECODE           (0xC844)
#define PROC_CPU_FAMILY_0X10_REVC_RB_F10RBLOGICALIDTABLES_FILECODE       (0xC845)
#define PROC_CPU_FAMILY_0X10_REVC_RB_F10RBMICROCODEPATCHTABLES_FILECODE  (0xC846)
#define PROC_CPU_FAMILY_0X10_REVC_RB_F10RBMSRTABLES_FILECODE             (0xC847)
#define PROC_CPU_FAMILY_0X10_REVC_RB_F10RBEQUIVALENCETABLE_FILECODE      (0xC848)
#define PROC_CPU_FAMILY_0X10_REVC_RB_F10RBPCITABLES_FILECODE             (0xC849)
#define PROC_CPU_FAMILY_0X10_REVD_F10REVDUTILITIES_FILECODE              (0xC850)
#define PROC_CPU_FAMILY_0X10_REVD_F10REVDMSGBASEDC1E_FILECODE            (0xC851)
#define PROC_CPU_FAMILY_0X10_REVD_F10REVDL3FEATURES_FILECODE             (0xC852)
#define PROC_CPU_FAMILY_0X10_REVD_HY_F10HYHTPHYTABLES_FILECODE           (0xC853)
#define PROC_CPU_FAMILY_0X10_REVD_HY_F10HYINITEARLYTABLE_FILECODE        (0xC854)
#define PROC_CPU_FAMILY_0X10_REVD_HY_F10HYLOGICALIDTABLES_FILECODE       (0xC855)
#define PROC_CPU_FAMILY_0X10_REVD_HY_F10HYMICROCODEPATCHTABLES_FILECODE  (0xC856)
#define PROC_CPU_FAMILY_0X10_REVD_HY_F10HYMSRTABLES_FILECODE             (0xC857)
#define PROC_CPU_FAMILY_0X10_REVD_HY_F10HYEQUIVALENCETABLE_FILECODE      (0xC858)
#define PROC_CPU_FAMILY_0X10_REVD_HY_F10HYPCITABLES_FILECODE             (0xC859)
#define PROC_CPU_FAMILY_0X10_REVE_F10REVEUTILITIES_FILECODE              (0xC860)
#define PROC_CPU_FAMILY_0X10_REVE_F10REVEMSRTABLES_FILECODE              (0xC861)
#define PROC_CPU_FAMILY_0X10_REVE_F10REVEPCITABLES_FILECODE              (0xC862)
#define PROC_CPU_FAMILY_0X10_REVE_F10REVEHTPHYTABLES_FILECODE            (0xC863)
#define PROC_CPU_FAMILY_0X10_REVE_PH_F10PHEQUIVALENCETABLE_FILECODE      (0xC864)
#define PROC_CPU_FAMILY_0X10_REVE_PH_F10PHHTPHYTABLES_FILECODE           (0xC865)
#define PROC_CPU_FAMILY_0X10_REVE_PH_F10PHLOGICALIDTABLES_FILECODE       (0xC866)
#define PROC_CPU_FAMILY_0X10_REVE_PH_F10PHMICROCODEPATCHTABLES_FILECODE  (0xC867)

// Family 12h
#define PROC_CPU_FAMILY_0X12_CPUCOMMONF12UTILITIES_FILECODE              (0xC901)
#define PROC_CPU_FAMILY_0X12_CPUF12BRANDID_FILECODE                      (0xC902)
#define PROC_CPU_FAMILY_0X12_CPUF12CACHEDEFAULTS_FILECODE                (0xC903)
#define PROC_CPU_FAMILY_0X12_CPUF12DMI_FILECODE                          (0xC904)
#define PROC_CPU_FAMILY_0X12_CPUF12MSRTABLES_FILECODE                    (0xC905)
#define PROC_CPU_FAMILY_0X12_CPUF12EARLYNBPSTATEINIT_FILECODE            (0xC906)
#define PROC_CPU_FAMILY_0X12_CPUF12PCITABLES_FILECODE                    (0xC907)
#define PROC_CPU_FAMILY_0X12_CPUF12POWERCHECK_FILECODE                   (0xC908)
#define PROC_CPU_FAMILY_0X12_CPUF12POWERMGMTSYSTEMTABLES_FILECODE        (0xC909)
#define PROC_CPU_FAMILY_0X12_CPUF12POWERPLANE_FILECODE                   (0xC90A)
#define PROC_CPU_FAMILY_0X12_CPUF12SOFTWARETHERMAL_FILECODE              (0xC90B)
#define PROC_CPU_FAMILY_0X12_CPUF12UTILITIES_FILECODE                    (0xC90C)
#define PROC_CPU_FAMILY_0X12_CPUF12WHEAINITDATATABLES_FILECODE           (0xC90D)
#define PROC_CPU_FAMILY_0X12_CPUF12PSTATE_FILECODE                       (0xC90E)
#define PROC_CPU_FAMILY_0X12_F12C6STATE_FILECODE                         (0xC90F)
#define PROC_CPU_FAMILY_0X12_F12CPB_FILECODE                             (0xC910)
#define PROC_CPU_FAMILY_0X12_F12IOCSTATE_FILECODE                        (0xC911)
#define PROC_CPU_FAMILY_0X12_LN_F12LNLOGICALIDTABLES_FILECODE            (0xC921)
#define PROC_CPU_FAMILY_0X12_LN_F12LNMICROCODEPATCHTABLES_FILECODE       (0xC922)
#define PROC_CPU_FAMILY_0X12_LN_F12LNEQUIVALENCETABLE_FILECODE           (0xC923)
#define PROC_CPU_FAMILY_0X12_CPUF12PERCOREPCITABLES_FILECODE             (0xC924)
#define PROC_CPU_FAMILY_0X12_LN_F12LNEARLYSAMPLES_FILECODE               (0xC925)

// Family 14h
#define PROC_CPU_FAMILY_0X14_CPUCOMMONF14UTILITIES_FILECODE              (0xCA01)
#define PROC_CPU_FAMILY_0X14_CPUF14BRANDID_FILECODE                      (0xCA02)
#define PROC_CPU_FAMILY_0X14_CPUF14CACHEDEFAULTS_FILECODE                (0xCA03)
#define PROC_CPU_FAMILY_0X14_CPUF14DMI_FILECODE                          (0xCA04)
#define PROC_CPU_FAMILY_0X14_CPUF14MSRTABLES_FILECODE                    (0xCA05)
#define PROC_CPU_FAMILY_0X14_CPUF14PCITABLES_FILECODE                    (0xCA06)
#define PROC_CPU_FAMILY_0X14_CPUF14UTILITIES_FILECODE                    (0xCA07)
#define PROC_CPU_FAMILY_0X14_CPUF14WHEAINITDATATABLES_FILECODE           (0xCA08)
#define PROC_CPU_FAMILY_0X14_CPUF14PSTATE_FILECODE                       (0xCA09)
#define PROC_CPU_FAMILY_0X14_F14IOCSTATE_FILECODE                        (0xCA0A)
#define PROC_CPU_FAMILY_0X14_CPUF14PERCOREPCITABLES_FILECODE             (0xCA0B)

#define PROC_CPU_FAMILY_0X14_ON_F14ONPOWERPLANE_FILECODE                 (0xCA21)
#define PROC_CPU_FAMILY_0X14_ON_F14ONC6STATE_FILECODE                    (0xCA22)
#define PROC_CPU_FAMILY_0X14_ON_F14ONLOGICALIDTABLES_FILECODE            (0xCA23)
#define PROC_CPU_FAMILY_0X14_ON_F14ONMICROCODEPATCHTABLES_FILECODE       (0xCA24)
#define PROC_CPU_FAMILY_0X14_ON_F14ONEQUIVALENCETABLE_FILECODE           (0xCA25)
#define PROC_CPU_FAMILY_0X14_ON_F14ONINITEARLYTABLE_FILECODE             (0xCA26)
#define PROC_CPU_FAMILY_0X14_ON_F14ONEARLYSAMPLES_FILECODE               (0xCA27)
#define PROC_CPU_FAMILY_0X14_ON_F14ONMSRTABLES_FILECODE                  (0xCA28)
#define PROC_CPU_FAMILY_0X14_ON_F14ONUTILITIES_FILECODE                  (0xCA29)
#define PROC_CPU_FAMILY_0X14_ON_F14ONPOWERMGMTSYSTEMTABLES_FILECODE      (0xCA2A)
#define PROC_CPU_FAMILY_0X14_ON_F14ONLOWPOWERINIT_FILECODE               (0xCA2B)
#define PROC_CPU_FAMILY_0X14_ON_F14ONCPB_FILECODE                        (0xCA2C)
#define PROC_CPU_FAMILY_0X14_ON_F14ONSOFTWARETHERMAL_FILECODE            (0xCA2D)
#define PROC_CPU_FAMILY_0X14_ON_F14ONPOWERCHECK_FILECODE                 (0xCA2E)

#define PROC_CPU_FAMILY_0X14_KR_F14KREQUIVALENCETABLE_FILECODE           (0xCA41)
#define PROC_CPU_FAMILY_0X14_KR_F14KRINITEARLYTABLE_FILECODE             (0xCA42)
#define PROC_CPU_FAMILY_0X14_KR_F14KRLOGICALIDTABLES_FILECODE            (0xCA43)
#define PROC_CPU_FAMILY_0X14_KR_F14KRMICROCODEPATCHTABLES_FILECODE       (0xCA44)
#define PROC_CPU_FAMILY_0X14_KR_F14KRCPB_FILECODE                        (0xCA45)
#define PROC_CPU_FAMILY_0X14_KR_F14KRC6STATE_FILECODE                    (0xCA46)
#define PROC_CPU_FAMILY_0X14_KR_F14KRUTILITIES_FILECODE                  (0xCA47)
#define PROC_CPU_FAMILY_0X14_KR_F14KRPOWERPLANE_FILECODE                 (0xCA48)
#define PROC_CPU_FAMILY_0X14_KR_F14KRPOWERMGMTSYSTEMTABLES_FILECODE      (0xCA49)
#define PROC_CPU_FAMILY_0X14_KR_F14KREARLYNBPSTATEINIT_FILECODE          (0xCA4A)
#define PROC_CPU_FAMILY_0X14_KR_F14KRMSRTABLES_FILECODE                  (0xCA4B)
#define PROC_CPU_FAMILY_0X14_KR_F14KRPCITABLES_FILECODE                  (0xCA4C)
#define PROC_CPU_FAMILY_0X14_KR_F14KRSOFTWARETHERMAL_FILECODE            (0xCA4D)
#define PROC_CPU_FAMILY_0X14_KR_F14KRPOWERCHECK_FILECODE                 (0xCA4E)

// Family 15h
#define PROC_CPU_FAMILY_0X15_CPUCOMMONF15UTILITIES_FILECODE              (0xCB01)
#define PROC_CPU_FAMILY_0X15_CPUF15BRANDID_FILECODE                      (0xCB02)
#define PROC_CPU_FAMILY_0X15_CPUF15CACHEDEFAULTS_FILECODE                (0xCB03)
#define PROC_CPU_FAMILY_0X15_CPUF15DMI_FILECODE                          (0xCB04)
#define PROC_CPU_FAMILY_0X15_CPUF15MSRTABLES_FILECODE                    (0xCB05)
#define PROC_CPU_FAMILY_0X15_CPUF15PCITABLES_FILECODE                    (0xCB06)
#define PROC_CPU_FAMILY_0X15_CPUF15POWERCHECK_FILECODE                   (0xCB07)
#define PROC_CPU_FAMILY_0X15_CPUF15UTILITIES_FILECODE                    (0xCB08)
#define PROC_CPU_FAMILY_0X15_CPUF15WHEAINITDATATABLES_FILECODE           (0xCB09)
#define PROC_CPU_FAMILY_0X15_F15PSTATEHPCMODE_FILECODE                   (0xCB0A)
#define PROC_CPU_FAMILY_0X15_CPUF15APM_FILECODE                          (0xCB0B)

#define PROC_CPU_FAMILY_0X15_OR_CPUF15ORCOREAFTERRESET_FILECODE          (0xCB20)
#define PROC_CPU_FAMILY_0X15_OR_CPUF15ORDMI_FILECODE                     (0xCB21)
#define PROC_CPU_FAMILY_0X15_OR_CPUF15ORNBAFTERRESET_FILECODE            (0xCB22)
#define PROC_CPU_FAMILY_0X15_OR_CPUF15ORPSTATE_FILECODE                  (0xCB23)
#define PROC_CPU_FAMILY_0X15_OR_F15ORL3FEATURES_FILECODE                 (0xCB24)
#define PROC_CPU_FAMILY_0X15_OR_F15ORMSGBASEDC1E_FILECODE                (0xCB25)
#define PROC_CPU_FAMILY_0X15_OR_F15ORLOGICALIDTABLES_FILECODE            (0xCB26)
#define PROC_CPU_FAMILY_0X15_OR_F15ORMICROCODEPATCHTABLES_FILECODE       (0xCB27)
#define PROC_CPU_FAMILY_0X15_OR_F15ORMSRTABLES_FILECODE                  (0xCB28)
#define PROC_CPU_FAMILY_0X15_OR_F15ORSHAREDMSRTABLE_FILECODE             (0xCB29)
#define PROC_CPU_FAMILY_0X15_OR_F15OREQUIVALENCETABLE_FILECODE           (0xCB2A)
#define PROC_CPU_FAMILY_0X15_OR_F15ORPCITABLES_FILECODE                  (0xCB2B)
#define PROC_CPU_FAMILY_0X15_OR_F15ORPOWERMGMTSYSTEMTABLES_FILECODE      (0xCB2C)
#define PROC_CPU_FAMILY_0X15_OR_F15ORPOWERPLANE_FILECODE                 (0xCB2D)
#define PROC_CPU_FAMILY_0X15_OR_F15ORUTILITIES_FILECODE                  (0xCB2E)
#define PROC_CPU_FAMILY_0X15_OR_F15ORWORKAROUNDSTABLE_FILECODE           (0xCB2F)
#define PROC_CPU_FAMILY_0X15_OR_F15ORPMNBCOFVIDINIT_FILECODE             (0xCB30)
#define PROC_CPU_FAMILY_0X15_OR_F15ORLOWPWRPSTATE_FILECODE               (0xCB31)
#define PROC_CPU_FAMILY_0X15_OR_F15ORSINGLELINKPCITABLES_FILECODE        (0xCB32)
#define PROC_CPU_FAMILY_0X15_OR_F15ORMULTILINKPCITABLES_FILECODE         (0xCB33)
#define PROC_CPU_FAMILY_0X15_OR_F15ORC6STATE_FILECODE                    (0xCB34)
#define PROC_CPU_FAMILY_0X15_OR_F15OREARLYSAMPLES_FILECODE               (0xCB35)
#define PROC_CPU_FAMILY_0X15_OR_F15ORCPB_FILECODE                        (0xCB36)
#define PROC_CPU_FAMILY_0X15_OR_F15ORIOCSTATE_FILECODE                   (0xCB37)
#define PROC_CPU_FAMILY_0X15_OR_CPUF15ORCACHEFLUSHONHALT_FILECODE        (0xCB38)
#define PROC_CPU_FAMILY_0X15_OR_CPUF15ORFEATURELEVELING_FILECODE         (0xCB39)
#define PROC_CPU_FAMILY_0X15_OR_CPUF15ORSOFTWARETHERMAL_FILECODE         (0xCB3A)
#define PROC_CPU_FAMILY_0X15_OR_F15ORINITEARLYTABLE_FILECODE             (0xCB3B)

#define PROC_CPU_FAMILY_0X15_TN_CPUF15TNCOREAFTERRESET_FILECODE          (0xCB50)
#define PROC_CPU_FAMILY_0X15_TN_CPUF15TNDMI_FILECODE                     (0xCB51)
#define PROC_CPU_FAMILY_0X15_TN_CPUF15TNNBAFTERRESET_FILECODE            (0xCB52)
#define PROC_CPU_FAMILY_0X15_TN_CPUF15TNPSTATE_FILECODE                  (0xCB53)
#define PROC_CPU_FAMILY_0X15_TN_F15TNLOGICALIDTABLES_FILECODE            (0xCB54)
#define PROC_CPU_FAMILY_0X15_TN_F15TNMICROCODEPATCHTABLES_FILECODE       (0xCB55)
#define PROC_CPU_FAMILY_0X15_TN_F15TNMSRTABLES_FILECODE                  (0xCB56)
#define PROC_CPU_FAMILY_0X15_TN_F15TNSHAREDMSRTABLE_FILECODE             (0xCB57)
#define PROC_CPU_FAMILY_0X15_TN_F15TNEQUIVALENCETABLE_FILECODE           (0xCB58)
#define PROC_CPU_FAMILY_0X15_TN_F15TNPCITABLES_FILECODE                  (0xCB59)
#define PROC_CPU_FAMILY_0X15_TN_F15TNPOWERMGMTSYSTEMTABLES_FILECODE      (0xCB5A)
#define PROC_CPU_FAMILY_0X15_TN_F15TNPOWERPLANE_FILECODE                 (0xCB5B)
#define PROC_CPU_FAMILY_0X15_TN_F15TNUTILITIES_FILECODE                  (0xCB5C)
#define PROC_CPU_FAMILY_0X15_TN_F15TNC6STATE_FILECODE                    (0xCB5D)
#define PROC_CPU_FAMILY_0X15_TN_F15TNCPB_FILECODE                        (0xCB5E)
#define PROC_CPU_FAMILY_0X15_TN_F15TNIOCSTATE_FILECODE                   (0xCB5F)
#define PROC_CPU_FAMILY_0X15_TN_CPUF15TNCACHEFLUSHONHALT_FILECODE        (0xCB60)
#define PROC_CPU_FAMILY_0X15_TN_CPUF15TNSOFTWARETHERMAL_FILECODE         (0xCB61)
#define PROC_CPU_FAMILY_0X15_TN_F15TNINITEARLYTABLE_FILECODE             (0xCB62)
#define PROC_CPU_FAMILY_0X15_TN_F15TNEARLYSAMPLES_FILECODE               (0xCB63)

#define PROC_CPU_FAMILY_0X15_KM_CPUF15KMCOREAFTERRESET_FILECODE          (0xCB80)
#define PROC_CPU_FAMILY_0X15_KM_CPUF15KMDMI_FILECODE                     (0xCB81)
#define PROC_CPU_FAMILY_0X15_KM_CPUF15KMNBAFTERRESET_FILECODE            (0xCB82)
#define PROC_CPU_FAMILY_0X15_KM_CPUF15KMPSTATE_FILECODE                  (0xCB83)
#define PROC_CPU_FAMILY_0X15_KM_F15KML3FEATURES_FILECODE                 (0xCB84)
#define PROC_CPU_FAMILY_0X15_KM_F15KMMSGBASEDC1E_FILECODE                (0xCB85)
#define PROC_CPU_FAMILY_0X15_KM_F15KMLOGICALIDTABLES_FILECODE            (0xCB86)
#define PROC_CPU_FAMILY_0X15_KM_F15KMMICROCODEPATCHTABLES_FILECODE       (0xCB87)
#define PROC_CPU_FAMILY_0X15_KM_F15KMMSRTABLES_FILECODE                  (0xCB88)
#define PROC_CPU_FAMILY_0X15_KM_F15KMSHAREDMSRTABLE_FILECODE             (0xCB89)
#define PROC_CPU_FAMILY_0X15_KM_F15KMEQUIVALENCETABLE_FILECODE           (0xCB8A)
#define PROC_CPU_FAMILY_0X15_KM_F15KMPCITABLES_FILECODE                  (0xCB8B)
#define PROC_CPU_FAMILY_0X15_KM_F15KMPOWERMGMTSYSTEMTABLES_FILECODE      (0xCB8C)
#define PROC_CPU_FAMILY_0X15_KM_F15KMPOWERPLANE_FILECODE                 (0xCB8D)
#define PROC_CPU_FAMILY_0X15_KM_F15KMUTILITIES_FILECODE                  (0xCB8E)
#define PROC_CPU_FAMILY_0X15_KM_F15KMWORKAROUNDSTABLE_FILECODE           (0xCB8F)
#define PROC_CPU_FAMILY_0X15_KM_F15KMPMNBCOFVIDINIT_FILECODE             (0xCB90)
#define PROC_CPU_FAMILY_0X15_KM_F15KMLOWPWRPSTATE_FILECODE               (0xCB91)
#define PROC_CPU_FAMILY_0X15_KM_F15KMSINGLELINKPCITABLES_FILECODE        (0xCB92)
#define PROC_CPU_FAMILY_0X15_KM_F15KMMULTILINKPCITABLES_FILECODE         (0xCB93)
#define PROC_CPU_FAMILY_0X15_KM_F15KMC6STATE_FILECODE                    (0xCB94)
#define PROC_CPU_FAMILY_0X15_KM_F15KMCPB_FILECODE                        (0xCB95)
#define PROC_CPU_FAMILY_0X15_KM_F15KMIOCSTATE_FILECODE                   (0xCB96)
#define PROC_CPU_FAMILY_0X15_KM_CPUF15KMCACHEFLUSHONHALT_FILECODE        (0xCB97)
#define PROC_CPU_FAMILY_0X15_KM_CPUF15KMFEATURELEVELING_FILECODE         (0xCB98)
#define PROC_CPU_FAMILY_0X15_KM_CPUF15KMSOFTWARETHERMAL_FILECODE         (0xCB99)
#define PROC_CPU_FAMILY_0X15_KM_F15KMINITEARLYTABLE_FILECODE             (0xCB9A)

#define PROC_CPU_FEATURE_CPUCACHEFLUSHONHALT_FILECODE                    (0xDC01)
#define PROC_CPU_FEATURE_CPUCACHEINIT_FILECODE                           (0xDC02)
#define PROC_CPU_FEATURE_CPUDMI_FILECODE                                 (0xDC10)
#define PROC_CPU_FEATURE_CPUFEATURELEVELING_FILECODE                     (0xDC20)
#define PROC_CPU_FEATURE_CPUL3FEATURES_FILECODE                          (0xDC30)
#define PROC_CPU_FEATURE_CPUPSTATEGATHER_FILECODE                        (0xDC41)
#define PROC_CPU_FEATURE_CPUPSTATELEVELING_FILECODE                      (0xDC42)
#define PROC_CPU_FEATURE_CPUPSTATETABLES_FILECODE                        (0xDC43)
#define PROC_CPU_FEATURE_CPUSLIT_FILECODE                                (0xDC50)
#define PROC_CPU_FEATURE_CPUSRAT_FILECODE                                (0xDC60)
#define PROC_CPU_FEATURE_CPUWHEA_FILECODE                                (0xDC70)
#define PROC_CPU_FEATURE_CPUHWC1E_FILECODE                               (0xDC80)
#define PROC_CPU_FEATURE_CPUSWC1E_FILECODE                               (0xDC81)
#define PROC_CPU_FEATURE_CPUC6STATE_FILECODE                             (0xDC82)
#define PROC_CPU_FEATURE_CPUCPB_FILECODE                                 (0xDC83)
#define PROC_CPU_FEATURE_CPULOWPWRPSTATE_FILECODE                        (0xDC84)
#define PROC_CPU_FEATURE_CPUIOCSTATE_FILECODE                            (0xDC85)
#define PROC_CPU_FEATURE_CPUPSTATEHPCMODE_FILECODE                       (0xDC86)
#define PROC_CPU_FEATURE_CPUAPM_FILECODE                                 (0xDC87)
#define PROC_CPU_FEATURE_CPUFEATURES_FILECODE                            (0xDC90)
#define PROC_CPU_FEATURE_CPUMSGBASEDC1E_FILECODE                         (0xDCA0)
#define PROC_CPU_FEATURE_CPUCORELEVELING_FILECODE                        (0xDCB0)
#define PROC_CPU_FEATURE_PRESERVEMAILBOX_FILECODE                        (0xDCC0)

#define PROC_RECOVERY_CPU_CPURECOVERY_FILECODE                           (0xDE01)

#define PROC_HT_FEATURES_HTFEATSETS_FILECODE                             (0xE001)
#define PROC_HT_FEATURES_HTFEATDYNAMICDISCOVERY_FILECODE                 (0xE002)
#define PROC_HT_FEATURES_HTFEATGANGING_FILECODE                          (0xE003)
#define PROC_HT_FEATURES_HTFEATNONCOHERENT_FILECODE                      (0xE004)
#define PROC_HT_FEATURES_HTFEATOPTIMIZATION_FILECODE                     (0xE005)
#define PROC_HT_FEATURES_HTFEATROUTING_FILECODE                          (0xE006)
#define PROC_HT_FEATURES_HTFEATSUBLINKS_FILECODE                         (0xE007)
#define PROC_HT_FEATURES_HTFEATTRAFFICDISTRIBUTION_FILECODE              (0xE008)
#define PROC_HT_FEATURES_HTIDS_FILECODE                                  (0xE009)
#define PROC_HT_HTFEAT_FILECODE                                          (0xE021)
#define PROC_HT_HTINTERFACE_FILECODE                                     (0xE022)
#define PROC_HT_HTINTERFACECOHERENT_FILECODE                             (0xE023)
#define PROC_HT_HTINTERFACEGENERAL_FILECODE                              (0xE024)
#define PROC_HT_HTINTERFACENONCOHERENT_FILECODE                          (0xE025)
#define PROC_HT_HTMAIN_FILECODE                                          (0xE026)
#define PROC_HT_HTNOTIFY_FILECODE                                        (0xE027)
#define PROC_HT_HTGRAPH_HTGRAPH_FILECODE                                 (0xE028)
#define PROC_HT_HTNB_FILECODE                                            (0xE081)
#define PROC_HT_NBCOMMON_HTNBCOHERENT_FILECODE                           (0xE082)
#define PROC_HT_NBCOMMON_HTNBNONCOHERENT_FILECODE                        (0xE083)
#define PROC_HT_NBCOMMON_HTNBOPTIMIZATION_FILECODE                       (0xE084)
#define PROC_HT_NBCOMMON_HTNBUTILITIES_FILECODE                          (0xE085)
#define PROC_HT_FAM10_HTNBFAM10_FILECODE                                 (0xE0C1)
#define PROC_HT_FAM10_HTNBCOHERENTFAM10_FILECODE                         (0xE0C2)
#define PROC_HT_FAM10_HTNBNONCOHERENTFAM10_FILECODE                      (0xE0C3)
#define PROC_HT_FAM10_HTNBOPTIMIZATIONFAM10_FILECODE                     (0xE0C4)
#define PROC_HT_FAM10_HTNBSYSTEMFAM10_FILECODE                           (0xE0C5)
#define PROC_HT_FAM10_HTNBUTILITIESFAM10_FILECODE                        (0xE0C6)
#define PROC_HT_FAM12_HTNBFAM12_FILECODE                                 (0xE101)
#define PROC_HT_FAM12_HTNBUTILITIESFAM12_FILECODE                        (0xE102)
#define PROC_HT_FAM14_HTNBFAM14_FILECODE                                 (0xE141)
#define PROC_HT_FAM14_HTNBUTILITIESFAM14_FILECODE                        (0xE142)
#define PROC_HT_FAM15_HTNBFAM15_FILECODE                                 (0xE181)
#define PROC_HT_FAM15_HTNBCOHERENTFAM15_FILECODE                         (0xE182)
#define PROC_HT_FAM15_HTNBNONCOHERENTFAM15_FILECODE                      (0xE183)
#define PROC_HT_FAM15_HTNBOPTIMIZATIONFAM15_FILECODE                     (0xE184)
#define PROC_HT_FAM15_HTNBSYSTEMFAM15_FILECODE                           (0xE185)
#define PROC_HT_FAM15_HTNBUTILITIESFAM15_FILECODE                        (0xE186)
#define PROC_HT_FAM15MOD1X_HTNBFAM15MOD1X_FILECODE                       (0xE187)
#define PROC_HT_FAM15MOD1X_HTNBUTILITIESFAM15MOD1X_FILECODE              (0xE188)
#define PROC_HT_FAM14MOD1X_HTNBFAM14MOD1X_FILECODE                       (0xE189)
#define PROC_HT_FAM14MOD1X_HTNBUTILITIESFAM14MOD1X_FILECODE              (0xE18A)
#define PROC_HT_FAM15MOD2X_HTNBFAM15MOD2X_FILECODE                             (0xE191)
#define PROC_HT_FAM15MOD2X_HTNBCOHERENTFAM15MOD2X_FILECODE                     (0xE192)
#define PROC_HT_FAM15MOD2X_HTNBNONCOHERENTFAM15MOD2X_FILECODE                  (0xE193)
#define PROC_HT_FAM15MOD2X_HTNBOPTIMIZATIONFAM15MOD2X_FILECODE                 (0xE194)
#define PROC_HT_FAM15MOD2X_HTNBSYSTEMFAM15MOD2X_FILECODE                       (0xE195)
#define PROC_HT_FAM15MOD2X_HTNBUTILITIESFAM15MOD2X_FILECODE                    (0xE196)

#define PROC_RECOVERY_HT_HTINITRECOVERY_FILECODE                         (0xE302)
#define PROC_RECOVERY_HT_HTINITRESET_FILECODE                            (0xE301)

#define PROC_IDS_CONTROL_IDSCTRL_FILECODE                                (0xE801)
#define PROC_IDS_LIBRARY_IDSLIB_FILECODE                                 (0xE802)
#define PROC_IDS_DEBUG_IDSDEBUG_FILECODE                                 (0xE803)
#define PROC_IDS_PERF_IDSPERF_FILECODE                                   (0xE804)
#define PROC_IDS_FAMILY_0X10_IDSF10ALLSERVICE_FILECODE                   (0xE805)
#define PROC_IDS_FAMILY_0X10_BL_IDSF10BLSERVICE_FILECODE                 (0xE806)
#define PROC_IDS_FAMILY_0X10_DA_IDSF10DASERVICE_FILECODE                 (0xE807)
#define PROC_IDS_FAMILY_0X10_HY_IDSF10HYSERVICE_FILECODE                 (0xE808)
#define PROC_IDS_FAMILY_0X10_RB_IDSF10RBSERVICE_FILECODE                 (0xE809)
#define PROC_IDS_FAMILY_0X12_IDSF12ALLSERVICE_FILECODE                   (0xE80A)
#define PROC_IDS_FAMILY_0X14_IDSF14ALLSERVICE_FILECODE                   (0xE80B)
#define PROC_IDS_FAMILY_0X15_IDSF15ALLSERVICE_FILECODE                   (0xE80C)
#define PROC_IDS_FAMILY_0X14_KR_IDSF14KRALLSERVICE_FILECODE              (0xE80D)
#define PROC_IDS_FAMILY_0X15_OR_IDSF15ORALLSERVICE_FILECODE              (0xE80E)
#define PROC_IDS_FAMILY_0X15_TN_IDSF15TNALLSERVICE_FILECODE              (0xE80F)
#define PROC_IDS_LIBRARY_IDSREGACC_FILECODE                              (0xE810)

#define PROC_IDS_DEBUG_IDSIDTTABLE_FILECODE                              (0xE81E)
#define PROC_IDS_CONTROL_IDSNVTOCMOS_FILECODE                            (0xE81F)

///0xE820 ~ 0xE840 is reserved for ids extend module

#define PROC_MEM_ARDK_MA_FILECODE                                    (0xF001)
#define PROC_MEM_ARDK_DR_MARDR2_FILECODE                             (0xF002)
#define PROC_MEM_ARDK_DR_MARDR3_FILECODE                             (0xF003)
#define PROC_MEM_ARDK_HY_MARHY3_FILECODE                             (0xF004)
#define PROC_MEM_ARDK_LN_MASLN3_FILECODE                             (0xF005)
#define PROC_MEM_ARDK_DR_MAUDR3_FILECODE                             (0xF006)
#define PROC_MEM_ARDK_HY_MAUHY3_FILECODE                             (0xF007)
#define PROC_MEM_ARDK_LN_MAULN3_FILECODE                             (0xF008)
#define PROC_MEM_ARDK_DA_MAUDA3_FILECODE                             (0xF009)
#define PROC_MEM_ARDK_DA_MASDA2_FILECODE                             (0xF00A)
#define PROC_MEM_ARDK_DA_MASDA3_FILECODE                             (0xF00B)
#define PROC_MEM_ARDK_NI_MASNI3_FILECODE                             (0xF00C)
#define PROC_MEM_ARDK_C32_MARC32_3_FILECODE                          (0xF00D)
#define PROC_MEM_ARDK_C32_MAUC32_3_FILECODE                          (0xF00E)
#define PROC_MEM_ARDK_NI_MAUNI3_FILECODE                             (0xF00F)
#define PROC_MEM_ARDK_ON_MASON3_FILECODE                             (0xF010)
#define PROC_MEM_ARDK_ON_MAUON3_FILECODE                             (0xF011)
#define PROC_MEM_ARDK_PH_MASPH3_FILECODE                             (0xF012)
#define PROC_MEM_ARDK_PH_MAUPH3_FILECODE                             (0xF013)
#define PROC_MEM_ARDK_OR_MAROR3_FILECODE                             (0xF014)
#define PROC_MEM_ARDK_OR_MAUOR3_FILECODE                             (0xF017)
#define PROC_MEM_ARDK_RB_MASRB3_FILECODE                             (0xF018)
#define PROC_MEM_ARDK_RB_MAURB3_FILECODE                             (0xF019)

#define PROC_MEM_FEAT_CHINTLV_MFCHI_FILECODE                         (0xF081)
#define PROC_MEM_FEAT_CSINTLV_MFCSI_FILECODE                         (0xF082)
#define PROC_MEM_FEAT_ECC_MFECC_FILECODE                             (0xF083)
#define PROC_MEM_FEAT_ECC_MFEMP_FILECODE                             (0xF085)
#define PROC_MEM_FEAT_EXCLUDIMM_MFDIMMEXCLUD_FILECODE                (0xF086)
#define PROC_MEM_FEAT_IDENDIMM_MFIDENDIMM_FILECODE                   (0xF088)
#define PROC_MEM_FEAT_INTLVRN_MFINTLVRN_FILECODE                     (0xF089)
#define PROC_MEM_FEAT_LVDDR3_MFLVDDR3_FILECODE                       (0xF08A)
#define PROC_MEM_FEAT_MEMCLR_MFMEMCLR_FILECODE                       (0xF08B)
#define PROC_MEM_FEAT_NDINTLV_MFNDI_FILECODE                         (0xF08C)
#define PROC_MEM_FEAT_ODTHERMAL_MFODTHERMAL_FILECODE                 (0xF08D)
#define PROC_MEM_FEAT_OLSPARE_MFSPR_FILECODE                         (0xF08E)
#define PROC_MEM_FEAT_PARTRN_MFPARALLELTRAINING_FILECODE             (0xF08F)
#define PROC_MEM_FEAT_PARTRN_MFSTANDARDTRAINING_FILECODE             (0xF091)
#define PROC_MEM_FEAT_S3_MFS3_FILECODE                               (0xF092)
#define PROC_MEM_FEAT_TABLE_MFTDS_FILECODE                           (0xF093)

#define PROC_MEM_MAIN_MDEF_FILECODE                                  (0xF101)
#define PROC_MEM_MAIN_MINIT_FILECODE                                 (0xF102)
#define PROC_MEM_MAIN_MM_FILECODE                                    (0xF103)
#define PROC_MEM_FEAT_DMI_MFDMI_FILECODE                             (0xF104)
#define PROC_MEM_MAIN_MMECC_FILECODE                                 (0xF105)
#define PROC_MEM_MAIN_MMEXCLUDEDIMM_FILECODE                         (0xF106)
#define PROC_MEM_MAIN_DR_MMFLOWDR_FILECODE                           (0xF107)
#define PROC_MEM_MAIN_HY_MMFLOWHY_FILECODE                           (0xF108)
#define PROC_MEM_MAIN_LN_MMFLOWLN_FILECODE                           (0xF109)
#define PROC_MEM_MAIN_ON_MMFLOWON_FILECODE                           (0xF10A)
#define PROC_MEM_MAIN_MMNODEINTERLEAVE_FILECODE                      (0xF10B)
#define PROC_MEM_MAIN_MMONLINESPARE_FILECODE                         (0xF10C)
#define PROC_MEM_MAIN_MMPARALLELTRAINING_FILECODE                    (0xF10D)
#define PROC_MEM_MAIN_MMSTANDARDTRAINING_FILECODE                    (0xF10E)
#define PROC_MEM_MAIN_MUC_FILECODE                                   (0xF10F)
#define PROC_MEM_MAIN_MMMEMCLR_FILECODE                              (0xF110)
#define PROC_MEM_MAIN_DA_MMFLOWDA_FILECODE                           (0xF111)
#define PROC_MEM_MAIN_MMFLOW_FILECODE                                (0xF112)
#define PROC_MEM_MAIN_MERRHDL_FILECODE                               (0xF113)
#define PROC_MEM_MAIN_C32_MMFLOWC32_FILECODE                         (0xF114)
#define PROC_MEM_MAIN_MMLVDDR3_FILECODE                              (0xF115)
#define PROC_MEM_MAIN_MMUMAALLOC_FILECODE                            (0xF116)
#define PROC_MEM_MAIN_MMMEMRESTORE_FILECODE                          (0xF117)
#define PROC_MEM_MAIN_MMCONDITIONALPSO_FILECODE                      (0xF118)
#define PROC_MEM_MAIN_OR_MMFLOWOR_FILECODE                           (0xF119)
#define PROC_MEM_MAIN_RB_MMFLOWRB_FILECODE                           (0xF11A)
#define PROC_MEM_MAIN_PH_MMFLOWPH_FILECODE                           (0xF11B)
#define PROC_MEM_MAIN_TN_MMFLOWTN_FILECODE                           (0xF11C)
#define PROC_MEM_MAIN_KR_MMFLOWKR_FILECODE                           (0xF11D)

#define PROC_MEM_NB_DR_MNDR_FILECODE                                 (0XF213)
#define PROC_MEM_NB_DR_MNFLOWDR_FILECODE                             (0XF214)
#define PROC_MEM_NB_DR_MNIDENDIMMDR_FILECODE                         (0XF216)
#define PROC_MEM_NB_DR_MNMCTDR_FILECODE                              (0XF217)
#define PROC_MEM_NB_DR_MNDCTDR_FILECODE                              (0XF218)
#define PROC_MEM_NB_DR_MNOTDR_FILECODE                               (0XF219)
#define PROC_MEM_NB_DR_MNPARTRAINDR_FILECODE                         (0XF21A)
#define PROC_MEM_NB_DR_MNPROTODR_FILECODE                            (0XF21C)
#define PROC_MEM_NB_DR_MNS3DR_FILECODE                               (0XF21D)
#define PROC_MEM_NB_DR_MNREGDR_FILECODE                              (0XF21E)
#define PROC_MEM_NB_RB_MNRB_FILECODE                                 (0XF220)
#define PROC_MEM_NB_RB_MNFLOWRB_FILECODE                             (0XF221)
#define PROC_MEM_NB_RB_MNS3RB_FILECODE                               (0XF222)
#define PROC_MEM_NB_RB_MNIDENDIMMRB_FILECODE                         (0XF223)
#define PROC_MEM_NB_HY_MNFLOWHY_FILECODE                             (0XF233)
#define PROC_MEM_NB_HY_MNHY_FILECODE                                 (0XF235)
#define PROC_MEM_NB_HY_MNIDENDIMMHY_FILECODE                         (0XF236)
#define PROC_MEM_NB_HY_MNMCTHY_FILECODE                              (0XF237)
#define PROC_MEM_NB_HY_MNDCTHY_FILECODE                              (0XF238)
#define PROC_MEM_NB_HY_MNOTHY_FILECODE                               (0XF239)
#define PROC_MEM_NB_HY_MNPARTRAINHY_FILECODE                         (0XF23A)
#define PROC_MEM_NB_HY_MNPHYHY_FILECODE                              (0XF23B)
#define PROC_MEM_NB_HY_MNPROTOHY_FILECODE                            (0XF23C)
#define PROC_MEM_NB_HY_MNS3HY_FILECODE                               (0XF23D)
#define PROC_MEM_NB_HY_MNREGHY_FILECODE                              (0XF23E)
#define PROC_MEM_NB_ON_MNON_FILECODE                                 (0xF240)
#define PROC_MEM_NB_ON_MNREGON_FILECODE                              (0xF241)
#define PROC_MEM_NB_ON_MNDCTON_FILECODE                              (0xF242)
#define PROC_MEM_NB_ON_MNIDENDIMMON_FILECODE                         (0xF244)
#define PROC_MEM_NB_ON_MNMCTON_FILECODE                              (0xF245)
#define PROC_MEM_NB_ON_MNOTON_FILECODE                               (0xF246)
#define PROC_MEM_NB_ON_MNPHYON_FILECODE                              (0xF247)
#define PROC_MEM_NB_ON_MNS3ON_FILECODE                               (0xF248)
#define PROC_MEM_NB_ON_MNFLOWON_FILECODE                             (0xF249)
#define PROC_MEM_NB_ON_MNPROTOON_FILECODE                            (0xF24A)
#define PROC_MEM_NB_LN_MNDCTLN_FILECODE                              (0XF252)
#define PROC_MEM_NB_LN_MNFLOWLN_FILECODE                             (0XF253)
#define PROC_MEM_NB_LN_MNIDENDIMMLN_FILECODE                         (0XF254)
#define PROC_MEM_NB_LN_MNMCTLN_FILECODE                              (0XF255)
#define PROC_MEM_NB_LN_MNOTLN_FILECODE                               (0XF256)
#define PROC_MEM_NB_LN_MNPHYLN_FILECODE                              (0XF257)
#define PROC_MEM_NB_LN_MNPROTOLN_FILECODE                            (0XF258)
#define PROC_MEM_NB_LN_MNLN_FILECODE                                 (0XF259)
#define PROC_MEM_NB_LN_MNS3LN_FILECODE                               (0XF25A)
#define PROC_MEM_NB_LN_MNREGLN_FILECODE                              (0XF25B)
#define PROC_MEM_NB_DA_MNDA_FILECODE                                 (0XF260)
#define PROC_MEM_NB_DA_MNFLOWDA_FILECODE                             (0XF261)
#define PROC_MEM_NB_DA_MNIDENDIMMDA_FILECODE                         (0XF263)
#define PROC_MEM_NB_DA_MNMCTDA_FILECODE                              (0XF264)
#define PROC_MEM_NB_DA_MNDCTDA_FILECODE                              (0XF265)
#define PROC_MEM_NB_DA_MNOTDA_FILECODE                               (0XF266)
#define PROC_MEM_NB_DA_MNPARTRAINDA_FILECODE                         (0XF267)
#define PROC_MEM_NB_DA_MNPROTODA_FILECODE                            (0XF269)
#define PROC_MEM_NB_DA_MNS3DA_FILECODE                               (0XF26A)
#define PROC_MEM_NB_DA_MNREGDA_FILECODE                              (0XF26B)
#define PROC_MEM_NB_C32_MNC32_FILECODE                               (0XF26C)
#define PROC_MEM_NB_C32_MNDCTC32_FILECODE                            (0XF26D)
#define PROC_MEM_NB_C32_MNFLOWC32_FILECODE                           (0XF26E)
#define PROC_MEM_NB_C32_MNIDENDIMMC32_FILECODE                       (0XF26F)
#define PROC_MEM_NB_C32_MNMCTC32_FILECODE                            (0XF270)
#define PROC_MEM_NB_C32_MNOTC32_FILECODE                             (0XF271)
#define PROC_MEM_NB_C32_MNPARTRAINC32_FILECODE                       (0XF272)
#define PROC_MEM_NB_C32_MNPHYC32_FILECODE                            (0XF273)
#define PROC_MEM_NB_C32_MNPROTOC32_FILECODE                          (0XF274)
#define PROC_MEM_NB_C32_MNS3C32_FILECODE                             (0XF275)
#define PROC_MEM_NB_C32_MNREGC32_FILECODE                            (0XF277)
#define PROC_MEM_NB_MN_FILECODE                                      (0XF27C)
#define PROC_MEM_NB_MNDCT_FILECODE                                   (0XF27D)
#define PROC_MEM_NB_MNPHY_FILECODE                                   (0XF27E)
#define PROC_MEM_NB_MNMCT_FILECODE                                   (0XF27F)
#define PROC_MEM_NB_MNS3_FILECODE                                    (0XF280)
#define PROC_MEM_NB_MNFLOW_FILECODE                                  (0XF281)
#define PROC_MEM_NB_MNFEAT_FILECODE                                  (0XF282)
#define PROC_MEM_NB_MNTRAIN2_FILECODE                                (0XF283)
#define PROC_MEM_NB_MNTRAIN3_FILECODE                                (0XF284)
#define PROC_MEM_NB_MNREG_FILECODE                                   (0XF285)
#define PROC_MEM_NB_NI_MNNI_FILECODE                                 (0XF286)
#define PROC_MEM_NB_NI_MNS3NI_FILECODE                               (0XF287)
#define PROC_MEM_NB_NI_MNFLOWNI_FILECODE                             (0XF288)
#define PROC_MEM_NB_PH_MNFLOWPH_FILECODE                             (0XF289)
#define PROC_MEM_NB_PH_MNPH_FILECODE                                 (0XF28A)
#define PROC_MEM_NB_PH_MNS3PH_FILECODE                               (0XF28B)
#define PROC_MEM_NB_PH_MNIDENDIMMPH_FILECODE                         (0XF28C)
#define PROC_MEM_NB_PH_MNMCTPH_FILECODE                              (0XF28D)
#define PROC_MEM_NB_OR_MNFLOWOR_FILECODE                             (0XF290)
#define PROC_MEM_NB_OR_MNOR_FILECODE                                 (0XF291)
#define PROC_MEM_NB_OR_MNIDENDIMMOR_FILECODE                         (0XF292)
#define PROC_MEM_NB_OR_MNMCTOR_FILECODE                              (0XF293)
#define PROC_MEM_NB_OR_MNDCTOR_FILECODE                              (0XF294)
#define PROC_MEM_NB_OR_MNOTOR_FILECODE                               (0XF295)
#define PROC_MEM_NB_OR_MNPARTRAINOR_FILECODE                         (0XF296)
#define PROC_MEM_NB_OR_MNPHYOR_FILECODE                              (0XF297)
#define PROC_MEM_NB_OR_MNPROTOOR_FILECODE                            (0XF298)
#define PROC_MEM_NB_OR_MNS3OR_FILECODE                               (0XF299)
#define PROC_MEM_NB_OR_MNREGOR_FILECODE                              (0XF29A)
#define PROC_MEM_NB_TN_MNREGTN_FILECODE                              (0XF29B)
#define PROC_MEM_NB_TN_MNTN_FILECODE                                 (0XF29C)
#define PROC_MEM_NB_TN_MNMCTTN_FILECODE                              (0XF29D)
#define PROC_MEM_NB_TN_MNOTTN_FILECODE                               (0XF29E)
#define PROC_MEM_NB_TN_MNDCTTN_FILECODE                              (0XF29F)
#define PROC_MEM_NB_TN_MNPHYTN_FILECODE                              (0XF2A0)
#define PROC_MEM_NB_TN_MNS3TN_FILECODE                               (0XF2A1)
#define PROC_MEM_NB_TN_MNIDENDIMMTN_FILECODE                         (0XF2A2)
#define PROC_MEM_NB_TN_MNFLOWTN_FILECODE                             (0XF2A3)
#define PROC_MEM_NB_TN_MNPROTOTN_FILECODE                            (0XF2A4)
#define PROC_MEM_NB_KR_MNREGKR_FILECODE                              (0xF2A5)
#define PROC_MEM_NB_KR_MNDCTKR_FILECODE                              (0xF2A6)
#define PROC_MEM_NB_KR_MNIDENDIMMKR_FILECODE                         (0xF2A7)
#define PROC_MEM_NB_KR_MNMCTKR_FILECODE                              (0xF2A8)
#define PROC_MEM_NB_KR_MNOTKR_FILECODE                               (0xF2A9)
#define PROC_MEM_NB_KR_MNPHYKR_FILECODE                              (0xF2AA)
#define PROC_MEM_NB_KR_MNS3KR_FILECODE                               (0xF2AB)
#define PROC_MEM_NB_KR_MNFLOWKR_FILECODE                             (0xF2AC)
#define PROC_MEM_NB_KR_MNPROTOKR_FILECODE                            (0xF2AD)
#define PROC_MEM_NB_KR_MNKR_FILECODE                                 (0xF2AE)
#define PROC_MEM_NB_KM_MNREGKM_FILECODE                              (0XF2AF)
#define PROC_MEM_NB_KM_MNKM_FILECODE                                 (0XF2B0)
#define PROC_MEM_NB_KM_MNMCTKM_FILECODE                              (0XF2B1)
#define PROC_MEM_NB_KM_MNOTKM_FILECODE                               (0XF2B2)
#define PROC_MEM_NB_KM_MNDCTKM_FILECODE                              (0XF2B3)
#define PROC_MEM_NB_KM_MNPHYKM_FILECODE                              (0XF2B4)
#define PROC_MEM_NB_KM_MNS3KM_FILECODE                               (0XF2B5)
#define PROC_MEM_NB_KM_MNIDENDIMMKM_FILECODE                         (0XF2B6)
#define PROC_MEM_NB_KM_MNFLOWKM_FILECODE                             (0XF2B7)
#define PROC_MEM_NB_KM_MNPROTOKM_FILECODE                            (0XF2B8)


#define PROC_MEM_PS_MP_FILECODE                                      (0XF401)
#define PROC_MEM_PS_DR_MPRDR3_FILECODE                               (0XF402)
#define PROC_MEM_PS_HY_MPRHY3_FILECODE                               (0XF403)
#define PROC_MEM_PS_LN_MPRLN3_FILECODE                               (0XF404)
#define PROC_MEM_PS_DR_MPSDR3_FILECODE                               (0XF405)
#define PROC_MEM_PS_HY_MPSHY3_FILECODE                               (0XF406)
#define PROC_MEM_PS_LN_MPSLN3_FILECODE                               (0XF407)
#define PROC_MEM_PS_DR_MPUDR3_FILECODE                               (0XF408)
#define PROC_MEM_PS_HY_MPUHY3_FILECODE                               (0XF409)
#define PROC_MEM_PS_LN_MPULN3_FILECODE                               (0XF40A)
#define PROC_MEM_PS_DA_MPUDA3_FILECODE                               (0XF40B)
#define PROC_MEM_PS_DA_MPSDA2_FILECODE                               (0XF40C)
#define PROC_MEM_PS_DA_MPSDA3_FILECODE                               (0XF40D)
#define PROC_MEM_PS_DR_MPRDR2_FILECODE                               (0XF40E)
#define PROC_MEM_PS_DR_MPUDR2_FILECODE                               (0XF40F)
#define PROC_MEM_PS_C32_MPRC32_3_FILECODE                            (0XF410)
#define PROC_MEM_PS_C32_MPUC32_3_FILECODE                            (0XF411)
#define PROC_MEM_PS_NI_MPSNI3_FILECODE                               (0XF412)
#define PROC_MEM_PS_NI_MPUNI3_FILECODE                               (0XF413)
#define PROC_MEM_PS_ON_MPSON3_FILECODE                               (0XF414)
#define PROC_MEM_PS_ON_MPUON3_FILECODE                               (0XF415)
#define PROC_MEM_PS_PH_MPSPH3_FILECODE                               (0XF416)
#define PROC_MEM_PS_PH_MPUPH3_FILECODE                               (0XF417)
#define PROC_MEM_PS_RB_MPSRB3_FILECODE                               (0XF418)
#define PROC_MEM_PS_RB_MPURB3_FILECODE                               (0XF419)
#define PROC_MEM_PS_OR_AM3_MPUORA3_FILECODE                          (0XF41A)
#define PROC_MEM_PS_OR_AM3_MPSORA3_FILECODE                          (0XF41B)
#define PROC_MEM_PS_OR_C32_MPRORC3_FILECODE                          (0XF41C)
#define PROC_MEM_PS_OR_C32_MPUORC3_FILECODE                          (0XF41D)
#define PROC_MEM_PS_OR_C32_MPLORC3_FILECODE                          (0XF41E)
#define PROC_MEM_PS_OR_G34_MPRORG3_FILECODE                          (0XF41F)
#define PROC_MEM_PS_OR_G34_MPUORG3_FILECODE                          (0XF420)
#define PROC_MEM_PS_OR_G34_MPLORG3_FILECODE                          (0XF421)
#define PROC_MEM_PS_MPRTT_FILECODE                                   (0XF422)
#define PROC_MEM_PS_MPMAXFREQ_FILECODE                               (0XF423)
#define PROC_MEM_PS_MPODTPAT_FILECODE                                (0XF424)
#define PROC_MEM_PS_MPSAO_FILECODE                                   (0XF425)
#define PROC_MEM_PS_MPMR0_FILECODE                                   (0XF426)
#define PROC_MEM_PS_MPRC2IBT_FILECODE                                (0XF427)
#define PROC_MEM_PS_MPRC10OPSPD_FILECODE                             (0XF428)
#define PROC_MEM_PS_MPLRIBT_FILECODE                                 (0XF429)
#define PROC_MEM_PS_MPLRNPR_FILECODE                                 (0XF42A)
#define PROC_MEM_PS_MPLRNLR_FILECODE                                 (0XF42B)
#define PROC_MEM_PS_OR_MPOR3_FILECODE                                (0XF42C)
#define PROC_MEM_PS_TN_MPSTN3_FILECODE                               (0XF42D)
#define PROC_MEM_PS_TN_MPTN3_FILECODE                                (0XF42E)
#define PROC_MEM_PS_TN_MPUTN3_FILECODE                               (0XF42F)
#define PROC_MEM_PS_TN_FM2_MPUTNFM2_FILECODE                         (0XF430)
#define PROC_MEM_PS_TN_FP2_MPSTNFP2_FILECODE                         (0XF431)
#define PROC_MEM_PS_TN_FS1_MPSTNFS1_FILECODE                         (0XF432)
#define PROC_MEM_PS_KR_MPKR3_FILECODE                                (0XF433)
#define PROC_MEM_PS_KR_MPUKR3_FILECODE                               (0XF434)
#define PROC_MEM_PS_KR_MPSKR3_FILECODE                               (0XF435)
#define PROC_MEM_PS_MPS___FILECODE                                   (0XF436)
#define PROC_MEM_PS_KM_FM2_MPUKMFM2_FILECODE                         (0XF437)
#define PROC_MEM_PS_KM_FM2_MPSKMFM2_FILECODE                         (0XF438)
#define PROC_MEM_PS_KM_C2012_MPRKMC3_FILECODE                        (0XF439)
#define PROC_MEM_PS_KM_C2012_MPUKMC3_FILECODE                        (0XF43A)
#define PROC_MEM_PS_KM_C2012_MPLKMC3_FILECODE                        (0XF43B)
#define PROC_MEM_PS_KM_G2012_MPRKMG3_FILECODE                        (0XF43C)
#define PROC_MEM_PS_KM_G2012_MPUKMG3_FILECODE                        (0XF43D)
#define PROC_MEM_PS_KM_G2012_MPLKMG3_FILECODE                        (0XF43E)
#define PROC_MEM_PS_KM_MPKM3_FILECODE                                (0XF43F)
#define PROC_MEM_PS_MPSEEDS_FILECODE                                 (0XF440)

#define PROC_MEM_TECH_MT_FILECODE                                    (0XF501)
#define PROC_MEM_TECH_MTHDI_FILECODE                                 (0XF502)
#define PROC_MEM_TECH_MTTDIMBT_FILECODE                              (0XF504)
#define PROC_MEM_TECH_MTTECC_FILECODE                                (0XF505)
#define PROC_MEM_TECH_MTTHRC_FILECODE                                (0XF506)
#define PROC_MEM_TECH_MTTML_FILECODE                                 (0XF507)
#define PROC_MEM_TECH_MTTOPTSRC_FILECODE                             (0XF509)
#define PROC_MEM_TECH_MTTSRC_FILECODE                                (0XF50B)
#define PROC_MEM_TECH_MTTEDGEDETECT_FILECODE                         (0XF50C)
#define PROC_MEM_TECH_DDR2_MT2_FILECODE                              (0XF541)
#define PROC_MEM_TECH_DDR2_MTOT2_FILECODE                            (0XF543)
#define PROC_MEM_TECH_DDR2_MTSPD2_FILECODE                           (0XF544)
#define PROC_MEM_TECH_DDR3_MT3_FILECODE                              (0XF581)
#define PROC_MEM_TECH_DDR3_MTOT3_FILECODE                            (0XF583)
#define PROC_MEM_TECH_DDR3_MTRCI3_FILECODE                           (0XF584)
#define PROC_MEM_TECH_DDR3_MTSDI3_FILECODE                           (0XF585)
#define PROC_MEM_TECH_DDR3_MTSPD3_FILECODE                           (0XF586)
#define PROC_MEM_TECH_DDR3_MTTWL3_FILECODE                           (0XF587)
#define PROC_MEM_TECH_DDR3_MTTECC3_FILECODE                          (0XF588)
#define PROC_MEM_TECH_DDR3_MTLRDIMM3_FILECODE                        (0XF589)
#define PROC_MEM_TECH_MTTHRCSEEDTRAIN_FILECODE                       (0XF58A)

#define PROC_RECOVERY_MEM_MRDEF_FILECODE                             (0XF801)
#define PROC_RECOVERY_MEM_MRINIT_FILECODE                            (0XF802)
#define PROC_RECOVERY_MEM_MRM_FILECODE                               (0XF803)
#define PROC_RECOVERY_MEM_MRUC_FILECODE                              (0XF804)
#define PROC_RECOVERY_MEM_NB_DR_MRNDR_FILECODE                       (0XF812)
#define PROC_RECOVERY_MEM_NB_DR_MRNMCTDR_FILECODE                    (0XF813)
#define PROC_RECOVERY_MEM_NB_HY_MRNDCTHY_FILECODE                    (0XF821)
#define PROC_RECOVERY_MEM_NB_HY_MRNHY_FILECODE                       (0XF822)
#define PROC_RECOVERY_MEM_NB_HY_MRNMCTHY_FILECODE                    (0XF823)
#define PROC_RECOVERY_MEM_NB_HY_MRNPROTOHY_FILECODE                  (0XF825)
#define PROC_RECOVERY_MEM_NB_LN_MRNDCTLN_FILECODE                    (0XF831)
#define PROC_RECOVERY_MEM_NB_LN_MRNMCTLN_FILECODE                    (0XF832)
#define PROC_RECOVERY_MEM_NB_LN_MRNLN_FILECODE                       (0XF833)
#define PROC_RECOVERY_MEM_NB_DA_MRNDA_FILECODE                       (0XF842)
#define PROC_RECOVERY_MEM_NB_DA_MRNMCTDA_FILECODE                    (0XF843)
#define PROC_RECOVERY_MEM_NB_NI_MRNNI_FILECODE                       (0XF845)
#define PROC_RECOVERY_MEM_NB_C32_MRNC32_FILECODE                     (0XF851)
#define PROC_RECOVERY_MEM_NB_C32_MRNMCTC32_FILECODE                  (0XF852)
#define PROC_RECOVERY_MEM_NB_C32_MRNPROTOC32_FILECODE                (0XF853)
#define PROC_RECOVERY_MEM_NB_ON_MRNDCTON_FILECODE                    (0xF861)
#define PROC_RECOVERY_MEM_NB_ON_MRNMCTON_FILECODE                    (0xF862)
#define PROC_RECOVERY_MEM_NB_ON_MRNON_FILECODE                       (0xF863)
#define PROC_RECOVERY_MEM_NB_PH_MRNPH_FILECODE                       (0xF871)
#define PROC_RECOVERY_MEM_NB_RB_MRNRB_FILECODE                       (0xF881)
#define PROC_RECOVERY_MEM_NB_KR_MRNDCTKR_FILECODE                    (0xF891)
#define PROC_RECOVERY_MEM_NB_KR_MRNMCTKR_FILECODE                    (0xF892)
#define PROC_RECOVERY_MEM_NB_KR_MRNKR_FILECODE                       (0xF893)
#define PROC_RECOVERY_MEM_TECH_MRTTPOS_FILECODE                      (0XF8C1)
#define PROC_RECOVERY_MEM_TECH_MRTTSRC_FILECODE                      (0XF8C2)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRT3_FILECODE                    (0XF8C3)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRTRCI3_FILECODE                 (0XF8C4)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRTSDI3_FILECODE                 (0XF8C5)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRTSPD3_FILECODE                 (0XF8C6)
#define PROC_RECOVERY_MEM_TECH_DDR3_MRTTWL3_FILECODE                 (0XF8C7)
#define PROC_RECOVERY_MEM_NB_MRN_FILECODE                            (0XF8C8)
#define PROC_RECOVERY_MEM_NB_MRNDCT_FILECODE                         (0XF8C9)
#define PROC_RECOVERY_MEM_NB_MRNMCT_FILECODE                         (0XF8CA)
#define PROC_RECOVERY_MEM_NB_MRNTRAIN3_FILECODE                      (0XF8CB)
#define PROC_RECOVERY_MEM_TECH_MRTTHRC_FILECODE                      (0XF8CC)
#define PROC_RECOVERY_MEM_NB_OR_MRNDCTOR_FILECODE                    (0XF8CD)
#define PROC_RECOVERY_MEM_NB_OR_MRNOR_FILECODE                       (0XF8CE)
#define PROC_RECOVERY_MEM_NB_OR_MRNMCTOR_FILECODE                    (0XF8CF)
#define PROC_RECOVERY_MEM_NB_OR_MRNPROTOOR_FILECODE                  (0XF8D0)
#define PROC_RECOVERY_MEM_PS_MRP_FILECODE                            (0XF8E0)
#define PROC_RECOVERY_MEM_PS_MRPRTT_FILECODE                         (0XF8E1)
#define PROC_RECOVERY_MEM_PS_MRPODTPAT_FILECODE                      (0XF8E2)
#define PROC_RECOVERY_MEM_PS_MRPSAO_FILECODE                         (0XF8E3)
#define PROC_RECOVERY_MEM_PS_MRPMR0_FILECODE                         (0XF8E4)
#define PROC_RECOVERY_MEM_PS_MRPRC2IBT_FILECODE                      (0XF8E5)
#define PROC_RECOVERY_MEM_PS_MRPRC10OPSPD_FILECODE                   (0XF8E6)
#define PROC_RECOVERY_MEM_PS_MRPLRIBT_FILECODE                       (0XF8E7)
#define PROC_RECOVERY_MEM_PS_MRPLRNPR_FILECODE                       (0XF8E8)
#define PROC_RECOVERY_MEM_PS_MRPLRNLR_FILECODE                       (0XF8E9)
#define PROC_RECOVERY_MEM_NB_TN_MRNDCTTN_FILECODE                    (0XF8F3)
#define PROC_RECOVERY_MEM_NB_TN_MRNTN_FILECODE                       (0XF8F4)
#define PROC_RECOVERY_MEM_NB_TN_MRNMCTTN_FILECODE                    (0XF8F5)
#define PROC_RECOVERY_MEM_NB_TN_MRNPROTOTN_FILECODE                  (0XF8F6)
#define PROC_RECOVERY_MEM_PS_TN_MRPSTN3_FILECODE                     (0XF8F7)
#define PROC_RECOVERY_MEM_PS_TN_MRPTN3_FILECODE                      (0XF8F8)
#define PROC_RECOVERY_MEM_PS_TN_MRPUTN3_FILECODE                     (0XF8F9)
#define PROC_RECOVERY_MEM_NB_KM_MRNDCTKM_FILECODE                    (0XF8FA)
#define PROC_RECOVERY_MEM_NB_KM_MRNKM_FILECODE                       (0XF8FB)
#define PROC_RECOVERY_MEM_NB_KM_MRNMCTKM_FILECODE                    (0XF8FC)
#define PROC_RECOVERY_MEM_NB_KM_MRNPROTOKM_FILECODE                  (0XF8FD)
#define PROC_RECOVERY_MEM_TECH_MRTTHRCSEEDTRAIN_FILECODE             (0XF8FE)

#endif // _FILECODE_H_
