/*
 * firmware initialization code for Trident Blade3d graphics adapter
 *   written by Fuger Shen 2003-10-10
 *   (C) 2003 XGI Technology Inc.
 *   This code is released under GPL with permission from XGI
 */
#include <delay.h>
#include <stdlib.h>
#include <string.h>
#include <arch/io.h>

#include <console/console.h>
#include <device/device.h>
#include <device/pci.h>
#include <device/pci_ids.h>
#include <device/pci_ops.h>


//----------------------------------------------------------------------------//
// init chip 9880
// Fuger Shen 2003-10-10
//----------------------------------------------------------------------------//

#define inp inb
#define outp(port,val) outb(val, port)

#define WORD    unsigned int
#define BYTE    unsigned char
#define DWORD   unsigned long

#define SGRAMTimg   0x27
#define CHIPREV     0x3		//1,RA 2,RB,3,RC

#define Port_SRX    0x3c4
#define Port_CRX    0x3d4
#define Port_GRX    0x3ce
#define Port_BRX    0x3c0

static BYTE Mem_Clk_Table[][2] = {
	//For EDO, 3x5.2a.3:2=01            3x4.28.2:0
	{ 0x50, 0x46 },		//000, F_78
	{ 0xCF, 0x51 },		//001, F_81 = 81.011Mhz
	{ 0x30, 0x83 },		//010, F_40 = 40.006Mhz
	{ 0x1B, 0x43 },		//011, F_50 = 49.999MHz
	{ 0x22, 0x43 },		//100, F_60 = 59.999MHz
	{ 0x42, 0x46 },		//101, F_66 = 65.988MHz
	{ 0x33, 0x44 },		//110, F_70 = 69.999Mhz
	{ 0x22, 0x42 },		//111, F_75 = 74,999Mhz
	//for SGRAM, 3x5.2a.3:2=1x
	{ 0x3A, 0x05 },		//000, F_135
	{ 0x38, 0x05 },		//001, F_130
	{ 0x44, 0x44 },		//010, F_90 = 89.999MHz
	{ 0x22, 0x04 },		//011, F_100=100.227MHz
	{ 0x0E, 0x01 },		//100, F_105
	{ 0x3D, 0x07 },		//101, F_110=109.989Mhz
	{ 0x22, 0x03 },		//110, F_120=119.999MHz
	{ 0x36, 0x05 },		//111, F_125
};


typedef struct Reg_struct {
	WORD rPort;
	BYTE rIndex;
	BYTE rValue;
	BYTE rMask;
} Def_Reg_struct;

typedef Def_Reg_struct* lpDef_Reg_struct;
// , *pDef_Reg_struct, far * lpDef_Reg_struct;

static Def_Reg_struct Mode3_temp[] = {	//mode3 temp
	//port    index value  mask
	{Port_CRX, 0x00, 0x5F, 0x00},
	{Port_CRX, 0x01, 0x4F, 0x00},
	{Port_CRX, 0x02, 0x50, 0x00},
	{Port_CRX, 0x03, 0x82, 0x00},
	{Port_CRX, 0x04, 0x55, 0x00},
	{Port_CRX, 0x05, 0x81, 0x00},
	{Port_CRX, 0x06, 0xBF, 0x00},
	{Port_CRX, 0x07, 0x1F, 0x00},
	{Port_CRX, 0x08, 0x00, 0x00},
	{Port_CRX, 0x09, 0xC7, 0x00},
	{Port_CRX, 0x0a, 0x06, 0x00},
	{Port_CRX, 0x0b, 0x07, 0x00},
	{Port_CRX, 0x0c, 0x00, 0x00},
	{Port_CRX, 0x0d, 0x00, 0x00},
	{Port_CRX, 0x0e, 0x00, 0x00},
	{Port_CRX, 0x0f, 0x00, 0x00},
	{Port_CRX, 0x10, 0x9C, 0x00},
	{Port_CRX, 0x11, 0x8E, 0x00},
	{Port_CRX, 0x12, 0x8F, 0x00},
	{Port_CRX, 0x13, 0x28, 0x00},
	{Port_CRX, 0x14, 0x1F, 0x00},
	{Port_CRX, 0x15, 0x96, 0x00},
	{Port_CRX, 0x16, 0xB9, 0x00},
	{Port_CRX, 0x17, 0xA3, 0x00},
	{Port_CRX, 0x18, 0xFF, 0x00},
};

WORD Length_Mode3_temp = sizeof(Mode3_temp) / sizeof(Def_Reg_struct);

Def_Reg_struct Mode3_reg[] = {	//mode3
	//port   index   value   mask
	{Port_CRX, 0x00, 0x5F, 0x00},			//3d5
	{Port_CRX, 0x01, 0x4F, 0x00},
	{Port_CRX, 0x02, 0x50, 0x00},
	{Port_CRX, 0x03, 0x82, 0x00},
	{Port_CRX, 0x04, 0x55, 0x00},
	{Port_CRX, 0x05, 0x81, 0x00},
	{Port_CRX, 0x06, 0xBF, 0x00},
	{Port_CRX, 0x07, 0x1F, 0x00},
	{Port_CRX, 0x08, 0x00, 0x00},
	{Port_CRX, 0x09, 0x4F, 0x00},
	{Port_CRX, 0x0a, 0x0D, 0x00},
	{Port_CRX, 0x0b, 0x0E, 0x00},
	{Port_CRX, 0x0c, 0x00, 0x00},
	{Port_CRX, 0x0d, 0x00, 0x00},
	{Port_CRX, 0x0e, 0x00, 0x00},
	{Port_CRX, 0x0f, 0x00, 0x00},
	{Port_CRX, 0x10, 0x9C, 0x00},
	{Port_CRX, 0x11, 0x8E, 0x00},
	{Port_CRX, 0x12, 0x8F, 0x00},
	{Port_CRX, 0x13, 0x28, 0x00},
	{Port_CRX, 0x14, 0x1F, 0x00},
	{Port_CRX, 0x15, 0x96, 0x00},
	{Port_CRX, 0x16, 0xB9, 0x00},
	{Port_CRX, 0x17, 0xA3, 0x00},
	{Port_CRX, 0x18, 0xFF, 0x00},

	//brx
	{Port_BRX, 0x00, 0x00, 0x00},
	{Port_BRX, 0x01, 0x01, 0x00},
	{Port_BRX, 0x02, 0x02, 0x00},
	{Port_BRX, 0x03, 0x03, 0x00},
	{Port_BRX, 0x04, 0x04, 0x00},
	{Port_BRX, 0x05, 0x05, 0x00},
	{Port_BRX, 0x06, 0x14, 0x00},
	{Port_BRX, 0x07, 0x07, 0x00},
	{Port_BRX, 0x08, 0x38, 0x00},
	{Port_BRX, 0x09, 0x39, 0x00},
	{Port_BRX, 0x0a, 0x3A, 0x00},
	{Port_BRX, 0x0b, 0x3B, 0x00},
	{Port_BRX, 0x0c, 0x3C, 0x00},
	{Port_BRX, 0x0d, 0x3D, 0x00},
	{Port_BRX, 0x0e, 0x3E, 0x00},
	{Port_BRX, 0x0f, 0x3F, 0x00},
	{Port_BRX, 0x10, 0x0C, 0x00},
	{Port_BRX, 0x11, 0x00, 0x00},
	{Port_BRX, 0x12, 0x0F, 0x00},
	{Port_BRX, 0x13, 0x08, 0x00},
	{Port_BRX, 0x14, 0x00, 0x00},

	{Port_SRX, 0x00, 0x03, 0x00},
	{Port_SRX, 0x01, 0x00, 0x00},
	{Port_SRX, 0x02, 0x03, 0x00},
	{Port_SRX, 0x03, 0x00, 0x00},
	{Port_SRX, 0x04, 0x02, 0x00},
	{Port_SRX, 0x18, 0xa6, 0x00},			//VCLK
	{Port_SRX, 0x19, 0xc9, 0x00},
	{Port_SRX, 0x0D, 0x20, 0x00},
	{Port_SRX, 0x12, 0x11, 0x00},

	{Port_CRX, 0x19, 0x4a, 0x00},
	//{Port_CRX, 0x20, 0x20, 0x00},
	//{Port_CRX, 0x23, 0x00, 0x00},
	//{Port_CRX, 0x1E, 0x89, 0x00},
	{Port_CRX, 0x21, 0xce, 0x00},
	//{Port_CRX, 0x25, 0x07, 0x00},
	//{Port_CRX, 0x27, 0x08, 0x00},
	//{Port_CRX, 0x2B, 0x00, 0x00},
	//{Port_CRX, 0x29, 0x04, 0x00},
	//{Port_CRX, 0x2F, 0x22, 0x00},
	{Port_CRX, 0x37, 0x81, 0x00},
	//{Port_CRX, 0x38, 0x00, 0x00},
	//{Port_CRX, 0x3b, 0x01, 0x00},
	{Port_CRX, 0x56, 0x00, 0x00},
	{Port_CRX, 0x57, 0x54, 0x00},

	{Port_GRX, 0x05, 0x10, 0x00},
	{Port_GRX, 0x06, 0x0e, 0x00},			//
	{Port_GRX, 0x0F, 0x20, 0x00},
	//{Port_GRX, 0x31, 0x06, 0x00},
	//{Port_GRX, 0x33, 0x30, 0x00},
	//{Port_GRX, 0x52, 0x10, 0x00},
};

static WORD Length_Mode3_reg = sizeof(Mode3_reg) / sizeof(Def_Reg_struct);

static Def_Reg_struct Init_reg[] = {
	//port   index   value   mask
	{Port_GRX, 0x25, 0x00, 0x00},
	{Port_GRX, 0x21, 0x00, 0x00},
	{Port_GRX, 0x22, 0x00, 0x00},
	{Port_GRX, 0x26, 0x08, 0x00},
	{Port_GRX, 0x27, 0x00, 0x00},
	{Port_GRX, 0x28, 0xFF, 0x00},
	{Port_GRX, 0x29, 0x00, 0x00},
	{Port_GRX, 0x2A, 0x00, 0x00},
	{Port_GRX, 0x2C, 0x06, 0x00},
	{Port_GRX, 0x2E, 0x00, 0x00},
	{Port_GRX, 0x2F, 0x00, 0x00},
	{Port_GRX, 0x20, 0x80, 0x00},

	{Port_SRX, 0x24, 0x0F, 0x00},
	{Port_SRX, 0x37, 0x30, 0x00},
	{Port_SRX, 0x38, 0x04, 0x00},

	{Port_GRX, 0x23, 0x00, 0x00},
	{Port_GRX, 0x33, 0x20, 0x00},
	{Port_GRX, 0x30, 0x00, 0x00},
	//
	{Port_GRX, 0x28, 0x18, 0x00},

	{Port_CRX, 0x0F, 0x20, 0x40},
	{Port_CRX, 0x1F, 0x00, 0x00},
	{Port_CRX, 0x20, 0x30, 0x00},
	{Port_CRX, 0x23, 0x10, 0x00},
	{Port_CRX, 0x25, 0x86, 0x00},
	{Port_CRX, 0x2F, 0x1F, 0x00},
	{Port_CRX, 0x30, 0x0F, 0x00},
	{Port_CRX, 0x33, 0x00, 0x00},
	{Port_CRX, 0x38, 0x10, 0x00},
	{Port_CRX, 0x39, 0x00, 0x00},
	{Port_CRX, 0x5E, 0x00, 0x00},
	{Port_CRX, 0x29, 0x04, 0x00},

	{Port_GRX, 0x5C, 0x00, 0x80},
	{Port_GRX, 0x62, 0x00, 0x08},

	{Port_SRX, 0x20, 0x04, 0x00},
	{Port_GRX, 0x2F, 0x23, 0x00},
	{Port_SRX, 0x0B, 0x00, 0x00},
	{Port_SRX, 0x0D, 0x28, 0x00},
};

static WORD Length_Init_reg = sizeof(Init_reg) / sizeof(Def_Reg_struct);

static BYTE C8x16_Char[][8] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//;0
	{ 0x00, 0x00, 0x7E, 0x81, 0xA5, 0x81, 0x81, 0xBD },
	{ 0x99, 0x81, 0x81, 0x7E, 0x00, 0x00, 0x00, 0x00 },	//;1
	{ 0x00, 0x00, 0x7E, 0xFF, 0xDB, 0xFF, 0xFF, 0xC3 },
	{ 0xE7, 0xFF, 0xFF, 0x7E, 0x00, 0x00, 0x00, 0x00 },	//;2
	{ 0x00, 0x00, 0x00, 0x00, 0x6C, 0xFE, 0xFE, 0xFE },
	{ 0xFE, 0x7C, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00 },	//;3
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7C, 0xFE },
	{ 0x7C, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	//;4
	{ 0x00, 0x00, 0x00, 0x18, 0x3C, 0x3C, 0xE7, 0xE7 },
	{ 0xE7, 0x99, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00 },	//;5
	{ 0x00, 0x00, 0x00, 0x18, 0x3C, 0x7E, 0xFF, 0xFF },
	{ 0x7E, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00 },	//;6
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3C },
	{ 0x3C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//;7
	{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xC3 },
	{ 0xC3, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },	//;8
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x66, 0x42 },
	{ 0x42, 0x66, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00 },	//;9
	{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0x99, 0xBD },
	{ 0xBD, 0x99, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },	////10
	{ 0x00, 0x00, 0x1E, 0x0E, 0x1A, 0x32, 0x78, 0xCC },
	{ 0xCC, 0xCC, 0xCC, 0x78, 0x00, 0x00, 0x00, 0x00 },	//11
	{ 0x00, 0x00, 0x3C, 0x66, 0x66, 0x66, 0x66, 0x3C },
	{ 0x18, 0x7E, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	//12
	{ 0x00, 0x00, 0x3F, 0x33, 0x3F, 0x30, 0x30, 0x30 },
	{ 0x30, 0x70, 0xF0, 0xE0, 0x00, 0x00, 0x00, 0x00 },	//13
	{ 0x00, 0x00, 0x7F, 0x63, 0x7F, 0x63, 0x63, 0x63 },
	{ 0x63, 0x67, 0xE7, 0xE6, 0xC0, 0x00, 0x00, 0x00 },	//14
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0xDB, 0x3C, 0xE7 },
	{ 0x3C, 0xDB, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	//15
	{ 0x00, 0x80, 0xC0, 0xE0, 0xF0, 0xF8, 0xFE, 0xF8 },
	{ 0xF0, 0xE0, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00 },	//16
	{ 0x00, 0x02, 0x06, 0x0E, 0x1E, 0x3E, 0xFE, 0x3E },
	{ 0x1E, 0x0E, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00 },	//17
	{ 0x00, 0x00, 0x18, 0x3C, 0x7E, 0x18, 0x18, 0x18 },
	{ 0x18, 0x7E, 0x3C, 0x18, 0x00, 0x00, 0x00, 0x00 },	//18
	{ 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66 },
	{ 0x66, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	//19
	{ 0x00, 0x00, 0x7F, 0xDB, 0xDB, 0xDB, 0x7B, 0x1B },
	{ 0x1B, 0x1B, 0x1B, 0x1B, 0x00, 0x00, 0x00, 0x00 },	//20
	{ 0x00, 0x7C, 0xC6, 0x60, 0x38, 0x6C, 0xC6, 0xC6 },
	{ 0x6C, 0x38, 0x0C, 0xC6, 0x7C, 0x00, 0x00, 0x00 },	//21
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xFE, 0xFE, 0xFE, 0xFE, 0x00, 0x00, 0x00, 0x00 },	//22
	{ 0x00, 0x00, 0x18, 0x3C, 0x7E, 0x18, 0x18, 0x18 },
	{ 0x18, 0x7E, 0x3C, 0x18, 0x7E, 0x00, 0x00, 0x00 },	//23
	{ 0x00, 0x00, 0x18, 0x3C, 0x7E, 0x18, 0x18, 0x18 },
	{ 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	//24
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },
	{ 0x18, 0x7E, 0x3C, 0x18, 0x00, 0x00, 0x00, 0x00 },	//25
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x0C, 0xFE },
	{ 0x0C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//26
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x60, 0xFE },
	{ 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//27
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0xC0 },
	{ 0xC0, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//28
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x6C, 0xFE },
	{ 0x6C, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//29
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x38, 0x7C },
	{ 0x7C, 0xFE, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00 },	//30
	{ 0x00, 0x00, 0x00, 0x00, 0xFE, 0xFE, 0x7C, 0x7C },
	{ 0x38, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	//31
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//32
	{ 0x00, 0x00, 0x18, 0x3C, 0x3C, 0x3C, 0x18, 0x18 },
	{ 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	//33
	{ 0x00, 0x66, 0x66, 0x66, 0x24, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//34
	{ 0x00, 0x00, 0x00, 0x6C, 0x6C, 0xFE, 0x6C, 0x6C },
	{ 0x6C, 0xFE, 0x6C, 0x6C, 0x00, 0x00, 0x00, 0x00 },	//35
	{ 0x18, 0x18, 0x7C, 0xC6, 0xC2, 0xC0, 0x7C, 0x06 },
	{ 0x86, 0xC6, 0x7C, 0x18, 0x18, 0x00, 0x00, 0x00 },	//36
	{ 0x00, 0x00, 0x00, 0x00, 0xC2, 0xC6, 0x0C, 0x18 },
	{ 0x30, 0x60, 0xC6, 0x86, 0x00, 0x00, 0x00, 0x00 },	//37
	{ 0x00, 0x00, 0x38, 0x6C, 0x6C, 0x38, 0x76, 0xDC },
	{ 0xCC, 0xCC, 0xCC, 0x76, 0x00, 0x00, 0x00, 0x00 },	//38
	{ 0x00, 0x30, 0x30, 0x30, 0x60, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//39
	{ 0x00, 0x00, 0x0C, 0x18, 0x30, 0x30, 0x30, 0x30 },
	{ 0x30, 0x30, 0x18, 0x0C, 0x00, 0x00, 0x00, 0x00 },	//40
	{ 0x00, 0x00, 0x30, 0x18, 0x0C, 0x0C, 0x0C, 0x0C },
	{ 0x0C, 0x0C, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00 },	//41
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x3C, 0xFF },
	{ 0x3C, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//42
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7E },
	{ 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//43
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00 },	//44
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//45
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	//46
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0C, 0x18 },
	{ 0x30, 0x60, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00 },	//47
	{ 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xD6, 0xD6 },
	{ 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//48
	{ 0x00, 0x00, 0x18, 0x38, 0x78, 0x18, 0x18, 0x18 },
	{ 0x18, 0x18, 0x18, 0x7E, 0x00, 0x00, 0x00, 0x00 },	//49
	{ 0x00, 0x00, 0x7C, 0xC6, 0x06, 0x0C, 0x18, 0x30 },
	{ 0x60, 0xC0, 0xC6, 0xFE, 0x00, 0x00, 0x00, 0x00 },	//50
	{ 0x00, 0x00, 0x7C, 0xC6, 0x06, 0x06, 0x3C, 0x06 },
	{ 0x06, 0x06, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//51
	{ 0x00, 0x00, 0x0C, 0x1C, 0x3C, 0x6C, 0xCC, 0xFE },
	{ 0x0C, 0x0C, 0x0C, 0x1E, 0x00, 0x00, 0x00, 0x00 },	//52
	{ 0x00, 0x00, 0xFE, 0xC0, 0xC0, 0xC0, 0xFC, 0x0E },
	{ 0x06, 0x06, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//53
	{ 0x00, 0x00, 0x38, 0x60, 0xC0, 0xC0, 0xFC, 0xC6 },
	{ 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//54
	{ 0x00, 0x00, 0xFE, 0xC6, 0x06, 0x06, 0x0C, 0x18 },
	{ 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	//55
	{ 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0x7C, 0xC6 },
	{ 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//56
	{ 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0x7E, 0x06 },
	{ 0x06, 0x06, 0x0C, 0x78, 0x00, 0x00, 0x00, 0x00 },	//57
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00 },
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	//58
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00 },
	{ 0x00, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00 },	//59
	{ 0x00, 0x00, 0x00, 0x06, 0x0C, 0x18, 0x30, 0x60 },
	{ 0x30, 0x18, 0x0C, 0x06, 0x00, 0x00, 0x00, 0x00 },	//60
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00 },
	{ 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//61
	{ 0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 0x0C, 0x06 },
	{ 0x0C, 0x18, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00 },	//62
	{ 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0x0C, 0x18, 0x18 },
	{ 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	//63
	{ 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xDE, 0xDE },
	{ 0xDE, 0xDC, 0xC0, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//64
	{ 0x00, 0x00, 0x10, 0x38, 0x6C, 0xC6, 0xC6, 0xFE },
	{ 0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00 },	//65
	{ 0x00, 0x00, 0xFC, 0x66, 0x66, 0x66, 0x7C, 0x66 },
	{ 0x66, 0x66, 0x66, 0xFC, 0x00, 0x00, 0x00, 0x00 },	//66
	{ 0x00, 0x00, 0x3C, 0x66, 0xC2, 0xC0, 0xC0, 0xC0 },
	{ 0xC0, 0xC2, 0x66, 0x3C, 0x00, 0x00, 0x00, 0x00 },	//67
	{ 0x00, 0x00, 0xF8, 0x6C, 0x66, 0x66, 0x66, 0x66 },
	{ 0x66, 0x66, 0x6C, 0xF8, 0x00, 0x00, 0x00, 0x00 },	//68
	{ 0x00, 0x00, 0xFE, 0x66, 0x62, 0x68, 0x78, 0x68 },
	{ 0x60, 0x62, 0x66, 0xFE, 0x00, 0x00, 0x00, 0x00 },	//69
	{ 0x00, 0x00, 0xFE, 0x66, 0x62, 0x68, 0x78, 0x68 },
	{ 0x60, 0x60, 0x60, 0xF0, 0x00, 0x00, 0x00, 0x00 },	//70
	{ 0x00, 0x00, 0x3C, 0x66, 0xC2, 0xC0, 0xC0, 0xDE },
	{ 0xC6, 0xC6, 0x66, 0x3A, 0x00, 0x00, 0x00, 0x00 },	//71
	{ 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xFE, 0xC6 },
	{ 0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00 },	//72
	{ 0x00, 0x00, 0x3C, 0x18, 0x18, 0x18, 0x18, 0x18 },
	{ 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00 },	//73
	{ 0x00, 0x00, 0x1E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C },
	{ 0xCC, 0xCC, 0xCC, 0x78, 0x00, 0x00, 0x00, 0x00 },	//74
	{ 0x00, 0x00, 0xE6, 0x66, 0x6C, 0x6C, 0x78, 0x78 },
	{ 0x6C, 0x66, 0x66, 0xE6, 0x00, 0x00, 0x00, 0x00 },	//75
	{ 0x00, 0x00, 0xF0, 0x60, 0x60, 0x60, 0x60, 0x60 },
	{ 0x60, 0x62, 0x66, 0xFE, 0x00, 0x00, 0x00, 0x00 },	//76
	{ 0x00, 0x00, 0xC6, 0xEE, 0xFE, 0xFE, 0xD6, 0xC6 },
	{ 0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00 },	//77
	{ 0x00, 0x00, 0xC6, 0xE6, 0xF6, 0xFE, 0xDE, 0xCE },
	{ 0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00 },	//78
	{ 0x00, 0x00, 0x38, 0x6C, 0xC6, 0xC6, 0xC6, 0xC6 },
	{ 0xC6, 0xC6, 0x6C, 0x38, 0x00, 0x00, 0x00, 0x00 },	//79
	{ 0x00, 0x00, 0xFC, 0x66, 0x66, 0x66, 0x7C, 0x60 },
	{ 0x60, 0x60, 0x60, 0xF0, 0x00, 0x00, 0x00, 0x00 },	//80
	{ 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6 },
	{ 0xC6, 0xD6, 0xDE, 0x7C, 0x0C, 0x0E, 0x00, 0x00 },	//81
	{ 0x00, 0x00, 0xFC, 0x66, 0x66, 0x66, 0x7C, 0x6C },
	{ 0x66, 0x66, 0x66, 0xE6, 0x00, 0x00, 0x00, 0x00 },	//82
	{ 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0x60, 0x38, 0x0C },
	{ 0x06, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//83
	{ 0x00, 0x00, 0x7E, 0x7E, 0x5A, 0x18, 0x18, 0x18 },
	{ 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00 },	//84
	{ 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6 },
	{ 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//85
	{ 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6 },
	{ 0xC6, 0x6C, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00 },	//86
	{ 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xD6 },
	{ 0xD6, 0xFE, 0x6C, 0x6C, 0x00, 0x00, 0x00, 0x00 },	//87
	{ 0x00, 0x00, 0xC6, 0xC6, 0x6C, 0x6C, 0x38, 0x38 },
	{ 0x6C, 0x6C, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00 },	//88
	{ 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x18 },
	{ 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00 },	//89
	{ 0x00, 0x00, 0xFE, 0xC6, 0x86, 0x0C, 0x18, 0x30 },
	{ 0x60, 0xC2, 0xC6, 0xFE, 0x00, 0x00, 0x00, 0x00 },	//90
	{ 0x00, 0x00, 0x3C, 0x30, 0x30, 0x30, 0x30, 0x30 },
	{ 0x30, 0x30, 0x30, 0x3C, 0x00, 0x00, 0x00, 0x00 },	//91
	{ 0x00, 0x00, 0x00, 0x80, 0xC0, 0xE0, 0x70, 0x38 },
	{ 0x1C, 0x0E, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00 },	//92
	{ 0x00, 0x00, 0x3C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C },
	{ 0x0C, 0x0C, 0x0C, 0x3C, 0x00, 0x00, 0x00, 0x00 },	//93
	{ 0x10, 0x38, 0x6C, 0xC6, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//94
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00 },	//95
	{ 0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//96
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0C, 0x7C },
	{ 0xCC, 0xCC, 0xCC, 0x76, 0x00, 0x00, 0x00, 0x00 },	//97
	{ 0x00, 0x00, 0xE0, 0x60, 0x60, 0x78, 0x6C, 0x66 },
	{ 0x66, 0x66, 0x66, 0xDC, 0x00, 0x00, 0x00, 0x00 },	//98
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC0 },
	{ 0xC0, 0xC0, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//99
	{ 0x00, 0x00, 0x1C, 0x0C, 0x0C, 0x3C, 0x6C, 0xCC },
	{ 0xCC, 0xCC, 0xCC, 0x76, 0x00, 0x00, 0x00, 0x00 },	//100
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xFE },
	{ 0xC0, 0xC0, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//101
	{ 0x00, 0x00, 0x38, 0x6C, 0x64, 0x60, 0xF0, 0x60 },
	{ 0x60, 0x60, 0x60, 0xF0, 0x00, 0x00, 0x00, 0x00 },	//102
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xCC, 0xCC },
	{ 0xCC, 0xCC, 0xCC, 0x7C, 0x0C, 0xCC, 0x78, 0x00 },	//103
	{ 0x00, 0x00, 0xE0, 0x60, 0x60, 0x6C, 0x76, 0x66 },
	{ 0x66, 0x66, 0x66, 0xE6, 0x00, 0x00, 0x00, 0x00 },	//104
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18 },
	{ 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00 },	//105
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x0E, 0x06, 0x06 },
	{ 0x06, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3C, 0x00 },	//106
	{ 0x00, 0x00, 0xE0, 0x60, 0x60, 0x66, 0x6C, 0x78 },
	{ 0x78, 0x6C, 0x66, 0xE6, 0x00, 0x00, 0x00, 0x00 },	//107
	{ 0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18 },
	{ 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00 },	//108
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xEC, 0xFE, 0xD6 },
	{ 0xD6, 0xD6, 0xD6, 0xD6, 0x00, 0x00, 0x00, 0x00 },	//109
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xDC, 0x66, 0x66 },
	{ 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	//110
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC6 },
	{ 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//111
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xDC, 0x66, 0x66 },
	{ 0x66, 0x66, 0x66, 0x7C, 0x60, 0x60, 0xF0, 0x00 },	//112
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xCC, 0xCC },
	{ 0xCC, 0xCC, 0xCC, 0x7C, 0x0C, 0x0C, 0x1E, 0x00 },	//113
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xDC, 0x76, 0x62 },
	{ 0x60, 0x60, 0x60, 0xF0, 0x00, 0x00, 0x00, 0x00 },	//114
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0x60 },
	{ 0x38, 0x0C, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//115
	{ 0x00, 0x00, 0x10, 0x30, 0x30, 0xFC, 0x30, 0x30 },
	{ 0x30, 0x30, 0x36, 0x1C, 0x00, 0x00, 0x00, 0x00 },	//116
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xCC, 0xCC, 0xCC },
	{ 0xCC, 0xCC, 0xCC, 0x76, 0x00, 0x00, 0x00, 0x00 },	//117
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66 },
	{ 0x66, 0x66, 0x3C, 0x18, 0x00, 0x00, 0x00, 0x00 },	//118
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0xC6 },
	{ 0xD6, 0xD6, 0xFE, 0x6C, 0x00, 0x00, 0x00, 0x00 },	//119
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0x6C, 0x38 },
	{ 0x38, 0x38, 0x6C, 0xC6, 0x00, 0x00, 0x00, 0x00 },	//120
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0xC6 },
	{ 0xC6, 0xC6, 0xC6, 0x7E, 0x06, 0x0C, 0xF8, 0x00 },	//121
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0xCC, 0x18 },
	{ 0x30, 0x60, 0xC6, 0xFE, 0x00, 0x00, 0x00, 0x00 },	//122
	{ 0x00, 0x00, 0x0E, 0x18, 0x18, 0x18, 0x70, 0x18 },
	{ 0x18, 0x18, 0x18, 0x0E, 0x00, 0x00, 0x00, 0x00 },	//123
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18 },
	{ 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	//124
	{ 0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x0E, 0x18 },
	{ 0x18, 0x18, 0x18, 0x70, 0x00, 0x00, 0x00, 0x00 },	//125
	{ 0x00, 0x00, 0x76, 0xDC, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//126
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x6C, 0xC6 },
	{ 0xC6, 0xC6, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00 },	//127
	{ 0x00, 0x00, 0x3C, 0x66, 0xC2, 0xC0, 0xC0, 0xC0 },
	{ 0xC2, 0x66, 0x3C, 0x0C, 0x06, 0x7C, 0x00, 0x00 },	//128
	{ 0x00, 0x00, 0xCC, 0xCC, 0x00, 0xCC, 0xCC, 0xCC },
	{ 0xCC, 0xCC, 0xCC, 0x76, 0x00, 0x00, 0x00, 0x00 },	//129
	{ 0x00, 0x0C, 0x18, 0x30, 0x00, 0x7C, 0xC6, 0xFE },
	{ 0xC0, 0xC0, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//130
	{ 0x00, 0x10, 0x38, 0x6C, 0x00, 0x78, 0x0C, 0x7C },
	{ 0xCC, 0xCC, 0xCC, 0x76, 0x00, 0x00, 0x00, 0x00 },	//131
	{ 0x00, 0x00, 0xCC, 0xCC, 0x00, 0x78, 0x0C, 0x7C },
	{ 0xCC, 0xCC, 0xCC, 0x76, 0x00, 0x00, 0x00, 0x00 },	//132
	{ 0x00, 0x60, 0x30, 0x18, 0x00, 0x78, 0x0C, 0x7C },
	{ 0xCC, 0xCC, 0xCC, 0x76, 0x00, 0x00, 0x00, 0x00 },	//133
	{ 0x00, 0x38, 0x6C, 0x38, 0x00, 0x78, 0x0C, 0x7C },
	{ 0xCC, 0xCC, 0xCC, 0x76, 0x00, 0x00, 0x00, 0x00 },	//134
	{ 0x00, 0x00, 0x00, 0x00, 0x3C, 0x66, 0x60, 0x60 },
	{ 0x66, 0x3C, 0x0C, 0x06, 0x3C, 0x00, 0x00, 0x00 },	//135
	{ 0x00, 0x10, 0x38, 0x6C, 0x00, 0x7C, 0xC6, 0xFE },
	{ 0xC0, 0xC0, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//136
	{ 0x00, 0x00, 0xC6, 0xC6, 0x00, 0x7C, 0xC6, 0xFE },
	{ 0xC0, 0xC0, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//137
	{ 0x00, 0x60, 0x30, 0x18, 0x00, 0x7C, 0xC6, 0xFE },
	{ 0xC0, 0xC0, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//138
	{ 0x00, 0x00, 0x66, 0x66, 0x00, 0x38, 0x18, 0x18 },
	{ 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00 },	//139
	{ 0x00, 0x18, 0x3C, 0x66, 0x00, 0x38, 0x18, 0x18 },
	{ 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00 },	//140
	{ 0x00, 0x60, 0x30, 0x18, 0x00, 0x38, 0x18, 0x18 },
	{ 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00 },	//141
	{ 0x00, 0xC6, 0xC6, 0x10, 0x38, 0x6C, 0xC6, 0xC6 },
	{ 0xFE, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00 },	//142
	{ 0x38, 0x6C, 0x38, 0x00, 0x38, 0x6C, 0xC6, 0xC6 },
	{ 0xFE, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00 },	//143
	{ 0x18, 0x30, 0x60, 0x00, 0xFE, 0x66, 0x60, 0x7C },
	{ 0x60, 0x60, 0x66, 0xFE, 0x00, 0x00, 0x00, 0x00 },	//144
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xCC, 0x76, 0x36 },
	{ 0x7E, 0xD8, 0xD8, 0x6E, 0x00, 0x00, 0x00, 0x00 },	//145
	{ 0x00, 0x00, 0x3E, 0x6C, 0xCC, 0xCC, 0xFE, 0xCC },
	{ 0xCC, 0xCC, 0xCC, 0xCE, 0x00, 0x00, 0x00, 0x00 },	//146
	{ 0x00, 0x10, 0x38, 0x6C, 0x00, 0x7C, 0xC6, 0xC6 },
	{ 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//147
	{ 0x00, 0x00, 0xC6, 0xC6, 0x00, 0x7C, 0xC6, 0xC6 },
	{ 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//148
	{ 0x00, 0x60, 0x30, 0x18, 0x00, 0x7C, 0xC6, 0xC6 },
	{ 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//149
	{ 0x00, 0x30, 0x78, 0xCC, 0x00, 0xCC, 0xCC, 0xCC },
	{ 0xCC, 0xCC, 0xCC, 0x76, 0x00, 0x00, 0x00, 0x00 },	//150
	{ 0x00, 0x60, 0x30, 0x18, 0x00, 0xCC, 0xCC, 0xCC },
	{ 0xCC, 0xCC, 0xCC, 0x76, 0x00, 0x00, 0x00, 0x00 },	//151
	{ 0x00, 0x00, 0xC6, 0xC6, 0x00, 0xC6, 0xC6, 0xC6 },
	{ 0xC6, 0xC6, 0xC6, 0x7E, 0x06, 0x0C, 0x78, 0x00 },	//152
	{ 0x00, 0xC6, 0xC6, 0x00, 0x38, 0x6C, 0xC6, 0xC6 },
	{ 0xC6, 0xC6, 0x6C, 0x38, 0x00, 0x00, 0x00, 0x00 },	//153
	{ 0x00, 0xC6, 0xC6, 0x00, 0xC6, 0xC6, 0xC6, 0xC6 },
	{ 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//154
	{ 0x00, 0x18, 0x18, 0x3C, 0x66, 0x60, 0x60, 0x60 },
	{ 0x66, 0x3C, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	//155
	{ 0x00, 0x38, 0x6C, 0x64, 0x60, 0xF0, 0x60, 0x60 },
	{ 0x60, 0x60, 0xE6, 0xFC, 0x00, 0x00, 0x00, 0x00 },	//156
	{ 0x00, 0x00, 0x66, 0x66, 0x3C, 0x18, 0x7E, 0x18 },
	{ 0x7E, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	//157
	{ 0x00, 0xF8, 0xCC, 0xCC, 0xF8, 0xC4, 0xCC, 0xDE },
	{ 0xCC, 0xCC, 0xCC, 0xC6, 0x00, 0x00, 0x00, 0x00 },	//158
	{ 0x00, 0x0E, 0x1B, 0x18, 0x18, 0x18, 0x7E, 0x18 },
	{ 0x18, 0x18, 0x18, 0x18, 0xD8, 0x70, 0x00, 0x00 },	//159
	{ 0x00, 0x18, 0x30, 0x60, 0x00, 0x78, 0x0C, 0x7C },
	{ 0xCC, 0xCC, 0xCC, 0x76, 0x00, 0x00, 0x00, 0x00 },	//160
	{ 0x00, 0x0C, 0x18, 0x30, 0x00, 0x38, 0x18, 0x18 },
	{ 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00 },	//161
	{ 0x00, 0x18, 0x30, 0x60, 0x00, 0x7C, 0xC6, 0xC6 },
	{ 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//162
	{ 0x00, 0x18, 0x30, 0x60, 0x00, 0xCC, 0xCC, 0xCC },
	{ 0xCC, 0xCC, 0xCC, 0x76, 0x00, 0x00, 0x00, 0x00 },	//163
	{ 0x00, 0x00, 0x76, 0xDC, 0x00, 0xDC, 0x66, 0x66 },
	{ 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	//164
	{ 0x76, 0xDC, 0x00, 0xC6, 0xE6, 0xF6, 0xFE, 0xDE },
	{ 0xCE, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00 },	//165
	{ 0x00, 0x3C, 0x6C, 0x6C, 0x3E, 0x00, 0x7E, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//166
	{ 0x00, 0x38, 0x6C, 0x6C, 0x38, 0x00, 0x7C, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//167
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x60 },
	{ 0xC0, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 },	//168
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0xC0 },
	{ 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00 },	//169
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x06 },
	{ 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	//170
	{ 0x00, 0xC0, 0xC0, 0xC2, 0xC6, 0xCC, 0x18, 0x30 },
	{ 0x60, 0xCE, 0x93, 0x06, 0x0C, 0x1F, 0x00, 0x00 },	//171
	{ 0x00, 0xC0, 0xC0, 0xC2, 0xC6, 0xCC, 0x18, 0x30 },
	{ 0x66, 0xCE, 0x9A, 0x3F, 0x06, 0x0F, 0x00, 0x00 },	//172
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18 },
	{ 0x3C, 0x3C, 0x3C, 0x18, 0x00, 0x00, 0x00, 0x00 },	//173
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x66, 0xCC },
	{ 0x66, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//174
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xCC, 0x66, 0x33 },
	{ 0x66, 0xCC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//175
	{ 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44 },
	{ 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44 },	//176
	{ 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA },
	{ 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA },	//177
	{ 0xDD, 0x77, 0xDD, 0x77, 0xDD, 0x77, 0xDD, 0x77 },
	{ 0xDD, 0x77, 0xDD, 0x77, 0xDD, 0x77, 0xDD, 0x77 },	//178
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	//179
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF8 },
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	//180
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0xF8, 0x18, 0xF8 },
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	//181
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xF6 },
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	//182
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE },
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	//183
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x18, 0xF8 },
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	//184
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0xF6, 0x06, 0xF6 },
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	//185
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	//186
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x06, 0xF6 },
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	//187
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0xF6, 0x06, 0xFE },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//188
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xFE },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//189
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0xF8, 0x18, 0xF8 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//190
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8 },
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	//191
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1F },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//192
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xFF },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//193
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF },
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	//194
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1F },
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	//195
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//196
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xFF },
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	//197
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x1F, 0x18, 0x1F },
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	//198
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x37 },
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	//199
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x30, 0x3F },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//200
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x30, 0x37 },
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	//201
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0xF7, 0x00, 0xFF },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//202
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xF7 },
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	//203
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x30, 0x37 },
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	//204
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//205
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0xF7, 0x00, 0xF7 },
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	//206
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0xFF, 0x00, 0xFF },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//207
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xFF },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//208
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF },
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	//209
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF },
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	//210
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3F },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//211
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x1F, 0x18, 0x1F },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//212
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x18, 0x1F },
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	//213
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F },
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	//214
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xFF },
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	//215
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0xFF, 0x18, 0xFF },
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	//216
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF8 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//217
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F },
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	//218
	{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
	{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },	//219
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF },
	{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },	//220
	{ 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0 },
	{ 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0 },	//221
	{ 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F },
	{ 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F },	//222
	{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//223
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xDC, 0xD8 },
	{ 0xD8, 0xD8, 0xDC, 0x76, 0x00, 0x00, 0x00, 0x00 },	//224
	{ 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xDC, 0xC6 },
	{ 0xC3, 0xC3, 0xC3, 0xCE, 0x00, 0x00, 0x00, 0x00 },	//225
	{ 0x00, 0x00, 0xFE, 0xC6, 0xC6, 0xC0, 0xC0, 0xC0 },
	{ 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00 },	//226
	{ 0x00, 0x00, 0x00, 0x00, 0x80, 0xFE, 0x6C, 0x6C },
	{ 0x6C, 0x6C, 0x6C, 0x6C, 0x00, 0x00, 0x00, 0x00 },	//227
	{ 0x00, 0x00, 0x00, 0xFE, 0xC6, 0x60, 0x30, 0x18 },
	{ 0x30, 0x60, 0xC6, 0xFE, 0x00, 0x00, 0x00, 0x00 },	//228
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0xD8, 0xD8 },
	{ 0xD8, 0xD8, 0xD8, 0x70, 0x00, 0x00, 0x00, 0x00 },	//229
	{ 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66 },
	{ 0x66, 0x7C, 0x60, 0x60, 0xC0, 0x00, 0x00, 0x00 },	//230
	{ 0x00, 0x00, 0x00, 0x00, 0x76, 0xDC, 0x18, 0x18 },
	{ 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	//231
	{ 0x00, 0x00, 0x00, 0x7E, 0x18, 0x3C, 0x66, 0x66 },
	{ 0x66, 0x3C, 0x18, 0x7E, 0x00, 0x00, 0x00, 0x00 },	//232
	{ 0x00, 0x00, 0x00, 0x38, 0x6C, 0xC6, 0xC6, 0xFE },
	{ 0xC6, 0xC6, 0x6C, 0x38, 0x00, 0x00, 0x00, 0x00 },	//233
	{ 0x00, 0x00, 0x38, 0x6C, 0xC6, 0xC6, 0xC6, 0x6C },
	{ 0x6C, 0x6C, 0x6C, 0xEE, 0x00, 0x00, 0x00, 0x00 },	//234
	{ 0x00, 0x00, 0x1E, 0x30, 0x18, 0x0C, 0x3E, 0x66 },
	{ 0x66, 0x66, 0x66, 0x3C, 0x00, 0x00, 0x00, 0x00 },	//235
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0xDB, 0xDB },
	{ 0xDB, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//236
	{ 0x00, 0x00, 0x00, 0x03, 0x06, 0x7E, 0xCF, 0xDB },
	{ 0xF3, 0x7E, 0x60, 0xC0, 0x00, 0x00, 0x00, 0x00 },	//237
	{ 0x00, 0x00, 0x1C, 0x30, 0x60, 0x60, 0x7C, 0x60 },
	{ 0x60, 0x60, 0x30, 0x1C, 0x00, 0x00, 0x00, 0x00 },	//238
	{ 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6 },
	{ 0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00 },	//239
	{ 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0xFE },
	{ 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00 },	//240
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7E, 0x18 },
	{ 0x18, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00 },	//241
	{ 0x00, 0x00, 0x00, 0x30, 0x18, 0x0C, 0x06, 0x0C },
	{ 0x18, 0x30, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00 },	//242
	{ 0x00, 0x00, 0x00, 0x0C, 0x18, 0x30, 0x60, 0x30 },
	{ 0x18, 0x0C, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00 },	//243
	{ 0x00, 0x00, 0x0E, 0x1B, 0x1B, 0x18, 0x18, 0x18 },
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	//244
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },
	{ 0xD8, 0xD8, 0xD8, 0x70, 0x00, 0x00, 0x00, 0x00 },	//245
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7E },
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	//246
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xDC, 0x00 },
	{ 0x76, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//247
	{ 0x00, 0x38, 0x6C, 0x6C, 0x38, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//248
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18 },
	{ 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//249
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//250
	{ 0x00, 0x0F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xEC },
	{ 0x6C, 0x6C, 0x3C, 0x1C, 0x00, 0x00, 0x00, 0x00 },	//251
	{ 0x00, 0xD8, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//252
	{ 0x00, 0x70, 0x98, 0x30, 0x60, 0xC8, 0xF8, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//253
	{ 0x00, 0x00, 0x00, 0x00, 0x7C, 0x7C, 0x7C, 0x7C },
	{ 0x7C, 0x7C, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00 },	//254
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	//255
};

static void config_OEM_regs(void);
static void unprotect_reg(void);
static void reprotect_reg(void);
static void set_memCLK(BYTE mem_Type, BYTE mem_MD);
static void init_SGRAM(void);
static void config_video_memory(void);
static void set_video_mode(void);
static void clear_MEM(void);
static void set_font(void);

static int init9880(void)
{
	unprotect_reg();

	//if use SDRAM
	//outp(Port_CRX, 0x2a);
	//outp(Port_CRX+1, (inp(Port_CRX+1) & ~0x0c) | 0x08);
	//disable other card

	//enable VGA
	outp(0x3c3, 0x01);
	outp(0x4e68, 0x08);

	outp(0x3c2, 0x23);

	//if chip revB
	if (CHIPREV == 0x02) {
		printk(BIOS_DEBUG, "blade3d: chip revision B\n");
		outp(Port_CRX, 0xc0);
		outp(Port_CRX + 1, 0x00);
	}
	config_OEM_regs();
	init_SGRAM();
	//config_video_memory();
	set_video_mode();
	reprotect_reg();
	//screen on
	outp(Port_SRX, 0x01);
	outp(Port_SRX + 1, inp(Port_SRX + 1) & ~0x20);

	return 0;
}

static void config_OEM_regs(void)
{
	BYTE CRX_2A, Old_value;
	BYTE mem_Type;
	BYTE mem_MD;
	WORD i;

	lpDef_Reg_struct lpMode3_temp;
	lpDef_Reg_struct lpInit_reg;
	lpMode3_temp = &Mode3_temp[0];
	lpInit_reg = &Init_reg[0];

	printk(BIOS_DEBUG, "blade3d: config_OEM_regs()\n");

	outp(Port_GRX, 0x24);
	outp(Port_GRX + 1, 0xe0);
	//MCLK VCLK to 16 bit
	outp(Port_CRX, 0xcf);
	outp(Port_CRX + 1, inp(Port_CRX + 1) | 0x03);
	//3c5.0e
	//outp(Port_SRX, 0x3b);
	//outp(Port_SRX+1, inp(Port_SRX+1) | 0x20);
	//
	outp(Port_CRX, 0x3b);
	outp(Port_CRX + 1, inp(Port_CRX + 1) | 0x20);
	//
	outp(Port_CRX, 0x1a);
	outp(Port_CRX + 1, inp(Port_CRX + 1) & 0x08);
	//
	outp(Port_CRX, 0x2a);
	CRX_2A = inp(Port_CRX + 1);
	outp(Port_CRX + 1, CRX_2A & ~0x20);

	mem_Type = (CRX_2A & ~0x20) & 0x08;

	outp(Port_GRX, 0x0f);
	if (0x08 == mem_Type)
		outp(Port_GRX + 1, inp(Port_GRX + 1) | 0x20);
	else
		outp(Port_GRX + 1, inp(Port_GRX + 1) & ~0x20);

	outp(Port_CRX, 0x28);
	mem_MD = inp(Port_CRX + 1) & 0x07;

	set_memCLK(mem_Type, mem_MD);
	delay(100);

	if (0x08 == mem_Type) {
		outp(Port_CRX, 0x2e);
		outp(Port_CRX + 1, 0x00);
		delay(100);
		outp(Port_CRX, 0x2d);
		outp(Port_CRX + 1, 0x92);
	} else {
		outp(Port_CRX, 0x2d);
		outp(Port_CRX + 1, 0x82);
	}

	for (i = 0; i < Length_Mode3_temp; i++) {
		outp(lpMode3_temp[i].rPort, lpMode3_temp[i].rIndex);
		Old_value = inp(lpMode3_temp[i].rPort + 1);
		outp(lpMode3_temp[i].rPort + 1,
		     lpMode3_temp[i].rValue | (Old_value & lpMode3_temp[i].
					       rMask));
	}
	//screen off
	outp(Port_SRX, 0x01);
	outp(Port_SRX + 1, inp(Port_SRX + 1) | 0x20);

	for (i = 0; i < Length_Init_reg; i++) {
		outp(lpInit_reg[i].rPort, lpInit_reg[i].rIndex);
		Old_value = inp(lpInit_reg[i].rPort + 1);
		outp(lpInit_reg[i].rPort + 1,
		     lpInit_reg[i].rValue | (Old_value & lpInit_reg[i].
					     rMask));
	}
	delay(10);
	init_SGRAM();

	outp(Port_CRX, 0x1a);
	if (0x08 == inp(Port_CRX + 1)) {
		outp(Port_CRX, 0x20);
		outp(Port_CRX + 1, inp(Port_CRX + 1) | 0x04);
	}

}				//end config_OEM_reg

//---------------------------------------------------------------------------//

static void unprotect_reg(void)
{
	outp(Port_SRX, 0x11);
	outp(Port_SRX + 1, 0x92);
}

static void reprotect_reg(void)
{
	outp(Port_SRX, 0x11);
	outp(Port_SRX + 1, 0x87);
}

static void set_memCLK(BYTE mem_Type, BYTE mem_MD)
{
	BYTE Index;

	Index = ((mem_Type + mem_MD) << 0x01) & 0xf;
	outp(Port_SRX, 0x16);
	outp(Port_SRX + 1, Mem_Clk_Table[Index][0]);
	outp(Port_SRX, 0x17);
	outp(Port_SRX + 1, Mem_Clk_Table[Index][1]);

}

static void init_SGRAM(void)
{
	BYTE Temp, i;

	outp(Port_CRX, 0x2a);
	if (inp(Port_CRX + 1) & 0x08)	//SGRAM
	{
		outp(Port_CRX, 0x28);
		if (inp(Port_CRX + 1) & 0x08) {
			outp(Port_CRX, 0x1c);
			outp(Port_CRX + 1, 0x7a);
		} else {
			outp(Port_CRX, 0x1c);
			outp(Port_CRX + 1, 0x3a);
		}
		outp(Port_CRX, 0x1b);
		outp(Port_CRX + 1, SGRAMTimg);
		if (CHIPREV >= 0x03) {
			outp(Port_CRX, 0x1a);
			outp(Port_CRX + 1, inp(Port_CRX + 1) | 0x01);
		} else {
			outp(Port_CRX, 0x1a);
			outp(Port_CRX + 1, 0x16);
			outp(Port_CRX + 1, inp(Port_CRX + 1) | 0x16);
			for (i = 0; i < 10; i++) {
				outp(Port_CRX, 0x1c);
				outp(Port_CRX + 1,
				     inp(Port_CRX + 1) | 0x40);
			}
			delay(100);
			outp(Port_CRX, 0x1c);
			Temp = (inp(Port_CRX + 1) | 0x20) & 0x3c;
			outp(Port_CRX + 1, Temp);
			outp(Port_CRX + 1, Temp & 0x08);
		}

	} else {			//SGRAM
		printk(BIOS_DEBUG, "blade3d: No SGRAM found.\n");
	}
}

static void config_video_memory(void)
{
	printk(BIOS_DEBUG, "blade3d: Error: no video memory init\n");
}

static void set_video_mode(void)
{
	BYTE i;
	BYTE Old_value;
	lpDef_Reg_struct lpMode3_reg;
	lpMode3_reg = &Mode3_reg[0];

	printk(BIOS_DEBUG, "blade3d: setting video mode\n");
	outp(0x3c2, 0x67);
	for (i = 0; i < Length_Mode3_reg; i++) {
		if (lpMode3_reg[i].rPort == Port_BRX) {
			inp(0x3DA);
			delay(3);
			outp(lpMode3_reg[i].rPort, lpMode3_reg[i].rIndex);
			outp(lpMode3_reg[i].rPort, lpMode3_reg[i].rValue);
		} else {
			outp(lpMode3_reg[i].rPort, lpMode3_reg[i].rIndex);
			Old_value = inp(lpMode3_reg[i].rPort + 1);
			outp(lpMode3_reg[i].rPort + 1,
			     lpMode3_reg[i].
			     rValue | (Old_value & lpMode3_reg[i].rMask));
		}
	}
	//set_font();
	//clear_MEM();
}

static void set_font(void)
{

	printk(BIOS_DEBUG, "blade3d: setting font (not implemented)\n");
}

static void clear_MEM(void)
{
	//_fmemset(MK_FP(0xb800,0),0x720,0x4000);
	__asm__("push %ax\n\t"
		"push %cx\n\t"
		"push %di\n\t"
		"push %es\n\t"
		"mov %ax, 0xb800\n\t"
		"mov %es, %ax\n\t"
		"mov %ax, 0x720\n\t"
		"mov %cx, 0x4000\n\t"
		"xor %di, %di\n\t"
		"rep stosw\n\t"
		"pop %es\n\t"
		"pop %di\n\t"
		"pop %cx\n\t"
		"pop %ax\n\t"
	       );
}


static void trident_blade3d_init(struct device *dev)
{
	printk(BIOS_INFO, "blade3d: initializing video card\n");
	init9880();
}

static struct device_operations trident_blade3d_ops  = {
	.read_resources   = pci_dev_read_resources,
	.set_resources    = pci_dev_set_resources,
	.enable_resources = pci_dev_enable_resources,
	.init             = trident_blade3d_init,
	.scan_bus         = 0,
};

static const struct pci_driver trident_blade3d_driver __pci_driver = {
        .ops    = &trident_blade3d_ops,
        .vendor = 0x1023,
        .device = 0x9880,
};
