/*
 * This file is part of the coreboot project.
 *
 * Copyright 2013 Google Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */


#include <cbfs.h>  /* This driver serves as a CBFS media source. */

#include "spi.h"

int init_default_cbfs_media(struct cbfs_media *media)
{
	return initialize_tegra_spi_cbfs_media(media,
		(void*)CONFIG_CBFS_CACHE_ADDRESS,
		CONFIG_CBFS_CACHE_SIZE);
}
