/*
 * This file is part of the libpayload project.
 *
 * Copyright (C) 2008 Advanced Micro Devices, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <arch/asm.h>

/*
 * Our entry point
 */
ENTRY(_entry)

	/* TODO: disable interrupts */

	/* Clear BSS */
	mov r12, #0
	ldr r2, bss_boundaries
	ldr r3, bss_boundaries + 4
	cmp r2, r3
	beq no_bss

	sub r3, #4 /* Account for late condition check. */
loop:
	cmp r2, r3
	str r12, [r2], #4
	blt loop
no_bss:
	/* Save off the location of the coreboot tables */
	ldr r1, 1f
	str r0, [r1]

	/* Setup new stack */
	ldr sp, 2f

	/* TODO: Save old stack pointer and link register */

	/* Let's rock. */
	bl start_main

	/* %r0 has the return value - pass it on unmolested */

	/* TODO: restore old stack pointer and link register */

	/* Return to the original context. */
	bx lr
ENDPROC(_entry)

.align 4
bss_boundaries:
	.word _edata
	.word _end
1:
.word	cb_header_ptr
2:
.word	_stack
