---
title: ASUS Chromebook C201 
x-toc-enable: true
...

NOTE: support for this machine is dropped in recent Libreboot releases. It will
be re-added at a later date. For now, please use Libreboot 20160907 on this
machine.

NOTE: much of this page is outdated. for instance, it references cafe beverage
who later revealed herself to be Alyssa Rosenzweig, who then launched the
Panfrost project.

This is a Chromebook, using the Rockchip RK3288 SoC. It uses an ARM CPU,
and has free EC firmware (unlike some other laptops). More RK3288-based
laptops will be added to libreboot at a later date.

Flashing instructions can be found at
[../install/\#flashrom](../install/#flashrom)

Google's intent with CrOS devices
==================================

CrOS (Chromium OS/Chrome OS) devices, such as Chromebooks, were not
designed with the intent of bringing more freedom to users. However,
they run with a lot of free software at the boot software and embedded
controller levels, since free software gives Google enough flexibility
to optimize various aspects such as boot time and most importantly, to
implement the CrOS security system, that involves various aspects of the
software. Google does hire a lot of Coreboot developers, who are
generally friendly to the free software movement and try to be good
members of the free software community, by contributing code back.

CrOS devices are designed (from the factory) to actually coax the user
into using proprietary web services (SaaSS) that invade the user's
privacy (ChromeOS is literally just the Google Chrome browser when you
boot up, itself proprietary and comes with proprietary add-ons like
flash. It's only intended for SaaSS, not actual, real computing).
Google is even a member of the *PRISM* program, as outlined by Edward
Snowden. See notes about ChromeOS below. The libreboot project
recommends that the user replace the default *ChromeOS* with a
distribution that can be used in freedom, without invading the user's
privacy.

We also use a similar argument for the MacBook and the ThinkPads that
are supported in libreboot. Those laptops are supported, in spite of
Apple and Lenovo, companies which are actually *hostile* to the free
software movement.

Considerations about ChromeOS and free operating systems
========================================================

This laptop comes preinstalled (from the factory) with Google ChromeOS.
This is a GNU+Linux distribution, but it's not general purpose and it
comes with proprietary software. It's designed for SaaSS. Libreboot
recommends that users of this laptop replace it with another
distribution.

Debian GNU+Linux
----------------

<https://wiki.debian.org/InstallingDebianOn/Asus/C201> shows how to
install Debian.

Devuan GNU+Linux
----------------

<https://notabug.org/dimkr/devsus> produces bootable and installable
Devuan images.

Parabola GNU+Linux
------------------

See:
<https://lists.gnu.org/archive/html/libreboot/2015-12/msg00026.html>

In this discussion thread (on the old GNU Libreboot mailing lists), there are
instructions for installing Parabola on C201 and other rockchip chromebooks
supported by Libreboot.

Caution: Video acceleration requires a non-free blob, software rendering can be used instead.
=============================================================================================

The C201 has a Mali T GPU, which requires a non-free blob. A driver,
Tamil, was written, but its source code has not been released. The
developer has so-far [withheld
it](http://libv.livejournal.com/27461.html). Use software rendering to
avoid the blob instead. Most tasks can still be performed without video
acceleration, without any noticeable performance penalty.

In practise, this means that certain things like games, blender and
GNOME shell (or other fancy desktops) won't work well. The libreboot
project recommends a lightweight desktop which does not need video
acceleration, such as *XFCE* or *LXDE*.

As it is unlikely that Tamil will be released, the
[chai](https://notabug.org/cafe/chai) project is writing a driver as
well. Ask on IRC if you think you can contribute.

Caution: WiFi requires a non-free blob, a USB dongle can be used instead.
=========================================================================

These laptops have non-removeable (soldered on) M.2 Type 1216 card
with WiFi+Bluetooth, which requires non-free firmware to be loaded by
the Linux kernel in order to work.

The libreboot project recommends using an external USB wifi dongle that
works with free software. See
[\#recommended\_wifi](./#recommended_wifi).

There are 2 companies (endorsed by Free Software Foundation, under their
*Respects your Freedom* guidelines), that sell USB WiFi dongles
guaranteed to work with free software (i.e. linux-libre kernel):

-   [ThinkPenguin sells
    them](https://www.thinkpenguin.com/gnu-linux/penguin-wireless-n-usb-adapter-gnu-linux-tpe-n150usb)
    (company based in USA)
-   [Tehnoetic sells
    them](https://tehnoetic.com/tehnoetic-wireless-adapter-gnu-linux-libre-tet-n150)
    (company based in Europe)

These wifi dongles use the AR9271 (atheros) chipset, supported by the
free *ath9k\_htc* driver in the Linux kernel. They work in *linux-libre*
too.

EC firmware is free software!
=============================

It's free software. Google provides the source. Build scripts will be
added later, with EC sources provided in libreboot, and builds of the EC
firmware.

This is unlike the other current libreboot laptops (Intel based). In
practise, you can (if you do without the video/wifi blobs, and replace
ChromeOS with a distribution that respects your freedom) be more free
when using one of these laptops.

The libreboot FAQ briefly describes what an *EC* is:
[../../faq.md#firmware-ec](../../faq.md#firmware-ec)

No microcode!
=============

Unlike x86 (e.g. Intel/AMD) CPUs, ARM CPUs do not use microcode, not
even built in. On the Intel/AMD based libreboot systems, there is still
microcode in the CPU (not considered problematic by the FSF, provided
that it is reasonably trusted to not be malicious, since it's part of
the hardware and read-only), but we exclude microcode updates (volatile
updates which are uploaded at boot time by the boot firmware, if
present), which are proprietary software.

On ARM CPUs, the instruction set is implemented in circuitry, without
microcode.

Depthcharge payload
===================

These systems do not use the GRUB payload. Instead, they use a payload
called depthcharge, which is common on CrOS devices. This is free
software, maintained by Google.

Flash chip write protection: the screw
======================================

It's next to the flash chip. Unscrew it, and the flash chip is
read-write. Screw it back in, and the flash chip is read-only. It's
called the screw.

*The screw* is accessible by removing other screws and gently prying off
the upper shell, where the flash chip and the screw are then directly
accessible. User flashing from software is possible, without having to
externally re-flash, but the flash chip is SPI (SOIC-8 form factor) so
you can also externally re-flash if you want to. In practise, you only
need to externally re-flash if you brick the laptop; read
[../install/spi.md](../install/spi.md) for an example
of how to set up an SPI programmer.

Write protection is useful, because it prevents the firmware from being
re-flashed by any malicious software that might become executed on your
GNU+Linux system, as root. In other words, it can prevent a
firmware-level *evil maid* attack. It's possible to write protect on
all current libreboot systems, but CrOS devices make it easy. The screw
is such a stupidly simple idea, which all designs should implement.
