#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 text-icu
version:              0.7.1.0
visibility:           public
id:                   text-icu-0.7.1.0-4lRD4kS3GycDn8oAzrlddC
key:                  text-icu-0.7.1.0-4lRD4kS3GycDn8oAzrlddC
license:              BSD-3-Clause
copyright:            2009-2015 Bryan O'\''Sullivan
maintainer:           Bryan O'\''Sullivan <bos@serpentine.com>
homepage:             https://github.com/bos/text-icu
synopsis:             Bindings to the ICU library
description:
    Haskell bindings to the International Components for Unicode (ICU)
    libraries.  These libraries provide robust and full-featured Unicode
    services on a wide variety of platforms.

    Features include:

    * Both pure and impure bindings, to allow for fine control over efficiency
    and ease of use.

    * Breaking of strings on character, word, sentence, and line boundaries.

    * Access to the Unicode Character Database (UCD) of character metadata.

    * String collation functions, for locales where the conventions for
    lexicographic ordering differ from the simple numeric ordering of
    character codes.

    * Character set conversion functions, allowing conversion between
    Unicode and over 220 character encodings.

    * Unicode normalization.  (When implementations keep strings in a
    normalized form, they can be assured that equivalent strings have a
    unique binary representation.)

    * Regular expression search and replace.

    * Security checks for visually confusable (spoofable) strings.

category:             Data, Text
abi:                  d6e9522a4d918a4d2c114f429fb04563
exposed:              True
exposed-modules:
    Data.Text.ICU Data.Text.ICU.Break Data.Text.ICU.Char
    Data.Text.ICU.Collate Data.Text.ICU.Convert Data.Text.ICU.Error
    Data.Text.ICU.Normalize Data.Text.ICU.Regex Data.Text.ICU.Spoof
    Data.Text.ICU.Types

hidden-modules:
    Data.Text.ICU.BitMask Data.Text.ICU.Break.Pure
    Data.Text.ICU.Break.Types Data.Text.ICU.Collate.Internal
    Data.Text.ICU.Collate.Pure Data.Text.ICU.Convert.Internal
    Data.Text.ICU.Error.Internal Data.Text.ICU.Internal
    Data.Text.ICU.Iterator Data.Text.ICU.Normalize.Internal
    Data.Text.ICU.Regex.Internal Data.Text.ICU.Regex.Pure
    Data.Text.ICU.Spoof.Internal Data.Text.ICU.Spoof.Pure
    Data.Text.ICU.Text

import-dirs:          /usr/lib/ghc-8.10.5/site-local/text-icu-0.7.1.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/text-icu-0.7.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/text-icu-0.7.1.0
hs-libraries:         HStext-icu-0.7.1.0-4lRD4kS3GycDn8oAzrlddC
extra-libraries:      icuuc icui18n icudata
depends:
    base-4.14.2.0 bytestring-0.10.12.0 deepseq-1.4.4.0 text-1.2.4.1

haddock-interfaces:   /usr/share/doc/haskell-text-icu/html/text-icu.haddock
haddock-html:         /usr/share/doc/haskell-text-icu/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

