#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 versions
version:              5.0.0
visibility:           public
id:                   versions-5.0.0-6rJibBh5K0q3bKq4DYNxNl
key:                  versions-5.0.0-6rJibBh5K0q3bKq4DYNxNl
license:              BSD-3-Clause
maintainer:           colin@fosskers.ca
author:               Colin Woodbury
homepage:             https://github.com/fosskers/versions
synopsis:             Types and parsers for software version numbers.
description:
    A library for parsing and comparing software version numbers. We like to give
    version numbers to our software in a myriad of ways. Some ways follow strict
    guidelines for incrementing and comparison. Some follow conventional wisdom
    and are generally self-consistent. Some are just plain asinine. This library
    provides a means of parsing and comparing /any/ style of versioning, be it a
    nice Semantic Version like this:

    > 1.2.3-r1+git123

    ...or a monstrosity like this:

    > 2:10.2+0.0093r3+1-1

    Please switch to <http://semver.org Semantic Versioning> if you aren'\''t
    currently using it. It provides consistency in version incrementing and has
    the best constraints on comparisons.

    This library implements version @2.0.0@ of the SemVer spec.

category:             Data
abi:                  6b066d1f6c915e468487052a7bd18531
exposed:              True
exposed-modules:      Data.Versions
import-dirs:          /usr/lib/ghc-8.10.5/site-local/versions-5.0.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/versions-5.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/versions-5.0.0
hs-libraries:         HSversions-5.0.0-6rJibBh5K0q3bKq4DYNxNl
depends:
    base-4.14.2.0 deepseq-1.4.4.0
    hashable-1.3.2.0-L2CDkY7lZtECinpkHRj0mo
    megaparsec-9.0.1-IyAio6GA8vt39fw1sjLrjI
    parser-combinators-1.3.0-I56cvBuZMEG2VbjtPZAqZY text-1.2.4.1

haddock-interfaces:   /usr/share/doc/haskell-versions/html/versions.haddock
haddock-html:         /usr/share/doc/haskell-versions/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

