// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from esp32c3.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Espressif

// +build esp,esp32c3

// 32-bit RISC-V MCU & 2.4 GHz Wi-Fi & Bluetooth 5 (LE)
//
//     Copyright 2021 Espressif Systems (Shanghai) PTE LTD Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
package esp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ESP32-C3"
	CPU          = "RV32IMC"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Highest interrupt number on this device.
	IRQ_max = 0
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)
func HandleInterrupt(num int) {
	switch num {
	}
}

// Peripherals.
var (
	// Peripheral AES
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x6003a000)))

	// Peripheral APB_CTRL
	APB_CTRL = (*APB_CTRL_Type)(unsafe.Pointer(uintptr(0x60026000)))

	// Peripheral APB_SARADC
	APB_SARADC = (*APB_SARADC_Type)(unsafe.Pointer(uintptr(0x60040000)))

	// Peripheral ASSIST_DEBUG
	ASSIST_DEBUG = (*ASSIST_DEBUG_Type)(unsafe.Pointer(uintptr(0x600ce000)))

	// Peripheral DMA
	DMA = (*DMA_Type)(unsafe.Pointer(uintptr(0x6003f000)))

	// Peripheral DS
	DS = (*DS_Type)(unsafe.Pointer(uintptr(0x6003d000)))

	// Peripheral EFUSE
	EFUSE = (*EFUSE_Type)(unsafe.Pointer(uintptr(0x60008800)))

	// Peripheral GPIO
	GPIO = (*GPIO_Type)(unsafe.Pointer(uintptr(0x60004000)))

	// Peripheral GPIOSD
	GPIOSD = (*GPIOSD_Type)(unsafe.Pointer(uintptr(0x60004f00)))

	// Peripheral HMAC
	HMAC = (*HMAC_Type)(unsafe.Pointer(uintptr(0x6003e000)))

	// Peripheral I2C
	I2C = (*I2C_Type)(unsafe.Pointer(uintptr(0x60013000)))

	// Peripheral I2S
	I2S = (*I2S_Type)(unsafe.Pointer(uintptr(0x6002d000)))

	// Peripheral INTERRUPT_CORE0
	INTERRUPT_CORE0 = (*INTERRUPT_CORE0_Type)(unsafe.Pointer(uintptr(0x600c2000)))

	// Peripheral IO_MUX
	IO_MUX = (*IO_MUX_Type)(unsafe.Pointer(uintptr(0x60009000)))

	// Peripheral LEDC
	LEDC = (*LEDC_Type)(unsafe.Pointer(uintptr(0x60019000)))

	// Peripheral RMT
	RMT = (*RMT_Type)(unsafe.Pointer(uintptr(0x60016000)))

	// Peripheral RSA
	RSA = (*RSA_Type)(unsafe.Pointer(uintptr(0x6003c000)))

	// Peripheral RTC_CNTL
	RTC_CNTL = (*RTC_CNTL_Type)(unsafe.Pointer(uintptr(0x60008000)))

	// Peripheral SENSITIVE
	SENSITIVE = (*SENSITIVE_Type)(unsafe.Pointer(uintptr(0x600c1000)))

	// Peripheral SHA
	SHA = (*SHA_Type)(unsafe.Pointer(uintptr(0x6003b000)))

	// Peripheral SPI0
	SPI0 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x60003000)))

	// Peripheral SPI1
	SPI1 = (*SPI1_Type)(unsafe.Pointer(uintptr(0x60002000)))

	// Peripheral SPI2
	SPI2 = (*SPI2_Type)(unsafe.Pointer(uintptr(0x60024000)))

	// Peripheral SYSTEM
	SYSTEM = (*SYSTEM_Type)(unsafe.Pointer(uintptr(0x600c0000)))

	// Peripheral SYSTIMER
	SYSTIMER = (*SYSTIMER_Type)(unsafe.Pointer(uintptr(0x60023000)))

	// Peripheral TIMG
	TIMG0 = (*TIMG_Type)(unsafe.Pointer(uintptr(0x6001f000)))

	// Peripheral UART
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x60000000)))

	// Peripheral UHCI
	UHCI0 = (*UHCI_Type)(unsafe.Pointer(uintptr(0x60014000)))

	// Peripheral USB_DEVICE
	USB_DEVICE = (*USB_DEVICE_Type)(unsafe.Pointer(uintptr(0x60043000)))

	// Peripheral XTS_AES
	XTS_AES = (*XTS_AES_Type)(unsafe.Pointer(uintptr(0x600cc000)))

	// Peripheral TIMG
	TIMG1 = (*TIMG_Type)(unsafe.Pointer(uintptr(0x60020000)))

	// Peripheral UART
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x60010000)))

	// Peripheral UHCI
	UHCI1 = (*UHCI_Type)(unsafe.Pointer(uintptr(0x6000c000)))
)

// Peripheral AES
type AES_Type struct {
	KEY_0             volatile.Register32 // 0x0
	KEY_1             volatile.Register32 // 0x4
	KEY_2             volatile.Register32 // 0x8
	KEY_3             volatile.Register32 // 0xC
	KEY_4             volatile.Register32 // 0x10
	KEY_5             volatile.Register32 // 0x14
	KEY_6             volatile.Register32 // 0x18
	KEY_7             volatile.Register32 // 0x1C
	TEXT_IN_0         volatile.Register32 // 0x20
	TEXT_IN_1         volatile.Register32 // 0x24
	TEXT_IN_2         volatile.Register32 // 0x28
	TEXT_IN_3         volatile.Register32 // 0x2C
	TEXT_OUT_0        volatile.Register32 // 0x30
	TEXT_OUT_1        volatile.Register32 // 0x34
	TEXT_OUT_2        volatile.Register32 // 0x38
	TEXT_OUT_3        volatile.Register32 // 0x3C
	MODE              volatile.Register32 // 0x40
	ENDIAN            volatile.Register32 // 0x44
	TRIGGER           volatile.Register32 // 0x48
	STATE             volatile.Register32 // 0x4C
	IV_MEM            volatile.Register32 // 0x50
	_                 [12]byte
	H_MEM             volatile.Register32 // 0x60
	_                 [12]byte
	J0_MEM            volatile.Register32 // 0x70
	_                 [12]byte
	T0_MEM            volatile.Register32 // 0x80
	_                 [12]byte
	DMA_ENABLE        volatile.Register32 // 0x90
	BLOCK_MODE        volatile.Register32 // 0x94
	BLOCK_NUM         volatile.Register32 // 0x98
	INC_SEL           volatile.Register32 // 0x9C
	AAD_BLOCK_NUM     volatile.Register32 // 0xA0
	REMAINDER_BIT_NUM volatile.Register32 // 0xA4
	CONTINUE          volatile.Register32 // 0xA8
	INT_CLEAR         volatile.Register32 // 0xAC
	INT_ENA           volatile.Register32 // 0xB0
	DATE              volatile.Register32 // 0xB4
	DMA_EXIT          volatile.Register32 // 0xB8
}

// AES.KEY_0: Key material key_0 configure register
func (o *AES_Type) SetKEY_0(value uint32) {
	volatile.StoreUint32(&o.KEY_0.Reg, value)
}
func (o *AES_Type) GetKEY_0() uint32 {
	return volatile.LoadUint32(&o.KEY_0.Reg)
}

// AES.KEY_1: Key material key_1 configure register
func (o *AES_Type) SetKEY_1(value uint32) {
	volatile.StoreUint32(&o.KEY_1.Reg, value)
}
func (o *AES_Type) GetKEY_1() uint32 {
	return volatile.LoadUint32(&o.KEY_1.Reg)
}

// AES.KEY_2: Key material key_2 configure register
func (o *AES_Type) SetKEY_2(value uint32) {
	volatile.StoreUint32(&o.KEY_2.Reg, value)
}
func (o *AES_Type) GetKEY_2() uint32 {
	return volatile.LoadUint32(&o.KEY_2.Reg)
}

// AES.KEY_3: Key material key_3 configure register
func (o *AES_Type) SetKEY_3(value uint32) {
	volatile.StoreUint32(&o.KEY_3.Reg, value)
}
func (o *AES_Type) GetKEY_3() uint32 {
	return volatile.LoadUint32(&o.KEY_3.Reg)
}

// AES.KEY_4: Key material key_4 configure register
func (o *AES_Type) SetKEY_4(value uint32) {
	volatile.StoreUint32(&o.KEY_4.Reg, value)
}
func (o *AES_Type) GetKEY_4() uint32 {
	return volatile.LoadUint32(&o.KEY_4.Reg)
}

// AES.KEY_5: Key material key_5 configure register
func (o *AES_Type) SetKEY_5(value uint32) {
	volatile.StoreUint32(&o.KEY_5.Reg, value)
}
func (o *AES_Type) GetKEY_5() uint32 {
	return volatile.LoadUint32(&o.KEY_5.Reg)
}

// AES.KEY_6: Key material key_6 configure register
func (o *AES_Type) SetKEY_6(value uint32) {
	volatile.StoreUint32(&o.KEY_6.Reg, value)
}
func (o *AES_Type) GetKEY_6() uint32 {
	return volatile.LoadUint32(&o.KEY_6.Reg)
}

// AES.KEY_7: Key material key_7 configure register
func (o *AES_Type) SetKEY_7(value uint32) {
	volatile.StoreUint32(&o.KEY_7.Reg, value)
}
func (o *AES_Type) GetKEY_7() uint32 {
	return volatile.LoadUint32(&o.KEY_7.Reg)
}

// AES.TEXT_IN_0: source text material text_in_0 configure register
func (o *AES_Type) SetTEXT_IN_0(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_0.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_0() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_0.Reg)
}

// AES.TEXT_IN_1: source text material text_in_1 configure register
func (o *AES_Type) SetTEXT_IN_1(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_1.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_1() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_1.Reg)
}

// AES.TEXT_IN_2: source text material text_in_2 configure register
func (o *AES_Type) SetTEXT_IN_2(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_2.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_2() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_2.Reg)
}

// AES.TEXT_IN_3: source text material text_in_3 configure register
func (o *AES_Type) SetTEXT_IN_3(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_3.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_3() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_3.Reg)
}

// AES.TEXT_OUT_0: result text material text_out_0 configure register
func (o *AES_Type) SetTEXT_OUT_0(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_0.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_0() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_0.Reg)
}

// AES.TEXT_OUT_1: result text material text_out_1 configure register
func (o *AES_Type) SetTEXT_OUT_1(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_1.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_1() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_1.Reg)
}

// AES.TEXT_OUT_2: result text material text_out_2 configure register
func (o *AES_Type) SetTEXT_OUT_2(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_2.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_2() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_2.Reg)
}

// AES.TEXT_OUT_3: result text material text_out_3 configure register
func (o *AES_Type) SetTEXT_OUT_3(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_3.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_3() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_3.Reg)
}

// AES.MODE: AES Mode register
func (o *AES_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x7)|value)
}
func (o *AES_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x7
}

// AES.ENDIAN: AES Endian configure register
func (o *AES_Type) SetENDIAN(value uint32) {
	volatile.StoreUint32(&o.ENDIAN.Reg, volatile.LoadUint32(&o.ENDIAN.Reg)&^(0x3f)|value)
}
func (o *AES_Type) GetENDIAN() uint32 {
	return volatile.LoadUint32(&o.ENDIAN.Reg) & 0x3f
}

// AES.TRIGGER: AES trigger register
func (o *AES_Type) SetTRIGGER(value uint32) {
	volatile.StoreUint32(&o.TRIGGER.Reg, volatile.LoadUint32(&o.TRIGGER.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetTRIGGER() uint32 {
	return volatile.LoadUint32(&o.TRIGGER.Reg) & 0x1
}

// AES.STATE: AES state register
func (o *AES_Type) SetSTATE(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x3)|value)
}
func (o *AES_Type) GetSTATE() uint32 {
	return volatile.LoadUint32(&o.STATE.Reg) & 0x3
}

// AES.DMA_ENABLE: DMA-AES working mode register
func (o *AES_Type) SetDMA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.DMA_ENABLE.Reg, volatile.LoadUint32(&o.DMA_ENABLE.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetDMA_ENABLE() uint32 {
	return volatile.LoadUint32(&o.DMA_ENABLE.Reg) & 0x1
}

// AES.BLOCK_MODE: AES cipher block mode register
func (o *AES_Type) SetBLOCK_MODE(value uint32) {
	volatile.StoreUint32(&o.BLOCK_MODE.Reg, volatile.LoadUint32(&o.BLOCK_MODE.Reg)&^(0x7)|value)
}
func (o *AES_Type) GetBLOCK_MODE() uint32 {
	return volatile.LoadUint32(&o.BLOCK_MODE.Reg) & 0x7
}

// AES.BLOCK_NUM: AES block number register
func (o *AES_Type) SetBLOCK_NUM(value uint32) {
	volatile.StoreUint32(&o.BLOCK_NUM.Reg, value)
}
func (o *AES_Type) GetBLOCK_NUM() uint32 {
	return volatile.LoadUint32(&o.BLOCK_NUM.Reg)
}

// AES.INC_SEL: Standard incrementing function configure register
func (o *AES_Type) SetINC_SEL(value uint32) {
	volatile.StoreUint32(&o.INC_SEL.Reg, volatile.LoadUint32(&o.INC_SEL.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetINC_SEL() uint32 {
	return volatile.LoadUint32(&o.INC_SEL.Reg) & 0x1
}

// AES.AAD_BLOCK_NUM: Additional Authential Data block number register
func (o *AES_Type) SetAAD_BLOCK_NUM(value uint32) {
	volatile.StoreUint32(&o.AAD_BLOCK_NUM.Reg, value)
}
func (o *AES_Type) GetAAD_BLOCK_NUM() uint32 {
	return volatile.LoadUint32(&o.AAD_BLOCK_NUM.Reg)
}

// AES.REMAINDER_BIT_NUM: AES remainder bit number register
func (o *AES_Type) SetREMAINDER_BIT_NUM(value uint32) {
	volatile.StoreUint32(&o.REMAINDER_BIT_NUM.Reg, volatile.LoadUint32(&o.REMAINDER_BIT_NUM.Reg)&^(0x7f)|value)
}
func (o *AES_Type) GetREMAINDER_BIT_NUM() uint32 {
	return volatile.LoadUint32(&o.REMAINDER_BIT_NUM.Reg) & 0x7f
}

// AES.CONTINUE: AES continue register
func (o *AES_Type) SetCONTINUE(value uint32) {
	volatile.StoreUint32(&o.CONTINUE.Reg, volatile.LoadUint32(&o.CONTINUE.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetCONTINUE() uint32 {
	return volatile.LoadUint32(&o.CONTINUE.Reg) & 0x1
}

// AES.INT_CLEAR: AES Interrupt clear register
func (o *AES_Type) SetINT_CLEAR(value uint32) {
	volatile.StoreUint32(&o.INT_CLEAR.Reg, volatile.LoadUint32(&o.INT_CLEAR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetINT_CLEAR() uint32 {
	return volatile.LoadUint32(&o.INT_CLEAR.Reg) & 0x1
}

// AES.INT_ENA: AES Interrupt enable register
func (o *AES_Type) SetINT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetINT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}

// AES.DATE: AES version control register
func (o *AES_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x3fffffff)|value)
}
func (o *AES_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x3fffffff
}

// AES.DMA_EXIT: AES-DMA exit config
func (o *AES_Type) SetDMA_EXIT(value uint32) {
	volatile.StoreUint32(&o.DMA_EXIT.Reg, volatile.LoadUint32(&o.DMA_EXIT.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetDMA_EXIT() uint32 {
	return volatile.LoadUint32(&o.DMA_EXIT.Reg) & 0x1
}

// Peripheral APB_CTRL
type APB_CTRL_Type struct {
	SYSCLK_CONF          volatile.Register32 // 0x0
	TICK_CONF            volatile.Register32 // 0x4
	CLK_OUT_EN           volatile.Register32 // 0x8
	WIFI_BB_CFG          volatile.Register32 // 0xC
	WIFI_BB_CFG_2        volatile.Register32 // 0x10
	WIFI_CLK_EN          volatile.Register32 // 0x14
	WIFI_RST_EN          volatile.Register32 // 0x18
	HOST_INF_SEL         volatile.Register32 // 0x1C
	EXT_MEM_PMS_LOCK     volatile.Register32 // 0x20
	_                    [4]byte
	FLASH_ACE0_ATTR      volatile.Register32 // 0x28
	FLASH_ACE1_ATTR      volatile.Register32 // 0x2C
	FLASH_ACE2_ATTR      volatile.Register32 // 0x30
	FLASH_ACE3_ATTR      volatile.Register32 // 0x34
	FLASH_ACE0_ADDR      volatile.Register32 // 0x38
	FLASH_ACE1_ADDR      volatile.Register32 // 0x3C
	FLASH_ACE2_ADDR      volatile.Register32 // 0x40
	FLASH_ACE3_ADDR      volatile.Register32 // 0x44
	FLASH_ACE0_SIZE      volatile.Register32 // 0x48
	FLASH_ACE1_SIZE      volatile.Register32 // 0x4C
	FLASH_ACE2_SIZE      volatile.Register32 // 0x50
	FLASH_ACE3_SIZE      volatile.Register32 // 0x54
	_                    [48]byte
	SPI_MEM_PMS_CTRL     volatile.Register32 // 0x88
	SPI_MEM_REJECT_ADDR  volatile.Register32 // 0x8C
	SDIO_CTRL            volatile.Register32 // 0x90
	REDCY_SIG0           volatile.Register32 // 0x94
	REDCY_SIG1           volatile.Register32 // 0x98
	FRONT_END_MEM_PD     volatile.Register32 // 0x9C
	RETENTION_CTRL       volatile.Register32 // 0xA0
	CLKGATE_FORCE_ON     volatile.Register32 // 0xA4
	MEM_POWER_DOWN       volatile.Register32 // 0xA8
	MEM_POWER_UP         volatile.Register32 // 0xAC
	RND_DATA             volatile.Register32 // 0xB0
	PERI_BACKUP_CONFIG   volatile.Register32 // 0xB4
	PERI_BACKUP_APB_ADDR volatile.Register32 // 0xB8
	PERI_BACKUP_MEM_ADDR volatile.Register32 // 0xBC
	PERI_BACKUP_INT_RAW  volatile.Register32 // 0xC0
	PERI_BACKUP_INT_ST   volatile.Register32 // 0xC4
	PERI_BACKUP_INT_ENA  volatile.Register32 // 0xC8
	_                    [4]byte
	PERI_BACKUP_INT_CLR  volatile.Register32 // 0xD0
	_                    [808]byte
	DATE                 volatile.Register32 // 0x3FC
}

// APB_CTRL.SYSCLK_CONF: APB_CTRL_SYSCLK_CONF_REG
func (o *APB_CTRL_Type) SetSYSCLK_CONF_PRE_DIV_CNT(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x3ff)|value)
}
func (o *APB_CTRL_Type) GetSYSCLK_CONF_PRE_DIV_CNT() uint32 {
	return volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x3ff
}
func (o *APB_CTRL_Type) SetSYSCLK_CONF_CLK_320M_EN(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x400)|value<<10)
}
func (o *APB_CTRL_Type) GetSYSCLK_CONF_CLK_320M_EN() uint32 {
	return (volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x400) >> 10
}
func (o *APB_CTRL_Type) SetSYSCLK_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x800)|value<<11)
}
func (o *APB_CTRL_Type) GetSYSCLK_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x800) >> 11
}
func (o *APB_CTRL_Type) SetSYSCLK_CONF_RST_TICK_CNT(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *APB_CTRL_Type) GetSYSCLK_CONF_RST_TICK_CNT() uint32 {
	return (volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x1000) >> 12
}

// APB_CTRL.TICK_CONF: APB_CTRL_TICK_CONF_REG
func (o *APB_CTRL_Type) SetTICK_CONF_XTAL_TICK_NUM(value uint32) {
	volatile.StoreUint32(&o.TICK_CONF.Reg, volatile.LoadUint32(&o.TICK_CONF.Reg)&^(0xff)|value)
}
func (o *APB_CTRL_Type) GetTICK_CONF_XTAL_TICK_NUM() uint32 {
	return volatile.LoadUint32(&o.TICK_CONF.Reg) & 0xff
}
func (o *APB_CTRL_Type) SetTICK_CONF_CK8M_TICK_NUM(value uint32) {
	volatile.StoreUint32(&o.TICK_CONF.Reg, volatile.LoadUint32(&o.TICK_CONF.Reg)&^(0xff00)|value<<8)
}
func (o *APB_CTRL_Type) GetTICK_CONF_CK8M_TICK_NUM() uint32 {
	return (volatile.LoadUint32(&o.TICK_CONF.Reg) & 0xff00) >> 8
}
func (o *APB_CTRL_Type) SetTICK_CONF_TICK_ENABLE(value uint32) {
	volatile.StoreUint32(&o.TICK_CONF.Reg, volatile.LoadUint32(&o.TICK_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *APB_CTRL_Type) GetTICK_CONF_TICK_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.TICK_CONF.Reg) & 0x10000) >> 16
}

// APB_CTRL.CLK_OUT_EN: APB_CTRL_CLK_OUT_EN_REG
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK20_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK20_OEN() uint32 {
	return volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK22_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x2)|value<<1)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK22_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x2) >> 1
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK44_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x4)|value<<2)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK44_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x4) >> 2
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK_BB_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x8)|value<<3)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK_BB_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x8) >> 3
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK80_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x10)|value<<4)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK80_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x10) >> 4
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK160_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x20)|value<<5)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK160_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x20) >> 5
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK_320M_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x40)|value<<6)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK_320M_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x40) >> 6
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK_ADC_INF_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x80)|value<<7)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK_ADC_INF_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x80) >> 7
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK_DAC_CPU_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x100)|value<<8)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK_DAC_CPU_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x100) >> 8
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK40X_BB_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x200)|value<<9)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK40X_BB_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x200) >> 9
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK_XTAL_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x400)|value<<10)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK_XTAL_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x400) >> 10
}

// APB_CTRL.WIFI_BB_CFG: APB_CTRL_WIFI_BB_CFG_REG
func (o *APB_CTRL_Type) SetWIFI_BB_CFG(value uint32) {
	volatile.StoreUint32(&o.WIFI_BB_CFG.Reg, value)
}
func (o *APB_CTRL_Type) GetWIFI_BB_CFG() uint32 {
	return volatile.LoadUint32(&o.WIFI_BB_CFG.Reg)
}

// APB_CTRL.WIFI_BB_CFG_2: APB_CTRL_WIFI_BB_CFG_2_REG
func (o *APB_CTRL_Type) SetWIFI_BB_CFG_2(value uint32) {
	volatile.StoreUint32(&o.WIFI_BB_CFG_2.Reg, value)
}
func (o *APB_CTRL_Type) GetWIFI_BB_CFG_2() uint32 {
	return volatile.LoadUint32(&o.WIFI_BB_CFG_2.Reg)
}

// APB_CTRL.WIFI_CLK_EN: APB_CTRL_WIFI_CLK_EN_REG
func (o *APB_CTRL_Type) SetWIFI_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.WIFI_CLK_EN.Reg, value)
}
func (o *APB_CTRL_Type) GetWIFI_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.WIFI_CLK_EN.Reg)
}

// APB_CTRL.WIFI_RST_EN: APB_CTRL_WIFI_RST_EN_REG
func (o *APB_CTRL_Type) SetWIFI_RST_EN(value uint32) {
	volatile.StoreUint32(&o.WIFI_RST_EN.Reg, value)
}
func (o *APB_CTRL_Type) GetWIFI_RST_EN() uint32 {
	return volatile.LoadUint32(&o.WIFI_RST_EN.Reg)
}

// APB_CTRL.HOST_INF_SEL: APB_CTRL_HOST_INF_SEL_REG
func (o *APB_CTRL_Type) SetHOST_INF_SEL_PERI_IO_SWAP(value uint32) {
	volatile.StoreUint32(&o.HOST_INF_SEL.Reg, volatile.LoadUint32(&o.HOST_INF_SEL.Reg)&^(0xff)|value)
}
func (o *APB_CTRL_Type) GetHOST_INF_SEL_PERI_IO_SWAP() uint32 {
	return volatile.LoadUint32(&o.HOST_INF_SEL.Reg) & 0xff
}

// APB_CTRL.EXT_MEM_PMS_LOCK: APB_CTRL_EXT_MEM_PMS_LOCK_REG
func (o *APB_CTRL_Type) SetEXT_MEM_PMS_LOCK(value uint32) {
	volatile.StoreUint32(&o.EXT_MEM_PMS_LOCK.Reg, volatile.LoadUint32(&o.EXT_MEM_PMS_LOCK.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetEXT_MEM_PMS_LOCK() uint32 {
	return volatile.LoadUint32(&o.EXT_MEM_PMS_LOCK.Reg) & 0x1
}

// APB_CTRL.FLASH_ACE0_ATTR: APB_CTRL_FLASH_ACE0_ATTR_REG
func (o *APB_CTRL_Type) SetFLASH_ACE0_ATTR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE0_ATTR.Reg, volatile.LoadUint32(&o.FLASH_ACE0_ATTR.Reg)&^(0x3)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE0_ATTR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE0_ATTR.Reg) & 0x3
}

// APB_CTRL.FLASH_ACE1_ATTR: APB_CTRL_FLASH_ACE1_ATTR_REG
func (o *APB_CTRL_Type) SetFLASH_ACE1_ATTR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE1_ATTR.Reg, volatile.LoadUint32(&o.FLASH_ACE1_ATTR.Reg)&^(0x3)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE1_ATTR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE1_ATTR.Reg) & 0x3
}

// APB_CTRL.FLASH_ACE2_ATTR: APB_CTRL_FLASH_ACE2_ATTR_REG
func (o *APB_CTRL_Type) SetFLASH_ACE2_ATTR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE2_ATTR.Reg, volatile.LoadUint32(&o.FLASH_ACE2_ATTR.Reg)&^(0x3)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE2_ATTR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE2_ATTR.Reg) & 0x3
}

// APB_CTRL.FLASH_ACE3_ATTR: APB_CTRL_FLASH_ACE3_ATTR_REG
func (o *APB_CTRL_Type) SetFLASH_ACE3_ATTR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE3_ATTR.Reg, volatile.LoadUint32(&o.FLASH_ACE3_ATTR.Reg)&^(0x3)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE3_ATTR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE3_ATTR.Reg) & 0x3
}

// APB_CTRL.FLASH_ACE0_ADDR: APB_CTRL_FLASH_ACE0_ADDR_REG
func (o *APB_CTRL_Type) SetFLASH_ACE0_ADDR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE0_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE0_ADDR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE0_ADDR.Reg)
}

// APB_CTRL.FLASH_ACE1_ADDR: APB_CTRL_FLASH_ACE1_ADDR_REG
func (o *APB_CTRL_Type) SetFLASH_ACE1_ADDR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE1_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE1_ADDR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE1_ADDR.Reg)
}

// APB_CTRL.FLASH_ACE2_ADDR: APB_CTRL_FLASH_ACE2_ADDR_REG
func (o *APB_CTRL_Type) SetFLASH_ACE2_ADDR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE2_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE2_ADDR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE2_ADDR.Reg)
}

// APB_CTRL.FLASH_ACE3_ADDR: APB_CTRL_FLASH_ACE3_ADDR_REG
func (o *APB_CTRL_Type) SetFLASH_ACE3_ADDR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE3_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE3_ADDR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE3_ADDR.Reg)
}

// APB_CTRL.FLASH_ACE0_SIZE: APB_CTRL_FLASH_ACE0_SIZE_REG
func (o *APB_CTRL_Type) SetFLASH_ACE0_SIZE(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE0_SIZE.Reg, volatile.LoadUint32(&o.FLASH_ACE0_SIZE.Reg)&^(0x1fff)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE0_SIZE() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE0_SIZE.Reg) & 0x1fff
}

// APB_CTRL.FLASH_ACE1_SIZE: APB_CTRL_FLASH_ACE1_SIZE_REG
func (o *APB_CTRL_Type) SetFLASH_ACE1_SIZE(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE1_SIZE.Reg, volatile.LoadUint32(&o.FLASH_ACE1_SIZE.Reg)&^(0x1fff)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE1_SIZE() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE1_SIZE.Reg) & 0x1fff
}

// APB_CTRL.FLASH_ACE2_SIZE: APB_CTRL_FLASH_ACE2_SIZE_REG
func (o *APB_CTRL_Type) SetFLASH_ACE2_SIZE(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE2_SIZE.Reg, volatile.LoadUint32(&o.FLASH_ACE2_SIZE.Reg)&^(0x1fff)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE2_SIZE() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE2_SIZE.Reg) & 0x1fff
}

// APB_CTRL.FLASH_ACE3_SIZE: APB_CTRL_FLASH_ACE3_SIZE_REG
func (o *APB_CTRL_Type) SetFLASH_ACE3_SIZE(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE3_SIZE.Reg, volatile.LoadUint32(&o.FLASH_ACE3_SIZE.Reg)&^(0x1fff)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE3_SIZE() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE3_SIZE.Reg) & 0x1fff
}

// APB_CTRL.SPI_MEM_PMS_CTRL: APB_CTRL_SPI_MEM_PMS_CTRL_REG
func (o *APB_CTRL_Type) SetSPI_MEM_PMS_CTRL_SPI_MEM_REJECT_INT(value uint32) {
	volatile.StoreUint32(&o.SPI_MEM_PMS_CTRL.Reg, volatile.LoadUint32(&o.SPI_MEM_PMS_CTRL.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetSPI_MEM_PMS_CTRL_SPI_MEM_REJECT_INT() uint32 {
	return volatile.LoadUint32(&o.SPI_MEM_PMS_CTRL.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetSPI_MEM_PMS_CTRL_SPI_MEM_REJECT_CLR(value uint32) {
	volatile.StoreUint32(&o.SPI_MEM_PMS_CTRL.Reg, volatile.LoadUint32(&o.SPI_MEM_PMS_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *APB_CTRL_Type) GetSPI_MEM_PMS_CTRL_SPI_MEM_REJECT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SPI_MEM_PMS_CTRL.Reg) & 0x2) >> 1
}
func (o *APB_CTRL_Type) SetSPI_MEM_PMS_CTRL_SPI_MEM_REJECT_CDE(value uint32) {
	volatile.StoreUint32(&o.SPI_MEM_PMS_CTRL.Reg, volatile.LoadUint32(&o.SPI_MEM_PMS_CTRL.Reg)&^(0x7c)|value<<2)
}
func (o *APB_CTRL_Type) GetSPI_MEM_PMS_CTRL_SPI_MEM_REJECT_CDE() uint32 {
	return (volatile.LoadUint32(&o.SPI_MEM_PMS_CTRL.Reg) & 0x7c) >> 2
}

// APB_CTRL.SPI_MEM_REJECT_ADDR: APB_CTRL_SPI_MEM_REJECT_ADDR_REG
func (o *APB_CTRL_Type) SetSPI_MEM_REJECT_ADDR(value uint32) {
	volatile.StoreUint32(&o.SPI_MEM_REJECT_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetSPI_MEM_REJECT_ADDR() uint32 {
	return volatile.LoadUint32(&o.SPI_MEM_REJECT_ADDR.Reg)
}

// APB_CTRL.SDIO_CTRL: APB_CTRL_SDIO_CTRL_REG
func (o *APB_CTRL_Type) SetSDIO_CTRL_SDIO_WIN_ACCESS_EN(value uint32) {
	volatile.StoreUint32(&o.SDIO_CTRL.Reg, volatile.LoadUint32(&o.SDIO_CTRL.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetSDIO_CTRL_SDIO_WIN_ACCESS_EN() uint32 {
	return volatile.LoadUint32(&o.SDIO_CTRL.Reg) & 0x1
}

// APB_CTRL.REDCY_SIG0: APB_CTRL_REDCY_SIG0_REG
func (o *APB_CTRL_Type) SetREDCY_SIG0(value uint32) {
	volatile.StoreUint32(&o.REDCY_SIG0.Reg, volatile.LoadUint32(&o.REDCY_SIG0.Reg)&^(0x7fffffff)|value)
}
func (o *APB_CTRL_Type) GetREDCY_SIG0() uint32 {
	return volatile.LoadUint32(&o.REDCY_SIG0.Reg) & 0x7fffffff
}
func (o *APB_CTRL_Type) SetREDCY_SIG0_REDCY_ANDOR(value uint32) {
	volatile.StoreUint32(&o.REDCY_SIG0.Reg, volatile.LoadUint32(&o.REDCY_SIG0.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_CTRL_Type) GetREDCY_SIG0_REDCY_ANDOR() uint32 {
	return (volatile.LoadUint32(&o.REDCY_SIG0.Reg) & 0x80000000) >> 31
}

// APB_CTRL.REDCY_SIG1: APB_CTRL_REDCY_SIG1_REG
func (o *APB_CTRL_Type) SetREDCY_SIG1(value uint32) {
	volatile.StoreUint32(&o.REDCY_SIG1.Reg, volatile.LoadUint32(&o.REDCY_SIG1.Reg)&^(0x7fffffff)|value)
}
func (o *APB_CTRL_Type) GetREDCY_SIG1() uint32 {
	return volatile.LoadUint32(&o.REDCY_SIG1.Reg) & 0x7fffffff
}
func (o *APB_CTRL_Type) SetREDCY_SIG1_REDCY_NANDOR(value uint32) {
	volatile.StoreUint32(&o.REDCY_SIG1.Reg, volatile.LoadUint32(&o.REDCY_SIG1.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_CTRL_Type) GetREDCY_SIG1_REDCY_NANDOR() uint32 {
	return (volatile.LoadUint32(&o.REDCY_SIG1.Reg) & 0x80000000) >> 31
}

// APB_CTRL.FRONT_END_MEM_PD: APB_CTRL_FRONT_END_MEM_PD_REG
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_AGC_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_AGC_MEM_FORCE_PU() uint32 {
	return volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_AGC_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x2)|value<<1)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_AGC_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x2) >> 1
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_PBUS_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x4)|value<<2)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_PBUS_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x4) >> 2
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_PBUS_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x8)|value<<3)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_PBUS_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x8) >> 3
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_DC_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x10)|value<<4)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_DC_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x10) >> 4
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_DC_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x20)|value<<5)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_DC_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x20) >> 5
}

// APB_CTRL.RETENTION_CTRL: APB_CTRL_RETENTION_CTRL_REG
func (o *APB_CTRL_Type) SetRETENTION_CTRL_RETENTION_LINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.RETENTION_CTRL.Reg, volatile.LoadUint32(&o.RETENTION_CTRL.Reg)&^(0x7ffffff)|value)
}
func (o *APB_CTRL_Type) GetRETENTION_CTRL_RETENTION_LINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.RETENTION_CTRL.Reg) & 0x7ffffff
}
func (o *APB_CTRL_Type) SetRETENTION_CTRL_NOBYPASS_CPU_ISO_RST(value uint32) {
	volatile.StoreUint32(&o.RETENTION_CTRL.Reg, volatile.LoadUint32(&o.RETENTION_CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_CTRL_Type) GetRETENTION_CTRL_NOBYPASS_CPU_ISO_RST() uint32 {
	return (volatile.LoadUint32(&o.RETENTION_CTRL.Reg) & 0x8000000) >> 27
}

// APB_CTRL.CLKGATE_FORCE_ON: APB_CTRL_CLKGATE_FORCE_ON_REG
func (o *APB_CTRL_Type) SetCLKGATE_FORCE_ON_ROM_CLKGATE_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.CLKGATE_FORCE_ON.Reg, volatile.LoadUint32(&o.CLKGATE_FORCE_ON.Reg)&^(0x3)|value)
}
func (o *APB_CTRL_Type) GetCLKGATE_FORCE_ON_ROM_CLKGATE_FORCE_ON() uint32 {
	return volatile.LoadUint32(&o.CLKGATE_FORCE_ON.Reg) & 0x3
}
func (o *APB_CTRL_Type) SetCLKGATE_FORCE_ON_SRAM_CLKGATE_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.CLKGATE_FORCE_ON.Reg, volatile.LoadUint32(&o.CLKGATE_FORCE_ON.Reg)&^(0x3c)|value<<2)
}
func (o *APB_CTRL_Type) GetCLKGATE_FORCE_ON_SRAM_CLKGATE_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.CLKGATE_FORCE_ON.Reg) & 0x3c) >> 2
}

// APB_CTRL.MEM_POWER_DOWN: APB_CTRL_MEM_POWER_DOWN_REG
func (o *APB_CTRL_Type) SetMEM_POWER_DOWN_ROM_POWER_DOWN(value uint32) {
	volatile.StoreUint32(&o.MEM_POWER_DOWN.Reg, volatile.LoadUint32(&o.MEM_POWER_DOWN.Reg)&^(0x3)|value)
}
func (o *APB_CTRL_Type) GetMEM_POWER_DOWN_ROM_POWER_DOWN() uint32 {
	return volatile.LoadUint32(&o.MEM_POWER_DOWN.Reg) & 0x3
}
func (o *APB_CTRL_Type) SetMEM_POWER_DOWN_SRAM_POWER_DOWN(value uint32) {
	volatile.StoreUint32(&o.MEM_POWER_DOWN.Reg, volatile.LoadUint32(&o.MEM_POWER_DOWN.Reg)&^(0x3c)|value<<2)
}
func (o *APB_CTRL_Type) GetMEM_POWER_DOWN_SRAM_POWER_DOWN() uint32 {
	return (volatile.LoadUint32(&o.MEM_POWER_DOWN.Reg) & 0x3c) >> 2
}

// APB_CTRL.MEM_POWER_UP: APB_CTRL_MEM_POWER_UP_REG
func (o *APB_CTRL_Type) SetMEM_POWER_UP_ROM_POWER_UP(value uint32) {
	volatile.StoreUint32(&o.MEM_POWER_UP.Reg, volatile.LoadUint32(&o.MEM_POWER_UP.Reg)&^(0x3)|value)
}
func (o *APB_CTRL_Type) GetMEM_POWER_UP_ROM_POWER_UP() uint32 {
	return volatile.LoadUint32(&o.MEM_POWER_UP.Reg) & 0x3
}
func (o *APB_CTRL_Type) SetMEM_POWER_UP_SRAM_POWER_UP(value uint32) {
	volatile.StoreUint32(&o.MEM_POWER_UP.Reg, volatile.LoadUint32(&o.MEM_POWER_UP.Reg)&^(0x3c)|value<<2)
}
func (o *APB_CTRL_Type) GetMEM_POWER_UP_SRAM_POWER_UP() uint32 {
	return (volatile.LoadUint32(&o.MEM_POWER_UP.Reg) & 0x3c) >> 2
}

// APB_CTRL.RND_DATA: APB_CTRL_RND_DATA_REG
func (o *APB_CTRL_Type) SetRND_DATA(value uint32) {
	volatile.StoreUint32(&o.RND_DATA.Reg, value)
}
func (o *APB_CTRL_Type) GetRND_DATA() uint32 {
	return volatile.LoadUint32(&o.RND_DATA.Reg)
}

// APB_CTRL.PERI_BACKUP_CONFIG: APB_CTRL_PERI_BACKUP_CONFIG_REG
func (o *APB_CTRL_Type) SetPERI_BACKUP_CONFIG_PERI_BACKUP_FLOW_ERR(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_CONFIG.Reg, volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg)&^(0x6)|value<<1)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_CONFIG_PERI_BACKUP_FLOW_ERR() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg) & 0x6) >> 1
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_CONFIG_PERI_BACKUP_BURST_LIMIT(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_CONFIG.Reg, volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg)&^(0x1f0)|value<<4)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_CONFIG_PERI_BACKUP_BURST_LIMIT() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg) & 0x1f0) >> 4
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_CONFIG_PERI_BACKUP_TOUT_THRES(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_CONFIG.Reg, volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg)&^(0x7fe00)|value<<9)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_CONFIG_PERI_BACKUP_TOUT_THRES() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg) & 0x7fe00) >> 9
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_CONFIG_PERI_BACKUP_SIZE(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_CONFIG.Reg, volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg)&^(0x1ff80000)|value<<19)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_CONFIG_PERI_BACKUP_SIZE() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg) & 0x1ff80000) >> 19
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_CONFIG_PERI_BACKUP_START(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_CONFIG.Reg, volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_CONFIG_PERI_BACKUP_START() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg) & 0x20000000) >> 29
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_CONFIG_PERI_BACKUP_TO_MEM(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_CONFIG.Reg, volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_CONFIG_PERI_BACKUP_TO_MEM() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg) & 0x40000000) >> 30
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_CONFIG_PERI_BACKUP_ENA(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_CONFIG.Reg, volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_CONFIG_PERI_BACKUP_ENA() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg) & 0x80000000) >> 31
}

// APB_CTRL.PERI_BACKUP_APB_ADDR: APB_CTRL_PERI_BACKUP_APB_ADDR_REG
func (o *APB_CTRL_Type) SetPERI_BACKUP_APB_ADDR(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_APB_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_APB_ADDR() uint32 {
	return volatile.LoadUint32(&o.PERI_BACKUP_APB_ADDR.Reg)
}

// APB_CTRL.PERI_BACKUP_MEM_ADDR: APB_CTRL_PERI_BACKUP_MEM_ADDR_REG
func (o *APB_CTRL_Type) SetPERI_BACKUP_MEM_ADDR(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_MEM_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_MEM_ADDR() uint32 {
	return volatile.LoadUint32(&o.PERI_BACKUP_MEM_ADDR.Reg)
}

// APB_CTRL.PERI_BACKUP_INT_RAW: APB_CTRL_PERI_BACKUP_INT_RAW_REG
func (o *APB_CTRL_Type) SetPERI_BACKUP_INT_RAW_PERI_BACKUP_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_INT_RAW.Reg, volatile.LoadUint32(&o.PERI_BACKUP_INT_RAW.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_INT_RAW_PERI_BACKUP_DONE_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.PERI_BACKUP_INT_RAW.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_INT_RAW_PERI_BACKUP_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_INT_RAW.Reg, volatile.LoadUint32(&o.PERI_BACKUP_INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_INT_RAW_PERI_BACKUP_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_INT_RAW.Reg) & 0x2) >> 1
}

// APB_CTRL.PERI_BACKUP_INT_ST: APB_CTRL_PERI_BACKUP_INT_ST_REG
func (o *APB_CTRL_Type) SetPERI_BACKUP_INT_ST_PERI_BACKUP_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_INT_ST.Reg, volatile.LoadUint32(&o.PERI_BACKUP_INT_ST.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_INT_ST_PERI_BACKUP_DONE_INT_ST() uint32 {
	return volatile.LoadUint32(&o.PERI_BACKUP_INT_ST.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_INT_ST_PERI_BACKUP_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_INT_ST.Reg, volatile.LoadUint32(&o.PERI_BACKUP_INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_INT_ST_PERI_BACKUP_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_INT_ST.Reg) & 0x2) >> 1
}

// APB_CTRL.PERI_BACKUP_INT_ENA: APB_CTRL_PERI_BACKUP_INT_ENA_REG
func (o *APB_CTRL_Type) SetPERI_BACKUP_INT_ENA_PERI_BACKUP_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_INT_ENA.Reg, volatile.LoadUint32(&o.PERI_BACKUP_INT_ENA.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_INT_ENA_PERI_BACKUP_DONE_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.PERI_BACKUP_INT_ENA.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_INT_ENA_PERI_BACKUP_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_INT_ENA.Reg, volatile.LoadUint32(&o.PERI_BACKUP_INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_INT_ENA_PERI_BACKUP_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_INT_ENA.Reg) & 0x2) >> 1
}

// APB_CTRL.PERI_BACKUP_INT_CLR: APB_CTRL_PERI_BACKUP_INT_CLR_REG
func (o *APB_CTRL_Type) SetPERI_BACKUP_INT_CLR_PERI_BACKUP_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_INT_CLR.Reg, volatile.LoadUint32(&o.PERI_BACKUP_INT_CLR.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_INT_CLR_PERI_BACKUP_DONE_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.PERI_BACKUP_INT_CLR.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_INT_CLR_PERI_BACKUP_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_INT_CLR.Reg, volatile.LoadUint32(&o.PERI_BACKUP_INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_INT_CLR_PERI_BACKUP_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_INT_CLR.Reg) & 0x2) >> 1
}

// APB_CTRL.DATE: APB_CTRL_DATE_REG
func (o *APB_CTRL_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *APB_CTRL_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// Peripheral APB_SARADC
type APB_SARADC_Type struct {
	CTRL            volatile.Register32 // 0x0
	CTRL2           volatile.Register32 // 0x4
	FILTER_CTRL1    volatile.Register32 // 0x8
	FSM_WAIT        volatile.Register32 // 0xC
	SAR1_STATUS     volatile.Register32 // 0x10
	SAR2_STATUS     volatile.Register32 // 0x14
	SAR_PATT_TAB1   volatile.Register32 // 0x18
	SAR_PATT_TAB2   volatile.Register32 // 0x1C
	ONETIME_SAMPLE  volatile.Register32 // 0x20
	ARB_CTRL        volatile.Register32 // 0x24
	FILTER_CTRL0    volatile.Register32 // 0x28
	SAR1DATA_STATUS volatile.Register32 // 0x2C
	SAR2DATA_STATUS volatile.Register32 // 0x30
	THRES0_CTRL     volatile.Register32 // 0x34
	THRES1_CTRL     volatile.Register32 // 0x38
	THRES_CTRL      volatile.Register32 // 0x3C
	INT_ENA         volatile.Register32 // 0x40
	INT_RAW         volatile.Register32 // 0x44
	INT_ST          volatile.Register32 // 0x48
	INT_CLR         volatile.Register32 // 0x4C
	DMA_CONF        volatile.Register32 // 0x50
	CLKM_CONF       volatile.Register32 // 0x54
	APB_TSENS_CTRL  volatile.Register32 // 0x58
	TSENS_CTRL2     volatile.Register32 // 0x5C
	CALI            volatile.Register32 // 0x60
	_               [920]byte
	CTRL_DATE       volatile.Register32 // 0x3FC
}

// APB_SARADC.CTRL: digital saradc configure register
func (o *APB_SARADC_Type) SetCTRL_SARADC_START_FORCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_START_FORCE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_START(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_START() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR_CLK_GATED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR_CLK_GATED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x7f80)|value<<7)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x7f80) >> 7
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR_PATT_LEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x38000)|value<<15)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR_PATT_LEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x38000) >> 15
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR_PATT_P_CLEAR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR_PATT_P_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800000) >> 23
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_XPD_SAR_FORCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x18000000)|value<<27)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_XPD_SAR_FORCE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x18000000) >> 27
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_WAIT_ARB_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xc0000000)|value<<30)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_WAIT_ARB_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xc0000000) >> 30
}

// APB_SARADC.CTRL2: digital saradc configure register
func (o *APB_SARADC_Type) SetCTRL2_SARADC_MEAS_NUM_LIMIT(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1)|value)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_MEAS_NUM_LIMIT() uint32 {
	return volatile.LoadUint32(&o.CTRL2.Reg) & 0x1
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_MAX_MEAS_NUM(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1fe)|value<<1)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_MAX_MEAS_NUM() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x1fe) >> 1
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_SAR1_INV(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x200)|value<<9)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_SAR1_INV() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x200) >> 9
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_SAR2_INV(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x400)|value<<10)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_SAR2_INV() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x400) >> 10
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_TIMER_TARGET(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0xfff000)|value<<12)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_TIMER_TARGET() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0xfff000) >> 12
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_TIMER_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1000000)|value<<24)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_TIMER_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x1000000) >> 24
}

// APB_SARADC.FILTER_CTRL1: digital saradc configure register
func (o *APB_SARADC_Type) SetFILTER_CTRL1_APB_SARADC_FILTER_FACTOR1(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL1.Reg, volatile.LoadUint32(&o.FILTER_CTRL1.Reg)&^(0x1c000000)|value<<26)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL1_APB_SARADC_FILTER_FACTOR1() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL1.Reg) & 0x1c000000) >> 26
}
func (o *APB_SARADC_Type) SetFILTER_CTRL1_APB_SARADC_FILTER_FACTOR0(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL1.Reg, volatile.LoadUint32(&o.FILTER_CTRL1.Reg)&^(0xe0000000)|value<<29)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL1_APB_SARADC_FILTER_FACTOR0() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL1.Reg) & 0xe0000000) >> 29
}

// APB_SARADC.FSM_WAIT: digital saradc configure register
func (o *APB_SARADC_Type) SetFSM_WAIT_SARADC_XPD_WAIT(value uint32) {
	volatile.StoreUint32(&o.FSM_WAIT.Reg, volatile.LoadUint32(&o.FSM_WAIT.Reg)&^(0xff)|value)
}
func (o *APB_SARADC_Type) GetFSM_WAIT_SARADC_XPD_WAIT() uint32 {
	return volatile.LoadUint32(&o.FSM_WAIT.Reg) & 0xff
}
func (o *APB_SARADC_Type) SetFSM_WAIT_SARADC_RSTB_WAIT(value uint32) {
	volatile.StoreUint32(&o.FSM_WAIT.Reg, volatile.LoadUint32(&o.FSM_WAIT.Reg)&^(0xff00)|value<<8)
}
func (o *APB_SARADC_Type) GetFSM_WAIT_SARADC_RSTB_WAIT() uint32 {
	return (volatile.LoadUint32(&o.FSM_WAIT.Reg) & 0xff00) >> 8
}
func (o *APB_SARADC_Type) SetFSM_WAIT_SARADC_STANDBY_WAIT(value uint32) {
	volatile.StoreUint32(&o.FSM_WAIT.Reg, volatile.LoadUint32(&o.FSM_WAIT.Reg)&^(0xff0000)|value<<16)
}
func (o *APB_SARADC_Type) GetFSM_WAIT_SARADC_STANDBY_WAIT() uint32 {
	return (volatile.LoadUint32(&o.FSM_WAIT.Reg) & 0xff0000) >> 16
}

// APB_SARADC.SAR1_STATUS: digital saradc configure register
func (o *APB_SARADC_Type) SetSAR1_STATUS(value uint32) {
	volatile.StoreUint32(&o.SAR1_STATUS.Reg, value)
}
func (o *APB_SARADC_Type) GetSAR1_STATUS() uint32 {
	return volatile.LoadUint32(&o.SAR1_STATUS.Reg)
}

// APB_SARADC.SAR2_STATUS: digital saradc configure register
func (o *APB_SARADC_Type) SetSAR2_STATUS(value uint32) {
	volatile.StoreUint32(&o.SAR2_STATUS.Reg, value)
}
func (o *APB_SARADC_Type) GetSAR2_STATUS() uint32 {
	return volatile.LoadUint32(&o.SAR2_STATUS.Reg)
}

// APB_SARADC.SAR_PATT_TAB1: digital saradc configure register
func (o *APB_SARADC_Type) SetSAR_PATT_TAB1_SARADC_SAR_PATT_TAB1(value uint32) {
	volatile.StoreUint32(&o.SAR_PATT_TAB1.Reg, volatile.LoadUint32(&o.SAR_PATT_TAB1.Reg)&^(0xffffff)|value)
}
func (o *APB_SARADC_Type) GetSAR_PATT_TAB1_SARADC_SAR_PATT_TAB1() uint32 {
	return volatile.LoadUint32(&o.SAR_PATT_TAB1.Reg) & 0xffffff
}

// APB_SARADC.SAR_PATT_TAB2: digital saradc configure register
func (o *APB_SARADC_Type) SetSAR_PATT_TAB2_SARADC_SAR_PATT_TAB2(value uint32) {
	volatile.StoreUint32(&o.SAR_PATT_TAB2.Reg, volatile.LoadUint32(&o.SAR_PATT_TAB2.Reg)&^(0xffffff)|value)
}
func (o *APB_SARADC_Type) GetSAR_PATT_TAB2_SARADC_SAR_PATT_TAB2() uint32 {
	return volatile.LoadUint32(&o.SAR_PATT_TAB2.Reg) & 0xffffff
}

// APB_SARADC.ONETIME_SAMPLE: digital saradc configure register
func (o *APB_SARADC_Type) SetONETIME_SAMPLE_SARADC_ONETIME_ATTEN(value uint32) {
	volatile.StoreUint32(&o.ONETIME_SAMPLE.Reg, volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg)&^(0x1800000)|value<<23)
}
func (o *APB_SARADC_Type) GetONETIME_SAMPLE_SARADC_ONETIME_ATTEN() uint32 {
	return (volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg) & 0x1800000) >> 23
}
func (o *APB_SARADC_Type) SetONETIME_SAMPLE_SARADC_ONETIME_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.ONETIME_SAMPLE.Reg, volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg)&^(0x1e000000)|value<<25)
}
func (o *APB_SARADC_Type) GetONETIME_SAMPLE_SARADC_ONETIME_CHANNEL() uint32 {
	return (volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg) & 0x1e000000) >> 25
}
func (o *APB_SARADC_Type) SetONETIME_SAMPLE_SARADC_ONETIME_START(value uint32) {
	volatile.StoreUint32(&o.ONETIME_SAMPLE.Reg, volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetONETIME_SAMPLE_SARADC_ONETIME_START() uint32 {
	return (volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetONETIME_SAMPLE_SARADC2_ONETIME_SAMPLE(value uint32) {
	volatile.StoreUint32(&o.ONETIME_SAMPLE.Reg, volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetONETIME_SAMPLE_SARADC2_ONETIME_SAMPLE() uint32 {
	return (volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetONETIME_SAMPLE_SARADC1_ONETIME_SAMPLE(value uint32) {
	volatile.StoreUint32(&o.ONETIME_SAMPLE.Reg, volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetONETIME_SAMPLE_SARADC1_ONETIME_SAMPLE() uint32 {
	return (volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg) & 0x80000000) >> 31
}

// APB_SARADC.ARB_CTRL: digital saradc configure register
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_APB_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_APB_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x4) >> 2
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_RTC_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_RTC_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x8) >> 3
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_WIFI_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_WIFI_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x10) >> 4
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_GRANT_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_GRANT_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x20) >> 5
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_APB_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0xc0)|value<<6)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_APB_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0xc0) >> 6
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_RTC_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_RTC_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x300) >> 8
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_WIFI_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_WIFI_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0xc00) >> 10
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_FIX_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_FIX_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x1000) >> 12
}

// APB_SARADC.FILTER_CTRL0: digital saradc configure register
func (o *APB_SARADC_Type) SetFILTER_CTRL0_APB_SARADC_FILTER_CHANNEL1(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL0.Reg, volatile.LoadUint32(&o.FILTER_CTRL0.Reg)&^(0x3c0000)|value<<18)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL0_APB_SARADC_FILTER_CHANNEL1() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL0.Reg) & 0x3c0000) >> 18
}
func (o *APB_SARADC_Type) SetFILTER_CTRL0_APB_SARADC_FILTER_CHANNEL0(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL0.Reg, volatile.LoadUint32(&o.FILTER_CTRL0.Reg)&^(0x3c00000)|value<<22)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL0_APB_SARADC_FILTER_CHANNEL0() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL0.Reg) & 0x3c00000) >> 22
}
func (o *APB_SARADC_Type) SetFILTER_CTRL0_APB_SARADC_FILTER_RESET(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL0.Reg, volatile.LoadUint32(&o.FILTER_CTRL0.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL0_APB_SARADC_FILTER_RESET() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL0.Reg) & 0x80000000) >> 31
}

// APB_SARADC.SAR1DATA_STATUS: digital saradc configure register
func (o *APB_SARADC_Type) SetSAR1DATA_STATUS_APB_SARADC1_DATA(value uint32) {
	volatile.StoreUint32(&o.SAR1DATA_STATUS.Reg, volatile.LoadUint32(&o.SAR1DATA_STATUS.Reg)&^(0x1ffff)|value)
}
func (o *APB_SARADC_Type) GetSAR1DATA_STATUS_APB_SARADC1_DATA() uint32 {
	return volatile.LoadUint32(&o.SAR1DATA_STATUS.Reg) & 0x1ffff
}

// APB_SARADC.SAR2DATA_STATUS: digital saradc configure register
func (o *APB_SARADC_Type) SetSAR2DATA_STATUS_APB_SARADC2_DATA(value uint32) {
	volatile.StoreUint32(&o.SAR2DATA_STATUS.Reg, volatile.LoadUint32(&o.SAR2DATA_STATUS.Reg)&^(0x1ffff)|value)
}
func (o *APB_SARADC_Type) GetSAR2DATA_STATUS_APB_SARADC2_DATA() uint32 {
	return volatile.LoadUint32(&o.SAR2DATA_STATUS.Reg) & 0x1ffff
}

// APB_SARADC.THRES0_CTRL: digital saradc configure register
func (o *APB_SARADC_Type) SetTHRES0_CTRL_APB_SARADC_THRES0_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.THRES0_CTRL.Reg, volatile.LoadUint32(&o.THRES0_CTRL.Reg)&^(0xf)|value)
}
func (o *APB_SARADC_Type) GetTHRES0_CTRL_APB_SARADC_THRES0_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.THRES0_CTRL.Reg) & 0xf
}
func (o *APB_SARADC_Type) SetTHRES0_CTRL_APB_SARADC_THRES0_HIGH(value uint32) {
	volatile.StoreUint32(&o.THRES0_CTRL.Reg, volatile.LoadUint32(&o.THRES0_CTRL.Reg)&^(0x3ffe0)|value<<5)
}
func (o *APB_SARADC_Type) GetTHRES0_CTRL_APB_SARADC_THRES0_HIGH() uint32 {
	return (volatile.LoadUint32(&o.THRES0_CTRL.Reg) & 0x3ffe0) >> 5
}
func (o *APB_SARADC_Type) SetTHRES0_CTRL_APB_SARADC_THRES0_LOW(value uint32) {
	volatile.StoreUint32(&o.THRES0_CTRL.Reg, volatile.LoadUint32(&o.THRES0_CTRL.Reg)&^(0x7ffc0000)|value<<18)
}
func (o *APB_SARADC_Type) GetTHRES0_CTRL_APB_SARADC_THRES0_LOW() uint32 {
	return (volatile.LoadUint32(&o.THRES0_CTRL.Reg) & 0x7ffc0000) >> 18
}

// APB_SARADC.THRES1_CTRL: digital saradc configure register
func (o *APB_SARADC_Type) SetTHRES1_CTRL_APB_SARADC_THRES1_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.THRES1_CTRL.Reg, volatile.LoadUint32(&o.THRES1_CTRL.Reg)&^(0xf)|value)
}
func (o *APB_SARADC_Type) GetTHRES1_CTRL_APB_SARADC_THRES1_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.THRES1_CTRL.Reg) & 0xf
}
func (o *APB_SARADC_Type) SetTHRES1_CTRL_APB_SARADC_THRES1_HIGH(value uint32) {
	volatile.StoreUint32(&o.THRES1_CTRL.Reg, volatile.LoadUint32(&o.THRES1_CTRL.Reg)&^(0x3ffe0)|value<<5)
}
func (o *APB_SARADC_Type) GetTHRES1_CTRL_APB_SARADC_THRES1_HIGH() uint32 {
	return (volatile.LoadUint32(&o.THRES1_CTRL.Reg) & 0x3ffe0) >> 5
}
func (o *APB_SARADC_Type) SetTHRES1_CTRL_APB_SARADC_THRES1_LOW(value uint32) {
	volatile.StoreUint32(&o.THRES1_CTRL.Reg, volatile.LoadUint32(&o.THRES1_CTRL.Reg)&^(0x7ffc0000)|value<<18)
}
func (o *APB_SARADC_Type) GetTHRES1_CTRL_APB_SARADC_THRES1_LOW() uint32 {
	return (volatile.LoadUint32(&o.THRES1_CTRL.Reg) & 0x7ffc0000) >> 18
}

// APB_SARADC.THRES_CTRL: digital saradc configure register
func (o *APB_SARADC_Type) SetTHRES_CTRL_APB_SARADC_THRES_ALL_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_APB_SARADC_THRES_ALL_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetTHRES_CTRL_APB_SARADC_THRES1_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_APB_SARADC_THRES1_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetTHRES_CTRL_APB_SARADC_THRES0_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_APB_SARADC_THRES0_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_ENA: digital saradc int register
func (o *APB_SARADC_Type) SetINT_ENA_APB_SARADC_THRES1_LOW_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_SARADC_Type) GetINT_ENA_APB_SARADC_THRES1_LOW_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4000000) >> 26
}
func (o *APB_SARADC_Type) SetINT_ENA_APB_SARADC_THRES0_LOW_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetINT_ENA_APB_SARADC_THRES0_LOW_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetINT_ENA_APB_SARADC_THRES1_HIGH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_ENA_APB_SARADC_THRES1_HIGH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_ENA_APB_SARADC_THRES0_HIGH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_ENA_APB_SARADC_THRES0_HIGH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_ENA_APB_SARADC2_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_ENA_APB_SARADC2_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_ENA_APB_SARADC1_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_ENA_APB_SARADC1_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_RAW: digital saradc int register
func (o *APB_SARADC_Type) SetINT_RAW_APB_SARADC_THRES1_LOW_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_SARADC_Type) GetINT_RAW_APB_SARADC_THRES1_LOW_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4000000) >> 26
}
func (o *APB_SARADC_Type) SetINT_RAW_APB_SARADC_THRES0_LOW_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetINT_RAW_APB_SARADC_THRES0_LOW_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetINT_RAW_APB_SARADC_THRES1_HIGH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_RAW_APB_SARADC_THRES1_HIGH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_RAW_APB_SARADC_THRES0_HIGH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_RAW_APB_SARADC_THRES0_HIGH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_RAW_APB_SARADC2_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_RAW_APB_SARADC2_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_RAW_APB_SARADC1_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_RAW_APB_SARADC1_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_ST: digital saradc int register
func (o *APB_SARADC_Type) SetINT_ST_APB_SARADC_THRES1_LOW_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_SARADC_Type) GetINT_ST_APB_SARADC_THRES1_LOW_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4000000) >> 26
}
func (o *APB_SARADC_Type) SetINT_ST_APB_SARADC_THRES0_LOW_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetINT_ST_APB_SARADC_THRES0_LOW_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetINT_ST_APB_SARADC_THRES1_HIGH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_ST_APB_SARADC_THRES1_HIGH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_ST_APB_SARADC_THRES0_HIGH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_ST_APB_SARADC_THRES0_HIGH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_ST_APB_SARADC2_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_ST_APB_SARADC2_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_ST_APB_SARADC1_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_ST_APB_SARADC1_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_CLR: digital saradc int register
func (o *APB_SARADC_Type) SetINT_CLR_APB_SARADC_THRES1_LOW_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_SARADC_Type) GetINT_CLR_APB_SARADC_THRES1_LOW_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4000000) >> 26
}
func (o *APB_SARADC_Type) SetINT_CLR_APB_SARADC_THRES0_LOW_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetINT_CLR_APB_SARADC_THRES0_LOW_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetINT_CLR_APB_SARADC_THRES1_HIGH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_CLR_APB_SARADC_THRES1_HIGH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_CLR_APB_SARADC_THRES0_HIGH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_CLR_APB_SARADC_THRES0_HIGH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_CLR_APB_SARADC2_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_CLR_APB_SARADC2_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_CLR_APB_SARADC1_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_CLR_APB_SARADC1_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80000000) >> 31
}

// APB_SARADC.DMA_CONF: digital saradc configure register
func (o *APB_SARADC_Type) SetDMA_CONF_APB_ADC_EOF_NUM(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0xffff)|value)
}
func (o *APB_SARADC_Type) GetDMA_CONF_APB_ADC_EOF_NUM() uint32 {
	return volatile.LoadUint32(&o.DMA_CONF.Reg) & 0xffff
}
func (o *APB_SARADC_Type) SetDMA_CONF_APB_ADC_RESET_FSM(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetDMA_CONF_APB_ADC_RESET_FSM() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetDMA_CONF_APB_ADC_TRANS(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetDMA_CONF_APB_ADC_TRANS() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x80000000) >> 31
}

// APB_SARADC.CLKM_CONF: digital saradc configure register
func (o *APB_SARADC_Type) SetCLKM_CONF_CLKM_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0xff)|value)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLKM_DIV_NUM() uint32 {
	return volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0xff
}
func (o *APB_SARADC_Type) SetCLKM_CONF_CLKM_DIV_B(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0x3f00)|value<<8)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLKM_DIV_B() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0x3f00) >> 8
}
func (o *APB_SARADC_Type) SetCLKM_CONF_CLKM_DIV_A(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0xfc000)|value<<14)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLKM_DIV_A() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0xfc000) >> 14
}
func (o *APB_SARADC_Type) SetCLKM_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0x100000) >> 20
}
func (o *APB_SARADC_Type) SetCLKM_CONF_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0x600000)|value<<21)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0x600000) >> 21
}

// APB_SARADC.APB_TSENS_CTRL: digital tsens configure register
func (o *APB_SARADC_Type) SetAPB_TSENS_CTRL_TSENS_OUT(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_CTRL.Reg, volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg)&^(0xff)|value)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_CTRL_TSENS_OUT() uint32 {
	return volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg) & 0xff
}
func (o *APB_SARADC_Type) SetAPB_TSENS_CTRL_TSENS_IN_INV(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_CTRL.Reg, volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_CTRL_TSENS_IN_INV() uint32 {
	return (volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg) & 0x2000) >> 13
}
func (o *APB_SARADC_Type) SetAPB_TSENS_CTRL_TSENS_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_CTRL.Reg, volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg)&^(0x3fc000)|value<<14)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_CTRL_TSENS_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg) & 0x3fc000) >> 14
}
func (o *APB_SARADC_Type) SetAPB_TSENS_CTRL_TSENS_PU(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_CTRL.Reg, volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_CTRL_TSENS_PU() uint32 {
	return (volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg) & 0x400000) >> 22
}

// APB_SARADC.TSENS_CTRL2: digital tsens configure register
func (o *APB_SARADC_Type) SetTSENS_CTRL2_TSENS_XPD_WAIT(value uint32) {
	volatile.StoreUint32(&o.TSENS_CTRL2.Reg, volatile.LoadUint32(&o.TSENS_CTRL2.Reg)&^(0xfff)|value)
}
func (o *APB_SARADC_Type) GetTSENS_CTRL2_TSENS_XPD_WAIT() uint32 {
	return volatile.LoadUint32(&o.TSENS_CTRL2.Reg) & 0xfff
}
func (o *APB_SARADC_Type) SetTSENS_CTRL2_TSENS_XPD_FORCE(value uint32) {
	volatile.StoreUint32(&o.TSENS_CTRL2.Reg, volatile.LoadUint32(&o.TSENS_CTRL2.Reg)&^(0x3000)|value<<12)
}
func (o *APB_SARADC_Type) GetTSENS_CTRL2_TSENS_XPD_FORCE() uint32 {
	return (volatile.LoadUint32(&o.TSENS_CTRL2.Reg) & 0x3000) >> 12
}
func (o *APB_SARADC_Type) SetTSENS_CTRL2_TSENS_CLK_INV(value uint32) {
	volatile.StoreUint32(&o.TSENS_CTRL2.Reg, volatile.LoadUint32(&o.TSENS_CTRL2.Reg)&^(0x4000)|value<<14)
}
func (o *APB_SARADC_Type) GetTSENS_CTRL2_TSENS_CLK_INV() uint32 {
	return (volatile.LoadUint32(&o.TSENS_CTRL2.Reg) & 0x4000) >> 14
}
func (o *APB_SARADC_Type) SetTSENS_CTRL2_TSENS_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.TSENS_CTRL2.Reg, volatile.LoadUint32(&o.TSENS_CTRL2.Reg)&^(0x8000)|value<<15)
}
func (o *APB_SARADC_Type) GetTSENS_CTRL2_TSENS_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.TSENS_CTRL2.Reg) & 0x8000) >> 15
}

// APB_SARADC.CALI: digital saradc configure register
func (o *APB_SARADC_Type) SetCALI_APB_SARADC_CALI_CFG(value uint32) {
	volatile.StoreUint32(&o.CALI.Reg, volatile.LoadUint32(&o.CALI.Reg)&^(0x1ffff)|value)
}
func (o *APB_SARADC_Type) GetCALI_APB_SARADC_CALI_CFG() uint32 {
	return volatile.LoadUint32(&o.CALI.Reg) & 0x1ffff
}

// APB_SARADC.CTRL_DATE: version
func (o *APB_SARADC_Type) SetCTRL_DATE(value uint32) {
	volatile.StoreUint32(&o.CTRL_DATE.Reg, value)
}
func (o *APB_SARADC_Type) GetCTRL_DATE() uint32 {
	return volatile.LoadUint32(&o.CTRL_DATE.Reg)
}

// Peripheral ASSIST_DEBUG
type ASSIST_DEBUG_Type struct {
	C0RE_0_MONTR_ENA                       volatile.Register32 // 0x0
	CORE_0_INTR_RAW                        volatile.Register32 // 0x4
	CORE_0_INTR_ENA                        volatile.Register32 // 0x8
	CORE_0_INTR_CLR                        volatile.Register32 // 0xC
	CORE_0_AREA_DRAM0_0_MIN                volatile.Register32 // 0x10
	CORE_0_AREA_DRAM0_0_MAX                volatile.Register32 // 0x14
	CORE_0_AREA_DRAM0_1_MIN                volatile.Register32 // 0x18
	CORE_0_AREA_DRAM0_1_MAX                volatile.Register32 // 0x1C
	CORE_0_AREA_PIF_0_MIN                  volatile.Register32 // 0x20
	CORE_0_AREA_PIF_0_MAX                  volatile.Register32 // 0x24
	CORE_0_AREA_PIF_1_MIN                  volatile.Register32 // 0x28
	CORE_0_AREA_PIF_1_MAX                  volatile.Register32 // 0x2C
	CORE_0_AREA_PC                         volatile.Register32 // 0x30
	CORE_0_AREA_SP                         volatile.Register32 // 0x34
	CORE_0_SP_MIN                          volatile.Register32 // 0x38
	CORE_0_SP_MAX                          volatile.Register32 // 0x3C
	CORE_0_SP_PC                           volatile.Register32 // 0x40
	CORE_0_RCD_EN                          volatile.Register32 // 0x44
	CORE_0_RCD_PDEBUGPC                    volatile.Register32 // 0x48
	CORE_0_RCD_PDEBUGSP                    volatile.Register32 // 0x4C
	CORE_0_IRAM0_EXCEPTION_MONITOR_0       volatile.Register32 // 0x50
	CORE_0_IRAM0_EXCEPTION_MONITOR_1       volatile.Register32 // 0x54
	CORE_0_DRAM0_EXCEPTION_MONITOR_0       volatile.Register32 // 0x58
	CORE_0_DRAM0_EXCEPTION_MONITOR_1       volatile.Register32 // 0x5C
	CORE_0_DRAM0_EXCEPTION_MONITOR_2       volatile.Register32 // 0x60
	CORE_0_DRAM0_EXCEPTION_MONITOR_3       volatile.Register32 // 0x64
	CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0 volatile.Register32 // 0x68
	CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1 volatile.Register32 // 0x6C
	LOG_SETTING                            volatile.Register32 // 0x70
	LOG_DATA_0                             volatile.Register32 // 0x74
	LOG_DATA_MASK                          volatile.Register32 // 0x78
	LOG_MIN                                volatile.Register32 // 0x7C
	LOG_MAX                                volatile.Register32 // 0x80
	LOG_MEM_START                          volatile.Register32 // 0x84
	LOG_MEM_END                            volatile.Register32 // 0x88
	LOG_MEM_WRITING_ADDR                   volatile.Register32 // 0x8C
	LOG_MEM_FULL_FLAG                      volatile.Register32 // 0x90
	C0RE_0_LASTPC_BEFORE_EXCEPTION         volatile.Register32 // 0x94
	C0RE_0_DEBUG_MODE                      volatile.Register32 // 0x98
	_                                      [352]byte
	DATE                                   volatile.Register32 // 0x1FC
}

// ASSIST_DEBUG.C0RE_0_MONTR_ENA: ASSIST_DEBUG_C0RE_0_MONTR_ENA_REG
func (o *ASSIST_DEBUG_Type) SetC0RE_0_MONTR_ENA_CORE_0_AREA_DRAM0_0_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.C0RE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetC0RE_0_MONTR_ENA_CORE_0_AREA_DRAM0_0_RD_ENA() uint32 {
	return volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetC0RE_0_MONTR_ENA_CORE_0_AREA_DRAM0_0_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.C0RE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetC0RE_0_MONTR_ENA_CORE_0_AREA_DRAM0_0_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg) & 0x2) >> 1
}
func (o *ASSIST_DEBUG_Type) SetC0RE_0_MONTR_ENA_CORE_0_AREA_DRAM0_1_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.C0RE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg)&^(0x4)|value<<2)
}
func (o *ASSIST_DEBUG_Type) GetC0RE_0_MONTR_ENA_CORE_0_AREA_DRAM0_1_RD_ENA() uint32 {
	return (volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg) & 0x4) >> 2
}
func (o *ASSIST_DEBUG_Type) SetC0RE_0_MONTR_ENA_CORE_0_AREA_DRAM0_1_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.C0RE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg)&^(0x8)|value<<3)
}
func (o *ASSIST_DEBUG_Type) GetC0RE_0_MONTR_ENA_CORE_0_AREA_DRAM0_1_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg) & 0x8) >> 3
}
func (o *ASSIST_DEBUG_Type) SetC0RE_0_MONTR_ENA_CORE_0_AREA_PIF_0_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.C0RE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg)&^(0x10)|value<<4)
}
func (o *ASSIST_DEBUG_Type) GetC0RE_0_MONTR_ENA_CORE_0_AREA_PIF_0_RD_ENA() uint32 {
	return (volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg) & 0x10) >> 4
}
func (o *ASSIST_DEBUG_Type) SetC0RE_0_MONTR_ENA_CORE_0_AREA_PIF_0_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.C0RE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg)&^(0x20)|value<<5)
}
func (o *ASSIST_DEBUG_Type) GetC0RE_0_MONTR_ENA_CORE_0_AREA_PIF_0_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg) & 0x20) >> 5
}
func (o *ASSIST_DEBUG_Type) SetC0RE_0_MONTR_ENA_CORE_0_AREA_PIF_1_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.C0RE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg)&^(0x40)|value<<6)
}
func (o *ASSIST_DEBUG_Type) GetC0RE_0_MONTR_ENA_CORE_0_AREA_PIF_1_RD_ENA() uint32 {
	return (volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg) & 0x40) >> 6
}
func (o *ASSIST_DEBUG_Type) SetC0RE_0_MONTR_ENA_CORE_0_AREA_PIF_1_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.C0RE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg)&^(0x80)|value<<7)
}
func (o *ASSIST_DEBUG_Type) GetC0RE_0_MONTR_ENA_CORE_0_AREA_PIF_1_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg) & 0x80) >> 7
}
func (o *ASSIST_DEBUG_Type) SetC0RE_0_MONTR_ENA_CORE_0_SP_SPILL_MIN_ENA(value uint32) {
	volatile.StoreUint32(&o.C0RE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg)&^(0x100)|value<<8)
}
func (o *ASSIST_DEBUG_Type) GetC0RE_0_MONTR_ENA_CORE_0_SP_SPILL_MIN_ENA() uint32 {
	return (volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg) & 0x100) >> 8
}
func (o *ASSIST_DEBUG_Type) SetC0RE_0_MONTR_ENA_CORE_0_SP_SPILL_MAX_ENA(value uint32) {
	volatile.StoreUint32(&o.C0RE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg)&^(0x200)|value<<9)
}
func (o *ASSIST_DEBUG_Type) GetC0RE_0_MONTR_ENA_CORE_0_SP_SPILL_MAX_ENA() uint32 {
	return (volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg) & 0x200) >> 9
}
func (o *ASSIST_DEBUG_Type) SetC0RE_0_MONTR_ENA_CORE_0_IRAM0_EXCEPTION_MONITOR_ENA(value uint32) {
	volatile.StoreUint32(&o.C0RE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg)&^(0x400)|value<<10)
}
func (o *ASSIST_DEBUG_Type) GetC0RE_0_MONTR_ENA_CORE_0_IRAM0_EXCEPTION_MONITOR_ENA() uint32 {
	return (volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg) & 0x400) >> 10
}
func (o *ASSIST_DEBUG_Type) SetC0RE_0_MONTR_ENA_CORE_0_DRAM0_EXCEPTION_MONITOR_ENA(value uint32) {
	volatile.StoreUint32(&o.C0RE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg)&^(0x800)|value<<11)
}
func (o *ASSIST_DEBUG_Type) GetC0RE_0_MONTR_ENA_CORE_0_DRAM0_EXCEPTION_MONITOR_ENA() uint32 {
	return (volatile.LoadUint32(&o.C0RE_0_MONTR_ENA.Reg) & 0x800) >> 11
}

// ASSIST_DEBUG.CORE_0_INTR_RAW: ASSIST_DEBUG_CORE_0_INTR_RAW_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_0_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_0_RD_RAW() uint32 {
	return volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_0_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_0_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x2) >> 1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_1_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x4)|value<<2)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_1_RD_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x4) >> 2
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_1_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x8)|value<<3)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_1_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x8) >> 3
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_PIF_0_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x10)|value<<4)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_PIF_0_RD_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x10) >> 4
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_PIF_0_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x20)|value<<5)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_PIF_0_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x20) >> 5
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_PIF_1_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x40)|value<<6)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_PIF_1_RD_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x40) >> 6
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_PIF_1_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x80)|value<<7)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_PIF_1_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x80) >> 7
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MIN_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x100)|value<<8)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MIN_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x100) >> 8
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MAX_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x200)|value<<9)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MAX_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x200) >> 9
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_IRAM0_EXCEPTION_MONITOR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x400)|value<<10)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_IRAM0_EXCEPTION_MONITOR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x400) >> 10
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_DRAM0_EXCEPTION_MONITOR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x800)|value<<11)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_DRAM0_EXCEPTION_MONITOR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x800) >> 11
}

// ASSIST_DEBUG.CORE_0_INTR_ENA: ASSIST_DEBUG_CORE_0_INTR_ENA_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_0_RD_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_0_RD_INTR_ENA() uint32 {
	return volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_0_WR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_0_WR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x2) >> 1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_1_RD_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x4)|value<<2)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_1_RD_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x4) >> 2
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_1_WR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x8)|value<<3)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_1_WR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x8) >> 3
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_PIF_0_RD_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x10)|value<<4)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_PIF_0_RD_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x10) >> 4
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_PIF_0_WR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x20)|value<<5)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_PIF_0_WR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x20) >> 5
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_PIF_1_RD_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x40)|value<<6)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_PIF_1_RD_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x40) >> 6
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_PIF_1_WR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x80)|value<<7)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_PIF_1_WR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x80) >> 7
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MIN_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x100)|value<<8)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MIN_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x100) >> 8
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MAX_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x200)|value<<9)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MAX_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x200) >> 9
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_IRAM0_EXCEPTION_MONITOR_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x400)|value<<10)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_IRAM0_EXCEPTION_MONITOR_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x400) >> 10
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_DRAM0_EXCEPTION_MONITOR_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x800)|value<<11)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_DRAM0_EXCEPTION_MONITOR_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x800) >> 11
}

// ASSIST_DEBUG.CORE_0_INTR_CLR: ASSIST_DEBUG_CORE_0_INTR_CLR_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_0_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_0_RD_CLR() uint32 {
	return volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_0_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_0_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x2) >> 1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_1_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x4)|value<<2)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_1_RD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x4) >> 2
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_1_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x8)|value<<3)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_1_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x8) >> 3
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_PIF_0_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x10)|value<<4)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_PIF_0_RD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x10) >> 4
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_PIF_0_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x20)|value<<5)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_PIF_0_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x20) >> 5
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_PIF_1_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x40)|value<<6)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_PIF_1_RD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x40) >> 6
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_PIF_1_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x80)|value<<7)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_PIF_1_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x80) >> 7
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MIN_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x100)|value<<8)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MIN_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x100) >> 8
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MAX_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x200)|value<<9)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MAX_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x200) >> 9
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_IRAM0_EXCEPTION_MONITOR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x400)|value<<10)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_IRAM0_EXCEPTION_MONITOR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x400) >> 10
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_DRAM0_EXCEPTION_MONITOR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x800)|value<<11)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_DRAM0_EXCEPTION_MONITOR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x800) >> 11
}

// ASSIST_DEBUG.CORE_0_AREA_DRAM0_0_MIN: ASSIST_DEBUG_CORE_0_AREA_DRAM0_0_MIN_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_DRAM0_0_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_DRAM0_0_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_DRAM0_0_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_DRAM0_0_MIN.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_DRAM0_0_MAX: ASSIST_DEBUG_CORE_0_AREA_DRAM0_0_MAX_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_DRAM0_0_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_DRAM0_0_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_DRAM0_0_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_DRAM0_0_MAX.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_DRAM0_1_MIN: ASSIST_DEBUG_CORE_0_AREA_DRAM0_1_MIN_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_DRAM0_1_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_DRAM0_1_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_DRAM0_1_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_DRAM0_1_MIN.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_DRAM0_1_MAX: ASSIST_DEBUG_CORE_0_AREA_DRAM0_1_MAX_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_DRAM0_1_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_DRAM0_1_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_DRAM0_1_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_DRAM0_1_MAX.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_PIF_0_MIN: ASSIST_DEBUG_CORE_0_AREA_PIF_0_MIN_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_PIF_0_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PIF_0_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_PIF_0_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PIF_0_MIN.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_PIF_0_MAX: ASSIST_DEBUG_CORE_0_AREA_PIF_0_MAX_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_PIF_0_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PIF_0_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_PIF_0_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PIF_0_MAX.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_PIF_1_MIN: ASSIST_DEBUG_CORE_0_AREA_PIF_1_MIN_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_PIF_1_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PIF_1_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_PIF_1_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PIF_1_MIN.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_PIF_1_MAX: ASSIST_DEBUG_CORE_0_AREA_PIF_1_MAX_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_PIF_1_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PIF_1_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_PIF_1_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PIF_1_MAX.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_PC: ASSIST_DEBUG_CORE_0_AREA_PC_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_PC(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PC.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_PC() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PC.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_SP: ASSIST_DEBUG_CORE_0_AREA_SP_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_SP(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_SP.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_SP() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_SP.Reg)
}

// ASSIST_DEBUG.CORE_0_SP_MIN: ASSIST_DEBUG_CORE_0_SP_MIN_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_SP_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_SP_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_SP_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_SP_MIN.Reg)
}

// ASSIST_DEBUG.CORE_0_SP_MAX: ASSIST_DEBUG_CORE_0_SP_MAX_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_SP_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_SP_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_SP_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_SP_MAX.Reg)
}

// ASSIST_DEBUG.CORE_0_SP_PC: ASSIST_DEBUG_CORE_0_SP_PC_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_SP_PC(value uint32) {
	volatile.StoreUint32(&o.CORE_0_SP_PC.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_SP_PC() uint32 {
	return volatile.LoadUint32(&o.CORE_0_SP_PC.Reg)
}

// ASSIST_DEBUG.CORE_0_RCD_EN: ASSIST_DEBUG_CORE_0_RCD_EN_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_RCD_EN_CORE_0_RCD_RECORDEN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_EN.Reg, volatile.LoadUint32(&o.CORE_0_RCD_EN.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_RCD_EN_CORE_0_RCD_RECORDEN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_EN.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_RCD_EN_CORE_0_RCD_PDEBUGEN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_EN.Reg, volatile.LoadUint32(&o.CORE_0_RCD_EN.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_RCD_EN_CORE_0_RCD_PDEBUGEN() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_RCD_EN.Reg) & 0x2) >> 1
}

// ASSIST_DEBUG.CORE_0_RCD_PDEBUGPC: ASSIST_DEBUG_CORE_0_RCD_PDEBUGPC_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_RCD_PDEBUGPC(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_PDEBUGPC.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_RCD_PDEBUGPC() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_PDEBUGPC.Reg)
}

// ASSIST_DEBUG.CORE_0_RCD_PDEBUGSP: ASSIST_DEBUG_CORE_0_RCD_PDEBUGSP_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_RCD_PDEBUGSP(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_PDEBUGSP.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_RCD_PDEBUGSP() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_PDEBUGSP.Reg)
}

// ASSIST_DEBUG.CORE_0_IRAM0_EXCEPTION_MONITOR_0: ASSIST_DEBUG_CORE_0_RCD_PDEBUGSP_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_ADDR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg)&^(0xffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_ADDR_0() uint32 {
	return volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg) & 0xffffff
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_WR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x1000000)|value<<24)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_WR_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg) & 0x1000000) >> 24
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_LOADSTORE_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x2000000)|value<<25)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_LOADSTORE_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg) & 0x2000000) >> 25
}

// ASSIST_DEBUG.CORE_0_IRAM0_EXCEPTION_MONITOR_1: ASSIST_DEBUG_CORE_0_IRAM0_EXCEPTION_MONITOR_1_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_ADDR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg)&^(0xffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_ADDR_1() uint32 {
	return volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg) & 0xffffff
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_WR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg)&^(0x1000000)|value<<24)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_WR_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg) & 0x1000000) >> 24
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_LOADSTORE_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg)&^(0x2000000)|value<<25)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_LOADSTORE_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg) & 0x2000000) >> 25
}

// ASSIST_DEBUG.CORE_0_DRAM0_EXCEPTION_MONITOR_0: ASSIST_DEBUG_CORE_0_DRAM0_EXCEPTION_MONITOR_0_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_ADDR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg)&^(0xffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_ADDR_0() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg) & 0xffffff
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_WR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x1000000)|value<<24)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_WR_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg) & 0x1000000) >> 24
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_BYTEEN_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x1e000000)|value<<25)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_BYTEEN_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg) & 0x1e000000) >> 25
}

// ASSIST_DEBUG.CORE_0_DRAM0_EXCEPTION_MONITOR_1: ASSIST_DEBUG_CORE_0_DRAM0_EXCEPTION_MONITOR_1_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_1.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_1() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_1.Reg)
}

// ASSIST_DEBUG.CORE_0_DRAM0_EXCEPTION_MONITOR_2: ASSIST_DEBUG_CORE_0_DRAM0_EXCEPTION_MONITOR_1_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_2_CORE_0_DRAM0_RECORDING_ADDR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg)&^(0xffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_2_CORE_0_DRAM0_RECORDING_ADDR_1() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg) & 0xffffff
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_2_CORE_0_DRAM0_RECORDING_WR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg)&^(0x1000000)|value<<24)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_2_CORE_0_DRAM0_RECORDING_WR_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg) & 0x1000000) >> 24
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_2_CORE_0_DRAM0_RECORDING_BYTEEN_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg)&^(0x1e000000)|value<<25)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_2_CORE_0_DRAM0_RECORDING_BYTEEN_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg) & 0x1e000000) >> 25
}

// ASSIST_DEBUG.CORE_0_DRAM0_EXCEPTION_MONITOR_3: ASSIST_DEBUG_CORE_0_DRAM0_EXCEPTION_MONITOR_3_REG
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_3(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_3.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_3() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_3.Reg)
}

// ASSIST_DEBUG.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0: ASSIST_DEBUG_CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0_REG
func (o *ASSIST_DEBUG_Type) SetCORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0_CORE_X_IRAM0_DRAM0_LIMIT_CYCLE_0(value uint32) {
	volatile.StoreUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0.Reg)&^(0xfffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0_CORE_X_IRAM0_DRAM0_LIMIT_CYCLE_0() uint32 {
	return volatile.LoadUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0.Reg) & 0xfffff
}

// ASSIST_DEBUG.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1: ASSIST_DEBUG_CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1_REG
func (o *ASSIST_DEBUG_Type) SetCORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1_CORE_X_IRAM0_DRAM0_LIMIT_CYCLE_1(value uint32) {
	volatile.StoreUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1.Reg)&^(0xfffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1_CORE_X_IRAM0_DRAM0_LIMIT_CYCLE_1() uint32 {
	return volatile.LoadUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1.Reg) & 0xfffff
}

// ASSIST_DEBUG.LOG_SETTING: ASSIST_DEBUG_LOG_SETTING
func (o *ASSIST_DEBUG_Type) SetLOG_SETTING_LOG_ENA(value uint32) {
	volatile.StoreUint32(&o.LOG_SETTING.Reg, volatile.LoadUint32(&o.LOG_SETTING.Reg)&^(0x7)|value)
}
func (o *ASSIST_DEBUG_Type) GetLOG_SETTING_LOG_ENA() uint32 {
	return volatile.LoadUint32(&o.LOG_SETTING.Reg) & 0x7
}
func (o *ASSIST_DEBUG_Type) SetLOG_SETTING_LOG_MODE(value uint32) {
	volatile.StoreUint32(&o.LOG_SETTING.Reg, volatile.LoadUint32(&o.LOG_SETTING.Reg)&^(0x78)|value<<3)
}
func (o *ASSIST_DEBUG_Type) GetLOG_SETTING_LOG_MODE() uint32 {
	return (volatile.LoadUint32(&o.LOG_SETTING.Reg) & 0x78) >> 3
}
func (o *ASSIST_DEBUG_Type) SetLOG_SETTING_LOG_MEM_LOOP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.LOG_SETTING.Reg, volatile.LoadUint32(&o.LOG_SETTING.Reg)&^(0x80)|value<<7)
}
func (o *ASSIST_DEBUG_Type) GetLOG_SETTING_LOG_MEM_LOOP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.LOG_SETTING.Reg) & 0x80) >> 7
}

// ASSIST_DEBUG.LOG_DATA_0: ASSIST_DEBUG_LOG_DATA_0_REG
func (o *ASSIST_DEBUG_Type) SetLOG_DATA_0(value uint32) {
	volatile.StoreUint32(&o.LOG_DATA_0.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetLOG_DATA_0() uint32 {
	return volatile.LoadUint32(&o.LOG_DATA_0.Reg)
}

// ASSIST_DEBUG.LOG_DATA_MASK: ASSIST_DEBUG_LOG_DATA_MASK_REG
func (o *ASSIST_DEBUG_Type) SetLOG_DATA_MASK_LOG_DATA_SIZE(value uint32) {
	volatile.StoreUint32(&o.LOG_DATA_MASK.Reg, volatile.LoadUint32(&o.LOG_DATA_MASK.Reg)&^(0xffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetLOG_DATA_MASK_LOG_DATA_SIZE() uint32 {
	return volatile.LoadUint32(&o.LOG_DATA_MASK.Reg) & 0xffff
}

// ASSIST_DEBUG.LOG_MIN: ASSIST_DEBUG_LOG_MIN_REG
func (o *ASSIST_DEBUG_Type) SetLOG_MIN(value uint32) {
	volatile.StoreUint32(&o.LOG_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetLOG_MIN() uint32 {
	return volatile.LoadUint32(&o.LOG_MIN.Reg)
}

// ASSIST_DEBUG.LOG_MAX: ASSIST_DEBUG_LOG_MAX_REG
func (o *ASSIST_DEBUG_Type) SetLOG_MAX(value uint32) {
	volatile.StoreUint32(&o.LOG_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetLOG_MAX() uint32 {
	return volatile.LoadUint32(&o.LOG_MAX.Reg)
}

// ASSIST_DEBUG.LOG_MEM_START: ASSIST_DEBUG_LOG_MEM_START_REG
func (o *ASSIST_DEBUG_Type) SetLOG_MEM_START(value uint32) {
	volatile.StoreUint32(&o.LOG_MEM_START.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetLOG_MEM_START() uint32 {
	return volatile.LoadUint32(&o.LOG_MEM_START.Reg)
}

// ASSIST_DEBUG.LOG_MEM_END: ASSIST_DEBUG_LOG_MEM_END_REG
func (o *ASSIST_DEBUG_Type) SetLOG_MEM_END(value uint32) {
	volatile.StoreUint32(&o.LOG_MEM_END.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetLOG_MEM_END() uint32 {
	return volatile.LoadUint32(&o.LOG_MEM_END.Reg)
}

// ASSIST_DEBUG.LOG_MEM_WRITING_ADDR: ASSIST_DEBUG_LOG_MEM_WRITING_ADDR_REG
func (o *ASSIST_DEBUG_Type) SetLOG_MEM_WRITING_ADDR(value uint32) {
	volatile.StoreUint32(&o.LOG_MEM_WRITING_ADDR.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetLOG_MEM_WRITING_ADDR() uint32 {
	return volatile.LoadUint32(&o.LOG_MEM_WRITING_ADDR.Reg)
}

// ASSIST_DEBUG.LOG_MEM_FULL_FLAG: ASSIST_DEBUG_LOG_MEM_FULL_FLAG_REG
func (o *ASSIST_DEBUG_Type) SetLOG_MEM_FULL_FLAG(value uint32) {
	volatile.StoreUint32(&o.LOG_MEM_FULL_FLAG.Reg, volatile.LoadUint32(&o.LOG_MEM_FULL_FLAG.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetLOG_MEM_FULL_FLAG() uint32 {
	return volatile.LoadUint32(&o.LOG_MEM_FULL_FLAG.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetLOG_MEM_FULL_FLAG_CLR_LOG_MEM_FULL_FLAG(value uint32) {
	volatile.StoreUint32(&o.LOG_MEM_FULL_FLAG.Reg, volatile.LoadUint32(&o.LOG_MEM_FULL_FLAG.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetLOG_MEM_FULL_FLAG_CLR_LOG_MEM_FULL_FLAG() uint32 {
	return (volatile.LoadUint32(&o.LOG_MEM_FULL_FLAG.Reg) & 0x2) >> 1
}

// ASSIST_DEBUG.C0RE_0_LASTPC_BEFORE_EXCEPTION: ASSIST_DEBUG_C0RE_0_LASTPC_BEFORE_EXCEPTION
func (o *ASSIST_DEBUG_Type) SetC0RE_0_LASTPC_BEFORE_EXCEPTION(value uint32) {
	volatile.StoreUint32(&o.C0RE_0_LASTPC_BEFORE_EXCEPTION.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetC0RE_0_LASTPC_BEFORE_EXCEPTION() uint32 {
	return volatile.LoadUint32(&o.C0RE_0_LASTPC_BEFORE_EXCEPTION.Reg)
}

// ASSIST_DEBUG.C0RE_0_DEBUG_MODE: ASSIST_DEBUG_C0RE_0_DEBUG_MODE
func (o *ASSIST_DEBUG_Type) SetC0RE_0_DEBUG_MODE_CORE_0_DEBUG_MODE(value uint32) {
	volatile.StoreUint32(&o.C0RE_0_DEBUG_MODE.Reg, volatile.LoadUint32(&o.C0RE_0_DEBUG_MODE.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetC0RE_0_DEBUG_MODE_CORE_0_DEBUG_MODE() uint32 {
	return volatile.LoadUint32(&o.C0RE_0_DEBUG_MODE.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetC0RE_0_DEBUG_MODE_CORE_0_DEBUG_MODULE_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.C0RE_0_DEBUG_MODE.Reg, volatile.LoadUint32(&o.C0RE_0_DEBUG_MODE.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetC0RE_0_DEBUG_MODE_CORE_0_DEBUG_MODULE_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.C0RE_0_DEBUG_MODE.Reg) & 0x2) >> 1
}

// ASSIST_DEBUG.DATE: ASSIST_DEBUG_DATE_REG
func (o *ASSIST_DEBUG_Type) SetDATE_ASSIST_DEBUG_DATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetDATE_ASSIST_DEBUG_DATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// Peripheral DMA
type DMA_Type struct {
	INT_RAW_CH0              volatile.Register32 // 0x0
	INT_ST_CH0               volatile.Register32 // 0x4
	INT_ENA_CH0              volatile.Register32 // 0x8
	INT_CLR_CH0              volatile.Register32 // 0xC
	INT_RAW_CH1              volatile.Register32 // 0x10
	INT_ST_CH1               volatile.Register32 // 0x14
	INT_ENA_CH1              volatile.Register32 // 0x18
	INT_CLR_CH1              volatile.Register32 // 0x1C
	INT_RAW_CH2              volatile.Register32 // 0x20
	INT_ST_CH2               volatile.Register32 // 0x24
	INT_ENA_CH2              volatile.Register32 // 0x28
	INT_CLR_CH2              volatile.Register32 // 0x2C
	_                        [16]byte
	AHB_TEST                 volatile.Register32 // 0x40
	MISC_CONF                volatile.Register32 // 0x44
	DATE                     volatile.Register32 // 0x48
	_                        [36]byte
	IN_CONF0_CH0             volatile.Register32 // 0x70
	IN_CONF1_CH0             volatile.Register32 // 0x74
	INFIFO_STATUS_CH0        volatile.Register32 // 0x78
	IN_POP_CH0               volatile.Register32 // 0x7C
	IN_LINK_CH0              volatile.Register32 // 0x80
	IN_STATE_CH0             volatile.Register32 // 0x84
	IN_SUC_EOF_DES_ADDR_CH0  volatile.Register32 // 0x88
	IN_ERR_EOF_DES_ADDR_CH0  volatile.Register32 // 0x8C
	IN_DSCR_CH0              volatile.Register32 // 0x90
	IN_DSCR_BF0_CH0          volatile.Register32 // 0x94
	IN_DSCR_BF1_CH0          volatile.Register32 // 0x98
	IN_PRI_CH0               volatile.Register32 // 0x9C
	IN_PERI_SEL_CH0          volatile.Register32 // 0xA0
	_                        [44]byte
	OUT_CONF0_CH0            volatile.Register32 // 0xD0
	OUT_CONF1_CH0            volatile.Register32 // 0xD4
	OUTFIFO_STATUS_CH0       volatile.Register32 // 0xD8
	OUT_PUSH_CH0             volatile.Register32 // 0xDC
	OUT_LINK_CH0             volatile.Register32 // 0xE0
	OUT_STATE_CH0            volatile.Register32 // 0xE4
	OUT_EOF_DES_ADDR_CH0     volatile.Register32 // 0xE8
	OUT_EOF_BFR_DES_ADDR_CH0 volatile.Register32 // 0xEC
	OUT_DSCR_CH0             volatile.Register32 // 0xF0
	OUT_DSCR_BF0_CH0         volatile.Register32 // 0xF4
	OUT_DSCR_BF1_CH0         volatile.Register32 // 0xF8
	OUT_PRI_CH0              volatile.Register32 // 0xFC
	OUT_PERI_SEL_CH0         volatile.Register32 // 0x100
	_                        [44]byte
	IN_CONF0_CH1             volatile.Register32 // 0x130
	IN_CONF1_CH1             volatile.Register32 // 0x134
	INFIFO_STATUS_CH1        volatile.Register32 // 0x138
	IN_POP_CH1               volatile.Register32 // 0x13C
	IN_LINK_CH1              volatile.Register32 // 0x140
	IN_STATE_CH1             volatile.Register32 // 0x144
	IN_SUC_EOF_DES_ADDR_CH1  volatile.Register32 // 0x148
	IN_ERR_EOF_DES_ADDR_CH1  volatile.Register32 // 0x14C
	IN_DSCR_CH1              volatile.Register32 // 0x150
	IN_DSCR_BF0_CH1          volatile.Register32 // 0x154
	IN_DSCR_BF1_CH1          volatile.Register32 // 0x158
	IN_PRI_CH1               volatile.Register32 // 0x15C
	IN_PERI_SEL_CH1          volatile.Register32 // 0x160
	_                        [44]byte
	OUT_CONF0_CH1            volatile.Register32 // 0x190
	OUT_CONF1_CH1            volatile.Register32 // 0x194
	OUTFIFO_STATUS_CH1       volatile.Register32 // 0x198
	OUT_PUSH_CH1             volatile.Register32 // 0x19C
	OUT_LINK_CH1             volatile.Register32 // 0x1A0
	OUT_STATE_CH1            volatile.Register32 // 0x1A4
	OUT_EOF_DES_ADDR_CH1     volatile.Register32 // 0x1A8
	OUT_EOF_BFR_DES_ADDR_CH1 volatile.Register32 // 0x1AC
	OUT_DSCR_CH1             volatile.Register32 // 0x1B0
	OUT_DSCR_BF0_CH1         volatile.Register32 // 0x1B4
	OUT_DSCR_BF1_CH1         volatile.Register32 // 0x1B8
	OUT_PRI_CH1              volatile.Register32 // 0x1BC
	OUT_PERI_SEL_CH1         volatile.Register32 // 0x1C0
	_                        [44]byte
	IN_CONF0_CH2             volatile.Register32 // 0x1F0
	IN_CONF1_CH2             volatile.Register32 // 0x1F4
	INFIFO_STATUS_CH2        volatile.Register32 // 0x1F8
	IN_POP_CH2               volatile.Register32 // 0x1FC
	IN_LINK_CH2              volatile.Register32 // 0x200
	IN_STATE_CH2             volatile.Register32 // 0x204
	IN_SUC_EOF_DES_ADDR_CH2  volatile.Register32 // 0x208
	IN_ERR_EOF_DES_ADDR_CH2  volatile.Register32 // 0x20C
	IN_DSCR_CH2              volatile.Register32 // 0x210
	IN_DSCR_BF0_CH2          volatile.Register32 // 0x214
	IN_DSCR_BF1_CH2          volatile.Register32 // 0x218
	IN_PRI_CH2               volatile.Register32 // 0x21C
	IN_PERI_SEL_CH2          volatile.Register32 // 0x220
	_                        [44]byte
	OUT_CONF0_CH2            volatile.Register32 // 0x250
	OUT_CONF1_CH2            volatile.Register32 // 0x254
	OUTFIFO_STATUS_CH2       volatile.Register32 // 0x258
	OUT_PUSH_CH2             volatile.Register32 // 0x25C
	OUT_LINK_CH2             volatile.Register32 // 0x260
	OUT_STATE_CH2            volatile.Register32 // 0x264
	OUT_EOF_DES_ADDR_CH2     volatile.Register32 // 0x268
	OUT_EOF_BFR_DES_ADDR_CH2 volatile.Register32 // 0x26C
	OUT_DSCR_CH2             volatile.Register32 // 0x270
	OUT_DSCR_BF0_CH2         volatile.Register32 // 0x274
	OUT_DSCR_BF1_CH2         volatile.Register32 // 0x278
	OUT_PRI_CH2              volatile.Register32 // 0x27C
	OUT_PERI_SEL_CH2         volatile.Register32 // 0x280
}

// DMA.INT_RAW_CH0: DMA_INT_RAW_CH0_REG.
func (o *DMA_Type) SetINT_RAW_CH0_IN_DONE_CH0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_RAW_CH0_IN_DONE_CH0_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetINT_RAW_CH0_IN_SUC_EOF_CH0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_RAW_CH0_IN_SUC_EOF_CH0_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_RAW_CH0_IN_ERR_EOF_CH0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_RAW_CH0_IN_ERR_EOF_CH0_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_RAW_CH0_OUT_DONE_CH0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_RAW_CH0_OUT_DONE_CH0_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINT_RAW_CH0_OUT_EOF_CH0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINT_RAW_CH0_OUT_EOF_CH0_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINT_RAW_CH0_IN_DSCR_ERR_CH0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINT_RAW_CH0_IN_DSCR_ERR_CH0_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINT_RAW_CH0_OUT_DSCR_ERR_CH0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINT_RAW_CH0_OUT_DSCR_ERR_CH0_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINT_RAW_CH0_IN_DSCR_EMPTY_CH0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINT_RAW_CH0_IN_DSCR_EMPTY_CH0_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINT_RAW_CH0_OUT_TOTAL_EOF_CH0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINT_RAW_CH0_OUT_TOTAL_EOF_CH0_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINT_RAW_CH0_INFIFO_OVF_CH0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINT_RAW_CH0_INFIFO_OVF_CH0_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINT_RAW_CH0_INFIFO_UDF_CH0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINT_RAW_CH0_INFIFO_UDF_CH0_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINT_RAW_CH0_OUTFIFO_OVF_CH0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINT_RAW_CH0_OUTFIFO_OVF_CH0_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINT_RAW_CH0_OUTFIFO_UDF_CH0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINT_RAW_CH0_OUTFIFO_UDF_CH0_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x1000) >> 12
}

// DMA.INT_ST_CH0: DMA_INT_ST_CH0_REG.
func (o *DMA_Type) SetINT_ST_CH0_IN_DONE_CH0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_ST_CH0_IN_DONE_CH0_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetINT_ST_CH0_IN_SUC_EOF_CH0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_ST_CH0_IN_SUC_EOF_CH0_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_ST_CH0_IN_ERR_EOF_CH0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_ST_CH0_IN_ERR_EOF_CH0_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_ST_CH0_OUT_DONE_CH0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_ST_CH0_OUT_DONE_CH0_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINT_ST_CH0_OUT_EOF_CH0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINT_ST_CH0_OUT_EOF_CH0_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINT_ST_CH0_IN_DSCR_ERR_CH0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINT_ST_CH0_IN_DSCR_ERR_CH0_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINT_ST_CH0_OUT_DSCR_ERR_CH0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINT_ST_CH0_OUT_DSCR_ERR_CH0_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINT_ST_CH0_IN_DSCR_EMPTY_CH0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINT_ST_CH0_IN_DSCR_EMPTY_CH0_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINT_ST_CH0_OUT_TOTAL_EOF_CH0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINT_ST_CH0_OUT_TOTAL_EOF_CH0_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINT_ST_CH0_INFIFO_OVF_CH0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINT_ST_CH0_INFIFO_OVF_CH0_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINT_ST_CH0_INFIFO_UDF_CH0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINT_ST_CH0_INFIFO_UDF_CH0_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINT_ST_CH0_OUTFIFO_OVF_CH0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINT_ST_CH0_OUTFIFO_OVF_CH0_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINT_ST_CH0_OUTFIFO_UDF_CH0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINT_ST_CH0_OUTFIFO_UDF_CH0_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x1000) >> 12
}

// DMA.INT_ENA_CH0: DMA_INT_ENA_CH0_REG.
func (o *DMA_Type) SetINT_ENA_CH0_IN_DONE_CH0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_ENA_CH0_IN_DONE_CH0_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetINT_ENA_CH0_IN_SUC_EOF_CH0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_ENA_CH0_IN_SUC_EOF_CH0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_ENA_CH0_IN_ERR_EOF_CH0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_ENA_CH0_IN_ERR_EOF_CH0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_ENA_CH0_OUT_DONE_CH0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_ENA_CH0_OUT_DONE_CH0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINT_ENA_CH0_OUT_EOF_CH0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINT_ENA_CH0_OUT_EOF_CH0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINT_ENA_CH0_IN_DSCR_ERR_CH0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINT_ENA_CH0_IN_DSCR_ERR_CH0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINT_ENA_CH0_OUT_DSCR_ERR_CH0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINT_ENA_CH0_OUT_DSCR_ERR_CH0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINT_ENA_CH0_IN_DSCR_EMPTY_CH0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINT_ENA_CH0_IN_DSCR_EMPTY_CH0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINT_ENA_CH0_OUT_TOTAL_EOF_CH0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINT_ENA_CH0_OUT_TOTAL_EOF_CH0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINT_ENA_CH0_INFIFO_OVF_CH0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINT_ENA_CH0_INFIFO_OVF_CH0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINT_ENA_CH0_INFIFO_UDF_CH0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINT_ENA_CH0_INFIFO_UDF_CH0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINT_ENA_CH0_OUTFIFO_OVF_CH0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINT_ENA_CH0_OUTFIFO_OVF_CH0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINT_ENA_CH0_OUTFIFO_UDF_CH0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINT_ENA_CH0_OUTFIFO_UDF_CH0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x1000) >> 12
}

// DMA.INT_CLR_CH0: DMA_INT_CLR_CH0_REG.
func (o *DMA_Type) SetINT_CLR_CH0_IN_DONE_CH0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_CLR_CH0_IN_DONE_CH0_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetINT_CLR_CH0_IN_SUC_EOF_CH0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_CLR_CH0_IN_SUC_EOF_CH0_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_CLR_CH0_IN_ERR_EOF_CH0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_CLR_CH0_IN_ERR_EOF_CH0_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_CLR_CH0_OUT_DONE_CH0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_CLR_CH0_OUT_DONE_CH0_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINT_CLR_CH0_OUT_EOF_CH0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINT_CLR_CH0_OUT_EOF_CH0_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINT_CLR_CH0_IN_DSCR_ERR_CH0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINT_CLR_CH0_IN_DSCR_ERR_CH0_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINT_CLR_CH0_OUT_DSCR_ERR_CH0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINT_CLR_CH0_OUT_DSCR_ERR_CH0_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINT_CLR_CH0_IN_DSCR_EMPTY_CH0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINT_CLR_CH0_IN_DSCR_EMPTY_CH0_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINT_CLR_CH0_OUT_TOTAL_EOF_CH0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINT_CLR_CH0_OUT_TOTAL_EOF_CH0_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINT_CLR_CH0_INFIFO_OVF_CH0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINT_CLR_CH0_INFIFO_OVF_CH0_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINT_CLR_CH0_INFIFO_UDF_CH0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINT_CLR_CH0_INFIFO_UDF_CH0_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINT_CLR_CH0_OUTFIFO_OVF_CH0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINT_CLR_CH0_OUTFIFO_OVF_CH0_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINT_CLR_CH0_OUTFIFO_UDF_CH0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINT_CLR_CH0_OUTFIFO_UDF_CH0_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x1000) >> 12
}

// DMA.INT_RAW_CH1: DMA_INT_RAW_CH1_REG.
func (o *DMA_Type) SetINT_RAW_CH1_IN_DONE_CH1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH1.Reg, volatile.LoadUint32(&o.INT_RAW_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_RAW_CH1_IN_DONE_CH1_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetINT_RAW_CH1_IN_SUC_EOF_CH1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH1.Reg, volatile.LoadUint32(&o.INT_RAW_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_RAW_CH1_IN_SUC_EOF_CH1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_RAW_CH1_IN_ERR_EOF_CH1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH1.Reg, volatile.LoadUint32(&o.INT_RAW_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_RAW_CH1_IN_ERR_EOF_CH1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_RAW_CH1_OUT_DONE_CH1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH1.Reg, volatile.LoadUint32(&o.INT_RAW_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_RAW_CH1_OUT_DONE_CH1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINT_RAW_CH1_OUT_EOF_CH1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH1.Reg, volatile.LoadUint32(&o.INT_RAW_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINT_RAW_CH1_OUT_EOF_CH1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINT_RAW_CH1_IN_DSCR_ERR_CH1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH1.Reg, volatile.LoadUint32(&o.INT_RAW_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINT_RAW_CH1_IN_DSCR_ERR_CH1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINT_RAW_CH1_OUT_DSCR_ERR_CH1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH1.Reg, volatile.LoadUint32(&o.INT_RAW_CH1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINT_RAW_CH1_OUT_DSCR_ERR_CH1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINT_RAW_CH1_IN_DSCR_EMPTY_CH1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH1.Reg, volatile.LoadUint32(&o.INT_RAW_CH1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINT_RAW_CH1_IN_DSCR_EMPTY_CH1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH1.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINT_RAW_CH1_OUT_TOTAL_EOF_CH1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH1.Reg, volatile.LoadUint32(&o.INT_RAW_CH1.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINT_RAW_CH1_OUT_TOTAL_EOF_CH1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH1.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINT_RAW_CH1_INFIFO_OVF_CH1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH1.Reg, volatile.LoadUint32(&o.INT_RAW_CH1.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINT_RAW_CH1_INFIFO_OVF_CH1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH1.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINT_RAW_CH1_INFIFO_UDF_CH1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH1.Reg, volatile.LoadUint32(&o.INT_RAW_CH1.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINT_RAW_CH1_INFIFO_UDF_CH1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH1.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINT_RAW_CH1_OUTFIFO_OVF_CH1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH1.Reg, volatile.LoadUint32(&o.INT_RAW_CH1.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINT_RAW_CH1_OUTFIFO_OVF_CH1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH1.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINT_RAW_CH1_OUTFIFO_UDF_CH1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH1.Reg, volatile.LoadUint32(&o.INT_RAW_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINT_RAW_CH1_OUTFIFO_UDF_CH1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH1.Reg) & 0x1000) >> 12
}

// DMA.INT_ST_CH1: DMA_INT_ST_CH1_REG.
func (o *DMA_Type) SetINT_ST_CH1_IN_DONE_CH1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH1.Reg, volatile.LoadUint32(&o.INT_ST_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_ST_CH1_IN_DONE_CH1_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetINT_ST_CH1_IN_SUC_EOF_CH1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH1.Reg, volatile.LoadUint32(&o.INT_ST_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_ST_CH1_IN_SUC_EOF_CH1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_ST_CH1_IN_ERR_EOF_CH1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH1.Reg, volatile.LoadUint32(&o.INT_ST_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_ST_CH1_IN_ERR_EOF_CH1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_ST_CH1_OUT_DONE_CH1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH1.Reg, volatile.LoadUint32(&o.INT_ST_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_ST_CH1_OUT_DONE_CH1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINT_ST_CH1_OUT_EOF_CH1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH1.Reg, volatile.LoadUint32(&o.INT_ST_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINT_ST_CH1_OUT_EOF_CH1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINT_ST_CH1_IN_DSCR_ERR_CH1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH1.Reg, volatile.LoadUint32(&o.INT_ST_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINT_ST_CH1_IN_DSCR_ERR_CH1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINT_ST_CH1_OUT_DSCR_ERR_CH1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH1.Reg, volatile.LoadUint32(&o.INT_ST_CH1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINT_ST_CH1_OUT_DSCR_ERR_CH1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINT_ST_CH1_IN_DSCR_EMPTY_CH1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH1.Reg, volatile.LoadUint32(&o.INT_ST_CH1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINT_ST_CH1_IN_DSCR_EMPTY_CH1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH1.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINT_ST_CH1_OUT_TOTAL_EOF_CH1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH1.Reg, volatile.LoadUint32(&o.INT_ST_CH1.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINT_ST_CH1_OUT_TOTAL_EOF_CH1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH1.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINT_ST_CH1_INFIFO_OVF_CH1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH1.Reg, volatile.LoadUint32(&o.INT_ST_CH1.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINT_ST_CH1_INFIFO_OVF_CH1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH1.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINT_ST_CH1_INFIFO_UDF_CH1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH1.Reg, volatile.LoadUint32(&o.INT_ST_CH1.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINT_ST_CH1_INFIFO_UDF_CH1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH1.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINT_ST_CH1_OUTFIFO_OVF_CH1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH1.Reg, volatile.LoadUint32(&o.INT_ST_CH1.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINT_ST_CH1_OUTFIFO_OVF_CH1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH1.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINT_ST_CH1_OUTFIFO_UDF_CH1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH1.Reg, volatile.LoadUint32(&o.INT_ST_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINT_ST_CH1_OUTFIFO_UDF_CH1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH1.Reg) & 0x1000) >> 12
}

// DMA.INT_ENA_CH1: DMA_INT_ENA_CH1_REG.
func (o *DMA_Type) SetINT_ENA_CH1_IN_DONE_CH1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH1.Reg, volatile.LoadUint32(&o.INT_ENA_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_ENA_CH1_IN_DONE_CH1_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetINT_ENA_CH1_IN_SUC_EOF_CH1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH1.Reg, volatile.LoadUint32(&o.INT_ENA_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_ENA_CH1_IN_SUC_EOF_CH1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_ENA_CH1_IN_ERR_EOF_CH1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH1.Reg, volatile.LoadUint32(&o.INT_ENA_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_ENA_CH1_IN_ERR_EOF_CH1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_ENA_CH1_OUT_DONE_CH1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH1.Reg, volatile.LoadUint32(&o.INT_ENA_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_ENA_CH1_OUT_DONE_CH1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINT_ENA_CH1_OUT_EOF_CH1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH1.Reg, volatile.LoadUint32(&o.INT_ENA_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINT_ENA_CH1_OUT_EOF_CH1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINT_ENA_CH1_IN_DSCR_ERR_CH1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH1.Reg, volatile.LoadUint32(&o.INT_ENA_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINT_ENA_CH1_IN_DSCR_ERR_CH1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINT_ENA_CH1_OUT_DSCR_ERR_CH1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH1.Reg, volatile.LoadUint32(&o.INT_ENA_CH1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINT_ENA_CH1_OUT_DSCR_ERR_CH1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINT_ENA_CH1_IN_DSCR_EMPTY_CH1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH1.Reg, volatile.LoadUint32(&o.INT_ENA_CH1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINT_ENA_CH1_IN_DSCR_EMPTY_CH1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH1.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINT_ENA_CH1_OUT_TOTAL_EOF_CH1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH1.Reg, volatile.LoadUint32(&o.INT_ENA_CH1.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINT_ENA_CH1_OUT_TOTAL_EOF_CH1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH1.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINT_ENA_CH1_INFIFO_OVF_CH1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH1.Reg, volatile.LoadUint32(&o.INT_ENA_CH1.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINT_ENA_CH1_INFIFO_OVF_CH1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH1.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINT_ENA_CH1_INFIFO_UDF_CH1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH1.Reg, volatile.LoadUint32(&o.INT_ENA_CH1.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINT_ENA_CH1_INFIFO_UDF_CH1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH1.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINT_ENA_CH1_OUTFIFO_OVF_CH1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH1.Reg, volatile.LoadUint32(&o.INT_ENA_CH1.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINT_ENA_CH1_OUTFIFO_OVF_CH1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH1.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINT_ENA_CH1_OUTFIFO_UDF_CH1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH1.Reg, volatile.LoadUint32(&o.INT_ENA_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINT_ENA_CH1_OUTFIFO_UDF_CH1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH1.Reg) & 0x1000) >> 12
}

// DMA.INT_CLR_CH1: DMA_INT_CLR_CH1_REG.
func (o *DMA_Type) SetINT_CLR_CH1_IN_DONE_CH1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH1.Reg, volatile.LoadUint32(&o.INT_CLR_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_CLR_CH1_IN_DONE_CH1_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetINT_CLR_CH1_IN_SUC_EOF_CH1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH1.Reg, volatile.LoadUint32(&o.INT_CLR_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_CLR_CH1_IN_SUC_EOF_CH1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_CLR_CH1_IN_ERR_EOF_CH1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH1.Reg, volatile.LoadUint32(&o.INT_CLR_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_CLR_CH1_IN_ERR_EOF_CH1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_CLR_CH1_OUT_DONE_CH1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH1.Reg, volatile.LoadUint32(&o.INT_CLR_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_CLR_CH1_OUT_DONE_CH1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINT_CLR_CH1_OUT_EOF_CH1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH1.Reg, volatile.LoadUint32(&o.INT_CLR_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINT_CLR_CH1_OUT_EOF_CH1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINT_CLR_CH1_IN_DSCR_ERR_CH1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH1.Reg, volatile.LoadUint32(&o.INT_CLR_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINT_CLR_CH1_IN_DSCR_ERR_CH1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINT_CLR_CH1_OUT_DSCR_ERR_CH1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH1.Reg, volatile.LoadUint32(&o.INT_CLR_CH1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINT_CLR_CH1_OUT_DSCR_ERR_CH1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINT_CLR_CH1_IN_DSCR_EMPTY_CH1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH1.Reg, volatile.LoadUint32(&o.INT_CLR_CH1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINT_CLR_CH1_IN_DSCR_EMPTY_CH1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH1.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINT_CLR_CH1_OUT_TOTAL_EOF_CH1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH1.Reg, volatile.LoadUint32(&o.INT_CLR_CH1.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINT_CLR_CH1_OUT_TOTAL_EOF_CH1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH1.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINT_CLR_CH1_INFIFO_OVF_CH1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH1.Reg, volatile.LoadUint32(&o.INT_CLR_CH1.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINT_CLR_CH1_INFIFO_OVF_CH1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH1.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINT_CLR_CH1_INFIFO_UDF_CH1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH1.Reg, volatile.LoadUint32(&o.INT_CLR_CH1.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINT_CLR_CH1_INFIFO_UDF_CH1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH1.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINT_CLR_CH1_OUTFIFO_OVF_CH1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH1.Reg, volatile.LoadUint32(&o.INT_CLR_CH1.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINT_CLR_CH1_OUTFIFO_OVF_CH1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH1.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINT_CLR_CH1_OUTFIFO_UDF_CH1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH1.Reg, volatile.LoadUint32(&o.INT_CLR_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINT_CLR_CH1_OUTFIFO_UDF_CH1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH1.Reg) & 0x1000) >> 12
}

// DMA.INT_RAW_CH2: DMA_INT_RAW_CH2_REG.
func (o *DMA_Type) SetINT_RAW_CH2_IN_DONE_CH2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH2.Reg, volatile.LoadUint32(&o.INT_RAW_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_RAW_CH2_IN_DONE_CH2_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetINT_RAW_CH2_IN_SUC_EOF_CH2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH2.Reg, volatile.LoadUint32(&o.INT_RAW_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_RAW_CH2_IN_SUC_EOF_CH2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_RAW_CH2_IN_ERR_EOF_CH2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH2.Reg, volatile.LoadUint32(&o.INT_RAW_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_RAW_CH2_IN_ERR_EOF_CH2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_RAW_CH2_OUT_DONE_CH2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH2.Reg, volatile.LoadUint32(&o.INT_RAW_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_RAW_CH2_OUT_DONE_CH2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINT_RAW_CH2_OUT_EOF_CH2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH2.Reg, volatile.LoadUint32(&o.INT_RAW_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINT_RAW_CH2_OUT_EOF_CH2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINT_RAW_CH2_IN_DSCR_ERR_CH2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH2.Reg, volatile.LoadUint32(&o.INT_RAW_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINT_RAW_CH2_IN_DSCR_ERR_CH2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINT_RAW_CH2_OUT_DSCR_ERR_CH2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH2.Reg, volatile.LoadUint32(&o.INT_RAW_CH2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINT_RAW_CH2_OUT_DSCR_ERR_CH2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINT_RAW_CH2_IN_DSCR_EMPTY_CH2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH2.Reg, volatile.LoadUint32(&o.INT_RAW_CH2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINT_RAW_CH2_IN_DSCR_EMPTY_CH2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH2.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINT_RAW_CH2_OUT_TOTAL_EOF_CH2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH2.Reg, volatile.LoadUint32(&o.INT_RAW_CH2.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINT_RAW_CH2_OUT_TOTAL_EOF_CH2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH2.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINT_RAW_CH2_INFIFO_OVF_CH2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH2.Reg, volatile.LoadUint32(&o.INT_RAW_CH2.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINT_RAW_CH2_INFIFO_OVF_CH2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH2.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINT_RAW_CH2_INFIFO_UDF_CH2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH2.Reg, volatile.LoadUint32(&o.INT_RAW_CH2.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINT_RAW_CH2_INFIFO_UDF_CH2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH2.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINT_RAW_CH2_OUTFIFO_OVF_CH2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH2.Reg, volatile.LoadUint32(&o.INT_RAW_CH2.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINT_RAW_CH2_OUTFIFO_OVF_CH2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH2.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINT_RAW_CH2_OUTFIFO_UDF_CH2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH2.Reg, volatile.LoadUint32(&o.INT_RAW_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINT_RAW_CH2_OUTFIFO_UDF_CH2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH2.Reg) & 0x1000) >> 12
}

// DMA.INT_ST_CH2: DMA_INT_ST_CH2_REG.
func (o *DMA_Type) SetINT_ST_CH2_IN_DONE_CH2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH2.Reg, volatile.LoadUint32(&o.INT_ST_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_ST_CH2_IN_DONE_CH2_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetINT_ST_CH2_IN_SUC_EOF_CH2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH2.Reg, volatile.LoadUint32(&o.INT_ST_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_ST_CH2_IN_SUC_EOF_CH2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_ST_CH2_IN_ERR_EOF_CH2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH2.Reg, volatile.LoadUint32(&o.INT_ST_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_ST_CH2_IN_ERR_EOF_CH2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_ST_CH2_OUT_DONE_CH2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH2.Reg, volatile.LoadUint32(&o.INT_ST_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_ST_CH2_OUT_DONE_CH2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINT_ST_CH2_OUT_EOF_CH2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH2.Reg, volatile.LoadUint32(&o.INT_ST_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINT_ST_CH2_OUT_EOF_CH2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINT_ST_CH2_IN_DSCR_ERR_CH2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH2.Reg, volatile.LoadUint32(&o.INT_ST_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINT_ST_CH2_IN_DSCR_ERR_CH2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINT_ST_CH2_OUT_DSCR_ERR_CH2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH2.Reg, volatile.LoadUint32(&o.INT_ST_CH2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINT_ST_CH2_OUT_DSCR_ERR_CH2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINT_ST_CH2_IN_DSCR_EMPTY_CH2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH2.Reg, volatile.LoadUint32(&o.INT_ST_CH2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINT_ST_CH2_IN_DSCR_EMPTY_CH2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH2.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINT_ST_CH2_OUT_TOTAL_EOF_CH2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH2.Reg, volatile.LoadUint32(&o.INT_ST_CH2.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINT_ST_CH2_OUT_TOTAL_EOF_CH2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH2.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINT_ST_CH2_INFIFO_OVF_CH2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH2.Reg, volatile.LoadUint32(&o.INT_ST_CH2.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINT_ST_CH2_INFIFO_OVF_CH2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH2.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINT_ST_CH2_INFIFO_UDF_CH2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH2.Reg, volatile.LoadUint32(&o.INT_ST_CH2.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINT_ST_CH2_INFIFO_UDF_CH2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH2.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINT_ST_CH2_OUTFIFO_OVF_CH2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH2.Reg, volatile.LoadUint32(&o.INT_ST_CH2.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINT_ST_CH2_OUTFIFO_OVF_CH2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH2.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINT_ST_CH2_OUTFIFO_UDF_CH2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH2.Reg, volatile.LoadUint32(&o.INT_ST_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINT_ST_CH2_OUTFIFO_UDF_CH2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH2.Reg) & 0x1000) >> 12
}

// DMA.INT_ENA_CH2: DMA_INT_ENA_CH2_REG.
func (o *DMA_Type) SetINT_ENA_CH2_IN_DONE_CH2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH2.Reg, volatile.LoadUint32(&o.INT_ENA_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_ENA_CH2_IN_DONE_CH2_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetINT_ENA_CH2_IN_SUC_EOF_CH2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH2.Reg, volatile.LoadUint32(&o.INT_ENA_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_ENA_CH2_IN_SUC_EOF_CH2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_ENA_CH2_IN_ERR_EOF_CH2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH2.Reg, volatile.LoadUint32(&o.INT_ENA_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_ENA_CH2_IN_ERR_EOF_CH2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_ENA_CH2_OUT_DONE_CH2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH2.Reg, volatile.LoadUint32(&o.INT_ENA_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_ENA_CH2_OUT_DONE_CH2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINT_ENA_CH2_OUT_EOF_CH2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH2.Reg, volatile.LoadUint32(&o.INT_ENA_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINT_ENA_CH2_OUT_EOF_CH2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINT_ENA_CH2_IN_DSCR_ERR_CH2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH2.Reg, volatile.LoadUint32(&o.INT_ENA_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINT_ENA_CH2_IN_DSCR_ERR_CH2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINT_ENA_CH2_OUT_DSCR_ERR_CH2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH2.Reg, volatile.LoadUint32(&o.INT_ENA_CH2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINT_ENA_CH2_OUT_DSCR_ERR_CH2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINT_ENA_CH2_IN_DSCR_EMPTY_CH2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH2.Reg, volatile.LoadUint32(&o.INT_ENA_CH2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINT_ENA_CH2_IN_DSCR_EMPTY_CH2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH2.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINT_ENA_CH2_OUT_TOTAL_EOF_CH2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH2.Reg, volatile.LoadUint32(&o.INT_ENA_CH2.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINT_ENA_CH2_OUT_TOTAL_EOF_CH2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH2.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINT_ENA_CH2_INFIFO_OVF_CH2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH2.Reg, volatile.LoadUint32(&o.INT_ENA_CH2.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINT_ENA_CH2_INFIFO_OVF_CH2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH2.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINT_ENA_CH2_INFIFO_UDF_CH2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH2.Reg, volatile.LoadUint32(&o.INT_ENA_CH2.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINT_ENA_CH2_INFIFO_UDF_CH2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH2.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINT_ENA_CH2_OUTFIFO_OVF_CH2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH2.Reg, volatile.LoadUint32(&o.INT_ENA_CH2.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINT_ENA_CH2_OUTFIFO_OVF_CH2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH2.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINT_ENA_CH2_OUTFIFO_UDF_CH2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH2.Reg, volatile.LoadUint32(&o.INT_ENA_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINT_ENA_CH2_OUTFIFO_UDF_CH2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH2.Reg) & 0x1000) >> 12
}

// DMA.INT_CLR_CH2: DMA_INT_CLR_CH2_REG.
func (o *DMA_Type) SetINT_CLR_CH2_IN_DONE_CH2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH2.Reg, volatile.LoadUint32(&o.INT_CLR_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_CLR_CH2_IN_DONE_CH2_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetINT_CLR_CH2_IN_SUC_EOF_CH2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH2.Reg, volatile.LoadUint32(&o.INT_CLR_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_CLR_CH2_IN_SUC_EOF_CH2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_CLR_CH2_IN_ERR_EOF_CH2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH2.Reg, volatile.LoadUint32(&o.INT_CLR_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_CLR_CH2_IN_ERR_EOF_CH2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_CLR_CH2_OUT_DONE_CH2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH2.Reg, volatile.LoadUint32(&o.INT_CLR_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_CLR_CH2_OUT_DONE_CH2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINT_CLR_CH2_OUT_EOF_CH2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH2.Reg, volatile.LoadUint32(&o.INT_CLR_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINT_CLR_CH2_OUT_EOF_CH2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINT_CLR_CH2_IN_DSCR_ERR_CH2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH2.Reg, volatile.LoadUint32(&o.INT_CLR_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINT_CLR_CH2_IN_DSCR_ERR_CH2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINT_CLR_CH2_OUT_DSCR_ERR_CH2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH2.Reg, volatile.LoadUint32(&o.INT_CLR_CH2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINT_CLR_CH2_OUT_DSCR_ERR_CH2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINT_CLR_CH2_IN_DSCR_EMPTY_CH2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH2.Reg, volatile.LoadUint32(&o.INT_CLR_CH2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINT_CLR_CH2_IN_DSCR_EMPTY_CH2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH2.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINT_CLR_CH2_OUT_TOTAL_EOF_CH2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH2.Reg, volatile.LoadUint32(&o.INT_CLR_CH2.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINT_CLR_CH2_OUT_TOTAL_EOF_CH2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH2.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINT_CLR_CH2_INFIFO_OVF_CH2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH2.Reg, volatile.LoadUint32(&o.INT_CLR_CH2.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINT_CLR_CH2_INFIFO_OVF_CH2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH2.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINT_CLR_CH2_INFIFO_UDF_CH2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH2.Reg, volatile.LoadUint32(&o.INT_CLR_CH2.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINT_CLR_CH2_INFIFO_UDF_CH2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH2.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINT_CLR_CH2_OUTFIFO_OVF_CH2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH2.Reg, volatile.LoadUint32(&o.INT_CLR_CH2.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINT_CLR_CH2_OUTFIFO_OVF_CH2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH2.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINT_CLR_CH2_OUTFIFO_UDF_CH2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH2.Reg, volatile.LoadUint32(&o.INT_CLR_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINT_CLR_CH2_OUTFIFO_UDF_CH2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH2.Reg) & 0x1000) >> 12
}

// DMA.AHB_TEST: DMA_AHB_TEST_REG.
func (o *DMA_Type) SetAHB_TEST_AHB_TESTMODE(value uint32) {
	volatile.StoreUint32(&o.AHB_TEST.Reg, volatile.LoadUint32(&o.AHB_TEST.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetAHB_TEST_AHB_TESTMODE() uint32 {
	return volatile.LoadUint32(&o.AHB_TEST.Reg) & 0x7
}
func (o *DMA_Type) SetAHB_TEST_AHB_TESTADDR(value uint32) {
	volatile.StoreUint32(&o.AHB_TEST.Reg, volatile.LoadUint32(&o.AHB_TEST.Reg)&^(0x30)|value<<4)
}
func (o *DMA_Type) GetAHB_TEST_AHB_TESTADDR() uint32 {
	return (volatile.LoadUint32(&o.AHB_TEST.Reg) & 0x30) >> 4
}

// DMA.MISC_CONF: DMA_MISC_CONF_REG.
func (o *DMA_Type) SetMISC_CONF_AHBM_RST_INTER(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetMISC_CONF_AHBM_RST_INTER() uint32 {
	return volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x1
}
func (o *DMA_Type) SetMISC_CONF_ARB_PRI_DIS(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetMISC_CONF_ARB_PRI_DIS() uint32 {
	return (volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetMISC_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetMISC_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x8) >> 3
}

// DMA.DATE: DMA_DATE_REG.
func (o *DMA_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *DMA_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// DMA.IN_CONF0_CH0: DMA_IN_CONF0_CH0_REG.
func (o *DMA_Type) SetIN_CONF0_CH0_IN_RST_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_CONF0_CH0_IN_RST_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetIN_CONF0_CH0_IN_LOOP_TEST_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_CONF0_CH0_IN_LOOP_TEST_CH0() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_CONF0_CH0_INDSCR_BURST_EN_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_CONF0_CH0_INDSCR_BURST_EN_CH0() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_CONF0_CH0_IN_DATA_BURST_EN_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_CONF0_CH0_IN_DATA_BURST_EN_CH0() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_CONF0_CH0_MEM_TRANS_EN_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_CONF0_CH0_MEM_TRANS_EN_CH0() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x10) >> 4
}

// DMA.IN_CONF1_CH0: DMA_IN_CONF1_CH0_REG.
func (o *DMA_Type) SetIN_CONF1_CH0_IN_CHECK_OWNER_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH0.Reg, volatile.LoadUint32(&o.IN_CONF1_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_CONF1_CH0_IN_CHECK_OWNER_CH0() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH0.Reg) & 0x1000) >> 12
}

// DMA.INFIFO_STATUS_CH0: DMA_INFIFO_STATUS_CH0_REG.
func (o *DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_FULL_CH0(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_FULL_CH0() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_EMPTY_CH0(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_EMPTY_CH0() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_CNT_CH0(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0xfc)|value<<2)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_CNT_CH0() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0xfc) >> 2
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_1B_CH0(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_1B_CH0() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_2B_CH0(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_2B_CH0() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_3B_CH0(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_3B_CH0() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_4B_CH0(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_4B_CH0() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_BUF_HUNGRY_CH0(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_BUF_HUNGRY_CH0() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x8000000) >> 27
}

// DMA.IN_POP_CH0: DMA_IN_POP_CH0_REG.
func (o *DMA_Type) SetIN_POP_CH0_INFIFO_RDATA_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH0.Reg, volatile.LoadUint32(&o.IN_POP_CH0.Reg)&^(0xfff)|value)
}
func (o *DMA_Type) GetIN_POP_CH0_INFIFO_RDATA_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_POP_CH0.Reg) & 0xfff
}
func (o *DMA_Type) SetIN_POP_CH0_INFIFO_POP_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH0.Reg, volatile.LoadUint32(&o.IN_POP_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_POP_CH0_INFIFO_POP_CH0() uint32 {
	return (volatile.LoadUint32(&o.IN_POP_CH0.Reg) & 0x1000) >> 12
}

// DMA.IN_LINK_CH0: DMA_IN_LINK_CH0_REG.
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0xfffff
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_AUTO_RET_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_AUTO_RET_CH0() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_STOP_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_STOP_CH0() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_START_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_START_CH0() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_RESTART_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_RESTART_CH0() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_PARK_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_PARK_CH0() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x1000000) >> 24
}

// DMA.IN_STATE_CH0: DMA_IN_STATE_CH0_REG.
func (o *DMA_Type) SetIN_STATE_CH0_INLINK_DSCR_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH0.Reg, volatile.LoadUint32(&o.IN_STATE_CH0.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetIN_STATE_CH0_INLINK_DSCR_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_STATE_CH0.Reg) & 0x3ffff
}
func (o *DMA_Type) SetIN_STATE_CH0_IN_DSCR_STATE_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH0.Reg, volatile.LoadUint32(&o.IN_STATE_CH0.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetIN_STATE_CH0_IN_DSCR_STATE_CH0() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH0.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetIN_STATE_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH0.Reg, volatile.LoadUint32(&o.IN_STATE_CH0.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetIN_STATE_CH0() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH0.Reg) & 0x700000) >> 20
}

// DMA.IN_SUC_EOF_DES_ADDR_CH0: DMA_IN_SUC_EOF_DES_ADDR_CH0_REG.
func (o *DMA_Type) SetIN_SUC_EOF_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_SUC_EOF_DES_ADDR_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_SUC_EOF_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_SUC_EOF_DES_ADDR_CH0.Reg)
}

// DMA.IN_ERR_EOF_DES_ADDR_CH0: DMA_IN_ERR_EOF_DES_ADDR_CH0_REG.
func (o *DMA_Type) SetIN_ERR_EOF_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_ERR_EOF_DES_ADDR_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_ERR_EOF_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_ERR_EOF_DES_ADDR_CH0.Reg)
}

// DMA.IN_DSCR_CH0: DMA_IN_DSCR_CH0_REG.
func (o *DMA_Type) SetIN_DSCR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_CH0.Reg)
}

// DMA.IN_DSCR_BF0_CH0: DMA_IN_DSCR_BF0_CH0_REG.
func (o *DMA_Type) SetIN_DSCR_BF0_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF0_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF0_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF0_CH0.Reg)
}

// DMA.IN_DSCR_BF1_CH0: DMA_IN_DSCR_BF1_CH0_REG.
func (o *DMA_Type) SetIN_DSCR_BF1_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF1_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF1_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF1_CH0.Reg)
}

// DMA.IN_PRI_CH0: DMA_IN_PRI_CH0_REG.
func (o *DMA_Type) SetIN_PRI_CH0_RX_PRI_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH0.Reg, volatile.LoadUint32(&o.IN_PRI_CH0.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetIN_PRI_CH0_RX_PRI_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_PRI_CH0.Reg) & 0xf
}

// DMA.IN_PERI_SEL_CH0: DMA_IN_PERI_SEL_CH0_REG.
func (o *DMA_Type) SetIN_PERI_SEL_CH0_PERI_IN_SEL_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_PERI_SEL_CH0.Reg, volatile.LoadUint32(&o.IN_PERI_SEL_CH0.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetIN_PERI_SEL_CH0_PERI_IN_SEL_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_PERI_SEL_CH0.Reg) & 0x3f
}

// DMA.OUT_CONF0_CH0: DMA_OUT_CONF0_CH0_REG.
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_RST_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_RST_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_LOOP_TEST_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_LOOP_TEST_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_AUTO_WRBACK_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_AUTO_WRBACK_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_EOF_MODE_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_EOF_MODE_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUTDSCR_BURST_EN_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUTDSCR_BURST_EN_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_DATA_BURST_EN_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_DATA_BURST_EN_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x20) >> 5
}

// DMA.OUT_CONF1_CH0: DMA_OUT_CONF1_CH0_REG.
func (o *DMA_Type) SetOUT_CONF1_CH0_OUT_CHECK_OWNER_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetOUT_CONF1_CH0_OUT_CHECK_OWNER_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH0.Reg) & 0x1000) >> 12
}

// DMA.OUTFIFO_STATUS_CH0: DMA_OUTFIFO_STATUS_CH0_REG.
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_FULL_CH0(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_FULL_CH0() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_EMPTY_CH0(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_EMPTY_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_CNT_CH0(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0xfc)|value<<2)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_CNT_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0xfc) >> 2
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_1B_CH0(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_1B_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_2B_CH0(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_2B_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_3B_CH0(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_3B_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_4B_CH0(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_4B_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x4000000) >> 26
}

// DMA.OUT_PUSH_CH0: DMA_OUT_PUSH_CH0_REG.
func (o *DMA_Type) SetOUT_PUSH_CH0_OUTFIFO_WDATA_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH0.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg)&^(0x1ff)|value)
}
func (o *DMA_Type) GetOUT_PUSH_CH0_OUTFIFO_WDATA_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg) & 0x1ff
}
func (o *DMA_Type) SetOUT_PUSH_CH0_OUTFIFO_PUSH_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH0.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetOUT_PUSH_CH0_OUTFIFO_PUSH_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg) & 0x200) >> 9
}

// DMA.OUT_LINK_CH0: DMA_OUT_LINK_CH0_REG.
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0xfffff
}
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_STOP_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_STOP_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_START_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_START_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_RESTART_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_RESTART_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_PARK_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_PARK_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x800000) >> 23
}

// DMA.OUT_STATE_CH0: DMA_OUT_STATE_CH0_REG.
func (o *DMA_Type) SetOUT_STATE_CH0_OUTLINK_DSCR_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH0.Reg, volatile.LoadUint32(&o.OUT_STATE_CH0.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetOUT_STATE_CH0_OUTLINK_DSCR_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_STATE_CH0.Reg) & 0x3ffff
}
func (o *DMA_Type) SetOUT_STATE_CH0_OUT_DSCR_STATE_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH0.Reg, volatile.LoadUint32(&o.OUT_STATE_CH0.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetOUT_STATE_CH0_OUT_DSCR_STATE_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH0.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetOUT_STATE_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH0.Reg, volatile.LoadUint32(&o.OUT_STATE_CH0.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetOUT_STATE_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH0.Reg) & 0x700000) >> 20
}

// DMA.OUT_EOF_DES_ADDR_CH0: DMA_OUT_EOF_DES_ADDR_CH0_REG.
func (o *DMA_Type) SetOUT_EOF_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR_CH0.Reg)
}

// DMA.OUT_EOF_BFR_DES_ADDR_CH0: DMA_OUT_EOF_BFR_DES_ADDR_CH0_REG.
func (o *DMA_Type) SetOUT_EOF_BFR_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_BFR_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR_CH0.Reg)
}

// DMA.OUT_DSCR_CH0: DMA_OUT_DSCR_CH0_REG.
func (o *DMA_Type) SetOUT_DSCR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_CH0.Reg)
}

// DMA.OUT_DSCR_BF0_CH0: DMA_OUT_DSCR_BF0_CH0_REG.
func (o *DMA_Type) SetOUT_DSCR_BF0_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF0_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF0_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF0_CH0.Reg)
}

// DMA.OUT_DSCR_BF1_CH0: DMA_OUT_DSCR_BF1_CH0_REG.
func (o *DMA_Type) SetOUT_DSCR_BF1_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF1_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF1_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF1_CH0.Reg)
}

// DMA.OUT_PRI_CH0: DMA_OUT_PRI_CH0_REG.
func (o *DMA_Type) SetOUT_PRI_CH0_TX_PRI_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH0.Reg, volatile.LoadUint32(&o.OUT_PRI_CH0.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetOUT_PRI_CH0_TX_PRI_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_PRI_CH0.Reg) & 0xf
}

// DMA.OUT_PERI_SEL_CH0: DMA_OUT_PERI_SEL_CH0_REG.
func (o *DMA_Type) SetOUT_PERI_SEL_CH0_PERI_OUT_SEL_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_PERI_SEL_CH0.Reg, volatile.LoadUint32(&o.OUT_PERI_SEL_CH0.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetOUT_PERI_SEL_CH0_PERI_OUT_SEL_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_PERI_SEL_CH0.Reg) & 0x3f
}

// DMA.IN_CONF0_CH1: DMA_IN_CONF0_CH1_REG.
func (o *DMA_Type) SetIN_CONF0_CH1_IN_RST_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_CONF0_CH1_IN_RST_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetIN_CONF0_CH1_IN_LOOP_TEST_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_CONF0_CH1_IN_LOOP_TEST_CH1() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_CONF0_CH1_INDSCR_BURST_EN_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_CONF0_CH1_INDSCR_BURST_EN_CH1() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_CONF0_CH1_IN_DATA_BURST_EN_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_CONF0_CH1_IN_DATA_BURST_EN_CH1() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_CONF0_CH1_MEM_TRANS_EN_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_CONF0_CH1_MEM_TRANS_EN_CH1() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x10) >> 4
}

// DMA.IN_CONF1_CH1: DMA_IN_CONF1_CH1_REG.
func (o *DMA_Type) SetIN_CONF1_CH1_IN_CHECK_OWNER_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH1.Reg, volatile.LoadUint32(&o.IN_CONF1_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_CONF1_CH1_IN_CHECK_OWNER_CH1() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH1.Reg) & 0x1000) >> 12
}

// DMA.INFIFO_STATUS_CH1: DMA_INFIFO_STATUS_CH1_REG.
func (o *DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_FULL_CH1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_FULL_CH1() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_EMPTY_CH1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_EMPTY_CH1() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_CNT_CH1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0xfc)|value<<2)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_CNT_CH1() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0xfc) >> 2
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_1B_CH1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_1B_CH1() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_2B_CH1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_2B_CH1() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_3B_CH1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_3B_CH1() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_4B_CH1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_4B_CH1() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_IN_BUF_HUNGRY_CH1(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_IN_BUF_HUNGRY_CH1() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x8000000) >> 27
}

// DMA.IN_POP_CH1: DMA_IN_POP_CH1_REG.
func (o *DMA_Type) SetIN_POP_CH1_INFIFO_RDATA_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH1.Reg, volatile.LoadUint32(&o.IN_POP_CH1.Reg)&^(0xfff)|value)
}
func (o *DMA_Type) GetIN_POP_CH1_INFIFO_RDATA_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_POP_CH1.Reg) & 0xfff
}
func (o *DMA_Type) SetIN_POP_CH1_INFIFO_POP_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH1.Reg, volatile.LoadUint32(&o.IN_POP_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_POP_CH1_INFIFO_POP_CH1() uint32 {
	return (volatile.LoadUint32(&o.IN_POP_CH1.Reg) & 0x1000) >> 12
}

// DMA.IN_LINK_CH1: DMA_IN_LINK_CH1_REG.
func (o *DMA_Type) SetIN_LINK_CH1_INLINK_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetIN_LINK_CH1_INLINK_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0xfffff
}
func (o *DMA_Type) SetIN_LINK_CH1_INLINK_AUTO_RET_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetIN_LINK_CH1_INLINK_AUTO_RET_CH1() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetIN_LINK_CH1_INLINK_STOP_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetIN_LINK_CH1_INLINK_STOP_CH1() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetIN_LINK_CH1_INLINK_START_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetIN_LINK_CH1_INLINK_START_CH1() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetIN_LINK_CH1_INLINK_RESTART_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetIN_LINK_CH1_INLINK_RESTART_CH1() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetIN_LINK_CH1_INLINK_PARK_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetIN_LINK_CH1_INLINK_PARK_CH1() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x1000000) >> 24
}

// DMA.IN_STATE_CH1: DMA_IN_STATE_CH1_REG.
func (o *DMA_Type) SetIN_STATE_CH1_INLINK_DSCR_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH1.Reg, volatile.LoadUint32(&o.IN_STATE_CH1.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetIN_STATE_CH1_INLINK_DSCR_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_STATE_CH1.Reg) & 0x3ffff
}
func (o *DMA_Type) SetIN_STATE_CH1_IN_DSCR_STATE_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH1.Reg, volatile.LoadUint32(&o.IN_STATE_CH1.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetIN_STATE_CH1_IN_DSCR_STATE_CH1() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH1.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetIN_STATE_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH1.Reg, volatile.LoadUint32(&o.IN_STATE_CH1.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetIN_STATE_CH1() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH1.Reg) & 0x700000) >> 20
}

// DMA.IN_SUC_EOF_DES_ADDR_CH1: DMA_IN_SUC_EOF_DES_ADDR_CH1_REG.
func (o *DMA_Type) SetIN_SUC_EOF_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_SUC_EOF_DES_ADDR_CH1.Reg, value)
}
func (o *DMA_Type) GetIN_SUC_EOF_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_SUC_EOF_DES_ADDR_CH1.Reg)
}

// DMA.IN_ERR_EOF_DES_ADDR_CH1: DMA_IN_ERR_EOF_DES_ADDR_CH1_REG.
func (o *DMA_Type) SetIN_ERR_EOF_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_ERR_EOF_DES_ADDR_CH1.Reg, value)
}
func (o *DMA_Type) GetIN_ERR_EOF_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_ERR_EOF_DES_ADDR_CH1.Reg)
}

// DMA.IN_DSCR_CH1: DMA_IN_DSCR_CH1_REG.
func (o *DMA_Type) SetIN_DSCR_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_CH1.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_CH1.Reg)
}

// DMA.IN_DSCR_BF0_CH1: DMA_IN_DSCR_BF0_CH1_REG.
func (o *DMA_Type) SetIN_DSCR_BF0_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF0_CH1.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF0_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF0_CH1.Reg)
}

// DMA.IN_DSCR_BF1_CH1: DMA_IN_DSCR_BF1_CH1_REG.
func (o *DMA_Type) SetIN_DSCR_BF1_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF1_CH1.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF1_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF1_CH1.Reg)
}

// DMA.IN_PRI_CH1: DMA_IN_PRI_CH1_REG.
func (o *DMA_Type) SetIN_PRI_CH1_RX_PRI_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH1.Reg, volatile.LoadUint32(&o.IN_PRI_CH1.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetIN_PRI_CH1_RX_PRI_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_PRI_CH1.Reg) & 0xf
}

// DMA.IN_PERI_SEL_CH1: DMA_IN_PERI_SEL_CH1_REG.
func (o *DMA_Type) SetIN_PERI_SEL_CH1_PERI_IN_SEL_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_PERI_SEL_CH1.Reg, volatile.LoadUint32(&o.IN_PERI_SEL_CH1.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetIN_PERI_SEL_CH1_PERI_IN_SEL_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_PERI_SEL_CH1.Reg) & 0x3f
}

// DMA.OUT_CONF0_CH1: DMA_OUT_CONF0_CH1_REG.
func (o *DMA_Type) SetOUT_CONF0_CH1_OUT_RST_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUT_RST_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_CONF0_CH1_OUT_LOOP_TEST_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUT_LOOP_TEST_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_CONF0_CH1_OUT_AUTO_WRBACK_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUT_AUTO_WRBACK_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_CONF0_CH1_OUT_EOF_MODE_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUT_EOF_MODE_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_CONF0_CH1_OUTDSCR_BURST_EN_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUTDSCR_BURST_EN_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_CONF0_CH1_OUT_DATA_BURST_EN_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUT_DATA_BURST_EN_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x20) >> 5
}

// DMA.OUT_CONF1_CH1: DMA_OUT_CONF1_CH1_REG.
func (o *DMA_Type) SetOUT_CONF1_CH1_OUT_CHECK_OWNER_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetOUT_CONF1_CH1_OUT_CHECK_OWNER_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH1.Reg) & 0x1000) >> 12
}

// DMA.OUTFIFO_STATUS_CH1: DMA_OUTFIFO_STATUS_CH1_REG.
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_FULL_CH1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_FULL_CH1() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_EMPTY_CH1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_EMPTY_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_CNT_CH1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0xfc)|value<<2)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_CNT_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0xfc) >> 2
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_1B_CH1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_1B_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_2B_CH1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_2B_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_3B_CH1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_3B_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_4B_CH1(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_4B_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x4000000) >> 26
}

// DMA.OUT_PUSH_CH1: DMA_OUT_PUSH_CH1_REG.
func (o *DMA_Type) SetOUT_PUSH_CH1_OUTFIFO_WDATA_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH1.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg)&^(0x1ff)|value)
}
func (o *DMA_Type) GetOUT_PUSH_CH1_OUTFIFO_WDATA_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg) & 0x1ff
}
func (o *DMA_Type) SetOUT_PUSH_CH1_OUTFIFO_PUSH_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH1.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetOUT_PUSH_CH1_OUTFIFO_PUSH_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg) & 0x200) >> 9
}

// DMA.OUT_LINK_CH1: DMA_OUT_LINK_CH1_REG.
func (o *DMA_Type) SetOUT_LINK_CH1_OUTLINK_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetOUT_LINK_CH1_OUTLINK_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0xfffff
}
func (o *DMA_Type) SetOUT_LINK_CH1_OUTLINK_STOP_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetOUT_LINK_CH1_OUTLINK_STOP_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetOUT_LINK_CH1_OUTLINK_START_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetOUT_LINK_CH1_OUTLINK_START_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetOUT_LINK_CH1_OUTLINK_RESTART_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetOUT_LINK_CH1_OUTLINK_RESTART_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetOUT_LINK_CH1_OUTLINK_PARK_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUT_LINK_CH1_OUTLINK_PARK_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0x800000) >> 23
}

// DMA.OUT_STATE_CH1: DMA_OUT_STATE_CH1_REG.
func (o *DMA_Type) SetOUT_STATE_CH1_OUTLINK_DSCR_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH1.Reg, volatile.LoadUint32(&o.OUT_STATE_CH1.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetOUT_STATE_CH1_OUTLINK_DSCR_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_STATE_CH1.Reg) & 0x3ffff
}
func (o *DMA_Type) SetOUT_STATE_CH1_OUT_DSCR_STATE_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH1.Reg, volatile.LoadUint32(&o.OUT_STATE_CH1.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetOUT_STATE_CH1_OUT_DSCR_STATE_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH1.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetOUT_STATE_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH1.Reg, volatile.LoadUint32(&o.OUT_STATE_CH1.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetOUT_STATE_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH1.Reg) & 0x700000) >> 20
}

// DMA.OUT_EOF_DES_ADDR_CH1: DMA_OUT_EOF_DES_ADDR_CH1_REG.
func (o *DMA_Type) SetOUT_EOF_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR_CH1.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR_CH1.Reg)
}

// DMA.OUT_EOF_BFR_DES_ADDR_CH1: DMA_OUT_EOF_BFR_DES_ADDR_CH1_REG.
func (o *DMA_Type) SetOUT_EOF_BFR_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR_CH1.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_BFR_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR_CH1.Reg)
}

// DMA.OUT_DSCR_CH1: DMA_OUT_DSCR_CH1_REG.
func (o *DMA_Type) SetOUT_DSCR_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_CH1.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_CH1.Reg)
}

// DMA.OUT_DSCR_BF0_CH1: DMA_OUT_DSCR_BF0_CH1_REG.
func (o *DMA_Type) SetOUT_DSCR_BF0_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF0_CH1.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF0_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF0_CH1.Reg)
}

// DMA.OUT_DSCR_BF1_CH1: DMA_OUT_DSCR_BF1_CH1_REG.
func (o *DMA_Type) SetOUT_DSCR_BF1_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF1_CH1.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF1_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF1_CH1.Reg)
}

// DMA.OUT_PRI_CH1: DMA_OUT_PRI_CH1_REG.
func (o *DMA_Type) SetOUT_PRI_CH1_TX_PRI_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH1.Reg, volatile.LoadUint32(&o.OUT_PRI_CH1.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetOUT_PRI_CH1_TX_PRI_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_PRI_CH1.Reg) & 0xf
}

// DMA.OUT_PERI_SEL_CH1: DMA_OUT_PERI_SEL_CH1_REG.
func (o *DMA_Type) SetOUT_PERI_SEL_CH1_PERI_OUT_SEL_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_PERI_SEL_CH1.Reg, volatile.LoadUint32(&o.OUT_PERI_SEL_CH1.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetOUT_PERI_SEL_CH1_PERI_OUT_SEL_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_PERI_SEL_CH1.Reg) & 0x3f
}

// DMA.IN_CONF0_CH2: DMA_IN_CONF0_CH2_REG.
func (o *DMA_Type) SetIN_CONF0_CH2_IN_RST_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_CONF0_CH2_IN_RST_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetIN_CONF0_CH2_IN_LOOP_TEST_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_CONF0_CH2_IN_LOOP_TEST_CH2() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_CONF0_CH2_INDSCR_BURST_EN_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_CONF0_CH2_INDSCR_BURST_EN_CH2() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_CONF0_CH2_IN_DATA_BURST_EN_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_CONF0_CH2_IN_DATA_BURST_EN_CH2() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_CONF0_CH2_MEM_TRANS_EN_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_CONF0_CH2_MEM_TRANS_EN_CH2() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x10) >> 4
}

// DMA.IN_CONF1_CH2: DMA_IN_CONF1_CH2_REG.
func (o *DMA_Type) SetIN_CONF1_CH2_IN_CHECK_OWNER_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH2.Reg, volatile.LoadUint32(&o.IN_CONF1_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_CONF1_CH2_IN_CHECK_OWNER_CH2() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH2.Reg) & 0x1000) >> 12
}

// DMA.INFIFO_STATUS_CH2: DMA_INFIFO_STATUS_CH2_REG.
func (o *DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_FULL_CH2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_FULL_CH2() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_EMPTY_CH2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_EMPTY_CH2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_CNT_CH2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0xfc)|value<<2)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_CNT_CH2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0xfc) >> 2
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_1B_CH2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_1B_CH2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_2B_CH2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_2B_CH2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_3B_CH2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_3B_CH2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_4B_CH2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_4B_CH2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_IN_BUF_HUNGRY_CH2(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_IN_BUF_HUNGRY_CH2() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x8000000) >> 27
}

// DMA.IN_POP_CH2: DMA_IN_POP_CH2_REG.
func (o *DMA_Type) SetIN_POP_CH2_INFIFO_RDATA_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH2.Reg, volatile.LoadUint32(&o.IN_POP_CH2.Reg)&^(0xfff)|value)
}
func (o *DMA_Type) GetIN_POP_CH2_INFIFO_RDATA_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_POP_CH2.Reg) & 0xfff
}
func (o *DMA_Type) SetIN_POP_CH2_INFIFO_POP_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH2.Reg, volatile.LoadUint32(&o.IN_POP_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_POP_CH2_INFIFO_POP_CH2() uint32 {
	return (volatile.LoadUint32(&o.IN_POP_CH2.Reg) & 0x1000) >> 12
}

// DMA.IN_LINK_CH2: DMA_IN_LINK_CH2_REG.
func (o *DMA_Type) SetIN_LINK_CH2_INLINK_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetIN_LINK_CH2_INLINK_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0xfffff
}
func (o *DMA_Type) SetIN_LINK_CH2_INLINK_AUTO_RET_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetIN_LINK_CH2_INLINK_AUTO_RET_CH2() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetIN_LINK_CH2_INLINK_STOP_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetIN_LINK_CH2_INLINK_STOP_CH2() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetIN_LINK_CH2_INLINK_START_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetIN_LINK_CH2_INLINK_START_CH2() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetIN_LINK_CH2_INLINK_RESTART_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetIN_LINK_CH2_INLINK_RESTART_CH2() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetIN_LINK_CH2_INLINK_PARK_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetIN_LINK_CH2_INLINK_PARK_CH2() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x1000000) >> 24
}

// DMA.IN_STATE_CH2: DMA_IN_STATE_CH2_REG.
func (o *DMA_Type) SetIN_STATE_CH2_INLINK_DSCR_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH2.Reg, volatile.LoadUint32(&o.IN_STATE_CH2.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetIN_STATE_CH2_INLINK_DSCR_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_STATE_CH2.Reg) & 0x3ffff
}
func (o *DMA_Type) SetIN_STATE_CH2_IN_DSCR_STATE_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH2.Reg, volatile.LoadUint32(&o.IN_STATE_CH2.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetIN_STATE_CH2_IN_DSCR_STATE_CH2() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH2.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetIN_STATE_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH2.Reg, volatile.LoadUint32(&o.IN_STATE_CH2.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetIN_STATE_CH2() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH2.Reg) & 0x700000) >> 20
}

// DMA.IN_SUC_EOF_DES_ADDR_CH2: DMA_IN_SUC_EOF_DES_ADDR_CH2_REG.
func (o *DMA_Type) SetIN_SUC_EOF_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_SUC_EOF_DES_ADDR_CH2.Reg, value)
}
func (o *DMA_Type) GetIN_SUC_EOF_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_SUC_EOF_DES_ADDR_CH2.Reg)
}

// DMA.IN_ERR_EOF_DES_ADDR_CH2: DMA_IN_ERR_EOF_DES_ADDR_CH2_REG.
func (o *DMA_Type) SetIN_ERR_EOF_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_ERR_EOF_DES_ADDR_CH2.Reg, value)
}
func (o *DMA_Type) GetIN_ERR_EOF_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_ERR_EOF_DES_ADDR_CH2.Reg)
}

// DMA.IN_DSCR_CH2: DMA_IN_DSCR_CH2_REG.
func (o *DMA_Type) SetIN_DSCR_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_CH2.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_CH2.Reg)
}

// DMA.IN_DSCR_BF0_CH2: DMA_IN_DSCR_BF0_CH2_REG.
func (o *DMA_Type) SetIN_DSCR_BF0_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF0_CH2.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF0_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF0_CH2.Reg)
}

// DMA.IN_DSCR_BF1_CH2: DMA_IN_DSCR_BF1_CH2_REG.
func (o *DMA_Type) SetIN_DSCR_BF1_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF1_CH2.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF1_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF1_CH2.Reg)
}

// DMA.IN_PRI_CH2: DMA_IN_PRI_CH2_REG.
func (o *DMA_Type) SetIN_PRI_CH2_RX_PRI_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH2.Reg, volatile.LoadUint32(&o.IN_PRI_CH2.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetIN_PRI_CH2_RX_PRI_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_PRI_CH2.Reg) & 0xf
}

// DMA.IN_PERI_SEL_CH2: DMA_IN_PERI_SEL_CH2_REG.
func (o *DMA_Type) SetIN_PERI_SEL_CH2_PERI_IN_SEL_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_PERI_SEL_CH2.Reg, volatile.LoadUint32(&o.IN_PERI_SEL_CH2.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetIN_PERI_SEL_CH2_PERI_IN_SEL_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_PERI_SEL_CH2.Reg) & 0x3f
}

// DMA.OUT_CONF0_CH2: DMA_OUT_CONF0_CH2_REG.
func (o *DMA_Type) SetOUT_CONF0_CH2_OUT_RST_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUT_RST_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_CONF0_CH2_OUT_LOOP_TEST_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUT_LOOP_TEST_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_CONF0_CH2_OUT_AUTO_WRBACK_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUT_AUTO_WRBACK_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_CONF0_CH2_OUT_EOF_MODE_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUT_EOF_MODE_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_CONF0_CH2_OUTDSCR_BURST_EN_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUTDSCR_BURST_EN_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_CONF0_CH2_OUT_DATA_BURST_EN_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUT_DATA_BURST_EN_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x20) >> 5
}

// DMA.OUT_CONF1_CH2: DMA_OUT_CONF1_CH2_REG.
func (o *DMA_Type) SetOUT_CONF1_CH2_OUT_CHECK_OWNER_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetOUT_CONF1_CH2_OUT_CHECK_OWNER_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH2.Reg) & 0x1000) >> 12
}

// DMA.OUTFIFO_STATUS_CH2: DMA_OUTFIFO_STATUS_CH2_REG.
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_FULL_CH2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_FULL_CH2() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_EMPTY_CH2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_EMPTY_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_CNT_CH2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0xfc)|value<<2)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_CNT_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0xfc) >> 2
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_1B_CH2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_1B_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_2B_CH2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_2B_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_3B_CH2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_3B_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_4B_CH2(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_4B_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x4000000) >> 26
}

// DMA.OUT_PUSH_CH2: DMA_OUT_PUSH_CH2_REG.
func (o *DMA_Type) SetOUT_PUSH_CH2_OUTFIFO_WDATA_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH2.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg)&^(0x1ff)|value)
}
func (o *DMA_Type) GetOUT_PUSH_CH2_OUTFIFO_WDATA_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg) & 0x1ff
}
func (o *DMA_Type) SetOUT_PUSH_CH2_OUTFIFO_PUSH_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH2.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetOUT_PUSH_CH2_OUTFIFO_PUSH_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg) & 0x200) >> 9
}

// DMA.OUT_LINK_CH2: DMA_OUT_LINK_CH2_REG.
func (o *DMA_Type) SetOUT_LINK_CH2_OUTLINK_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetOUT_LINK_CH2_OUTLINK_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0xfffff
}
func (o *DMA_Type) SetOUT_LINK_CH2_OUTLINK_STOP_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetOUT_LINK_CH2_OUTLINK_STOP_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetOUT_LINK_CH2_OUTLINK_START_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetOUT_LINK_CH2_OUTLINK_START_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetOUT_LINK_CH2_OUTLINK_RESTART_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetOUT_LINK_CH2_OUTLINK_RESTART_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetOUT_LINK_CH2_OUTLINK_PARK_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUT_LINK_CH2_OUTLINK_PARK_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0x800000) >> 23
}

// DMA.OUT_STATE_CH2: DMA_OUT_STATE_CH2_REG.
func (o *DMA_Type) SetOUT_STATE_CH2_OUTLINK_DSCR_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH2.Reg, volatile.LoadUint32(&o.OUT_STATE_CH2.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetOUT_STATE_CH2_OUTLINK_DSCR_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_STATE_CH2.Reg) & 0x3ffff
}
func (o *DMA_Type) SetOUT_STATE_CH2_OUT_DSCR_STATE_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH2.Reg, volatile.LoadUint32(&o.OUT_STATE_CH2.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetOUT_STATE_CH2_OUT_DSCR_STATE_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH2.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetOUT_STATE_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH2.Reg, volatile.LoadUint32(&o.OUT_STATE_CH2.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetOUT_STATE_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH2.Reg) & 0x700000) >> 20
}

// DMA.OUT_EOF_DES_ADDR_CH2: DMA_OUT_EOF_DES_ADDR_CH2_REG.
func (o *DMA_Type) SetOUT_EOF_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR_CH2.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR_CH2.Reg)
}

// DMA.OUT_EOF_BFR_DES_ADDR_CH2: DMA_OUT_EOF_BFR_DES_ADDR_CH2_REG.
func (o *DMA_Type) SetOUT_EOF_BFR_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR_CH2.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_BFR_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR_CH2.Reg)
}

// DMA.OUT_DSCR_CH2: DMA_OUT_DSCR_CH2_REG.
func (o *DMA_Type) SetOUT_DSCR_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_CH2.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_CH2.Reg)
}

// DMA.OUT_DSCR_BF0_CH2: DMA_OUT_DSCR_BF0_CH2_REG.
func (o *DMA_Type) SetOUT_DSCR_BF0_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF0_CH2.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF0_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF0_CH2.Reg)
}

// DMA.OUT_DSCR_BF1_CH2: DMA_OUT_DSCR_BF1_CH2_REG.
func (o *DMA_Type) SetOUT_DSCR_BF1_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF1_CH2.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF1_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF1_CH2.Reg)
}

// DMA.OUT_PRI_CH2: DMA_OUT_PRI_CH2_REG.
func (o *DMA_Type) SetOUT_PRI_CH2_TX_PRI_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH2.Reg, volatile.LoadUint32(&o.OUT_PRI_CH2.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetOUT_PRI_CH2_TX_PRI_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_PRI_CH2.Reg) & 0xf
}

// DMA.OUT_PERI_SEL_CH2: DMA_OUT_PERI_SEL_CH2_REG.
func (o *DMA_Type) SetOUT_PERI_SEL_CH2_PERI_OUT_SEL_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_PERI_SEL_CH2.Reg, volatile.LoadUint32(&o.OUT_PERI_SEL_CH2.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetOUT_PERI_SEL_CH2_PERI_OUT_SEL_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_PERI_SEL_CH2.Reg) & 0x3f
}

// Peripheral DS
type DS_Type struct {
	Y_MEM           volatile.Register32 // 0x0
	_               [508]byte
	M_MEM           volatile.Register32 // 0x200
	_               [508]byte
	RB_MEM          volatile.Register32 // 0x400
	_               [508]byte
	BOX_MEM         volatile.Register32 // 0x600
	_               [508]byte
	X_MEM           volatile.Register32 // 0x800
	_               [508]byte
	Z_MEM           volatile.Register32 // 0xA00
	_               [1020]byte
	SET_START       volatile.Register32 // 0xE00
	SET_CONTINUE    volatile.Register32 // 0xE04
	SET_FINISH      volatile.Register32 // 0xE08
	QUERY_BUSY      volatile.Register32 // 0xE0C
	QUERY_KEY_WRONG volatile.Register32 // 0xE10
	QUERY_CHECK     volatile.Register32 // 0xE14
	_               [8]byte
	DATE            volatile.Register32 // 0xE20
}

// DS.SET_START: DS start control register
func (o *DS_Type) SetSET_START(value uint32) {
	volatile.StoreUint32(&o.SET_START.Reg, volatile.LoadUint32(&o.SET_START.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetSET_START() uint32 {
	return volatile.LoadUint32(&o.SET_START.Reg) & 0x1
}

// DS.SET_CONTINUE: DS continue control register
func (o *DS_Type) SetSET_CONTINUE(value uint32) {
	volatile.StoreUint32(&o.SET_CONTINUE.Reg, volatile.LoadUint32(&o.SET_CONTINUE.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetSET_CONTINUE() uint32 {
	return volatile.LoadUint32(&o.SET_CONTINUE.Reg) & 0x1
}

// DS.SET_FINISH: DS finish control register
func (o *DS_Type) SetSET_FINISH(value uint32) {
	volatile.StoreUint32(&o.SET_FINISH.Reg, volatile.LoadUint32(&o.SET_FINISH.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetSET_FINISH() uint32 {
	return volatile.LoadUint32(&o.SET_FINISH.Reg) & 0x1
}

// DS.QUERY_BUSY: DS query busy register
func (o *DS_Type) SetQUERY_BUSY(value uint32) {
	volatile.StoreUint32(&o.QUERY_BUSY.Reg, volatile.LoadUint32(&o.QUERY_BUSY.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetQUERY_BUSY() uint32 {
	return volatile.LoadUint32(&o.QUERY_BUSY.Reg) & 0x1
}

// DS.QUERY_KEY_WRONG: DS query key-wrong counter register
func (o *DS_Type) SetQUERY_KEY_WRONG(value uint32) {
	volatile.StoreUint32(&o.QUERY_KEY_WRONG.Reg, volatile.LoadUint32(&o.QUERY_KEY_WRONG.Reg)&^(0xf)|value)
}
func (o *DS_Type) GetQUERY_KEY_WRONG() uint32 {
	return volatile.LoadUint32(&o.QUERY_KEY_WRONG.Reg) & 0xf
}

// DS.QUERY_CHECK: DS query check result register
func (o *DS_Type) SetQUERY_CHECK_MD_ERROR(value uint32) {
	volatile.StoreUint32(&o.QUERY_CHECK.Reg, volatile.LoadUint32(&o.QUERY_CHECK.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetQUERY_CHECK_MD_ERROR() uint32 {
	return volatile.LoadUint32(&o.QUERY_CHECK.Reg) & 0x1
}
func (o *DS_Type) SetQUERY_CHECK_PADDING_BAD(value uint32) {
	volatile.StoreUint32(&o.QUERY_CHECK.Reg, volatile.LoadUint32(&o.QUERY_CHECK.Reg)&^(0x2)|value<<1)
}
func (o *DS_Type) GetQUERY_CHECK_PADDING_BAD() uint32 {
	return (volatile.LoadUint32(&o.QUERY_CHECK.Reg) & 0x2) >> 1
}

// DS.DATE: DS version control register
func (o *DS_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x3fffffff)|value)
}
func (o *DS_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x3fffffff
}

// Peripheral EFUSE
type EFUSE_Type struct {
	PGM_DATA0          volatile.Register32 // 0x0
	PGM_DATA1          volatile.Register32 // 0x4
	PGM_DATA2          volatile.Register32 // 0x8
	PGM_DATA3          volatile.Register32 // 0xC
	PGM_DATA4          volatile.Register32 // 0x10
	PGM_DATA5          volatile.Register32 // 0x14
	PGM_DATA6          volatile.Register32 // 0x18
	PGM_DATA7          volatile.Register32 // 0x1C
	PGM_CHECK_VALUE0   volatile.Register32 // 0x20
	PGM_CHECK_VALUE1   volatile.Register32 // 0x24
	PGM_CHECK_VALUE2   volatile.Register32 // 0x28
	RD_WR_DIS          volatile.Register32 // 0x2C
	RD_REPEAT_DATA0    volatile.Register32 // 0x30
	RD_REPEAT_DATA1    volatile.Register32 // 0x34
	RD_REPEAT_DATA2    volatile.Register32 // 0x38
	RD_REPEAT_DATA3    volatile.Register32 // 0x3C
	RD_REPEAT_DATA4    volatile.Register32 // 0x40
	RD_MAC_SPI_SYS_0   volatile.Register32 // 0x44
	RD_MAC_SPI_SYS_1   volatile.Register32 // 0x48
	RD_MAC_SPI_SYS_2   volatile.Register32 // 0x4C
	RD_MAC_SPI_SYS_3   volatile.Register32 // 0x50
	RD_MAC_SPI_SYS_4   volatile.Register32 // 0x54
	RD_MAC_SPI_SYS_5   volatile.Register32 // 0x58
	RD_SYS_PART1_DATA0 volatile.Register32 // 0x5C
	RD_SYS_PART1_DATA1 volatile.Register32 // 0x60
	RD_SYS_PART1_DATA2 volatile.Register32 // 0x64
	RD_SYS_PART1_DATA3 volatile.Register32 // 0x68
	RD_SYS_PART1_DATA4 volatile.Register32 // 0x6C
	RD_SYS_PART1_DATA5 volatile.Register32 // 0x70
	RD_SYS_PART1_DATA6 volatile.Register32 // 0x74
	RD_SYS_PART1_DATA7 volatile.Register32 // 0x78
	RD_USR_DATA0       volatile.Register32 // 0x7C
	RD_USR_DATA1       volatile.Register32 // 0x80
	RD_USR_DATA2       volatile.Register32 // 0x84
	RD_USR_DATA3       volatile.Register32 // 0x88
	RD_USR_DATA4       volatile.Register32 // 0x8C
	RD_USR_DATA5       volatile.Register32 // 0x90
	RD_USR_DATA6       volatile.Register32 // 0x94
	RD_USR_DATA7       volatile.Register32 // 0x98
	RD_KEY0_DATA0      volatile.Register32 // 0x9C
	RD_KEY0_DATA1      volatile.Register32 // 0xA0
	RD_KEY0_DATA2      volatile.Register32 // 0xA4
	RD_KEY0_DATA3      volatile.Register32 // 0xA8
	RD_KEY0_DATA4      volatile.Register32 // 0xAC
	RD_KEY0_DATA5      volatile.Register32 // 0xB0
	RD_KEY0_DATA6      volatile.Register32 // 0xB4
	RD_KEY0_DATA7      volatile.Register32 // 0xB8
	RD_KEY1_DATA0      volatile.Register32 // 0xBC
	RD_KEY1_DATA1      volatile.Register32 // 0xC0
	RD_KEY1_DATA2      volatile.Register32 // 0xC4
	RD_KEY1_DATA3      volatile.Register32 // 0xC8
	RD_KEY1_DATA4      volatile.Register32 // 0xCC
	RD_KEY1_DATA5      volatile.Register32 // 0xD0
	RD_KEY1_DATA6      volatile.Register32 // 0xD4
	RD_KEY1_DATA7      volatile.Register32 // 0xD8
	RD_KEY2_DATA0      volatile.Register32 // 0xDC
	RD_KEY2_DATA1      volatile.Register32 // 0xE0
	RD_KEY2_DATA2      volatile.Register32 // 0xE4
	RD_KEY2_DATA3      volatile.Register32 // 0xE8
	RD_KEY2_DATA4      volatile.Register32 // 0xEC
	RD_KEY2_DATA5      volatile.Register32 // 0xF0
	RD_KEY2_DATA6      volatile.Register32 // 0xF4
	RD_KEY2_DATA7      volatile.Register32 // 0xF8
	RD_KEY3_DATA0      volatile.Register32 // 0xFC
	RD_KEY3_DATA1      volatile.Register32 // 0x100
	RD_KEY3_DATA2      volatile.Register32 // 0x104
	RD_KEY3_DATA3      volatile.Register32 // 0x108
	RD_KEY3_DATA4      volatile.Register32 // 0x10C
	RD_KEY3_DATA5      volatile.Register32 // 0x110
	RD_KEY3_DATA6      volatile.Register32 // 0x114
	RD_KEY3_DATA7      volatile.Register32 // 0x118
	RD_KEY4_DATA0      volatile.Register32 // 0x11C
	RD_KEY4_DATA1      volatile.Register32 // 0x120
	RD_KEY4_DATA2      volatile.Register32 // 0x124
	RD_KEY4_DATA3      volatile.Register32 // 0x128
	RD_KEY4_DATA4      volatile.Register32 // 0x12C
	RD_KEY4_DATA5      volatile.Register32 // 0x130
	RD_KEY4_DATA6      volatile.Register32 // 0x134
	RD_KEY4_DATA7      volatile.Register32 // 0x138
	RD_KEY5_DATA0      volatile.Register32 // 0x13C
	RD_KEY5_DATA1      volatile.Register32 // 0x140
	RD_KEY5_DATA2      volatile.Register32 // 0x144
	RD_KEY5_DATA3      volatile.Register32 // 0x148
	RD_KEY5_DATA4      volatile.Register32 // 0x14C
	RD_KEY5_DATA5      volatile.Register32 // 0x150
	RD_KEY5_DATA6      volatile.Register32 // 0x154
	RD_KEY5_DATA7      volatile.Register32 // 0x158
	RD_SYS_PART2_DATA0 volatile.Register32 // 0x15C
	RD_SYS_PART2_DATA1 volatile.Register32 // 0x160
	RD_SYS_PART2_DATA2 volatile.Register32 // 0x164
	RD_SYS_PART2_DATA3 volatile.Register32 // 0x168
	RD_SYS_PART2_DATA4 volatile.Register32 // 0x16C
	RD_SYS_PART2_DATA5 volatile.Register32 // 0x170
	RD_SYS_PART2_DATA6 volatile.Register32 // 0x174
	RD_SYS_PART2_DATA7 volatile.Register32 // 0x178
	RD_REPEAT_ERR0     volatile.Register32 // 0x17C
	RD_REPEAT_ERR1     volatile.Register32 // 0x180
	RD_REPEAT_ERR2     volatile.Register32 // 0x184
	RD_REPEAT_ERR3     volatile.Register32 // 0x188
	_                  [4]byte
	RD_REPEAT_ERR4     volatile.Register32 // 0x190
	_                  [44]byte
	RD_RS_ERR0         volatile.Register32 // 0x1C0
	RD_RS_ERR1         volatile.Register32 // 0x1C4
	CLK                volatile.Register32 // 0x1C8
	CONF               volatile.Register32 // 0x1CC
	STATUS             volatile.Register32 // 0x1D0
	CMD                volatile.Register32 // 0x1D4
	INT_RAW            volatile.Register32 // 0x1D8
	INT_ST             volatile.Register32 // 0x1DC
	INT_ENA            volatile.Register32 // 0x1E0
	INT_CLR            volatile.Register32 // 0x1E4
	DAC_CONF           volatile.Register32 // 0x1E8
	RD_TIM_CONF        volatile.Register32 // 0x1EC
	WR_TIM_CONF1       volatile.Register32 // 0x1F0
	WR_TIM_CONF2       volatile.Register32 // 0x1F4
	_                  [4]byte
	DATE               volatile.Register32 // 0x1FC
}

// EFUSE.PGM_DATA0: Register 0 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA0(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA0() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA0.Reg)
}

// EFUSE.PGM_DATA1: Register 1 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA1(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA1() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA1.Reg)
}

// EFUSE.PGM_DATA2: Register 2 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA2(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA2() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA2.Reg)
}

// EFUSE.PGM_DATA3: Register 3 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA3(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA3() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA3.Reg)
}

// EFUSE.PGM_DATA4: Register 4 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA4(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA4() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA4.Reg)
}

// EFUSE.PGM_DATA5: Register 5 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA5(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA5() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA5.Reg)
}

// EFUSE.PGM_DATA6: Register 6 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA6(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA6() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA6.Reg)
}

// EFUSE.PGM_DATA7: Register 7 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA7(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA7() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA7.Reg)
}

// EFUSE.PGM_CHECK_VALUE0: Register 0 that stores the RS code to be programmed.
func (o *EFUSE_Type) SetPGM_CHECK_VALUE0(value uint32) {
	volatile.StoreUint32(&o.PGM_CHECK_VALUE0.Reg, value)
}
func (o *EFUSE_Type) GetPGM_CHECK_VALUE0() uint32 {
	return volatile.LoadUint32(&o.PGM_CHECK_VALUE0.Reg)
}

// EFUSE.PGM_CHECK_VALUE1: Register 1 that stores the RS code to be programmed.
func (o *EFUSE_Type) SetPGM_CHECK_VALUE1(value uint32) {
	volatile.StoreUint32(&o.PGM_CHECK_VALUE1.Reg, value)
}
func (o *EFUSE_Type) GetPGM_CHECK_VALUE1() uint32 {
	return volatile.LoadUint32(&o.PGM_CHECK_VALUE1.Reg)
}

// EFUSE.PGM_CHECK_VALUE2: Register 2 that stores the RS code to be programmed.
func (o *EFUSE_Type) SetPGM_CHECK_VALUE2(value uint32) {
	volatile.StoreUint32(&o.PGM_CHECK_VALUE2.Reg, value)
}
func (o *EFUSE_Type) GetPGM_CHECK_VALUE2() uint32 {
	return volatile.LoadUint32(&o.PGM_CHECK_VALUE2.Reg)
}

// EFUSE.RD_WR_DIS: BLOCK0 data register 0.
func (o *EFUSE_Type) SetRD_WR_DIS(value uint32) {
	volatile.StoreUint32(&o.RD_WR_DIS.Reg, value)
}
func (o *EFUSE_Type) GetRD_WR_DIS() uint32 {
	return volatile.LoadUint32(&o.RD_WR_DIS.Reg)
}

// EFUSE.RD_REPEAT_DATA0: BLOCK0 data register 1.
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_RD_DIS(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x7f)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_RD_DIS() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x7f
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_RTC_RAM_BOOT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_RTC_RAM_BOOT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_ICACHE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_ICACHE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_USB_JTAG(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_USB_JTAG() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_DOWNLOAD_ICACHE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x400)|value<<10)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_DOWNLOAD_ICACHE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x400) >> 10
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_USB_DEVICE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x800)|value<<11)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_USB_DEVICE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x800) >> 11
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_FORCE_DOWNLOAD(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x1000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_FORCE_DOWNLOAD() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x1000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_RPT4_RESERVED6(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_RPT4_RESERVED6() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_CAN(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x4000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_CAN() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x4000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_JTAG_SEL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x8000)|value<<15)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_JTAG_SEL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x8000) >> 15
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_SOFT_DIS_JTAG(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x70000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_SOFT_DIS_JTAG() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x70000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_PAD_JTAG(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x80000)|value<<19)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_PAD_JTAG() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x80000) >> 19
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_DOWNLOAD_MANUAL_ENCRYPT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x100000)|value<<20)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_DOWNLOAD_MANUAL_ENCRYPT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x100000) >> 20
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_USB_DREFH(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x600000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_USB_DREFH() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x600000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_USB_DREFL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x1800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_USB_DREFL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x1800000) >> 23
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_USB_EXCHG_PINS(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x2000000)|value<<25)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_USB_EXCHG_PINS() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x2000000) >> 25
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_VDD_SPI_AS_GPIO(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x4000000)|value<<26)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_VDD_SPI_AS_GPIO() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x4000000) >> 26
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_BTLC_GPIO_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x18000000)|value<<27)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_BTLC_GPIO_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x18000000) >> 27
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_POWERGLITCH_EN(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x20000000)|value<<29)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_POWERGLITCH_EN() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x20000000) >> 29
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_POWER_GLITCH_DSENSE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0xc0000000)|value<<30)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_POWER_GLITCH_DSENSE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0xc0000000) >> 30
}

// EFUSE.RD_REPEAT_DATA1: BLOCK0 data register 2.
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_RPT4_RESERVED2(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_RPT4_RESERVED2() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0xffff
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_WDT_DELAY_SEL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x30000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_WDT_DELAY_SEL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x30000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_SPI_BOOT_CRYPT_CNT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x1c0000)|value<<18)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_SPI_BOOT_CRYPT_CNT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x1c0000) >> 18
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x400000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE1() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x400000) >> 22
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE2(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE2() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x800000) >> 23
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_KEY_PURPOSE_0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0xf000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_KEY_PURPOSE_0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0xf000000) >> 24
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_KEY_PURPOSE_1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_KEY_PURPOSE_1() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0xf0000000) >> 28
}

// EFUSE.RD_REPEAT_DATA2: BLOCK0 data register 3.
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_KEY_PURPOSE_2(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_KEY_PURPOSE_2() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_KEY_PURPOSE_3(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf0)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_KEY_PURPOSE_3() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf0) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_KEY_PURPOSE_4(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf00)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_KEY_PURPOSE_4() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf00) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_KEY_PURPOSE_5(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_KEY_PURPOSE_5() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_RPT4_RESERVED3(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf0000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_RPT4_RESERVED3() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf0000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_SECURE_BOOT_EN(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0x100000)|value<<20)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_SECURE_BOOT_EN() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0x100000) >> 20
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_SECURE_BOOT_AGGRESSIVE_REVOKE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_SECURE_BOOT_AGGRESSIVE_REVOKE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_RPT4_RESERVED0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xfc00000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_RPT4_RESERVED0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xfc00000) >> 22
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_FLASH_TPUW(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_FLASH_TPUW() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf0000000) >> 28
}

// EFUSE.RD_REPEAT_DATA3: BLOCK0 data register 4.
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_DIS_DOWNLOAD_MODE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_DIS_DOWNLOAD_MODE() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x1
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_DIS_LEGACY_SPI_BOOT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_DIS_LEGACY_SPI_BOOT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_UART_PRINT_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x4)|value<<2)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_UART_PRINT_CHANNEL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x4) >> 2
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_FLASH_ECC_MODE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_FLASH_ECC_MODE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_DIS_USB_DOWNLOAD_MODE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_DIS_USB_DOWNLOAD_MODE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_ENABLE_SECURITY_DOWNLOAD(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_ENABLE_SECURITY_DOWNLOAD() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_UART_PRINT_CONTROL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0xc0)|value<<6)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_UART_PRINT_CONTROL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0xc0) >> 6
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_PIN_POWER_SELECTION(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_PIN_POWER_SELECTION() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_FLASH_TYPE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_FLASH_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_FLASH_PAGE_SIZE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0xc00)|value<<10)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_FLASH_PAGE_SIZE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0xc00) >> 10
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_FLASH_ECC_EN(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x1000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_FLASH_ECC_EN() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x1000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_FORCE_SEND_RESUME(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_FORCE_SEND_RESUME() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_SECURE_VERSION(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x3fffc000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_SECURE_VERSION() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x3fffc000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_RPT4_RESERVED1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0xc0000000)|value<<30)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_RPT4_RESERVED1() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0xc0000000) >> 30
}

// EFUSE.RD_REPEAT_DATA4: BLOCK0 data register 5.
func (o *EFUSE_Type) SetRD_REPEAT_DATA4_RPT4_RESERVED4(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA4.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA4.Reg)&^(0xffffff)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA4_RPT4_RESERVED4() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA4.Reg) & 0xffffff
}

// EFUSE.RD_MAC_SPI_SYS_0: BLOCK1 data register 0.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_0(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_0.Reg, value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_0() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_0.Reg)
}

// EFUSE.RD_MAC_SPI_SYS_1: BLOCK1 data register 1.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_1_MAC_1(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_1.Reg, volatile.LoadUint32(&o.RD_MAC_SPI_SYS_1.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_1_MAC_1() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_1.Reg) & 0xffff
}
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_1_SPI_PAD_CONF_0(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_1.Reg, volatile.LoadUint32(&o.RD_MAC_SPI_SYS_1.Reg)&^(0xffff0000)|value<<16)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_1_SPI_PAD_CONF_0() uint32 {
	return (volatile.LoadUint32(&o.RD_MAC_SPI_SYS_1.Reg) & 0xffff0000) >> 16
}

// EFUSE.RD_MAC_SPI_SYS_2: BLOCK1 data register 2.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_2(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_2.Reg, value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_2() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_2.Reg)
}

// EFUSE.RD_MAC_SPI_SYS_3: BLOCK1 data register 3.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_3_SPI_PAD_CONF_2(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_3.Reg, volatile.LoadUint32(&o.RD_MAC_SPI_SYS_3.Reg)&^(0x3ffff)|value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_3_SPI_PAD_CONF_2() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_3.Reg) & 0x3ffff
}
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_3_SYS_DATA_PART0_0(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_3.Reg, volatile.LoadUint32(&o.RD_MAC_SPI_SYS_3.Reg)&^(0xfffc0000)|value<<18)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_3_SYS_DATA_PART0_0() uint32 {
	return (volatile.LoadUint32(&o.RD_MAC_SPI_SYS_3.Reg) & 0xfffc0000) >> 18
}

// EFUSE.RD_MAC_SPI_SYS_4: BLOCK1 data register 4.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_4(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_4.Reg, value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_4() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_4.Reg)
}

// EFUSE.RD_MAC_SPI_SYS_5: BLOCK1 data register 5.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_5(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_5.Reg, value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_5() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_5.Reg)
}

// EFUSE.RD_SYS_PART1_DATA0: Register 0 of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA0.Reg)
}

// EFUSE.RD_SYS_PART1_DATA1: Register 1 of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA1.Reg)
}

// EFUSE.RD_SYS_PART1_DATA2: Register 2 of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA2.Reg)
}

// EFUSE.RD_SYS_PART1_DATA3: Register 3 of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA3.Reg)
}

// EFUSE.RD_SYS_PART1_DATA4: Register 4 of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA4.Reg)
}

// EFUSE.RD_SYS_PART1_DATA5: Register 5 of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA5.Reg)
}

// EFUSE.RD_SYS_PART1_DATA6: Register 6 of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA6.Reg)
}

// EFUSE.RD_SYS_PART1_DATA7: Register 7 of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA7.Reg)
}

// EFUSE.RD_USR_DATA0: Register 0 of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA0.Reg)
}

// EFUSE.RD_USR_DATA1: Register 1 of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA1.Reg)
}

// EFUSE.RD_USR_DATA2: Register 2 of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA2.Reg)
}

// EFUSE.RD_USR_DATA3: Register 3 of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA3.Reg)
}

// EFUSE.RD_USR_DATA4: Register 4 of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA4.Reg)
}

// EFUSE.RD_USR_DATA5: Register 5 of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA5.Reg)
}

// EFUSE.RD_USR_DATA6: Register 6 of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA6.Reg)
}

// EFUSE.RD_USR_DATA7: Register 7 of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA7.Reg)
}

// EFUSE.RD_KEY0_DATA0: Register 0 of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA0.Reg)
}

// EFUSE.RD_KEY0_DATA1: Register 1 of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA1.Reg)
}

// EFUSE.RD_KEY0_DATA2: Register 2 of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA2.Reg)
}

// EFUSE.RD_KEY0_DATA3: Register 3 of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA3.Reg)
}

// EFUSE.RD_KEY0_DATA4: Register 4 of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA4.Reg)
}

// EFUSE.RD_KEY0_DATA5: Register 5 of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA5.Reg)
}

// EFUSE.RD_KEY0_DATA6: Register 6 of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA6.Reg)
}

// EFUSE.RD_KEY0_DATA7: Register 7 of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA7.Reg)
}

// EFUSE.RD_KEY1_DATA0: Register 0 of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA0.Reg)
}

// EFUSE.RD_KEY1_DATA1: Register 1 of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA1.Reg)
}

// EFUSE.RD_KEY1_DATA2: Register 2 of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA2.Reg)
}

// EFUSE.RD_KEY1_DATA3: Register 3 of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA3.Reg)
}

// EFUSE.RD_KEY1_DATA4: Register 4 of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA4.Reg)
}

// EFUSE.RD_KEY1_DATA5: Register 5 of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA5.Reg)
}

// EFUSE.RD_KEY1_DATA6: Register 6 of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA6.Reg)
}

// EFUSE.RD_KEY1_DATA7: Register 7 of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA7.Reg)
}

// EFUSE.RD_KEY2_DATA0: Register 0 of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA0.Reg)
}

// EFUSE.RD_KEY2_DATA1: Register 1 of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA1.Reg)
}

// EFUSE.RD_KEY2_DATA2: Register 2 of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA2.Reg)
}

// EFUSE.RD_KEY2_DATA3: Register 3 of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA3.Reg)
}

// EFUSE.RD_KEY2_DATA4: Register 4 of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA4.Reg)
}

// EFUSE.RD_KEY2_DATA5: Register 5 of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA5.Reg)
}

// EFUSE.RD_KEY2_DATA6: Register 6 of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA6.Reg)
}

// EFUSE.RD_KEY2_DATA7: Register 7 of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA7.Reg)
}

// EFUSE.RD_KEY3_DATA0: Register 0 of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA0.Reg)
}

// EFUSE.RD_KEY3_DATA1: Register 1 of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA1.Reg)
}

// EFUSE.RD_KEY3_DATA2: Register 2 of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA2.Reg)
}

// EFUSE.RD_KEY3_DATA3: Register 3 of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA3.Reg)
}

// EFUSE.RD_KEY3_DATA4: Register 4 of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA4.Reg)
}

// EFUSE.RD_KEY3_DATA5: Register 5 of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA5.Reg)
}

// EFUSE.RD_KEY3_DATA6: Register 6 of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA6.Reg)
}

// EFUSE.RD_KEY3_DATA7: Register 7 of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA7.Reg)
}

// EFUSE.RD_KEY4_DATA0: Register 0 of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA0.Reg)
}

// EFUSE.RD_KEY4_DATA1: Register 1 of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA1.Reg)
}

// EFUSE.RD_KEY4_DATA2: Register 2 of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA2.Reg)
}

// EFUSE.RD_KEY4_DATA3: Register 3 of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA3.Reg)
}

// EFUSE.RD_KEY4_DATA4: Register 4 of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA4.Reg)
}

// EFUSE.RD_KEY4_DATA5: Register 5 of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA5.Reg)
}

// EFUSE.RD_KEY4_DATA6: Register 6 of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA6.Reg)
}

// EFUSE.RD_KEY4_DATA7: Register 7 of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA7.Reg)
}

// EFUSE.RD_KEY5_DATA0: Register 0 of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA0.Reg)
}

// EFUSE.RD_KEY5_DATA1: Register 1 of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA1.Reg)
}

// EFUSE.RD_KEY5_DATA2: Register 2 of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA2.Reg)
}

// EFUSE.RD_KEY5_DATA3: Register 3 of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA3.Reg)
}

// EFUSE.RD_KEY5_DATA4: Register 4 of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA4.Reg)
}

// EFUSE.RD_KEY5_DATA5: Register 5 of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA5.Reg)
}

// EFUSE.RD_KEY5_DATA6: Register 6 of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA6.Reg)
}

// EFUSE.RD_KEY5_DATA7: Register 7 of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA7.Reg)
}

// EFUSE.RD_SYS_PART2_DATA0: Register 0 of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA0.Reg)
}

// EFUSE.RD_SYS_PART2_DATA1: Register 1 of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA1.Reg)
}

// EFUSE.RD_SYS_PART2_DATA2: Register 2 of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA2.Reg)
}

// EFUSE.RD_SYS_PART2_DATA3: Register 3 of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA3.Reg)
}

// EFUSE.RD_SYS_PART2_DATA4: Register 4 of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA4.Reg)
}

// EFUSE.RD_SYS_PART2_DATA5: Register 5 of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA5.Reg)
}

// EFUSE.RD_SYS_PART2_DATA6: Register 6 of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA6.Reg)
}

// EFUSE.RD_SYS_PART2_DATA7: Register 7 of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA7.Reg)
}

// EFUSE.RD_REPEAT_ERR0: Programming error record register 0 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_RD_DIS_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x7f)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_RD_DIS_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x7f
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_RTC_RAM_BOOT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_RTC_RAM_BOOT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_ICACHE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_ICACHE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_USB_JTAG_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_USB_JTAG_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_DOWNLOAD_ICACHE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x400)|value<<10)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_DOWNLOAD_ICACHE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x400) >> 10
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_USB_DEVICE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x800)|value<<11)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_USB_DEVICE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x800) >> 11
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_FORCE_DOWNLOAD_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x1000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_FORCE_DOWNLOAD_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x1000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_RPT4_RESERVED6_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_RPT4_RESERVED6_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_CAN_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x4000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_CAN_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x4000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_JTAG_SEL_ENABLE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x8000)|value<<15)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_JTAG_SEL_ENABLE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x8000) >> 15
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_SOFT_DIS_JTAG_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x70000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_SOFT_DIS_JTAG_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x70000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_PAD_JTAG_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x80000)|value<<19)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_PAD_JTAG_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x80000) >> 19
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_DOWNLOAD_MANUAL_ENCRYPT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x100000)|value<<20)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_DOWNLOAD_MANUAL_ENCRYPT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x100000) >> 20
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_USB_DREFH_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x600000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_USB_DREFH_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x600000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_USB_DREFL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x1800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_USB_DREFL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x1800000) >> 23
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_USB_EXCHG_PINS_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x2000000)|value<<25)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_USB_EXCHG_PINS_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x2000000) >> 25
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_VDD_SPI_AS_GPIO_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x4000000)|value<<26)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_VDD_SPI_AS_GPIO_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x4000000) >> 26
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_BTLC_GPIO_ENABLE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x18000000)|value<<27)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_BTLC_GPIO_ENABLE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x18000000) >> 27
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_POWERGLITCH_EN_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x20000000)|value<<29)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_POWERGLITCH_EN_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x20000000) >> 29
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_POWER_GLITCH_DSENSE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0xc0000000)|value<<30)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_POWER_GLITCH_DSENSE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0xc0000000) >> 30
}

// EFUSE.RD_REPEAT_ERR1: Programming error record register 1 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_RPT4_RESERVED2_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_RPT4_RESERVED2_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0xffff
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_WDT_DELAY_SEL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x30000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_WDT_DELAY_SEL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x30000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_SPI_BOOT_CRYPT_CNT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x1c0000)|value<<18)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_SPI_BOOT_CRYPT_CNT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x1c0000) >> 18
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE0_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE0_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE1_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x400000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE1_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x400000) >> 22
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE2_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE2_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x800000) >> 23
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_KEY_PURPOSE_0_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0xf000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_KEY_PURPOSE_0_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0xf000000) >> 24
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_KEY_PURPOSE_1_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_KEY_PURPOSE_1_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0xf0000000) >> 28
}

// EFUSE.RD_REPEAT_ERR2: Programming error record register 2 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_KEY_PURPOSE_2_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_KEY_PURPOSE_2_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_KEY_PURPOSE_3_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf0)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_KEY_PURPOSE_3_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf0) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_KEY_PURPOSE_4_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf00)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_KEY_PURPOSE_4_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf00) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_KEY_PURPOSE_5_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_KEY_PURPOSE_5_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_RPT4_RESERVED3_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf0000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_RPT4_RESERVED3_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf0000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_SECURE_BOOT_EN_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0x100000)|value<<20)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_SECURE_BOOT_EN_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0x100000) >> 20
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_SECURE_BOOT_AGGRESSIVE_REVOKE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_SECURE_BOOT_AGGRESSIVE_REVOKE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_RPT4_RESERVED0_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xfc00000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_RPT4_RESERVED0_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xfc00000) >> 22
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_FLASH_TPUW_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_FLASH_TPUW_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf0000000) >> 28
}

// EFUSE.RD_REPEAT_ERR3: Programming error record register 3 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_DIS_DOWNLOAD_MODE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_DIS_DOWNLOAD_MODE_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x1
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_DIS_LEGACY_SPI_BOOT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_DIS_LEGACY_SPI_BOOT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_UART_PRINT_CHANNEL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x4)|value<<2)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_UART_PRINT_CHANNEL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x4) >> 2
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_FLASH_ECC_MODE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_FLASH_ECC_MODE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_DIS_USB_DOWNLOAD_MODE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_DIS_USB_DOWNLOAD_MODE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_ENABLE_SECURITY_DOWNLOAD_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_ENABLE_SECURITY_DOWNLOAD_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_UART_PRINT_CONTROL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0xc0)|value<<6)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_UART_PRINT_CONTROL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0xc0) >> 6
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_PIN_POWER_SELECTION_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_PIN_POWER_SELECTION_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_FLASH_TYPE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_FLASH_TYPE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_FLASH_PAGE_SIZE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0xc00)|value<<10)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_FLASH_PAGE_SIZE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0xc00) >> 10
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_FLASH_ECC_EN_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x1000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_FLASH_ECC_EN_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x1000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_FORCE_SEND_RESUME_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_FORCE_SEND_RESUME_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_SECURE_VERSION_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x3fffc000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_SECURE_VERSION_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x3fffc000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_RPT4_RESERVED1_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0xc0000000)|value<<30)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_RPT4_RESERVED1_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0xc0000000) >> 30
}

// EFUSE.RD_REPEAT_ERR4: Programming error record register 4 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR4_RPT4_RESERVED4_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR4.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR4.Reg)&^(0xffffff)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR4_RPT4_RESERVED4_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR4.Reg) & 0xffffff
}

// EFUSE.RD_RS_ERR0: Programming error record register 0 of BLOCK1-10.
func (o *EFUSE_Type) SetRD_RS_ERR0_MAC_SPI_8M_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x7)|value)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_MAC_SPI_8M_ERR_NUM() uint32 {
	return volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x7
}
func (o *EFUSE_Type) SetRD_RS_ERR0_MAC_SPI_8M_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_MAC_SPI_8M_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetRD_RS_ERR0_SYS_PART1_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x70)|value<<4)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_SYS_PART1_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x70) >> 4
}
func (o *EFUSE_Type) SetRD_RS_ERR0_SYS_PART1_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_SYS_PART1_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetRD_RS_ERR0_USR_DATA_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x700)|value<<8)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_USR_DATA_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x700) >> 8
}
func (o *EFUSE_Type) SetRD_RS_ERR0_USR_DATA_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x800)|value<<11)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_USR_DATA_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x800) >> 11
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY0_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x7000)|value<<12)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY0_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x7000) >> 12
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY0_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x8000)|value<<15)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY0_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x8000) >> 15
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY1_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x70000)|value<<16)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY1_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x70000) >> 16
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY1_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x80000)|value<<19)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY1_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x80000) >> 19
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY2_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x700000)|value<<20)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY2_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x700000) >> 20
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY2_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY2_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x800000) >> 23
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY3_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x7000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY3_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x7000000) >> 24
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY3_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x8000000)|value<<27)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY3_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x8000000) >> 27
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY4_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x70000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY4_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x70000000) >> 28
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY4_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x80000000)|value<<31)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY4_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x80000000) >> 31
}

// EFUSE.RD_RS_ERR1: Programming error record register 1 of BLOCK1-10.
func (o *EFUSE_Type) SetRD_RS_ERR1_KEY5_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR1.Reg, volatile.LoadUint32(&o.RD_RS_ERR1.Reg)&^(0x7)|value)
}
func (o *EFUSE_Type) GetRD_RS_ERR1_KEY5_ERR_NUM() uint32 {
	return volatile.LoadUint32(&o.RD_RS_ERR1.Reg) & 0x7
}
func (o *EFUSE_Type) SetRD_RS_ERR1_KEY5_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR1.Reg, volatile.LoadUint32(&o.RD_RS_ERR1.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetRD_RS_ERR1_KEY5_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR1.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetRD_RS_ERR1_SYS_PART2_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR1.Reg, volatile.LoadUint32(&o.RD_RS_ERR1.Reg)&^(0x70)|value<<4)
}
func (o *EFUSE_Type) GetRD_RS_ERR1_SYS_PART2_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR1.Reg) & 0x70) >> 4
}
func (o *EFUSE_Type) SetRD_RS_ERR1_SYS_PART2_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR1.Reg, volatile.LoadUint32(&o.RD_RS_ERR1.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_RS_ERR1_SYS_PART2_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR1.Reg) & 0x80) >> 7
}

// EFUSE.CLK: eFuse clcok configuration register.
func (o *EFUSE_Type) SetCLK_EFUSE_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetCLK_EFUSE_MEM_FORCE_PD() uint32 {
	return volatile.LoadUint32(&o.CLK.Reg) & 0x1
}
func (o *EFUSE_Type) SetCLK_MEM_CLK_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetCLK_MEM_CLK_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetCLK_EFUSE_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x4)|value<<2)
}
func (o *EFUSE_Type) GetCLK_EFUSE_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x4) >> 2
}
func (o *EFUSE_Type) SetCLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x10000)|value<<16)
}
func (o *EFUSE_Type) GetCLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x10000) >> 16
}

// EFUSE.CONF: eFuse operation mode configuraiton register;
func (o *EFUSE_Type) SetCONF_OP_CODE(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetCONF_OP_CODE() uint32 {
	return volatile.LoadUint32(&o.CONF.Reg) & 0xffff
}

// EFUSE.STATUS: eFuse status register.
func (o *EFUSE_Type) SetSTATUS_STATE(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xf)|value)
}
func (o *EFUSE_Type) GetSTATUS_STATE() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0xf
}
func (o *EFUSE_Type) SetSTATUS_OTP_LOAD_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetSTATUS_OTP_LOAD_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetSTATUS_OTP_VDDQ_C_SYNC2(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetSTATUS_OTP_VDDQ_C_SYNC2() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetSTATUS_OTP_STROBE_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *EFUSE_Type) GetSTATUS_OTP_STROBE_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x40) >> 6
}
func (o *EFUSE_Type) SetSTATUS_OTP_CSB_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetSTATUS_OTP_CSB_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetSTATUS_OTP_PGENB_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetSTATUS_OTP_PGENB_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetSTATUS_OTP_VDDQ_IS_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetSTATUS_OTP_VDDQ_IS_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetSTATUS_REPEAT_ERR_CNT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x3fc00)|value<<10)
}
func (o *EFUSE_Type) GetSTATUS_REPEAT_ERR_CNT() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x3fc00) >> 10
}

// EFUSE.CMD: eFuse command register.
func (o *EFUSE_Type) SetCMD_READ_CMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetCMD_READ_CMD() uint32 {
	return volatile.LoadUint32(&o.CMD.Reg) & 0x1
}
func (o *EFUSE_Type) SetCMD_PGM_CMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetCMD_PGM_CMD() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetCMD_BLK_NUM(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x3c)|value<<2)
}
func (o *EFUSE_Type) GetCMD_BLK_NUM() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x3c) >> 2
}

// EFUSE.INT_RAW: eFuse raw interrupt register.
func (o *EFUSE_Type) SetINT_RAW_READ_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_RAW_READ_DONE_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_RAW_PGM_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_RAW_PGM_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}

// EFUSE.INT_ST: eFuse interrupt status register.
func (o *EFUSE_Type) SetINT_ST_READ_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_ST_READ_DONE_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_ST_PGM_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_ST_PGM_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2) >> 1
}

// EFUSE.INT_ENA: eFuse interrupt enable register.
func (o *EFUSE_Type) SetINT_ENA_READ_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_ENA_READ_DONE_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_ENA_PGM_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_ENA_PGM_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}

// EFUSE.INT_CLR: eFuse interrupt clear register.
func (o *EFUSE_Type) SetINT_CLR_READ_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_CLR_READ_DONE_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_CLR_PGM_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_CLR_PGM_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}

// EFUSE.DAC_CONF: Controls the eFuse programming voltage.
func (o *EFUSE_Type) SetDAC_CONF_DAC_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetDAC_CONF_DAC_CLK_DIV() uint32 {
	return volatile.LoadUint32(&o.DAC_CONF.Reg) & 0xff
}
func (o *EFUSE_Type) SetDAC_CONF_DAC_CLK_PAD_SEL(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetDAC_CONF_DAC_CLK_PAD_SEL() uint32 {
	return (volatile.LoadUint32(&o.DAC_CONF.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetDAC_CONF_DAC_NUM(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0x1fe00)|value<<9)
}
func (o *EFUSE_Type) GetDAC_CONF_DAC_NUM() uint32 {
	return (volatile.LoadUint32(&o.DAC_CONF.Reg) & 0x1fe00) >> 9
}
func (o *EFUSE_Type) SetDAC_CONF_OE_CLR(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *EFUSE_Type) GetDAC_CONF_OE_CLR() uint32 {
	return (volatile.LoadUint32(&o.DAC_CONF.Reg) & 0x20000) >> 17
}

// EFUSE.RD_TIM_CONF: Configures read timing parameters.
func (o *EFUSE_Type) SetRD_TIM_CONF_READ_INIT_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_TIM_CONF.Reg, volatile.LoadUint32(&o.RD_TIM_CONF.Reg)&^(0xff000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_TIM_CONF_READ_INIT_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_TIM_CONF.Reg) & 0xff000000) >> 24
}

// EFUSE.WR_TIM_CONF1: Configurarion register 1 of eFuse programming timing parameters.
func (o *EFUSE_Type) SetWR_TIM_CONF1_PWR_ON_NUM(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF1.Reg, volatile.LoadUint32(&o.WR_TIM_CONF1.Reg)&^(0xffff00)|value<<8)
}
func (o *EFUSE_Type) GetWR_TIM_CONF1_PWR_ON_NUM() uint32 {
	return (volatile.LoadUint32(&o.WR_TIM_CONF1.Reg) & 0xffff00) >> 8
}

// EFUSE.WR_TIM_CONF2: Configurarion register 2 of eFuse programming timing parameters.
func (o *EFUSE_Type) SetWR_TIM_CONF2_PWR_OFF_NUM(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF2.Reg, volatile.LoadUint32(&o.WR_TIM_CONF2.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetWR_TIM_CONF2_PWR_OFF_NUM() uint32 {
	return volatile.LoadUint32(&o.WR_TIM_CONF2.Reg) & 0xffff
}

// EFUSE.DATE: eFuse version register.
func (o *EFUSE_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *EFUSE_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// Peripheral GPIO
type GPIO_Type struct {
	BT_SELECT          volatile.Register32 // 0x0
	OUT                volatile.Register32 // 0x4
	OUT_W1TS           volatile.Register32 // 0x8
	OUT_W1TC           volatile.Register32 // 0xC
	_                  [12]byte
	SDIO_SELECT        volatile.Register32 // 0x1C
	ENABLE             volatile.Register32 // 0x20
	ENABLE_W1TS        volatile.Register32 // 0x24
	ENABLE_W1TC        volatile.Register32 // 0x28
	_                  [12]byte
	STRAP              volatile.Register32 // 0x38
	IN                 volatile.Register32 // 0x3C
	_                  [4]byte
	STATUS             volatile.Register32 // 0x44
	STATUS_W1TS        volatile.Register32 // 0x48
	STATUS_W1TC        volatile.Register32 // 0x4C
	_                  [12]byte
	PCPU_INT           volatile.Register32 // 0x5C
	PCPU_NMI_INT       volatile.Register32 // 0x60
	CPUSDIO_INT        volatile.Register32 // 0x64
	_                  [12]byte
	PIN0               volatile.Register32 // 0x74
	PIN1               volatile.Register32 // 0x78
	PIN2               volatile.Register32 // 0x7C
	PIN3               volatile.Register32 // 0x80
	PIN4               volatile.Register32 // 0x84
	PIN5               volatile.Register32 // 0x88
	PIN6               volatile.Register32 // 0x8C
	PIN7               volatile.Register32 // 0x90
	PIN8               volatile.Register32 // 0x94
	PIN9               volatile.Register32 // 0x98
	PIN10              volatile.Register32 // 0x9C
	PIN11              volatile.Register32 // 0xA0
	PIN12              volatile.Register32 // 0xA4
	PIN13              volatile.Register32 // 0xA8
	PIN14              volatile.Register32 // 0xAC
	PIN15              volatile.Register32 // 0xB0
	PIN16              volatile.Register32 // 0xB4
	PIN17              volatile.Register32 // 0xB8
	PIN18              volatile.Register32 // 0xBC
	PIN19              volatile.Register32 // 0xC0
	PIN20              volatile.Register32 // 0xC4
	PIN21              volatile.Register32 // 0xC8
	PIN22              volatile.Register32 // 0xCC
	PIN23              volatile.Register32 // 0xD0
	PIN24              volatile.Register32 // 0xD4
	PIN25              volatile.Register32 // 0xD8
	_                  [112]byte
	STATUS_NEXT        volatile.Register32 // 0x14C
	_                  [4]byte
	FUNC0_IN_SEL_CFG   volatile.Register32 // 0x154
	FUNC1_IN_SEL_CFG   volatile.Register32 // 0x158
	FUNC2_IN_SEL_CFG   volatile.Register32 // 0x15C
	FUNC3_IN_SEL_CFG   volatile.Register32 // 0x160
	FUNC4_IN_SEL_CFG   volatile.Register32 // 0x164
	FUNC5_IN_SEL_CFG   volatile.Register32 // 0x168
	FUNC6_IN_SEL_CFG   volatile.Register32 // 0x16C
	FUNC7_IN_SEL_CFG   volatile.Register32 // 0x170
	FUNC8_IN_SEL_CFG   volatile.Register32 // 0x174
	FUNC9_IN_SEL_CFG   volatile.Register32 // 0x178
	FUNC10_IN_SEL_CFG  volatile.Register32 // 0x17C
	FUNC11_IN_SEL_CFG  volatile.Register32 // 0x180
	FUNC12_IN_SEL_CFG  volatile.Register32 // 0x184
	FUNC13_IN_SEL_CFG  volatile.Register32 // 0x188
	FUNC14_IN_SEL_CFG  volatile.Register32 // 0x18C
	FUNC15_IN_SEL_CFG  volatile.Register32 // 0x190
	FUNC16_IN_SEL_CFG  volatile.Register32 // 0x194
	FUNC17_IN_SEL_CFG  volatile.Register32 // 0x198
	FUNC18_IN_SEL_CFG  volatile.Register32 // 0x19C
	FUNC19_IN_SEL_CFG  volatile.Register32 // 0x1A0
	FUNC20_IN_SEL_CFG  volatile.Register32 // 0x1A4
	FUNC21_IN_SEL_CFG  volatile.Register32 // 0x1A8
	FUNC22_IN_SEL_CFG  volatile.Register32 // 0x1AC
	FUNC23_IN_SEL_CFG  volatile.Register32 // 0x1B0
	FUNC24_IN_SEL_CFG  volatile.Register32 // 0x1B4
	FUNC25_IN_SEL_CFG  volatile.Register32 // 0x1B8
	FUNC26_IN_SEL_CFG  volatile.Register32 // 0x1BC
	FUNC27_IN_SEL_CFG  volatile.Register32 // 0x1C0
	FUNC28_IN_SEL_CFG  volatile.Register32 // 0x1C4
	FUNC29_IN_SEL_CFG  volatile.Register32 // 0x1C8
	FUNC30_IN_SEL_CFG  volatile.Register32 // 0x1CC
	FUNC31_IN_SEL_CFG  volatile.Register32 // 0x1D0
	FUNC32_IN_SEL_CFG  volatile.Register32 // 0x1D4
	FUNC33_IN_SEL_CFG  volatile.Register32 // 0x1D8
	FUNC34_IN_SEL_CFG  volatile.Register32 // 0x1DC
	FUNC35_IN_SEL_CFG  volatile.Register32 // 0x1E0
	FUNC36_IN_SEL_CFG  volatile.Register32 // 0x1E4
	FUNC37_IN_SEL_CFG  volatile.Register32 // 0x1E8
	FUNC38_IN_SEL_CFG  volatile.Register32 // 0x1EC
	FUNC39_IN_SEL_CFG  volatile.Register32 // 0x1F0
	FUNC40_IN_SEL_CFG  volatile.Register32 // 0x1F4
	FUNC41_IN_SEL_CFG  volatile.Register32 // 0x1F8
	FUNC42_IN_SEL_CFG  volatile.Register32 // 0x1FC
	FUNC43_IN_SEL_CFG  volatile.Register32 // 0x200
	FUNC44_IN_SEL_CFG  volatile.Register32 // 0x204
	FUNC45_IN_SEL_CFG  volatile.Register32 // 0x208
	FUNC46_IN_SEL_CFG  volatile.Register32 // 0x20C
	FUNC47_IN_SEL_CFG  volatile.Register32 // 0x210
	FUNC48_IN_SEL_CFG  volatile.Register32 // 0x214
	FUNC49_IN_SEL_CFG  volatile.Register32 // 0x218
	FUNC50_IN_SEL_CFG  volatile.Register32 // 0x21C
	FUNC51_IN_SEL_CFG  volatile.Register32 // 0x220
	FUNC52_IN_SEL_CFG  volatile.Register32 // 0x224
	FUNC53_IN_SEL_CFG  volatile.Register32 // 0x228
	FUNC54_IN_SEL_CFG  volatile.Register32 // 0x22C
	FUNC55_IN_SEL_CFG  volatile.Register32 // 0x230
	FUNC56_IN_SEL_CFG  volatile.Register32 // 0x234
	FUNC57_IN_SEL_CFG  volatile.Register32 // 0x238
	FUNC58_IN_SEL_CFG  volatile.Register32 // 0x23C
	FUNC59_IN_SEL_CFG  volatile.Register32 // 0x240
	FUNC60_IN_SEL_CFG  volatile.Register32 // 0x244
	FUNC61_IN_SEL_CFG  volatile.Register32 // 0x248
	FUNC62_IN_SEL_CFG  volatile.Register32 // 0x24C
	FUNC63_IN_SEL_CFG  volatile.Register32 // 0x250
	FUNC64_IN_SEL_CFG  volatile.Register32 // 0x254
	FUNC65_IN_SEL_CFG  volatile.Register32 // 0x258
	FUNC66_IN_SEL_CFG  volatile.Register32 // 0x25C
	FUNC67_IN_SEL_CFG  volatile.Register32 // 0x260
	FUNC68_IN_SEL_CFG  volatile.Register32 // 0x264
	FUNC69_IN_SEL_CFG  volatile.Register32 // 0x268
	FUNC70_IN_SEL_CFG  volatile.Register32 // 0x26C
	FUNC71_IN_SEL_CFG  volatile.Register32 // 0x270
	FUNC72_IN_SEL_CFG  volatile.Register32 // 0x274
	FUNC73_IN_SEL_CFG  volatile.Register32 // 0x278
	FUNC74_IN_SEL_CFG  volatile.Register32 // 0x27C
	FUNC75_IN_SEL_CFG  volatile.Register32 // 0x280
	FUNC76_IN_SEL_CFG  volatile.Register32 // 0x284
	FUNC77_IN_SEL_CFG  volatile.Register32 // 0x288
	FUNC78_IN_SEL_CFG  volatile.Register32 // 0x28C
	FUNC79_IN_SEL_CFG  volatile.Register32 // 0x290
	FUNC80_IN_SEL_CFG  volatile.Register32 // 0x294
	FUNC81_IN_SEL_CFG  volatile.Register32 // 0x298
	FUNC82_IN_SEL_CFG  volatile.Register32 // 0x29C
	FUNC83_IN_SEL_CFG  volatile.Register32 // 0x2A0
	FUNC84_IN_SEL_CFG  volatile.Register32 // 0x2A4
	FUNC85_IN_SEL_CFG  volatile.Register32 // 0x2A8
	FUNC86_IN_SEL_CFG  volatile.Register32 // 0x2AC
	FUNC87_IN_SEL_CFG  volatile.Register32 // 0x2B0
	FUNC88_IN_SEL_CFG  volatile.Register32 // 0x2B4
	FUNC89_IN_SEL_CFG  volatile.Register32 // 0x2B8
	FUNC90_IN_SEL_CFG  volatile.Register32 // 0x2BC
	FUNC91_IN_SEL_CFG  volatile.Register32 // 0x2C0
	FUNC92_IN_SEL_CFG  volatile.Register32 // 0x2C4
	FUNC93_IN_SEL_CFG  volatile.Register32 // 0x2C8
	FUNC94_IN_SEL_CFG  volatile.Register32 // 0x2CC
	FUNC95_IN_SEL_CFG  volatile.Register32 // 0x2D0
	FUNC96_IN_SEL_CFG  volatile.Register32 // 0x2D4
	FUNC97_IN_SEL_CFG  volatile.Register32 // 0x2D8
	FUNC98_IN_SEL_CFG  volatile.Register32 // 0x2DC
	FUNC99_IN_SEL_CFG  volatile.Register32 // 0x2E0
	FUNC100_IN_SEL_CFG volatile.Register32 // 0x2E4
	FUNC101_IN_SEL_CFG volatile.Register32 // 0x2E8
	FUNC102_IN_SEL_CFG volatile.Register32 // 0x2EC
	FUNC103_IN_SEL_CFG volatile.Register32 // 0x2F0
	FUNC104_IN_SEL_CFG volatile.Register32 // 0x2F4
	FUNC105_IN_SEL_CFG volatile.Register32 // 0x2F8
	FUNC106_IN_SEL_CFG volatile.Register32 // 0x2FC
	FUNC107_IN_SEL_CFG volatile.Register32 // 0x300
	FUNC108_IN_SEL_CFG volatile.Register32 // 0x304
	FUNC109_IN_SEL_CFG volatile.Register32 // 0x308
	FUNC110_IN_SEL_CFG volatile.Register32 // 0x30C
	FUNC111_IN_SEL_CFG volatile.Register32 // 0x310
	FUNC112_IN_SEL_CFG volatile.Register32 // 0x314
	FUNC113_IN_SEL_CFG volatile.Register32 // 0x318
	FUNC114_IN_SEL_CFG volatile.Register32 // 0x31C
	FUNC115_IN_SEL_CFG volatile.Register32 // 0x320
	FUNC116_IN_SEL_CFG volatile.Register32 // 0x324
	FUNC117_IN_SEL_CFG volatile.Register32 // 0x328
	FUNC118_IN_SEL_CFG volatile.Register32 // 0x32C
	FUNC119_IN_SEL_CFG volatile.Register32 // 0x330
	FUNC120_IN_SEL_CFG volatile.Register32 // 0x334
	FUNC121_IN_SEL_CFG volatile.Register32 // 0x338
	FUNC122_IN_SEL_CFG volatile.Register32 // 0x33C
	FUNC123_IN_SEL_CFG volatile.Register32 // 0x340
	FUNC124_IN_SEL_CFG volatile.Register32 // 0x344
	FUNC125_IN_SEL_CFG volatile.Register32 // 0x348
	FUNC126_IN_SEL_CFG volatile.Register32 // 0x34C
	FUNC127_IN_SEL_CFG volatile.Register32 // 0x350
	_                  [512]byte
	FUNC0_OUT_SEL_CFG  volatile.Register32 // 0x554
	FUNC1_OUT_SEL_CFG  volatile.Register32 // 0x558
	FUNC2_OUT_SEL_CFG  volatile.Register32 // 0x55C
	FUNC3_OUT_SEL_CFG  volatile.Register32 // 0x560
	FUNC4_OUT_SEL_CFG  volatile.Register32 // 0x564
	FUNC5_OUT_SEL_CFG  volatile.Register32 // 0x568
	FUNC6_OUT_SEL_CFG  volatile.Register32 // 0x56C
	FUNC7_OUT_SEL_CFG  volatile.Register32 // 0x570
	FUNC8_OUT_SEL_CFG  volatile.Register32 // 0x574
	FUNC9_OUT_SEL_CFG  volatile.Register32 // 0x578
	FUNC10_OUT_SEL_CFG volatile.Register32 // 0x57C
	FUNC11_OUT_SEL_CFG volatile.Register32 // 0x580
	FUNC12_OUT_SEL_CFG volatile.Register32 // 0x584
	FUNC13_OUT_SEL_CFG volatile.Register32 // 0x588
	FUNC14_OUT_SEL_CFG volatile.Register32 // 0x58C
	FUNC15_OUT_SEL_CFG volatile.Register32 // 0x590
	FUNC16_OUT_SEL_CFG volatile.Register32 // 0x594
	FUNC17_OUT_SEL_CFG volatile.Register32 // 0x598
	FUNC18_OUT_SEL_CFG volatile.Register32 // 0x59C
	FUNC19_OUT_SEL_CFG volatile.Register32 // 0x5A0
	FUNC20_OUT_SEL_CFG volatile.Register32 // 0x5A4
	FUNC21_OUT_SEL_CFG volatile.Register32 // 0x5A8
	FUNC22_OUT_SEL_CFG volatile.Register32 // 0x5AC
	FUNC23_OUT_SEL_CFG volatile.Register32 // 0x5B0
	FUNC24_OUT_SEL_CFG volatile.Register32 // 0x5B4
	FUNC25_OUT_SEL_CFG volatile.Register32 // 0x5B8
	_                  [112]byte
	CLOCK_GATE         volatile.Register32 // 0x62C
	_                  [204]byte
	REG_DATE           volatile.Register32 // 0x6FC
}

// GPIO.BT_SELECT: GPIO bit select register
func (o *GPIO_Type) SetBT_SELECT(value uint32) {
	volatile.StoreUint32(&o.BT_SELECT.Reg, value)
}
func (o *GPIO_Type) GetBT_SELECT() uint32 {
	return volatile.LoadUint32(&o.BT_SELECT.Reg)
}

// GPIO.OUT: GPIO output register
func (o *GPIO_Type) SetOUT_DATA_ORIG(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x3ffffff)|value)
}
func (o *GPIO_Type) GetOUT_DATA_ORIG() uint32 {
	return volatile.LoadUint32(&o.OUT.Reg) & 0x3ffffff
}

// GPIO.OUT_W1TS: GPIO output set register
func (o *GPIO_Type) SetOUT_W1TS(value uint32) {
	volatile.StoreUint32(&o.OUT_W1TS.Reg, volatile.LoadUint32(&o.OUT_W1TS.Reg)&^(0x3ffffff)|value)
}
func (o *GPIO_Type) GetOUT_W1TS() uint32 {
	return volatile.LoadUint32(&o.OUT_W1TS.Reg) & 0x3ffffff
}

// GPIO.OUT_W1TC: GPIO output clear register
func (o *GPIO_Type) SetOUT_W1TC(value uint32) {
	volatile.StoreUint32(&o.OUT_W1TC.Reg, volatile.LoadUint32(&o.OUT_W1TC.Reg)&^(0x3ffffff)|value)
}
func (o *GPIO_Type) GetOUT_W1TC() uint32 {
	return volatile.LoadUint32(&o.OUT_W1TC.Reg) & 0x3ffffff
}

// GPIO.SDIO_SELECT: GPIO sdio select register
func (o *GPIO_Type) SetSDIO_SELECT_SDIO_SEL(value uint32) {
	volatile.StoreUint32(&o.SDIO_SELECT.Reg, volatile.LoadUint32(&o.SDIO_SELECT.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetSDIO_SELECT_SDIO_SEL() uint32 {
	return volatile.LoadUint32(&o.SDIO_SELECT.Reg) & 0xff
}

// GPIO.ENABLE: GPIO output enable register
func (o *GPIO_Type) SetENABLE_DATA(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x3ffffff)|value)
}
func (o *GPIO_Type) GetENABLE_DATA() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x3ffffff
}

// GPIO.ENABLE_W1TS: GPIO output enable set register
func (o *GPIO_Type) SetENABLE_W1TS(value uint32) {
	volatile.StoreUint32(&o.ENABLE_W1TS.Reg, volatile.LoadUint32(&o.ENABLE_W1TS.Reg)&^(0x3ffffff)|value)
}
func (o *GPIO_Type) GetENABLE_W1TS() uint32 {
	return volatile.LoadUint32(&o.ENABLE_W1TS.Reg) & 0x3ffffff
}

// GPIO.ENABLE_W1TC: GPIO output enable clear register
func (o *GPIO_Type) SetENABLE_W1TC(value uint32) {
	volatile.StoreUint32(&o.ENABLE_W1TC.Reg, volatile.LoadUint32(&o.ENABLE_W1TC.Reg)&^(0x3ffffff)|value)
}
func (o *GPIO_Type) GetENABLE_W1TC() uint32 {
	return volatile.LoadUint32(&o.ENABLE_W1TC.Reg) & 0x3ffffff
}

// GPIO.STRAP: pad strapping register
func (o *GPIO_Type) SetSTRAP_STRAPPING(value uint32) {
	volatile.StoreUint32(&o.STRAP.Reg, volatile.LoadUint32(&o.STRAP.Reg)&^(0xffff)|value)
}
func (o *GPIO_Type) GetSTRAP_STRAPPING() uint32 {
	return volatile.LoadUint32(&o.STRAP.Reg) & 0xffff
}

// GPIO.IN: GPIO input register
func (o *GPIO_Type) SetIN_DATA_NEXT(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x3ffffff)|value)
}
func (o *GPIO_Type) GetIN_DATA_NEXT() uint32 {
	return volatile.LoadUint32(&o.IN.Reg) & 0x3ffffff
}

// GPIO.STATUS: GPIO interrupt status register
func (o *GPIO_Type) SetSTATUS_INTERRUPT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x3ffffff)|value)
}
func (o *GPIO_Type) GetSTATUS_INTERRUPT() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x3ffffff
}

// GPIO.STATUS_W1TS: GPIO interrupt status set register
func (o *GPIO_Type) SetSTATUS_W1TS(value uint32) {
	volatile.StoreUint32(&o.STATUS_W1TS.Reg, volatile.LoadUint32(&o.STATUS_W1TS.Reg)&^(0x3ffffff)|value)
}
func (o *GPIO_Type) GetSTATUS_W1TS() uint32 {
	return volatile.LoadUint32(&o.STATUS_W1TS.Reg) & 0x3ffffff
}

// GPIO.STATUS_W1TC: GPIO interrupt status clear register
func (o *GPIO_Type) SetSTATUS_W1TC(value uint32) {
	volatile.StoreUint32(&o.STATUS_W1TC.Reg, volatile.LoadUint32(&o.STATUS_W1TC.Reg)&^(0x3ffffff)|value)
}
func (o *GPIO_Type) GetSTATUS_W1TC() uint32 {
	return volatile.LoadUint32(&o.STATUS_W1TC.Reg) & 0x3ffffff
}

// GPIO.PCPU_INT: GPIO PRO_CPU interrupt status register
func (o *GPIO_Type) SetPCPU_INT_PROCPU_INT(value uint32) {
	volatile.StoreUint32(&o.PCPU_INT.Reg, volatile.LoadUint32(&o.PCPU_INT.Reg)&^(0x3ffffff)|value)
}
func (o *GPIO_Type) GetPCPU_INT_PROCPU_INT() uint32 {
	return volatile.LoadUint32(&o.PCPU_INT.Reg) & 0x3ffffff
}

// GPIO.PCPU_NMI_INT: GPIO PRO_CPU(not shielded) interrupt status register
func (o *GPIO_Type) SetPCPU_NMI_INT_PROCPU_NMI_INT(value uint32) {
	volatile.StoreUint32(&o.PCPU_NMI_INT.Reg, volatile.LoadUint32(&o.PCPU_NMI_INT.Reg)&^(0x3ffffff)|value)
}
func (o *GPIO_Type) GetPCPU_NMI_INT_PROCPU_NMI_INT() uint32 {
	return volatile.LoadUint32(&o.PCPU_NMI_INT.Reg) & 0x3ffffff
}

// GPIO.CPUSDIO_INT: GPIO CPUSDIO interrupt status register
func (o *GPIO_Type) SetCPUSDIO_INT_SDIO_INT(value uint32) {
	volatile.StoreUint32(&o.CPUSDIO_INT.Reg, volatile.LoadUint32(&o.CPUSDIO_INT.Reg)&^(0x3ffffff)|value)
}
func (o *GPIO_Type) GetCPUSDIO_INT_SDIO_INT() uint32 {
	return volatile.LoadUint32(&o.CPUSDIO_INT.Reg) & 0x3ffffff
}

// GPIO.PIN0: GPIO pin configuration register
func (o *GPIO_Type) SetPIN0_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN0_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN0.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN0_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN0_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN0_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN0_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN0_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN0_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN0_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN0_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN0_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN0_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN0_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN0_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x3e000) >> 13
}

// GPIO.PIN1: GPIO pin configuration register
func (o *GPIO_Type) SetPIN1_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN1_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN1.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN1_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN1_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN1_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN1_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN1_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN1_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN1_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN1_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN1_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN1_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN1_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN1_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x3e000) >> 13
}

// GPIO.PIN2: GPIO pin configuration register
func (o *GPIO_Type) SetPIN2_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN2_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN2.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN2_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN2_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN2_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN2_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN2_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN2_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN2_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN2_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN2_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN2_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN2_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN2_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x3e000) >> 13
}

// GPIO.PIN3: GPIO pin configuration register
func (o *GPIO_Type) SetPIN3_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN3_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN3.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN3_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN3_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN3_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN3_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN3_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN3_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN3_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN3_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN3_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN3_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN3_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN3_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x3e000) >> 13
}

// GPIO.PIN4: GPIO pin configuration register
func (o *GPIO_Type) SetPIN4_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN4_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN4.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN4_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN4_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN4_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN4_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN4_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN4_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN4_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN4_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN4_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN4_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN4_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN4_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x3e000) >> 13
}

// GPIO.PIN5: GPIO pin configuration register
func (o *GPIO_Type) SetPIN5_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN5_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN5.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN5_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN5_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN5_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN5_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN5_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN5_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN5_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN5_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN5_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN5_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN5_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN5_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x3e000) >> 13
}

// GPIO.PIN6: GPIO pin configuration register
func (o *GPIO_Type) SetPIN6_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN6_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN6.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN6_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN6_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN6_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN6_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN6_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN6_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN6_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN6_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN6_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN6_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN6_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN6_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x3e000) >> 13
}

// GPIO.PIN7: GPIO pin configuration register
func (o *GPIO_Type) SetPIN7_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN7_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN7.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN7_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN7_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN7_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN7_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN7_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN7_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN7_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN7_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN7_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN7_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN7_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN7_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x3e000) >> 13
}

// GPIO.PIN8: GPIO pin configuration register
func (o *GPIO_Type) SetPIN8_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN8_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN8.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN8_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN8_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN8_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN8_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN8_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN8_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN8_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN8_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN8_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN8_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN8_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN8_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x3e000) >> 13
}

// GPIO.PIN9: GPIO pin configuration register
func (o *GPIO_Type) SetPIN9_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN9_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN9.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN9_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN9_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN9_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN9_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN9_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN9_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN9_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN9_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN9_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN9_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN9_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN9_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x3e000) >> 13
}

// GPIO.PIN10: GPIO pin configuration register
func (o *GPIO_Type) SetPIN10_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN10_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN10.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN10_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN10_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN10_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN10_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN10_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN10_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN10_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN10_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN10_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN10_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN10_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN10_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x3e000) >> 13
}

// GPIO.PIN11: GPIO pin configuration register
func (o *GPIO_Type) SetPIN11_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN11_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN11.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN11_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN11_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN11_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN11_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN11_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN11_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN11_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN11_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN11_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN11_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN11_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN11_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x3e000) >> 13
}

// GPIO.PIN12: GPIO pin configuration register
func (o *GPIO_Type) SetPIN12_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN12_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN12.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN12_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN12_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN12_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN12_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN12_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN12_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN12_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN12_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN12_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN12_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN12_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN12_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x3e000) >> 13
}

// GPIO.PIN13: GPIO pin configuration register
func (o *GPIO_Type) SetPIN13_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN13_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN13.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN13_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN13_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN13_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN13_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN13_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN13_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN13_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN13_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN13_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN13_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN13_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN13_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x3e000) >> 13
}

// GPIO.PIN14: GPIO pin configuration register
func (o *GPIO_Type) SetPIN14_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN14_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN14.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN14_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN14_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN14_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN14_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN14_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN14_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN14_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN14_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN14_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN14_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN14_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN14_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x3e000) >> 13
}

// GPIO.PIN15: GPIO pin configuration register
func (o *GPIO_Type) SetPIN15_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN15_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN15.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN15_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN15_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN15_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN15_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN15_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN15_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN15_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN15_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN15_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN15_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN15_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN15_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x3e000) >> 13
}

// GPIO.PIN16: GPIO pin configuration register
func (o *GPIO_Type) SetPIN16_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN16_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN16.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN16_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN16_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN16_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN16_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN16_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN16_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN16_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN16_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN16_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN16_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN16_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN16_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x3e000) >> 13
}

// GPIO.PIN17: GPIO pin configuration register
func (o *GPIO_Type) SetPIN17_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN17_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN17.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN17_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN17_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN17_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN17_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN17_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN17_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN17_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN17_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN17_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN17_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN17_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN17_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x3e000) >> 13
}

// GPIO.PIN18: GPIO pin configuration register
func (o *GPIO_Type) SetPIN18_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN18_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN18.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN18_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN18_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN18_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN18_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN18_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN18_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN18_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN18_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN18_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN18_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN18_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN18_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x3e000) >> 13
}

// GPIO.PIN19: GPIO pin configuration register
func (o *GPIO_Type) SetPIN19_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN19_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN19.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN19_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN19_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN19_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN19_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN19_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN19_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN19_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN19_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN19_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN19_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN19_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN19_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x3e000) >> 13
}

// GPIO.PIN20: GPIO pin configuration register
func (o *GPIO_Type) SetPIN20_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN20_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN20.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN20_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN20_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN20_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN20_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN20_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN20_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN20_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN20_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN20_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN20_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN20_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN20_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x3e000) >> 13
}

// GPIO.PIN21: GPIO pin configuration register
func (o *GPIO_Type) SetPIN21_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN21_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN21.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN21_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN21_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN21_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN21_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN21_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN21_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN21_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN21_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN21_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN21_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN21_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN21_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x3e000) >> 13
}

// GPIO.PIN22: GPIO pin configuration register
func (o *GPIO_Type) SetPIN22_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN22_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN22.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN22_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN22_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN22_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN22_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN22_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN22_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN22_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN22_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN22_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN22_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN22_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN22_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x3e000) >> 13
}

// GPIO.PIN23: GPIO pin configuration register
func (o *GPIO_Type) SetPIN23_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN23_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN23.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN23_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN23_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN23_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN23_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN23_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN23_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN23_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN23_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN23_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN23_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN23_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN23_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x3e000) >> 13
}

// GPIO.PIN24: GPIO pin configuration register
func (o *GPIO_Type) SetPIN24_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN24_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN24.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN24_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN24_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN24_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN24_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN24_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN24_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN24_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN24_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN24_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN24_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN24_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN24_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x3e000) >> 13
}

// GPIO.PIN25: GPIO pin configuration register
func (o *GPIO_Type) SetPIN25_PIN_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN25_PIN_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN25.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN25_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN25_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN25_PIN_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN25_PIN_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN25_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN25_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN25_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN25_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN25_PIN_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN25_PIN_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN25_PIN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN25_PIN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x3e000) >> 13
}

// GPIO.STATUS_NEXT: GPIO interrupt source register
func (o *GPIO_Type) SetSTATUS_NEXT_STATUS_INTERRUPT_NEXT(value uint32) {
	volatile.StoreUint32(&o.STATUS_NEXT.Reg, volatile.LoadUint32(&o.STATUS_NEXT.Reg)&^(0x3ffffff)|value)
}
func (o *GPIO_Type) GetSTATUS_NEXT_STATUS_INTERRUPT_NEXT() uint32 {
	return volatile.LoadUint32(&o.STATUS_NEXT.Reg) & 0x3ffffff
}

// GPIO.FUNC0_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC0_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC0_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC0_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC0_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC0_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC0_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC1_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC1_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC1_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC1_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC1_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC1_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC1_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC2_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC2_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC2_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC2_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC2_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC2_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC2_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC3_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC3_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC3_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC3_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC3_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC3_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC3_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC4_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC4_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC4_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC4_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC4_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC4_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC4_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC5_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC5_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC5_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC5_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC5_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC5_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC5_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC6_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC6_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC6_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC6_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC6_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC6_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC6_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC7_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC7_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC7_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC7_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC7_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC7_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC7_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC8_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC8_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC8_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC8_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC8_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC8_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC8_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC9_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC9_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC9_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC9_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC9_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC9_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC9_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC10_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC10_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC10_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC10_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC10_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC10_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC10_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC11_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC11_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC11_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC11_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC11_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC11_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC11_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC12_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC12_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC12_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC12_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC12_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC12_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC12_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC13_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC13_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC13_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC13_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC13_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC13_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC13_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC14_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC14_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC14_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC14_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC14_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC14_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC14_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC15_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC15_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC15_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC15_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC15_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC15_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC15_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC16_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC16_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC16_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC16_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC16_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC16_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC16_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC17_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC17_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC17_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC17_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC17_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC17_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC17_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC18_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC18_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC18_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC18_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC18_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC18_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC18_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC19_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC19_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC19_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC19_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC19_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC19_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC19_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC20_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC20_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC20_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC20_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC20_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC20_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC20_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC21_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC21_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC21_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC21_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC21_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC21_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC21_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC22_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC22_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC22_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC22_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC22_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC22_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC22_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC23_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC23_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC23_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC23_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC23_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC23_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC23_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC24_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC24_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC24_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC24_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC24_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC24_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC24_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC25_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC25_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC25_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC25_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC25_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC25_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC25_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC26_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC26_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC26_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC26_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC26_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC26_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC26_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC27_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC27_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC27_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC27_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC27_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC27_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC27_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC28_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC28_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC28_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC28_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC28_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC28_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC28_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC29_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC29_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC29_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC29_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC29_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC29_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC29_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC30_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC30_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC30_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC30_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC30_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC30_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC30_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC31_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC31_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC31_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC31_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC31_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC31_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC31_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC32_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC32_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC32_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC32_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC32_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC32_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC32_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC33_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC33_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC33_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC33_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC33_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC33_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC33_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC34_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC34_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC34_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC34_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC34_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC34_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC34_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC35_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC35_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC35_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC35_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC35_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC35_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC35_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC36_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC36_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC36_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC36_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC36_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC36_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC36_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC37_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC37_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC37_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC37_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC37_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC37_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC37_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC38_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC38_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC38_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC38_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC38_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC38_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC38_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC39_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC39_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC39_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC39_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC39_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC39_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC39_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC40_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC40_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC40_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC40_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC40_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC40_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC40_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC41_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC41_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC41_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC41_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC41_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC41_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC41_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC42_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC42_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC42_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC42_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC42_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC42_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC42_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC43_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC43_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC43_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC43_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC43_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC43_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC43_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC44_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC44_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC44_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC44_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC44_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC44_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC44_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC45_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC45_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC45_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC45_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC45_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC45_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC45_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC46_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC46_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC46_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC46_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC46_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC46_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC46_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC47_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC47_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC47_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC47_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC47_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC47_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC47_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC48_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC48_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC48_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC48_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC48_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC48_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC48_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC49_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC49_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC49_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC49_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC49_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC49_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC49_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC50_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC50_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC50_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC50_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC50_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC50_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC50_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC51_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC51_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC51_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC51_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC51_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC51_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC51_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC52_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC52_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC52_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC52_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC52_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC52_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC52_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC53_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC53_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC53_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC53_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC53_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC53_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC53_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC54_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC54_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC54_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC54_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC54_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC54_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC54_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC54_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC54_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC54_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC55_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC55_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC55_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC55_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC55_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC55_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC55_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC55_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC55_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC55_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC56_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC56_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC56_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC56_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC56_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC56_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC56_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC56_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC56_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC56_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC57_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC57_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC57_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC57_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC57_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC57_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC57_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC57_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC57_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC57_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC58_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC58_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC58_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC58_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC58_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC58_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC58_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC58_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC58_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC58_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC59_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC59_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC59_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC59_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC59_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC59_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC59_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC59_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC59_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC59_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC60_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC60_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC60_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC60_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC60_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC60_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC60_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC60_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC60_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC60_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC61_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC61_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC61_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC61_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC61_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC61_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC61_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC61_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC61_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC61_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC62_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC62_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC62_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC62_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC62_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC62_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC62_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC62_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC62_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC62_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC63_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC63_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC63_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC63_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC63_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC63_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC63_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC63_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC63_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC63_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC64_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC64_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC64_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC64_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC64_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC64_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC64_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC64_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC64_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC64_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC65_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC65_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC65_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC65_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC65_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC65_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC65_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC65_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC65_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC65_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC66_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC66_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC66_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC66_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC66_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC66_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC66_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC66_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC66_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC66_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC67_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC67_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC67_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC67_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC67_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC67_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC67_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC67_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC67_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC67_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC68_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC68_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC68_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC68_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC68_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC68_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC68_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC68_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC68_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC68_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC69_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC69_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC69_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC69_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC69_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC69_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC69_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC69_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC69_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC69_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC70_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC70_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC70_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC70_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC70_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC70_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC70_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC70_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC70_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC70_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC71_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC71_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC71_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC71_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC71_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC71_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC71_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC71_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC71_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC71_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC72_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC72_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC72_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC72_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC72_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC72_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC72_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC72_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC72_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC72_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC73_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC73_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC73_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC73_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC73_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC73_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC73_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC73_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC73_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC73_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC74_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC74_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC74_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC74_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC74_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC74_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC74_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC74_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC74_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC74_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC75_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC75_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC75_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC75_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC75_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC75_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC75_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC75_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC75_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC75_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC76_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC76_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC76_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC76_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC76_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC76_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC76_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC76_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC76_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC76_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC77_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC77_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC77_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC77_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC77_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC77_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC77_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC77_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC77_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC77_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC78_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC78_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC78_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC78_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC78_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC78_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC78_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC78_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC78_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC78_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC79_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC79_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC79_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC79_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC79_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC79_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC79_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC79_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC79_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC79_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC80_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC80_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC80_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC80_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC80_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC80_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC80_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC80_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC80_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC80_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC81_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC81_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC81_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC81_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC81_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC81_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC81_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC81_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC81_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC81_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC82_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC82_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC82_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC82_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC82_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC82_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC82_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC82_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC82_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC82_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC83_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC83_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC83_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC83_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC83_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC83_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC83_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC83_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC83_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC83_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC84_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC84_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC84_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC84_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC84_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC84_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC84_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC84_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC84_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC84_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC85_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC85_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC85_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC85_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC85_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC85_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC85_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC85_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC85_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC85_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC86_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC86_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC86_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC86_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC86_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC86_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC86_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC86_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC86_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC86_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC87_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC87_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC87_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC87_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC87_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC87_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC87_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC87_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC87_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC87_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC88_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC88_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC88_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC88_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC88_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC88_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC88_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC88_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC88_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC88_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC89_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC89_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC89_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC89_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC89_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC89_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC89_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC89_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC89_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC89_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC90_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC90_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC90_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC90_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC90_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC90_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC90_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC90_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC90_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC90_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC91_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC91_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC91_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC91_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC91_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC91_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC91_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC91_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC91_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC91_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC92_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC92_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC92_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC92_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC92_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC92_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC92_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC92_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC92_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC92_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC93_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC93_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC93_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC93_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC93_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC93_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC93_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC93_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC93_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC93_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC94_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC94_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC94_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC94_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC94_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC94_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC94_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC94_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC94_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC94_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC95_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC95_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC95_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC95_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC95_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC95_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC95_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC95_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC95_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC95_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC96_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC96_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC96_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC96_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC96_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC96_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC96_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC96_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC96_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC96_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC97_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC97_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC97_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC97_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC97_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC97_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC97_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC97_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC97_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC97_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC98_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC98_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC98_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC98_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC98_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC98_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC98_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC98_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC98_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC98_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC99_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC99_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC99_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC99_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC99_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC99_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC99_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC99_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC99_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC99_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC100_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC100_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC100_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC100_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC100_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC100_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC100_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC100_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC100_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC100_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC101_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC101_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC101_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC101_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC101_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC101_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC101_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC101_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC101_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC101_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC102_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC102_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC102_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC102_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC102_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC102_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC102_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC102_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC102_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC102_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC103_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC103_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC103_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC103_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC103_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC103_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC103_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC103_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC103_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC103_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC104_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC104_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC104_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC104_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC104_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC104_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC104_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC104_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC104_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC104_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC105_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC105_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC105_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC105_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC105_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC105_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC105_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC105_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC105_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC105_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC106_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC106_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC106_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC106_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC106_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC106_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC106_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC106_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC106_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC106_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC107_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC107_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC107_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC107_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC107_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC107_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC107_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC107_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC107_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC107_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC108_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC108_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC108_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC108_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC108_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC108_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC108_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC108_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC108_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC108_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC109_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC109_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC109_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC109_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC109_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC109_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC109_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC109_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC109_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC109_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC110_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC110_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC110_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC110_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC110_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC110_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC110_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC110_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC110_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC110_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC111_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC111_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC111_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC111_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC111_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC111_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC111_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC111_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC111_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC111_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC112_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC112_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC112_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC112_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC112_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC112_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC112_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC112_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC112_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC112_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC113_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC113_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC113_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC113_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC113_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC113_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC113_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC113_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC113_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC113_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC114_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC114_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC114_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC114_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC114_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC114_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC114_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC114_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC114_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC114_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC115_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC115_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC115_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC115_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC115_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC115_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC115_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC115_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC115_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC115_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC116_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC116_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC116_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC116_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC116_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC116_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC116_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC116_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC116_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC116_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC117_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC117_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC117_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC117_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC117_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC117_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC117_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC117_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC117_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC117_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC118_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC118_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC118_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC118_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC118_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC118_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC118_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC118_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC118_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC118_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC119_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC119_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC119_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC119_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC119_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC119_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC119_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC119_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC119_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC119_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC120_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC120_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC120_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC120_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC120_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC120_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC120_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC120_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC120_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC120_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC121_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC121_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC121_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC121_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC121_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC121_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC121_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC121_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC121_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC121_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC122_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC122_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC122_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC122_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC122_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC122_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC122_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC122_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC122_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC122_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC123_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC123_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC123_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC123_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC123_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC123_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC123_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC123_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC123_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC123_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC124_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC124_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC124_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC124_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC124_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC124_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC124_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC124_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC124_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC124_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC125_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC125_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC125_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC125_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC125_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC125_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC125_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC125_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC125_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC125_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC126_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC126_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC126_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC126_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC126_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC126_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC126_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC126_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC126_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC126_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC127_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC127_IN_SEL_CFG_FUNC_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC127_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC127_IN_SEL_CFG_FUNC_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC127_IN_SEL_CFG_FUNC_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC127_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC127_IN_SEL_CFG_FUNC_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC127_IN_SEL_CFG_SIG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC127_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC127_IN_SEL_CFG_SIG_IN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC0_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC1_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC2_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC3_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC4_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC5_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC6_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC7_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC8_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC9_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC10_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC11_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC12_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC13_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC14_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC15_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC16_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC17_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC18_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC19_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC20_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC21_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC22_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC23_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC24_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC25_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC25_OUT_SEL_CFG_FUNC_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC25_OUT_SEL_CFG_FUNC_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC25_OUT_SEL_CFG_FUNC_OUT_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC25_OUT_SEL_CFG_FUNC_OUT_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC25_OUT_SEL_CFG_FUNC_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC25_OUT_SEL_CFG_FUNC_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC25_OUT_SEL_CFG_FUNC_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC25_OUT_SEL_CFG_FUNC_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.CLOCK_GATE: GPIO clock gate register
func (o *GPIO_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// GPIO.REG_DATE: GPIO version register
func (o *GPIO_Type) SetREG_DATE(value uint32) {
	volatile.StoreUint32(&o.REG_DATE.Reg, volatile.LoadUint32(&o.REG_DATE.Reg)&^(0xfffffff)|value)
}
func (o *GPIO_Type) GetREG_DATE() uint32 {
	return volatile.LoadUint32(&o.REG_DATE.Reg) & 0xfffffff
}

// Peripheral GPIOSD
type GPIOSD_Type struct {
	SIGMADELTA0        volatile.Register32 // 0x0
	SIGMADELTA1        volatile.Register32 // 0x4
	SIGMADELTA2        volatile.Register32 // 0x8
	SIGMADELTA3        volatile.Register32 // 0xC
	_                  [16]byte
	SIGMADELTA_CG      volatile.Register32 // 0x20
	SIGMADELTA_MISC    volatile.Register32 // 0x24
	SIGMADELTA_VERSION volatile.Register32 // 0x28
}

// GPIOSD.SIGMADELTA0: Duty Cycle Configure Register of SDM%s
func (o *GPIOSD_Type) SetSIGMADELTA0_SD0_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA0.Reg, volatile.LoadUint32(&o.SIGMADELTA0.Reg)&^(0xff)|value)
}
func (o *GPIOSD_Type) GetSIGMADELTA0_SD0_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA0.Reg) & 0xff
}
func (o *GPIOSD_Type) SetSIGMADELTA0_SD0_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA0.Reg, volatile.LoadUint32(&o.SIGMADELTA0.Reg)&^(0xff00)|value<<8)
}
func (o *GPIOSD_Type) GetSIGMADELTA0_SD0_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA0.Reg) & 0xff00) >> 8
}

// GPIOSD.SIGMADELTA1: Duty Cycle Configure Register of SDM%s
func (o *GPIOSD_Type) SetSIGMADELTA1_SD0_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA1.Reg, volatile.LoadUint32(&o.SIGMADELTA1.Reg)&^(0xff)|value)
}
func (o *GPIOSD_Type) GetSIGMADELTA1_SD0_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA1.Reg) & 0xff
}
func (o *GPIOSD_Type) SetSIGMADELTA1_SD0_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA1.Reg, volatile.LoadUint32(&o.SIGMADELTA1.Reg)&^(0xff00)|value<<8)
}
func (o *GPIOSD_Type) GetSIGMADELTA1_SD0_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA1.Reg) & 0xff00) >> 8
}

// GPIOSD.SIGMADELTA2: Duty Cycle Configure Register of SDM%s
func (o *GPIOSD_Type) SetSIGMADELTA2_SD0_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA2.Reg, volatile.LoadUint32(&o.SIGMADELTA2.Reg)&^(0xff)|value)
}
func (o *GPIOSD_Type) GetSIGMADELTA2_SD0_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA2.Reg) & 0xff
}
func (o *GPIOSD_Type) SetSIGMADELTA2_SD0_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA2.Reg, volatile.LoadUint32(&o.SIGMADELTA2.Reg)&^(0xff00)|value<<8)
}
func (o *GPIOSD_Type) GetSIGMADELTA2_SD0_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA2.Reg) & 0xff00) >> 8
}

// GPIOSD.SIGMADELTA3: Duty Cycle Configure Register of SDM%s
func (o *GPIOSD_Type) SetSIGMADELTA3_SD0_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA3.Reg, volatile.LoadUint32(&o.SIGMADELTA3.Reg)&^(0xff)|value)
}
func (o *GPIOSD_Type) GetSIGMADELTA3_SD0_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA3.Reg) & 0xff
}
func (o *GPIOSD_Type) SetSIGMADELTA3_SD0_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA3.Reg, volatile.LoadUint32(&o.SIGMADELTA3.Reg)&^(0xff00)|value<<8)
}
func (o *GPIOSD_Type) GetSIGMADELTA3_SD0_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA3.Reg) & 0xff00) >> 8
}

// GPIOSD.SIGMADELTA_CG: Clock Gating Configure Register
func (o *GPIOSD_Type) SetSIGMADELTA_CG_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA_CG.Reg, volatile.LoadUint32(&o.SIGMADELTA_CG.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOSD_Type) GetSIGMADELTA_CG_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA_CG.Reg) & 0x80000000) >> 31
}

// GPIOSD.SIGMADELTA_MISC: MISC Register
func (o *GPIOSD_Type) SetSIGMADELTA_MISC_FUNCTION_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA_MISC.Reg, volatile.LoadUint32(&o.SIGMADELTA_MISC.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIOSD_Type) GetSIGMADELTA_MISC_FUNCTION_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA_MISC.Reg) & 0x40000000) >> 30
}
func (o *GPIOSD_Type) SetSIGMADELTA_MISC_SPI_SWAP(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA_MISC.Reg, volatile.LoadUint32(&o.SIGMADELTA_MISC.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOSD_Type) GetSIGMADELTA_MISC_SPI_SWAP() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA_MISC.Reg) & 0x80000000) >> 31
}

// GPIOSD.SIGMADELTA_VERSION: Version Control Register
func (o *GPIOSD_Type) SetSIGMADELTA_VERSION_GPIO_SD_DATE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA_VERSION.Reg, volatile.LoadUint32(&o.SIGMADELTA_VERSION.Reg)&^(0xfffffff)|value)
}
func (o *GPIOSD_Type) GetSIGMADELTA_VERSION_GPIO_SD_DATE() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA_VERSION.Reg) & 0xfffffff
}

// Peripheral HMAC
type HMAC_Type struct {
	_                   [64]byte
	SET_START           volatile.Register32 // 0x40
	SET_PARA_PURPOSE    volatile.Register32 // 0x44
	SET_PARA_KEY        volatile.Register32 // 0x48
	SET_PARA_FINISH     volatile.Register32 // 0x4C
	SET_MESSAGE_ONE     volatile.Register32 // 0x50
	SET_MESSAGE_ING     volatile.Register32 // 0x54
	SET_MESSAGE_END     volatile.Register32 // 0x58
	SET_RESULT_FINISH   volatile.Register32 // 0x5C
	SET_INVALIDATE_JTAG volatile.Register32 // 0x60
	SET_INVALIDATE_DS   volatile.Register32 // 0x64
	QUERY_ERROR         volatile.Register32 // 0x68
	QUERY_BUSY          volatile.Register32 // 0x6C
	_                   [16]byte
	WR_MESSAGE_MEM      volatile.Register32 // 0x80
	_                   [60]byte
	RD_RESULT_MEM       volatile.Register32 // 0xC0
	_                   [44]byte
	SET_MESSAGE_PAD     volatile.Register32 // 0xF0
	ONE_BLOCK           volatile.Register32 // 0xF4
	SOFT_JTAG_CTRL      volatile.Register32 // 0xF8
	WR_JTAG             volatile.Register32 // 0xFC
}

// HMAC.SET_START: Process control register 0.
func (o *HMAC_Type) SetSET_START(value uint32) {
	volatile.StoreUint32(&o.SET_START.Reg, volatile.LoadUint32(&o.SET_START.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_START() uint32 {
	return volatile.LoadUint32(&o.SET_START.Reg) & 0x1
}

// HMAC.SET_PARA_PURPOSE: Configure purpose.
func (o *HMAC_Type) SetSET_PARA_PURPOSE_PURPOSE_SET(value uint32) {
	volatile.StoreUint32(&o.SET_PARA_PURPOSE.Reg, volatile.LoadUint32(&o.SET_PARA_PURPOSE.Reg)&^(0xf)|value)
}
func (o *HMAC_Type) GetSET_PARA_PURPOSE_PURPOSE_SET() uint32 {
	return volatile.LoadUint32(&o.SET_PARA_PURPOSE.Reg) & 0xf
}

// HMAC.SET_PARA_KEY: Configure key.
func (o *HMAC_Type) SetSET_PARA_KEY_KEY_SET(value uint32) {
	volatile.StoreUint32(&o.SET_PARA_KEY.Reg, volatile.LoadUint32(&o.SET_PARA_KEY.Reg)&^(0x7)|value)
}
func (o *HMAC_Type) GetSET_PARA_KEY_KEY_SET() uint32 {
	return volatile.LoadUint32(&o.SET_PARA_KEY.Reg) & 0x7
}

// HMAC.SET_PARA_FINISH: Finish initial configuration.
func (o *HMAC_Type) SetSET_PARA_FINISH_SET_PARA_END(value uint32) {
	volatile.StoreUint32(&o.SET_PARA_FINISH.Reg, volatile.LoadUint32(&o.SET_PARA_FINISH.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_PARA_FINISH_SET_PARA_END() uint32 {
	return volatile.LoadUint32(&o.SET_PARA_FINISH.Reg) & 0x1
}

// HMAC.SET_MESSAGE_ONE: Process control register 1.
func (o *HMAC_Type) SetSET_MESSAGE_ONE_SET_TEXT_ONE(value uint32) {
	volatile.StoreUint32(&o.SET_MESSAGE_ONE.Reg, volatile.LoadUint32(&o.SET_MESSAGE_ONE.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_MESSAGE_ONE_SET_TEXT_ONE() uint32 {
	return volatile.LoadUint32(&o.SET_MESSAGE_ONE.Reg) & 0x1
}

// HMAC.SET_MESSAGE_ING: Process control register 2.
func (o *HMAC_Type) SetSET_MESSAGE_ING_SET_TEXT_ING(value uint32) {
	volatile.StoreUint32(&o.SET_MESSAGE_ING.Reg, volatile.LoadUint32(&o.SET_MESSAGE_ING.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_MESSAGE_ING_SET_TEXT_ING() uint32 {
	return volatile.LoadUint32(&o.SET_MESSAGE_ING.Reg) & 0x1
}

// HMAC.SET_MESSAGE_END: Process control register 3.
func (o *HMAC_Type) SetSET_MESSAGE_END_SET_TEXT_END(value uint32) {
	volatile.StoreUint32(&o.SET_MESSAGE_END.Reg, volatile.LoadUint32(&o.SET_MESSAGE_END.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_MESSAGE_END_SET_TEXT_END() uint32 {
	return volatile.LoadUint32(&o.SET_MESSAGE_END.Reg) & 0x1
}

// HMAC.SET_RESULT_FINISH: Process control register 4.
func (o *HMAC_Type) SetSET_RESULT_FINISH_SET_RESULT_END(value uint32) {
	volatile.StoreUint32(&o.SET_RESULT_FINISH.Reg, volatile.LoadUint32(&o.SET_RESULT_FINISH.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_RESULT_FINISH_SET_RESULT_END() uint32 {
	return volatile.LoadUint32(&o.SET_RESULT_FINISH.Reg) & 0x1
}

// HMAC.SET_INVALIDATE_JTAG: Invalidate register 0.
func (o *HMAC_Type) SetSET_INVALIDATE_JTAG(value uint32) {
	volatile.StoreUint32(&o.SET_INVALIDATE_JTAG.Reg, volatile.LoadUint32(&o.SET_INVALIDATE_JTAG.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_INVALIDATE_JTAG() uint32 {
	return volatile.LoadUint32(&o.SET_INVALIDATE_JTAG.Reg) & 0x1
}

// HMAC.SET_INVALIDATE_DS: Invalidate register 1.
func (o *HMAC_Type) SetSET_INVALIDATE_DS(value uint32) {
	volatile.StoreUint32(&o.SET_INVALIDATE_DS.Reg, volatile.LoadUint32(&o.SET_INVALIDATE_DS.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_INVALIDATE_DS() uint32 {
	return volatile.LoadUint32(&o.SET_INVALIDATE_DS.Reg) & 0x1
}

// HMAC.QUERY_ERROR: Error register.
func (o *HMAC_Type) SetQUERY_ERROR_QUREY_CHECK(value uint32) {
	volatile.StoreUint32(&o.QUERY_ERROR.Reg, volatile.LoadUint32(&o.QUERY_ERROR.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetQUERY_ERROR_QUREY_CHECK() uint32 {
	return volatile.LoadUint32(&o.QUERY_ERROR.Reg) & 0x1
}

// HMAC.QUERY_BUSY: Busy register.
func (o *HMAC_Type) SetQUERY_BUSY_BUSY_STATE(value uint32) {
	volatile.StoreUint32(&o.QUERY_BUSY.Reg, volatile.LoadUint32(&o.QUERY_BUSY.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetQUERY_BUSY_BUSY_STATE() uint32 {
	return volatile.LoadUint32(&o.QUERY_BUSY.Reg) & 0x1
}

// HMAC.SET_MESSAGE_PAD: Process control register 5.
func (o *HMAC_Type) SetSET_MESSAGE_PAD_SET_TEXT_PAD(value uint32) {
	volatile.StoreUint32(&o.SET_MESSAGE_PAD.Reg, volatile.LoadUint32(&o.SET_MESSAGE_PAD.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_MESSAGE_PAD_SET_TEXT_PAD() uint32 {
	return volatile.LoadUint32(&o.SET_MESSAGE_PAD.Reg) & 0x1
}

// HMAC.ONE_BLOCK: Process control register 6.
func (o *HMAC_Type) SetONE_BLOCK_SET_ONE_BLOCK(value uint32) {
	volatile.StoreUint32(&o.ONE_BLOCK.Reg, volatile.LoadUint32(&o.ONE_BLOCK.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetONE_BLOCK_SET_ONE_BLOCK() uint32 {
	return volatile.LoadUint32(&o.ONE_BLOCK.Reg) & 0x1
}

// HMAC.SOFT_JTAG_CTRL: Jtag register 0.
func (o *HMAC_Type) SetSOFT_JTAG_CTRL(value uint32) {
	volatile.StoreUint32(&o.SOFT_JTAG_CTRL.Reg, volatile.LoadUint32(&o.SOFT_JTAG_CTRL.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSOFT_JTAG_CTRL() uint32 {
	return volatile.LoadUint32(&o.SOFT_JTAG_CTRL.Reg) & 0x1
}

// HMAC.WR_JTAG: Jtag register 1.
func (o *HMAC_Type) SetWR_JTAG(value uint32) {
	volatile.StoreUint32(&o.WR_JTAG.Reg, value)
}
func (o *HMAC_Type) GetWR_JTAG() uint32 {
	return volatile.LoadUint32(&o.WR_JTAG.Reg)
}

// Peripheral I2C
type I2C_Type struct {
	SCL_LOW_PERIOD       volatile.Register32 // 0x0
	CTR                  volatile.Register32 // 0x4
	SR                   volatile.Register32 // 0x8
	TO                   volatile.Register32 // 0xC
	SLAVE_ADDR           volatile.Register32 // 0x10
	FIFO_ST              volatile.Register32 // 0x14
	FIFO_CONF            volatile.Register32 // 0x18
	FIFO_DATA            volatile.Register32 // 0x1C
	INT_RAW              volatile.Register32 // 0x20
	INT_CLR              volatile.Register32 // 0x24
	INT_ENA              volatile.Register32 // 0x28
	INT_STATUS           volatile.Register32 // 0x2C
	SDA_HOLD             volatile.Register32 // 0x30
	SDA_SAMPLE           volatile.Register32 // 0x34
	SCL_HIGH_PERIOD      volatile.Register32 // 0x38
	_                    [4]byte
	SCL_START_HOLD       volatile.Register32 // 0x40
	SCL_RSTART_SETUP     volatile.Register32 // 0x44
	SCL_STOP_HOLD        volatile.Register32 // 0x48
	SCL_STOP_SETUP       volatile.Register32 // 0x4C
	FILTER_CFG           volatile.Register32 // 0x50
	CLK_CONF             volatile.Register32 // 0x54
	COMD0                volatile.Register32 // 0x58
	COMD1                volatile.Register32 // 0x5C
	COMD2                volatile.Register32 // 0x60
	COMD3                volatile.Register32 // 0x64
	COMD4                volatile.Register32 // 0x68
	COMD5                volatile.Register32 // 0x6C
	COMD6                volatile.Register32 // 0x70
	COMD7                volatile.Register32 // 0x74
	SCL_ST_TIME_OUT      volatile.Register32 // 0x78
	SCL_MAIN_ST_TIME_OUT volatile.Register32 // 0x7C
	SCL_SP_CONF          volatile.Register32 // 0x80
	SCL_STRETCH_CONF     volatile.Register32 // 0x84
	_                    [112]byte
	DATE                 volatile.Register32 // 0xF8
	_                    [4]byte
	TXFIFO_START_ADDR    volatile.Register32 // 0x100
	_                    [124]byte
	RXFIFO_START_ADDR    volatile.Register32 // 0x180
}

// I2C.SCL_LOW_PERIOD: I2C_SCL_LOW_PERIOD_REG
func (o *I2C_Type) SetSCL_LOW_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_LOW_PERIOD.Reg, volatile.LoadUint32(&o.SCL_LOW_PERIOD.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_LOW_PERIOD() uint32 {
	return volatile.LoadUint32(&o.SCL_LOW_PERIOD.Reg) & 0x1ff
}

// I2C.CTR: I2C_CTR_REG
func (o *I2C_Type) SetCTR_SDA_FORCE_OUT(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCTR_SDA_FORCE_OUT() uint32 {
	return volatile.LoadUint32(&o.CTR.Reg) & 0x1
}
func (o *I2C_Type) SetCTR_SCL_FORCE_OUT(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCTR_SCL_FORCE_OUT() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCTR_SAMPLE_SCL_LEVEL(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCTR_SAMPLE_SCL_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCTR_RX_FULL_ACK_LEVEL(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCTR_RX_FULL_ACK_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCTR_MS_MODE(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCTR_MS_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCTR_TRANS_START(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCTR_TRANS_START() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCTR_TX_LSB_FIRST(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCTR_TX_LSB_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCTR_RX_LSB_FIRST(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCTR_RX_LSB_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCTR_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetCTR_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetCTR_ARBITRATION_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetCTR_ARBITRATION_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetCTR_FSM_RST(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCTR_FSM_RST() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCTR_CONF_UPGATE(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCTR_CONF_UPGATE() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCTR_SLV_TX_AUTO_START_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCTR_SLV_TX_AUTO_START_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCTR_ADDR_10BIT_RW_CHECK_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetCTR_ADDR_10BIT_RW_CHECK_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetCTR_ADDR_BROADCASTING_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCTR_ADDR_BROADCASTING_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x4000) >> 14
}

// I2C.SR: I2C_SR_REG
func (o *I2C_Type) SetSR_RESP_REC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSR_RESP_REC() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *I2C_Type) SetSR_SLAVE_RW(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetSR_SLAVE_RW() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetSR_ARB_LOST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetSR_ARB_LOST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetSR_BUS_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetSR_BUS_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetSR_SLAVE_ADDRESSED(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetSR_SLAVE_ADDRESSED() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetSR_RXFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x3f00)|value<<8)
}
func (o *I2C_Type) GetSR_RXFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x3f00) >> 8
}
func (o *I2C_Type) SetSR_STRETCH_CAUSE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xc000)|value<<14)
}
func (o *I2C_Type) GetSR_STRETCH_CAUSE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xc000) >> 14
}
func (o *I2C_Type) SetSR_TXFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xfc0000)|value<<18)
}
func (o *I2C_Type) GetSR_TXFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xfc0000) >> 18
}
func (o *I2C_Type) SetSR_SCL_MAIN_STATE_LAST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x7000000)|value<<24)
}
func (o *I2C_Type) GetSR_SCL_MAIN_STATE_LAST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x7000000) >> 24
}
func (o *I2C_Type) SetSR_SCL_STATE_LAST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x70000000)|value<<28)
}
func (o *I2C_Type) GetSR_SCL_STATE_LAST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x70000000) >> 28
}

// I2C.TO: I2C_TO_REG
func (o *I2C_Type) SetTO_TIME_OUT_VALUE(value uint32) {
	volatile.StoreUint32(&o.TO.Reg, volatile.LoadUint32(&o.TO.Reg)&^(0x1f)|value)
}
func (o *I2C_Type) GetTO_TIME_OUT_VALUE() uint32 {
	return volatile.LoadUint32(&o.TO.Reg) & 0x1f
}
func (o *I2C_Type) SetTO_TIME_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.TO.Reg, volatile.LoadUint32(&o.TO.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetTO_TIME_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.TO.Reg) & 0x20) >> 5
}

// I2C.SLAVE_ADDR: I2C_SLAVE_ADDR_REG
func (o *I2C_Type) SetSLAVE_ADDR(value uint32) {
	volatile.StoreUint32(&o.SLAVE_ADDR.Reg, volatile.LoadUint32(&o.SLAVE_ADDR.Reg)&^(0x7fff)|value)
}
func (o *I2C_Type) GetSLAVE_ADDR() uint32 {
	return volatile.LoadUint32(&o.SLAVE_ADDR.Reg) & 0x7fff
}
func (o *I2C_Type) SetSLAVE_ADDR_ADDR_10BIT_EN(value uint32) {
	volatile.StoreUint32(&o.SLAVE_ADDR.Reg, volatile.LoadUint32(&o.SLAVE_ADDR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetSLAVE_ADDR_ADDR_10BIT_EN() uint32 {
	return (volatile.LoadUint32(&o.SLAVE_ADDR.Reg) & 0x80000000) >> 31
}

// I2C.FIFO_ST: I2C_FIFO_ST_REG
func (o *I2C_Type) SetFIFO_ST_RXFIFO_RADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x1f)|value)
}
func (o *I2C_Type) GetFIFO_ST_RXFIFO_RADDR() uint32 {
	return volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x1f
}
func (o *I2C_Type) SetFIFO_ST_RXFIFO_WADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x3e0)|value<<5)
}
func (o *I2C_Type) GetFIFO_ST_RXFIFO_WADDR() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x3e0) >> 5
}
func (o *I2C_Type) SetFIFO_ST_TXFIFO_RADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x7c00)|value<<10)
}
func (o *I2C_Type) GetFIFO_ST_TXFIFO_RADDR() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x7c00) >> 10
}
func (o *I2C_Type) SetFIFO_ST_TXFIFO_WADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0xf8000)|value<<15)
}
func (o *I2C_Type) GetFIFO_ST_TXFIFO_WADDR() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0xf8000) >> 15
}
func (o *I2C_Type) SetFIFO_ST_SLAVE_RW_POINT(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x3fc00000)|value<<22)
}
func (o *I2C_Type) GetFIFO_ST_SLAVE_RW_POINT() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x3fc00000) >> 22
}

// I2C.FIFO_CONF: I2C_FIFO_CONF_REG
func (o *I2C_Type) SetFIFO_CONF_RXFIFO_WM_THRHD(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x1f)|value)
}
func (o *I2C_Type) GetFIFO_CONF_RXFIFO_WM_THRHD() uint32 {
	return volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x1f
}
func (o *I2C_Type) SetFIFO_CONF_TXFIFO_WM_THRHD(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x3e0)|value<<5)
}
func (o *I2C_Type) GetFIFO_CONF_TXFIFO_WM_THRHD() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x3e0) >> 5
}
func (o *I2C_Type) SetFIFO_CONF_NONFIFO_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetFIFO_CONF_NONFIFO_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetFIFO_CONF_FIFO_ADDR_CFG_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetFIFO_CONF_FIFO_ADDR_CFG_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetFIFO_CONF_RX_FIFO_RST(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetFIFO_CONF_RX_FIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetFIFO_CONF_TX_FIFO_RST(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetFIFO_CONF_TX_FIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetFIFO_CONF_FIFO_PRT_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetFIFO_CONF_FIFO_PRT_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x4000) >> 14
}

// I2C.FIFO_DATA: I2C_FIFO_DATA_REG
func (o *I2C_Type) SetFIFO_DATA_FIFO_RDATA(value uint32) {
	volatile.StoreUint32(&o.FIFO_DATA.Reg, volatile.LoadUint32(&o.FIFO_DATA.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetFIFO_DATA_FIFO_RDATA() uint32 {
	return volatile.LoadUint32(&o.FIFO_DATA.Reg) & 0xff
}

// I2C.INT_RAW: I2C_INT_RAW_REG
func (o *I2C_Type) SetINT_RAW_RXFIFO_WM_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_RAW_RXFIFO_WM_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *I2C_Type) SetINT_RAW_TXFIFO_WM_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_RAW_TXFIFO_WM_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_RAW_RXFIFO_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_RAW_RXFIFO_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_RAW_END_DETECT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_RAW_END_DETECT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_RAW_BYTE_TRANS_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_RAW_BYTE_TRANS_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_RAW_ARBITRATION_LOST_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_RAW_ARBITRATION_LOST_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_RAW_MST_TXFIFO_UDF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_RAW_MST_TXFIFO_UDF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_RAW_TRANS_COMPLETE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_RAW_TRANS_COMPLETE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_RAW_TIME_OUT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_RAW_TIME_OUT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_RAW_TRANS_START_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_RAW_TRANS_START_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_RAW_NACK_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_RAW_NACK_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_RAW_TXFIFO_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_RAW_TXFIFO_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_RAW_RXFIFO_UDF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_RAW_RXFIFO_UDF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetINT_RAW_SCL_ST_TO_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetINT_RAW_SCL_ST_TO_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetINT_RAW_SCL_MAIN_ST_TO_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetINT_RAW_SCL_MAIN_ST_TO_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetINT_RAW_DET_START_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINT_RAW_DET_START_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetINT_RAW_SLAVE_STRETCH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetINT_RAW_SLAVE_STRETCH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetINT_RAW_GENERAL_CALL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetINT_RAW_GENERAL_CALL_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20000) >> 17
}

// I2C.INT_CLR: I2C_INT_CLR_REG
func (o *I2C_Type) SetINT_CLR_RXFIFO_WM_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_CLR_RXFIFO_WM_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *I2C_Type) SetINT_CLR_TXFIFO_WM_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_CLR_TXFIFO_WM_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_CLR_RXFIFO_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_CLR_RXFIFO_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_CLR_END_DETECT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_CLR_END_DETECT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_CLR_BYTE_TRANS_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_CLR_BYTE_TRANS_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_CLR_ARBITRATION_LOST_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_CLR_ARBITRATION_LOST_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_CLR_MST_TXFIFO_UDF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_CLR_MST_TXFIFO_UDF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_CLR_TRANS_COMPLETE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_CLR_TRANS_COMPLETE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_CLR_TIME_OUT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_CLR_TIME_OUT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_CLR_TRANS_START_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_CLR_TRANS_START_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_CLR_NACK_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_CLR_NACK_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_CLR_TXFIFO_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_CLR_TXFIFO_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_CLR_RXFIFO_UDF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_CLR_RXFIFO_UDF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetINT_CLR_SCL_ST_TO_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetINT_CLR_SCL_ST_TO_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetINT_CLR_SCL_MAIN_ST_TO_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetINT_CLR_SCL_MAIN_ST_TO_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetINT_CLR_DET_START_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINT_CLR_DET_START_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetINT_CLR_SLAVE_STRETCH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetINT_CLR_SLAVE_STRETCH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetINT_CLR_GENERAL_CALL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetINT_CLR_GENERAL_CALL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20000) >> 17
}

// I2C.INT_ENA: I2C_INT_ENA_REG
func (o *I2C_Type) SetINT_ENA_RXFIFO_WM_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_ENA_RXFIFO_WM_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *I2C_Type) SetINT_ENA_TXFIFO_WM_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_ENA_TXFIFO_WM_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_ENA_RXFIFO_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_ENA_RXFIFO_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_ENA_END_DETECT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_ENA_END_DETECT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_ENA_BYTE_TRANS_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_ENA_BYTE_TRANS_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_ENA_ARBITRATION_LOST_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_ENA_ARBITRATION_LOST_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_ENA_MST_TXFIFO_UDF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_ENA_MST_TXFIFO_UDF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_ENA_TRANS_COMPLETE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_ENA_TRANS_COMPLETE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_ENA_TIME_OUT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_ENA_TIME_OUT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_ENA_TRANS_START_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_ENA_TRANS_START_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_ENA_NACK_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_ENA_NACK_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_ENA_TXFIFO_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_ENA_TXFIFO_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_ENA_RXFIFO_UDF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_ENA_RXFIFO_UDF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetINT_ENA_SCL_ST_TO_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetINT_ENA_SCL_ST_TO_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetINT_ENA_SCL_MAIN_ST_TO_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetINT_ENA_SCL_MAIN_ST_TO_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetINT_ENA_DET_START_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINT_ENA_DET_START_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetINT_ENA_SLAVE_STRETCH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetINT_ENA_SLAVE_STRETCH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetINT_ENA_GENERAL_CALL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetINT_ENA_GENERAL_CALL_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20000) >> 17
}

// I2C.INT_STATUS: I2C_INT_STATUS_REG
func (o *I2C_Type) SetINT_STATUS_RXFIFO_WM_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_STATUS_RXFIFO_WM_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x1
}
func (o *I2C_Type) SetINT_STATUS_TXFIFO_WM_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_STATUS_TXFIFO_WM_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_STATUS_RXFIFO_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_STATUS_RXFIFO_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_STATUS_END_DETECT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_STATUS_END_DETECT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_STATUS_BYTE_TRANS_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_STATUS_BYTE_TRANS_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_STATUS_ARBITRATION_LOST_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_STATUS_ARBITRATION_LOST_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_STATUS_MST_TXFIFO_UDF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_STATUS_MST_TXFIFO_UDF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_STATUS_TRANS_COMPLETE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_STATUS_TRANS_COMPLETE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_STATUS_TIME_OUT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_STATUS_TIME_OUT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_STATUS_TRANS_START_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_STATUS_TRANS_START_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_STATUS_NACK_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_STATUS_NACK_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_STATUS_TXFIFO_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_STATUS_TXFIFO_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_STATUS_RXFIFO_UDF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_STATUS_RXFIFO_UDF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetINT_STATUS_SCL_ST_TO_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetINT_STATUS_SCL_ST_TO_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetINT_STATUS_SCL_MAIN_ST_TO_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetINT_STATUS_SCL_MAIN_ST_TO_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetINT_STATUS_DET_START_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINT_STATUS_DET_START_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetINT_STATUS_SLAVE_STRETCH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetINT_STATUS_SLAVE_STRETCH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetINT_STATUS_GENERAL_CALL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetINT_STATUS_GENERAL_CALL_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x20000) >> 17
}

// I2C.SDA_HOLD: I2C_SDA_HOLD_REG
func (o *I2C_Type) SetSDA_HOLD_TIME(value uint32) {
	volatile.StoreUint32(&o.SDA_HOLD.Reg, volatile.LoadUint32(&o.SDA_HOLD.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSDA_HOLD_TIME() uint32 {
	return volatile.LoadUint32(&o.SDA_HOLD.Reg) & 0x1ff
}

// I2C.SDA_SAMPLE: I2C_SDA_SAMPLE_REG
func (o *I2C_Type) SetSDA_SAMPLE_TIME(value uint32) {
	volatile.StoreUint32(&o.SDA_SAMPLE.Reg, volatile.LoadUint32(&o.SDA_SAMPLE.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSDA_SAMPLE_TIME() uint32 {
	return volatile.LoadUint32(&o.SDA_SAMPLE.Reg) & 0x1ff
}

// I2C.SCL_HIGH_PERIOD: I2C_SCL_HIGH_PERIOD_REG
func (o *I2C_Type) SetSCL_HIGH_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_HIGH_PERIOD.Reg, volatile.LoadUint32(&o.SCL_HIGH_PERIOD.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_HIGH_PERIOD() uint32 {
	return volatile.LoadUint32(&o.SCL_HIGH_PERIOD.Reg) & 0x1ff
}
func (o *I2C_Type) SetSCL_HIGH_PERIOD_SCL_WAIT_HIGH_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_HIGH_PERIOD.Reg, volatile.LoadUint32(&o.SCL_HIGH_PERIOD.Reg)&^(0xfe00)|value<<9)
}
func (o *I2C_Type) GetSCL_HIGH_PERIOD_SCL_WAIT_HIGH_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.SCL_HIGH_PERIOD.Reg) & 0xfe00) >> 9
}

// I2C.SCL_START_HOLD: I2C_SCL_START_HOLD_REG
func (o *I2C_Type) SetSCL_START_HOLD_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_START_HOLD.Reg, volatile.LoadUint32(&o.SCL_START_HOLD.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_START_HOLD_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_START_HOLD.Reg) & 0x1ff
}

// I2C.SCL_RSTART_SETUP: I2C_SCL_RSTART_SETUP_REG
func (o *I2C_Type) SetSCL_RSTART_SETUP_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_RSTART_SETUP.Reg, volatile.LoadUint32(&o.SCL_RSTART_SETUP.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_RSTART_SETUP_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_RSTART_SETUP.Reg) & 0x1ff
}

// I2C.SCL_STOP_HOLD: I2C_SCL_STOP_HOLD_REG
func (o *I2C_Type) SetSCL_STOP_HOLD_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_STOP_HOLD.Reg, volatile.LoadUint32(&o.SCL_STOP_HOLD.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_STOP_HOLD_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_STOP_HOLD.Reg) & 0x1ff
}

// I2C.SCL_STOP_SETUP: I2C_SCL_STOP_SETUP_REG
func (o *I2C_Type) SetSCL_STOP_SETUP_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_STOP_SETUP.Reg, volatile.LoadUint32(&o.SCL_STOP_SETUP.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_STOP_SETUP_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_STOP_SETUP.Reg) & 0x1ff
}

// I2C.FILTER_CFG: I2C_FILTER_CFG_REG
func (o *I2C_Type) SetFILTER_CFG_SCL_FILTER_THRES(value uint32) {
	volatile.StoreUint32(&o.FILTER_CFG.Reg, volatile.LoadUint32(&o.FILTER_CFG.Reg)&^(0xf)|value)
}
func (o *I2C_Type) GetFILTER_CFG_SCL_FILTER_THRES() uint32 {
	return volatile.LoadUint32(&o.FILTER_CFG.Reg) & 0xf
}
func (o *I2C_Type) SetFILTER_CFG_SDA_FILTER_THRES(value uint32) {
	volatile.StoreUint32(&o.FILTER_CFG.Reg, volatile.LoadUint32(&o.FILTER_CFG.Reg)&^(0xf0)|value<<4)
}
func (o *I2C_Type) GetFILTER_CFG_SDA_FILTER_THRES() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CFG.Reg) & 0xf0) >> 4
}
func (o *I2C_Type) SetFILTER_CFG_SCL_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.FILTER_CFG.Reg, volatile.LoadUint32(&o.FILTER_CFG.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetFILTER_CFG_SCL_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CFG.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetFILTER_CFG_SDA_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.FILTER_CFG.Reg, volatile.LoadUint32(&o.FILTER_CFG.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetFILTER_CFG_SDA_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CFG.Reg) & 0x200) >> 9
}

// I2C.CLK_CONF: I2C_CLK_CONF_REG
func (o *I2C_Type) SetCLK_CONF_SCLK_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetCLK_CONF_SCLK_DIV_NUM() uint32 {
	return volatile.LoadUint32(&o.CLK_CONF.Reg) & 0xff
}
func (o *I2C_Type) SetCLK_CONF_SCLK_DIV_A(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x3f00)|value<<8)
}
func (o *I2C_Type) GetCLK_CONF_SCLK_DIV_A() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x3f00) >> 8
}
func (o *I2C_Type) SetCLK_CONF_SCLK_DIV_B(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0xfc000)|value<<14)
}
func (o *I2C_Type) GetCLK_CONF_SCLK_DIV_B() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0xfc000) >> 14
}
func (o *I2C_Type) SetCLK_CONF_SCLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *I2C_Type) GetCLK_CONF_SCLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x100000) >> 20
}
func (o *I2C_Type) SetCLK_CONF_SCLK_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x200000)|value<<21)
}
func (o *I2C_Type) GetCLK_CONF_SCLK_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x200000) >> 21
}

// I2C.COMD0: I2C_COMD%s_REG
func (o *I2C_Type) SetCOMD0_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD0.Reg, volatile.LoadUint32(&o.COMD0.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD0_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD0.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD0_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD0.Reg, volatile.LoadUint32(&o.COMD0.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD0_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD0.Reg) & 0x80000000) >> 31
}

// I2C.COMD1: I2C_COMD%s_REG
func (o *I2C_Type) SetCOMD1_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD1.Reg, volatile.LoadUint32(&o.COMD1.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD1_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD1.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD1_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD1.Reg, volatile.LoadUint32(&o.COMD1.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD1_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD1.Reg) & 0x80000000) >> 31
}

// I2C.COMD2: I2C_COMD%s_REG
func (o *I2C_Type) SetCOMD2_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD2.Reg, volatile.LoadUint32(&o.COMD2.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD2_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD2.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD2_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD2.Reg, volatile.LoadUint32(&o.COMD2.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD2_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD2.Reg) & 0x80000000) >> 31
}

// I2C.COMD3: I2C_COMD%s_REG
func (o *I2C_Type) SetCOMD3_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD3.Reg, volatile.LoadUint32(&o.COMD3.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD3_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD3.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD3_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD3.Reg, volatile.LoadUint32(&o.COMD3.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD3_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD3.Reg) & 0x80000000) >> 31
}

// I2C.COMD4: I2C_COMD%s_REG
func (o *I2C_Type) SetCOMD4_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD4.Reg, volatile.LoadUint32(&o.COMD4.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD4_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD4.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD4_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD4.Reg, volatile.LoadUint32(&o.COMD4.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD4_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD4.Reg) & 0x80000000) >> 31
}

// I2C.COMD5: I2C_COMD%s_REG
func (o *I2C_Type) SetCOMD5_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD5.Reg, volatile.LoadUint32(&o.COMD5.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD5_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD5.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD5_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD5.Reg, volatile.LoadUint32(&o.COMD5.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD5_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD5.Reg) & 0x80000000) >> 31
}

// I2C.COMD6: I2C_COMD%s_REG
func (o *I2C_Type) SetCOMD6_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD6.Reg, volatile.LoadUint32(&o.COMD6.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD6_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD6.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD6_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD6.Reg, volatile.LoadUint32(&o.COMD6.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD6_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD6.Reg) & 0x80000000) >> 31
}

// I2C.COMD7: I2C_COMD%s_REG
func (o *I2C_Type) SetCOMD7_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD7.Reg, volatile.LoadUint32(&o.COMD7.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD7_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD7.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD7_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD7.Reg, volatile.LoadUint32(&o.COMD7.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD7_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD7.Reg) & 0x80000000) >> 31
}

// I2C.SCL_ST_TIME_OUT: I2C_SCL_ST_TIME_OUT_REG
func (o *I2C_Type) SetSCL_ST_TIME_OUT_SCL_ST_TO_I2C(value uint32) {
	volatile.StoreUint32(&o.SCL_ST_TIME_OUT.Reg, volatile.LoadUint32(&o.SCL_ST_TIME_OUT.Reg)&^(0x1f)|value)
}
func (o *I2C_Type) GetSCL_ST_TIME_OUT_SCL_ST_TO_I2C() uint32 {
	return volatile.LoadUint32(&o.SCL_ST_TIME_OUT.Reg) & 0x1f
}

// I2C.SCL_MAIN_ST_TIME_OUT: I2C_SCL_MAIN_ST_TIME_OUT_REG
func (o *I2C_Type) SetSCL_MAIN_ST_TIME_OUT_SCL_MAIN_ST_TO_I2C(value uint32) {
	volatile.StoreUint32(&o.SCL_MAIN_ST_TIME_OUT.Reg, volatile.LoadUint32(&o.SCL_MAIN_ST_TIME_OUT.Reg)&^(0x1f)|value)
}
func (o *I2C_Type) GetSCL_MAIN_ST_TIME_OUT_SCL_MAIN_ST_TO_I2C() uint32 {
	return volatile.LoadUint32(&o.SCL_MAIN_ST_TIME_OUT.Reg) & 0x1f
}

// I2C.SCL_SP_CONF: I2C_SCL_SP_CONF_REG
func (o *I2C_Type) SetSCL_SP_CONF_SCL_RST_SLV_EN(value uint32) {
	volatile.StoreUint32(&o.SCL_SP_CONF.Reg, volatile.LoadUint32(&o.SCL_SP_CONF.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSCL_SP_CONF_SCL_RST_SLV_EN() uint32 {
	return volatile.LoadUint32(&o.SCL_SP_CONF.Reg) & 0x1
}
func (o *I2C_Type) SetSCL_SP_CONF_SCL_RST_SLV_NUM(value uint32) {
	volatile.StoreUint32(&o.SCL_SP_CONF.Reg, volatile.LoadUint32(&o.SCL_SP_CONF.Reg)&^(0x3e)|value<<1)
}
func (o *I2C_Type) GetSCL_SP_CONF_SCL_RST_SLV_NUM() uint32 {
	return (volatile.LoadUint32(&o.SCL_SP_CONF.Reg) & 0x3e) >> 1
}
func (o *I2C_Type) SetSCL_SP_CONF_SCL_PD_EN(value uint32) {
	volatile.StoreUint32(&o.SCL_SP_CONF.Reg, volatile.LoadUint32(&o.SCL_SP_CONF.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetSCL_SP_CONF_SCL_PD_EN() uint32 {
	return (volatile.LoadUint32(&o.SCL_SP_CONF.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetSCL_SP_CONF_SDA_PD_EN(value uint32) {
	volatile.StoreUint32(&o.SCL_SP_CONF.Reg, volatile.LoadUint32(&o.SCL_SP_CONF.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetSCL_SP_CONF_SDA_PD_EN() uint32 {
	return (volatile.LoadUint32(&o.SCL_SP_CONF.Reg) & 0x80) >> 7
}

// I2C.SCL_STRETCH_CONF: I2C_SCL_STRETCH_CONF_REG
func (o *I2C_Type) SetSCL_STRETCH_CONF_STRETCH_PROTECT_NUM(value uint32) {
	volatile.StoreUint32(&o.SCL_STRETCH_CONF.Reg, volatile.LoadUint32(&o.SCL_STRETCH_CONF.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetSCL_STRETCH_CONF_STRETCH_PROTECT_NUM() uint32 {
	return volatile.LoadUint32(&o.SCL_STRETCH_CONF.Reg) & 0x3ff
}
func (o *I2C_Type) SetSCL_STRETCH_CONF_SLAVE_SCL_STRETCH_EN(value uint32) {
	volatile.StoreUint32(&o.SCL_STRETCH_CONF.Reg, volatile.LoadUint32(&o.SCL_STRETCH_CONF.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetSCL_STRETCH_CONF_SLAVE_SCL_STRETCH_EN() uint32 {
	return (volatile.LoadUint32(&o.SCL_STRETCH_CONF.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetSCL_STRETCH_CONF_SLAVE_SCL_STRETCH_CLR(value uint32) {
	volatile.StoreUint32(&o.SCL_STRETCH_CONF.Reg, volatile.LoadUint32(&o.SCL_STRETCH_CONF.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetSCL_STRETCH_CONF_SLAVE_SCL_STRETCH_CLR() uint32 {
	return (volatile.LoadUint32(&o.SCL_STRETCH_CONF.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetSCL_STRETCH_CONF_SLAVE_BYTE_ACK_CTL_EN(value uint32) {
	volatile.StoreUint32(&o.SCL_STRETCH_CONF.Reg, volatile.LoadUint32(&o.SCL_STRETCH_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetSCL_STRETCH_CONF_SLAVE_BYTE_ACK_CTL_EN() uint32 {
	return (volatile.LoadUint32(&o.SCL_STRETCH_CONF.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetSCL_STRETCH_CONF_SLAVE_BYTE_ACK_LVL(value uint32) {
	volatile.StoreUint32(&o.SCL_STRETCH_CONF.Reg, volatile.LoadUint32(&o.SCL_STRETCH_CONF.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetSCL_STRETCH_CONF_SLAVE_BYTE_ACK_LVL() uint32 {
	return (volatile.LoadUint32(&o.SCL_STRETCH_CONF.Reg) & 0x2000) >> 13
}

// I2C.DATE: I2C_DATE_REG
func (o *I2C_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *I2C_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// I2C.TXFIFO_START_ADDR: I2C_TXFIFO_START_ADDR_REG
func (o *I2C_Type) SetTXFIFO_START_ADDR(value uint32) {
	volatile.StoreUint32(&o.TXFIFO_START_ADDR.Reg, value)
}
func (o *I2C_Type) GetTXFIFO_START_ADDR() uint32 {
	return volatile.LoadUint32(&o.TXFIFO_START_ADDR.Reg)
}

// I2C.RXFIFO_START_ADDR: I2C_RXFIFO_START_ADDR_REG
func (o *I2C_Type) SetRXFIFO_START_ADDR(value uint32) {
	volatile.StoreUint32(&o.RXFIFO_START_ADDR.Reg, value)
}
func (o *I2C_Type) GetRXFIFO_START_ADDR() uint32 {
	return volatile.LoadUint32(&o.RXFIFO_START_ADDR.Reg)
}

// Peripheral I2S
type I2S_Type struct {
	_                [12]byte
	INT_RAW          volatile.Register32 // 0xC
	INT_ST           volatile.Register32 // 0x10
	INT_ENA          volatile.Register32 // 0x14
	INT_CLR          volatile.Register32 // 0x18
	_                [4]byte
	RX_CONF          volatile.Register32 // 0x20
	TX_CONF          volatile.Register32 // 0x24
	RX_CONF1         volatile.Register32 // 0x28
	TX_CONF1         volatile.Register32 // 0x2C
	RX_CLKM_CONF     volatile.Register32 // 0x30
	TX_CLKM_CONF     volatile.Register32 // 0x34
	RX_CLKM_DIV_CONF volatile.Register32 // 0x38
	TX_CLKM_DIV_CONF volatile.Register32 // 0x3C
	TX_PCM2PDM_CONF  volatile.Register32 // 0x40
	TX_PCM2PDM_CONF1 volatile.Register32 // 0x44
	_                [8]byte
	RX_TDM_CTRL      volatile.Register32 // 0x50
	TX_TDM_CTRL      volatile.Register32 // 0x54
	RX_TIMING        volatile.Register32 // 0x58
	TX_TIMING        volatile.Register32 // 0x5C
	LC_HUNG_CONF     volatile.Register32 // 0x60
	RXEOF_NUM        volatile.Register32 // 0x64
	CONF_SIGLE_DATA  volatile.Register32 // 0x68
	STATE            volatile.Register32 // 0x6C
	_                [16]byte
	DATE             volatile.Register32 // 0x80
}

// I2S.INT_RAW: I2S interrupt raw register, valid in level.
func (o *I2S_Type) SetINT_RAW_RX_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetINT_RAW_RX_DONE_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *I2S_Type) SetINT_RAW_TX_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINT_RAW_TX_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINT_RAW_RX_HUNG_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINT_RAW_RX_HUNG_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINT_RAW_TX_HUNG_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetINT_RAW_TX_HUNG_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8) >> 3
}

// I2S.INT_ST: I2S interrupt status register.
func (o *I2S_Type) SetINT_ST_RX_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetINT_ST_RX_DONE_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST.Reg) & 0x1
}
func (o *I2S_Type) SetINT_ST_TX_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINT_ST_TX_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINT_ST_RX_HUNG_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINT_ST_RX_HUNG_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINT_ST_TX_HUNG_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetINT_ST_TX_HUNG_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8) >> 3
}

// I2S.INT_ENA: I2S interrupt enable register.
func (o *I2S_Type) SetINT_ENA_RX_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetINT_ENA_RX_DONE_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *I2S_Type) SetINT_ENA_TX_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINT_ENA_TX_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINT_ENA_RX_HUNG_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINT_ENA_RX_HUNG_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINT_ENA_TX_HUNG_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetINT_ENA_TX_HUNG_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8) >> 3
}

// I2S.INT_CLR: I2S interrupt clear register.
func (o *I2S_Type) SetINT_CLR_RX_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetINT_CLR_RX_DONE_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *I2S_Type) SetINT_CLR_TX_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINT_CLR_TX_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINT_CLR_RX_HUNG_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINT_CLR_RX_HUNG_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINT_CLR_TX_HUNG_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetINT_CLR_TX_HUNG_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8) >> 3
}

// I2S.RX_CONF: I2S RX configure register
func (o *I2S_Type) SetRX_CONF_RX_RESET(value uint32) {
	volatile.StoreUint32(&o.RX_CONF.Reg, volatile.LoadUint32(&o.RX_CONF.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetRX_CONF_RX_RESET() uint32 {
	return volatile.LoadUint32(&o.RX_CONF.Reg) & 0x1
}
func (o *I2S_Type) SetRX_CONF_RX_FIFO_RESET(value uint32) {
	volatile.StoreUint32(&o.RX_CONF.Reg, volatile.LoadUint32(&o.RX_CONF.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetRX_CONF_RX_FIFO_RESET() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetRX_CONF_RX_START(value uint32) {
	volatile.StoreUint32(&o.RX_CONF.Reg, volatile.LoadUint32(&o.RX_CONF.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetRX_CONF_RX_START() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetRX_CONF_RX_SLAVE_MOD(value uint32) {
	volatile.StoreUint32(&o.RX_CONF.Reg, volatile.LoadUint32(&o.RX_CONF.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetRX_CONF_RX_SLAVE_MOD() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetRX_CONF_RX_MONO(value uint32) {
	volatile.StoreUint32(&o.RX_CONF.Reg, volatile.LoadUint32(&o.RX_CONF.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetRX_CONF_RX_MONO() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetRX_CONF_RX_BIG_ENDIAN(value uint32) {
	volatile.StoreUint32(&o.RX_CONF.Reg, volatile.LoadUint32(&o.RX_CONF.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetRX_CONF_RX_BIG_ENDIAN() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetRX_CONF_RX_UPDATE(value uint32) {
	volatile.StoreUint32(&o.RX_CONF.Reg, volatile.LoadUint32(&o.RX_CONF.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetRX_CONF_RX_UPDATE() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetRX_CONF_RX_MONO_FST_VLD(value uint32) {
	volatile.StoreUint32(&o.RX_CONF.Reg, volatile.LoadUint32(&o.RX_CONF.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetRX_CONF_RX_MONO_FST_VLD() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetRX_CONF_RX_PCM_CONF(value uint32) {
	volatile.StoreUint32(&o.RX_CONF.Reg, volatile.LoadUint32(&o.RX_CONF.Reg)&^(0xc00)|value<<10)
}
func (o *I2S_Type) GetRX_CONF_RX_PCM_CONF() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF.Reg) & 0xc00) >> 10
}
func (o *I2S_Type) SetRX_CONF_RX_PCM_BYPASS(value uint32) {
	volatile.StoreUint32(&o.RX_CONF.Reg, volatile.LoadUint32(&o.RX_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetRX_CONF_RX_PCM_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetRX_CONF_RX_STOP_MODE(value uint32) {
	volatile.StoreUint32(&o.RX_CONF.Reg, volatile.LoadUint32(&o.RX_CONF.Reg)&^(0x6000)|value<<13)
}
func (o *I2S_Type) GetRX_CONF_RX_STOP_MODE() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF.Reg) & 0x6000) >> 13
}
func (o *I2S_Type) SetRX_CONF_RX_LEFT_ALIGN(value uint32) {
	volatile.StoreUint32(&o.RX_CONF.Reg, volatile.LoadUint32(&o.RX_CONF.Reg)&^(0x8000)|value<<15)
}
func (o *I2S_Type) GetRX_CONF_RX_LEFT_ALIGN() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF.Reg) & 0x8000) >> 15
}
func (o *I2S_Type) SetRX_CONF_RX_24_FILL_EN(value uint32) {
	volatile.StoreUint32(&o.RX_CONF.Reg, volatile.LoadUint32(&o.RX_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetRX_CONF_RX_24_FILL_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF.Reg) & 0x10000) >> 16
}
func (o *I2S_Type) SetRX_CONF_RX_WS_IDLE_POL(value uint32) {
	volatile.StoreUint32(&o.RX_CONF.Reg, volatile.LoadUint32(&o.RX_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *I2S_Type) GetRX_CONF_RX_WS_IDLE_POL() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF.Reg) & 0x20000) >> 17
}
func (o *I2S_Type) SetRX_CONF_RX_BIT_ORDER(value uint32) {
	volatile.StoreUint32(&o.RX_CONF.Reg, volatile.LoadUint32(&o.RX_CONF.Reg)&^(0x40000)|value<<18)
}
func (o *I2S_Type) GetRX_CONF_RX_BIT_ORDER() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF.Reg) & 0x40000) >> 18
}
func (o *I2S_Type) SetRX_CONF_RX_TDM_EN(value uint32) {
	volatile.StoreUint32(&o.RX_CONF.Reg, volatile.LoadUint32(&o.RX_CONF.Reg)&^(0x80000)|value<<19)
}
func (o *I2S_Type) GetRX_CONF_RX_TDM_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF.Reg) & 0x80000) >> 19
}
func (o *I2S_Type) SetRX_CONF_RX_PDM_EN(value uint32) {
	volatile.StoreUint32(&o.RX_CONF.Reg, volatile.LoadUint32(&o.RX_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *I2S_Type) GetRX_CONF_RX_PDM_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF.Reg) & 0x100000) >> 20
}

// I2S.TX_CONF: I2S TX configure register
func (o *I2S_Type) SetTX_CONF_TX_RESET(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetTX_CONF_TX_RESET() uint32 {
	return volatile.LoadUint32(&o.TX_CONF.Reg) & 0x1
}
func (o *I2S_Type) SetTX_CONF_TX_FIFO_RESET(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetTX_CONF_TX_FIFO_RESET() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetTX_CONF_TX_START(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetTX_CONF_TX_START() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetTX_CONF_TX_SLAVE_MOD(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetTX_CONF_TX_SLAVE_MOD() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetTX_CONF_TX_MONO(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetTX_CONF_TX_MONO() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetTX_CONF_TX_CHAN_EQUAL(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x40)|value<<6)
}
func (o *I2S_Type) GetTX_CONF_TX_CHAN_EQUAL() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0x40) >> 6
}
func (o *I2S_Type) SetTX_CONF_TX_BIG_ENDIAN(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetTX_CONF_TX_BIG_ENDIAN() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetTX_CONF_TX_UPDATE(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetTX_CONF_TX_UPDATE() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetTX_CONF_TX_MONO_FST_VLD(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetTX_CONF_TX_MONO_FST_VLD() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetTX_CONF_TX_PCM_CONF(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0xc00)|value<<10)
}
func (o *I2S_Type) GetTX_CONF_TX_PCM_CONF() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0xc00) >> 10
}
func (o *I2S_Type) SetTX_CONF_TX_PCM_BYPASS(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetTX_CONF_TX_PCM_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetTX_CONF_TX_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x2000)|value<<13)
}
func (o *I2S_Type) GetTX_CONF_TX_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0x2000) >> 13
}
func (o *I2S_Type) SetTX_CONF_TX_LEFT_ALIGN(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x8000)|value<<15)
}
func (o *I2S_Type) GetTX_CONF_TX_LEFT_ALIGN() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0x8000) >> 15
}
func (o *I2S_Type) SetTX_CONF_TX_24_FILL_EN(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetTX_CONF_TX_24_FILL_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0x10000) >> 16
}
func (o *I2S_Type) SetTX_CONF_TX_WS_IDLE_POL(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *I2S_Type) GetTX_CONF_TX_WS_IDLE_POL() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0x20000) >> 17
}
func (o *I2S_Type) SetTX_CONF_TX_BIT_ORDER(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x40000)|value<<18)
}
func (o *I2S_Type) GetTX_CONF_TX_BIT_ORDER() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0x40000) >> 18
}
func (o *I2S_Type) SetTX_CONF_TX_TDM_EN(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x80000)|value<<19)
}
func (o *I2S_Type) GetTX_CONF_TX_TDM_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0x80000) >> 19
}
func (o *I2S_Type) SetTX_CONF_TX_PDM_EN(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *I2S_Type) GetTX_CONF_TX_PDM_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0x100000) >> 20
}
func (o *I2S_Type) SetTX_CONF_TX_CHAN_MOD(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x7000000)|value<<24)
}
func (o *I2S_Type) GetTX_CONF_TX_CHAN_MOD() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0x7000000) >> 24
}
func (o *I2S_Type) SetTX_CONF_SIG_LOOPBACK(value uint32) {
	volatile.StoreUint32(&o.TX_CONF.Reg, volatile.LoadUint32(&o.TX_CONF.Reg)&^(0x8000000)|value<<27)
}
func (o *I2S_Type) GetTX_CONF_SIG_LOOPBACK() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF.Reg) & 0x8000000) >> 27
}

// I2S.RX_CONF1: I2S RX configure register 1
func (o *I2S_Type) SetRX_CONF1_RX_TDM_WS_WIDTH(value uint32) {
	volatile.StoreUint32(&o.RX_CONF1.Reg, volatile.LoadUint32(&o.RX_CONF1.Reg)&^(0x7f)|value)
}
func (o *I2S_Type) GetRX_CONF1_RX_TDM_WS_WIDTH() uint32 {
	return volatile.LoadUint32(&o.RX_CONF1.Reg) & 0x7f
}
func (o *I2S_Type) SetRX_CONF1_RX_BCK_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.RX_CONF1.Reg, volatile.LoadUint32(&o.RX_CONF1.Reg)&^(0x1f80)|value<<7)
}
func (o *I2S_Type) GetRX_CONF1_RX_BCK_DIV_NUM() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF1.Reg) & 0x1f80) >> 7
}
func (o *I2S_Type) SetRX_CONF1_RX_BITS_MOD(value uint32) {
	volatile.StoreUint32(&o.RX_CONF1.Reg, volatile.LoadUint32(&o.RX_CONF1.Reg)&^(0x3e000)|value<<13)
}
func (o *I2S_Type) GetRX_CONF1_RX_BITS_MOD() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF1.Reg) & 0x3e000) >> 13
}
func (o *I2S_Type) SetRX_CONF1_RX_HALF_SAMPLE_BITS(value uint32) {
	volatile.StoreUint32(&o.RX_CONF1.Reg, volatile.LoadUint32(&o.RX_CONF1.Reg)&^(0xfc0000)|value<<18)
}
func (o *I2S_Type) GetRX_CONF1_RX_HALF_SAMPLE_BITS() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF1.Reg) & 0xfc0000) >> 18
}
func (o *I2S_Type) SetRX_CONF1_RX_TDM_CHAN_BITS(value uint32) {
	volatile.StoreUint32(&o.RX_CONF1.Reg, volatile.LoadUint32(&o.RX_CONF1.Reg)&^(0x1f000000)|value<<24)
}
func (o *I2S_Type) GetRX_CONF1_RX_TDM_CHAN_BITS() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF1.Reg) & 0x1f000000) >> 24
}
func (o *I2S_Type) SetRX_CONF1_RX_MSB_SHIFT(value uint32) {
	volatile.StoreUint32(&o.RX_CONF1.Reg, volatile.LoadUint32(&o.RX_CONF1.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S_Type) GetRX_CONF1_RX_MSB_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.RX_CONF1.Reg) & 0x20000000) >> 29
}

// I2S.TX_CONF1: I2S TX configure register 1
func (o *I2S_Type) SetTX_CONF1_TX_TDM_WS_WIDTH(value uint32) {
	volatile.StoreUint32(&o.TX_CONF1.Reg, volatile.LoadUint32(&o.TX_CONF1.Reg)&^(0x7f)|value)
}
func (o *I2S_Type) GetTX_CONF1_TX_TDM_WS_WIDTH() uint32 {
	return volatile.LoadUint32(&o.TX_CONF1.Reg) & 0x7f
}
func (o *I2S_Type) SetTX_CONF1_TX_BCK_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.TX_CONF1.Reg, volatile.LoadUint32(&o.TX_CONF1.Reg)&^(0x1f80)|value<<7)
}
func (o *I2S_Type) GetTX_CONF1_TX_BCK_DIV_NUM() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF1.Reg) & 0x1f80) >> 7
}
func (o *I2S_Type) SetTX_CONF1_TX_BITS_MOD(value uint32) {
	volatile.StoreUint32(&o.TX_CONF1.Reg, volatile.LoadUint32(&o.TX_CONF1.Reg)&^(0x3e000)|value<<13)
}
func (o *I2S_Type) GetTX_CONF1_TX_BITS_MOD() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF1.Reg) & 0x3e000) >> 13
}
func (o *I2S_Type) SetTX_CONF1_TX_HALF_SAMPLE_BITS(value uint32) {
	volatile.StoreUint32(&o.TX_CONF1.Reg, volatile.LoadUint32(&o.TX_CONF1.Reg)&^(0xfc0000)|value<<18)
}
func (o *I2S_Type) GetTX_CONF1_TX_HALF_SAMPLE_BITS() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF1.Reg) & 0xfc0000) >> 18
}
func (o *I2S_Type) SetTX_CONF1_TX_TDM_CHAN_BITS(value uint32) {
	volatile.StoreUint32(&o.TX_CONF1.Reg, volatile.LoadUint32(&o.TX_CONF1.Reg)&^(0x1f000000)|value<<24)
}
func (o *I2S_Type) GetTX_CONF1_TX_TDM_CHAN_BITS() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF1.Reg) & 0x1f000000) >> 24
}
func (o *I2S_Type) SetTX_CONF1_TX_MSB_SHIFT(value uint32) {
	volatile.StoreUint32(&o.TX_CONF1.Reg, volatile.LoadUint32(&o.TX_CONF1.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S_Type) GetTX_CONF1_TX_MSB_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF1.Reg) & 0x20000000) >> 29
}
func (o *I2S_Type) SetTX_CONF1_TX_BCK_NO_DLY(value uint32) {
	volatile.StoreUint32(&o.TX_CONF1.Reg, volatile.LoadUint32(&o.TX_CONF1.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S_Type) GetTX_CONF1_TX_BCK_NO_DLY() uint32 {
	return (volatile.LoadUint32(&o.TX_CONF1.Reg) & 0x40000000) >> 30
}

// I2S.RX_CLKM_CONF: I2S RX clock configure register
func (o *I2S_Type) SetRX_CLKM_CONF_RX_CLKM_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.RX_CLKM_CONF.Reg, volatile.LoadUint32(&o.RX_CLKM_CONF.Reg)&^(0xff)|value)
}
func (o *I2S_Type) GetRX_CLKM_CONF_RX_CLKM_DIV_NUM() uint32 {
	return volatile.LoadUint32(&o.RX_CLKM_CONF.Reg) & 0xff
}
func (o *I2S_Type) SetRX_CLKM_CONF_RX_CLK_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.RX_CLKM_CONF.Reg, volatile.LoadUint32(&o.RX_CLKM_CONF.Reg)&^(0x4000000)|value<<26)
}
func (o *I2S_Type) GetRX_CLKM_CONF_RX_CLK_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.RX_CLKM_CONF.Reg) & 0x4000000) >> 26
}
func (o *I2S_Type) SetRX_CLKM_CONF_RX_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.RX_CLKM_CONF.Reg, volatile.LoadUint32(&o.RX_CLKM_CONF.Reg)&^(0x18000000)|value<<27)
}
func (o *I2S_Type) GetRX_CLKM_CONF_RX_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.RX_CLKM_CONF.Reg) & 0x18000000) >> 27
}
func (o *I2S_Type) SetRX_CLKM_CONF_MCLK_SEL(value uint32) {
	volatile.StoreUint32(&o.RX_CLKM_CONF.Reg, volatile.LoadUint32(&o.RX_CLKM_CONF.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S_Type) GetRX_CLKM_CONF_MCLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.RX_CLKM_CONF.Reg) & 0x20000000) >> 29
}

// I2S.TX_CLKM_CONF: I2S TX clock configure register
func (o *I2S_Type) SetTX_CLKM_CONF_TX_CLKM_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.TX_CLKM_CONF.Reg, volatile.LoadUint32(&o.TX_CLKM_CONF.Reg)&^(0xff)|value)
}
func (o *I2S_Type) GetTX_CLKM_CONF_TX_CLKM_DIV_NUM() uint32 {
	return volatile.LoadUint32(&o.TX_CLKM_CONF.Reg) & 0xff
}
func (o *I2S_Type) SetTX_CLKM_CONF_TX_CLK_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.TX_CLKM_CONF.Reg, volatile.LoadUint32(&o.TX_CLKM_CONF.Reg)&^(0x4000000)|value<<26)
}
func (o *I2S_Type) GetTX_CLKM_CONF_TX_CLK_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.TX_CLKM_CONF.Reg) & 0x4000000) >> 26
}
func (o *I2S_Type) SetTX_CLKM_CONF_TX_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.TX_CLKM_CONF.Reg, volatile.LoadUint32(&o.TX_CLKM_CONF.Reg)&^(0x18000000)|value<<27)
}
func (o *I2S_Type) GetTX_CLKM_CONF_TX_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.TX_CLKM_CONF.Reg) & 0x18000000) >> 27
}
func (o *I2S_Type) SetTX_CLKM_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.TX_CLKM_CONF.Reg, volatile.LoadUint32(&o.TX_CLKM_CONF.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S_Type) GetTX_CLKM_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_CLKM_CONF.Reg) & 0x20000000) >> 29
}

// I2S.RX_CLKM_DIV_CONF: I2S RX module clock divider configure register
func (o *I2S_Type) SetRX_CLKM_DIV_CONF_RX_CLKM_DIV_Z(value uint32) {
	volatile.StoreUint32(&o.RX_CLKM_DIV_CONF.Reg, volatile.LoadUint32(&o.RX_CLKM_DIV_CONF.Reg)&^(0x1ff)|value)
}
func (o *I2S_Type) GetRX_CLKM_DIV_CONF_RX_CLKM_DIV_Z() uint32 {
	return volatile.LoadUint32(&o.RX_CLKM_DIV_CONF.Reg) & 0x1ff
}
func (o *I2S_Type) SetRX_CLKM_DIV_CONF_RX_CLKM_DIV_Y(value uint32) {
	volatile.StoreUint32(&o.RX_CLKM_DIV_CONF.Reg, volatile.LoadUint32(&o.RX_CLKM_DIV_CONF.Reg)&^(0x3fe00)|value<<9)
}
func (o *I2S_Type) GetRX_CLKM_DIV_CONF_RX_CLKM_DIV_Y() uint32 {
	return (volatile.LoadUint32(&o.RX_CLKM_DIV_CONF.Reg) & 0x3fe00) >> 9
}
func (o *I2S_Type) SetRX_CLKM_DIV_CONF_RX_CLKM_DIV_X(value uint32) {
	volatile.StoreUint32(&o.RX_CLKM_DIV_CONF.Reg, volatile.LoadUint32(&o.RX_CLKM_DIV_CONF.Reg)&^(0x7fc0000)|value<<18)
}
func (o *I2S_Type) GetRX_CLKM_DIV_CONF_RX_CLKM_DIV_X() uint32 {
	return (volatile.LoadUint32(&o.RX_CLKM_DIV_CONF.Reg) & 0x7fc0000) >> 18
}
func (o *I2S_Type) SetRX_CLKM_DIV_CONF_RX_CLKM_DIV_YN1(value uint32) {
	volatile.StoreUint32(&o.RX_CLKM_DIV_CONF.Reg, volatile.LoadUint32(&o.RX_CLKM_DIV_CONF.Reg)&^(0x8000000)|value<<27)
}
func (o *I2S_Type) GetRX_CLKM_DIV_CONF_RX_CLKM_DIV_YN1() uint32 {
	return (volatile.LoadUint32(&o.RX_CLKM_DIV_CONF.Reg) & 0x8000000) >> 27
}

// I2S.TX_CLKM_DIV_CONF: I2S TX module clock divider configure register
func (o *I2S_Type) SetTX_CLKM_DIV_CONF_TX_CLKM_DIV_Z(value uint32) {
	volatile.StoreUint32(&o.TX_CLKM_DIV_CONF.Reg, volatile.LoadUint32(&o.TX_CLKM_DIV_CONF.Reg)&^(0x1ff)|value)
}
func (o *I2S_Type) GetTX_CLKM_DIV_CONF_TX_CLKM_DIV_Z() uint32 {
	return volatile.LoadUint32(&o.TX_CLKM_DIV_CONF.Reg) & 0x1ff
}
func (o *I2S_Type) SetTX_CLKM_DIV_CONF_TX_CLKM_DIV_Y(value uint32) {
	volatile.StoreUint32(&o.TX_CLKM_DIV_CONF.Reg, volatile.LoadUint32(&o.TX_CLKM_DIV_CONF.Reg)&^(0x3fe00)|value<<9)
}
func (o *I2S_Type) GetTX_CLKM_DIV_CONF_TX_CLKM_DIV_Y() uint32 {
	return (volatile.LoadUint32(&o.TX_CLKM_DIV_CONF.Reg) & 0x3fe00) >> 9
}
func (o *I2S_Type) SetTX_CLKM_DIV_CONF_TX_CLKM_DIV_X(value uint32) {
	volatile.StoreUint32(&o.TX_CLKM_DIV_CONF.Reg, volatile.LoadUint32(&o.TX_CLKM_DIV_CONF.Reg)&^(0x7fc0000)|value<<18)
}
func (o *I2S_Type) GetTX_CLKM_DIV_CONF_TX_CLKM_DIV_X() uint32 {
	return (volatile.LoadUint32(&o.TX_CLKM_DIV_CONF.Reg) & 0x7fc0000) >> 18
}
func (o *I2S_Type) SetTX_CLKM_DIV_CONF_TX_CLKM_DIV_YN1(value uint32) {
	volatile.StoreUint32(&o.TX_CLKM_DIV_CONF.Reg, volatile.LoadUint32(&o.TX_CLKM_DIV_CONF.Reg)&^(0x8000000)|value<<27)
}
func (o *I2S_Type) GetTX_CLKM_DIV_CONF_TX_CLKM_DIV_YN1() uint32 {
	return (volatile.LoadUint32(&o.TX_CLKM_DIV_CONF.Reg) & 0x8000000) >> 27
}

// I2S.TX_PCM2PDM_CONF: I2S TX PCM2PDM configuration register
func (o *I2S_Type) SetTX_PCM2PDM_CONF_TX_PDM_HP_BYPASS(value uint32) {
	volatile.StoreUint32(&o.TX_PCM2PDM_CONF.Reg, volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetTX_PCM2PDM_CONF_TX_PDM_HP_BYPASS() uint32 {
	return volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg) & 0x1
}
func (o *I2S_Type) SetTX_PCM2PDM_CONF_TX_PDM_SINC_OSR2(value uint32) {
	volatile.StoreUint32(&o.TX_PCM2PDM_CONF.Reg, volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg)&^(0x1e)|value<<1)
}
func (o *I2S_Type) GetTX_PCM2PDM_CONF_TX_PDM_SINC_OSR2() uint32 {
	return (volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg) & 0x1e) >> 1
}
func (o *I2S_Type) SetTX_PCM2PDM_CONF_TX_PDM_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.TX_PCM2PDM_CONF.Reg, volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg)&^(0x1fe0)|value<<5)
}
func (o *I2S_Type) GetTX_PCM2PDM_CONF_TX_PDM_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg) & 0x1fe0) >> 5
}
func (o *I2S_Type) SetTX_PCM2PDM_CONF_TX_PDM_HP_IN_SHIFT(value uint32) {
	volatile.StoreUint32(&o.TX_PCM2PDM_CONF.Reg, volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg)&^(0x6000)|value<<13)
}
func (o *I2S_Type) GetTX_PCM2PDM_CONF_TX_PDM_HP_IN_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg) & 0x6000) >> 13
}
func (o *I2S_Type) SetTX_PCM2PDM_CONF_TX_PDM_LP_IN_SHIFT(value uint32) {
	volatile.StoreUint32(&o.TX_PCM2PDM_CONF.Reg, volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg)&^(0x18000)|value<<15)
}
func (o *I2S_Type) GetTX_PCM2PDM_CONF_TX_PDM_LP_IN_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg) & 0x18000) >> 15
}
func (o *I2S_Type) SetTX_PCM2PDM_CONF_TX_PDM_SINC_IN_SHIFT(value uint32) {
	volatile.StoreUint32(&o.TX_PCM2PDM_CONF.Reg, volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg)&^(0x60000)|value<<17)
}
func (o *I2S_Type) GetTX_PCM2PDM_CONF_TX_PDM_SINC_IN_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg) & 0x60000) >> 17
}
func (o *I2S_Type) SetTX_PCM2PDM_CONF_TX_PDM_SIGMADELTA_IN_SHIFT(value uint32) {
	volatile.StoreUint32(&o.TX_PCM2PDM_CONF.Reg, volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg)&^(0x180000)|value<<19)
}
func (o *I2S_Type) GetTX_PCM2PDM_CONF_TX_PDM_SIGMADELTA_IN_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg) & 0x180000) >> 19
}
func (o *I2S_Type) SetTX_PCM2PDM_CONF_TX_PDM_SIGMADELTA_DITHER2(value uint32) {
	volatile.StoreUint32(&o.TX_PCM2PDM_CONF.Reg, volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg)&^(0x200000)|value<<21)
}
func (o *I2S_Type) GetTX_PCM2PDM_CONF_TX_PDM_SIGMADELTA_DITHER2() uint32 {
	return (volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg) & 0x200000) >> 21
}
func (o *I2S_Type) SetTX_PCM2PDM_CONF_TX_PDM_SIGMADELTA_DITHER(value uint32) {
	volatile.StoreUint32(&o.TX_PCM2PDM_CONF.Reg, volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg)&^(0x400000)|value<<22)
}
func (o *I2S_Type) GetTX_PCM2PDM_CONF_TX_PDM_SIGMADELTA_DITHER() uint32 {
	return (volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg) & 0x400000) >> 22
}
func (o *I2S_Type) SetTX_PCM2PDM_CONF_TX_PDM_DAC_2OUT_EN(value uint32) {
	volatile.StoreUint32(&o.TX_PCM2PDM_CONF.Reg, volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg)&^(0x800000)|value<<23)
}
func (o *I2S_Type) GetTX_PCM2PDM_CONF_TX_PDM_DAC_2OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg) & 0x800000) >> 23
}
func (o *I2S_Type) SetTX_PCM2PDM_CONF_TX_PDM_DAC_MODE_EN(value uint32) {
	volatile.StoreUint32(&o.TX_PCM2PDM_CONF.Reg, volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S_Type) GetTX_PCM2PDM_CONF_TX_PDM_DAC_MODE_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg) & 0x1000000) >> 24
}
func (o *I2S_Type) SetTX_PCM2PDM_CONF_PCM2PDM_CONV_EN(value uint32) {
	volatile.StoreUint32(&o.TX_PCM2PDM_CONF.Reg, volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S_Type) GetTX_PCM2PDM_CONF_PCM2PDM_CONV_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_PCM2PDM_CONF.Reg) & 0x2000000) >> 25
}

// I2S.TX_PCM2PDM_CONF1: I2S TX PCM2PDM configuration register
func (o *I2S_Type) SetTX_PCM2PDM_CONF1_TX_PDM_FP(value uint32) {
	volatile.StoreUint32(&o.TX_PCM2PDM_CONF1.Reg, volatile.LoadUint32(&o.TX_PCM2PDM_CONF1.Reg)&^(0x3ff)|value)
}
func (o *I2S_Type) GetTX_PCM2PDM_CONF1_TX_PDM_FP() uint32 {
	return volatile.LoadUint32(&o.TX_PCM2PDM_CONF1.Reg) & 0x3ff
}
func (o *I2S_Type) SetTX_PCM2PDM_CONF1_TX_PDM_FS(value uint32) {
	volatile.StoreUint32(&o.TX_PCM2PDM_CONF1.Reg, volatile.LoadUint32(&o.TX_PCM2PDM_CONF1.Reg)&^(0xffc00)|value<<10)
}
func (o *I2S_Type) GetTX_PCM2PDM_CONF1_TX_PDM_FS() uint32 {
	return (volatile.LoadUint32(&o.TX_PCM2PDM_CONF1.Reg) & 0xffc00) >> 10
}
func (o *I2S_Type) SetTX_PCM2PDM_CONF1_TX_IIR_HP_MULT12_5(value uint32) {
	volatile.StoreUint32(&o.TX_PCM2PDM_CONF1.Reg, volatile.LoadUint32(&o.TX_PCM2PDM_CONF1.Reg)&^(0x700000)|value<<20)
}
func (o *I2S_Type) GetTX_PCM2PDM_CONF1_TX_IIR_HP_MULT12_5() uint32 {
	return (volatile.LoadUint32(&o.TX_PCM2PDM_CONF1.Reg) & 0x700000) >> 20
}
func (o *I2S_Type) SetTX_PCM2PDM_CONF1_TX_IIR_HP_MULT12_0(value uint32) {
	volatile.StoreUint32(&o.TX_PCM2PDM_CONF1.Reg, volatile.LoadUint32(&o.TX_PCM2PDM_CONF1.Reg)&^(0x3800000)|value<<23)
}
func (o *I2S_Type) GetTX_PCM2PDM_CONF1_TX_IIR_HP_MULT12_0() uint32 {
	return (volatile.LoadUint32(&o.TX_PCM2PDM_CONF1.Reg) & 0x3800000) >> 23
}

// I2S.RX_TDM_CTRL: I2S TX TDM mode control register
func (o *I2S_Type) SetRX_TDM_CTRL_RX_TDM_PDM_CHAN0_EN(value uint32) {
	volatile.StoreUint32(&o.RX_TDM_CTRL.Reg, volatile.LoadUint32(&o.RX_TDM_CTRL.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetRX_TDM_CTRL_RX_TDM_PDM_CHAN0_EN() uint32 {
	return volatile.LoadUint32(&o.RX_TDM_CTRL.Reg) & 0x1
}
func (o *I2S_Type) SetRX_TDM_CTRL_RX_TDM_PDM_CHAN1_EN(value uint32) {
	volatile.StoreUint32(&o.RX_TDM_CTRL.Reg, volatile.LoadUint32(&o.RX_TDM_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetRX_TDM_CTRL_RX_TDM_PDM_CHAN1_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_TDM_CTRL.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetRX_TDM_CTRL_RX_TDM_PDM_CHAN2_EN(value uint32) {
	volatile.StoreUint32(&o.RX_TDM_CTRL.Reg, volatile.LoadUint32(&o.RX_TDM_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetRX_TDM_CTRL_RX_TDM_PDM_CHAN2_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_TDM_CTRL.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetRX_TDM_CTRL_RX_TDM_PDM_CHAN3_EN(value uint32) {
	volatile.StoreUint32(&o.RX_TDM_CTRL.Reg, volatile.LoadUint32(&o.RX_TDM_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetRX_TDM_CTRL_RX_TDM_PDM_CHAN3_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_TDM_CTRL.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetRX_TDM_CTRL_RX_TDM_PDM_CHAN4_EN(value uint32) {
	volatile.StoreUint32(&o.RX_TDM_CTRL.Reg, volatile.LoadUint32(&o.RX_TDM_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetRX_TDM_CTRL_RX_TDM_PDM_CHAN4_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_TDM_CTRL.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetRX_TDM_CTRL_RX_TDM_PDM_CHAN5_EN(value uint32) {
	volatile.StoreUint32(&o.RX_TDM_CTRL.Reg, volatile.LoadUint32(&o.RX_TDM_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetRX_TDM_CTRL_RX_TDM_PDM_CHAN5_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_TDM_CTRL.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetRX_TDM_CTRL_RX_TDM_PDM_CHAN6_EN(value uint32) {
	volatile.StoreUint32(&o.RX_TDM_CTRL.Reg, volatile.LoadUint32(&o.RX_TDM_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *I2S_Type) GetRX_TDM_CTRL_RX_TDM_PDM_CHAN6_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_TDM_CTRL.Reg) & 0x40) >> 6
}
func (o *I2S_Type) SetRX_TDM_CTRL_RX_TDM_PDM_CHAN7_EN(value uint32) {
	volatile.StoreUint32(&o.RX_TDM_CTRL.Reg, volatile.LoadUint32(&o.RX_TDM_CTRL.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetRX_TDM_CTRL_RX_TDM_PDM_CHAN7_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_TDM_CTRL.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetRX_TDM_CTRL_RX_TDM_CHAN8_EN(value uint32) {
	volatile.StoreUint32(&o.RX_TDM_CTRL.Reg, volatile.LoadUint32(&o.RX_TDM_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetRX_TDM_CTRL_RX_TDM_CHAN8_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_TDM_CTRL.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetRX_TDM_CTRL_RX_TDM_CHAN9_EN(value uint32) {
	volatile.StoreUint32(&o.RX_TDM_CTRL.Reg, volatile.LoadUint32(&o.RX_TDM_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetRX_TDM_CTRL_RX_TDM_CHAN9_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_TDM_CTRL.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetRX_TDM_CTRL_RX_TDM_CHAN10_EN(value uint32) {
	volatile.StoreUint32(&o.RX_TDM_CTRL.Reg, volatile.LoadUint32(&o.RX_TDM_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *I2S_Type) GetRX_TDM_CTRL_RX_TDM_CHAN10_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_TDM_CTRL.Reg) & 0x400) >> 10
}
func (o *I2S_Type) SetRX_TDM_CTRL_RX_TDM_CHAN11_EN(value uint32) {
	volatile.StoreUint32(&o.RX_TDM_CTRL.Reg, volatile.LoadUint32(&o.RX_TDM_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetRX_TDM_CTRL_RX_TDM_CHAN11_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_TDM_CTRL.Reg) & 0x800) >> 11
}
func (o *I2S_Type) SetRX_TDM_CTRL_RX_TDM_CHAN12_EN(value uint32) {
	volatile.StoreUint32(&o.RX_TDM_CTRL.Reg, volatile.LoadUint32(&o.RX_TDM_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetRX_TDM_CTRL_RX_TDM_CHAN12_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_TDM_CTRL.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetRX_TDM_CTRL_RX_TDM_CHAN13_EN(value uint32) {
	volatile.StoreUint32(&o.RX_TDM_CTRL.Reg, volatile.LoadUint32(&o.RX_TDM_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *I2S_Type) GetRX_TDM_CTRL_RX_TDM_CHAN13_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_TDM_CTRL.Reg) & 0x2000) >> 13
}
func (o *I2S_Type) SetRX_TDM_CTRL_RX_TDM_CHAN14_EN(value uint32) {
	volatile.StoreUint32(&o.RX_TDM_CTRL.Reg, volatile.LoadUint32(&o.RX_TDM_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *I2S_Type) GetRX_TDM_CTRL_RX_TDM_CHAN14_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_TDM_CTRL.Reg) & 0x4000) >> 14
}
func (o *I2S_Type) SetRX_TDM_CTRL_RX_TDM_CHAN15_EN(value uint32) {
	volatile.StoreUint32(&o.RX_TDM_CTRL.Reg, volatile.LoadUint32(&o.RX_TDM_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *I2S_Type) GetRX_TDM_CTRL_RX_TDM_CHAN15_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_TDM_CTRL.Reg) & 0x8000) >> 15
}
func (o *I2S_Type) SetRX_TDM_CTRL_RX_TDM_TOT_CHAN_NUM(value uint32) {
	volatile.StoreUint32(&o.RX_TDM_CTRL.Reg, volatile.LoadUint32(&o.RX_TDM_CTRL.Reg)&^(0xf0000)|value<<16)
}
func (o *I2S_Type) GetRX_TDM_CTRL_RX_TDM_TOT_CHAN_NUM() uint32 {
	return (volatile.LoadUint32(&o.RX_TDM_CTRL.Reg) & 0xf0000) >> 16
}

// I2S.TX_TDM_CTRL: I2S TX TDM mode control register
func (o *I2S_Type) SetTX_TDM_CTRL_TX_TDM_CHAN0_EN(value uint32) {
	volatile.StoreUint32(&o.TX_TDM_CTRL.Reg, volatile.LoadUint32(&o.TX_TDM_CTRL.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetTX_TDM_CTRL_TX_TDM_CHAN0_EN() uint32 {
	return volatile.LoadUint32(&o.TX_TDM_CTRL.Reg) & 0x1
}
func (o *I2S_Type) SetTX_TDM_CTRL_TX_TDM_CHAN1_EN(value uint32) {
	volatile.StoreUint32(&o.TX_TDM_CTRL.Reg, volatile.LoadUint32(&o.TX_TDM_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetTX_TDM_CTRL_TX_TDM_CHAN1_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_TDM_CTRL.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetTX_TDM_CTRL_TX_TDM_CHAN2_EN(value uint32) {
	volatile.StoreUint32(&o.TX_TDM_CTRL.Reg, volatile.LoadUint32(&o.TX_TDM_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetTX_TDM_CTRL_TX_TDM_CHAN2_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_TDM_CTRL.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetTX_TDM_CTRL_TX_TDM_CHAN3_EN(value uint32) {
	volatile.StoreUint32(&o.TX_TDM_CTRL.Reg, volatile.LoadUint32(&o.TX_TDM_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetTX_TDM_CTRL_TX_TDM_CHAN3_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_TDM_CTRL.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetTX_TDM_CTRL_TX_TDM_CHAN4_EN(value uint32) {
	volatile.StoreUint32(&o.TX_TDM_CTRL.Reg, volatile.LoadUint32(&o.TX_TDM_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetTX_TDM_CTRL_TX_TDM_CHAN4_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_TDM_CTRL.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetTX_TDM_CTRL_TX_TDM_CHAN5_EN(value uint32) {
	volatile.StoreUint32(&o.TX_TDM_CTRL.Reg, volatile.LoadUint32(&o.TX_TDM_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetTX_TDM_CTRL_TX_TDM_CHAN5_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_TDM_CTRL.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetTX_TDM_CTRL_TX_TDM_CHAN6_EN(value uint32) {
	volatile.StoreUint32(&o.TX_TDM_CTRL.Reg, volatile.LoadUint32(&o.TX_TDM_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *I2S_Type) GetTX_TDM_CTRL_TX_TDM_CHAN6_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_TDM_CTRL.Reg) & 0x40) >> 6
}
func (o *I2S_Type) SetTX_TDM_CTRL_TX_TDM_CHAN7_EN(value uint32) {
	volatile.StoreUint32(&o.TX_TDM_CTRL.Reg, volatile.LoadUint32(&o.TX_TDM_CTRL.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetTX_TDM_CTRL_TX_TDM_CHAN7_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_TDM_CTRL.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetTX_TDM_CTRL_TX_TDM_CHAN8_EN(value uint32) {
	volatile.StoreUint32(&o.TX_TDM_CTRL.Reg, volatile.LoadUint32(&o.TX_TDM_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetTX_TDM_CTRL_TX_TDM_CHAN8_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_TDM_CTRL.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetTX_TDM_CTRL_TX_TDM_CHAN9_EN(value uint32) {
	volatile.StoreUint32(&o.TX_TDM_CTRL.Reg, volatile.LoadUint32(&o.TX_TDM_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetTX_TDM_CTRL_TX_TDM_CHAN9_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_TDM_CTRL.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetTX_TDM_CTRL_TX_TDM_CHAN10_EN(value uint32) {
	volatile.StoreUint32(&o.TX_TDM_CTRL.Reg, volatile.LoadUint32(&o.TX_TDM_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *I2S_Type) GetTX_TDM_CTRL_TX_TDM_CHAN10_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_TDM_CTRL.Reg) & 0x400) >> 10
}
func (o *I2S_Type) SetTX_TDM_CTRL_TX_TDM_CHAN11_EN(value uint32) {
	volatile.StoreUint32(&o.TX_TDM_CTRL.Reg, volatile.LoadUint32(&o.TX_TDM_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetTX_TDM_CTRL_TX_TDM_CHAN11_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_TDM_CTRL.Reg) & 0x800) >> 11
}
func (o *I2S_Type) SetTX_TDM_CTRL_TX_TDM_CHAN12_EN(value uint32) {
	volatile.StoreUint32(&o.TX_TDM_CTRL.Reg, volatile.LoadUint32(&o.TX_TDM_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetTX_TDM_CTRL_TX_TDM_CHAN12_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_TDM_CTRL.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetTX_TDM_CTRL_TX_TDM_CHAN13_EN(value uint32) {
	volatile.StoreUint32(&o.TX_TDM_CTRL.Reg, volatile.LoadUint32(&o.TX_TDM_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *I2S_Type) GetTX_TDM_CTRL_TX_TDM_CHAN13_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_TDM_CTRL.Reg) & 0x2000) >> 13
}
func (o *I2S_Type) SetTX_TDM_CTRL_TX_TDM_CHAN14_EN(value uint32) {
	volatile.StoreUint32(&o.TX_TDM_CTRL.Reg, volatile.LoadUint32(&o.TX_TDM_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *I2S_Type) GetTX_TDM_CTRL_TX_TDM_CHAN14_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_TDM_CTRL.Reg) & 0x4000) >> 14
}
func (o *I2S_Type) SetTX_TDM_CTRL_TX_TDM_CHAN15_EN(value uint32) {
	volatile.StoreUint32(&o.TX_TDM_CTRL.Reg, volatile.LoadUint32(&o.TX_TDM_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *I2S_Type) GetTX_TDM_CTRL_TX_TDM_CHAN15_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_TDM_CTRL.Reg) & 0x8000) >> 15
}
func (o *I2S_Type) SetTX_TDM_CTRL_TX_TDM_TOT_CHAN_NUM(value uint32) {
	volatile.StoreUint32(&o.TX_TDM_CTRL.Reg, volatile.LoadUint32(&o.TX_TDM_CTRL.Reg)&^(0xf0000)|value<<16)
}
func (o *I2S_Type) GetTX_TDM_CTRL_TX_TDM_TOT_CHAN_NUM() uint32 {
	return (volatile.LoadUint32(&o.TX_TDM_CTRL.Reg) & 0xf0000) >> 16
}
func (o *I2S_Type) SetTX_TDM_CTRL_TX_TDM_SKIP_MSK_EN(value uint32) {
	volatile.StoreUint32(&o.TX_TDM_CTRL.Reg, volatile.LoadUint32(&o.TX_TDM_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *I2S_Type) GetTX_TDM_CTRL_TX_TDM_SKIP_MSK_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_TDM_CTRL.Reg) & 0x100000) >> 20
}

// I2S.RX_TIMING: I2S RX timing control register
func (o *I2S_Type) SetRX_TIMING_RX_SD_IN_DM(value uint32) {
	volatile.StoreUint32(&o.RX_TIMING.Reg, volatile.LoadUint32(&o.RX_TIMING.Reg)&^(0x3)|value)
}
func (o *I2S_Type) GetRX_TIMING_RX_SD_IN_DM() uint32 {
	return volatile.LoadUint32(&o.RX_TIMING.Reg) & 0x3
}
func (o *I2S_Type) SetRX_TIMING_RX_WS_OUT_DM(value uint32) {
	volatile.StoreUint32(&o.RX_TIMING.Reg, volatile.LoadUint32(&o.RX_TIMING.Reg)&^(0x30000)|value<<16)
}
func (o *I2S_Type) GetRX_TIMING_RX_WS_OUT_DM() uint32 {
	return (volatile.LoadUint32(&o.RX_TIMING.Reg) & 0x30000) >> 16
}
func (o *I2S_Type) SetRX_TIMING_RX_BCK_OUT_DM(value uint32) {
	volatile.StoreUint32(&o.RX_TIMING.Reg, volatile.LoadUint32(&o.RX_TIMING.Reg)&^(0x300000)|value<<20)
}
func (o *I2S_Type) GetRX_TIMING_RX_BCK_OUT_DM() uint32 {
	return (volatile.LoadUint32(&o.RX_TIMING.Reg) & 0x300000) >> 20
}
func (o *I2S_Type) SetRX_TIMING_RX_WS_IN_DM(value uint32) {
	volatile.StoreUint32(&o.RX_TIMING.Reg, volatile.LoadUint32(&o.RX_TIMING.Reg)&^(0x3000000)|value<<24)
}
func (o *I2S_Type) GetRX_TIMING_RX_WS_IN_DM() uint32 {
	return (volatile.LoadUint32(&o.RX_TIMING.Reg) & 0x3000000) >> 24
}
func (o *I2S_Type) SetRX_TIMING_RX_BCK_IN_DM(value uint32) {
	volatile.StoreUint32(&o.RX_TIMING.Reg, volatile.LoadUint32(&o.RX_TIMING.Reg)&^(0x30000000)|value<<28)
}
func (o *I2S_Type) GetRX_TIMING_RX_BCK_IN_DM() uint32 {
	return (volatile.LoadUint32(&o.RX_TIMING.Reg) & 0x30000000) >> 28
}

// I2S.TX_TIMING: I2S TX timing control register
func (o *I2S_Type) SetTX_TIMING_TX_SD_OUT_DM(value uint32) {
	volatile.StoreUint32(&o.TX_TIMING.Reg, volatile.LoadUint32(&o.TX_TIMING.Reg)&^(0x3)|value)
}
func (o *I2S_Type) GetTX_TIMING_TX_SD_OUT_DM() uint32 {
	return volatile.LoadUint32(&o.TX_TIMING.Reg) & 0x3
}
func (o *I2S_Type) SetTX_TIMING_TX_SD1_OUT_DM(value uint32) {
	volatile.StoreUint32(&o.TX_TIMING.Reg, volatile.LoadUint32(&o.TX_TIMING.Reg)&^(0x30)|value<<4)
}
func (o *I2S_Type) GetTX_TIMING_TX_SD1_OUT_DM() uint32 {
	return (volatile.LoadUint32(&o.TX_TIMING.Reg) & 0x30) >> 4
}
func (o *I2S_Type) SetTX_TIMING_TX_WS_OUT_DM(value uint32) {
	volatile.StoreUint32(&o.TX_TIMING.Reg, volatile.LoadUint32(&o.TX_TIMING.Reg)&^(0x30000)|value<<16)
}
func (o *I2S_Type) GetTX_TIMING_TX_WS_OUT_DM() uint32 {
	return (volatile.LoadUint32(&o.TX_TIMING.Reg) & 0x30000) >> 16
}
func (o *I2S_Type) SetTX_TIMING_TX_BCK_OUT_DM(value uint32) {
	volatile.StoreUint32(&o.TX_TIMING.Reg, volatile.LoadUint32(&o.TX_TIMING.Reg)&^(0x300000)|value<<20)
}
func (o *I2S_Type) GetTX_TIMING_TX_BCK_OUT_DM() uint32 {
	return (volatile.LoadUint32(&o.TX_TIMING.Reg) & 0x300000) >> 20
}
func (o *I2S_Type) SetTX_TIMING_TX_WS_IN_DM(value uint32) {
	volatile.StoreUint32(&o.TX_TIMING.Reg, volatile.LoadUint32(&o.TX_TIMING.Reg)&^(0x3000000)|value<<24)
}
func (o *I2S_Type) GetTX_TIMING_TX_WS_IN_DM() uint32 {
	return (volatile.LoadUint32(&o.TX_TIMING.Reg) & 0x3000000) >> 24
}
func (o *I2S_Type) SetTX_TIMING_TX_BCK_IN_DM(value uint32) {
	volatile.StoreUint32(&o.TX_TIMING.Reg, volatile.LoadUint32(&o.TX_TIMING.Reg)&^(0x30000000)|value<<28)
}
func (o *I2S_Type) GetTX_TIMING_TX_BCK_IN_DM() uint32 {
	return (volatile.LoadUint32(&o.TX_TIMING.Reg) & 0x30000000) >> 28
}

// I2S.LC_HUNG_CONF: I2S HUNG configure register.
func (o *I2S_Type) SetLC_HUNG_CONF_LC_FIFO_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.LC_HUNG_CONF.Reg, volatile.LoadUint32(&o.LC_HUNG_CONF.Reg)&^(0xff)|value)
}
func (o *I2S_Type) GetLC_HUNG_CONF_LC_FIFO_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.LC_HUNG_CONF.Reg) & 0xff
}
func (o *I2S_Type) SetLC_HUNG_CONF_LC_FIFO_TIMEOUT_SHIFT(value uint32) {
	volatile.StoreUint32(&o.LC_HUNG_CONF.Reg, volatile.LoadUint32(&o.LC_HUNG_CONF.Reg)&^(0x700)|value<<8)
}
func (o *I2S_Type) GetLC_HUNG_CONF_LC_FIFO_TIMEOUT_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.LC_HUNG_CONF.Reg) & 0x700) >> 8
}
func (o *I2S_Type) SetLC_HUNG_CONF_LC_FIFO_TIMEOUT_ENA(value uint32) {
	volatile.StoreUint32(&o.LC_HUNG_CONF.Reg, volatile.LoadUint32(&o.LC_HUNG_CONF.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetLC_HUNG_CONF_LC_FIFO_TIMEOUT_ENA() uint32 {
	return (volatile.LoadUint32(&o.LC_HUNG_CONF.Reg) & 0x800) >> 11
}

// I2S.RXEOF_NUM: I2S RX data number control register.
func (o *I2S_Type) SetRXEOF_NUM_RX_EOF_NUM(value uint32) {
	volatile.StoreUint32(&o.RXEOF_NUM.Reg, volatile.LoadUint32(&o.RXEOF_NUM.Reg)&^(0xfff)|value)
}
func (o *I2S_Type) GetRXEOF_NUM_RX_EOF_NUM() uint32 {
	return volatile.LoadUint32(&o.RXEOF_NUM.Reg) & 0xfff
}

// I2S.CONF_SIGLE_DATA: I2S signal data register
func (o *I2S_Type) SetCONF_SIGLE_DATA(value uint32) {
	volatile.StoreUint32(&o.CONF_SIGLE_DATA.Reg, value)
}
func (o *I2S_Type) GetCONF_SIGLE_DATA() uint32 {
	return volatile.LoadUint32(&o.CONF_SIGLE_DATA.Reg)
}

// I2S.STATE: I2S TX status register
func (o *I2S_Type) SetSTATE_TX_IDLE(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetSTATE_TX_IDLE() uint32 {
	return volatile.LoadUint32(&o.STATE.Reg) & 0x1
}

// I2S.DATE: Version control register
func (o *I2S_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *I2S_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// Peripheral INTERRUPT_CORE0
type INTERRUPT_CORE0_Type struct {
	MAC_INTR_MAP                                 volatile.Register32 // 0x0
	MAC_NMI_MAP                                  volatile.Register32 // 0x4
	PWR_INTR_MAP                                 volatile.Register32 // 0x8
	BB_INT_MAP                                   volatile.Register32 // 0xC
	BT_MAC_INT_MAP                               volatile.Register32 // 0x10
	BT_BB_INT_MAP                                volatile.Register32 // 0x14
	BT_BB_NMI_MAP                                volatile.Register32 // 0x18
	RWBT_IRQ_MAP                                 volatile.Register32 // 0x1C
	RWBLE_IRQ_MAP                                volatile.Register32 // 0x20
	RWBT_NMI_MAP                                 volatile.Register32 // 0x24
	RWBLE_NMI_MAP                                volatile.Register32 // 0x28
	I2C_MST_INT_MAP                              volatile.Register32 // 0x2C
	SLC0_INTR_MAP                                volatile.Register32 // 0x30
	SLC1_INTR_MAP                                volatile.Register32 // 0x34
	APB_CTRL_INTR_MAP                            volatile.Register32 // 0x38
	UHCI0_INTR_MAP                               volatile.Register32 // 0x3C
	GPIO_INTERRUPT_PRO_MAP                       volatile.Register32 // 0x40
	GPIO_INTERRUPT_PRO_NMI_MAP                   volatile.Register32 // 0x44
	SPI_INTR_1_MAP                               volatile.Register32 // 0x48
	SPI_INTR_2_MAP                               volatile.Register32 // 0x4C
	I2S1_INT_MAP                                 volatile.Register32 // 0x50
	UART_INTR_MAP                                volatile.Register32 // 0x54
	UART1_INTR_MAP                               volatile.Register32 // 0x58
	LEDC_INT_MAP                                 volatile.Register32 // 0x5C
	EFUSE_INT_MAP                                volatile.Register32 // 0x60
	CAN_INT_MAP                                  volatile.Register32 // 0x64
	USB_INTR_MAP                                 volatile.Register32 // 0x68
	RTC_CORE_INTR_MAP                            volatile.Register32 // 0x6C
	RMT_INTR_MAP                                 volatile.Register32 // 0x70
	I2C_EXT0_INTR_MAP                            volatile.Register32 // 0x74
	TIMER_INT1_MAP                               volatile.Register32 // 0x78
	TIMER_INT2_MAP                               volatile.Register32 // 0x7C
	TG_T0_INT_MAP                                volatile.Register32 // 0x80
	TG_WDT_INT_MAP                               volatile.Register32 // 0x84
	TG1_T0_INT_MAP                               volatile.Register32 // 0x88
	TG1_WDT_INT_MAP                              volatile.Register32 // 0x8C
	CACHE_IA_INT_MAP                             volatile.Register32 // 0x90
	SYSTIMER_TARGET0_INT_MAP                     volatile.Register32 // 0x94
	SYSTIMER_TARGET1_INT_MAP                     volatile.Register32 // 0x98
	SYSTIMER_TARGET2_INT_MAP                     volatile.Register32 // 0x9C
	SPI_MEM_REJECT_INTR_MAP                      volatile.Register32 // 0xA0
	ICACHE_PRELOAD_INT_MAP                       volatile.Register32 // 0xA4
	ICACHE_SYNC_INT_MAP                          volatile.Register32 // 0xA8
	APB_ADC_INT_MAP                              volatile.Register32 // 0xAC
	DMA_CH0_INT_MAP                              volatile.Register32 // 0xB0
	DMA_CH1_INT_MAP                              volatile.Register32 // 0xB4
	DMA_CH2_INT_MAP                              volatile.Register32 // 0xB8
	RSA_INT_MAP                                  volatile.Register32 // 0xBC
	AES_INT_MAP                                  volatile.Register32 // 0xC0
	SHA_INT_MAP                                  volatile.Register32 // 0xC4
	CPU_INTR_FROM_CPU_0_MAP                      volatile.Register32 // 0xC8
	CPU_INTR_FROM_CPU_1_MAP                      volatile.Register32 // 0xCC
	CPU_INTR_FROM_CPU_2_MAP                      volatile.Register32 // 0xD0
	CPU_INTR_FROM_CPU_3_MAP                      volatile.Register32 // 0xD4
	ASSIST_DEBUG_INTR_MAP                        volatile.Register32 // 0xD8
	DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP     volatile.Register32 // 0xDC
	CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP    volatile.Register32 // 0xE0
	CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP    volatile.Register32 // 0xE4
	CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP      volatile.Register32 // 0xE8
	CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP volatile.Register32 // 0xEC
	BACKUP_PMS_VIOLATE_INTR_MAP                  volatile.Register32 // 0xF0
	CACHE_CORE0_ACS_INT_MAP                      volatile.Register32 // 0xF4
	INTR_STATUS_REG_0                            volatile.Register32 // 0xF8
	INTR_STATUS_REG_1                            volatile.Register32 // 0xFC
	CLOCK_GATE                                   volatile.Register32 // 0x100
	CPU_INT_ENABLE                               volatile.Register32 // 0x104
	CPU_INT_TYPE                                 volatile.Register32 // 0x108
	CPU_INT_CLEAR                                volatile.Register32 // 0x10C
	CPU_INT_EIP_STATUS                           volatile.Register32 // 0x110
	CPU_INT_PRI_0                                volatile.Register32 // 0x114
	CPU_INT_PRI_1                                volatile.Register32 // 0x118
	CPU_INT_PRI_2                                volatile.Register32 // 0x11C
	CPU_INT_PRI_3                                volatile.Register32 // 0x120
	CPU_INT_PRI_4                                volatile.Register32 // 0x124
	CPU_INT_PRI_5                                volatile.Register32 // 0x128
	CPU_INT_PRI_6                                volatile.Register32 // 0x12C
	CPU_INT_PRI_7                                volatile.Register32 // 0x130
	CPU_INT_PRI_8                                volatile.Register32 // 0x134
	CPU_INT_PRI_9                                volatile.Register32 // 0x138
	CPU_INT_PRI_10                               volatile.Register32 // 0x13C
	CPU_INT_PRI_11                               volatile.Register32 // 0x140
	CPU_INT_PRI_12                               volatile.Register32 // 0x144
	CPU_INT_PRI_13                               volatile.Register32 // 0x148
	CPU_INT_PRI_14                               volatile.Register32 // 0x14C
	CPU_INT_PRI_15                               volatile.Register32 // 0x150
	CPU_INT_PRI_16                               volatile.Register32 // 0x154
	CPU_INT_PRI_17                               volatile.Register32 // 0x158
	CPU_INT_PRI_18                               volatile.Register32 // 0x15C
	CPU_INT_PRI_19                               volatile.Register32 // 0x160
	CPU_INT_PRI_20                               volatile.Register32 // 0x164
	CPU_INT_PRI_21                               volatile.Register32 // 0x168
	CPU_INT_PRI_22                               volatile.Register32 // 0x16C
	CPU_INT_PRI_23                               volatile.Register32 // 0x170
	CPU_INT_PRI_24                               volatile.Register32 // 0x174
	CPU_INT_PRI_25                               volatile.Register32 // 0x178
	CPU_INT_PRI_26                               volatile.Register32 // 0x17C
	CPU_INT_PRI_27                               volatile.Register32 // 0x180
	CPU_INT_PRI_28                               volatile.Register32 // 0x184
	CPU_INT_PRI_29                               volatile.Register32 // 0x188
	CPU_INT_PRI_30                               volatile.Register32 // 0x18C
	CPU_INT_PRI_31                               volatile.Register32 // 0x190
	CPU_INT_THRESH                               volatile.Register32 // 0x194
	_                                            [1636]byte
	INTERRUPT_REG_DATE                           volatile.Register32 // 0x7FC
}

// INTERRUPT_CORE0.MAC_INTR_MAP: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetMAC_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.MAC_INTR_MAP.Reg, volatile.LoadUint32(&o.MAC_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetMAC_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.MAC_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.MAC_NMI_MAP: mac nmi_intr map register
func (o *INTERRUPT_CORE0_Type) SetMAC_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.MAC_NMI_MAP.Reg, volatile.LoadUint32(&o.MAC_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetMAC_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.MAC_NMI_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PWR_INTR_MAP: pwr intr map register
func (o *INTERRUPT_CORE0_Type) SetPWR_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PWR_INTR_MAP.Reg, volatile.LoadUint32(&o.PWR_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPWR_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PWR_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.BB_INT_MAP: bb intr map register
func (o *INTERRUPT_CORE0_Type) SetBB_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.BB_INT_MAP.Reg, volatile.LoadUint32(&o.BB_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetBB_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.BB_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.BT_MAC_INT_MAP: bt intr map register
func (o *INTERRUPT_CORE0_Type) SetBT_MAC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.BT_MAC_INT_MAP.Reg, volatile.LoadUint32(&o.BT_MAC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetBT_MAC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.BT_MAC_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.BT_BB_INT_MAP: bb_bt intr map register
func (o *INTERRUPT_CORE0_Type) SetBT_BB_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.BT_BB_INT_MAP.Reg, volatile.LoadUint32(&o.BT_BB_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetBT_BB_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.BT_BB_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.BT_BB_NMI_MAP: bb_bt_nmi intr map register
func (o *INTERRUPT_CORE0_Type) SetBT_BB_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.BT_BB_NMI_MAP.Reg, volatile.LoadUint32(&o.BT_BB_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetBT_BB_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.BT_BB_NMI_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.RWBT_IRQ_MAP: rwbt intr map register
func (o *INTERRUPT_CORE0_Type) SetRWBT_IRQ_MAP(value uint32) {
	volatile.StoreUint32(&o.RWBT_IRQ_MAP.Reg, volatile.LoadUint32(&o.RWBT_IRQ_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetRWBT_IRQ_MAP() uint32 {
	return volatile.LoadUint32(&o.RWBT_IRQ_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.RWBLE_IRQ_MAP: rwble intr map register
func (o *INTERRUPT_CORE0_Type) SetRWBLE_IRQ_MAP(value uint32) {
	volatile.StoreUint32(&o.RWBLE_IRQ_MAP.Reg, volatile.LoadUint32(&o.RWBLE_IRQ_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetRWBLE_IRQ_MAP() uint32 {
	return volatile.LoadUint32(&o.RWBLE_IRQ_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.RWBT_NMI_MAP: rwbt_nmi intr map register
func (o *INTERRUPT_CORE0_Type) SetRWBT_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.RWBT_NMI_MAP.Reg, volatile.LoadUint32(&o.RWBT_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetRWBT_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.RWBT_NMI_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.RWBLE_NMI_MAP: rwble_nmi intr map register
func (o *INTERRUPT_CORE0_Type) SetRWBLE_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.RWBLE_NMI_MAP.Reg, volatile.LoadUint32(&o.RWBLE_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetRWBLE_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.RWBLE_NMI_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.I2C_MST_INT_MAP: i2c intr map register
func (o *INTERRUPT_CORE0_Type) SetI2C_MST_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.I2C_MST_INT_MAP.Reg, volatile.LoadUint32(&o.I2C_MST_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetI2C_MST_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.I2C_MST_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.SLC0_INTR_MAP: slc0 intr map register
func (o *INTERRUPT_CORE0_Type) SetSLC0_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.SLC0_INTR_MAP.Reg, volatile.LoadUint32(&o.SLC0_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetSLC0_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.SLC0_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.SLC1_INTR_MAP: slc1 intr map register
func (o *INTERRUPT_CORE0_Type) SetSLC1_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.SLC1_INTR_MAP.Reg, volatile.LoadUint32(&o.SLC1_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetSLC1_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.SLC1_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.APB_CTRL_INTR_MAP: apb_ctrl intr map register
func (o *INTERRUPT_CORE0_Type) SetAPB_CTRL_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APB_CTRL_INTR_MAP.Reg, volatile.LoadUint32(&o.APB_CTRL_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetAPB_CTRL_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APB_CTRL_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.UHCI0_INTR_MAP: uchi0 intr map register
func (o *INTERRUPT_CORE0_Type) SetUHCI0_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.UHCI0_INTR_MAP.Reg, volatile.LoadUint32(&o.UHCI0_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetUHCI0_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.UHCI0_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.GPIO_INTERRUPT_PRO_MAP: gpio intr map register
func (o *INTERRUPT_CORE0_Type) SetGPIO_INTERRUPT_PRO_MAP(value uint32) {
	volatile.StoreUint32(&o.GPIO_INTERRUPT_PRO_MAP.Reg, volatile.LoadUint32(&o.GPIO_INTERRUPT_PRO_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetGPIO_INTERRUPT_PRO_MAP() uint32 {
	return volatile.LoadUint32(&o.GPIO_INTERRUPT_PRO_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.GPIO_INTERRUPT_PRO_NMI_MAP: gpio_pro intr map register
func (o *INTERRUPT_CORE0_Type) SetGPIO_INTERRUPT_PRO_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.GPIO_INTERRUPT_PRO_NMI_MAP.Reg, volatile.LoadUint32(&o.GPIO_INTERRUPT_PRO_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetGPIO_INTERRUPT_PRO_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.GPIO_INTERRUPT_PRO_NMI_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.SPI_INTR_1_MAP: gpio_pro_nmi intr map register
func (o *INTERRUPT_CORE0_Type) SetSPI_INTR_1_MAP(value uint32) {
	volatile.StoreUint32(&o.SPI_INTR_1_MAP.Reg, volatile.LoadUint32(&o.SPI_INTR_1_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetSPI_INTR_1_MAP() uint32 {
	return volatile.LoadUint32(&o.SPI_INTR_1_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.SPI_INTR_2_MAP: spi1 intr map register
func (o *INTERRUPT_CORE0_Type) SetSPI_INTR_2_MAP(value uint32) {
	volatile.StoreUint32(&o.SPI_INTR_2_MAP.Reg, volatile.LoadUint32(&o.SPI_INTR_2_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetSPI_INTR_2_MAP() uint32 {
	return volatile.LoadUint32(&o.SPI_INTR_2_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.I2S1_INT_MAP: spi2 intr map register
func (o *INTERRUPT_CORE0_Type) SetI2S1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.I2S1_INT_MAP.Reg, volatile.LoadUint32(&o.I2S1_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetI2S1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.I2S1_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.UART_INTR_MAP: i2s1 intr map register
func (o *INTERRUPT_CORE0_Type) SetUART_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.UART_INTR_MAP.Reg, volatile.LoadUint32(&o.UART_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetUART_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.UART_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.UART1_INTR_MAP: uart1 intr map register
func (o *INTERRUPT_CORE0_Type) SetUART1_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.UART1_INTR_MAP.Reg, volatile.LoadUint32(&o.UART1_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetUART1_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.UART1_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.LEDC_INT_MAP: ledc intr map register
func (o *INTERRUPT_CORE0_Type) SetLEDC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LEDC_INT_MAP.Reg, volatile.LoadUint32(&o.LEDC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetLEDC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LEDC_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.EFUSE_INT_MAP: efuse intr map register
func (o *INTERRUPT_CORE0_Type) SetEFUSE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.EFUSE_INT_MAP.Reg, volatile.LoadUint32(&o.EFUSE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetEFUSE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.EFUSE_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.CAN_INT_MAP: can intr map register
func (o *INTERRUPT_CORE0_Type) SetCAN_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CAN_INT_MAP.Reg, volatile.LoadUint32(&o.CAN_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCAN_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CAN_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.USB_INTR_MAP: usb intr map register
func (o *INTERRUPT_CORE0_Type) SetUSB_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.USB_INTR_MAP.Reg, volatile.LoadUint32(&o.USB_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetUSB_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.USB_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.RTC_CORE_INTR_MAP: rtc intr map register
func (o *INTERRUPT_CORE0_Type) SetRTC_CORE_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.RTC_CORE_INTR_MAP.Reg, volatile.LoadUint32(&o.RTC_CORE_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetRTC_CORE_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.RTC_CORE_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.RMT_INTR_MAP: rmt intr map register
func (o *INTERRUPT_CORE0_Type) SetRMT_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.RMT_INTR_MAP.Reg, volatile.LoadUint32(&o.RMT_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetRMT_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.RMT_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.I2C_EXT0_INTR_MAP: i2c intr map register
func (o *INTERRUPT_CORE0_Type) SetI2C_EXT0_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.I2C_EXT0_INTR_MAP.Reg, volatile.LoadUint32(&o.I2C_EXT0_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetI2C_EXT0_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.I2C_EXT0_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.TIMER_INT1_MAP: timer1 intr map register
func (o *INTERRUPT_CORE0_Type) SetTIMER_INT1_MAP(value uint32) {
	volatile.StoreUint32(&o.TIMER_INT1_MAP.Reg, volatile.LoadUint32(&o.TIMER_INT1_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetTIMER_INT1_MAP() uint32 {
	return volatile.LoadUint32(&o.TIMER_INT1_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.TIMER_INT2_MAP: timer2 intr map register
func (o *INTERRUPT_CORE0_Type) SetTIMER_INT2_MAP(value uint32) {
	volatile.StoreUint32(&o.TIMER_INT2_MAP.Reg, volatile.LoadUint32(&o.TIMER_INT2_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetTIMER_INT2_MAP() uint32 {
	return volatile.LoadUint32(&o.TIMER_INT2_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.TG_T0_INT_MAP: tg to intr map register
func (o *INTERRUPT_CORE0_Type) SetTG_T0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.TG_T0_INT_MAP.Reg, volatile.LoadUint32(&o.TG_T0_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetTG_T0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.TG_T0_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.TG_WDT_INT_MAP: tg wdt intr map register
func (o *INTERRUPT_CORE0_Type) SetTG_WDT_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.TG_WDT_INT_MAP.Reg, volatile.LoadUint32(&o.TG_WDT_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetTG_WDT_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.TG_WDT_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.TG1_T0_INT_MAP: tg1 to intr map register
func (o *INTERRUPT_CORE0_Type) SetTG1_T0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.TG1_T0_INT_MAP.Reg, volatile.LoadUint32(&o.TG1_T0_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetTG1_T0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.TG1_T0_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.TG1_WDT_INT_MAP: tg1 wdt intr map register
func (o *INTERRUPT_CORE0_Type) SetTG1_WDT_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.TG1_WDT_INT_MAP.Reg, volatile.LoadUint32(&o.TG1_WDT_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetTG1_WDT_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.TG1_WDT_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.CACHE_IA_INT_MAP: cache ia intr map register
func (o *INTERRUPT_CORE0_Type) SetCACHE_IA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CACHE_IA_INT_MAP.Reg, volatile.LoadUint32(&o.CACHE_IA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCACHE_IA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CACHE_IA_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.SYSTIMER_TARGET0_INT_MAP: systimer intr map register
func (o *INTERRUPT_CORE0_Type) SetSYSTIMER_TARGET0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SYSTIMER_TARGET0_INT_MAP.Reg, volatile.LoadUint32(&o.SYSTIMER_TARGET0_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetSYSTIMER_TARGET0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SYSTIMER_TARGET0_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.SYSTIMER_TARGET1_INT_MAP: systimer target1 intr map register
func (o *INTERRUPT_CORE0_Type) SetSYSTIMER_TARGET1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SYSTIMER_TARGET1_INT_MAP.Reg, volatile.LoadUint32(&o.SYSTIMER_TARGET1_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetSYSTIMER_TARGET1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SYSTIMER_TARGET1_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.SYSTIMER_TARGET2_INT_MAP: systimer target2 intr map register
func (o *INTERRUPT_CORE0_Type) SetSYSTIMER_TARGET2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SYSTIMER_TARGET2_INT_MAP.Reg, volatile.LoadUint32(&o.SYSTIMER_TARGET2_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetSYSTIMER_TARGET2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SYSTIMER_TARGET2_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.SPI_MEM_REJECT_INTR_MAP: spi mem reject intr map register
func (o *INTERRUPT_CORE0_Type) SetSPI_MEM_REJECT_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.SPI_MEM_REJECT_INTR_MAP.Reg, volatile.LoadUint32(&o.SPI_MEM_REJECT_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetSPI_MEM_REJECT_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.SPI_MEM_REJECT_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.ICACHE_PRELOAD_INT_MAP: icache perload intr map register
func (o *INTERRUPT_CORE0_Type) SetICACHE_PRELOAD_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.ICACHE_PRELOAD_INT_MAP.Reg, volatile.LoadUint32(&o.ICACHE_PRELOAD_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetICACHE_PRELOAD_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.ICACHE_PRELOAD_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.ICACHE_SYNC_INT_MAP: icache sync intr map register
func (o *INTERRUPT_CORE0_Type) SetICACHE_SYNC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.ICACHE_SYNC_INT_MAP.Reg, volatile.LoadUint32(&o.ICACHE_SYNC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetICACHE_SYNC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.ICACHE_SYNC_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.APB_ADC_INT_MAP: adc intr map register
func (o *INTERRUPT_CORE0_Type) SetAPB_ADC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APB_ADC_INT_MAP.Reg, volatile.LoadUint32(&o.APB_ADC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetAPB_ADC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APB_ADC_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.DMA_CH0_INT_MAP: dma ch0 intr map register
func (o *INTERRUPT_CORE0_Type) SetDMA_CH0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.DMA_CH0_INT_MAP.Reg, volatile.LoadUint32(&o.DMA_CH0_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetDMA_CH0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.DMA_CH0_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.DMA_CH1_INT_MAP: dma ch1 intr map register
func (o *INTERRUPT_CORE0_Type) SetDMA_CH1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.DMA_CH1_INT_MAP.Reg, volatile.LoadUint32(&o.DMA_CH1_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetDMA_CH1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.DMA_CH1_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.DMA_CH2_INT_MAP: dma ch2 intr map register
func (o *INTERRUPT_CORE0_Type) SetDMA_CH2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.DMA_CH2_INT_MAP.Reg, volatile.LoadUint32(&o.DMA_CH2_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetDMA_CH2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.DMA_CH2_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.RSA_INT_MAP: rsa intr map register
func (o *INTERRUPT_CORE0_Type) SetRSA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.RSA_INT_MAP.Reg, volatile.LoadUint32(&o.RSA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetRSA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.RSA_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.AES_INT_MAP: aes intr map register
func (o *INTERRUPT_CORE0_Type) SetAES_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AES_INT_MAP.Reg, volatile.LoadUint32(&o.AES_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetAES_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AES_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.SHA_INT_MAP: sha intr map register
func (o *INTERRUPT_CORE0_Type) SetSHA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SHA_INT_MAP.Reg, volatile.LoadUint32(&o.SHA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetSHA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SHA_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.CPU_INTR_FROM_CPU_0_MAP: cpu from cpu 0 intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INTR_FROM_CPU_0_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INTR_FROM_CPU_0_MAP.Reg, volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_0_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INTR_FROM_CPU_0_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_0_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.CPU_INTR_FROM_CPU_1_MAP: cpu from cpu 0 intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INTR_FROM_CPU_1_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INTR_FROM_CPU_1_MAP.Reg, volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_1_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INTR_FROM_CPU_1_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_1_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.CPU_INTR_FROM_CPU_2_MAP: cpu from cpu 1 intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INTR_FROM_CPU_2_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INTR_FROM_CPU_2_MAP.Reg, volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_2_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INTR_FROM_CPU_2_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_2_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.CPU_INTR_FROM_CPU_3_MAP: cpu from cpu 3 intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INTR_FROM_CPU_3_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INTR_FROM_CPU_3_MAP.Reg, volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_3_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INTR_FROM_CPU_3_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_3_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.ASSIST_DEBUG_INTR_MAP: assist debug intr map register
func (o *INTERRUPT_CORE0_Type) SetASSIST_DEBUG_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.ASSIST_DEBUG_INTR_MAP.Reg, volatile.LoadUint32(&o.ASSIST_DEBUG_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetASSIST_DEBUG_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.ASSIST_DEBUG_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP: dma pms violatile intr map register
func (o *INTERRUPT_CORE0_Type) SetDMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP.Reg, volatile.LoadUint32(&o.DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetDMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP: iram0 pms violatile intr map register
func (o *INTERRUPT_CORE0_Type) SetCORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP.Reg, volatile.LoadUint32(&o.CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP.Reg, volatile.LoadUint32(&o.CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.BACKUP_PMS_VIOLATE_INTR_MAP: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetBACKUP_PMS_VIOLATE_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.BACKUP_PMS_VIOLATE_INTR_MAP.Reg, volatile.LoadUint32(&o.BACKUP_PMS_VIOLATE_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetBACKUP_PMS_VIOLATE_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.BACKUP_PMS_VIOLATE_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.CACHE_CORE0_ACS_INT_MAP: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCACHE_CORE0_ACS_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CACHE_CORE0_ACS_INT_MAP.Reg, volatile.LoadUint32(&o.CACHE_CORE0_ACS_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCACHE_CORE0_ACS_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CACHE_CORE0_ACS_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.INTR_STATUS_REG_0: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetINTR_STATUS_REG_0(value uint32) {
	volatile.StoreUint32(&o.INTR_STATUS_REG_0.Reg, value)
}
func (o *INTERRUPT_CORE0_Type) GetINTR_STATUS_REG_0() uint32 {
	return volatile.LoadUint32(&o.INTR_STATUS_REG_0.Reg)
}

// INTERRUPT_CORE0.INTR_STATUS_REG_1: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetINTR_STATUS_REG_1(value uint32) {
	volatile.StoreUint32(&o.INTR_STATUS_REG_1.Reg, value)
}
func (o *INTERRUPT_CORE0_Type) GetINTR_STATUS_REG_1() uint32 {
	return volatile.LoadUint32(&o.INTR_STATUS_REG_1.Reg)
}

// INTERRUPT_CORE0.CLOCK_GATE: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCLOCK_GATE_REG_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCLOCK_GATE_REG_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// INTERRUPT_CORE0.CPU_INT_ENABLE: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_ENABLE.Reg, value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_ENABLE.Reg)
}

// INTERRUPT_CORE0.CPU_INT_TYPE: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_TYPE.Reg, value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_TYPE() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_TYPE.Reg)
}

// INTERRUPT_CORE0.CPU_INT_CLEAR: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_CLEAR(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_CLEAR.Reg, value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_CLEAR() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_CLEAR.Reg)
}

// INTERRUPT_CORE0.CPU_INT_EIP_STATUS: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_EIP_STATUS(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_EIP_STATUS.Reg, value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_EIP_STATUS() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_EIP_STATUS.Reg)
}

// INTERRUPT_CORE0.CPU_INT_PRI_0: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_0_CPU_PRI_0_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_0.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_0.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_0_CPU_PRI_0_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_0.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_1: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_1_CPU_PRI_1_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_1.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_1.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_1_CPU_PRI_1_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_1.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_2: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_2_CPU_PRI_2_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_2.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_2.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_2_CPU_PRI_2_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_2.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_3: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_3_CPU_PRI_3_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_3.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_3.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_3_CPU_PRI_3_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_3.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_4: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_4_CPU_PRI_4_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_4.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_4.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_4_CPU_PRI_4_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_4.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_5: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_5_CPU_PRI_5_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_5.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_5.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_5_CPU_PRI_5_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_5.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_6: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_6_CPU_PRI_6_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_6.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_6.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_6_CPU_PRI_6_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_6.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_7: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_7_CPU_PRI_7_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_7.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_7.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_7_CPU_PRI_7_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_7.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_8: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_8_CPU_PRI_8_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_8.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_8.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_8_CPU_PRI_8_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_8.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_9: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_9_CPU_PRI_9_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_9.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_9.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_9_CPU_PRI_9_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_9.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_10: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_10_CPU_PRI_10_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_10.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_10.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_10_CPU_PRI_10_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_10.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_11: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_11_CPU_PRI_11_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_11.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_11.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_11_CPU_PRI_11_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_11.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_12: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_12_CPU_PRI_12_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_12.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_12.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_12_CPU_PRI_12_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_12.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_13: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_13_CPU_PRI_13_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_13.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_13.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_13_CPU_PRI_13_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_13.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_14: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_14_CPU_PRI_14_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_14.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_14.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_14_CPU_PRI_14_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_14.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_15: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_15_CPU_PRI_15_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_15.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_15.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_15_CPU_PRI_15_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_15.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_16: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_16_CPU_PRI_16_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_16.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_16.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_16_CPU_PRI_16_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_16.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_17: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_17_CPU_PRI_17_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_17.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_17.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_17_CPU_PRI_17_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_17.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_18: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_18_CPU_PRI_18_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_18.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_18.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_18_CPU_PRI_18_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_18.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_19: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_19_CPU_PRI_19_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_19.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_19.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_19_CPU_PRI_19_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_19.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_20: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_20_CPU_PRI_20_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_20.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_20.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_20_CPU_PRI_20_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_20.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_21: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_21_CPU_PRI_21_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_21.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_21.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_21_CPU_PRI_21_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_21.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_22: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_22_CPU_PRI_22_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_22.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_22.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_22_CPU_PRI_22_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_22.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_23: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_23_CPU_PRI_23_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_23.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_23.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_23_CPU_PRI_23_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_23.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_24: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_24_CPU_PRI_24_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_24.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_24.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_24_CPU_PRI_24_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_24.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_25: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_25_CPU_PRI_25_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_25.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_25.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_25_CPU_PRI_25_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_25.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_26: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_26_CPU_PRI_26_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_26.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_26.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_26_CPU_PRI_26_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_26.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_27: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_27_CPU_PRI_27_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_27.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_27.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_27_CPU_PRI_27_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_27.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_28: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_28_CPU_PRI_28_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_28.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_28.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_28_CPU_PRI_28_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_28.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_29: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_29_CPU_PRI_29_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_29.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_29.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_29_CPU_PRI_29_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_29.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_30: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_30_CPU_PRI_30_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_30.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_30.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_30_CPU_PRI_30_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_30.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_31: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_31_CPU_PRI_31_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_31.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_31.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_31_CPU_PRI_31_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_31.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_THRESH: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_THRESH(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_THRESH.Reg, volatile.LoadUint32(&o.CPU_INT_THRESH.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_THRESH() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_THRESH.Reg) & 0xf
}

// INTERRUPT_CORE0.INTERRUPT_REG_DATE: mac intr map register
func (o *INTERRUPT_CORE0_Type) SetINTERRUPT_REG_DATE(value uint32) {
	volatile.StoreUint32(&o.INTERRUPT_REG_DATE.Reg, volatile.LoadUint32(&o.INTERRUPT_REG_DATE.Reg)&^(0xfffffff)|value)
}
func (o *INTERRUPT_CORE0_Type) GetINTERRUPT_REG_DATE() uint32 {
	return volatile.LoadUint32(&o.INTERRUPT_REG_DATE.Reg) & 0xfffffff
}

// Peripheral IO_MUX
type IO_MUX_Type struct {
	PIN_CTRL volatile.Register32 // 0x0
	GPIO0    volatile.Register32 // 0x4
	GPIO1    volatile.Register32 // 0x8
	GPIO2    volatile.Register32 // 0xC
	GPIO3    volatile.Register32 // 0x10
	GPIO4    volatile.Register32 // 0x14
	GPIO5    volatile.Register32 // 0x18
	GPIO6    volatile.Register32 // 0x1C
	GPIO7    volatile.Register32 // 0x20
	GPIO8    volatile.Register32 // 0x24
	GPIO9    volatile.Register32 // 0x28
	GPIO10   volatile.Register32 // 0x2C
	GPIO11   volatile.Register32 // 0x30
	GPIO12   volatile.Register32 // 0x34
	GPIO13   volatile.Register32 // 0x38
	GPIO14   volatile.Register32 // 0x3C
	GPIO15   volatile.Register32 // 0x40
	GPIO16   volatile.Register32 // 0x44
	GPIO17   volatile.Register32 // 0x48
	GPIO18   volatile.Register32 // 0x4C
	GPIO19   volatile.Register32 // 0x50
	GPIO20   volatile.Register32 // 0x54
	GPIO21   volatile.Register32 // 0x58
	_        [160]byte
	DATE     volatile.Register32 // 0xFC
}

// IO_MUX.PIN_CTRL: Clock Output Configuration Register
func (o *IO_MUX_Type) SetPIN_CTRL_CLK_OUT1(value uint32) {
	volatile.StoreUint32(&o.PIN_CTRL.Reg, volatile.LoadUint32(&o.PIN_CTRL.Reg)&^(0xf)|value)
}
func (o *IO_MUX_Type) GetPIN_CTRL_CLK_OUT1() uint32 {
	return volatile.LoadUint32(&o.PIN_CTRL.Reg) & 0xf
}
func (o *IO_MUX_Type) SetPIN_CTRL_CLK_OUT2(value uint32) {
	volatile.StoreUint32(&o.PIN_CTRL.Reg, volatile.LoadUint32(&o.PIN_CTRL.Reg)&^(0xf0)|value<<4)
}
func (o *IO_MUX_Type) GetPIN_CTRL_CLK_OUT2() uint32 {
	return (volatile.LoadUint32(&o.PIN_CTRL.Reg) & 0xf0) >> 4
}
func (o *IO_MUX_Type) SetPIN_CTRL_CLK_OUT3(value uint32) {
	volatile.StoreUint32(&o.PIN_CTRL.Reg, volatile.LoadUint32(&o.PIN_CTRL.Reg)&^(0xf00)|value<<8)
}
func (o *IO_MUX_Type) GetPIN_CTRL_CLK_OUT3() uint32 {
	return (volatile.LoadUint32(&o.PIN_CTRL.Reg) & 0xf00) >> 8
}

// IO_MUX.GPIO0: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO0_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO0.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO0_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO0_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO0_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO0_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO0_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO0_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO0_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO0_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO0_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO0_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO0_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO0_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO0_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO0_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO0_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO0_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO1: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO1_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO1.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO1_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO1_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO1_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO1_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO1_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO1_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO1_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO1_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO1_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO1_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO1_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO1_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO1_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO1_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO1_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO1_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO2: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO2_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO2.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO2_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO2_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO2_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO2_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO2_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO2_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO2_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO2_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO2_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO2_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO2_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO2_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO2_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO2_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO2_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO2_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO3: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO3_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO3.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO3_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO3_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO3_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO3_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO3_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO3_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO3_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO3_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO3_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO3_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO3_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO3_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO3_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO3_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO3_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO3_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO4: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO4_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO4.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO4_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO4_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO4_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO4_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO4_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO4_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO4_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO4_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO4_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO4_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO4_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO4_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO4_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO4_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO4_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO4_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO5: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO5_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO5.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO5_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO5_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO5_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO5_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO5_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO5_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO5_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO5_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO5_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO5_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO5_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO5_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO5_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO5_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO5_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO5_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO6: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO6_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO6.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO6_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO6_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO6_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO6_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO6_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO6_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO6_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO6_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO6_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO6_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO6_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO6_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO6_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO6_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO6_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO6_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO7: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO7_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO7.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO7_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO7_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO7_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO7_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO7_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO7_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO7_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO7_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO7_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO7_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO7_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO7_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO7_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO7_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO7_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO7_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO8: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO8_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO8.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO8_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO8_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO8_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO8_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO8_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO8_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO8_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO8_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO8_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO8_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO8_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO8_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO8_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO8_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO8_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO8_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO9: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO9_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO9.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO9_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO9_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO9_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO9_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO9_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO9_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO9_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO9_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO9_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO9_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO9_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO9_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO9_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO9_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO9_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO9_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO10: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO10_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO10.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO10_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO10_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO10_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO10_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO10_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO10_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO10_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO10_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO10_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO10_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO10_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO10_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO10_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO10_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO10_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO10_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO11: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO11_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO11.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO11_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO11_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO11_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO11_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO11_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO11_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO11_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO11_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO11_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO11_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO11_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO11_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO11_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO11_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO11_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO11_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO12: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO12_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO12.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO12_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO12_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO12_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO12_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO12_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO12_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO12_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO12_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO12_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO12_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO12_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO12_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO12_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO12_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO12_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO12_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO13: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO13_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO13.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO13_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO13_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO13_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO13_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO13_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO13_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO13_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO13_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO13_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO13_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO13_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO13_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO13_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO13_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO13_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO13_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO14: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO14_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO14.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO14_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO14_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO14_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO14_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO14_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO14_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO14_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO14_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO14_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO14_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO14_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO14_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO14_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO14_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO14_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO14_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO15: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO15_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO15.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO15_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO15_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO15_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO15_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO15_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO15_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO15_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO15_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO15_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO15_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO15_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO15_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO15_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO15_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO15_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO15_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO16: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO16_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO16.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO16_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO16_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO16_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO16_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO16_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO16_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO16_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO16_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO16_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO16_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO16_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO16_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO16_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO16_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO16_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO16_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO17: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO17_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO17.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO17_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO17_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO17_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO17_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO17_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO17_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO17_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO17_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO17_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO17_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO17_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO17_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO17_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO17_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO17_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO17_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO18: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO18_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO18.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO18_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO18_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO18_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO18_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO18_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO18_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO18_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO18_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO18_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO18_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO18_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO18_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO18_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO18_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO18_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO18_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO19: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO19_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO19.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO19_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO19_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO19_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO19_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO19_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO19_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO19_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO19_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO19_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO19_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO19_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO19_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO19_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO19_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO19_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO19_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO20: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO20_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO20.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO20_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO20_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO20_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO20_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO20_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO20_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO20_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO20_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO20_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO20_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO20_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO20_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO20_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO20_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO20_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO20_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO21: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO21_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO21_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO21.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO21_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO21_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO21_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO21_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO21_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO21_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO21_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO21_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO21_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO21_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO21_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO21_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO21_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO21_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO21_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO21_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO21_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO21_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO21_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO21_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x8000) >> 15
}

// IO_MUX.DATE: IO MUX Version Control Register
func (o *IO_MUX_Type) SetDATE_REG_DATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *IO_MUX_Type) GetDATE_REG_DATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// Peripheral LEDC
type LEDC_Type struct {
	LSCH0_CONF0    volatile.Register32 // 0x0
	LSCH0_HPOINT   volatile.Register32 // 0x4
	LSCH0_DUTY     volatile.Register32 // 0x8
	LSCH0_CONF1    volatile.Register32 // 0xC
	LSCH0_DUTY_R   volatile.Register32 // 0x10
	LSCH1_CONF0    volatile.Register32 // 0x14
	LSCH1_HPOINT   volatile.Register32 // 0x18
	LSCH1_DUTY     volatile.Register32 // 0x1C
	LSCH1_CONF1    volatile.Register32 // 0x20
	LSCH1_DUTY_R   volatile.Register32 // 0x24
	LSCH2_CONF0    volatile.Register32 // 0x28
	LSCH2_HPOINT   volatile.Register32 // 0x2C
	LSCH2_DUTY     volatile.Register32 // 0x30
	LSCH2_CONF1    volatile.Register32 // 0x34
	LSCH2_DUTY_R   volatile.Register32 // 0x38
	LSCH3_CONF0    volatile.Register32 // 0x3C
	LSCH3_HPOINT   volatile.Register32 // 0x40
	LSCH3_DUTY     volatile.Register32 // 0x44
	LSCH3_CONF1    volatile.Register32 // 0x48
	LSCH3_DUTY_R   volatile.Register32 // 0x4C
	LSCH4_CONF0    volatile.Register32 // 0x50
	LSCH4_HPOINT   volatile.Register32 // 0x54
	LSCH4_DUTY     volatile.Register32 // 0x58
	LSCH4_CONF1    volatile.Register32 // 0x5C
	LSCH4_DUTY_R   volatile.Register32 // 0x60
	LSCH5_CONF0    volatile.Register32 // 0x64
	LSCH5_HPOINT   volatile.Register32 // 0x68
	LSCH5_DUTY     volatile.Register32 // 0x6C
	LSCH5_CONF1    volatile.Register32 // 0x70
	LSCH5_DUTY_R   volatile.Register32 // 0x74
	_              [40]byte
	LSTIMER0_CONF  volatile.Register32 // 0xA0
	LSTIMER0_VALUE volatile.Register32 // 0xA4
	LSTIMER1_CONF  volatile.Register32 // 0xA8
	LSTIMER1_VALUE volatile.Register32 // 0xAC
	LSTIMER2_CONF  volatile.Register32 // 0xB0
	LSTIMER2_VALUE volatile.Register32 // 0xB4
	LSTIMER3_CONF  volatile.Register32 // 0xB8
	LSTIMER3_VALUE volatile.Register32 // 0xBC
	INT_RAW        volatile.Register32 // 0xC0
	INT_ST         volatile.Register32 // 0xC4
	INT_ENA        volatile.Register32 // 0xC8
	INT_CLR        volatile.Register32 // 0xCC
	CONF           volatile.Register32 // 0xD0
	_              [40]byte
	DATE           volatile.Register32 // 0xFC
}

// LEDC.LSCH0_CONF0: LEDC_LSCH0_CONF0.
func (o *LEDC_Type) SetLSCH0_CONF0_TIMER_SEL_LSCH0(value uint32) {
	volatile.StoreUint32(&o.LSCH0_CONF0.Reg, volatile.LoadUint32(&o.LSCH0_CONF0.Reg)&^(0x3)|value)
}
func (o *LEDC_Type) GetLSCH0_CONF0_TIMER_SEL_LSCH0() uint32 {
	return volatile.LoadUint32(&o.LSCH0_CONF0.Reg) & 0x3
}
func (o *LEDC_Type) SetLSCH0_CONF0_SIG_OUT_EN_LSCH0(value uint32) {
	volatile.StoreUint32(&o.LSCH0_CONF0.Reg, volatile.LoadUint32(&o.LSCH0_CONF0.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetLSCH0_CONF0_SIG_OUT_EN_LSCH0() uint32 {
	return (volatile.LoadUint32(&o.LSCH0_CONF0.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetLSCH0_CONF0_IDLE_LV_LSCH0(value uint32) {
	volatile.StoreUint32(&o.LSCH0_CONF0.Reg, volatile.LoadUint32(&o.LSCH0_CONF0.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetLSCH0_CONF0_IDLE_LV_LSCH0() uint32 {
	return (volatile.LoadUint32(&o.LSCH0_CONF0.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetLSCH0_CONF0_PARA_UP_LSCH0(value uint32) {
	volatile.StoreUint32(&o.LSCH0_CONF0.Reg, volatile.LoadUint32(&o.LSCH0_CONF0.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetLSCH0_CONF0_PARA_UP_LSCH0() uint32 {
	return (volatile.LoadUint32(&o.LSCH0_CONF0.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetLSCH0_CONF0_OVF_NUM_LSCH0(value uint32) {
	volatile.StoreUint32(&o.LSCH0_CONF0.Reg, volatile.LoadUint32(&o.LSCH0_CONF0.Reg)&^(0x7fe0)|value<<5)
}
func (o *LEDC_Type) GetLSCH0_CONF0_OVF_NUM_LSCH0() uint32 {
	return (volatile.LoadUint32(&o.LSCH0_CONF0.Reg) & 0x7fe0) >> 5
}
func (o *LEDC_Type) SetLSCH0_CONF0_OVF_CNT_EN_LSCH0(value uint32) {
	volatile.StoreUint32(&o.LSCH0_CONF0.Reg, volatile.LoadUint32(&o.LSCH0_CONF0.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetLSCH0_CONF0_OVF_CNT_EN_LSCH0() uint32 {
	return (volatile.LoadUint32(&o.LSCH0_CONF0.Reg) & 0x8000) >> 15
}
func (o *LEDC_Type) SetLSCH0_CONF0_OVF_CNT_RESET_LSCH0(value uint32) {
	volatile.StoreUint32(&o.LSCH0_CONF0.Reg, volatile.LoadUint32(&o.LSCH0_CONF0.Reg)&^(0x10000)|value<<16)
}
func (o *LEDC_Type) GetLSCH0_CONF0_OVF_CNT_RESET_LSCH0() uint32 {
	return (volatile.LoadUint32(&o.LSCH0_CONF0.Reg) & 0x10000) >> 16
}

// LEDC.LSCH0_HPOINT: LEDC_LSCH0_HPOINT.
func (o *LEDC_Type) SetLSCH0_HPOINT_HPOINT_LSCH0(value uint32) {
	volatile.StoreUint32(&o.LSCH0_HPOINT.Reg, volatile.LoadUint32(&o.LSCH0_HPOINT.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetLSCH0_HPOINT_HPOINT_LSCH0() uint32 {
	return volatile.LoadUint32(&o.LSCH0_HPOINT.Reg) & 0x3fff
}

// LEDC.LSCH0_DUTY: LEDC_LSCH0_DUTY.
func (o *LEDC_Type) SetLSCH0_DUTY_DUTY_LSCH0(value uint32) {
	volatile.StoreUint32(&o.LSCH0_DUTY.Reg, volatile.LoadUint32(&o.LSCH0_DUTY.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetLSCH0_DUTY_DUTY_LSCH0() uint32 {
	return volatile.LoadUint32(&o.LSCH0_DUTY.Reg) & 0x7ffff
}

// LEDC.LSCH0_CONF1: LEDC_LSCH0_CONF1.
func (o *LEDC_Type) SetLSCH0_CONF1_DUTY_SCALE_LSCH0(value uint32) {
	volatile.StoreUint32(&o.LSCH0_CONF1.Reg, volatile.LoadUint32(&o.LSCH0_CONF1.Reg)&^(0x3ff)|value)
}
func (o *LEDC_Type) GetLSCH0_CONF1_DUTY_SCALE_LSCH0() uint32 {
	return volatile.LoadUint32(&o.LSCH0_CONF1.Reg) & 0x3ff
}
func (o *LEDC_Type) SetLSCH0_CONF1_DUTY_CYCLE_LSCH0(value uint32) {
	volatile.StoreUint32(&o.LSCH0_CONF1.Reg, volatile.LoadUint32(&o.LSCH0_CONF1.Reg)&^(0xffc00)|value<<10)
}
func (o *LEDC_Type) GetLSCH0_CONF1_DUTY_CYCLE_LSCH0() uint32 {
	return (volatile.LoadUint32(&o.LSCH0_CONF1.Reg) & 0xffc00) >> 10
}
func (o *LEDC_Type) SetLSCH0_CONF1_DUTY_NUM_LSCH0(value uint32) {
	volatile.StoreUint32(&o.LSCH0_CONF1.Reg, volatile.LoadUint32(&o.LSCH0_CONF1.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LEDC_Type) GetLSCH0_CONF1_DUTY_NUM_LSCH0() uint32 {
	return (volatile.LoadUint32(&o.LSCH0_CONF1.Reg) & 0x3ff00000) >> 20
}
func (o *LEDC_Type) SetLSCH0_CONF1_DUTY_INC_LSCH0(value uint32) {
	volatile.StoreUint32(&o.LSCH0_CONF1.Reg, volatile.LoadUint32(&o.LSCH0_CONF1.Reg)&^(0x40000000)|value<<30)
}
func (o *LEDC_Type) GetLSCH0_CONF1_DUTY_INC_LSCH0() uint32 {
	return (volatile.LoadUint32(&o.LSCH0_CONF1.Reg) & 0x40000000) >> 30
}
func (o *LEDC_Type) SetLSCH0_CONF1_DUTY_START_LSCH0(value uint32) {
	volatile.StoreUint32(&o.LSCH0_CONF1.Reg, volatile.LoadUint32(&o.LSCH0_CONF1.Reg)&^(0x80000000)|value<<31)
}
func (o *LEDC_Type) GetLSCH0_CONF1_DUTY_START_LSCH0() uint32 {
	return (volatile.LoadUint32(&o.LSCH0_CONF1.Reg) & 0x80000000) >> 31
}

// LEDC.LSCH0_DUTY_R: LEDC_LSCH0_DUTY_R.
func (o *LEDC_Type) SetLSCH0_DUTY_R_DUTY_LSCH0_R(value uint32) {
	volatile.StoreUint32(&o.LSCH0_DUTY_R.Reg, volatile.LoadUint32(&o.LSCH0_DUTY_R.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetLSCH0_DUTY_R_DUTY_LSCH0_R() uint32 {
	return volatile.LoadUint32(&o.LSCH0_DUTY_R.Reg) & 0x7ffff
}

// LEDC.LSCH1_CONF0: LEDC_LSCH1_CONF0.
func (o *LEDC_Type) SetLSCH1_CONF0_TIMER_SEL_LSCH1(value uint32) {
	volatile.StoreUint32(&o.LSCH1_CONF0.Reg, volatile.LoadUint32(&o.LSCH1_CONF0.Reg)&^(0x3)|value)
}
func (o *LEDC_Type) GetLSCH1_CONF0_TIMER_SEL_LSCH1() uint32 {
	return volatile.LoadUint32(&o.LSCH1_CONF0.Reg) & 0x3
}
func (o *LEDC_Type) SetLSCH1_CONF0_SIG_OUT_EN_LSCH1(value uint32) {
	volatile.StoreUint32(&o.LSCH1_CONF0.Reg, volatile.LoadUint32(&o.LSCH1_CONF0.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetLSCH1_CONF0_SIG_OUT_EN_LSCH1() uint32 {
	return (volatile.LoadUint32(&o.LSCH1_CONF0.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetLSCH1_CONF0_IDLE_LV_LSCH1(value uint32) {
	volatile.StoreUint32(&o.LSCH1_CONF0.Reg, volatile.LoadUint32(&o.LSCH1_CONF0.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetLSCH1_CONF0_IDLE_LV_LSCH1() uint32 {
	return (volatile.LoadUint32(&o.LSCH1_CONF0.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetLSCH1_CONF0_PARA_UP_LSCH1(value uint32) {
	volatile.StoreUint32(&o.LSCH1_CONF0.Reg, volatile.LoadUint32(&o.LSCH1_CONF0.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetLSCH1_CONF0_PARA_UP_LSCH1() uint32 {
	return (volatile.LoadUint32(&o.LSCH1_CONF0.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetLSCH1_CONF0_OVF_NUM_LSCH1(value uint32) {
	volatile.StoreUint32(&o.LSCH1_CONF0.Reg, volatile.LoadUint32(&o.LSCH1_CONF0.Reg)&^(0x7fe0)|value<<5)
}
func (o *LEDC_Type) GetLSCH1_CONF0_OVF_NUM_LSCH1() uint32 {
	return (volatile.LoadUint32(&o.LSCH1_CONF0.Reg) & 0x7fe0) >> 5
}
func (o *LEDC_Type) SetLSCH1_CONF0_OVF_CNT_EN_LSCH1(value uint32) {
	volatile.StoreUint32(&o.LSCH1_CONF0.Reg, volatile.LoadUint32(&o.LSCH1_CONF0.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetLSCH1_CONF0_OVF_CNT_EN_LSCH1() uint32 {
	return (volatile.LoadUint32(&o.LSCH1_CONF0.Reg) & 0x8000) >> 15
}
func (o *LEDC_Type) SetLSCH1_CONF0_OVF_CNT_RESET_LSCH1(value uint32) {
	volatile.StoreUint32(&o.LSCH1_CONF0.Reg, volatile.LoadUint32(&o.LSCH1_CONF0.Reg)&^(0x10000)|value<<16)
}
func (o *LEDC_Type) GetLSCH1_CONF0_OVF_CNT_RESET_LSCH1() uint32 {
	return (volatile.LoadUint32(&o.LSCH1_CONF0.Reg) & 0x10000) >> 16
}

// LEDC.LSCH1_HPOINT: LEDC_LSCH1_HPOINT.
func (o *LEDC_Type) SetLSCH1_HPOINT_HPOINT_LSCH1(value uint32) {
	volatile.StoreUint32(&o.LSCH1_HPOINT.Reg, volatile.LoadUint32(&o.LSCH1_HPOINT.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetLSCH1_HPOINT_HPOINT_LSCH1() uint32 {
	return volatile.LoadUint32(&o.LSCH1_HPOINT.Reg) & 0x3fff
}

// LEDC.LSCH1_DUTY: LEDC_LSCH1_DUTY.
func (o *LEDC_Type) SetLSCH1_DUTY_DUTY_LSCH1(value uint32) {
	volatile.StoreUint32(&o.LSCH1_DUTY.Reg, volatile.LoadUint32(&o.LSCH1_DUTY.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetLSCH1_DUTY_DUTY_LSCH1() uint32 {
	return volatile.LoadUint32(&o.LSCH1_DUTY.Reg) & 0x7ffff
}

// LEDC.LSCH1_CONF1: LEDC_LSCH1_CONF1.
func (o *LEDC_Type) SetLSCH1_CONF1_DUTY_SCALE_LSCH1(value uint32) {
	volatile.StoreUint32(&o.LSCH1_CONF1.Reg, volatile.LoadUint32(&o.LSCH1_CONF1.Reg)&^(0x3ff)|value)
}
func (o *LEDC_Type) GetLSCH1_CONF1_DUTY_SCALE_LSCH1() uint32 {
	return volatile.LoadUint32(&o.LSCH1_CONF1.Reg) & 0x3ff
}
func (o *LEDC_Type) SetLSCH1_CONF1_DUTY_CYCLE_LSCH1(value uint32) {
	volatile.StoreUint32(&o.LSCH1_CONF1.Reg, volatile.LoadUint32(&o.LSCH1_CONF1.Reg)&^(0xffc00)|value<<10)
}
func (o *LEDC_Type) GetLSCH1_CONF1_DUTY_CYCLE_LSCH1() uint32 {
	return (volatile.LoadUint32(&o.LSCH1_CONF1.Reg) & 0xffc00) >> 10
}
func (o *LEDC_Type) SetLSCH1_CONF1_DUTY_NUM_LSCH1(value uint32) {
	volatile.StoreUint32(&o.LSCH1_CONF1.Reg, volatile.LoadUint32(&o.LSCH1_CONF1.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LEDC_Type) GetLSCH1_CONF1_DUTY_NUM_LSCH1() uint32 {
	return (volatile.LoadUint32(&o.LSCH1_CONF1.Reg) & 0x3ff00000) >> 20
}
func (o *LEDC_Type) SetLSCH1_CONF1_DUTY_INC_LSCH1(value uint32) {
	volatile.StoreUint32(&o.LSCH1_CONF1.Reg, volatile.LoadUint32(&o.LSCH1_CONF1.Reg)&^(0x40000000)|value<<30)
}
func (o *LEDC_Type) GetLSCH1_CONF1_DUTY_INC_LSCH1() uint32 {
	return (volatile.LoadUint32(&o.LSCH1_CONF1.Reg) & 0x40000000) >> 30
}
func (o *LEDC_Type) SetLSCH1_CONF1_DUTY_START_LSCH1(value uint32) {
	volatile.StoreUint32(&o.LSCH1_CONF1.Reg, volatile.LoadUint32(&o.LSCH1_CONF1.Reg)&^(0x80000000)|value<<31)
}
func (o *LEDC_Type) GetLSCH1_CONF1_DUTY_START_LSCH1() uint32 {
	return (volatile.LoadUint32(&o.LSCH1_CONF1.Reg) & 0x80000000) >> 31
}

// LEDC.LSCH1_DUTY_R: LEDC_LSCH1_DUTY_R.
func (o *LEDC_Type) SetLSCH1_DUTY_R_DUTY_LSCH1_R(value uint32) {
	volatile.StoreUint32(&o.LSCH1_DUTY_R.Reg, volatile.LoadUint32(&o.LSCH1_DUTY_R.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetLSCH1_DUTY_R_DUTY_LSCH1_R() uint32 {
	return volatile.LoadUint32(&o.LSCH1_DUTY_R.Reg) & 0x7ffff
}

// LEDC.LSCH2_CONF0: LEDC_LSCH2_CONF0.
func (o *LEDC_Type) SetLSCH2_CONF0_TIMER_SEL_LSCH2(value uint32) {
	volatile.StoreUint32(&o.LSCH2_CONF0.Reg, volatile.LoadUint32(&o.LSCH2_CONF0.Reg)&^(0x3)|value)
}
func (o *LEDC_Type) GetLSCH2_CONF0_TIMER_SEL_LSCH2() uint32 {
	return volatile.LoadUint32(&o.LSCH2_CONF0.Reg) & 0x3
}
func (o *LEDC_Type) SetLSCH2_CONF0_SIG_OUT_EN_LSCH2(value uint32) {
	volatile.StoreUint32(&o.LSCH2_CONF0.Reg, volatile.LoadUint32(&o.LSCH2_CONF0.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetLSCH2_CONF0_SIG_OUT_EN_LSCH2() uint32 {
	return (volatile.LoadUint32(&o.LSCH2_CONF0.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetLSCH2_CONF0_IDLE_LV_LSCH2(value uint32) {
	volatile.StoreUint32(&o.LSCH2_CONF0.Reg, volatile.LoadUint32(&o.LSCH2_CONF0.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetLSCH2_CONF0_IDLE_LV_LSCH2() uint32 {
	return (volatile.LoadUint32(&o.LSCH2_CONF0.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetLSCH2_CONF0_PARA_UP_LSCH2(value uint32) {
	volatile.StoreUint32(&o.LSCH2_CONF0.Reg, volatile.LoadUint32(&o.LSCH2_CONF0.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetLSCH2_CONF0_PARA_UP_LSCH2() uint32 {
	return (volatile.LoadUint32(&o.LSCH2_CONF0.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetLSCH2_CONF0_OVF_NUM_LSCH2(value uint32) {
	volatile.StoreUint32(&o.LSCH2_CONF0.Reg, volatile.LoadUint32(&o.LSCH2_CONF0.Reg)&^(0x7fe0)|value<<5)
}
func (o *LEDC_Type) GetLSCH2_CONF0_OVF_NUM_LSCH2() uint32 {
	return (volatile.LoadUint32(&o.LSCH2_CONF0.Reg) & 0x7fe0) >> 5
}
func (o *LEDC_Type) SetLSCH2_CONF0_OVF_CNT_EN_LSCH2(value uint32) {
	volatile.StoreUint32(&o.LSCH2_CONF0.Reg, volatile.LoadUint32(&o.LSCH2_CONF0.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetLSCH2_CONF0_OVF_CNT_EN_LSCH2() uint32 {
	return (volatile.LoadUint32(&o.LSCH2_CONF0.Reg) & 0x8000) >> 15
}
func (o *LEDC_Type) SetLSCH2_CONF0_OVF_CNT_RESET_LSCH2(value uint32) {
	volatile.StoreUint32(&o.LSCH2_CONF0.Reg, volatile.LoadUint32(&o.LSCH2_CONF0.Reg)&^(0x10000)|value<<16)
}
func (o *LEDC_Type) GetLSCH2_CONF0_OVF_CNT_RESET_LSCH2() uint32 {
	return (volatile.LoadUint32(&o.LSCH2_CONF0.Reg) & 0x10000) >> 16
}

// LEDC.LSCH2_HPOINT: LEDC_LSCH2_HPOINT.
func (o *LEDC_Type) SetLSCH2_HPOINT_HPOINT_LSCH2(value uint32) {
	volatile.StoreUint32(&o.LSCH2_HPOINT.Reg, volatile.LoadUint32(&o.LSCH2_HPOINT.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetLSCH2_HPOINT_HPOINT_LSCH2() uint32 {
	return volatile.LoadUint32(&o.LSCH2_HPOINT.Reg) & 0x3fff
}

// LEDC.LSCH2_DUTY: LEDC_LSCH2_DUTY.
func (o *LEDC_Type) SetLSCH2_DUTY_DUTY_LSCH2(value uint32) {
	volatile.StoreUint32(&o.LSCH2_DUTY.Reg, volatile.LoadUint32(&o.LSCH2_DUTY.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetLSCH2_DUTY_DUTY_LSCH2() uint32 {
	return volatile.LoadUint32(&o.LSCH2_DUTY.Reg) & 0x7ffff
}

// LEDC.LSCH2_CONF1: LEDC_LSCH2_CONF1.
func (o *LEDC_Type) SetLSCH2_CONF1_DUTY_SCALE_LSCH2(value uint32) {
	volatile.StoreUint32(&o.LSCH2_CONF1.Reg, volatile.LoadUint32(&o.LSCH2_CONF1.Reg)&^(0x3ff)|value)
}
func (o *LEDC_Type) GetLSCH2_CONF1_DUTY_SCALE_LSCH2() uint32 {
	return volatile.LoadUint32(&o.LSCH2_CONF1.Reg) & 0x3ff
}
func (o *LEDC_Type) SetLSCH2_CONF1_DUTY_CYCLE_LSCH2(value uint32) {
	volatile.StoreUint32(&o.LSCH2_CONF1.Reg, volatile.LoadUint32(&o.LSCH2_CONF1.Reg)&^(0xffc00)|value<<10)
}
func (o *LEDC_Type) GetLSCH2_CONF1_DUTY_CYCLE_LSCH2() uint32 {
	return (volatile.LoadUint32(&o.LSCH2_CONF1.Reg) & 0xffc00) >> 10
}
func (o *LEDC_Type) SetLSCH2_CONF1_DUTY_NUM_LSCH2(value uint32) {
	volatile.StoreUint32(&o.LSCH2_CONF1.Reg, volatile.LoadUint32(&o.LSCH2_CONF1.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LEDC_Type) GetLSCH2_CONF1_DUTY_NUM_LSCH2() uint32 {
	return (volatile.LoadUint32(&o.LSCH2_CONF1.Reg) & 0x3ff00000) >> 20
}
func (o *LEDC_Type) SetLSCH2_CONF1_DUTY_INC_LSCH2(value uint32) {
	volatile.StoreUint32(&o.LSCH2_CONF1.Reg, volatile.LoadUint32(&o.LSCH2_CONF1.Reg)&^(0x40000000)|value<<30)
}
func (o *LEDC_Type) GetLSCH2_CONF1_DUTY_INC_LSCH2() uint32 {
	return (volatile.LoadUint32(&o.LSCH2_CONF1.Reg) & 0x40000000) >> 30
}
func (o *LEDC_Type) SetLSCH2_CONF1_DUTY_START_LSCH2(value uint32) {
	volatile.StoreUint32(&o.LSCH2_CONF1.Reg, volatile.LoadUint32(&o.LSCH2_CONF1.Reg)&^(0x80000000)|value<<31)
}
func (o *LEDC_Type) GetLSCH2_CONF1_DUTY_START_LSCH2() uint32 {
	return (volatile.LoadUint32(&o.LSCH2_CONF1.Reg) & 0x80000000) >> 31
}

// LEDC.LSCH2_DUTY_R: LEDC_LSCH2_DUTY_R.
func (o *LEDC_Type) SetLSCH2_DUTY_R_DUTY_LSCH2_R(value uint32) {
	volatile.StoreUint32(&o.LSCH2_DUTY_R.Reg, volatile.LoadUint32(&o.LSCH2_DUTY_R.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetLSCH2_DUTY_R_DUTY_LSCH2_R() uint32 {
	return volatile.LoadUint32(&o.LSCH2_DUTY_R.Reg) & 0x7ffff
}

// LEDC.LSCH3_CONF0: LEDC_LSCH3_CONF0.
func (o *LEDC_Type) SetLSCH3_CONF0_TIMER_SEL_LSCH3(value uint32) {
	volatile.StoreUint32(&o.LSCH3_CONF0.Reg, volatile.LoadUint32(&o.LSCH3_CONF0.Reg)&^(0x3)|value)
}
func (o *LEDC_Type) GetLSCH3_CONF0_TIMER_SEL_LSCH3() uint32 {
	return volatile.LoadUint32(&o.LSCH3_CONF0.Reg) & 0x3
}
func (o *LEDC_Type) SetLSCH3_CONF0_SIG_OUT_EN_LSCH3(value uint32) {
	volatile.StoreUint32(&o.LSCH3_CONF0.Reg, volatile.LoadUint32(&o.LSCH3_CONF0.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetLSCH3_CONF0_SIG_OUT_EN_LSCH3() uint32 {
	return (volatile.LoadUint32(&o.LSCH3_CONF0.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetLSCH3_CONF0_IDLE_LV_LSCH3(value uint32) {
	volatile.StoreUint32(&o.LSCH3_CONF0.Reg, volatile.LoadUint32(&o.LSCH3_CONF0.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetLSCH3_CONF0_IDLE_LV_LSCH3() uint32 {
	return (volatile.LoadUint32(&o.LSCH3_CONF0.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetLSCH3_CONF0_PARA_UP_LSCH3(value uint32) {
	volatile.StoreUint32(&o.LSCH3_CONF0.Reg, volatile.LoadUint32(&o.LSCH3_CONF0.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetLSCH3_CONF0_PARA_UP_LSCH3() uint32 {
	return (volatile.LoadUint32(&o.LSCH3_CONF0.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetLSCH3_CONF0_OVF_NUM_LSCH3(value uint32) {
	volatile.StoreUint32(&o.LSCH3_CONF0.Reg, volatile.LoadUint32(&o.LSCH3_CONF0.Reg)&^(0x7fe0)|value<<5)
}
func (o *LEDC_Type) GetLSCH3_CONF0_OVF_NUM_LSCH3() uint32 {
	return (volatile.LoadUint32(&o.LSCH3_CONF0.Reg) & 0x7fe0) >> 5
}
func (o *LEDC_Type) SetLSCH3_CONF0_OVF_CNT_EN_LSCH3(value uint32) {
	volatile.StoreUint32(&o.LSCH3_CONF0.Reg, volatile.LoadUint32(&o.LSCH3_CONF0.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetLSCH3_CONF0_OVF_CNT_EN_LSCH3() uint32 {
	return (volatile.LoadUint32(&o.LSCH3_CONF0.Reg) & 0x8000) >> 15
}
func (o *LEDC_Type) SetLSCH3_CONF0_OVF_CNT_RESET_LSCH3(value uint32) {
	volatile.StoreUint32(&o.LSCH3_CONF0.Reg, volatile.LoadUint32(&o.LSCH3_CONF0.Reg)&^(0x10000)|value<<16)
}
func (o *LEDC_Type) GetLSCH3_CONF0_OVF_CNT_RESET_LSCH3() uint32 {
	return (volatile.LoadUint32(&o.LSCH3_CONF0.Reg) & 0x10000) >> 16
}

// LEDC.LSCH3_HPOINT: LEDC_LSCH3_HPOINT.
func (o *LEDC_Type) SetLSCH3_HPOINT_HPOINT_LSCH3(value uint32) {
	volatile.StoreUint32(&o.LSCH3_HPOINT.Reg, volatile.LoadUint32(&o.LSCH3_HPOINT.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetLSCH3_HPOINT_HPOINT_LSCH3() uint32 {
	return volatile.LoadUint32(&o.LSCH3_HPOINT.Reg) & 0x3fff
}

// LEDC.LSCH3_DUTY: LEDC_LSCH3_DUTY.
func (o *LEDC_Type) SetLSCH3_DUTY_DUTY_LSCH3(value uint32) {
	volatile.StoreUint32(&o.LSCH3_DUTY.Reg, volatile.LoadUint32(&o.LSCH3_DUTY.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetLSCH3_DUTY_DUTY_LSCH3() uint32 {
	return volatile.LoadUint32(&o.LSCH3_DUTY.Reg) & 0x7ffff
}

// LEDC.LSCH3_CONF1: LEDC_LSCH3_CONF1.
func (o *LEDC_Type) SetLSCH3_CONF1_DUTY_SCALE_LSCH3(value uint32) {
	volatile.StoreUint32(&o.LSCH3_CONF1.Reg, volatile.LoadUint32(&o.LSCH3_CONF1.Reg)&^(0x3ff)|value)
}
func (o *LEDC_Type) GetLSCH3_CONF1_DUTY_SCALE_LSCH3() uint32 {
	return volatile.LoadUint32(&o.LSCH3_CONF1.Reg) & 0x3ff
}
func (o *LEDC_Type) SetLSCH3_CONF1_DUTY_CYCLE_LSCH3(value uint32) {
	volatile.StoreUint32(&o.LSCH3_CONF1.Reg, volatile.LoadUint32(&o.LSCH3_CONF1.Reg)&^(0xffc00)|value<<10)
}
func (o *LEDC_Type) GetLSCH3_CONF1_DUTY_CYCLE_LSCH3() uint32 {
	return (volatile.LoadUint32(&o.LSCH3_CONF1.Reg) & 0xffc00) >> 10
}
func (o *LEDC_Type) SetLSCH3_CONF1_DUTY_NUM_LSCH3(value uint32) {
	volatile.StoreUint32(&o.LSCH3_CONF1.Reg, volatile.LoadUint32(&o.LSCH3_CONF1.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LEDC_Type) GetLSCH3_CONF1_DUTY_NUM_LSCH3() uint32 {
	return (volatile.LoadUint32(&o.LSCH3_CONF1.Reg) & 0x3ff00000) >> 20
}
func (o *LEDC_Type) SetLSCH3_CONF1_DUTY_INC_LSCH3(value uint32) {
	volatile.StoreUint32(&o.LSCH3_CONF1.Reg, volatile.LoadUint32(&o.LSCH3_CONF1.Reg)&^(0x40000000)|value<<30)
}
func (o *LEDC_Type) GetLSCH3_CONF1_DUTY_INC_LSCH3() uint32 {
	return (volatile.LoadUint32(&o.LSCH3_CONF1.Reg) & 0x40000000) >> 30
}
func (o *LEDC_Type) SetLSCH3_CONF1_DUTY_START_LSCH3(value uint32) {
	volatile.StoreUint32(&o.LSCH3_CONF1.Reg, volatile.LoadUint32(&o.LSCH3_CONF1.Reg)&^(0x80000000)|value<<31)
}
func (o *LEDC_Type) GetLSCH3_CONF1_DUTY_START_LSCH3() uint32 {
	return (volatile.LoadUint32(&o.LSCH3_CONF1.Reg) & 0x80000000) >> 31
}

// LEDC.LSCH3_DUTY_R: LEDC_LSCH3_DUTY_R.
func (o *LEDC_Type) SetLSCH3_DUTY_R_DUTY_LSCH3_R(value uint32) {
	volatile.StoreUint32(&o.LSCH3_DUTY_R.Reg, volatile.LoadUint32(&o.LSCH3_DUTY_R.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetLSCH3_DUTY_R_DUTY_LSCH3_R() uint32 {
	return volatile.LoadUint32(&o.LSCH3_DUTY_R.Reg) & 0x7ffff
}

// LEDC.LSCH4_CONF0: LEDC_LSCH4_CONF0.
func (o *LEDC_Type) SetLSCH4_CONF0_TIMER_SEL_LSCH4(value uint32) {
	volatile.StoreUint32(&o.LSCH4_CONF0.Reg, volatile.LoadUint32(&o.LSCH4_CONF0.Reg)&^(0x3)|value)
}
func (o *LEDC_Type) GetLSCH4_CONF0_TIMER_SEL_LSCH4() uint32 {
	return volatile.LoadUint32(&o.LSCH4_CONF0.Reg) & 0x3
}
func (o *LEDC_Type) SetLSCH4_CONF0_SIG_OUT_EN_LSCH4(value uint32) {
	volatile.StoreUint32(&o.LSCH4_CONF0.Reg, volatile.LoadUint32(&o.LSCH4_CONF0.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetLSCH4_CONF0_SIG_OUT_EN_LSCH4() uint32 {
	return (volatile.LoadUint32(&o.LSCH4_CONF0.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetLSCH4_CONF0_IDLE_LV_LSCH4(value uint32) {
	volatile.StoreUint32(&o.LSCH4_CONF0.Reg, volatile.LoadUint32(&o.LSCH4_CONF0.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetLSCH4_CONF0_IDLE_LV_LSCH4() uint32 {
	return (volatile.LoadUint32(&o.LSCH4_CONF0.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetLSCH4_CONF0_PARA_UP_LSCH4(value uint32) {
	volatile.StoreUint32(&o.LSCH4_CONF0.Reg, volatile.LoadUint32(&o.LSCH4_CONF0.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetLSCH4_CONF0_PARA_UP_LSCH4() uint32 {
	return (volatile.LoadUint32(&o.LSCH4_CONF0.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetLSCH4_CONF0_OVF_NUM_LSCH4(value uint32) {
	volatile.StoreUint32(&o.LSCH4_CONF0.Reg, volatile.LoadUint32(&o.LSCH4_CONF0.Reg)&^(0x7fe0)|value<<5)
}
func (o *LEDC_Type) GetLSCH4_CONF0_OVF_NUM_LSCH4() uint32 {
	return (volatile.LoadUint32(&o.LSCH4_CONF0.Reg) & 0x7fe0) >> 5
}
func (o *LEDC_Type) SetLSCH4_CONF0_OVF_CNT_EN_LSCH4(value uint32) {
	volatile.StoreUint32(&o.LSCH4_CONF0.Reg, volatile.LoadUint32(&o.LSCH4_CONF0.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetLSCH4_CONF0_OVF_CNT_EN_LSCH4() uint32 {
	return (volatile.LoadUint32(&o.LSCH4_CONF0.Reg) & 0x8000) >> 15
}
func (o *LEDC_Type) SetLSCH4_CONF0_OVF_CNT_RESET_LSCH4(value uint32) {
	volatile.StoreUint32(&o.LSCH4_CONF0.Reg, volatile.LoadUint32(&o.LSCH4_CONF0.Reg)&^(0x10000)|value<<16)
}
func (o *LEDC_Type) GetLSCH4_CONF0_OVF_CNT_RESET_LSCH4() uint32 {
	return (volatile.LoadUint32(&o.LSCH4_CONF0.Reg) & 0x10000) >> 16
}

// LEDC.LSCH4_HPOINT: LEDC_LSCH4_HPOINT.
func (o *LEDC_Type) SetLSCH4_HPOINT_HPOINT_LSCH4(value uint32) {
	volatile.StoreUint32(&o.LSCH4_HPOINT.Reg, volatile.LoadUint32(&o.LSCH4_HPOINT.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetLSCH4_HPOINT_HPOINT_LSCH4() uint32 {
	return volatile.LoadUint32(&o.LSCH4_HPOINT.Reg) & 0x3fff
}

// LEDC.LSCH4_DUTY: LEDC_LSCH4_DUTY.
func (o *LEDC_Type) SetLSCH4_DUTY_DUTY_LSCH4(value uint32) {
	volatile.StoreUint32(&o.LSCH4_DUTY.Reg, volatile.LoadUint32(&o.LSCH4_DUTY.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetLSCH4_DUTY_DUTY_LSCH4() uint32 {
	return volatile.LoadUint32(&o.LSCH4_DUTY.Reg) & 0x7ffff
}

// LEDC.LSCH4_CONF1: LEDC_LSCH4_CONF1.
func (o *LEDC_Type) SetLSCH4_CONF1_DUTY_SCALE_LSCH4(value uint32) {
	volatile.StoreUint32(&o.LSCH4_CONF1.Reg, volatile.LoadUint32(&o.LSCH4_CONF1.Reg)&^(0x3ff)|value)
}
func (o *LEDC_Type) GetLSCH4_CONF1_DUTY_SCALE_LSCH4() uint32 {
	return volatile.LoadUint32(&o.LSCH4_CONF1.Reg) & 0x3ff
}
func (o *LEDC_Type) SetLSCH4_CONF1_DUTY_CYCLE_LSCH4(value uint32) {
	volatile.StoreUint32(&o.LSCH4_CONF1.Reg, volatile.LoadUint32(&o.LSCH4_CONF1.Reg)&^(0xffc00)|value<<10)
}
func (o *LEDC_Type) GetLSCH4_CONF1_DUTY_CYCLE_LSCH4() uint32 {
	return (volatile.LoadUint32(&o.LSCH4_CONF1.Reg) & 0xffc00) >> 10
}
func (o *LEDC_Type) SetLSCH4_CONF1_DUTY_NUM_LSCH4(value uint32) {
	volatile.StoreUint32(&o.LSCH4_CONF1.Reg, volatile.LoadUint32(&o.LSCH4_CONF1.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LEDC_Type) GetLSCH4_CONF1_DUTY_NUM_LSCH4() uint32 {
	return (volatile.LoadUint32(&o.LSCH4_CONF1.Reg) & 0x3ff00000) >> 20
}
func (o *LEDC_Type) SetLSCH4_CONF1_DUTY_INC_LSCH4(value uint32) {
	volatile.StoreUint32(&o.LSCH4_CONF1.Reg, volatile.LoadUint32(&o.LSCH4_CONF1.Reg)&^(0x40000000)|value<<30)
}
func (o *LEDC_Type) GetLSCH4_CONF1_DUTY_INC_LSCH4() uint32 {
	return (volatile.LoadUint32(&o.LSCH4_CONF1.Reg) & 0x40000000) >> 30
}
func (o *LEDC_Type) SetLSCH4_CONF1_DUTY_START_LSCH4(value uint32) {
	volatile.StoreUint32(&o.LSCH4_CONF1.Reg, volatile.LoadUint32(&o.LSCH4_CONF1.Reg)&^(0x80000000)|value<<31)
}
func (o *LEDC_Type) GetLSCH4_CONF1_DUTY_START_LSCH4() uint32 {
	return (volatile.LoadUint32(&o.LSCH4_CONF1.Reg) & 0x80000000) >> 31
}

// LEDC.LSCH4_DUTY_R: LEDC_LSCH4_DUTY_R.
func (o *LEDC_Type) SetLSCH4_DUTY_R_DUTY_LSCH4_R(value uint32) {
	volatile.StoreUint32(&o.LSCH4_DUTY_R.Reg, volatile.LoadUint32(&o.LSCH4_DUTY_R.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetLSCH4_DUTY_R_DUTY_LSCH4_R() uint32 {
	return volatile.LoadUint32(&o.LSCH4_DUTY_R.Reg) & 0x7ffff
}

// LEDC.LSCH5_CONF0: LEDC_LSCH5_CONF0.
func (o *LEDC_Type) SetLSCH5_CONF0_TIMER_SEL_LSCH5(value uint32) {
	volatile.StoreUint32(&o.LSCH5_CONF0.Reg, volatile.LoadUint32(&o.LSCH5_CONF0.Reg)&^(0x3)|value)
}
func (o *LEDC_Type) GetLSCH5_CONF0_TIMER_SEL_LSCH5() uint32 {
	return volatile.LoadUint32(&o.LSCH5_CONF0.Reg) & 0x3
}
func (o *LEDC_Type) SetLSCH5_CONF0_SIG_OUT_EN_LSCH5(value uint32) {
	volatile.StoreUint32(&o.LSCH5_CONF0.Reg, volatile.LoadUint32(&o.LSCH5_CONF0.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetLSCH5_CONF0_SIG_OUT_EN_LSCH5() uint32 {
	return (volatile.LoadUint32(&o.LSCH5_CONF0.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetLSCH5_CONF0_IDLE_LV_LSCH5(value uint32) {
	volatile.StoreUint32(&o.LSCH5_CONF0.Reg, volatile.LoadUint32(&o.LSCH5_CONF0.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetLSCH5_CONF0_IDLE_LV_LSCH5() uint32 {
	return (volatile.LoadUint32(&o.LSCH5_CONF0.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetLSCH5_CONF0_PARA_UP_LSCH5(value uint32) {
	volatile.StoreUint32(&o.LSCH5_CONF0.Reg, volatile.LoadUint32(&o.LSCH5_CONF0.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetLSCH5_CONF0_PARA_UP_LSCH5() uint32 {
	return (volatile.LoadUint32(&o.LSCH5_CONF0.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetLSCH5_CONF0_OVF_NUM_LSCH5(value uint32) {
	volatile.StoreUint32(&o.LSCH5_CONF0.Reg, volatile.LoadUint32(&o.LSCH5_CONF0.Reg)&^(0x7fe0)|value<<5)
}
func (o *LEDC_Type) GetLSCH5_CONF0_OVF_NUM_LSCH5() uint32 {
	return (volatile.LoadUint32(&o.LSCH5_CONF0.Reg) & 0x7fe0) >> 5
}
func (o *LEDC_Type) SetLSCH5_CONF0_OVF_CNT_EN_LSCH5(value uint32) {
	volatile.StoreUint32(&o.LSCH5_CONF0.Reg, volatile.LoadUint32(&o.LSCH5_CONF0.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetLSCH5_CONF0_OVF_CNT_EN_LSCH5() uint32 {
	return (volatile.LoadUint32(&o.LSCH5_CONF0.Reg) & 0x8000) >> 15
}
func (o *LEDC_Type) SetLSCH5_CONF0_OVF_CNT_RESET_LSCH5(value uint32) {
	volatile.StoreUint32(&o.LSCH5_CONF0.Reg, volatile.LoadUint32(&o.LSCH5_CONF0.Reg)&^(0x10000)|value<<16)
}
func (o *LEDC_Type) GetLSCH5_CONF0_OVF_CNT_RESET_LSCH5() uint32 {
	return (volatile.LoadUint32(&o.LSCH5_CONF0.Reg) & 0x10000) >> 16
}

// LEDC.LSCH5_HPOINT: LEDC_LSCH5_HPOINT.
func (o *LEDC_Type) SetLSCH5_HPOINT_HPOINT_LSCH5(value uint32) {
	volatile.StoreUint32(&o.LSCH5_HPOINT.Reg, volatile.LoadUint32(&o.LSCH5_HPOINT.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetLSCH5_HPOINT_HPOINT_LSCH5() uint32 {
	return volatile.LoadUint32(&o.LSCH5_HPOINT.Reg) & 0x3fff
}

// LEDC.LSCH5_DUTY: LEDC_LSCH5_DUTY.
func (o *LEDC_Type) SetLSCH5_DUTY_DUTY_LSCH5(value uint32) {
	volatile.StoreUint32(&o.LSCH5_DUTY.Reg, volatile.LoadUint32(&o.LSCH5_DUTY.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetLSCH5_DUTY_DUTY_LSCH5() uint32 {
	return volatile.LoadUint32(&o.LSCH5_DUTY.Reg) & 0x7ffff
}

// LEDC.LSCH5_CONF1: LEDC_LSCH5_CONF1.
func (o *LEDC_Type) SetLSCH5_CONF1_DUTY_SCALE_LSCH5(value uint32) {
	volatile.StoreUint32(&o.LSCH5_CONF1.Reg, volatile.LoadUint32(&o.LSCH5_CONF1.Reg)&^(0x3ff)|value)
}
func (o *LEDC_Type) GetLSCH5_CONF1_DUTY_SCALE_LSCH5() uint32 {
	return volatile.LoadUint32(&o.LSCH5_CONF1.Reg) & 0x3ff
}
func (o *LEDC_Type) SetLSCH5_CONF1_DUTY_CYCLE_LSCH5(value uint32) {
	volatile.StoreUint32(&o.LSCH5_CONF1.Reg, volatile.LoadUint32(&o.LSCH5_CONF1.Reg)&^(0xffc00)|value<<10)
}
func (o *LEDC_Type) GetLSCH5_CONF1_DUTY_CYCLE_LSCH5() uint32 {
	return (volatile.LoadUint32(&o.LSCH5_CONF1.Reg) & 0xffc00) >> 10
}
func (o *LEDC_Type) SetLSCH5_CONF1_DUTY_NUM_LSCH5(value uint32) {
	volatile.StoreUint32(&o.LSCH5_CONF1.Reg, volatile.LoadUint32(&o.LSCH5_CONF1.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LEDC_Type) GetLSCH5_CONF1_DUTY_NUM_LSCH5() uint32 {
	return (volatile.LoadUint32(&o.LSCH5_CONF1.Reg) & 0x3ff00000) >> 20
}
func (o *LEDC_Type) SetLSCH5_CONF1_DUTY_INC_LSCH5(value uint32) {
	volatile.StoreUint32(&o.LSCH5_CONF1.Reg, volatile.LoadUint32(&o.LSCH5_CONF1.Reg)&^(0x40000000)|value<<30)
}
func (o *LEDC_Type) GetLSCH5_CONF1_DUTY_INC_LSCH5() uint32 {
	return (volatile.LoadUint32(&o.LSCH5_CONF1.Reg) & 0x40000000) >> 30
}
func (o *LEDC_Type) SetLSCH5_CONF1_DUTY_START_LSCH5(value uint32) {
	volatile.StoreUint32(&o.LSCH5_CONF1.Reg, volatile.LoadUint32(&o.LSCH5_CONF1.Reg)&^(0x80000000)|value<<31)
}
func (o *LEDC_Type) GetLSCH5_CONF1_DUTY_START_LSCH5() uint32 {
	return (volatile.LoadUint32(&o.LSCH5_CONF1.Reg) & 0x80000000) >> 31
}

// LEDC.LSCH5_DUTY_R: LEDC_LSCH5_DUTY_R.
func (o *LEDC_Type) SetLSCH5_DUTY_R_DUTY_LSCH5_R(value uint32) {
	volatile.StoreUint32(&o.LSCH5_DUTY_R.Reg, volatile.LoadUint32(&o.LSCH5_DUTY_R.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetLSCH5_DUTY_R_DUTY_LSCH5_R() uint32 {
	return volatile.LoadUint32(&o.LSCH5_DUTY_R.Reg) & 0x7ffff
}

// LEDC.LSTIMER0_CONF: LEDC_LSTIMER0_CONF.
func (o *LEDC_Type) SetLSTIMER0_CONF_LSTIMER0_DUTY_RES(value uint32) {
	volatile.StoreUint32(&o.LSTIMER0_CONF.Reg, volatile.LoadUint32(&o.LSTIMER0_CONF.Reg)&^(0xf)|value)
}
func (o *LEDC_Type) GetLSTIMER0_CONF_LSTIMER0_DUTY_RES() uint32 {
	return volatile.LoadUint32(&o.LSTIMER0_CONF.Reg) & 0xf
}
func (o *LEDC_Type) SetLSTIMER0_CONF_CLK_DIV_LSTIMER0(value uint32) {
	volatile.StoreUint32(&o.LSTIMER0_CONF.Reg, volatile.LoadUint32(&o.LSTIMER0_CONF.Reg)&^(0x3ffff0)|value<<4)
}
func (o *LEDC_Type) GetLSTIMER0_CONF_CLK_DIV_LSTIMER0() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER0_CONF.Reg) & 0x3ffff0) >> 4
}
func (o *LEDC_Type) SetLSTIMER0_CONF_LSTIMER0_PAUSE(value uint32) {
	volatile.StoreUint32(&o.LSTIMER0_CONF.Reg, volatile.LoadUint32(&o.LSTIMER0_CONF.Reg)&^(0x400000)|value<<22)
}
func (o *LEDC_Type) GetLSTIMER0_CONF_LSTIMER0_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER0_CONF.Reg) & 0x400000) >> 22
}
func (o *LEDC_Type) SetLSTIMER0_CONF_LSTIMER0_RST(value uint32) {
	volatile.StoreUint32(&o.LSTIMER0_CONF.Reg, volatile.LoadUint32(&o.LSTIMER0_CONF.Reg)&^(0x800000)|value<<23)
}
func (o *LEDC_Type) GetLSTIMER0_CONF_LSTIMER0_RST() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER0_CONF.Reg) & 0x800000) >> 23
}
func (o *LEDC_Type) SetLSTIMER0_CONF_TICK_SEL_LSTIMER0(value uint32) {
	volatile.StoreUint32(&o.LSTIMER0_CONF.Reg, volatile.LoadUint32(&o.LSTIMER0_CONF.Reg)&^(0x1000000)|value<<24)
}
func (o *LEDC_Type) GetLSTIMER0_CONF_TICK_SEL_LSTIMER0() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER0_CONF.Reg) & 0x1000000) >> 24
}
func (o *LEDC_Type) SetLSTIMER0_CONF_LSTIMER0_PARA_UP(value uint32) {
	volatile.StoreUint32(&o.LSTIMER0_CONF.Reg, volatile.LoadUint32(&o.LSTIMER0_CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *LEDC_Type) GetLSTIMER0_CONF_LSTIMER0_PARA_UP() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER0_CONF.Reg) & 0x2000000) >> 25
}

// LEDC.LSTIMER0_VALUE: LEDC_LSTIMER0_VALUE.
func (o *LEDC_Type) SetLSTIMER0_VALUE_LSTIMER0_CNT(value uint32) {
	volatile.StoreUint32(&o.LSTIMER0_VALUE.Reg, volatile.LoadUint32(&o.LSTIMER0_VALUE.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetLSTIMER0_VALUE_LSTIMER0_CNT() uint32 {
	return volatile.LoadUint32(&o.LSTIMER0_VALUE.Reg) & 0x3fff
}

// LEDC.LSTIMER1_CONF: LEDC_LSTIMER1_CONF.
func (o *LEDC_Type) SetLSTIMER1_CONF_LSTIMER1_DUTY_RES(value uint32) {
	volatile.StoreUint32(&o.LSTIMER1_CONF.Reg, volatile.LoadUint32(&o.LSTIMER1_CONF.Reg)&^(0xf)|value)
}
func (o *LEDC_Type) GetLSTIMER1_CONF_LSTIMER1_DUTY_RES() uint32 {
	return volatile.LoadUint32(&o.LSTIMER1_CONF.Reg) & 0xf
}
func (o *LEDC_Type) SetLSTIMER1_CONF_CLK_DIV_LSTIMER1(value uint32) {
	volatile.StoreUint32(&o.LSTIMER1_CONF.Reg, volatile.LoadUint32(&o.LSTIMER1_CONF.Reg)&^(0x3ffff0)|value<<4)
}
func (o *LEDC_Type) GetLSTIMER1_CONF_CLK_DIV_LSTIMER1() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER1_CONF.Reg) & 0x3ffff0) >> 4
}
func (o *LEDC_Type) SetLSTIMER1_CONF_LSTIMER1_PAUSE(value uint32) {
	volatile.StoreUint32(&o.LSTIMER1_CONF.Reg, volatile.LoadUint32(&o.LSTIMER1_CONF.Reg)&^(0x400000)|value<<22)
}
func (o *LEDC_Type) GetLSTIMER1_CONF_LSTIMER1_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER1_CONF.Reg) & 0x400000) >> 22
}
func (o *LEDC_Type) SetLSTIMER1_CONF_LSTIMER1_RST(value uint32) {
	volatile.StoreUint32(&o.LSTIMER1_CONF.Reg, volatile.LoadUint32(&o.LSTIMER1_CONF.Reg)&^(0x800000)|value<<23)
}
func (o *LEDC_Type) GetLSTIMER1_CONF_LSTIMER1_RST() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER1_CONF.Reg) & 0x800000) >> 23
}
func (o *LEDC_Type) SetLSTIMER1_CONF_TICK_SEL_LSTIMER1(value uint32) {
	volatile.StoreUint32(&o.LSTIMER1_CONF.Reg, volatile.LoadUint32(&o.LSTIMER1_CONF.Reg)&^(0x1000000)|value<<24)
}
func (o *LEDC_Type) GetLSTIMER1_CONF_TICK_SEL_LSTIMER1() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER1_CONF.Reg) & 0x1000000) >> 24
}
func (o *LEDC_Type) SetLSTIMER1_CONF_LSTIMER1_PARA_UP(value uint32) {
	volatile.StoreUint32(&o.LSTIMER1_CONF.Reg, volatile.LoadUint32(&o.LSTIMER1_CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *LEDC_Type) GetLSTIMER1_CONF_LSTIMER1_PARA_UP() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER1_CONF.Reg) & 0x2000000) >> 25
}

// LEDC.LSTIMER1_VALUE: LEDC_LSTIMER1_VALUE.
func (o *LEDC_Type) SetLSTIMER1_VALUE_LSTIMER1_CNT(value uint32) {
	volatile.StoreUint32(&o.LSTIMER1_VALUE.Reg, volatile.LoadUint32(&o.LSTIMER1_VALUE.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetLSTIMER1_VALUE_LSTIMER1_CNT() uint32 {
	return volatile.LoadUint32(&o.LSTIMER1_VALUE.Reg) & 0x3fff
}

// LEDC.LSTIMER2_CONF: LEDC_LSTIMER2_CONF.
func (o *LEDC_Type) SetLSTIMER2_CONF_LSTIMER2_DUTY_RES(value uint32) {
	volatile.StoreUint32(&o.LSTIMER2_CONF.Reg, volatile.LoadUint32(&o.LSTIMER2_CONF.Reg)&^(0xf)|value)
}
func (o *LEDC_Type) GetLSTIMER2_CONF_LSTIMER2_DUTY_RES() uint32 {
	return volatile.LoadUint32(&o.LSTIMER2_CONF.Reg) & 0xf
}
func (o *LEDC_Type) SetLSTIMER2_CONF_CLK_DIV_LSTIMER2(value uint32) {
	volatile.StoreUint32(&o.LSTIMER2_CONF.Reg, volatile.LoadUint32(&o.LSTIMER2_CONF.Reg)&^(0x3ffff0)|value<<4)
}
func (o *LEDC_Type) GetLSTIMER2_CONF_CLK_DIV_LSTIMER2() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER2_CONF.Reg) & 0x3ffff0) >> 4
}
func (o *LEDC_Type) SetLSTIMER2_CONF_LSTIMER2_PAUSE(value uint32) {
	volatile.StoreUint32(&o.LSTIMER2_CONF.Reg, volatile.LoadUint32(&o.LSTIMER2_CONF.Reg)&^(0x400000)|value<<22)
}
func (o *LEDC_Type) GetLSTIMER2_CONF_LSTIMER2_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER2_CONF.Reg) & 0x400000) >> 22
}
func (o *LEDC_Type) SetLSTIMER2_CONF_LSTIMER2_RST(value uint32) {
	volatile.StoreUint32(&o.LSTIMER2_CONF.Reg, volatile.LoadUint32(&o.LSTIMER2_CONF.Reg)&^(0x800000)|value<<23)
}
func (o *LEDC_Type) GetLSTIMER2_CONF_LSTIMER2_RST() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER2_CONF.Reg) & 0x800000) >> 23
}
func (o *LEDC_Type) SetLSTIMER2_CONF_TICK_SEL_LSTIMER2(value uint32) {
	volatile.StoreUint32(&o.LSTIMER2_CONF.Reg, volatile.LoadUint32(&o.LSTIMER2_CONF.Reg)&^(0x1000000)|value<<24)
}
func (o *LEDC_Type) GetLSTIMER2_CONF_TICK_SEL_LSTIMER2() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER2_CONF.Reg) & 0x1000000) >> 24
}
func (o *LEDC_Type) SetLSTIMER2_CONF_LSTIMER2_PARA_UP(value uint32) {
	volatile.StoreUint32(&o.LSTIMER2_CONF.Reg, volatile.LoadUint32(&o.LSTIMER2_CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *LEDC_Type) GetLSTIMER2_CONF_LSTIMER2_PARA_UP() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER2_CONF.Reg) & 0x2000000) >> 25
}

// LEDC.LSTIMER2_VALUE: LEDC_LSTIMER2_VALUE.
func (o *LEDC_Type) SetLSTIMER2_VALUE_LSTIMER2_CNT(value uint32) {
	volatile.StoreUint32(&o.LSTIMER2_VALUE.Reg, volatile.LoadUint32(&o.LSTIMER2_VALUE.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetLSTIMER2_VALUE_LSTIMER2_CNT() uint32 {
	return volatile.LoadUint32(&o.LSTIMER2_VALUE.Reg) & 0x3fff
}

// LEDC.LSTIMER3_CONF: LEDC_LSTIMER3_CONF.
func (o *LEDC_Type) SetLSTIMER3_CONF_LSTIMER3_DUTY_RES(value uint32) {
	volatile.StoreUint32(&o.LSTIMER3_CONF.Reg, volatile.LoadUint32(&o.LSTIMER3_CONF.Reg)&^(0xf)|value)
}
func (o *LEDC_Type) GetLSTIMER3_CONF_LSTIMER3_DUTY_RES() uint32 {
	return volatile.LoadUint32(&o.LSTIMER3_CONF.Reg) & 0xf
}
func (o *LEDC_Type) SetLSTIMER3_CONF_CLK_DIV_LSTIMER3(value uint32) {
	volatile.StoreUint32(&o.LSTIMER3_CONF.Reg, volatile.LoadUint32(&o.LSTIMER3_CONF.Reg)&^(0x3ffff0)|value<<4)
}
func (o *LEDC_Type) GetLSTIMER3_CONF_CLK_DIV_LSTIMER3() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER3_CONF.Reg) & 0x3ffff0) >> 4
}
func (o *LEDC_Type) SetLSTIMER3_CONF_LSTIMER3_PAUSE(value uint32) {
	volatile.StoreUint32(&o.LSTIMER3_CONF.Reg, volatile.LoadUint32(&o.LSTIMER3_CONF.Reg)&^(0x400000)|value<<22)
}
func (o *LEDC_Type) GetLSTIMER3_CONF_LSTIMER3_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER3_CONF.Reg) & 0x400000) >> 22
}
func (o *LEDC_Type) SetLSTIMER3_CONF_LSTIMER3_RST(value uint32) {
	volatile.StoreUint32(&o.LSTIMER3_CONF.Reg, volatile.LoadUint32(&o.LSTIMER3_CONF.Reg)&^(0x800000)|value<<23)
}
func (o *LEDC_Type) GetLSTIMER3_CONF_LSTIMER3_RST() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER3_CONF.Reg) & 0x800000) >> 23
}
func (o *LEDC_Type) SetLSTIMER3_CONF_TICK_SEL_LSTIMER3(value uint32) {
	volatile.StoreUint32(&o.LSTIMER3_CONF.Reg, volatile.LoadUint32(&o.LSTIMER3_CONF.Reg)&^(0x1000000)|value<<24)
}
func (o *LEDC_Type) GetLSTIMER3_CONF_TICK_SEL_LSTIMER3() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER3_CONF.Reg) & 0x1000000) >> 24
}
func (o *LEDC_Type) SetLSTIMER3_CONF_LSTIMER3_PARA_UP(value uint32) {
	volatile.StoreUint32(&o.LSTIMER3_CONF.Reg, volatile.LoadUint32(&o.LSTIMER3_CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *LEDC_Type) GetLSTIMER3_CONF_LSTIMER3_PARA_UP() uint32 {
	return (volatile.LoadUint32(&o.LSTIMER3_CONF.Reg) & 0x2000000) >> 25
}

// LEDC.LSTIMER3_VALUE: LEDC_LSTIMER3_VALUE.
func (o *LEDC_Type) SetLSTIMER3_VALUE_LSTIMER3_CNT(value uint32) {
	volatile.StoreUint32(&o.LSTIMER3_VALUE.Reg, volatile.LoadUint32(&o.LSTIMER3_VALUE.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetLSTIMER3_VALUE_LSTIMER3_CNT() uint32 {
	return volatile.LoadUint32(&o.LSTIMER3_VALUE.Reg) & 0x3fff
}

// LEDC.INT_RAW: LEDC_INT_RAW.
func (o *LEDC_Type) SetINT_RAW_LSTIMER0_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *LEDC_Type) GetINT_RAW_LSTIMER0_OVF_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *LEDC_Type) SetINT_RAW_LSTIMER1_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *LEDC_Type) GetINT_RAW_LSTIMER1_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}
func (o *LEDC_Type) SetINT_RAW_LSTIMER2_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetINT_RAW_LSTIMER2_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetINT_RAW_LSTIMER3_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetINT_RAW_LSTIMER3_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetINT_RAW_DUTY_CHNG_END_LSCH0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetINT_RAW_DUTY_CHNG_END_LSCH0_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetINT_RAW_DUTY_CHNG_END_LSCH1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *LEDC_Type) GetINT_RAW_DUTY_CHNG_END_LSCH1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20) >> 5
}
func (o *LEDC_Type) SetINT_RAW_DUTY_CHNG_END_LSCH2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *LEDC_Type) GetINT_RAW_DUTY_CHNG_END_LSCH2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40) >> 6
}
func (o *LEDC_Type) SetINT_RAW_DUTY_CHNG_END_LSCH3_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *LEDC_Type) GetINT_RAW_DUTY_CHNG_END_LSCH3_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80) >> 7
}
func (o *LEDC_Type) SetINT_RAW_DUTY_CHNG_END_LSCH4_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *LEDC_Type) GetINT_RAW_DUTY_CHNG_END_LSCH4_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x100) >> 8
}
func (o *LEDC_Type) SetINT_RAW_DUTY_CHNG_END_LSCH5_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x200)|value<<9)
}
func (o *LEDC_Type) GetINT_RAW_DUTY_CHNG_END_LSCH5_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x200) >> 9
}
func (o *LEDC_Type) SetINT_RAW_OVF_CNT_LSCH0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x400)|value<<10)
}
func (o *LEDC_Type) GetINT_RAW_OVF_CNT_LSCH0_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x400) >> 10
}
func (o *LEDC_Type) SetINT_RAW_OVF_CNT_LSCH1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x800)|value<<11)
}
func (o *LEDC_Type) GetINT_RAW_OVF_CNT_LSCH1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x800) >> 11
}
func (o *LEDC_Type) SetINT_RAW_OVF_CNT_LSCH2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1000)|value<<12)
}
func (o *LEDC_Type) GetINT_RAW_OVF_CNT_LSCH2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1000) >> 12
}
func (o *LEDC_Type) SetINT_RAW_OVF_CNT_LSCH3_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2000)|value<<13)
}
func (o *LEDC_Type) GetINT_RAW_OVF_CNT_LSCH3_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2000) >> 13
}
func (o *LEDC_Type) SetINT_RAW_OVF_CNT_LSCH4_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4000)|value<<14)
}
func (o *LEDC_Type) GetINT_RAW_OVF_CNT_LSCH4_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4000) >> 14
}
func (o *LEDC_Type) SetINT_RAW_OVF_CNT_LSCH5_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetINT_RAW_OVF_CNT_LSCH5_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8000) >> 15
}

// LEDC.INT_ST: LEDC_INT_ST.
func (o *LEDC_Type) SetINT_ST_LSTIMER0_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1)|value)
}
func (o *LEDC_Type) GetINT_ST_LSTIMER0_OVF_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST.Reg) & 0x1
}
func (o *LEDC_Type) SetINT_ST_LSTIMER1_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *LEDC_Type) GetINT_ST_LSTIMER1_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2) >> 1
}
func (o *LEDC_Type) SetINT_ST_LSTIMER2_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetINT_ST_LSTIMER2_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetINT_ST_LSTIMER3_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetINT_ST_LSTIMER3_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetINT_ST_DUTY_CHNG_END_LSCH0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetINT_ST_DUTY_CHNG_END_LSCH0_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetINT_ST_DUTY_CHNG_END_LSCH1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *LEDC_Type) GetINT_ST_DUTY_CHNG_END_LSCH1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x20) >> 5
}
func (o *LEDC_Type) SetINT_ST_DUTY_CHNG_END_LSCH2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x40)|value<<6)
}
func (o *LEDC_Type) GetINT_ST_DUTY_CHNG_END_LSCH2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x40) >> 6
}
func (o *LEDC_Type) SetINT_ST_DUTY_CHNG_END_LSCH3_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80)|value<<7)
}
func (o *LEDC_Type) GetINT_ST_DUTY_CHNG_END_LSCH3_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80) >> 7
}
func (o *LEDC_Type) SetINT_ST_DUTY_CHNG_END_LSCH4_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x100)|value<<8)
}
func (o *LEDC_Type) GetINT_ST_DUTY_CHNG_END_LSCH4_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x100) >> 8
}
func (o *LEDC_Type) SetINT_ST_DUTY_CHNG_END_LSCH5_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x200)|value<<9)
}
func (o *LEDC_Type) GetINT_ST_DUTY_CHNG_END_LSCH5_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x200) >> 9
}
func (o *LEDC_Type) SetINT_ST_OVF_CNT_LSCH0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x400)|value<<10)
}
func (o *LEDC_Type) GetINT_ST_OVF_CNT_LSCH0_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x400) >> 10
}
func (o *LEDC_Type) SetINT_ST_OVF_CNT_LSCH1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x800)|value<<11)
}
func (o *LEDC_Type) GetINT_ST_OVF_CNT_LSCH1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x800) >> 11
}
func (o *LEDC_Type) SetINT_ST_OVF_CNT_LSCH2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1000)|value<<12)
}
func (o *LEDC_Type) GetINT_ST_OVF_CNT_LSCH2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x1000) >> 12
}
func (o *LEDC_Type) SetINT_ST_OVF_CNT_LSCH3_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2000)|value<<13)
}
func (o *LEDC_Type) GetINT_ST_OVF_CNT_LSCH3_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2000) >> 13
}
func (o *LEDC_Type) SetINT_ST_OVF_CNT_LSCH4_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4000)|value<<14)
}
func (o *LEDC_Type) GetINT_ST_OVF_CNT_LSCH4_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4000) >> 14
}
func (o *LEDC_Type) SetINT_ST_OVF_CNT_LSCH5_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetINT_ST_OVF_CNT_LSCH5_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8000) >> 15
}

// LEDC.INT_ENA: LEDC_INT_ENA.
func (o *LEDC_Type) SetINT_ENA_LSTIMER0_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *LEDC_Type) GetINT_ENA_LSTIMER0_OVF_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *LEDC_Type) SetINT_ENA_LSTIMER1_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *LEDC_Type) GetINT_ENA_LSTIMER1_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}
func (o *LEDC_Type) SetINT_ENA_LSTIMER2_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetINT_ENA_LSTIMER2_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetINT_ENA_LSTIMER3_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetINT_ENA_LSTIMER3_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetINT_ENA_DUTY_CHNG_END_LSCH0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetINT_ENA_DUTY_CHNG_END_LSCH0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetINT_ENA_DUTY_CHNG_END_LSCH1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *LEDC_Type) GetINT_ENA_DUTY_CHNG_END_LSCH1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20) >> 5
}
func (o *LEDC_Type) SetINT_ENA_DUTY_CHNG_END_LSCH2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *LEDC_Type) GetINT_ENA_DUTY_CHNG_END_LSCH2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40) >> 6
}
func (o *LEDC_Type) SetINT_ENA_DUTY_CHNG_END_LSCH3_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *LEDC_Type) GetINT_ENA_DUTY_CHNG_END_LSCH3_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80) >> 7
}
func (o *LEDC_Type) SetINT_ENA_DUTY_CHNG_END_LSCH4_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *LEDC_Type) GetINT_ENA_DUTY_CHNG_END_LSCH4_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x100) >> 8
}
func (o *LEDC_Type) SetINT_ENA_DUTY_CHNG_END_LSCH5_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x200)|value<<9)
}
func (o *LEDC_Type) GetINT_ENA_DUTY_CHNG_END_LSCH5_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x200) >> 9
}
func (o *LEDC_Type) SetINT_ENA_OVF_CNT_LSCH0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x400)|value<<10)
}
func (o *LEDC_Type) GetINT_ENA_OVF_CNT_LSCH0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x400) >> 10
}
func (o *LEDC_Type) SetINT_ENA_OVF_CNT_LSCH1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x800)|value<<11)
}
func (o *LEDC_Type) GetINT_ENA_OVF_CNT_LSCH1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x800) >> 11
}
func (o *LEDC_Type) SetINT_ENA_OVF_CNT_LSCH2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1000)|value<<12)
}
func (o *LEDC_Type) GetINT_ENA_OVF_CNT_LSCH2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1000) >> 12
}
func (o *LEDC_Type) SetINT_ENA_OVF_CNT_LSCH3_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2000)|value<<13)
}
func (o *LEDC_Type) GetINT_ENA_OVF_CNT_LSCH3_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2000) >> 13
}
func (o *LEDC_Type) SetINT_ENA_OVF_CNT_LSCH4_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4000)|value<<14)
}
func (o *LEDC_Type) GetINT_ENA_OVF_CNT_LSCH4_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4000) >> 14
}
func (o *LEDC_Type) SetINT_ENA_OVF_CNT_LSCH5_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetINT_ENA_OVF_CNT_LSCH5_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8000) >> 15
}

// LEDC.INT_CLR: LEDC_INT_CLR.
func (o *LEDC_Type) SetINT_CLR_LSTIMER0_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *LEDC_Type) GetINT_CLR_LSTIMER0_OVF_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *LEDC_Type) SetINT_CLR_LSTIMER1_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *LEDC_Type) GetINT_CLR_LSTIMER1_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}
func (o *LEDC_Type) SetINT_CLR_LSTIMER2_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetINT_CLR_LSTIMER2_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetINT_CLR_LSTIMER3_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetINT_CLR_LSTIMER3_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetINT_CLR_DUTY_CHNG_END_LSCH0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetINT_CLR_DUTY_CHNG_END_LSCH0_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetINT_CLR_DUTY_CHNG_END_LSCH1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *LEDC_Type) GetINT_CLR_DUTY_CHNG_END_LSCH1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20) >> 5
}
func (o *LEDC_Type) SetINT_CLR_DUTY_CHNG_END_LSCH2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *LEDC_Type) GetINT_CLR_DUTY_CHNG_END_LSCH2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40) >> 6
}
func (o *LEDC_Type) SetINT_CLR_DUTY_CHNG_END_LSCH3_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *LEDC_Type) GetINT_CLR_DUTY_CHNG_END_LSCH3_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80) >> 7
}
func (o *LEDC_Type) SetINT_CLR_DUTY_CHNG_END_LSCH4_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *LEDC_Type) GetINT_CLR_DUTY_CHNG_END_LSCH4_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x100) >> 8
}
func (o *LEDC_Type) SetINT_CLR_DUTY_CHNG_END_LSCH5_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x200)|value<<9)
}
func (o *LEDC_Type) GetINT_CLR_DUTY_CHNG_END_LSCH5_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x200) >> 9
}
func (o *LEDC_Type) SetINT_CLR_OVF_CNT_LSCH0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x400)|value<<10)
}
func (o *LEDC_Type) GetINT_CLR_OVF_CNT_LSCH0_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x400) >> 10
}
func (o *LEDC_Type) SetINT_CLR_OVF_CNT_LSCH1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x800)|value<<11)
}
func (o *LEDC_Type) GetINT_CLR_OVF_CNT_LSCH1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x800) >> 11
}
func (o *LEDC_Type) SetINT_CLR_OVF_CNT_LSCH2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *LEDC_Type) GetINT_CLR_OVF_CNT_LSCH2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1000) >> 12
}
func (o *LEDC_Type) SetINT_CLR_OVF_CNT_LSCH3_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *LEDC_Type) GetINT_CLR_OVF_CNT_LSCH3_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2000) >> 13
}
func (o *LEDC_Type) SetINT_CLR_OVF_CNT_LSCH4_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *LEDC_Type) GetINT_CLR_OVF_CNT_LSCH4_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4000) >> 14
}
func (o *LEDC_Type) SetINT_CLR_OVF_CNT_LSCH5_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetINT_CLR_OVF_CNT_LSCH5_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8000) >> 15
}

// LEDC.CONF: LEDC_CONF.
func (o *LEDC_Type) SetCONF_APB_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x3)|value)
}
func (o *LEDC_Type) GetCONF_APB_CLK_SEL() uint32 {
	return volatile.LoadUint32(&o.CONF.Reg) & 0x3
}
func (o *LEDC_Type) SetCONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *LEDC_Type) GetCONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x80000000) >> 31
}

// LEDC.DATE: LEDC_DATE.
func (o *LEDC_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *LEDC_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// Peripheral RMT
type RMT_Type struct {
	CH0DATA           volatile.Register32 // 0x0
	CH1DATA           volatile.Register32 // 0x4
	CH2DATA           volatile.Register32 // 0x8
	CH3DATA           volatile.Register32 // 0xC
	CH0CONF0          volatile.Register32 // 0x10
	CH1CONF0          volatile.Register32 // 0x14
	CH2CONF0          volatile.Register32 // 0x18
	CH2CONF1          volatile.Register32 // 0x1C
	CH3CONF0          volatile.Register32 // 0x20
	CH3CONF1          volatile.Register32 // 0x24
	CH0STATUS         volatile.Register32 // 0x28
	CH1STATUS         volatile.Register32 // 0x2C
	CH2STATUS         volatile.Register32 // 0x30
	CH3STATUS         volatile.Register32 // 0x34
	INT_RAW           volatile.Register32 // 0x38
	INT_ST            volatile.Register32 // 0x3C
	INT_ENA           volatile.Register32 // 0x40
	INT_CLR           volatile.Register32 // 0x44
	CH0CARRIER_DUTY   volatile.Register32 // 0x48
	CH1CARRIER_DUTY   volatile.Register32 // 0x4C
	CH2_RX_CARRIER_RM volatile.Register32 // 0x50
	CH3_RX_CARRIER_RM volatile.Register32 // 0x54
	CH0_TX_LIM        volatile.Register32 // 0x58
	CH1_TX_LIM        volatile.Register32 // 0x5C
	CH2_RX_LIM        volatile.Register32 // 0x60
	CH3_RX_LIM        volatile.Register32 // 0x64
	SYS_CONF          volatile.Register32 // 0x68
	TX_SIM            volatile.Register32 // 0x6C
	REF_CNT_RST       volatile.Register32 // 0x70
	_                 [88]byte
	DATE              volatile.Register32 // 0xCC
}

// RMT.CH0DATA: RMT_CH0DATA_REG.
func (o *RMT_Type) SetCH0DATA(value uint32) {
	volatile.StoreUint32(&o.CH0DATA.Reg, value)
}
func (o *RMT_Type) GetCH0DATA() uint32 {
	return volatile.LoadUint32(&o.CH0DATA.Reg)
}

// RMT.CH1DATA: RMT_CH1DATA_REG.
func (o *RMT_Type) SetCH1DATA(value uint32) {
	volatile.StoreUint32(&o.CH1DATA.Reg, value)
}
func (o *RMT_Type) GetCH1DATA() uint32 {
	return volatile.LoadUint32(&o.CH1DATA.Reg)
}

// RMT.CH2DATA: RMT_CH2DATA_REG.
func (o *RMT_Type) SetCH2DATA(value uint32) {
	volatile.StoreUint32(&o.CH2DATA.Reg, value)
}
func (o *RMT_Type) GetCH2DATA() uint32 {
	return volatile.LoadUint32(&o.CH2DATA.Reg)
}

// RMT.CH3DATA: RMT_CH3DATA_REG.
func (o *RMT_Type) SetCH3DATA(value uint32) {
	volatile.StoreUint32(&o.CH3DATA.Reg, value)
}
func (o *RMT_Type) GetCH3DATA() uint32 {
	return volatile.LoadUint32(&o.CH3DATA.Reg)
}

// RMT.CH0CONF0: RMT_CH0CONF0_REG.
func (o *RMT_Type) SetCH0CONF0_TX_START_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0CONF0.Reg, volatile.LoadUint32(&o.CH0CONF0.Reg)&^(0x1)|value)
}
func (o *RMT_Type) GetCH0CONF0_TX_START_CH0() uint32 {
	return volatile.LoadUint32(&o.CH0CONF0.Reg) & 0x1
}
func (o *RMT_Type) SetCH0CONF0_MEM_RD_RST_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0CONF0.Reg, volatile.LoadUint32(&o.CH0CONF0.Reg)&^(0x2)|value<<1)
}
func (o *RMT_Type) GetCH0CONF0_MEM_RD_RST_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0CONF0.Reg) & 0x2) >> 1
}
func (o *RMT_Type) SetCH0CONF0_APB_MEM_RST_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0CONF0.Reg, volatile.LoadUint32(&o.CH0CONF0.Reg)&^(0x4)|value<<2)
}
func (o *RMT_Type) GetCH0CONF0_APB_MEM_RST_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0CONF0.Reg) & 0x4) >> 2
}
func (o *RMT_Type) SetCH0CONF0_TX_CONTI_MODE_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0CONF0.Reg, volatile.LoadUint32(&o.CH0CONF0.Reg)&^(0x8)|value<<3)
}
func (o *RMT_Type) GetCH0CONF0_TX_CONTI_MODE_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0CONF0.Reg) & 0x8) >> 3
}
func (o *RMT_Type) SetCH0CONF0_MEM_TX_WRAP_EN_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0CONF0.Reg, volatile.LoadUint32(&o.CH0CONF0.Reg)&^(0x10)|value<<4)
}
func (o *RMT_Type) GetCH0CONF0_MEM_TX_WRAP_EN_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0CONF0.Reg) & 0x10) >> 4
}
func (o *RMT_Type) SetCH0CONF0_IDLE_OUT_LV_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0CONF0.Reg, volatile.LoadUint32(&o.CH0CONF0.Reg)&^(0x20)|value<<5)
}
func (o *RMT_Type) GetCH0CONF0_IDLE_OUT_LV_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0CONF0.Reg) & 0x20) >> 5
}
func (o *RMT_Type) SetCH0CONF0_IDLE_OUT_EN_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0CONF0.Reg, volatile.LoadUint32(&o.CH0CONF0.Reg)&^(0x40)|value<<6)
}
func (o *RMT_Type) GetCH0CONF0_IDLE_OUT_EN_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0CONF0.Reg) & 0x40) >> 6
}
func (o *RMT_Type) SetCH0CONF0_TX_STOP_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0CONF0.Reg, volatile.LoadUint32(&o.CH0CONF0.Reg)&^(0x80)|value<<7)
}
func (o *RMT_Type) GetCH0CONF0_TX_STOP_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0CONF0.Reg) & 0x80) >> 7
}
func (o *RMT_Type) SetCH0CONF0_DIV_CNT_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0CONF0.Reg, volatile.LoadUint32(&o.CH0CONF0.Reg)&^(0xff00)|value<<8)
}
func (o *RMT_Type) GetCH0CONF0_DIV_CNT_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0CONF0.Reg) & 0xff00) >> 8
}
func (o *RMT_Type) SetCH0CONF0_MEM_SIZE_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0CONF0.Reg, volatile.LoadUint32(&o.CH0CONF0.Reg)&^(0x70000)|value<<16)
}
func (o *RMT_Type) GetCH0CONF0_MEM_SIZE_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0CONF0.Reg) & 0x70000) >> 16
}
func (o *RMT_Type) SetCH0CONF0_CARRIER_EFF_EN_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0CONF0.Reg, volatile.LoadUint32(&o.CH0CONF0.Reg)&^(0x100000)|value<<20)
}
func (o *RMT_Type) GetCH0CONF0_CARRIER_EFF_EN_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0CONF0.Reg) & 0x100000) >> 20
}
func (o *RMT_Type) SetCH0CONF0_CARRIER_EN_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0CONF0.Reg, volatile.LoadUint32(&o.CH0CONF0.Reg)&^(0x200000)|value<<21)
}
func (o *RMT_Type) GetCH0CONF0_CARRIER_EN_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0CONF0.Reg) & 0x200000) >> 21
}
func (o *RMT_Type) SetCH0CONF0_CARRIER_OUT_LV_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0CONF0.Reg, volatile.LoadUint32(&o.CH0CONF0.Reg)&^(0x400000)|value<<22)
}
func (o *RMT_Type) GetCH0CONF0_CARRIER_OUT_LV_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0CONF0.Reg) & 0x400000) >> 22
}
func (o *RMT_Type) SetCH0CONF0_AFIFO_RST_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0CONF0.Reg, volatile.LoadUint32(&o.CH0CONF0.Reg)&^(0x800000)|value<<23)
}
func (o *RMT_Type) GetCH0CONF0_AFIFO_RST_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0CONF0.Reg) & 0x800000) >> 23
}
func (o *RMT_Type) SetCH0CONF0_REG_CONF_UPDATE_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0CONF0.Reg, volatile.LoadUint32(&o.CH0CONF0.Reg)&^(0x1000000)|value<<24)
}
func (o *RMT_Type) GetCH0CONF0_REG_CONF_UPDATE_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0CONF0.Reg) & 0x1000000) >> 24
}

// RMT.CH1CONF0: RMT_CH1CONF0_REG.
func (o *RMT_Type) SetCH1CONF0_TX_START_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1CONF0.Reg, volatile.LoadUint32(&o.CH1CONF0.Reg)&^(0x1)|value)
}
func (o *RMT_Type) GetCH1CONF0_TX_START_CH1() uint32 {
	return volatile.LoadUint32(&o.CH1CONF0.Reg) & 0x1
}
func (o *RMT_Type) SetCH1CONF0_MEM_RD_RST_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1CONF0.Reg, volatile.LoadUint32(&o.CH1CONF0.Reg)&^(0x2)|value<<1)
}
func (o *RMT_Type) GetCH1CONF0_MEM_RD_RST_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1CONF0.Reg) & 0x2) >> 1
}
func (o *RMT_Type) SetCH1CONF0_APB_MEM_RST_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1CONF0.Reg, volatile.LoadUint32(&o.CH1CONF0.Reg)&^(0x4)|value<<2)
}
func (o *RMT_Type) GetCH1CONF0_APB_MEM_RST_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1CONF0.Reg) & 0x4) >> 2
}
func (o *RMT_Type) SetCH1CONF0_TX_CONTI_MODE_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1CONF0.Reg, volatile.LoadUint32(&o.CH1CONF0.Reg)&^(0x8)|value<<3)
}
func (o *RMT_Type) GetCH1CONF0_TX_CONTI_MODE_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1CONF0.Reg) & 0x8) >> 3
}
func (o *RMT_Type) SetCH1CONF0_MEM_TX_WRAP_EN_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1CONF0.Reg, volatile.LoadUint32(&o.CH1CONF0.Reg)&^(0x10)|value<<4)
}
func (o *RMT_Type) GetCH1CONF0_MEM_TX_WRAP_EN_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1CONF0.Reg) & 0x10) >> 4
}
func (o *RMT_Type) SetCH1CONF0_IDLE_OUT_LV_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1CONF0.Reg, volatile.LoadUint32(&o.CH1CONF0.Reg)&^(0x20)|value<<5)
}
func (o *RMT_Type) GetCH1CONF0_IDLE_OUT_LV_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1CONF0.Reg) & 0x20) >> 5
}
func (o *RMT_Type) SetCH1CONF0_IDLE_OUT_EN_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1CONF0.Reg, volatile.LoadUint32(&o.CH1CONF0.Reg)&^(0x40)|value<<6)
}
func (o *RMT_Type) GetCH1CONF0_IDLE_OUT_EN_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1CONF0.Reg) & 0x40) >> 6
}
func (o *RMT_Type) SetCH1CONF0_TX_STOP_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1CONF0.Reg, volatile.LoadUint32(&o.CH1CONF0.Reg)&^(0x80)|value<<7)
}
func (o *RMT_Type) GetCH1CONF0_TX_STOP_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1CONF0.Reg) & 0x80) >> 7
}
func (o *RMT_Type) SetCH1CONF0_DIV_CNT_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1CONF0.Reg, volatile.LoadUint32(&o.CH1CONF0.Reg)&^(0xff00)|value<<8)
}
func (o *RMT_Type) GetCH1CONF0_DIV_CNT_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1CONF0.Reg) & 0xff00) >> 8
}
func (o *RMT_Type) SetCH1CONF0_MEM_SIZE_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1CONF0.Reg, volatile.LoadUint32(&o.CH1CONF0.Reg)&^(0x70000)|value<<16)
}
func (o *RMT_Type) GetCH1CONF0_MEM_SIZE_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1CONF0.Reg) & 0x70000) >> 16
}
func (o *RMT_Type) SetCH1CONF0_CARRIER_EFF_EN_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1CONF0.Reg, volatile.LoadUint32(&o.CH1CONF0.Reg)&^(0x100000)|value<<20)
}
func (o *RMT_Type) GetCH1CONF0_CARRIER_EFF_EN_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1CONF0.Reg) & 0x100000) >> 20
}
func (o *RMT_Type) SetCH1CONF0_CARRIER_EN_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1CONF0.Reg, volatile.LoadUint32(&o.CH1CONF0.Reg)&^(0x200000)|value<<21)
}
func (o *RMT_Type) GetCH1CONF0_CARRIER_EN_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1CONF0.Reg) & 0x200000) >> 21
}
func (o *RMT_Type) SetCH1CONF0_CARRIER_OUT_LV_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1CONF0.Reg, volatile.LoadUint32(&o.CH1CONF0.Reg)&^(0x400000)|value<<22)
}
func (o *RMT_Type) GetCH1CONF0_CARRIER_OUT_LV_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1CONF0.Reg) & 0x400000) >> 22
}
func (o *RMT_Type) SetCH1CONF0_AFIFO_RST_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1CONF0.Reg, volatile.LoadUint32(&o.CH1CONF0.Reg)&^(0x800000)|value<<23)
}
func (o *RMT_Type) GetCH1CONF0_AFIFO_RST_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1CONF0.Reg) & 0x800000) >> 23
}
func (o *RMT_Type) SetCH1CONF0_CONF_UPDATE_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1CONF0.Reg, volatile.LoadUint32(&o.CH1CONF0.Reg)&^(0x1000000)|value<<24)
}
func (o *RMT_Type) GetCH1CONF0_CONF_UPDATE_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1CONF0.Reg) & 0x1000000) >> 24
}

// RMT.CH2CONF0: RMT_CH2CONF0_REG.
func (o *RMT_Type) SetCH2CONF0_DIV_CNT_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2CONF0.Reg, volatile.LoadUint32(&o.CH2CONF0.Reg)&^(0xff)|value)
}
func (o *RMT_Type) GetCH2CONF0_DIV_CNT_CH2() uint32 {
	return volatile.LoadUint32(&o.CH2CONF0.Reg) & 0xff
}
func (o *RMT_Type) SetCH2CONF0_IDLE_THRES_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2CONF0.Reg, volatile.LoadUint32(&o.CH2CONF0.Reg)&^(0x7fff00)|value<<8)
}
func (o *RMT_Type) GetCH2CONF0_IDLE_THRES_CH2() uint32 {
	return (volatile.LoadUint32(&o.CH2CONF0.Reg) & 0x7fff00) >> 8
}
func (o *RMT_Type) SetCH2CONF0_MEM_SIZE_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2CONF0.Reg, volatile.LoadUint32(&o.CH2CONF0.Reg)&^(0x3800000)|value<<23)
}
func (o *RMT_Type) GetCH2CONF0_MEM_SIZE_CH2() uint32 {
	return (volatile.LoadUint32(&o.CH2CONF0.Reg) & 0x3800000) >> 23
}
func (o *RMT_Type) SetCH2CONF0_CARRIER_EN_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2CONF0.Reg, volatile.LoadUint32(&o.CH2CONF0.Reg)&^(0x10000000)|value<<28)
}
func (o *RMT_Type) GetCH2CONF0_CARRIER_EN_CH2() uint32 {
	return (volatile.LoadUint32(&o.CH2CONF0.Reg) & 0x10000000) >> 28
}
func (o *RMT_Type) SetCH2CONF0_CARRIER_OUT_LV_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2CONF0.Reg, volatile.LoadUint32(&o.CH2CONF0.Reg)&^(0x20000000)|value<<29)
}
func (o *RMT_Type) GetCH2CONF0_CARRIER_OUT_LV_CH2() uint32 {
	return (volatile.LoadUint32(&o.CH2CONF0.Reg) & 0x20000000) >> 29
}

// RMT.CH2CONF1: RMT_CH2CONF1_REG.
func (o *RMT_Type) SetCH2CONF1_RX_EN_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2CONF1.Reg, volatile.LoadUint32(&o.CH2CONF1.Reg)&^(0x1)|value)
}
func (o *RMT_Type) GetCH2CONF1_RX_EN_CH2() uint32 {
	return volatile.LoadUint32(&o.CH2CONF1.Reg) & 0x1
}
func (o *RMT_Type) SetCH2CONF1_MEM_WR_RST_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2CONF1.Reg, volatile.LoadUint32(&o.CH2CONF1.Reg)&^(0x2)|value<<1)
}
func (o *RMT_Type) GetCH2CONF1_MEM_WR_RST_CH2() uint32 {
	return (volatile.LoadUint32(&o.CH2CONF1.Reg) & 0x2) >> 1
}
func (o *RMT_Type) SetCH2CONF1_APB_MEM_RST_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2CONF1.Reg, volatile.LoadUint32(&o.CH2CONF1.Reg)&^(0x4)|value<<2)
}
func (o *RMT_Type) GetCH2CONF1_APB_MEM_RST_CH2() uint32 {
	return (volatile.LoadUint32(&o.CH2CONF1.Reg) & 0x4) >> 2
}
func (o *RMT_Type) SetCH2CONF1_MEM_OWNER_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2CONF1.Reg, volatile.LoadUint32(&o.CH2CONF1.Reg)&^(0x8)|value<<3)
}
func (o *RMT_Type) GetCH2CONF1_MEM_OWNER_CH2() uint32 {
	return (volatile.LoadUint32(&o.CH2CONF1.Reg) & 0x8) >> 3
}
func (o *RMT_Type) SetCH2CONF1_RX_FILTER_EN_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2CONF1.Reg, volatile.LoadUint32(&o.CH2CONF1.Reg)&^(0x10)|value<<4)
}
func (o *RMT_Type) GetCH2CONF1_RX_FILTER_EN_CH2() uint32 {
	return (volatile.LoadUint32(&o.CH2CONF1.Reg) & 0x10) >> 4
}
func (o *RMT_Type) SetCH2CONF1_RX_FILTER_THRES_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2CONF1.Reg, volatile.LoadUint32(&o.CH2CONF1.Reg)&^(0x1fe0)|value<<5)
}
func (o *RMT_Type) GetCH2CONF1_RX_FILTER_THRES_CH2() uint32 {
	return (volatile.LoadUint32(&o.CH2CONF1.Reg) & 0x1fe0) >> 5
}
func (o *RMT_Type) SetCH2CONF1_MEM_RX_WRAP_EN_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2CONF1.Reg, volatile.LoadUint32(&o.CH2CONF1.Reg)&^(0x2000)|value<<13)
}
func (o *RMT_Type) GetCH2CONF1_MEM_RX_WRAP_EN_CH2() uint32 {
	return (volatile.LoadUint32(&o.CH2CONF1.Reg) & 0x2000) >> 13
}
func (o *RMT_Type) SetCH2CONF1_AFIFO_RST_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2CONF1.Reg, volatile.LoadUint32(&o.CH2CONF1.Reg)&^(0x4000)|value<<14)
}
func (o *RMT_Type) GetCH2CONF1_AFIFO_RST_CH2() uint32 {
	return (volatile.LoadUint32(&o.CH2CONF1.Reg) & 0x4000) >> 14
}
func (o *RMT_Type) SetCH2CONF1_CONF_UPDATE_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2CONF1.Reg, volatile.LoadUint32(&o.CH2CONF1.Reg)&^(0x8000)|value<<15)
}
func (o *RMT_Type) GetCH2CONF1_CONF_UPDATE_CH2() uint32 {
	return (volatile.LoadUint32(&o.CH2CONF1.Reg) & 0x8000) >> 15
}

// RMT.CH3CONF0: RMT_CH3CONF0_REG.
func (o *RMT_Type) SetCH3CONF0_DIV_CNT_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3CONF0.Reg, volatile.LoadUint32(&o.CH3CONF0.Reg)&^(0xff)|value)
}
func (o *RMT_Type) GetCH3CONF0_DIV_CNT_CH3() uint32 {
	return volatile.LoadUint32(&o.CH3CONF0.Reg) & 0xff
}
func (o *RMT_Type) SetCH3CONF0_IDLE_THRES_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3CONF0.Reg, volatile.LoadUint32(&o.CH3CONF0.Reg)&^(0x7fff00)|value<<8)
}
func (o *RMT_Type) GetCH3CONF0_IDLE_THRES_CH3() uint32 {
	return (volatile.LoadUint32(&o.CH3CONF0.Reg) & 0x7fff00) >> 8
}
func (o *RMT_Type) SetCH3CONF0_MEM_SIZE_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3CONF0.Reg, volatile.LoadUint32(&o.CH3CONF0.Reg)&^(0x3800000)|value<<23)
}
func (o *RMT_Type) GetCH3CONF0_MEM_SIZE_CH3() uint32 {
	return (volatile.LoadUint32(&o.CH3CONF0.Reg) & 0x3800000) >> 23
}
func (o *RMT_Type) SetCH3CONF0_CARRIER_EN_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3CONF0.Reg, volatile.LoadUint32(&o.CH3CONF0.Reg)&^(0x10000000)|value<<28)
}
func (o *RMT_Type) GetCH3CONF0_CARRIER_EN_CH3() uint32 {
	return (volatile.LoadUint32(&o.CH3CONF0.Reg) & 0x10000000) >> 28
}
func (o *RMT_Type) SetCH3CONF0_CARRIER_OUT_LV_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3CONF0.Reg, volatile.LoadUint32(&o.CH3CONF0.Reg)&^(0x20000000)|value<<29)
}
func (o *RMT_Type) GetCH3CONF0_CARRIER_OUT_LV_CH3() uint32 {
	return (volatile.LoadUint32(&o.CH3CONF0.Reg) & 0x20000000) >> 29
}

// RMT.CH3CONF1: RMT_CH3CONF1_REG.
func (o *RMT_Type) SetCH3CONF1_RX_EN_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3CONF1.Reg, volatile.LoadUint32(&o.CH3CONF1.Reg)&^(0x1)|value)
}
func (o *RMT_Type) GetCH3CONF1_RX_EN_CH3() uint32 {
	return volatile.LoadUint32(&o.CH3CONF1.Reg) & 0x1
}
func (o *RMT_Type) SetCH3CONF1_MEM_WR_RST_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3CONF1.Reg, volatile.LoadUint32(&o.CH3CONF1.Reg)&^(0x2)|value<<1)
}
func (o *RMT_Type) GetCH3CONF1_MEM_WR_RST_CH3() uint32 {
	return (volatile.LoadUint32(&o.CH3CONF1.Reg) & 0x2) >> 1
}
func (o *RMT_Type) SetCH3CONF1_APB_MEM_RST_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3CONF1.Reg, volatile.LoadUint32(&o.CH3CONF1.Reg)&^(0x4)|value<<2)
}
func (o *RMT_Type) GetCH3CONF1_APB_MEM_RST_CH3() uint32 {
	return (volatile.LoadUint32(&o.CH3CONF1.Reg) & 0x4) >> 2
}
func (o *RMT_Type) SetCH3CONF1_MEM_OWNER_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3CONF1.Reg, volatile.LoadUint32(&o.CH3CONF1.Reg)&^(0x8)|value<<3)
}
func (o *RMT_Type) GetCH3CONF1_MEM_OWNER_CH3() uint32 {
	return (volatile.LoadUint32(&o.CH3CONF1.Reg) & 0x8) >> 3
}
func (o *RMT_Type) SetCH3CONF1_RX_FILTER_EN_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3CONF1.Reg, volatile.LoadUint32(&o.CH3CONF1.Reg)&^(0x10)|value<<4)
}
func (o *RMT_Type) GetCH3CONF1_RX_FILTER_EN_CH3() uint32 {
	return (volatile.LoadUint32(&o.CH3CONF1.Reg) & 0x10) >> 4
}
func (o *RMT_Type) SetCH3CONF1_RX_FILTER_THRES_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3CONF1.Reg, volatile.LoadUint32(&o.CH3CONF1.Reg)&^(0x1fe0)|value<<5)
}
func (o *RMT_Type) GetCH3CONF1_RX_FILTER_THRES_CH3() uint32 {
	return (volatile.LoadUint32(&o.CH3CONF1.Reg) & 0x1fe0) >> 5
}
func (o *RMT_Type) SetCH3CONF1_MEM_RX_WRAP_EN_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3CONF1.Reg, volatile.LoadUint32(&o.CH3CONF1.Reg)&^(0x2000)|value<<13)
}
func (o *RMT_Type) GetCH3CONF1_MEM_RX_WRAP_EN_CH3() uint32 {
	return (volatile.LoadUint32(&o.CH3CONF1.Reg) & 0x2000) >> 13
}
func (o *RMT_Type) SetCH3CONF1_AFIFO_RST_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3CONF1.Reg, volatile.LoadUint32(&o.CH3CONF1.Reg)&^(0x4000)|value<<14)
}
func (o *RMT_Type) GetCH3CONF1_AFIFO_RST_CH3() uint32 {
	return (volatile.LoadUint32(&o.CH3CONF1.Reg) & 0x4000) >> 14
}
func (o *RMT_Type) SetCH3CONF1_CONF_UPDATE_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3CONF1.Reg, volatile.LoadUint32(&o.CH3CONF1.Reg)&^(0x8000)|value<<15)
}
func (o *RMT_Type) GetCH3CONF1_CONF_UPDATE_CH3() uint32 {
	return (volatile.LoadUint32(&o.CH3CONF1.Reg) & 0x8000) >> 15
}

// RMT.CH0STATUS: RMT_CH0STATUS_REG.
func (o *RMT_Type) SetCH0STATUS_MEM_RADDR_EX_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0STATUS.Reg, volatile.LoadUint32(&o.CH0STATUS.Reg)&^(0x1ff)|value)
}
func (o *RMT_Type) GetCH0STATUS_MEM_RADDR_EX_CH0() uint32 {
	return volatile.LoadUint32(&o.CH0STATUS.Reg) & 0x1ff
}
func (o *RMT_Type) SetCH0STATUS_STATE_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0STATUS.Reg, volatile.LoadUint32(&o.CH0STATUS.Reg)&^(0xe00)|value<<9)
}
func (o *RMT_Type) GetCH0STATUS_STATE_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0STATUS.Reg) & 0xe00) >> 9
}
func (o *RMT_Type) SetCH0STATUS_APB_MEM_WADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0STATUS.Reg, volatile.LoadUint32(&o.CH0STATUS.Reg)&^(0x1ff000)|value<<12)
}
func (o *RMT_Type) GetCH0STATUS_APB_MEM_WADDR_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0STATUS.Reg) & 0x1ff000) >> 12
}
func (o *RMT_Type) SetCH0STATUS_APB_MEM_RD_ERR_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0STATUS.Reg, volatile.LoadUint32(&o.CH0STATUS.Reg)&^(0x200000)|value<<21)
}
func (o *RMT_Type) GetCH0STATUS_APB_MEM_RD_ERR_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0STATUS.Reg) & 0x200000) >> 21
}
func (o *RMT_Type) SetCH0STATUS_MEM_EMPTY_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0STATUS.Reg, volatile.LoadUint32(&o.CH0STATUS.Reg)&^(0x400000)|value<<22)
}
func (o *RMT_Type) GetCH0STATUS_MEM_EMPTY_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0STATUS.Reg) & 0x400000) >> 22
}
func (o *RMT_Type) SetCH0STATUS_APB_MEM_WR_ERR_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0STATUS.Reg, volatile.LoadUint32(&o.CH0STATUS.Reg)&^(0x800000)|value<<23)
}
func (o *RMT_Type) GetCH0STATUS_APB_MEM_WR_ERR_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0STATUS.Reg) & 0x800000) >> 23
}
func (o *RMT_Type) SetCH0STATUS_APB_MEM_RADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0STATUS.Reg, volatile.LoadUint32(&o.CH0STATUS.Reg)&^(0xff000000)|value<<24)
}
func (o *RMT_Type) GetCH0STATUS_APB_MEM_RADDR_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0STATUS.Reg) & 0xff000000) >> 24
}

// RMT.CH1STATUS: RMT_CH1STATUS_REG.
func (o *RMT_Type) SetCH1STATUS_MEM_RADDR_EX_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1STATUS.Reg, volatile.LoadUint32(&o.CH1STATUS.Reg)&^(0x1ff)|value)
}
func (o *RMT_Type) GetCH1STATUS_MEM_RADDR_EX_CH1() uint32 {
	return volatile.LoadUint32(&o.CH1STATUS.Reg) & 0x1ff
}
func (o *RMT_Type) SetCH1STATUS_STATE_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1STATUS.Reg, volatile.LoadUint32(&o.CH1STATUS.Reg)&^(0xe00)|value<<9)
}
func (o *RMT_Type) GetCH1STATUS_STATE_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1STATUS.Reg) & 0xe00) >> 9
}
func (o *RMT_Type) SetCH1STATUS_APB_MEM_WADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1STATUS.Reg, volatile.LoadUint32(&o.CH1STATUS.Reg)&^(0x1ff000)|value<<12)
}
func (o *RMT_Type) GetCH1STATUS_APB_MEM_WADDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1STATUS.Reg) & 0x1ff000) >> 12
}
func (o *RMT_Type) SetCH1STATUS_APB_MEM_RD_ERR_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1STATUS.Reg, volatile.LoadUint32(&o.CH1STATUS.Reg)&^(0x200000)|value<<21)
}
func (o *RMT_Type) GetCH1STATUS_APB_MEM_RD_ERR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1STATUS.Reg) & 0x200000) >> 21
}
func (o *RMT_Type) SetCH1STATUS_MEM_EMPTY_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1STATUS.Reg, volatile.LoadUint32(&o.CH1STATUS.Reg)&^(0x400000)|value<<22)
}
func (o *RMT_Type) GetCH1STATUS_MEM_EMPTY_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1STATUS.Reg) & 0x400000) >> 22
}
func (o *RMT_Type) SetCH1STATUS_APB_MEM_WR_ERR_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1STATUS.Reg, volatile.LoadUint32(&o.CH1STATUS.Reg)&^(0x800000)|value<<23)
}
func (o *RMT_Type) GetCH1STATUS_APB_MEM_WR_ERR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1STATUS.Reg) & 0x800000) >> 23
}
func (o *RMT_Type) SetCH1STATUS_APB_MEM_RADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1STATUS.Reg, volatile.LoadUint32(&o.CH1STATUS.Reg)&^(0xff000000)|value<<24)
}
func (o *RMT_Type) GetCH1STATUS_APB_MEM_RADDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1STATUS.Reg) & 0xff000000) >> 24
}

// RMT.CH2STATUS: RMT_CH2STATUS_REG.
func (o *RMT_Type) SetCH2STATUS_MEM_WADDR_EX_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2STATUS.Reg, volatile.LoadUint32(&o.CH2STATUS.Reg)&^(0x1ff)|value)
}
func (o *RMT_Type) GetCH2STATUS_MEM_WADDR_EX_CH2() uint32 {
	return volatile.LoadUint32(&o.CH2STATUS.Reg) & 0x1ff
}
func (o *RMT_Type) SetCH2STATUS_APB_MEM_RADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2STATUS.Reg, volatile.LoadUint32(&o.CH2STATUS.Reg)&^(0x1ff000)|value<<12)
}
func (o *RMT_Type) GetCH2STATUS_APB_MEM_RADDR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CH2STATUS.Reg) & 0x1ff000) >> 12
}
func (o *RMT_Type) SetCH2STATUS_STATE_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2STATUS.Reg, volatile.LoadUint32(&o.CH2STATUS.Reg)&^(0x1c00000)|value<<22)
}
func (o *RMT_Type) GetCH2STATUS_STATE_CH2() uint32 {
	return (volatile.LoadUint32(&o.CH2STATUS.Reg) & 0x1c00000) >> 22
}
func (o *RMT_Type) SetCH2STATUS_MEM_OWNER_ERR_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2STATUS.Reg, volatile.LoadUint32(&o.CH2STATUS.Reg)&^(0x2000000)|value<<25)
}
func (o *RMT_Type) GetCH2STATUS_MEM_OWNER_ERR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CH2STATUS.Reg) & 0x2000000) >> 25
}
func (o *RMT_Type) SetCH2STATUS_MEM_FULL_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2STATUS.Reg, volatile.LoadUint32(&o.CH2STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *RMT_Type) GetCH2STATUS_MEM_FULL_CH2() uint32 {
	return (volatile.LoadUint32(&o.CH2STATUS.Reg) & 0x4000000) >> 26
}
func (o *RMT_Type) SetCH2STATUS_APB_MEM_RD_ERR_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2STATUS.Reg, volatile.LoadUint32(&o.CH2STATUS.Reg)&^(0x8000000)|value<<27)
}
func (o *RMT_Type) GetCH2STATUS_APB_MEM_RD_ERR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CH2STATUS.Reg) & 0x8000000) >> 27
}

// RMT.CH3STATUS: RMT_CH3STATUS_REG.
func (o *RMT_Type) SetCH3STATUS_MEM_WADDR_EX_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3STATUS.Reg, volatile.LoadUint32(&o.CH3STATUS.Reg)&^(0x1ff)|value)
}
func (o *RMT_Type) GetCH3STATUS_MEM_WADDR_EX_CH3() uint32 {
	return volatile.LoadUint32(&o.CH3STATUS.Reg) & 0x1ff
}
func (o *RMT_Type) SetCH3STATUS_APB_MEM_RADDR_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3STATUS.Reg, volatile.LoadUint32(&o.CH3STATUS.Reg)&^(0x1ff000)|value<<12)
}
func (o *RMT_Type) GetCH3STATUS_APB_MEM_RADDR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CH3STATUS.Reg) & 0x1ff000) >> 12
}
func (o *RMT_Type) SetCH3STATUS_STATE_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3STATUS.Reg, volatile.LoadUint32(&o.CH3STATUS.Reg)&^(0x1c00000)|value<<22)
}
func (o *RMT_Type) GetCH3STATUS_STATE_CH3() uint32 {
	return (volatile.LoadUint32(&o.CH3STATUS.Reg) & 0x1c00000) >> 22
}
func (o *RMT_Type) SetCH3STATUS_MEM_OWNER_ERR_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3STATUS.Reg, volatile.LoadUint32(&o.CH3STATUS.Reg)&^(0x2000000)|value<<25)
}
func (o *RMT_Type) GetCH3STATUS_MEM_OWNER_ERR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CH3STATUS.Reg) & 0x2000000) >> 25
}
func (o *RMT_Type) SetCH3STATUS_MEM_FULL_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3STATUS.Reg, volatile.LoadUint32(&o.CH3STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *RMT_Type) GetCH3STATUS_MEM_FULL_CH3() uint32 {
	return (volatile.LoadUint32(&o.CH3STATUS.Reg) & 0x4000000) >> 26
}
func (o *RMT_Type) SetCH3STATUS_APB_MEM_RD_ERR_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3STATUS.Reg, volatile.LoadUint32(&o.CH3STATUS.Reg)&^(0x8000000)|value<<27)
}
func (o *RMT_Type) GetCH3STATUS_APB_MEM_RD_ERR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CH3STATUS.Reg) & 0x8000000) >> 27
}

// RMT.INT_RAW: RMT_INT_RAW_REG.
func (o *RMT_Type) SetINT_RAW_CH0_TX_END_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *RMT_Type) GetINT_RAW_CH0_TX_END_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *RMT_Type) SetINT_RAW_CH1_TX_END_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *RMT_Type) GetINT_RAW_CH1_TX_END_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}
func (o *RMT_Type) SetINT_RAW_CH2_RX_END_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *RMT_Type) GetINT_RAW_CH2_RX_END_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4) >> 2
}
func (o *RMT_Type) SetINT_RAW_CH3_RX_END_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *RMT_Type) GetINT_RAW_CH3_RX_END_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8) >> 3
}
func (o *RMT_Type) SetINT_RAW_CH0_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *RMT_Type) GetINT_RAW_CH0_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10) >> 4
}
func (o *RMT_Type) SetINT_RAW_CH1_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *RMT_Type) GetINT_RAW_CH1_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20) >> 5
}
func (o *RMT_Type) SetINT_RAW_CH2_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *RMT_Type) GetINT_RAW_CH2_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40) >> 6
}
func (o *RMT_Type) SetINT_RAW_CH3_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *RMT_Type) GetINT_RAW_CH3_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80) >> 7
}
func (o *RMT_Type) SetINT_RAW_CH0_TX_THR_EVENT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *RMT_Type) GetINT_RAW_CH0_TX_THR_EVENT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x100) >> 8
}
func (o *RMT_Type) SetINT_RAW_CH1_TX_THR_EVENT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x200)|value<<9)
}
func (o *RMT_Type) GetINT_RAW_CH1_TX_THR_EVENT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x200) >> 9
}
func (o *RMT_Type) SetINT_RAW_CH2_RX_THR_EVENT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x400)|value<<10)
}
func (o *RMT_Type) GetINT_RAW_CH2_RX_THR_EVENT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x400) >> 10
}
func (o *RMT_Type) SetINT_RAW_CH3_RX_THR_EVENT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x800)|value<<11)
}
func (o *RMT_Type) GetINT_RAW_CH3_RX_THR_EVENT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x800) >> 11
}
func (o *RMT_Type) SetINT_RAW_CH0_TX_LOOP_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1000)|value<<12)
}
func (o *RMT_Type) GetINT_RAW_CH0_TX_LOOP_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1000) >> 12
}
func (o *RMT_Type) SetINT_RAW_CH1_TX_LOOP_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2000)|value<<13)
}
func (o *RMT_Type) GetINT_RAW_CH1_TX_LOOP_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2000) >> 13
}

// RMT.INT_ST: RMT_INT_ST_REG.
func (o *RMT_Type) SetINT_ST_CH0_TX_END_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1)|value)
}
func (o *RMT_Type) GetINT_ST_CH0_TX_END_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST.Reg) & 0x1
}
func (o *RMT_Type) SetINT_ST_CH1_TX_END_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *RMT_Type) GetINT_ST_CH1_TX_END_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2) >> 1
}
func (o *RMT_Type) SetINT_ST_CH2_RX_END_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *RMT_Type) GetINT_ST_CH2_RX_END_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4) >> 2
}
func (o *RMT_Type) SetINT_ST_CH3_RX_END_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *RMT_Type) GetINT_ST_CH3_RX_END_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8) >> 3
}
func (o *RMT_Type) SetINT_ST_CH0_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *RMT_Type) GetINT_ST_CH0_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10) >> 4
}
func (o *RMT_Type) SetINT_ST_CH1_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *RMT_Type) GetINT_ST_CH1_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x20) >> 5
}
func (o *RMT_Type) SetINT_ST_CH2_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x40)|value<<6)
}
func (o *RMT_Type) GetINT_ST_CH2_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x40) >> 6
}
func (o *RMT_Type) SetINT_ST_CH3_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80)|value<<7)
}
func (o *RMT_Type) GetINT_ST_CH3_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80) >> 7
}
func (o *RMT_Type) SetINT_ST_CH0_TX_THR_EVENT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x100)|value<<8)
}
func (o *RMT_Type) GetINT_ST_CH0_TX_THR_EVENT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x100) >> 8
}
func (o *RMT_Type) SetINT_ST_CH1_TX_THR_EVENT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x200)|value<<9)
}
func (o *RMT_Type) GetINT_ST_CH1_TX_THR_EVENT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x200) >> 9
}
func (o *RMT_Type) SetINT_ST_CH2_RX_THR_EVENT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x400)|value<<10)
}
func (o *RMT_Type) GetINT_ST_CH2_RX_THR_EVENT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x400) >> 10
}
func (o *RMT_Type) SetINT_ST_CH3_RX_THR_EVENT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x800)|value<<11)
}
func (o *RMT_Type) GetINT_ST_CH3_RX_THR_EVENT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x800) >> 11
}
func (o *RMT_Type) SetINT_ST_CH0_TX_LOOP_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1000)|value<<12)
}
func (o *RMT_Type) GetINT_ST_CH0_TX_LOOP_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x1000) >> 12
}
func (o *RMT_Type) SetINT_ST_CH1_TX_LOOP_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2000)|value<<13)
}
func (o *RMT_Type) GetINT_ST_CH1_TX_LOOP_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2000) >> 13
}

// RMT.INT_ENA: RMT_INT_ENA_REG.
func (o *RMT_Type) SetINT_ENA_CH0_TX_END_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *RMT_Type) GetINT_ENA_CH0_TX_END_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *RMT_Type) SetINT_ENA_CH1_TX_END_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *RMT_Type) GetINT_ENA_CH1_TX_END_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}
func (o *RMT_Type) SetINT_ENA_CH2_RX_END_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *RMT_Type) GetINT_ENA_CH2_RX_END_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4) >> 2
}
func (o *RMT_Type) SetINT_ENA_CH3_RX_END_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *RMT_Type) GetINT_ENA_CH3_RX_END_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8) >> 3
}
func (o *RMT_Type) SetINT_ENA_CH0_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *RMT_Type) GetINT_ENA_CH0_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10) >> 4
}
func (o *RMT_Type) SetINT_ENA_CH1_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *RMT_Type) GetINT_ENA_CH1_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20) >> 5
}
func (o *RMT_Type) SetINT_ENA_CH2_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *RMT_Type) GetINT_ENA_CH2_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40) >> 6
}
func (o *RMT_Type) SetINT_ENA_CH3_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *RMT_Type) GetINT_ENA_CH3_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80) >> 7
}
func (o *RMT_Type) SetINT_ENA_CH0_TX_THR_EVENT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *RMT_Type) GetINT_ENA_CH0_TX_THR_EVENT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x100) >> 8
}
func (o *RMT_Type) SetINT_ENA_CH1_TX_THR_EVENT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x200)|value<<9)
}
func (o *RMT_Type) GetINT_ENA_CH1_TX_THR_EVENT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x200) >> 9
}
func (o *RMT_Type) SetINT_ENA_CH2_RX_THR_EVENT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x400)|value<<10)
}
func (o *RMT_Type) GetINT_ENA_CH2_RX_THR_EVENT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x400) >> 10
}
func (o *RMT_Type) SetINT_ENA_CH3_RX_THR_EVENT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x800)|value<<11)
}
func (o *RMT_Type) GetINT_ENA_CH3_RX_THR_EVENT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x800) >> 11
}
func (o *RMT_Type) SetINT_ENA_CH0_TX_LOOP_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1000)|value<<12)
}
func (o *RMT_Type) GetINT_ENA_CH0_TX_LOOP_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1000) >> 12
}
func (o *RMT_Type) SetINT_ENA_CH1_TX_LOOP_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2000)|value<<13)
}
func (o *RMT_Type) GetINT_ENA_CH1_TX_LOOP_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2000) >> 13
}

// RMT.INT_CLR: RMT_INT_CLR_REG.
func (o *RMT_Type) SetINT_CLR_CH0_TX_END_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *RMT_Type) GetINT_CLR_CH0_TX_END_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *RMT_Type) SetINT_CLR_CH1_TX_END_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *RMT_Type) GetINT_CLR_CH1_TX_END_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}
func (o *RMT_Type) SetINT_CLR_CH2_RX_END_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *RMT_Type) GetINT_CLR_CH2_RX_END_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4) >> 2
}
func (o *RMT_Type) SetINT_CLR_CH3_RX_END_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *RMT_Type) GetINT_CLR_CH3_RX_END_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8) >> 3
}
func (o *RMT_Type) SetINT_CLR_CH0_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *RMT_Type) GetINT_CLR_CH0_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10) >> 4
}
func (o *RMT_Type) SetINT_CLR_CH1_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *RMT_Type) GetINT_CLR_CH1_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20) >> 5
}
func (o *RMT_Type) SetINT_CLR_CH2_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *RMT_Type) GetINT_CLR_CH2_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40) >> 6
}
func (o *RMT_Type) SetINT_CLR_CH3_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *RMT_Type) GetINT_CLR_CH3_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80) >> 7
}
func (o *RMT_Type) SetINT_CLR_CH0_TX_THR_EVENT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *RMT_Type) GetINT_CLR_CH0_TX_THR_EVENT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x100) >> 8
}
func (o *RMT_Type) SetINT_CLR_CH1_TX_THR_EVENT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x200)|value<<9)
}
func (o *RMT_Type) GetINT_CLR_CH1_TX_THR_EVENT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x200) >> 9
}
func (o *RMT_Type) SetINT_CLR_CH2_RX_THR_EVENT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x400)|value<<10)
}
func (o *RMT_Type) GetINT_CLR_CH2_RX_THR_EVENT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x400) >> 10
}
func (o *RMT_Type) SetINT_CLR_CH3_RX_THR_EVENT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x800)|value<<11)
}
func (o *RMT_Type) GetINT_CLR_CH3_RX_THR_EVENT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x800) >> 11
}
func (o *RMT_Type) SetINT_CLR_CH0_TX_LOOP_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *RMT_Type) GetINT_CLR_CH0_TX_LOOP_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1000) >> 12
}
func (o *RMT_Type) SetINT_CLR_CH1_TX_LOOP_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *RMT_Type) GetINT_CLR_CH1_TX_LOOP_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2000) >> 13
}

// RMT.CH0CARRIER_DUTY: RMT_CH0CARRIER_DUTY_REG.
func (o *RMT_Type) SetCH0CARRIER_DUTY_CARRIER_LOW_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0CARRIER_DUTY.Reg, volatile.LoadUint32(&o.CH0CARRIER_DUTY.Reg)&^(0xffff)|value)
}
func (o *RMT_Type) GetCH0CARRIER_DUTY_CARRIER_LOW_CH0() uint32 {
	return volatile.LoadUint32(&o.CH0CARRIER_DUTY.Reg) & 0xffff
}
func (o *RMT_Type) SetCH0CARRIER_DUTY_CARRIER_HIGH_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0CARRIER_DUTY.Reg, volatile.LoadUint32(&o.CH0CARRIER_DUTY.Reg)&^(0xffff0000)|value<<16)
}
func (o *RMT_Type) GetCH0CARRIER_DUTY_CARRIER_HIGH_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0CARRIER_DUTY.Reg) & 0xffff0000) >> 16
}

// RMT.CH1CARRIER_DUTY: RMT_CH1CARRIER_DUTY_REG.
func (o *RMT_Type) SetCH1CARRIER_DUTY_CARRIER_LOW_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1CARRIER_DUTY.Reg, volatile.LoadUint32(&o.CH1CARRIER_DUTY.Reg)&^(0xffff)|value)
}
func (o *RMT_Type) GetCH1CARRIER_DUTY_CARRIER_LOW_CH1() uint32 {
	return volatile.LoadUint32(&o.CH1CARRIER_DUTY.Reg) & 0xffff
}
func (o *RMT_Type) SetCH1CARRIER_DUTY_CARRIER_HIGH_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1CARRIER_DUTY.Reg, volatile.LoadUint32(&o.CH1CARRIER_DUTY.Reg)&^(0xffff0000)|value<<16)
}
func (o *RMT_Type) GetCH1CARRIER_DUTY_CARRIER_HIGH_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1CARRIER_DUTY.Reg) & 0xffff0000) >> 16
}

// RMT.CH2_RX_CARRIER_RM: RMT_CH2_RX_CARRIER_RM_REG.
func (o *RMT_Type) SetCH2_RX_CARRIER_RM_CARRIER_LOW_THRES_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2_RX_CARRIER_RM.Reg, volatile.LoadUint32(&o.CH2_RX_CARRIER_RM.Reg)&^(0xffff)|value)
}
func (o *RMT_Type) GetCH2_RX_CARRIER_RM_CARRIER_LOW_THRES_CH2() uint32 {
	return volatile.LoadUint32(&o.CH2_RX_CARRIER_RM.Reg) & 0xffff
}
func (o *RMT_Type) SetCH2_RX_CARRIER_RM_CARRIER_HIGH_THRES_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2_RX_CARRIER_RM.Reg, volatile.LoadUint32(&o.CH2_RX_CARRIER_RM.Reg)&^(0xffff0000)|value<<16)
}
func (o *RMT_Type) GetCH2_RX_CARRIER_RM_CARRIER_HIGH_THRES_CH2() uint32 {
	return (volatile.LoadUint32(&o.CH2_RX_CARRIER_RM.Reg) & 0xffff0000) >> 16
}

// RMT.CH3_RX_CARRIER_RM: RMT_CH3_RX_CARRIER_RM_REG.
func (o *RMT_Type) SetCH3_RX_CARRIER_RM_CARRIER_LOW_THRES_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3_RX_CARRIER_RM.Reg, volatile.LoadUint32(&o.CH3_RX_CARRIER_RM.Reg)&^(0xffff)|value)
}
func (o *RMT_Type) GetCH3_RX_CARRIER_RM_CARRIER_LOW_THRES_CH3() uint32 {
	return volatile.LoadUint32(&o.CH3_RX_CARRIER_RM.Reg) & 0xffff
}
func (o *RMT_Type) SetCH3_RX_CARRIER_RM_CARRIER_HIGH_THRES_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3_RX_CARRIER_RM.Reg, volatile.LoadUint32(&o.CH3_RX_CARRIER_RM.Reg)&^(0xffff0000)|value<<16)
}
func (o *RMT_Type) GetCH3_RX_CARRIER_RM_CARRIER_HIGH_THRES_CH3() uint32 {
	return (volatile.LoadUint32(&o.CH3_RX_CARRIER_RM.Reg) & 0xffff0000) >> 16
}

// RMT.CH0_TX_LIM: RMT_CH0_TX_LIM_REG.
func (o *RMT_Type) SetCH0_TX_LIM_RMT_TX_LIM_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0_TX_LIM.Reg, volatile.LoadUint32(&o.CH0_TX_LIM.Reg)&^(0x1ff)|value)
}
func (o *RMT_Type) GetCH0_TX_LIM_RMT_TX_LIM_CH0() uint32 {
	return volatile.LoadUint32(&o.CH0_TX_LIM.Reg) & 0x1ff
}
func (o *RMT_Type) SetCH0_TX_LIM_RMT_TX_LOOP_NUM_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0_TX_LIM.Reg, volatile.LoadUint32(&o.CH0_TX_LIM.Reg)&^(0x7fe00)|value<<9)
}
func (o *RMT_Type) GetCH0_TX_LIM_RMT_TX_LOOP_NUM_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0_TX_LIM.Reg) & 0x7fe00) >> 9
}
func (o *RMT_Type) SetCH0_TX_LIM_RMT_TX_LOOP_CNT_EN_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0_TX_LIM.Reg, volatile.LoadUint32(&o.CH0_TX_LIM.Reg)&^(0x80000)|value<<19)
}
func (o *RMT_Type) GetCH0_TX_LIM_RMT_TX_LOOP_CNT_EN_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0_TX_LIM.Reg) & 0x80000) >> 19
}
func (o *RMT_Type) SetCH0_TX_LIM_LOOP_COUNT_RESET_CH0(value uint32) {
	volatile.StoreUint32(&o.CH0_TX_LIM.Reg, volatile.LoadUint32(&o.CH0_TX_LIM.Reg)&^(0x100000)|value<<20)
}
func (o *RMT_Type) GetCH0_TX_LIM_LOOP_COUNT_RESET_CH0() uint32 {
	return (volatile.LoadUint32(&o.CH0_TX_LIM.Reg) & 0x100000) >> 20
}

// RMT.CH1_TX_LIM: RMT_CH1_TX_LIM_REG.
func (o *RMT_Type) SetCH1_TX_LIM_RMT_TX_LIM_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1_TX_LIM.Reg, volatile.LoadUint32(&o.CH1_TX_LIM.Reg)&^(0x1ff)|value)
}
func (o *RMT_Type) GetCH1_TX_LIM_RMT_TX_LIM_CH1() uint32 {
	return volatile.LoadUint32(&o.CH1_TX_LIM.Reg) & 0x1ff
}
func (o *RMT_Type) SetCH1_TX_LIM_RMT_TX_LOOP_NUM_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1_TX_LIM.Reg, volatile.LoadUint32(&o.CH1_TX_LIM.Reg)&^(0x7fe00)|value<<9)
}
func (o *RMT_Type) GetCH1_TX_LIM_RMT_TX_LOOP_NUM_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1_TX_LIM.Reg) & 0x7fe00) >> 9
}
func (o *RMT_Type) SetCH1_TX_LIM_RMT_TX_LOOP_CNT_EN_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1_TX_LIM.Reg, volatile.LoadUint32(&o.CH1_TX_LIM.Reg)&^(0x80000)|value<<19)
}
func (o *RMT_Type) GetCH1_TX_LIM_RMT_TX_LOOP_CNT_EN_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1_TX_LIM.Reg) & 0x80000) >> 19
}
func (o *RMT_Type) SetCH1_TX_LIM_LOOP_COUNT_RESET_CH1(value uint32) {
	volatile.StoreUint32(&o.CH1_TX_LIM.Reg, volatile.LoadUint32(&o.CH1_TX_LIM.Reg)&^(0x100000)|value<<20)
}
func (o *RMT_Type) GetCH1_TX_LIM_LOOP_COUNT_RESET_CH1() uint32 {
	return (volatile.LoadUint32(&o.CH1_TX_LIM.Reg) & 0x100000) >> 20
}

// RMT.CH2_RX_LIM: RMT_CH2_RX_LIM_REG.
func (o *RMT_Type) SetCH2_RX_LIM_RMT_RX_LIM_CH2(value uint32) {
	volatile.StoreUint32(&o.CH2_RX_LIM.Reg, volatile.LoadUint32(&o.CH2_RX_LIM.Reg)&^(0x1ff)|value)
}
func (o *RMT_Type) GetCH2_RX_LIM_RMT_RX_LIM_CH2() uint32 {
	return volatile.LoadUint32(&o.CH2_RX_LIM.Reg) & 0x1ff
}

// RMT.CH3_RX_LIM: RMT_CH3_RX_LIM_REG.
func (o *RMT_Type) SetCH3_RX_LIM_RMT_RX_LIM_CH3(value uint32) {
	volatile.StoreUint32(&o.CH3_RX_LIM.Reg, volatile.LoadUint32(&o.CH3_RX_LIM.Reg)&^(0x1ff)|value)
}
func (o *RMT_Type) GetCH3_RX_LIM_RMT_RX_LIM_CH3() uint32 {
	return volatile.LoadUint32(&o.CH3_RX_LIM.Reg) & 0x1ff
}

// RMT.SYS_CONF: RMT_SYS_CONF_REG.
func (o *RMT_Type) SetSYS_CONF_APB_FIFO_MASK(value uint32) {
	volatile.StoreUint32(&o.SYS_CONF.Reg, volatile.LoadUint32(&o.SYS_CONF.Reg)&^(0x1)|value)
}
func (o *RMT_Type) GetSYS_CONF_APB_FIFO_MASK() uint32 {
	return volatile.LoadUint32(&o.SYS_CONF.Reg) & 0x1
}
func (o *RMT_Type) SetSYS_CONF_MEM_CLK_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.SYS_CONF.Reg, volatile.LoadUint32(&o.SYS_CONF.Reg)&^(0x2)|value<<1)
}
func (o *RMT_Type) GetSYS_CONF_MEM_CLK_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.SYS_CONF.Reg) & 0x2) >> 1
}
func (o *RMT_Type) SetSYS_CONF_RMT_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.SYS_CONF.Reg, volatile.LoadUint32(&o.SYS_CONF.Reg)&^(0x4)|value<<2)
}
func (o *RMT_Type) GetSYS_CONF_RMT_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.SYS_CONF.Reg) & 0x4) >> 2
}
func (o *RMT_Type) SetSYS_CONF_RMT_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.SYS_CONF.Reg, volatile.LoadUint32(&o.SYS_CONF.Reg)&^(0x8)|value<<3)
}
func (o *RMT_Type) GetSYS_CONF_RMT_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.SYS_CONF.Reg) & 0x8) >> 3
}
func (o *RMT_Type) SetSYS_CONF_RMT_SCLK_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.SYS_CONF.Reg, volatile.LoadUint32(&o.SYS_CONF.Reg)&^(0xff0)|value<<4)
}
func (o *RMT_Type) GetSYS_CONF_RMT_SCLK_DIV_NUM() uint32 {
	return (volatile.LoadUint32(&o.SYS_CONF.Reg) & 0xff0) >> 4
}
func (o *RMT_Type) SetSYS_CONF_RMT_SCLK_DIV_A(value uint32) {
	volatile.StoreUint32(&o.SYS_CONF.Reg, volatile.LoadUint32(&o.SYS_CONF.Reg)&^(0x3f000)|value<<12)
}
func (o *RMT_Type) GetSYS_CONF_RMT_SCLK_DIV_A() uint32 {
	return (volatile.LoadUint32(&o.SYS_CONF.Reg) & 0x3f000) >> 12
}
func (o *RMT_Type) SetSYS_CONF_RMT_SCLK_DIV_B(value uint32) {
	volatile.StoreUint32(&o.SYS_CONF.Reg, volatile.LoadUint32(&o.SYS_CONF.Reg)&^(0xfc0000)|value<<18)
}
func (o *RMT_Type) GetSYS_CONF_RMT_SCLK_DIV_B() uint32 {
	return (volatile.LoadUint32(&o.SYS_CONF.Reg) & 0xfc0000) >> 18
}
func (o *RMT_Type) SetSYS_CONF_RMT_SCLK_SEL(value uint32) {
	volatile.StoreUint32(&o.SYS_CONF.Reg, volatile.LoadUint32(&o.SYS_CONF.Reg)&^(0x3000000)|value<<24)
}
func (o *RMT_Type) GetSYS_CONF_RMT_SCLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.SYS_CONF.Reg) & 0x3000000) >> 24
}
func (o *RMT_Type) SetSYS_CONF_RMT_SCLK_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.SYS_CONF.Reg, volatile.LoadUint32(&o.SYS_CONF.Reg)&^(0x4000000)|value<<26)
}
func (o *RMT_Type) GetSYS_CONF_RMT_SCLK_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.SYS_CONF.Reg) & 0x4000000) >> 26
}
func (o *RMT_Type) SetSYS_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.SYS_CONF.Reg, volatile.LoadUint32(&o.SYS_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *RMT_Type) GetSYS_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.SYS_CONF.Reg) & 0x80000000) >> 31
}

// RMT.TX_SIM: RMT_TX_SIM_REG.
func (o *RMT_Type) SetTX_SIM_RMT_TX_SIM_CH0(value uint32) {
	volatile.StoreUint32(&o.TX_SIM.Reg, volatile.LoadUint32(&o.TX_SIM.Reg)&^(0x1)|value)
}
func (o *RMT_Type) GetTX_SIM_RMT_TX_SIM_CH0() uint32 {
	return volatile.LoadUint32(&o.TX_SIM.Reg) & 0x1
}
func (o *RMT_Type) SetTX_SIM_RMT_TX_SIM_CH1(value uint32) {
	volatile.StoreUint32(&o.TX_SIM.Reg, volatile.LoadUint32(&o.TX_SIM.Reg)&^(0x2)|value<<1)
}
func (o *RMT_Type) GetTX_SIM_RMT_TX_SIM_CH1() uint32 {
	return (volatile.LoadUint32(&o.TX_SIM.Reg) & 0x2) >> 1
}
func (o *RMT_Type) SetTX_SIM_RMT_TX_SIM_EN(value uint32) {
	volatile.StoreUint32(&o.TX_SIM.Reg, volatile.LoadUint32(&o.TX_SIM.Reg)&^(0x4)|value<<2)
}
func (o *RMT_Type) GetTX_SIM_RMT_TX_SIM_EN() uint32 {
	return (volatile.LoadUint32(&o.TX_SIM.Reg) & 0x4) >> 2
}

// RMT.REF_CNT_RST: RMT_REF_CNT_RST_REG.
func (o *RMT_Type) SetREF_CNT_RST_CH0(value uint32) {
	volatile.StoreUint32(&o.REF_CNT_RST.Reg, volatile.LoadUint32(&o.REF_CNT_RST.Reg)&^(0x1)|value)
}
func (o *RMT_Type) GetREF_CNT_RST_CH0() uint32 {
	return volatile.LoadUint32(&o.REF_CNT_RST.Reg) & 0x1
}
func (o *RMT_Type) SetREF_CNT_RST_CH1(value uint32) {
	volatile.StoreUint32(&o.REF_CNT_RST.Reg, volatile.LoadUint32(&o.REF_CNT_RST.Reg)&^(0x2)|value<<1)
}
func (o *RMT_Type) GetREF_CNT_RST_CH1() uint32 {
	return (volatile.LoadUint32(&o.REF_CNT_RST.Reg) & 0x2) >> 1
}
func (o *RMT_Type) SetREF_CNT_RST_CH2(value uint32) {
	volatile.StoreUint32(&o.REF_CNT_RST.Reg, volatile.LoadUint32(&o.REF_CNT_RST.Reg)&^(0x4)|value<<2)
}
func (o *RMT_Type) GetREF_CNT_RST_CH2() uint32 {
	return (volatile.LoadUint32(&o.REF_CNT_RST.Reg) & 0x4) >> 2
}
func (o *RMT_Type) SetREF_CNT_RST_CH3(value uint32) {
	volatile.StoreUint32(&o.REF_CNT_RST.Reg, volatile.LoadUint32(&o.REF_CNT_RST.Reg)&^(0x8)|value<<3)
}
func (o *RMT_Type) GetREF_CNT_RST_CH3() uint32 {
	return (volatile.LoadUint32(&o.REF_CNT_RST.Reg) & 0x8) >> 3
}

// RMT.DATE: RMT_DATE_REG.
func (o *RMT_Type) SetDATE_RMT_DATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *RMT_Type) GetDATE_RMT_DATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// Peripheral RSA
type RSA_Type struct {
	M_MEM             volatile.Register32 // 0x0
	_                 [508]byte
	Z_MEM             volatile.Register32 // 0x200
	_                 [508]byte
	Y_MEM             volatile.Register32 // 0x400
	_                 [508]byte
	X_MEM             volatile.Register32 // 0x600
	_                 [508]byte
	M_PRIME           volatile.Register32 // 0x800
	MODE              volatile.Register32 // 0x804
	QUERY_CLEAN       volatile.Register32 // 0x808
	SET_START_MODEXP  volatile.Register32 // 0x80C
	SET_START_MODMULT volatile.Register32 // 0x810
	SET_START_MULT    volatile.Register32 // 0x814
	QUERY_IDLE        volatile.Register32 // 0x818
	INT_CLR           volatile.Register32 // 0x81C
	CONSTANT_TIME     volatile.Register32 // 0x820
	SEARCH_ENABLE     volatile.Register32 // 0x824
	SEARCH_POS        volatile.Register32 // 0x828
	INT_ENA           volatile.Register32 // 0x82C
	DATE              volatile.Register32 // 0x830
}

// RSA.M_PRIME: RSA M_prime register
func (o *RSA_Type) SetM_PRIME(value uint32) {
	volatile.StoreUint32(&o.M_PRIME.Reg, value)
}
func (o *RSA_Type) GetM_PRIME() uint32 {
	return volatile.LoadUint32(&o.M_PRIME.Reg)
}

// RSA.MODE: RSA mode register
func (o *RSA_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x7f)|value)
}
func (o *RSA_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x7f
}

// RSA.QUERY_CLEAN: RSA query clean register
func (o *RSA_Type) SetQUERY_CLEAN(value uint32) {
	volatile.StoreUint32(&o.QUERY_CLEAN.Reg, volatile.LoadUint32(&o.QUERY_CLEAN.Reg)&^(0x1)|value)
}
func (o *RSA_Type) GetQUERY_CLEAN() uint32 {
	return volatile.LoadUint32(&o.QUERY_CLEAN.Reg) & 0x1
}

// RSA.SET_START_MODEXP: RSA modular exponentiation trigger register.
func (o *RSA_Type) SetSET_START_MODEXP(value uint32) {
	volatile.StoreUint32(&o.SET_START_MODEXP.Reg, volatile.LoadUint32(&o.SET_START_MODEXP.Reg)&^(0x1)|value)
}
func (o *RSA_Type) GetSET_START_MODEXP() uint32 {
	return volatile.LoadUint32(&o.SET_START_MODEXP.Reg) & 0x1
}

// RSA.SET_START_MODMULT: RSA modular multiplication trigger register.
func (o *RSA_Type) SetSET_START_MODMULT(value uint32) {
	volatile.StoreUint32(&o.SET_START_MODMULT.Reg, volatile.LoadUint32(&o.SET_START_MODMULT.Reg)&^(0x1)|value)
}
func (o *RSA_Type) GetSET_START_MODMULT() uint32 {
	return volatile.LoadUint32(&o.SET_START_MODMULT.Reg) & 0x1
}

// RSA.SET_START_MULT: RSA normal multiplication trigger register.
func (o *RSA_Type) SetSET_START_MULT(value uint32) {
	volatile.StoreUint32(&o.SET_START_MULT.Reg, volatile.LoadUint32(&o.SET_START_MULT.Reg)&^(0x1)|value)
}
func (o *RSA_Type) GetSET_START_MULT() uint32 {
	return volatile.LoadUint32(&o.SET_START_MULT.Reg) & 0x1
}

// RSA.QUERY_IDLE: RSA query idle register
func (o *RSA_Type) SetQUERY_IDLE(value uint32) {
	volatile.StoreUint32(&o.QUERY_IDLE.Reg, volatile.LoadUint32(&o.QUERY_IDLE.Reg)&^(0x1)|value)
}
func (o *RSA_Type) GetQUERY_IDLE() uint32 {
	return volatile.LoadUint32(&o.QUERY_IDLE.Reg) & 0x1
}

// RSA.INT_CLR: RSA interrupt clear register
func (o *RSA_Type) SetINT_CLR_CLEAR_INTERRUPT(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *RSA_Type) GetINT_CLR_CLEAR_INTERRUPT() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}

// RSA.CONSTANT_TIME: RSA constant time option register
func (o *RSA_Type) SetCONSTANT_TIME(value uint32) {
	volatile.StoreUint32(&o.CONSTANT_TIME.Reg, volatile.LoadUint32(&o.CONSTANT_TIME.Reg)&^(0x1)|value)
}
func (o *RSA_Type) GetCONSTANT_TIME() uint32 {
	return volatile.LoadUint32(&o.CONSTANT_TIME.Reg) & 0x1
}

// RSA.SEARCH_ENABLE: RSA search option
func (o *RSA_Type) SetSEARCH_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SEARCH_ENABLE.Reg, volatile.LoadUint32(&o.SEARCH_ENABLE.Reg)&^(0x1)|value)
}
func (o *RSA_Type) GetSEARCH_ENABLE() uint32 {
	return volatile.LoadUint32(&o.SEARCH_ENABLE.Reg) & 0x1
}

// RSA.SEARCH_POS: RSA search position configure register
func (o *RSA_Type) SetSEARCH_POS(value uint32) {
	volatile.StoreUint32(&o.SEARCH_POS.Reg, volatile.LoadUint32(&o.SEARCH_POS.Reg)&^(0xfff)|value)
}
func (o *RSA_Type) GetSEARCH_POS() uint32 {
	return volatile.LoadUint32(&o.SEARCH_POS.Reg) & 0xfff
}

// RSA.INT_ENA: RSA interrupt enable register
func (o *RSA_Type) SetINT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *RSA_Type) GetINT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}

// RSA.DATE: RSA version control register
func (o *RSA_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x3fffffff)|value)
}
func (o *RSA_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x3fffffff
}

// Peripheral RTC_CNTL
type RTC_CNTL_Type struct {
	RTC_OPTIONS0            volatile.Register32 // 0x0
	RTC_SLP_TIMER0          volatile.Register32 // 0x4
	RTC_SLP_TIMER1          volatile.Register32 // 0x8
	RTC_TIME_UPDATE         volatile.Register32 // 0xC
	RTC_TIME_LOW0           volatile.Register32 // 0x10
	RTC_TIME_HIGH0          volatile.Register32 // 0x14
	RTC_STATE0              volatile.Register32 // 0x18
	RTC_TIMER1              volatile.Register32 // 0x1C
	RTC_TIMER2              volatile.Register32 // 0x20
	RTC_TIMER3              volatile.Register32 // 0x24
	RTC_TIMER4              volatile.Register32 // 0x28
	RTC_TIMER5              volatile.Register32 // 0x2C
	RTC_TIMER6              volatile.Register32 // 0x30
	RTC_ANA_CONF            volatile.Register32 // 0x34
	RTC_RESET_STATE         volatile.Register32 // 0x38
	RTC_WAKEUP_STATE        volatile.Register32 // 0x3C
	INT_ENA_RTC             volatile.Register32 // 0x40
	INT_RAW_RTC             volatile.Register32 // 0x44
	INT_ST_RTC              volatile.Register32 // 0x48
	INT_CLR_RTC             volatile.Register32 // 0x4C
	RTC_STORE0              volatile.Register32 // 0x50
	RTC_STORE1              volatile.Register32 // 0x54
	RTC_STORE2              volatile.Register32 // 0x58
	RTC_STORE3              volatile.Register32 // 0x5C
	RTC_EXT_XTL_CONF        volatile.Register32 // 0x60
	RTC_EXT_WAKEUP_CONF     volatile.Register32 // 0x64
	RTC_SLP_REJECT_CONF     volatile.Register32 // 0x68
	RTC_CPU_PERIOD_CONF     volatile.Register32 // 0x6C
	RTC_CLK_CONF            volatile.Register32 // 0x70
	RTC_SLOW_CLK_CONF       volatile.Register32 // 0x74
	RTC_SDIO_CONF           volatile.Register32 // 0x78
	RTC_BIAS_CONF           volatile.Register32 // 0x7C
	RTC                     volatile.Register32 // 0x80
	RTC_PWC                 volatile.Register32 // 0x84
	DIG_PWC                 volatile.Register32 // 0x88
	DIG_ISO                 volatile.Register32 // 0x8C
	RTC_WDTCONFIG0          volatile.Register32 // 0x90
	RTC_WDTCONFIG1          volatile.Register32 // 0x94
	RTC_WDTCONFIG2          volatile.Register32 // 0x98
	RTC_WDTCONFIG3          volatile.Register32 // 0x9C
	RTC_WDTCONFIG4          volatile.Register32 // 0xA0
	RTC_WDTFEED             volatile.Register32 // 0xA4
	RTC_WDTWPROTECT         volatile.Register32 // 0xA8
	RTC_SWD_CONF            volatile.Register32 // 0xAC
	RTC_SWD_WPROTECT        volatile.Register32 // 0xB0
	RTC_SW_CPU_STALL        volatile.Register32 // 0xB4
	RTC_STORE4              volatile.Register32 // 0xB8
	RTC_STORE5              volatile.Register32 // 0xBC
	RTC_STORE6              volatile.Register32 // 0xC0
	RTC_STORE7              volatile.Register32 // 0xC4
	RTC_LOW_POWER_ST        volatile.Register32 // 0xC8
	RTC_DIAG0               volatile.Register32 // 0xCC
	RTC_PAD_HOLD            volatile.Register32 // 0xD0
	DIG_PAD_HOLD            volatile.Register32 // 0xD4
	RTC_BROWN_OUT           volatile.Register32 // 0xD8
	RTC_TIME_LOW1           volatile.Register32 // 0xDC
	RTC_TIME_HIGH1          volatile.Register32 // 0xE0
	RTC_XTAL32K_CLK_FACTOR  volatile.Register32 // 0xE4
	RTC_XTAL32K_CONF        volatile.Register32 // 0xE8
	RTC_USB_CONF            volatile.Register32 // 0xEC
	RTC_SLP_REJECT_CAUSE    volatile.Register32 // 0xF0
	RTC_OPTION1             volatile.Register32 // 0xF4
	RTC_SLP_WAKEUP_CAUSE    volatile.Register32 // 0xF8
	RTC_ULP_CP_TIMER_1      volatile.Register32 // 0xFC
	INT_ENA_RTC_W1TS        volatile.Register32 // 0x100
	INT_ENA_RTC_W1TC        volatile.Register32 // 0x104
	RTC_CNTL_RETENTION_CTRL volatile.Register32 // 0x108
	RTC_FIB_SEL             volatile.Register32 // 0x10C
	RTC_CNTL_GPIO_WAKEUP    volatile.Register32 // 0x110
	RTC_CNTL_DBG_SEL        volatile.Register32 // 0x114
	RTC_CNTL_DBG_MAP        volatile.Register32 // 0x118
	RTC_CNTL_SENSOR_CTRL    volatile.Register32 // 0x11C
	RTC_CNTL_DBG_SAR_SEL    volatile.Register32 // 0x120
	RTC_CNTL_PG_CTRL        volatile.Register32 // 0x124
	_                       [212]byte
	DATE                    volatile.Register32 // 0x1FC
}

// RTC_CNTL.RTC_OPTIONS0: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_SW_STALL_APPCPU_C0(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x3)|value)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_SW_STALL_APPCPU_C0() uint32 {
	return volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x3
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_SW_STALL_PROCPU_C0(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0xc)|value<<2)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_SW_STALL_PROCPU_C0() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0xc) >> 2
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_SW_APPCPU_RST(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x10)|value<<4)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_SW_APPCPU_RST() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x10) >> 4
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_SW_PROCPU_RST(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x20)|value<<5)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_SW_PROCPU_RST() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x20) >> 5
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_BB_I2C_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x40)|value<<6)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_BB_I2C_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x40) >> 6
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_BB_I2C_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x80)|value<<7)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_BB_I2C_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x80) >> 7
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_BBPLL_I2C_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x100)|value<<8)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_BBPLL_I2C_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x100) >> 8
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_BBPLL_I2C_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_BBPLL_I2C_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_BBPLL_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_BBPLL_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_BBPLL_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x800)|value<<11)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_BBPLL_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x800) >> 11
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_XTL_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_XTL_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x1000) >> 12
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_XTL_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_XTL_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x2000) >> 13
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_XTL_EN_WAIT(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x3c000)|value<<14)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_XTL_EN_WAIT() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x3c000) >> 14
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_XTL_EXT_CTR_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x700000)|value<<20)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_XTL_EXT_CTR_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x700000) >> 20
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_XTL_FORCE_ISO(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_XTL_FORCE_ISO() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x800000) >> 23
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_PLL_FORCE_ISO(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_PLL_FORCE_ISO() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x1000000) >> 24
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_ANALOG_FORCE_ISO(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_ANALOG_FORCE_ISO() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x2000000) >> 25
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_XTL_FORCE_NOISO(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_XTL_FORCE_NOISO() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x4000000) >> 26
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_PLL_FORCE_NOISO(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_PLL_FORCE_NOISO() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x8000000) >> 27
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_ANALOG_FORCE_NOISO(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_ANALOG_FORCE_NOISO() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_DG_WRAP_FORCE_RST(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_DG_WRAP_FORCE_RST() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_DG_WRAP_FORCE_NORST(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_DG_WRAP_FORCE_NORST() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetRTC_OPTIONS0_SW_SYS_RST(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTIONS0.Reg, volatile.LoadUint32(&o.RTC_OPTIONS0.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetRTC_OPTIONS0_SW_SYS_RST() uint32 {
	return (volatile.LoadUint32(&o.RTC_OPTIONS0.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.RTC_SLP_TIMER0: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_SLP_TIMER0(value uint32) {
	volatile.StoreUint32(&o.RTC_SLP_TIMER0.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_SLP_TIMER0() uint32 {
	return volatile.LoadUint32(&o.RTC_SLP_TIMER0.Reg)
}

// RTC_CNTL.RTC_SLP_TIMER1: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_SLP_TIMER1_SLP_VAL_HI(value uint32) {
	volatile.StoreUint32(&o.RTC_SLP_TIMER1.Reg, volatile.LoadUint32(&o.RTC_SLP_TIMER1.Reg)&^(0xffff)|value)
}
func (o *RTC_CNTL_Type) GetRTC_SLP_TIMER1_SLP_VAL_HI() uint32 {
	return volatile.LoadUint32(&o.RTC_SLP_TIMER1.Reg) & 0xffff
}
func (o *RTC_CNTL_Type) SetRTC_SLP_TIMER1_RTC_MAIN_TIMER_ALARM_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_SLP_TIMER1.Reg, volatile.LoadUint32(&o.RTC_SLP_TIMER1.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_CNTL_Type) GetRTC_SLP_TIMER1_RTC_MAIN_TIMER_ALARM_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_SLP_TIMER1.Reg) & 0x10000) >> 16
}

// RTC_CNTL.RTC_TIME_UPDATE: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_TIME_UPDATE_TIMER_SYS_STALL(value uint32) {
	volatile.StoreUint32(&o.RTC_TIME_UPDATE.Reg, volatile.LoadUint32(&o.RTC_TIME_UPDATE.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetRTC_TIME_UPDATE_TIMER_SYS_STALL() uint32 {
	return (volatile.LoadUint32(&o.RTC_TIME_UPDATE.Reg) & 0x8000000) >> 27
}
func (o *RTC_CNTL_Type) SetRTC_TIME_UPDATE_TIMER_XTL_OFF(value uint32) {
	volatile.StoreUint32(&o.RTC_TIME_UPDATE.Reg, volatile.LoadUint32(&o.RTC_TIME_UPDATE.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetRTC_TIME_UPDATE_TIMER_XTL_OFF() uint32 {
	return (volatile.LoadUint32(&o.RTC_TIME_UPDATE.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetRTC_TIME_UPDATE_TIMER_SYS_RST(value uint32) {
	volatile.StoreUint32(&o.RTC_TIME_UPDATE.Reg, volatile.LoadUint32(&o.RTC_TIME_UPDATE.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetRTC_TIME_UPDATE_TIMER_SYS_RST() uint32 {
	return (volatile.LoadUint32(&o.RTC_TIME_UPDATE.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetRTC_TIME_UPDATE(value uint32) {
	volatile.StoreUint32(&o.RTC_TIME_UPDATE.Reg, volatile.LoadUint32(&o.RTC_TIME_UPDATE.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetRTC_TIME_UPDATE() uint32 {
	return (volatile.LoadUint32(&o.RTC_TIME_UPDATE.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.RTC_TIME_LOW0: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_TIME_LOW0(value uint32) {
	volatile.StoreUint32(&o.RTC_TIME_LOW0.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_TIME_LOW0() uint32 {
	return volatile.LoadUint32(&o.RTC_TIME_LOW0.Reg)
}

// RTC_CNTL.RTC_TIME_HIGH0: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_TIME_HIGH0_RTC_TIMER_VALUE0_HIGH(value uint32) {
	volatile.StoreUint32(&o.RTC_TIME_HIGH0.Reg, volatile.LoadUint32(&o.RTC_TIME_HIGH0.Reg)&^(0xffff)|value)
}
func (o *RTC_CNTL_Type) GetRTC_TIME_HIGH0_RTC_TIMER_VALUE0_HIGH() uint32 {
	return volatile.LoadUint32(&o.RTC_TIME_HIGH0.Reg) & 0xffff
}

// RTC_CNTL.RTC_STATE0: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_STATE0_RTC_SW_CPU_INT(value uint32) {
	volatile.StoreUint32(&o.RTC_STATE0.Reg, volatile.LoadUint32(&o.RTC_STATE0.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetRTC_STATE0_RTC_SW_CPU_INT() uint32 {
	return volatile.LoadUint32(&o.RTC_STATE0.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetRTC_STATE0_RTC_SLP_REJECT_CAUSE_CLR(value uint32) {
	volatile.StoreUint32(&o.RTC_STATE0.Reg, volatile.LoadUint32(&o.RTC_STATE0.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetRTC_STATE0_RTC_SLP_REJECT_CAUSE_CLR() uint32 {
	return (volatile.LoadUint32(&o.RTC_STATE0.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetRTC_STATE0_APB2RTC_BRIDGE_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_STATE0.Reg, volatile.LoadUint32(&o.RTC_STATE0.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_CNTL_Type) GetRTC_STATE0_APB2RTC_BRIDGE_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTC_STATE0.Reg) & 0x400000) >> 22
}
func (o *RTC_CNTL_Type) SetRTC_STATE0_SDIO_ACTIVE_IND(value uint32) {
	volatile.StoreUint32(&o.RTC_STATE0.Reg, volatile.LoadUint32(&o.RTC_STATE0.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetRTC_STATE0_SDIO_ACTIVE_IND() uint32 {
	return (volatile.LoadUint32(&o.RTC_STATE0.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetRTC_STATE0_SLP_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.RTC_STATE0.Reg, volatile.LoadUint32(&o.RTC_STATE0.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetRTC_STATE0_SLP_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.RTC_STATE0.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetRTC_STATE0_SLP_REJECT(value uint32) {
	volatile.StoreUint32(&o.RTC_STATE0.Reg, volatile.LoadUint32(&o.RTC_STATE0.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetRTC_STATE0_SLP_REJECT() uint32 {
	return (volatile.LoadUint32(&o.RTC_STATE0.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetRTC_STATE0_SLEEP_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_STATE0.Reg, volatile.LoadUint32(&o.RTC_STATE0.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetRTC_STATE0_SLEEP_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_STATE0.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.RTC_TIMER1: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_TIMER1_CPU_STALL_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_TIMER1.Reg, volatile.LoadUint32(&o.RTC_TIMER1.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetRTC_TIMER1_CPU_STALL_EN() uint32 {
	return volatile.LoadUint32(&o.RTC_TIMER1.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetRTC_TIMER1_CPU_STALL_WAIT(value uint32) {
	volatile.StoreUint32(&o.RTC_TIMER1.Reg, volatile.LoadUint32(&o.RTC_TIMER1.Reg)&^(0x3e)|value<<1)
}
func (o *RTC_CNTL_Type) GetRTC_TIMER1_CPU_STALL_WAIT() uint32 {
	return (volatile.LoadUint32(&o.RTC_TIMER1.Reg) & 0x3e) >> 1
}
func (o *RTC_CNTL_Type) SetRTC_TIMER1_CK8M_WAIT(value uint32) {
	volatile.StoreUint32(&o.RTC_TIMER1.Reg, volatile.LoadUint32(&o.RTC_TIMER1.Reg)&^(0x3fc0)|value<<6)
}
func (o *RTC_CNTL_Type) GetRTC_TIMER1_CK8M_WAIT() uint32 {
	return (volatile.LoadUint32(&o.RTC_TIMER1.Reg) & 0x3fc0) >> 6
}
func (o *RTC_CNTL_Type) SetRTC_TIMER1_XTL_BUF_WAIT(value uint32) {
	volatile.StoreUint32(&o.RTC_TIMER1.Reg, volatile.LoadUint32(&o.RTC_TIMER1.Reg)&^(0xffc000)|value<<14)
}
func (o *RTC_CNTL_Type) GetRTC_TIMER1_XTL_BUF_WAIT() uint32 {
	return (volatile.LoadUint32(&o.RTC_TIMER1.Reg) & 0xffc000) >> 14
}
func (o *RTC_CNTL_Type) SetRTC_TIMER1_PLL_BUF_WAIT(value uint32) {
	volatile.StoreUint32(&o.RTC_TIMER1.Reg, volatile.LoadUint32(&o.RTC_TIMER1.Reg)&^(0xff000000)|value<<24)
}
func (o *RTC_CNTL_Type) GetRTC_TIMER1_PLL_BUF_WAIT() uint32 {
	return (volatile.LoadUint32(&o.RTC_TIMER1.Reg) & 0xff000000) >> 24
}

// RTC_CNTL.RTC_TIMER2: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_TIMER2_MIN_TIME_CK8M_OFF(value uint32) {
	volatile.StoreUint32(&o.RTC_TIMER2.Reg, volatile.LoadUint32(&o.RTC_TIMER2.Reg)&^(0xff000000)|value<<24)
}
func (o *RTC_CNTL_Type) GetRTC_TIMER2_MIN_TIME_CK8M_OFF() uint32 {
	return (volatile.LoadUint32(&o.RTC_TIMER2.Reg) & 0xff000000) >> 24
}

// RTC_CNTL.RTC_TIMER3: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_TIMER3_WIFI_WAIT_TIMER(value uint32) {
	volatile.StoreUint32(&o.RTC_TIMER3.Reg, volatile.LoadUint32(&o.RTC_TIMER3.Reg)&^(0x1ff)|value)
}
func (o *RTC_CNTL_Type) GetRTC_TIMER3_WIFI_WAIT_TIMER() uint32 {
	return volatile.LoadUint32(&o.RTC_TIMER3.Reg) & 0x1ff
}
func (o *RTC_CNTL_Type) SetRTC_TIMER3_WIFI_POWERUP_TIMER(value uint32) {
	volatile.StoreUint32(&o.RTC_TIMER3.Reg, volatile.LoadUint32(&o.RTC_TIMER3.Reg)&^(0xfe00)|value<<9)
}
func (o *RTC_CNTL_Type) GetRTC_TIMER3_WIFI_POWERUP_TIMER() uint32 {
	return (volatile.LoadUint32(&o.RTC_TIMER3.Reg) & 0xfe00) >> 9
}
func (o *RTC_CNTL_Type) SetRTC_TIMER3_BT_WAIT_TIMER(value uint32) {
	volatile.StoreUint32(&o.RTC_TIMER3.Reg, volatile.LoadUint32(&o.RTC_TIMER3.Reg)&^(0x1ff0000)|value<<16)
}
func (o *RTC_CNTL_Type) GetRTC_TIMER3_BT_WAIT_TIMER() uint32 {
	return (volatile.LoadUint32(&o.RTC_TIMER3.Reg) & 0x1ff0000) >> 16
}
func (o *RTC_CNTL_Type) SetRTC_TIMER3_BT_POWERUP_TIMER(value uint32) {
	volatile.StoreUint32(&o.RTC_TIMER3.Reg, volatile.LoadUint32(&o.RTC_TIMER3.Reg)&^(0xfe000000)|value<<25)
}
func (o *RTC_CNTL_Type) GetRTC_TIMER3_BT_POWERUP_TIMER() uint32 {
	return (volatile.LoadUint32(&o.RTC_TIMER3.Reg) & 0xfe000000) >> 25
}

// RTC_CNTL.RTC_TIMER4: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_TIMER4_CPU_TOP_WAIT_TIMER(value uint32) {
	volatile.StoreUint32(&o.RTC_TIMER4.Reg, volatile.LoadUint32(&o.RTC_TIMER4.Reg)&^(0x1ff)|value)
}
func (o *RTC_CNTL_Type) GetRTC_TIMER4_CPU_TOP_WAIT_TIMER() uint32 {
	return volatile.LoadUint32(&o.RTC_TIMER4.Reg) & 0x1ff
}
func (o *RTC_CNTL_Type) SetRTC_TIMER4_CPU_TOP_POWERUP_TIMER(value uint32) {
	volatile.StoreUint32(&o.RTC_TIMER4.Reg, volatile.LoadUint32(&o.RTC_TIMER4.Reg)&^(0xfe00)|value<<9)
}
func (o *RTC_CNTL_Type) GetRTC_TIMER4_CPU_TOP_POWERUP_TIMER() uint32 {
	return (volatile.LoadUint32(&o.RTC_TIMER4.Reg) & 0xfe00) >> 9
}
func (o *RTC_CNTL_Type) SetRTC_TIMER4_DG_WRAP_WAIT_TIMER(value uint32) {
	volatile.StoreUint32(&o.RTC_TIMER4.Reg, volatile.LoadUint32(&o.RTC_TIMER4.Reg)&^(0x1ff0000)|value<<16)
}
func (o *RTC_CNTL_Type) GetRTC_TIMER4_DG_WRAP_WAIT_TIMER() uint32 {
	return (volatile.LoadUint32(&o.RTC_TIMER4.Reg) & 0x1ff0000) >> 16
}
func (o *RTC_CNTL_Type) SetRTC_TIMER4_DG_WRAP_POWERUP_TIMER(value uint32) {
	volatile.StoreUint32(&o.RTC_TIMER4.Reg, volatile.LoadUint32(&o.RTC_TIMER4.Reg)&^(0xfe000000)|value<<25)
}
func (o *RTC_CNTL_Type) GetRTC_TIMER4_DG_WRAP_POWERUP_TIMER() uint32 {
	return (volatile.LoadUint32(&o.RTC_TIMER4.Reg) & 0xfe000000) >> 25
}

// RTC_CNTL.RTC_TIMER5: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_TIMER5_MIN_SLP_VAL(value uint32) {
	volatile.StoreUint32(&o.RTC_TIMER5.Reg, volatile.LoadUint32(&o.RTC_TIMER5.Reg)&^(0xff00)|value<<8)
}
func (o *RTC_CNTL_Type) GetRTC_TIMER5_MIN_SLP_VAL() uint32 {
	return (volatile.LoadUint32(&o.RTC_TIMER5.Reg) & 0xff00) >> 8
}

// RTC_CNTL.RTC_TIMER6: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_TIMER6_DG_PERI_WAIT_TIMER(value uint32) {
	volatile.StoreUint32(&o.RTC_TIMER6.Reg, volatile.LoadUint32(&o.RTC_TIMER6.Reg)&^(0x1ff0000)|value<<16)
}
func (o *RTC_CNTL_Type) GetRTC_TIMER6_DG_PERI_WAIT_TIMER() uint32 {
	return (volatile.LoadUint32(&o.RTC_TIMER6.Reg) & 0x1ff0000) >> 16
}
func (o *RTC_CNTL_Type) SetRTC_TIMER6_DG_PERI_POWERUP_TIMER(value uint32) {
	volatile.StoreUint32(&o.RTC_TIMER6.Reg, volatile.LoadUint32(&o.RTC_TIMER6.Reg)&^(0xfe000000)|value<<25)
}
func (o *RTC_CNTL_Type) GetRTC_TIMER6_DG_PERI_POWERUP_TIMER() uint32 {
	return (volatile.LoadUint32(&o.RTC_TIMER6.Reg) & 0xfe000000) >> 25
}

// RTC_CNTL.RTC_ANA_CONF: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_ANA_CONF_RESET_POR_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.RTC_ANA_CONF.Reg, volatile.LoadUint32(&o.RTC_ANA_CONF.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_CNTL_Type) GetRTC_ANA_CONF_RESET_POR_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.RTC_ANA_CONF.Reg) & 0x40000) >> 18
}
func (o *RTC_CNTL_Type) SetRTC_ANA_CONF_RESET_POR_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.RTC_ANA_CONF.Reg, volatile.LoadUint32(&o.RTC_ANA_CONF.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_CNTL_Type) GetRTC_ANA_CONF_RESET_POR_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.RTC_ANA_CONF.Reg) & 0x80000) >> 19
}
func (o *RTC_CNTL_Type) SetRTC_ANA_CONF_GLITCH_RST_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_ANA_CONF.Reg, volatile.LoadUint32(&o.RTC_ANA_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetRTC_ANA_CONF_GLITCH_RST_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_ANA_CONF.Reg) & 0x100000) >> 20
}
func (o *RTC_CNTL_Type) SetRTC_ANA_CONF_SAR_I2C_PU(value uint32) {
	volatile.StoreUint32(&o.RTC_ANA_CONF.Reg, volatile.LoadUint32(&o.RTC_ANA_CONF.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_CNTL_Type) GetRTC_ANA_CONF_SAR_I2C_PU() uint32 {
	return (volatile.LoadUint32(&o.RTC_ANA_CONF.Reg) & 0x400000) >> 22
}
func (o *RTC_CNTL_Type) SetRTC_ANA_CONF_PLLA_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.RTC_ANA_CONF.Reg, volatile.LoadUint32(&o.RTC_ANA_CONF.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_CNTL_Type) GetRTC_ANA_CONF_PLLA_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.RTC_ANA_CONF.Reg) & 0x800000) >> 23
}
func (o *RTC_CNTL_Type) SetRTC_ANA_CONF_PLLA_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.RTC_ANA_CONF.Reg, volatile.LoadUint32(&o.RTC_ANA_CONF.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_CNTL_Type) GetRTC_ANA_CONF_PLLA_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.RTC_ANA_CONF.Reg) & 0x1000000) >> 24
}
func (o *RTC_CNTL_Type) SetRTC_ANA_CONF_BBPLL_CAL_SLP_START(value uint32) {
	volatile.StoreUint32(&o.RTC_ANA_CONF.Reg, volatile.LoadUint32(&o.RTC_ANA_CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_CNTL_Type) GetRTC_ANA_CONF_BBPLL_CAL_SLP_START() uint32 {
	return (volatile.LoadUint32(&o.RTC_ANA_CONF.Reg) & 0x2000000) >> 25
}
func (o *RTC_CNTL_Type) SetRTC_ANA_CONF_PVTMON_PU(value uint32) {
	volatile.StoreUint32(&o.RTC_ANA_CONF.Reg, volatile.LoadUint32(&o.RTC_ANA_CONF.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_CNTL_Type) GetRTC_ANA_CONF_PVTMON_PU() uint32 {
	return (volatile.LoadUint32(&o.RTC_ANA_CONF.Reg) & 0x4000000) >> 26
}
func (o *RTC_CNTL_Type) SetRTC_ANA_CONF_TXRF_I2C_PU(value uint32) {
	volatile.StoreUint32(&o.RTC_ANA_CONF.Reg, volatile.LoadUint32(&o.RTC_ANA_CONF.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetRTC_ANA_CONF_TXRF_I2C_PU() uint32 {
	return (volatile.LoadUint32(&o.RTC_ANA_CONF.Reg) & 0x8000000) >> 27
}
func (o *RTC_CNTL_Type) SetRTC_ANA_CONF_RFRX_PBUS_PU(value uint32) {
	volatile.StoreUint32(&o.RTC_ANA_CONF.Reg, volatile.LoadUint32(&o.RTC_ANA_CONF.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetRTC_ANA_CONF_RFRX_PBUS_PU() uint32 {
	return (volatile.LoadUint32(&o.RTC_ANA_CONF.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetRTC_ANA_CONF_CKGEN_I2C_PU(value uint32) {
	volatile.StoreUint32(&o.RTC_ANA_CONF.Reg, volatile.LoadUint32(&o.RTC_ANA_CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetRTC_ANA_CONF_CKGEN_I2C_PU() uint32 {
	return (volatile.LoadUint32(&o.RTC_ANA_CONF.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetRTC_ANA_CONF_PLL_I2C_PU(value uint32) {
	volatile.StoreUint32(&o.RTC_ANA_CONF.Reg, volatile.LoadUint32(&o.RTC_ANA_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetRTC_ANA_CONF_PLL_I2C_PU() uint32 {
	return (volatile.LoadUint32(&o.RTC_ANA_CONF.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.RTC_RESET_STATE: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_RESET_STATE_RESET_CAUSE_PROCPU(value uint32) {
	volatile.StoreUint32(&o.RTC_RESET_STATE.Reg, volatile.LoadUint32(&o.RTC_RESET_STATE.Reg)&^(0x3f)|value)
}
func (o *RTC_CNTL_Type) GetRTC_RESET_STATE_RESET_CAUSE_PROCPU() uint32 {
	return volatile.LoadUint32(&o.RTC_RESET_STATE.Reg) & 0x3f
}
func (o *RTC_CNTL_Type) SetRTC_RESET_STATE_RESET_CAUSE_APPCPU(value uint32) {
	volatile.StoreUint32(&o.RTC_RESET_STATE.Reg, volatile.LoadUint32(&o.RTC_RESET_STATE.Reg)&^(0xfc0)|value<<6)
}
func (o *RTC_CNTL_Type) GetRTC_RESET_STATE_RESET_CAUSE_APPCPU() uint32 {
	return (volatile.LoadUint32(&o.RTC_RESET_STATE.Reg) & 0xfc0) >> 6
}
func (o *RTC_CNTL_Type) SetRTC_RESET_STATE_STAT_VECTOR_SEL_APPCPU(value uint32) {
	volatile.StoreUint32(&o.RTC_RESET_STATE.Reg, volatile.LoadUint32(&o.RTC_RESET_STATE.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_CNTL_Type) GetRTC_RESET_STATE_STAT_VECTOR_SEL_APPCPU() uint32 {
	return (volatile.LoadUint32(&o.RTC_RESET_STATE.Reg) & 0x1000) >> 12
}
func (o *RTC_CNTL_Type) SetRTC_RESET_STATE_STAT_VECTOR_SEL_PROCPU(value uint32) {
	volatile.StoreUint32(&o.RTC_RESET_STATE.Reg, volatile.LoadUint32(&o.RTC_RESET_STATE.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_CNTL_Type) GetRTC_RESET_STATE_STAT_VECTOR_SEL_PROCPU() uint32 {
	return (volatile.LoadUint32(&o.RTC_RESET_STATE.Reg) & 0x2000) >> 13
}
func (o *RTC_CNTL_Type) SetRTC_RESET_STATE_ALL_RESET_FLAG_PROCPU(value uint32) {
	volatile.StoreUint32(&o.RTC_RESET_STATE.Reg, volatile.LoadUint32(&o.RTC_RESET_STATE.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_CNTL_Type) GetRTC_RESET_STATE_ALL_RESET_FLAG_PROCPU() uint32 {
	return (volatile.LoadUint32(&o.RTC_RESET_STATE.Reg) & 0x4000) >> 14
}
func (o *RTC_CNTL_Type) SetRTC_RESET_STATE_ALL_RESET_FLAG_APPCPU(value uint32) {
	volatile.StoreUint32(&o.RTC_RESET_STATE.Reg, volatile.LoadUint32(&o.RTC_RESET_STATE.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetRTC_RESET_STATE_ALL_RESET_FLAG_APPCPU() uint32 {
	return (volatile.LoadUint32(&o.RTC_RESET_STATE.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetRTC_RESET_STATE_ALL_RESET_FLAG_CLR_PROCPU(value uint32) {
	volatile.StoreUint32(&o.RTC_RESET_STATE.Reg, volatile.LoadUint32(&o.RTC_RESET_STATE.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_CNTL_Type) GetRTC_RESET_STATE_ALL_RESET_FLAG_CLR_PROCPU() uint32 {
	return (volatile.LoadUint32(&o.RTC_RESET_STATE.Reg) & 0x10000) >> 16
}
func (o *RTC_CNTL_Type) SetRTC_RESET_STATE_ALL_RESET_FLAG_CLR_APPCPU(value uint32) {
	volatile.StoreUint32(&o.RTC_RESET_STATE.Reg, volatile.LoadUint32(&o.RTC_RESET_STATE.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_CNTL_Type) GetRTC_RESET_STATE_ALL_RESET_FLAG_CLR_APPCPU() uint32 {
	return (volatile.LoadUint32(&o.RTC_RESET_STATE.Reg) & 0x20000) >> 17
}
func (o *RTC_CNTL_Type) SetRTC_RESET_STATE_OCD_HALT_ON_RESET_APPCPU(value uint32) {
	volatile.StoreUint32(&o.RTC_RESET_STATE.Reg, volatile.LoadUint32(&o.RTC_RESET_STATE.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_CNTL_Type) GetRTC_RESET_STATE_OCD_HALT_ON_RESET_APPCPU() uint32 {
	return (volatile.LoadUint32(&o.RTC_RESET_STATE.Reg) & 0x40000) >> 18
}
func (o *RTC_CNTL_Type) SetRTC_RESET_STATE_OCD_HALT_ON_RESET_PROCPU(value uint32) {
	volatile.StoreUint32(&o.RTC_RESET_STATE.Reg, volatile.LoadUint32(&o.RTC_RESET_STATE.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_CNTL_Type) GetRTC_RESET_STATE_OCD_HALT_ON_RESET_PROCPU() uint32 {
	return (volatile.LoadUint32(&o.RTC_RESET_STATE.Reg) & 0x80000) >> 19
}
func (o *RTC_CNTL_Type) SetRTC_RESET_STATE_JTAG_RESET_FLAG_PROCPU(value uint32) {
	volatile.StoreUint32(&o.RTC_RESET_STATE.Reg, volatile.LoadUint32(&o.RTC_RESET_STATE.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetRTC_RESET_STATE_JTAG_RESET_FLAG_PROCPU() uint32 {
	return (volatile.LoadUint32(&o.RTC_RESET_STATE.Reg) & 0x100000) >> 20
}
func (o *RTC_CNTL_Type) SetRTC_RESET_STATE_JTAG_RESET_FLAG_APPCPU(value uint32) {
	volatile.StoreUint32(&o.RTC_RESET_STATE.Reg, volatile.LoadUint32(&o.RTC_RESET_STATE.Reg)&^(0x200000)|value<<21)
}
func (o *RTC_CNTL_Type) GetRTC_RESET_STATE_JTAG_RESET_FLAG_APPCPU() uint32 {
	return (volatile.LoadUint32(&o.RTC_RESET_STATE.Reg) & 0x200000) >> 21
}
func (o *RTC_CNTL_Type) SetRTC_RESET_STATE_JTAG_RESET_FLAG_CLR_PROCPU(value uint32) {
	volatile.StoreUint32(&o.RTC_RESET_STATE.Reg, volatile.LoadUint32(&o.RTC_RESET_STATE.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_CNTL_Type) GetRTC_RESET_STATE_JTAG_RESET_FLAG_CLR_PROCPU() uint32 {
	return (volatile.LoadUint32(&o.RTC_RESET_STATE.Reg) & 0x400000) >> 22
}
func (o *RTC_CNTL_Type) SetRTC_RESET_STATE_JTAG_RESET_FLAG_CLR_APPCPU(value uint32) {
	volatile.StoreUint32(&o.RTC_RESET_STATE.Reg, volatile.LoadUint32(&o.RTC_RESET_STATE.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_CNTL_Type) GetRTC_RESET_STATE_JTAG_RESET_FLAG_CLR_APPCPU() uint32 {
	return (volatile.LoadUint32(&o.RTC_RESET_STATE.Reg) & 0x800000) >> 23
}
func (o *RTC_CNTL_Type) SetRTC_RESET_STATE_RTC_DRESET_MASK_APPCPU(value uint32) {
	volatile.StoreUint32(&o.RTC_RESET_STATE.Reg, volatile.LoadUint32(&o.RTC_RESET_STATE.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_CNTL_Type) GetRTC_RESET_STATE_RTC_DRESET_MASK_APPCPU() uint32 {
	return (volatile.LoadUint32(&o.RTC_RESET_STATE.Reg) & 0x1000000) >> 24
}
func (o *RTC_CNTL_Type) SetRTC_RESET_STATE_RTC_DRESET_MASK_PROCPU(value uint32) {
	volatile.StoreUint32(&o.RTC_RESET_STATE.Reg, volatile.LoadUint32(&o.RTC_RESET_STATE.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_CNTL_Type) GetRTC_RESET_STATE_RTC_DRESET_MASK_PROCPU() uint32 {
	return (volatile.LoadUint32(&o.RTC_RESET_STATE.Reg) & 0x2000000) >> 25
}

// RTC_CNTL.RTC_WAKEUP_STATE: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_WAKEUP_STATE_RTC_WAKEUP_ENA(value uint32) {
	volatile.StoreUint32(&o.RTC_WAKEUP_STATE.Reg, volatile.LoadUint32(&o.RTC_WAKEUP_STATE.Reg)&^(0xffff8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetRTC_WAKEUP_STATE_RTC_WAKEUP_ENA() uint32 {
	return (volatile.LoadUint32(&o.RTC_WAKEUP_STATE.Reg) & 0xffff8000) >> 15
}

// RTC_CNTL.INT_ENA_RTC: rtc configure register
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_SLP_WAKEUP_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_SLP_WAKEUP_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA_RTC.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_SLP_REJECT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_SLP_REJECT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_RTC_WDT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_RTC_WDT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_RTC_BROWN_OUT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_RTC_BROWN_OUT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_RTC_MAIN_TIMER_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_RTC_MAIN_TIMER_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_RTC_SWD_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_RTC_SWD_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_RTC_XTAL32K_DEAD_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_RTC_XTAL32K_DEAD_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC.Reg) & 0x10000) >> 16
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_RTC_GLITCH_DET_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_RTC_GLITCH_DET_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC.Reg) & 0x80000) >> 19
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_RTC_BBPLL_CAL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_RTC_BBPLL_CAL_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC.Reg) & 0x100000) >> 20
}

// RTC_CNTL.INT_RAW_RTC: rtc configure register
func (o *RTC_CNTL_Type) SetINT_RAW_RTC_SLP_WAKEUP_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_RTC.Reg, volatile.LoadUint32(&o.INT_RAW_RTC.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetINT_RAW_RTC_SLP_WAKEUP_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW_RTC.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetINT_RAW_RTC_SLP_REJECT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_RTC.Reg, volatile.LoadUint32(&o.INT_RAW_RTC.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetINT_RAW_RTC_SLP_REJECT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_RTC.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetINT_RAW_RTC_RTC_WDT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_RTC.Reg, volatile.LoadUint32(&o.INT_RAW_RTC.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetINT_RAW_RTC_RTC_WDT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_RTC.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetINT_RAW_RTC_RTC_BROWN_OUT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_RTC.Reg, volatile.LoadUint32(&o.INT_RAW_RTC.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetINT_RAW_RTC_RTC_BROWN_OUT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_RTC.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetINT_RAW_RTC_RTC_MAIN_TIMER_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_RTC.Reg, volatile.LoadUint32(&o.INT_RAW_RTC.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetINT_RAW_RTC_RTC_MAIN_TIMER_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_RTC.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetINT_RAW_RTC_RTC_SWD_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_RTC.Reg, volatile.LoadUint32(&o.INT_RAW_RTC.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetINT_RAW_RTC_RTC_SWD_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_RTC.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetINT_RAW_RTC_RTC_XTAL32K_DEAD_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_RTC.Reg, volatile.LoadUint32(&o.INT_RAW_RTC.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_CNTL_Type) GetINT_RAW_RTC_RTC_XTAL32K_DEAD_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_RTC.Reg) & 0x10000) >> 16
}
func (o *RTC_CNTL_Type) SetINT_RAW_RTC_RTC_GLITCH_DET_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_RTC.Reg, volatile.LoadUint32(&o.INT_RAW_RTC.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_CNTL_Type) GetINT_RAW_RTC_RTC_GLITCH_DET_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_RTC.Reg) & 0x80000) >> 19
}
func (o *RTC_CNTL_Type) SetINT_RAW_RTC_RTC_BBPLL_CAL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_RTC.Reg, volatile.LoadUint32(&o.INT_RAW_RTC.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetINT_RAW_RTC_RTC_BBPLL_CAL_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_RTC.Reg) & 0x100000) >> 20
}

// RTC_CNTL.INT_ST_RTC: rtc configure register
func (o *RTC_CNTL_Type) SetINT_ST_RTC_SLP_WAKEUP_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_RTC.Reg, volatile.LoadUint32(&o.INT_ST_RTC.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetINT_ST_RTC_SLP_WAKEUP_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST_RTC.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetINT_ST_RTC_SLP_REJECT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_RTC.Reg, volatile.LoadUint32(&o.INT_ST_RTC.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetINT_ST_RTC_SLP_REJECT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_RTC.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetINT_ST_RTC_RTC_WDT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_RTC.Reg, volatile.LoadUint32(&o.INT_ST_RTC.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetINT_ST_RTC_RTC_WDT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_RTC.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetINT_ST_RTC_RTC_BROWN_OUT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_RTC.Reg, volatile.LoadUint32(&o.INT_ST_RTC.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetINT_ST_RTC_RTC_BROWN_OUT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_RTC.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetINT_ST_RTC_RTC_MAIN_TIMER_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_RTC.Reg, volatile.LoadUint32(&o.INT_ST_RTC.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetINT_ST_RTC_RTC_MAIN_TIMER_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_RTC.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetINT_ST_RTC_RTC_SWD_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_RTC.Reg, volatile.LoadUint32(&o.INT_ST_RTC.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetINT_ST_RTC_RTC_SWD_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_RTC.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetINT_ST_RTC_RTC_XTAL32K_DEAD_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_RTC.Reg, volatile.LoadUint32(&o.INT_ST_RTC.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_CNTL_Type) GetINT_ST_RTC_RTC_XTAL32K_DEAD_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_RTC.Reg) & 0x10000) >> 16
}
func (o *RTC_CNTL_Type) SetINT_ST_RTC_RTC_GLITCH_DET_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_RTC.Reg, volatile.LoadUint32(&o.INT_ST_RTC.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_CNTL_Type) GetINT_ST_RTC_RTC_GLITCH_DET_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_RTC.Reg) & 0x80000) >> 19
}
func (o *RTC_CNTL_Type) SetINT_ST_RTC_RTC_BBPLL_CAL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_RTC.Reg, volatile.LoadUint32(&o.INT_ST_RTC.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetINT_ST_RTC_RTC_BBPLL_CAL_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_RTC.Reg) & 0x100000) >> 20
}

// RTC_CNTL.INT_CLR_RTC: rtc configure register
func (o *RTC_CNTL_Type) SetINT_CLR_RTC_SLP_WAKEUP_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_RTC.Reg, volatile.LoadUint32(&o.INT_CLR_RTC.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetINT_CLR_RTC_SLP_WAKEUP_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR_RTC.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetINT_CLR_RTC_SLP_REJECT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_RTC.Reg, volatile.LoadUint32(&o.INT_CLR_RTC.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetINT_CLR_RTC_SLP_REJECT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_RTC.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetINT_CLR_RTC_RTC_WDT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_RTC.Reg, volatile.LoadUint32(&o.INT_CLR_RTC.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetINT_CLR_RTC_RTC_WDT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_RTC.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetINT_CLR_RTC_RTC_BROWN_OUT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_RTC.Reg, volatile.LoadUint32(&o.INT_CLR_RTC.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetINT_CLR_RTC_RTC_BROWN_OUT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_RTC.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetINT_CLR_RTC_RTC_MAIN_TIMER_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_RTC.Reg, volatile.LoadUint32(&o.INT_CLR_RTC.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetINT_CLR_RTC_RTC_MAIN_TIMER_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_RTC.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetINT_CLR_RTC_RTC_SWD_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_RTC.Reg, volatile.LoadUint32(&o.INT_CLR_RTC.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetINT_CLR_RTC_RTC_SWD_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_RTC.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetINT_CLR_RTC_RTC_XTAL32K_DEAD_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_RTC.Reg, volatile.LoadUint32(&o.INT_CLR_RTC.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_CNTL_Type) GetINT_CLR_RTC_RTC_XTAL32K_DEAD_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_RTC.Reg) & 0x10000) >> 16
}
func (o *RTC_CNTL_Type) SetINT_CLR_RTC_RTC_GLITCH_DET_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_RTC.Reg, volatile.LoadUint32(&o.INT_CLR_RTC.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_CNTL_Type) GetINT_CLR_RTC_RTC_GLITCH_DET_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_RTC.Reg) & 0x80000) >> 19
}
func (o *RTC_CNTL_Type) SetINT_CLR_RTC_RTC_BBPLL_CAL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_RTC.Reg, volatile.LoadUint32(&o.INT_CLR_RTC.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetINT_CLR_RTC_RTC_BBPLL_CAL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_RTC.Reg) & 0x100000) >> 20
}

// RTC_CNTL.RTC_STORE0: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_STORE0(value uint32) {
	volatile.StoreUint32(&o.RTC_STORE0.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_STORE0() uint32 {
	return volatile.LoadUint32(&o.RTC_STORE0.Reg)
}

// RTC_CNTL.RTC_STORE1: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_STORE1(value uint32) {
	volatile.StoreUint32(&o.RTC_STORE1.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_STORE1() uint32 {
	return volatile.LoadUint32(&o.RTC_STORE1.Reg)
}

// RTC_CNTL.RTC_STORE2: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_STORE2(value uint32) {
	volatile.StoreUint32(&o.RTC_STORE2.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_STORE2() uint32 {
	return volatile.LoadUint32(&o.RTC_STORE2.Reg)
}

// RTC_CNTL.RTC_STORE3: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_STORE3(value uint32) {
	volatile.StoreUint32(&o.RTC_STORE3.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_STORE3() uint32 {
	return volatile.LoadUint32(&o.RTC_STORE3.Reg)
}

// RTC_CNTL.RTC_EXT_XTL_CONF: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_EXT_XTL_CONF_XTAL32K_WDT_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_XTL_CONF_XTAL32K_WDT_EN() uint32 {
	return volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetRTC_EXT_XTL_CONF_XTAL32K_WDT_CLK_FO(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_XTL_CONF_XTAL32K_WDT_CLK_FO() uint32 {
	return (volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetRTC_EXT_XTL_CONF_XTAL32K_WDT_RESET(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg)&^(0x4)|value<<2)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_XTL_CONF_XTAL32K_WDT_RESET() uint32 {
	return (volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg) & 0x4) >> 2
}
func (o *RTC_CNTL_Type) SetRTC_EXT_XTL_CONF_XTAL32K_EXT_CLK_FO(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_XTL_CONF_XTAL32K_EXT_CLK_FO() uint32 {
	return (volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetRTC_EXT_XTL_CONF_XTAL32K_AUTO_BACKUP(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg)&^(0x10)|value<<4)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_XTL_CONF_XTAL32K_AUTO_BACKUP() uint32 {
	return (volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg) & 0x10) >> 4
}
func (o *RTC_CNTL_Type) SetRTC_EXT_XTL_CONF_XTAL32K_AUTO_RESTART(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg)&^(0x20)|value<<5)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_XTL_CONF_XTAL32K_AUTO_RESTART() uint32 {
	return (volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg) & 0x20) >> 5
}
func (o *RTC_CNTL_Type) SetRTC_EXT_XTL_CONF_XTAL32K_AUTO_RETURN(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg)&^(0x40)|value<<6)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_XTL_CONF_XTAL32K_AUTO_RETURN() uint32 {
	return (volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg) & 0x40) >> 6
}
func (o *RTC_CNTL_Type) SetRTC_EXT_XTL_CONF_XTAL32K_XPD_FORCE(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg)&^(0x80)|value<<7)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_XTL_CONF_XTAL32K_XPD_FORCE() uint32 {
	return (volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg) & 0x80) >> 7
}
func (o *RTC_CNTL_Type) SetRTC_EXT_XTL_CONF_ENCKINIT_XTAL_32K(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg)&^(0x100)|value<<8)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_XTL_CONF_ENCKINIT_XTAL_32K() uint32 {
	return (volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg) & 0x100) >> 8
}
func (o *RTC_CNTL_Type) SetRTC_EXT_XTL_CONF_DBUF_XTAL_32K(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_XTL_CONF_DBUF_XTAL_32K() uint32 {
	return (volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetRTC_EXT_XTL_CONF_DGM_XTAL_32K(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg)&^(0x1c00)|value<<10)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_XTL_CONF_DGM_XTAL_32K() uint32 {
	return (volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg) & 0x1c00) >> 10
}
func (o *RTC_CNTL_Type) SetRTC_EXT_XTL_CONF_DRES_XTAL_32K(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_XTL_CONF_DRES_XTAL_32K() uint32 {
	return (volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg) & 0xe000) >> 13
}
func (o *RTC_CNTL_Type) SetRTC_EXT_XTL_CONF_XPD_XTAL_32K(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_XTL_CONF_XPD_XTAL_32K() uint32 {
	return (volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg) & 0x10000) >> 16
}
func (o *RTC_CNTL_Type) SetRTC_EXT_XTL_CONF_DAC_XTAL_32K(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg)&^(0xe0000)|value<<17)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_XTL_CONF_DAC_XTAL_32K() uint32 {
	return (volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg) & 0xe0000) >> 17
}
func (o *RTC_CNTL_Type) SetRTC_EXT_XTL_CONF_RTC_WDT_STATE(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg)&^(0x700000)|value<<20)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_XTL_CONF_RTC_WDT_STATE() uint32 {
	return (volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg) & 0x700000) >> 20
}
func (o *RTC_CNTL_Type) SetRTC_EXT_XTL_CONF_RTC_XTAL32K_GPIO_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_XTL_CONF_RTC_XTAL32K_GPIO_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg) & 0x800000) >> 23
}
func (o *RTC_CNTL_Type) SetRTC_EXT_XTL_CONF_XTL_EXT_CTR_LV(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_XTL_CONF_XTL_EXT_CTR_LV() uint32 {
	return (volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetRTC_EXT_XTL_CONF_XTL_EXT_CTR_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_XTL_CONF_XTL_EXT_CTR_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_EXT_XTL_CONF.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.RTC_EXT_WAKEUP_CONF: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_EXT_WAKEUP_CONF_GPIO_WAKEUP_FILTER(value uint32) {
	volatile.StoreUint32(&o.RTC_EXT_WAKEUP_CONF.Reg, volatile.LoadUint32(&o.RTC_EXT_WAKEUP_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetRTC_EXT_WAKEUP_CONF_GPIO_WAKEUP_FILTER() uint32 {
	return (volatile.LoadUint32(&o.RTC_EXT_WAKEUP_CONF.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.RTC_SLP_REJECT_CONF: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_SLP_REJECT_CONF_RTC_SLEEP_REJECT_ENA(value uint32) {
	volatile.StoreUint32(&o.RTC_SLP_REJECT_CONF.Reg, volatile.LoadUint32(&o.RTC_SLP_REJECT_CONF.Reg)&^(0x3ffff000)|value<<12)
}
func (o *RTC_CNTL_Type) GetRTC_SLP_REJECT_CONF_RTC_SLEEP_REJECT_ENA() uint32 {
	return (volatile.LoadUint32(&o.RTC_SLP_REJECT_CONF.Reg) & 0x3ffff000) >> 12
}
func (o *RTC_CNTL_Type) SetRTC_SLP_REJECT_CONF_LIGHT_SLP_REJECT_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_SLP_REJECT_CONF.Reg, volatile.LoadUint32(&o.RTC_SLP_REJECT_CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetRTC_SLP_REJECT_CONF_LIGHT_SLP_REJECT_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_SLP_REJECT_CONF.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetRTC_SLP_REJECT_CONF_DEEP_SLP_REJECT_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_SLP_REJECT_CONF.Reg, volatile.LoadUint32(&o.RTC_SLP_REJECT_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetRTC_SLP_REJECT_CONF_DEEP_SLP_REJECT_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_SLP_REJECT_CONF.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.RTC_CPU_PERIOD_CONF: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_CPU_PERIOD_CONF_RTC_CPUSEL_CONF(value uint32) {
	volatile.StoreUint32(&o.RTC_CPU_PERIOD_CONF.Reg, volatile.LoadUint32(&o.RTC_CPU_PERIOD_CONF.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetRTC_CPU_PERIOD_CONF_RTC_CPUSEL_CONF() uint32 {
	return (volatile.LoadUint32(&o.RTC_CPU_PERIOD_CONF.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetRTC_CPU_PERIOD_CONF_RTC_CPUPERIOD_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_CPU_PERIOD_CONF.Reg, volatile.LoadUint32(&o.RTC_CPU_PERIOD_CONF.Reg)&^(0xc0000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetRTC_CPU_PERIOD_CONF_RTC_CPUPERIOD_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTC_CPU_PERIOD_CONF.Reg) & 0xc0000000) >> 30
}

// RTC_CNTL.RTC_CLK_CONF: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_EFUSE_CLK_FORCE_GATING(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_EFUSE_CLK_FORCE_GATING() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_EFUSE_CLK_FORCE_NOGATING(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0x4)|value<<2)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_EFUSE_CLK_FORCE_NOGATING() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0x4) >> 2
}
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_CK8M_DIV_SEL_VLD(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_CK8M_DIV_SEL_VLD() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_CK8M_DIV(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0x30)|value<<4)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_CK8M_DIV() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0x30) >> 4
}
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_ENB_CK8M(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0x40)|value<<6)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_ENB_CK8M() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0x40) >> 6
}
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_ENB_CK8M_DIV(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0x80)|value<<7)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_ENB_CK8M_DIV() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0x80) >> 7
}
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_DIG_XTAL32K_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0x100)|value<<8)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_DIG_XTAL32K_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0x100) >> 8
}
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_DIG_CLK8M_D256_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_DIG_CLK8M_D256_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_DIG_CLK8M_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_DIG_CLK8M_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_CK8M_DIV_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_CK8M_DIV_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0x7000) >> 12
}
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_XTAL_FORCE_NOGATING(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_XTAL_FORCE_NOGATING() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_CK8M_FORCE_NOGATING(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_CK8M_FORCE_NOGATING() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0x10000) >> 16
}
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_CK8M_DFREQ(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0x1fe0000)|value<<17)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_CK8M_DFREQ() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0x1fe0000) >> 17
}
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_CK8M_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_CK8M_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0x2000000) >> 25
}
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_CK8M_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_CK8M_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0x4000000) >> 26
}
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_XTAL_GLOBAL_FORCE_GATING(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_XTAL_GLOBAL_FORCE_GATING() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0x8000000) >> 27
}
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_XTAL_GLOBAL_FORCE_NOGATING(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_XTAL_GLOBAL_FORCE_NOGATING() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_FAST_CLK_RTC_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_FAST_CLK_RTC_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetRTC_CLK_CONF_ANA_CLK_RTC_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_CLK_CONF.Reg)&^(0xc0000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetRTC_CLK_CONF_ANA_CLK_RTC_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTC_CLK_CONF.Reg) & 0xc0000000) >> 30
}

// RTC_CNTL.RTC_SLOW_CLK_CONF: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_SLOW_CLK_CONF_RTC_ANA_CLK_DIV_VLD(value uint32) {
	volatile.StoreUint32(&o.RTC_SLOW_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_SLOW_CLK_CONF.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_CNTL_Type) GetRTC_SLOW_CLK_CONF_RTC_ANA_CLK_DIV_VLD() uint32 {
	return (volatile.LoadUint32(&o.RTC_SLOW_CLK_CONF.Reg) & 0x400000) >> 22
}
func (o *RTC_CNTL_Type) SetRTC_SLOW_CLK_CONF_RTC_ANA_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.RTC_SLOW_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_SLOW_CLK_CONF.Reg)&^(0x7f800000)|value<<23)
}
func (o *RTC_CNTL_Type) GetRTC_SLOW_CLK_CONF_RTC_ANA_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.RTC_SLOW_CLK_CONF.Reg) & 0x7f800000) >> 23
}
func (o *RTC_CNTL_Type) SetRTC_SLOW_CLK_CONF_RTC_SLOW_CLK_NEXT_EDGE(value uint32) {
	volatile.StoreUint32(&o.RTC_SLOW_CLK_CONF.Reg, volatile.LoadUint32(&o.RTC_SLOW_CLK_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetRTC_SLOW_CLK_CONF_RTC_SLOW_CLK_NEXT_EDGE() uint32 {
	return (volatile.LoadUint32(&o.RTC_SLOW_CLK_CONF.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.RTC_SDIO_CONF: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_SDIO_CONF_SDIO_TIMER_TARGET(value uint32) {
	volatile.StoreUint32(&o.RTC_SDIO_CONF.Reg, volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg)&^(0xff)|value)
}
func (o *RTC_CNTL_Type) GetRTC_SDIO_CONF_SDIO_TIMER_TARGET() uint32 {
	return volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg) & 0xff
}
func (o *RTC_CNTL_Type) SetRTC_SDIO_CONF_SDIO_DTHDRV(value uint32) {
	volatile.StoreUint32(&o.RTC_SDIO_CONF.Reg, volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg)&^(0x600)|value<<9)
}
func (o *RTC_CNTL_Type) GetRTC_SDIO_CONF_SDIO_DTHDRV() uint32 {
	return (volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg) & 0x600) >> 9
}
func (o *RTC_CNTL_Type) SetRTC_SDIO_CONF_SDIO_DCAP(value uint32) {
	volatile.StoreUint32(&o.RTC_SDIO_CONF.Reg, volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg)&^(0x1800)|value<<11)
}
func (o *RTC_CNTL_Type) GetRTC_SDIO_CONF_SDIO_DCAP() uint32 {
	return (volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg) & 0x1800) >> 11
}
func (o *RTC_CNTL_Type) SetRTC_SDIO_CONF_SDIO_INITI(value uint32) {
	volatile.StoreUint32(&o.RTC_SDIO_CONF.Reg, volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg)&^(0x6000)|value<<13)
}
func (o *RTC_CNTL_Type) GetRTC_SDIO_CONF_SDIO_INITI() uint32 {
	return (volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg) & 0x6000) >> 13
}
func (o *RTC_CNTL_Type) SetRTC_SDIO_CONF_SDIO_EN_INITI(value uint32) {
	volatile.StoreUint32(&o.RTC_SDIO_CONF.Reg, volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetRTC_SDIO_CONF_SDIO_EN_INITI() uint32 {
	return (volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetRTC_SDIO_CONF_SDIO_DCURLIM(value uint32) {
	volatile.StoreUint32(&o.RTC_SDIO_CONF.Reg, volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg)&^(0x70000)|value<<16)
}
func (o *RTC_CNTL_Type) GetRTC_SDIO_CONF_SDIO_DCURLIM() uint32 {
	return (volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg) & 0x70000) >> 16
}
func (o *RTC_CNTL_Type) SetRTC_SDIO_CONF_SDIO_MODECURLIM(value uint32) {
	volatile.StoreUint32(&o.RTC_SDIO_CONF.Reg, volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_CNTL_Type) GetRTC_SDIO_CONF_SDIO_MODECURLIM() uint32 {
	return (volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg) & 0x80000) >> 19
}
func (o *RTC_CNTL_Type) SetRTC_SDIO_CONF_SDIO_ENCURLIM(value uint32) {
	volatile.StoreUint32(&o.RTC_SDIO_CONF.Reg, volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetRTC_SDIO_CONF_SDIO_ENCURLIM() uint32 {
	return (volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg) & 0x100000) >> 20
}
func (o *RTC_CNTL_Type) SetRTC_SDIO_CONF_SDIO_REG_PD_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_SDIO_CONF.Reg, volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg)&^(0x200000)|value<<21)
}
func (o *RTC_CNTL_Type) GetRTC_SDIO_CONF_SDIO_REG_PD_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg) & 0x200000) >> 21
}
func (o *RTC_CNTL_Type) SetRTC_SDIO_CONF_SDIO_FORCE(value uint32) {
	volatile.StoreUint32(&o.RTC_SDIO_CONF.Reg, volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_CNTL_Type) GetRTC_SDIO_CONF_SDIO_FORCE() uint32 {
	return (volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg) & 0x400000) >> 22
}
func (o *RTC_CNTL_Type) SetRTC_SDIO_CONF_SDIO_TIEH(value uint32) {
	volatile.StoreUint32(&o.RTC_SDIO_CONF.Reg, volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_CNTL_Type) GetRTC_SDIO_CONF_SDIO_TIEH() uint32 {
	return (volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg) & 0x800000) >> 23
}
func (o *RTC_CNTL_Type) SetRTC_SDIO_CONF__1P8_READY(value uint32) {
	volatile.StoreUint32(&o.RTC_SDIO_CONF.Reg, volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_CNTL_Type) GetRTC_SDIO_CONF__1P8_READY() uint32 {
	return (volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg) & 0x1000000) >> 24
}
func (o *RTC_CNTL_Type) SetRTC_SDIO_CONF_DREFL_SDIO(value uint32) {
	volatile.StoreUint32(&o.RTC_SDIO_CONF.Reg, volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg)&^(0x6000000)|value<<25)
}
func (o *RTC_CNTL_Type) GetRTC_SDIO_CONF_DREFL_SDIO() uint32 {
	return (volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg) & 0x6000000) >> 25
}
func (o *RTC_CNTL_Type) SetRTC_SDIO_CONF_DREFM_SDIO(value uint32) {
	volatile.StoreUint32(&o.RTC_SDIO_CONF.Reg, volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg)&^(0x18000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetRTC_SDIO_CONF_DREFM_SDIO() uint32 {
	return (volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg) & 0x18000000) >> 27
}
func (o *RTC_CNTL_Type) SetRTC_SDIO_CONF_DREFH_SDIO(value uint32) {
	volatile.StoreUint32(&o.RTC_SDIO_CONF.Reg, volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg)&^(0x60000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetRTC_SDIO_CONF_DREFH_SDIO() uint32 {
	return (volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg) & 0x60000000) >> 29
}
func (o *RTC_CNTL_Type) SetRTC_SDIO_CONF_XPD_SDIO(value uint32) {
	volatile.StoreUint32(&o.RTC_SDIO_CONF.Reg, volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetRTC_SDIO_CONF_XPD_SDIO() uint32 {
	return (volatile.LoadUint32(&o.RTC_SDIO_CONF.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.RTC_BIAS_CONF: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_BIAS_CONF_DG_VDD_DRV_B_SLP(value uint32) {
	volatile.StoreUint32(&o.RTC_BIAS_CONF.Reg, volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg)&^(0xff)|value)
}
func (o *RTC_CNTL_Type) GetRTC_BIAS_CONF_DG_VDD_DRV_B_SLP() uint32 {
	return volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg) & 0xff
}
func (o *RTC_CNTL_Type) SetRTC_BIAS_CONF_DG_VDD_DRV_B_SLP_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_BIAS_CONF.Reg, volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg)&^(0x100)|value<<8)
}
func (o *RTC_CNTL_Type) GetRTC_BIAS_CONF_DG_VDD_DRV_B_SLP_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg) & 0x100) >> 8
}
func (o *RTC_CNTL_Type) SetRTC_BIAS_CONF_BIAS_BUF_IDLE(value uint32) {
	volatile.StoreUint32(&o.RTC_BIAS_CONF.Reg, volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetRTC_BIAS_CONF_BIAS_BUF_IDLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetRTC_BIAS_CONF_BIAS_BUF_WAKE(value uint32) {
	volatile.StoreUint32(&o.RTC_BIAS_CONF.Reg, volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg)&^(0x800)|value<<11)
}
func (o *RTC_CNTL_Type) GetRTC_BIAS_CONF_BIAS_BUF_WAKE() uint32 {
	return (volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg) & 0x800) >> 11
}
func (o *RTC_CNTL_Type) SetRTC_BIAS_CONF_BIAS_BUF_DEEP_SLP(value uint32) {
	volatile.StoreUint32(&o.RTC_BIAS_CONF.Reg, volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_CNTL_Type) GetRTC_BIAS_CONF_BIAS_BUF_DEEP_SLP() uint32 {
	return (volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg) & 0x1000) >> 12
}
func (o *RTC_CNTL_Type) SetRTC_BIAS_CONF_BIAS_BUF_MONITOR(value uint32) {
	volatile.StoreUint32(&o.RTC_BIAS_CONF.Reg, volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_CNTL_Type) GetRTC_BIAS_CONF_BIAS_BUF_MONITOR() uint32 {
	return (volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg) & 0x2000) >> 13
}
func (o *RTC_CNTL_Type) SetRTC_BIAS_CONF_PD_CUR_DEEP_SLP(value uint32) {
	volatile.StoreUint32(&o.RTC_BIAS_CONF.Reg, volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_CNTL_Type) GetRTC_BIAS_CONF_PD_CUR_DEEP_SLP() uint32 {
	return (volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg) & 0x4000) >> 14
}
func (o *RTC_CNTL_Type) SetRTC_BIAS_CONF_PD_CUR_MONITOR(value uint32) {
	volatile.StoreUint32(&o.RTC_BIAS_CONF.Reg, volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetRTC_BIAS_CONF_PD_CUR_MONITOR() uint32 {
	return (volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetRTC_BIAS_CONF_BIAS_SLEEP_DEEP_SLP(value uint32) {
	volatile.StoreUint32(&o.RTC_BIAS_CONF.Reg, volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_CNTL_Type) GetRTC_BIAS_CONF_BIAS_SLEEP_DEEP_SLP() uint32 {
	return (volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg) & 0x10000) >> 16
}
func (o *RTC_CNTL_Type) SetRTC_BIAS_CONF_BIAS_SLEEP_MONITOR(value uint32) {
	volatile.StoreUint32(&o.RTC_BIAS_CONF.Reg, volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_CNTL_Type) GetRTC_BIAS_CONF_BIAS_SLEEP_MONITOR() uint32 {
	return (volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg) & 0x20000) >> 17
}
func (o *RTC_CNTL_Type) SetRTC_BIAS_CONF_DBG_ATTEN_DEEP_SLP(value uint32) {
	volatile.StoreUint32(&o.RTC_BIAS_CONF.Reg, volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg)&^(0x3c0000)|value<<18)
}
func (o *RTC_CNTL_Type) GetRTC_BIAS_CONF_DBG_ATTEN_DEEP_SLP() uint32 {
	return (volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg) & 0x3c0000) >> 18
}
func (o *RTC_CNTL_Type) SetRTC_BIAS_CONF_DBG_ATTEN_MONITOR(value uint32) {
	volatile.StoreUint32(&o.RTC_BIAS_CONF.Reg, volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg)&^(0x3c00000)|value<<22)
}
func (o *RTC_CNTL_Type) GetRTC_BIAS_CONF_DBG_ATTEN_MONITOR() uint32 {
	return (volatile.LoadUint32(&o.RTC_BIAS_CONF.Reg) & 0x3c00000) >> 22
}

// RTC_CNTL.RTC: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_DIG_REG_CAL_EN(value uint32) {
	volatile.StoreUint32(&o.RTC.Reg, volatile.LoadUint32(&o.RTC.Reg)&^(0x80)|value<<7)
}
func (o *RTC_CNTL_Type) GetRTC_DIG_REG_CAL_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC.Reg) & 0x80) >> 7
}
func (o *RTC_CNTL_Type) SetRTC_SCK_DCAP(value uint32) {
	volatile.StoreUint32(&o.RTC.Reg, volatile.LoadUint32(&o.RTC.Reg)&^(0x3fc000)|value<<14)
}
func (o *RTC_CNTL_Type) GetRTC_SCK_DCAP() uint32 {
	return (volatile.LoadUint32(&o.RTC.Reg) & 0x3fc000) >> 14
}
func (o *RTC_CNTL_Type) SetRTC_DBOOST_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.RTC.Reg, volatile.LoadUint32(&o.RTC.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetRTC_DBOOST_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.RTC.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetRTC_DBOOST_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.RTC.Reg, volatile.LoadUint32(&o.RTC.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetRTC_DBOOST_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.RTC.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetRTC_REGULATOR_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.RTC.Reg, volatile.LoadUint32(&o.RTC.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetRTC_REGULATOR_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.RTC.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetRTC_REGULATOR_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.RTC.Reg, volatile.LoadUint32(&o.RTC.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetRTC_REGULATOR_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.RTC.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.RTC_PWC: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_PWC_RTC_PAD_FORCE_HOLD(value uint32) {
	volatile.StoreUint32(&o.RTC_PWC.Reg, volatile.LoadUint32(&o.RTC_PWC.Reg)&^(0x200000)|value<<21)
}
func (o *RTC_CNTL_Type) GetRTC_PWC_RTC_PAD_FORCE_HOLD() uint32 {
	return (volatile.LoadUint32(&o.RTC_PWC.Reg) & 0x200000) >> 21
}

// RTC_CNTL.DIG_PWC: rtc configure register
func (o *RTC_CNTL_Type) SetDIG_PWC_VDD_SPI_PWR_DRV(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x3)|value)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_VDD_SPI_PWR_DRV() uint32 {
	return volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x3
}
func (o *RTC_CNTL_Type) SetDIG_PWC_VDD_SPI_PWR_FORCE(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x4)|value<<2)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_VDD_SPI_PWR_FORCE() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x4) >> 2
}
func (o *RTC_CNTL_Type) SetDIG_PWC_LSLP_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_LSLP_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetDIG_PWC_LSLP_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x10)|value<<4)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_LSLP_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x10) >> 4
}
func (o *RTC_CNTL_Type) SetDIG_PWC_BT_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x800)|value<<11)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_BT_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x800) >> 11
}
func (o *RTC_CNTL_Type) SetDIG_PWC_BT_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_BT_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x1000) >> 12
}
func (o *RTC_CNTL_Type) SetDIG_PWC_DG_PERI_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_DG_PERI_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x2000) >> 13
}
func (o *RTC_CNTL_Type) SetDIG_PWC_DG_PERI_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_DG_PERI_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x4000) >> 14
}
func (o *RTC_CNTL_Type) SetDIG_PWC_RTC_FASTMEM_FORCE_LPD(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_RTC_FASTMEM_FORCE_LPD() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetDIG_PWC_RTC_FASTMEM_FORCE_LPU(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_RTC_FASTMEM_FORCE_LPU() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x10000) >> 16
}
func (o *RTC_CNTL_Type) SetDIG_PWC_WIFI_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_WIFI_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x20000) >> 17
}
func (o *RTC_CNTL_Type) SetDIG_PWC_WIFI_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_WIFI_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x40000) >> 18
}
func (o *RTC_CNTL_Type) SetDIG_PWC_DG_WRAP_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_DG_WRAP_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x80000) >> 19
}
func (o *RTC_CNTL_Type) SetDIG_PWC_DG_WRAP_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_DG_WRAP_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x100000) >> 20
}
func (o *RTC_CNTL_Type) SetDIG_PWC_CPU_TOP_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x200000)|value<<21)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_CPU_TOP_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x200000) >> 21
}
func (o *RTC_CNTL_Type) SetDIG_PWC_CPU_TOP_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_CPU_TOP_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x400000) >> 22
}
func (o *RTC_CNTL_Type) SetDIG_PWC_BT_PD_EN(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_BT_PD_EN() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x8000000) >> 27
}
func (o *RTC_CNTL_Type) SetDIG_PWC_DG_PERI_PD_EN(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_DG_PERI_PD_EN() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetDIG_PWC_CPU_TOP_PD_EN(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_CPU_TOP_PD_EN() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetDIG_PWC_WIFI_PD_EN(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_WIFI_PD_EN() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetDIG_PWC_DG_WRAP_PD_EN(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_DG_WRAP_PD_EN() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.DIG_ISO: rtc configure register
func (o *RTC_CNTL_Type) SetDIG_ISO_FORCE_OFF(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x80)|value<<7)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_FORCE_OFF() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x80) >> 7
}
func (o *RTC_CNTL_Type) SetDIG_ISO_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x100)|value<<8)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x100) >> 8
}
func (o *RTC_CNTL_Type) SetDIG_ISO_DG_PAD_AUTOHOLD(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_DG_PAD_AUTOHOLD() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetDIG_ISO_CLR_DG_PAD_AUTOHOLD(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_CLR_DG_PAD_AUTOHOLD() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetDIG_ISO_DG_PAD_AUTOHOLD_EN(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x800)|value<<11)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_DG_PAD_AUTOHOLD_EN() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x800) >> 11
}
func (o *RTC_CNTL_Type) SetDIG_ISO_DG_PAD_FORCE_NOISO(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_DG_PAD_FORCE_NOISO() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x1000) >> 12
}
func (o *RTC_CNTL_Type) SetDIG_ISO_DG_PAD_FORCE_ISO(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_DG_PAD_FORCE_ISO() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x2000) >> 13
}
func (o *RTC_CNTL_Type) SetDIG_ISO_DG_PAD_FORCE_UNHOLD(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_DG_PAD_FORCE_UNHOLD() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x4000) >> 14
}
func (o *RTC_CNTL_Type) SetDIG_ISO_DG_PAD_FORCE_HOLD(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_DG_PAD_FORCE_HOLD() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetDIG_ISO_BT_FORCE_ISO(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_BT_FORCE_ISO() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x400000) >> 22
}
func (o *RTC_CNTL_Type) SetDIG_ISO_BT_FORCE_NOISO(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_BT_FORCE_NOISO() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x800000) >> 23
}
func (o *RTC_CNTL_Type) SetDIG_ISO_DG_PERI_FORCE_ISO(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_DG_PERI_FORCE_ISO() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x1000000) >> 24
}
func (o *RTC_CNTL_Type) SetDIG_ISO_DG_PERI_FORCE_NOISO(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_DG_PERI_FORCE_NOISO() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x2000000) >> 25
}
func (o *RTC_CNTL_Type) SetDIG_ISO_CPU_TOP_FORCE_ISO(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_CPU_TOP_FORCE_ISO() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x4000000) >> 26
}
func (o *RTC_CNTL_Type) SetDIG_ISO_CPU_TOP_FORCE_NOISO(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_CPU_TOP_FORCE_NOISO() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x8000000) >> 27
}
func (o *RTC_CNTL_Type) SetDIG_ISO_WIFI_FORCE_ISO(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_WIFI_FORCE_ISO() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetDIG_ISO_WIFI_FORCE_NOISO(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_WIFI_FORCE_NOISO() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetDIG_ISO_DG_WRAP_FORCE_ISO(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_DG_WRAP_FORCE_ISO() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetDIG_ISO_DG_WRAP_FORCE_NOISO(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_DG_WRAP_FORCE_NOISO() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.RTC_WDTCONFIG0: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_WDTCONFIG0_WDT_CHIP_RESET_WIDTH(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTCONFIG0.Reg, volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg)&^(0xff)|value)
}
func (o *RTC_CNTL_Type) GetRTC_WDTCONFIG0_WDT_CHIP_RESET_WIDTH() uint32 {
	return volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg) & 0xff
}
func (o *RTC_CNTL_Type) SetRTC_WDTCONFIG0_WDT_CHIP_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTCONFIG0.Reg, volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg)&^(0x100)|value<<8)
}
func (o *RTC_CNTL_Type) GetRTC_WDTCONFIG0_WDT_CHIP_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg) & 0x100) >> 8
}
func (o *RTC_CNTL_Type) SetRTC_WDTCONFIG0_WDT_PAUSE_IN_SLP(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTCONFIG0.Reg, volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetRTC_WDTCONFIG0_WDT_PAUSE_IN_SLP() uint32 {
	return (volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetRTC_WDTCONFIG0_WDT_APPCPU_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTCONFIG0.Reg, volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetRTC_WDTCONFIG0_WDT_APPCPU_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetRTC_WDTCONFIG0_WDT_PROCPU_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTCONFIG0.Reg, volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg)&^(0x800)|value<<11)
}
func (o *RTC_CNTL_Type) GetRTC_WDTCONFIG0_WDT_PROCPU_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg) & 0x800) >> 11
}
func (o *RTC_CNTL_Type) SetRTC_WDTCONFIG0_WDT_FLASHBOOT_MOD_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTCONFIG0.Reg, volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_CNTL_Type) GetRTC_WDTCONFIG0_WDT_FLASHBOOT_MOD_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg) & 0x1000) >> 12
}
func (o *RTC_CNTL_Type) SetRTC_WDTCONFIG0_WDT_SYS_RESET_LENGTH(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTCONFIG0.Reg, volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_CNTL_Type) GetRTC_WDTCONFIG0_WDT_SYS_RESET_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg) & 0xe000) >> 13
}
func (o *RTC_CNTL_Type) SetRTC_WDTCONFIG0_WDT_CPU_RESET_LENGTH(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTCONFIG0.Reg, volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg)&^(0x70000)|value<<16)
}
func (o *RTC_CNTL_Type) GetRTC_WDTCONFIG0_WDT_CPU_RESET_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg) & 0x70000) >> 16
}
func (o *RTC_CNTL_Type) SetRTC_WDTCONFIG0_WDT_STG3(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTCONFIG0.Reg, volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg)&^(0x380000)|value<<19)
}
func (o *RTC_CNTL_Type) GetRTC_WDTCONFIG0_WDT_STG3() uint32 {
	return (volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg) & 0x380000) >> 19
}
func (o *RTC_CNTL_Type) SetRTC_WDTCONFIG0_WDT_STG2(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTCONFIG0.Reg, volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg)&^(0x1c00000)|value<<22)
}
func (o *RTC_CNTL_Type) GetRTC_WDTCONFIG0_WDT_STG2() uint32 {
	return (volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg) & 0x1c00000) >> 22
}
func (o *RTC_CNTL_Type) SetRTC_WDTCONFIG0_WDT_STG1(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTCONFIG0.Reg, volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg)&^(0xe000000)|value<<25)
}
func (o *RTC_CNTL_Type) GetRTC_WDTCONFIG0_WDT_STG1() uint32 {
	return (volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg) & 0xe000000) >> 25
}
func (o *RTC_CNTL_Type) SetRTC_WDTCONFIG0_WDT_STG0(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTCONFIG0.Reg, volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg)&^(0x70000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetRTC_WDTCONFIG0_WDT_STG0() uint32 {
	return (volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg) & 0x70000000) >> 28
}
func (o *RTC_CNTL_Type) SetRTC_WDTCONFIG0_WDT_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTCONFIG0.Reg, volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetRTC_WDTCONFIG0_WDT_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_WDTCONFIG0.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.RTC_WDTCONFIG1: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_WDTCONFIG1(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTCONFIG1.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_WDTCONFIG1() uint32 {
	return volatile.LoadUint32(&o.RTC_WDTCONFIG1.Reg)
}

// RTC_CNTL.RTC_WDTCONFIG2: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_WDTCONFIG2(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTCONFIG2.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_WDTCONFIG2() uint32 {
	return volatile.LoadUint32(&o.RTC_WDTCONFIG2.Reg)
}

// RTC_CNTL.RTC_WDTCONFIG3: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_WDTCONFIG3(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTCONFIG3.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_WDTCONFIG3() uint32 {
	return volatile.LoadUint32(&o.RTC_WDTCONFIG3.Reg)
}

// RTC_CNTL.RTC_WDTCONFIG4: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_WDTCONFIG4(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTCONFIG4.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_WDTCONFIG4() uint32 {
	return volatile.LoadUint32(&o.RTC_WDTCONFIG4.Reg)
}

// RTC_CNTL.RTC_WDTFEED: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_WDTFEED_RTC_WDT_FEED(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTFEED.Reg, volatile.LoadUint32(&o.RTC_WDTFEED.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetRTC_WDTFEED_RTC_WDT_FEED() uint32 {
	return (volatile.LoadUint32(&o.RTC_WDTFEED.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.RTC_WDTWPROTECT: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_WDTWPROTECT(value uint32) {
	volatile.StoreUint32(&o.RTC_WDTWPROTECT.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_WDTWPROTECT() uint32 {
	return volatile.LoadUint32(&o.RTC_WDTWPROTECT.Reg)
}

// RTC_CNTL.RTC_SWD_CONF: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_SWD_CONF_SWD_RESET_FLAG(value uint32) {
	volatile.StoreUint32(&o.RTC_SWD_CONF.Reg, volatile.LoadUint32(&o.RTC_SWD_CONF.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetRTC_SWD_CONF_SWD_RESET_FLAG() uint32 {
	return volatile.LoadUint32(&o.RTC_SWD_CONF.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetRTC_SWD_CONF_SWD_FEED_INT(value uint32) {
	volatile.StoreUint32(&o.RTC_SWD_CONF.Reg, volatile.LoadUint32(&o.RTC_SWD_CONF.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetRTC_SWD_CONF_SWD_FEED_INT() uint32 {
	return (volatile.LoadUint32(&o.RTC_SWD_CONF.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetRTC_SWD_CONF_SWD_BYPASS_RST(value uint32) {
	volatile.StoreUint32(&o.RTC_SWD_CONF.Reg, volatile.LoadUint32(&o.RTC_SWD_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_CNTL_Type) GetRTC_SWD_CONF_SWD_BYPASS_RST() uint32 {
	return (volatile.LoadUint32(&o.RTC_SWD_CONF.Reg) & 0x20000) >> 17
}
func (o *RTC_CNTL_Type) SetRTC_SWD_CONF_SWD_SIGNAL_WIDTH(value uint32) {
	volatile.StoreUint32(&o.RTC_SWD_CONF.Reg, volatile.LoadUint32(&o.RTC_SWD_CONF.Reg)&^(0xffc0000)|value<<18)
}
func (o *RTC_CNTL_Type) GetRTC_SWD_CONF_SWD_SIGNAL_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.RTC_SWD_CONF.Reg) & 0xffc0000) >> 18
}
func (o *RTC_CNTL_Type) SetRTC_SWD_CONF_SWD_RST_FLAG_CLR(value uint32) {
	volatile.StoreUint32(&o.RTC_SWD_CONF.Reg, volatile.LoadUint32(&o.RTC_SWD_CONF.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetRTC_SWD_CONF_SWD_RST_FLAG_CLR() uint32 {
	return (volatile.LoadUint32(&o.RTC_SWD_CONF.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetRTC_SWD_CONF_SWD_FEED(value uint32) {
	volatile.StoreUint32(&o.RTC_SWD_CONF.Reg, volatile.LoadUint32(&o.RTC_SWD_CONF.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetRTC_SWD_CONF_SWD_FEED() uint32 {
	return (volatile.LoadUint32(&o.RTC_SWD_CONF.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetRTC_SWD_CONF_SWD_DISABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_SWD_CONF.Reg, volatile.LoadUint32(&o.RTC_SWD_CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetRTC_SWD_CONF_SWD_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_SWD_CONF.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetRTC_SWD_CONF_SWD_AUTO_FEED_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_SWD_CONF.Reg, volatile.LoadUint32(&o.RTC_SWD_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetRTC_SWD_CONF_SWD_AUTO_FEED_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_SWD_CONF.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.RTC_SWD_WPROTECT: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_SWD_WPROTECT(value uint32) {
	volatile.StoreUint32(&o.RTC_SWD_WPROTECT.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_SWD_WPROTECT() uint32 {
	return volatile.LoadUint32(&o.RTC_SWD_WPROTECT.Reg)
}

// RTC_CNTL.RTC_SW_CPU_STALL: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_SW_CPU_STALL_SW_STALL_APPCPU_C1(value uint32) {
	volatile.StoreUint32(&o.RTC_SW_CPU_STALL.Reg, volatile.LoadUint32(&o.RTC_SW_CPU_STALL.Reg)&^(0x3f00000)|value<<20)
}
func (o *RTC_CNTL_Type) GetRTC_SW_CPU_STALL_SW_STALL_APPCPU_C1() uint32 {
	return (volatile.LoadUint32(&o.RTC_SW_CPU_STALL.Reg) & 0x3f00000) >> 20
}
func (o *RTC_CNTL_Type) SetRTC_SW_CPU_STALL_SW_STALL_PROCPU_C1(value uint32) {
	volatile.StoreUint32(&o.RTC_SW_CPU_STALL.Reg, volatile.LoadUint32(&o.RTC_SW_CPU_STALL.Reg)&^(0xfc000000)|value<<26)
}
func (o *RTC_CNTL_Type) GetRTC_SW_CPU_STALL_SW_STALL_PROCPU_C1() uint32 {
	return (volatile.LoadUint32(&o.RTC_SW_CPU_STALL.Reg) & 0xfc000000) >> 26
}

// RTC_CNTL.RTC_STORE4: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_STORE4(value uint32) {
	volatile.StoreUint32(&o.RTC_STORE4.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_STORE4() uint32 {
	return volatile.LoadUint32(&o.RTC_STORE4.Reg)
}

// RTC_CNTL.RTC_STORE5: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_STORE5(value uint32) {
	volatile.StoreUint32(&o.RTC_STORE5.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_STORE5() uint32 {
	return volatile.LoadUint32(&o.RTC_STORE5.Reg)
}

// RTC_CNTL.RTC_STORE6: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_STORE6(value uint32) {
	volatile.StoreUint32(&o.RTC_STORE6.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_STORE6() uint32 {
	return volatile.LoadUint32(&o.RTC_STORE6.Reg)
}

// RTC_CNTL.RTC_STORE7: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_STORE7(value uint32) {
	volatile.StoreUint32(&o.RTC_STORE7.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_STORE7() uint32 {
	return volatile.LoadUint32(&o.RTC_STORE7.Reg)
}

// RTC_CNTL.RTC_LOW_POWER_ST: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_XPD_ROM0(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_XPD_ROM0() uint32 {
	return volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_XPD_DIG_DCDC(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x4)|value<<2)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_XPD_DIG_DCDC() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x4) >> 2
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_PERI_ISO(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_PERI_ISO() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_XPD_RTC_PERI(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x10)|value<<4)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_XPD_RTC_PERI() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x10) >> 4
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_WIFI_ISO(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x20)|value<<5)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_WIFI_ISO() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x20) >> 5
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_XPD_WIFI(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x40)|value<<6)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_XPD_WIFI() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x40) >> 6
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_DIG_ISO(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x80)|value<<7)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_DIG_ISO() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x80) >> 7
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_XPD_DIG(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x100)|value<<8)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_XPD_DIG() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x100) >> 8
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_TOUCH_STATE_START(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_TOUCH_STATE_START() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_TOUCH_STATE_SWITCH(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_TOUCH_STATE_SWITCH() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_TOUCH_STATE_SLP(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x800)|value<<11)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_TOUCH_STATE_SLP() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x800) >> 11
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_TOUCH_STATE_DONE(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_TOUCH_STATE_DONE() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x1000) >> 12
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_COCPU_STATE_START(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_COCPU_STATE_START() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x2000) >> 13
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_COCPU_STATE_SWITCH(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_COCPU_STATE_SWITCH() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x4000) >> 14
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_COCPU_STATE_SLP(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_COCPU_STATE_SLP() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_COCPU_STATE_DONE(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_COCPU_STATE_DONE() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x10000) >> 16
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_MAIN_STATE_XTAL_ISO(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_MAIN_STATE_XTAL_ISO() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x20000) >> 17
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_MAIN_STATE_PLL_ON(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_MAIN_STATE_PLL_ON() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x40000) >> 18
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_RDY_FOR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_RDY_FOR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x80000) >> 19
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_MAIN_STATE_WAIT_END(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_MAIN_STATE_WAIT_END() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x100000) >> 20
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_IN_WAKEUP_STATE(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x200000)|value<<21)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_IN_WAKEUP_STATE() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x200000) >> 21
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_IN_LOW_POWER_STATE(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_IN_LOW_POWER_STATE() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x400000) >> 22
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_MAIN_STATE_IN_WAIT_8M(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_MAIN_STATE_IN_WAIT_8M() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x800000) >> 23
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_MAIN_STATE_IN_WAIT_PLL(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_MAIN_STATE_IN_WAIT_PLL() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x1000000) >> 24
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_MAIN_STATE_IN_WAIT_XTL(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_MAIN_STATE_IN_WAIT_XTL() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x2000000) >> 25
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_MAIN_STATE_IN_SLP(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_MAIN_STATE_IN_SLP() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x4000000) >> 26
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_MAIN_STATE_IN_IDLE(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_MAIN_STATE_IN_IDLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0x8000000) >> 27
}
func (o *RTC_CNTL_Type) SetRTC_LOW_POWER_ST_RTC_MAIN_STATE(value uint32) {
	volatile.StoreUint32(&o.RTC_LOW_POWER_ST.Reg, volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg)&^(0xf0000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetRTC_LOW_POWER_ST_RTC_MAIN_STATE() uint32 {
	return (volatile.LoadUint32(&o.RTC_LOW_POWER_ST.Reg) & 0xf0000000) >> 28
}

// RTC_CNTL.RTC_DIAG0: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_DIAG0(value uint32) {
	volatile.StoreUint32(&o.RTC_DIAG0.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_DIAG0() uint32 {
	return volatile.LoadUint32(&o.RTC_DIAG0.Reg)
}

// RTC_CNTL.RTC_PAD_HOLD: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_PAD_HOLD_RTC_GPIO_PIN0_HOLD(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD_HOLD.Reg, volatile.LoadUint32(&o.RTC_PAD_HOLD.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetRTC_PAD_HOLD_RTC_GPIO_PIN0_HOLD() uint32 {
	return volatile.LoadUint32(&o.RTC_PAD_HOLD.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetRTC_PAD_HOLD_RTC_GPIO_PIN1_HOLD(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD_HOLD.Reg, volatile.LoadUint32(&o.RTC_PAD_HOLD.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetRTC_PAD_HOLD_RTC_GPIO_PIN1_HOLD() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD_HOLD.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetRTC_PAD_HOLD_RTC_GPIO_PIN2_HOLD(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD_HOLD.Reg, volatile.LoadUint32(&o.RTC_PAD_HOLD.Reg)&^(0x4)|value<<2)
}
func (o *RTC_CNTL_Type) GetRTC_PAD_HOLD_RTC_GPIO_PIN2_HOLD() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD_HOLD.Reg) & 0x4) >> 2
}
func (o *RTC_CNTL_Type) SetRTC_PAD_HOLD_RTC_GPIO_PIN3_HOLD(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD_HOLD.Reg, volatile.LoadUint32(&o.RTC_PAD_HOLD.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetRTC_PAD_HOLD_RTC_GPIO_PIN3_HOLD() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD_HOLD.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetRTC_PAD_HOLD_RTC_GPIO_PIN4_HOLD(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD_HOLD.Reg, volatile.LoadUint32(&o.RTC_PAD_HOLD.Reg)&^(0x10)|value<<4)
}
func (o *RTC_CNTL_Type) GetRTC_PAD_HOLD_RTC_GPIO_PIN4_HOLD() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD_HOLD.Reg) & 0x10) >> 4
}
func (o *RTC_CNTL_Type) SetRTC_PAD_HOLD_RTC_GPIO_PIN5_HOLD(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD_HOLD.Reg, volatile.LoadUint32(&o.RTC_PAD_HOLD.Reg)&^(0x20)|value<<5)
}
func (o *RTC_CNTL_Type) GetRTC_PAD_HOLD_RTC_GPIO_PIN5_HOLD() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD_HOLD.Reg) & 0x20) >> 5
}

// RTC_CNTL.DIG_PAD_HOLD: rtc configure register
func (o *RTC_CNTL_Type) SetDIG_PAD_HOLD(value uint32) {
	volatile.StoreUint32(&o.DIG_PAD_HOLD.Reg, value)
}
func (o *RTC_CNTL_Type) GetDIG_PAD_HOLD() uint32 {
	return volatile.LoadUint32(&o.DIG_PAD_HOLD.Reg)
}

// RTC_CNTL.RTC_BROWN_OUT: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_BROWN_OUT_BROWN_OUT_INT_WAIT(value uint32) {
	volatile.StoreUint32(&o.RTC_BROWN_OUT.Reg, volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg)&^(0x3ff0)|value<<4)
}
func (o *RTC_CNTL_Type) GetRTC_BROWN_OUT_BROWN_OUT_INT_WAIT() uint32 {
	return (volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg) & 0x3ff0) >> 4
}
func (o *RTC_CNTL_Type) SetRTC_BROWN_OUT_BROWN_OUT_CLOSE_FLASH_ENA(value uint32) {
	volatile.StoreUint32(&o.RTC_BROWN_OUT.Reg, volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_CNTL_Type) GetRTC_BROWN_OUT_BROWN_OUT_CLOSE_FLASH_ENA() uint32 {
	return (volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg) & 0x4000) >> 14
}
func (o *RTC_CNTL_Type) SetRTC_BROWN_OUT_BROWN_OUT_PD_RF_ENA(value uint32) {
	volatile.StoreUint32(&o.RTC_BROWN_OUT.Reg, volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetRTC_BROWN_OUT_BROWN_OUT_PD_RF_ENA() uint32 {
	return (volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetRTC_BROWN_OUT_BROWN_OUT_RST_WAIT(value uint32) {
	volatile.StoreUint32(&o.RTC_BROWN_OUT.Reg, volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg)&^(0x3ff0000)|value<<16)
}
func (o *RTC_CNTL_Type) GetRTC_BROWN_OUT_BROWN_OUT_RST_WAIT() uint32 {
	return (volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg) & 0x3ff0000) >> 16
}
func (o *RTC_CNTL_Type) SetRTC_BROWN_OUT_BROWN_OUT_RST_ENA(value uint32) {
	volatile.StoreUint32(&o.RTC_BROWN_OUT.Reg, volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_CNTL_Type) GetRTC_BROWN_OUT_BROWN_OUT_RST_ENA() uint32 {
	return (volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg) & 0x4000000) >> 26
}
func (o *RTC_CNTL_Type) SetRTC_BROWN_OUT_BROWN_OUT_RST_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_BROWN_OUT.Reg, volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetRTC_BROWN_OUT_BROWN_OUT_RST_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg) & 0x8000000) >> 27
}
func (o *RTC_CNTL_Type) SetRTC_BROWN_OUT_BROWN_OUT_ANA_RST_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_BROWN_OUT.Reg, volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetRTC_BROWN_OUT_BROWN_OUT_ANA_RST_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetRTC_BROWN_OUT_BROWN_OUT_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.RTC_BROWN_OUT.Reg, volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetRTC_BROWN_OUT_BROWN_OUT_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetRTC_BROWN_OUT_BROWN_OUT_ENA(value uint32) {
	volatile.StoreUint32(&o.RTC_BROWN_OUT.Reg, volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetRTC_BROWN_OUT_BROWN_OUT_ENA() uint32 {
	return (volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetRTC_BROWN_OUT_DET(value uint32) {
	volatile.StoreUint32(&o.RTC_BROWN_OUT.Reg, volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetRTC_BROWN_OUT_DET() uint32 {
	return (volatile.LoadUint32(&o.RTC_BROWN_OUT.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.RTC_TIME_LOW1: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_TIME_LOW1(value uint32) {
	volatile.StoreUint32(&o.RTC_TIME_LOW1.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_TIME_LOW1() uint32 {
	return volatile.LoadUint32(&o.RTC_TIME_LOW1.Reg)
}

// RTC_CNTL.RTC_TIME_HIGH1: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_TIME_HIGH1_RTC_TIMER_VALUE1_HIGH(value uint32) {
	volatile.StoreUint32(&o.RTC_TIME_HIGH1.Reg, volatile.LoadUint32(&o.RTC_TIME_HIGH1.Reg)&^(0xffff)|value)
}
func (o *RTC_CNTL_Type) GetRTC_TIME_HIGH1_RTC_TIMER_VALUE1_HIGH() uint32 {
	return volatile.LoadUint32(&o.RTC_TIME_HIGH1.Reg) & 0xffff
}

// RTC_CNTL.RTC_XTAL32K_CLK_FACTOR: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_XTAL32K_CLK_FACTOR(value uint32) {
	volatile.StoreUint32(&o.RTC_XTAL32K_CLK_FACTOR.Reg, value)
}
func (o *RTC_CNTL_Type) GetRTC_XTAL32K_CLK_FACTOR() uint32 {
	return volatile.LoadUint32(&o.RTC_XTAL32K_CLK_FACTOR.Reg)
}

// RTC_CNTL.RTC_XTAL32K_CONF: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_XTAL32K_CONF_XTAL32K_RETURN_WAIT(value uint32) {
	volatile.StoreUint32(&o.RTC_XTAL32K_CONF.Reg, volatile.LoadUint32(&o.RTC_XTAL32K_CONF.Reg)&^(0xf)|value)
}
func (o *RTC_CNTL_Type) GetRTC_XTAL32K_CONF_XTAL32K_RETURN_WAIT() uint32 {
	return volatile.LoadUint32(&o.RTC_XTAL32K_CONF.Reg) & 0xf
}
func (o *RTC_CNTL_Type) SetRTC_XTAL32K_CONF_XTAL32K_RESTART_WAIT(value uint32) {
	volatile.StoreUint32(&o.RTC_XTAL32K_CONF.Reg, volatile.LoadUint32(&o.RTC_XTAL32K_CONF.Reg)&^(0xffff0)|value<<4)
}
func (o *RTC_CNTL_Type) GetRTC_XTAL32K_CONF_XTAL32K_RESTART_WAIT() uint32 {
	return (volatile.LoadUint32(&o.RTC_XTAL32K_CONF.Reg) & 0xffff0) >> 4
}
func (o *RTC_CNTL_Type) SetRTC_XTAL32K_CONF_XTAL32K_WDT_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.RTC_XTAL32K_CONF.Reg, volatile.LoadUint32(&o.RTC_XTAL32K_CONF.Reg)&^(0xff00000)|value<<20)
}
func (o *RTC_CNTL_Type) GetRTC_XTAL32K_CONF_XTAL32K_WDT_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.RTC_XTAL32K_CONF.Reg) & 0xff00000) >> 20
}
func (o *RTC_CNTL_Type) SetRTC_XTAL32K_CONF_XTAL32K_STABLE_THRES(value uint32) {
	volatile.StoreUint32(&o.RTC_XTAL32K_CONF.Reg, volatile.LoadUint32(&o.RTC_XTAL32K_CONF.Reg)&^(0xf0000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetRTC_XTAL32K_CONF_XTAL32K_STABLE_THRES() uint32 {
	return (volatile.LoadUint32(&o.RTC_XTAL32K_CONF.Reg) & 0xf0000000) >> 28
}

// RTC_CNTL.RTC_USB_CONF: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_USB_CONF_IO_MUX_RESET_DISABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_USB_CONF.Reg, volatile.LoadUint32(&o.RTC_USB_CONF.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_CNTL_Type) GetRTC_USB_CONF_IO_MUX_RESET_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_USB_CONF.Reg) & 0x40000) >> 18
}

// RTC_CNTL.RTC_SLP_REJECT_CAUSE: RTC_CNTL_RTC_SLP_REJECT_CAUSE_REG
func (o *RTC_CNTL_Type) SetRTC_SLP_REJECT_CAUSE_REJECT_CAUSE(value uint32) {
	volatile.StoreUint32(&o.RTC_SLP_REJECT_CAUSE.Reg, volatile.LoadUint32(&o.RTC_SLP_REJECT_CAUSE.Reg)&^(0x3ffff)|value)
}
func (o *RTC_CNTL_Type) GetRTC_SLP_REJECT_CAUSE_REJECT_CAUSE() uint32 {
	return volatile.LoadUint32(&o.RTC_SLP_REJECT_CAUSE.Reg) & 0x3ffff
}

// RTC_CNTL.RTC_OPTION1: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_OPTION1_FORCE_DOWNLOAD_BOOT(value uint32) {
	volatile.StoreUint32(&o.RTC_OPTION1.Reg, volatile.LoadUint32(&o.RTC_OPTION1.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetRTC_OPTION1_FORCE_DOWNLOAD_BOOT() uint32 {
	return volatile.LoadUint32(&o.RTC_OPTION1.Reg) & 0x1
}

// RTC_CNTL.RTC_SLP_WAKEUP_CAUSE: RTC_CNTL_RTC_SLP_WAKEUP_CAUSE_REG
func (o *RTC_CNTL_Type) SetRTC_SLP_WAKEUP_CAUSE_WAKEUP_CAUSE(value uint32) {
	volatile.StoreUint32(&o.RTC_SLP_WAKEUP_CAUSE.Reg, volatile.LoadUint32(&o.RTC_SLP_WAKEUP_CAUSE.Reg)&^(0x1ffff)|value)
}
func (o *RTC_CNTL_Type) GetRTC_SLP_WAKEUP_CAUSE_WAKEUP_CAUSE() uint32 {
	return volatile.LoadUint32(&o.RTC_SLP_WAKEUP_CAUSE.Reg) & 0x1ffff
}

// RTC_CNTL.RTC_ULP_CP_TIMER_1: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_ULP_CP_TIMER_1_ULP_CP_TIMER_SLP_CYCLE(value uint32) {
	volatile.StoreUint32(&o.RTC_ULP_CP_TIMER_1.Reg, volatile.LoadUint32(&o.RTC_ULP_CP_TIMER_1.Reg)&^(0xffffff00)|value<<8)
}
func (o *RTC_CNTL_Type) GetRTC_ULP_CP_TIMER_1_ULP_CP_TIMER_SLP_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_ULP_CP_TIMER_1.Reg) & 0xffffff00) >> 8
}

// RTC_CNTL.INT_ENA_RTC_W1TS: rtc configure register
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TS_SLP_WAKEUP_INT_ENA_W1TS(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TS.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TS_SLP_WAKEUP_INT_ENA_W1TS() uint32 {
	return volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TS_SLP_REJECT_INT_ENA_W1TS(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TS.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TS_SLP_REJECT_INT_ENA_W1TS() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TS_RTC_WDT_INT_ENA_W1TS(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TS.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TS_RTC_WDT_INT_ENA_W1TS() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TS_RTC_BROWN_OUT_INT_ENA_W1TS(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TS.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TS_RTC_BROWN_OUT_INT_ENA_W1TS() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TS_RTC_MAIN_TIMER_INT_ENA_W1TS(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TS.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TS_RTC_MAIN_TIMER_INT_ENA_W1TS() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TS_RTC_SWD_INT_ENA_W1TS(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TS.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TS_RTC_SWD_INT_ENA_W1TS() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TS_RTC_XTAL32K_DEAD_INT_ENA_W1TS(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TS.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TS_RTC_XTAL32K_DEAD_INT_ENA_W1TS() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg) & 0x10000) >> 16
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TS_RTC_GLITCH_DET_INT_ENA_W1TS(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TS.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TS_RTC_GLITCH_DET_INT_ENA_W1TS() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg) & 0x80000) >> 19
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TS_RTC_BBPLL_CAL_INT_ENA_W1TS(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TS.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TS_RTC_BBPLL_CAL_INT_ENA_W1TS() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg) & 0x100000) >> 20
}

// RTC_CNTL.INT_ENA_RTC_W1TC: rtc configure register
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TC_SLP_WAKEUP_INT_ENA_W1TC(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TC_SLP_WAKEUP_INT_ENA_W1TC() uint32 {
	return volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TC_SLP_REJECT_INT_ENA_W1TC(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TC_SLP_REJECT_INT_ENA_W1TC() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TC_RTC_WDT_INT_ENA_W1TC(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TC_RTC_WDT_INT_ENA_W1TC() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TC_RTC_BROWN_OUT_INT_ENA_W1TC(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TC_RTC_BROWN_OUT_INT_ENA_W1TC() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TC_RTC_MAIN_TIMER_INT_ENA_W1TC(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TC_RTC_MAIN_TIMER_INT_ENA_W1TC() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TC_RTC_SWD_INT_ENA_W1TC(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TC_RTC_SWD_INT_ENA_W1TC() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TC_RTC_XTAL32K_DEAD_INT_ENA_W1TC(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TC_RTC_XTAL32K_DEAD_INT_ENA_W1TC() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg) & 0x10000) >> 16
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TC_RTC_GLITCH_DET_INT_ENA_W1TC(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TC_RTC_GLITCH_DET_INT_ENA_W1TC() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg) & 0x80000) >> 19
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TC_RTC_BBPLL_CAL_INT_ENA_W1TC(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TC_RTC_BBPLL_CAL_INT_ENA_W1TC() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg) & 0x100000) >> 20
}

// RTC_CNTL.RTC_CNTL_RETENTION_CTRL: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_CNTL_RETENTION_CTRL_RETENTION_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_RETENTION_CTRL.Reg, volatile.LoadUint32(&o.RTC_CNTL_RETENTION_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_RETENTION_CTRL_RETENTION_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_RETENTION_CTRL.Reg) & 0x40000) >> 18
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_RETENTION_CTRL_RETENTION_DONE_WAIT(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_RETENTION_CTRL.Reg, volatile.LoadUint32(&o.RTC_CNTL_RETENTION_CTRL.Reg)&^(0x380000)|value<<19)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_RETENTION_CTRL_RETENTION_DONE_WAIT() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_RETENTION_CTRL.Reg) & 0x380000) >> 19
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_RETENTION_CTRL_RETENTION_CLKOFF_WAIT(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_RETENTION_CTRL.Reg, volatile.LoadUint32(&o.RTC_CNTL_RETENTION_CTRL.Reg)&^(0x3c00000)|value<<22)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_RETENTION_CTRL_RETENTION_CLKOFF_WAIT() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_RETENTION_CTRL.Reg) & 0x3c00000) >> 22
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_RETENTION_CTRL_RETENTION_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_RETENTION_CTRL.Reg, volatile.LoadUint32(&o.RTC_CNTL_RETENTION_CTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_RETENTION_CTRL_RETENTION_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_RETENTION_CTRL.Reg) & 0x4000000) >> 26
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_RETENTION_CTRL_RETENTION_WAIT(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_RETENTION_CTRL.Reg, volatile.LoadUint32(&o.RTC_CNTL_RETENTION_CTRL.Reg)&^(0xf8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_RETENTION_CTRL_RETENTION_WAIT() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_RETENTION_CTRL.Reg) & 0xf8000000) >> 27
}

// RTC_CNTL.RTC_FIB_SEL: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_FIB_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_FIB_SEL.Reg, volatile.LoadUint32(&o.RTC_FIB_SEL.Reg)&^(0x7)|value)
}
func (o *RTC_CNTL_Type) GetRTC_FIB_SEL() uint32 {
	return volatile.LoadUint32(&o.RTC_FIB_SEL.Reg) & 0x7
}

// RTC_CNTL.RTC_CNTL_GPIO_WAKEUP: rtc configure register
func (o *RTC_CNTL_Type) SetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_WAKEUP_STATUS(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg)&^(0x3f)|value)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_WAKEUP_STATUS() uint32 {
	return volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg) & 0x3f
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_WAKEUP_STATUS_CLR(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg)&^(0x40)|value<<6)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_WAKEUP_STATUS_CLR() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg) & 0x40) >> 6
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN_CLK_GATE(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg)&^(0x80)|value<<7)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN_CLK_GATE() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg) & 0x80) >> 7
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN5_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg)&^(0x700)|value<<8)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN5_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg) & 0x700) >> 8
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN4_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg)&^(0x3800)|value<<11)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN4_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg) & 0x3800) >> 11
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN3_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg)&^(0x1c000)|value<<14)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN3_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg) & 0x1c000) >> 14
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN2_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg)&^(0xe0000)|value<<17)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN2_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg) & 0xe0000) >> 17
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN1_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg)&^(0x700000)|value<<20)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN1_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg) & 0x700000) >> 20
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN0_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg)&^(0x3800000)|value<<23)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN0_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg) & 0x3800000) >> 23
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN5_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN5_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg) & 0x4000000) >> 26
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN4_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN4_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg) & 0x8000000) >> 27
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN3_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN3_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN2_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN2_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN1_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN1_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN0_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_GPIO_WAKEUP_RTC_GPIO_PIN0_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL_GPIO_WAKEUP.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.RTC_CNTL_DBG_SEL: 