﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/model/ThemeSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace QuickSight
{
namespace Model
{
  class ListThemesResult
  {
  public:
    AWS_QUICKSIGHT_API ListThemesResult();
    AWS_QUICKSIGHT_API ListThemesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_QUICKSIGHT_API ListThemesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>Information about the themes in the list.</p>
     */
    inline const Aws::Vector<ThemeSummary>& GetThemeSummaryList() const{ return m_themeSummaryList; }

    /**
     * <p>Information about the themes in the list.</p>
     */
    inline void SetThemeSummaryList(const Aws::Vector<ThemeSummary>& value) { m_themeSummaryList = value; }

    /**
     * <p>Information about the themes in the list.</p>
     */
    inline void SetThemeSummaryList(Aws::Vector<ThemeSummary>&& value) { m_themeSummaryList = std::move(value); }

    /**
     * <p>Information about the themes in the list.</p>
     */
    inline ListThemesResult& WithThemeSummaryList(const Aws::Vector<ThemeSummary>& value) { SetThemeSummaryList(value); return *this;}

    /**
     * <p>Information about the themes in the list.</p>
     */
    inline ListThemesResult& WithThemeSummaryList(Aws::Vector<ThemeSummary>&& value) { SetThemeSummaryList(std::move(value)); return *this;}

    /**
     * <p>Information about the themes in the list.</p>
     */
    inline ListThemesResult& AddThemeSummaryList(const ThemeSummary& value) { m_themeSummaryList.push_back(value); return *this; }

    /**
     * <p>Information about the themes in the list.</p>
     */
    inline ListThemesResult& AddThemeSummaryList(ThemeSummary&& value) { m_themeSummaryList.push_back(std::move(value)); return *this; }


    /**
     * <p>The token for the next set of results, or null if there are no more
     * results.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }

    /**
     * <p>The token for the next set of results, or null if there are no more
     * results.</p>
     */
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }

    /**
     * <p>The token for the next set of results, or null if there are no more
     * results.</p>
     */
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }

    /**
     * <p>The token for the next set of results, or null if there are no more
     * results.</p>
     */
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }

    /**
     * <p>The token for the next set of results, or null if there are no more
     * results.</p>
     */
    inline ListThemesResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}

    /**
     * <p>The token for the next set of results, or null if there are no more
     * results.</p>
     */
    inline ListThemesResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}

    /**
     * <p>The token for the next set of results, or null if there are no more
     * results.</p>
     */
    inline ListThemesResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}


    /**
     * <p>The HTTP status of the request.</p>
     */
    inline int GetStatus() const{ return m_status; }

    /**
     * <p>The HTTP status of the request.</p>
     */
    inline void SetStatus(int value) { m_status = value; }

    /**
     * <p>The HTTP status of the request.</p>
     */
    inline ListThemesResult& WithStatus(int value) { SetStatus(value); return *this;}


    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }

    
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }

    
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }

    
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }

    
    inline ListThemesResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}

    
    inline ListThemesResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}

    
    inline ListThemesResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}

  private:

    Aws::Vector<ThemeSummary> m_themeSummaryList;

    Aws::String m_nextToken;

    int m_status;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace QuickSight
} // namespace Aws
