﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sagemaker-geospatial/SageMakerGeospatial_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker-geospatial/model/ExportErrorType.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SageMakerGeospatial
{
namespace Model
{

  /**
   * <p>The structure representing the errors in an export EarthObservationJob
   * operation.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ExportErrorDetailsOutput">AWS
   * API Reference</a></p>
   */
  class ExportErrorDetailsOutput
  {
  public:
    AWS_SAGEMAKERGEOSPATIAL_API ExportErrorDetailsOutput();
    AWS_SAGEMAKERGEOSPATIAL_API ExportErrorDetailsOutput(Aws::Utils::Json::JsonView jsonValue);
    AWS_SAGEMAKERGEOSPATIAL_API ExportErrorDetailsOutput& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_SAGEMAKERGEOSPATIAL_API Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>A detailed message describing the error in an export EarthObservationJob
     * operation.</p>
     */
    inline const Aws::String& GetMessage() const{ return m_message; }

    /**
     * <p>A detailed message describing the error in an export EarthObservationJob
     * operation.</p>
     */
    inline bool MessageHasBeenSet() const { return m_messageHasBeenSet; }

    /**
     * <p>A detailed message describing the error in an export EarthObservationJob
     * operation.</p>
     */
    inline void SetMessage(const Aws::String& value) { m_messageHasBeenSet = true; m_message = value; }

    /**
     * <p>A detailed message describing the error in an export EarthObservationJob
     * operation.</p>
     */
    inline void SetMessage(Aws::String&& value) { m_messageHasBeenSet = true; m_message = std::move(value); }

    /**
     * <p>A detailed message describing the error in an export EarthObservationJob
     * operation.</p>
     */
    inline void SetMessage(const char* value) { m_messageHasBeenSet = true; m_message.assign(value); }

    /**
     * <p>A detailed message describing the error in an export EarthObservationJob
     * operation.</p>
     */
    inline ExportErrorDetailsOutput& WithMessage(const Aws::String& value) { SetMessage(value); return *this;}

    /**
     * <p>A detailed message describing the error in an export EarthObservationJob
     * operation.</p>
     */
    inline ExportErrorDetailsOutput& WithMessage(Aws::String&& value) { SetMessage(std::move(value)); return *this;}

    /**
     * <p>A detailed message describing the error in an export EarthObservationJob
     * operation.</p>
     */
    inline ExportErrorDetailsOutput& WithMessage(const char* value) { SetMessage(value); return *this;}


    /**
     * <p>The type of error in an export EarthObservationJob operation.</p>
     */
    inline const ExportErrorType& GetType() const{ return m_type; }

    /**
     * <p>The type of error in an export EarthObservationJob operation.</p>
     */
    inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }

    /**
     * <p>The type of error in an export EarthObservationJob operation.</p>
     */
    inline void SetType(const ExportErrorType& value) { m_typeHasBeenSet = true; m_type = value; }

    /**
     * <p>The type of error in an export EarthObservationJob operation.</p>
     */
    inline void SetType(ExportErrorType&& value) { m_typeHasBeenSet = true; m_type = std::move(value); }

    /**
     * <p>The type of error in an export EarthObservationJob operation.</p>
     */
    inline ExportErrorDetailsOutput& WithType(const ExportErrorType& value) { SetType(value); return *this;}

    /**
     * <p>The type of error in an export EarthObservationJob operation.</p>
     */
    inline ExportErrorDetailsOutput& WithType(ExportErrorType&& value) { SetType(std::move(value)); return *this;}

  private:

    Aws::String m_message;
    bool m_messageHasBeenSet = false;

    ExportErrorType m_type;
    bool m_typeHasBeenSet = false;
  };

} // namespace Model
} // namespace SageMakerGeospatial
} // namespace Aws
