﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/securityhub/model/AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SecurityHub
{
namespace Model
{

  /**
   * <p> An object that contains information on the status of Malware Protection as a
   * data source for the detector. </p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails">AWS
   * API Reference</a></p>
   */
  class AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails
  {
  public:
    AWS_SECURITYHUB_API AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails();
    AWS_SECURITYHUB_API AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails(Aws::Utils::Json::JsonView jsonValue);
    AWS_SECURITYHUB_API AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p> Describes the configuration of Malware Protection for EC2 instances with
     * findings. </p>
     */
    inline const AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails& GetScanEc2InstanceWithFindings() const{ return m_scanEc2InstanceWithFindings; }

    /**
     * <p> Describes the configuration of Malware Protection for EC2 instances with
     * findings. </p>
     */
    inline bool ScanEc2InstanceWithFindingsHasBeenSet() const { return m_scanEc2InstanceWithFindingsHasBeenSet; }

    /**
     * <p> Describes the configuration of Malware Protection for EC2 instances with
     * findings. </p>
     */
    inline void SetScanEc2InstanceWithFindings(const AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails& value) { m_scanEc2InstanceWithFindingsHasBeenSet = true; m_scanEc2InstanceWithFindings = value; }

    /**
     * <p> Describes the configuration of Malware Protection for EC2 instances with
     * findings. </p>
     */
    inline void SetScanEc2InstanceWithFindings(AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails&& value) { m_scanEc2InstanceWithFindingsHasBeenSet = true; m_scanEc2InstanceWithFindings = std::move(value); }

    /**
     * <p> Describes the configuration of Malware Protection for EC2 instances with
     * findings. </p>
     */
    inline AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails& WithScanEc2InstanceWithFindings(const AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails& value) { SetScanEc2InstanceWithFindings(value); return *this;}

    /**
     * <p> Describes the configuration of Malware Protection for EC2 instances with
     * findings. </p>
     */
    inline AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails& WithScanEc2InstanceWithFindings(AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails&& value) { SetScanEc2InstanceWithFindings(std::move(value)); return *this;}


    /**
     * <p> The GuardDuty Malware Protection service role. </p>
     */
    inline const Aws::String& GetServiceRole() const{ return m_serviceRole; }

    /**
     * <p> The GuardDuty Malware Protection service role. </p>
     */
    inline bool ServiceRoleHasBeenSet() const { return m_serviceRoleHasBeenSet; }

    /**
     * <p> The GuardDuty Malware Protection service role. </p>
     */
    inline void SetServiceRole(const Aws::String& value) { m_serviceRoleHasBeenSet = true; m_serviceRole = value; }

    /**
     * <p> The GuardDuty Malware Protection service role. </p>
     */
    inline void SetServiceRole(Aws::String&& value) { m_serviceRoleHasBeenSet = true; m_serviceRole = std::move(value); }

    /**
     * <p> The GuardDuty Malware Protection service role. </p>
     */
    inline void SetServiceRole(const char* value) { m_serviceRoleHasBeenSet = true; m_serviceRole.assign(value); }

    /**
     * <p> The GuardDuty Malware Protection service role. </p>
     */
    inline AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails& WithServiceRole(const Aws::String& value) { SetServiceRole(value); return *this;}

    /**
     * <p> The GuardDuty Malware Protection service role. </p>
     */
    inline AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails& WithServiceRole(Aws::String&& value) { SetServiceRole(std::move(value)); return *this;}

    /**
     * <p> The GuardDuty Malware Protection service role. </p>
     */
    inline AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails& WithServiceRole(const char* value) { SetServiceRole(value); return *this;}

  private:

    AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails m_scanEc2InstanceWithFindings;
    bool m_scanEc2InstanceWithFindingsHasBeenSet = false;

    Aws::String m_serviceRole;
    bool m_serviceRoleHasBeenSet = false;
  };

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
