#
# Find the KDevelop Parser Generator and set various variables accordingly
#
# KDEVPGQT_DIR and can be set to adjust the directory where the kdevelop-pg-qt
# headers and executable are searched. This should point to the installation
# directory of kdevelop-pg-qt
#
# KDEVPGQT_FOUND - set to TRUE if KDevelop-PG was found FALSE otherwise
#
# KDEVPGQT_INCLUDE_DIR         - include dir of kdevelop-pg, for example /usr/include/kdevelop-pg
#                              can be set by the user to select different include dirs
# KDEVPGQT_EXECUTABLE          - the absolute path to the kdevelop-pg executable
#
# Copyright (c) 2007 Andreas Pakulat <apaku@gmx.de>
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was KDevelop-PG-QtConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/KDevelop-PG-Qt" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

if( KDEVPGQT_INCLUDE_DIR AND KDEVPGQT_EXECUTABLE )
    set(KDevelop-PG-Qt_FIND_QUIETLY TRUE)
endif()

if(WIN32)
    file(TO_CMAKE_PATH "$ENV{PROGRAMFILES}" _progFiles)
    set(_KDEVPGQT_DIR ${_progFiles}/kdevelop-pg-qt)
endif()

if( NOT KDEVPGQT_DIR )
    find_path( _kdevpgqtIncDir kdevelop-pg-qt/kdev-pg-token-stream.h
        PATHS
        ${CMAKE_INSTALL_PREFIX}/include
        ${_KDEVPGQT_DIR}/include
    )
    if( _kdevpgqtIncDir )
        set(KDEVPGQT_INCLUDE_DIR ${_kdevpgqtIncDir}/kdevelop-pg-qt)
    endif()
    find_program( KDEVPGQT_EXECUTABLE NAMES kdev-pg-qt
        PATHS
        ${CMAKE_INSTALL_PREFIX}/bin
        ${_KDEVPGQT_DIR}/bin
    )

    set(KDEVPGQT_INCLUDE_DIR ${KDEVPGQT_INCLUDE_DIR} CACHE PATH "kdevelop-pg-qt include directory containing the headers")
    set( KDEVPGQT_EXECUTABLE ${KDEVPGQT_EXECUTABLE} CACHE PATH "executable for kdevelop-pg-qt" )
else()
    find_path( _kdevpgqtIncDir kdevelop-pg-qt/kdev-pg-token-stream.h
        PATHS
        ${CMAKE_INSTALL_PREFIX}/include
        ${_KDEVPGQT_DIR}/include
        ${KDEVPGQT_DIR}/include
    )
    set(KDEVPGQT_INCLUDE_DIR ${_kdevpgIncDir}/kdevelop-pg-qt)
    find_program( KDEVPGQT_EXECUTABLE NAMES kdev-pg-qt
        PATHS
        ${CMAKE_INSTALL_PREFIX}/bin
        ${_KDEVPGQT_DIR}/bin
        ${KDEVPGQT_DIR}/bin
    )
    set(KDEVPGQT_INCLUDE_DIR ${KDEVPGQT_INCLUDE_DIR} CACHE PATH "kdevelop-pg-qt include directory containing the headers")
    set( KDEVPGQT_EXECUTABLE ${KDEVPGQT_EXECUTABLE} CACHE PATH "executable for kdevelop-pg-qt" )
endif()

if( KDEVPGQT_INCLUDE_DIR
 AND KDEVPGQT_EXECUTABLE)

    if( NOT KDevelop-PG-Qt_FIND_QUIETLY )
        message(STATUS "Found KDevelop-PG-Qt")
        message(STATUS "  Using kdevelop-pg-qt include dir: ${KDEVPGQT_INCLUDE_DIR}")
        message(STATUS "  Using kdevelop-pg-qt executable: ${KDEVPGQT_EXECUTABLE}")
    endif()

# if all modules found
    set(KDEVPGQT_FOUND TRUE)

else( KDEVPGQT_INCLUDE_DIR
 AND KDEVPGQT_EXECUTABLE)

    if( KDevelop-PG-Qt_FIND_REQUIRED)
        message(FATAL_ERROR "Couldn't find KDevelop-PG-Qt.")
    else()
        message(STATUS "Couldn't find KDevelop-PG-Qt.")
    endif()
    message(STATUS "You can set KDEVPGQT_DIR to help cmake find KDevelop-PG-Qt")
    set(KDEVPGQT_FOUND FALSE)

endif( KDEVPGQT_INCLUDE_DIR
 AND KDEVPGQT_EXECUTABLE)

include("${CMAKE_CURRENT_LIST_DIR}/KDevelop-PG-QtMacros.cmake")
