/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000bR\u0011\u0010\u0015\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/CompilerDeserializationConfiguration;", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "skipMetadataVersionCheck", "", "getSkipMetadataVersionCheck", "()Z", "skipPrereleaseCheck", "getSkipPrereleaseCheck", "reportErrorsOnPreReleaseDependencies", "getReportErrorsOnPreReleaseDependencies", "allowUnstableDependencies", "getAllowUnstableDependencies", "typeAliasesAllowed", "getTypeAliasesAllowed", "isJvmPackageNameSupported", "readDeserializedContracts", "getReadDeserializedContracts", "frontend"})
public class CompilerDeserializationConfiguration
implements DeserializationConfiguration {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    private final boolean skipMetadataVersionCheck;
    private final boolean skipPrereleaseCheck;
    private final boolean reportErrorsOnPreReleaseDependencies;
    private final boolean allowUnstableDependencies;
    private final boolean typeAliasesAllowed;
    private final boolean isJvmPackageNameSupported;
    private final boolean readDeserializedContracts;

    public CompilerDeserializationConfiguration(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
        this.skipMetadataVersionCheck = this.languageVersionSettings.getFlag(AnalysisFlags.getSkipMetadataVersionCheck());
        this.skipPrereleaseCheck = this.languageVersionSettings.getFlag(AnalysisFlags.getSkipPrereleaseCheck());
        this.reportErrorsOnPreReleaseDependencies = !this.skipPrereleaseCheck && !this.languageVersionSettings.isPreRelease() && !KotlinCompilerVersion.isPreRelease();
        this.allowUnstableDependencies = this.languageVersionSettings.getFlag(AnalysisFlags.getAllowUnstableDependencies());
        this.typeAliasesAllowed = this.languageVersionSettings.supportsFeature(LanguageFeature.TypeAliases);
        this.isJvmPackageNameSupported = this.languageVersionSettings.supportsFeature(LanguageFeature.JvmPackageName);
        this.readDeserializedContracts = this.languageVersionSettings.supportsFeature(LanguageFeature.ReadDeserializedContracts);
    }

    @NotNull
    protected final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @Override
    public final boolean getSkipMetadataVersionCheck() {
        return this.skipMetadataVersionCheck;
    }

    @Override
    public final boolean getSkipPrereleaseCheck() {
        return this.skipPrereleaseCheck;
    }

    @Override
    public final boolean getReportErrorsOnPreReleaseDependencies() {
        return this.reportErrorsOnPreReleaseDependencies;
    }

    @Override
    public final boolean getAllowUnstableDependencies() {
        return this.allowUnstableDependencies;
    }

    @Override
    public final boolean getTypeAliasesAllowed() {
        return this.typeAliasesAllowed;
    }

    @Override
    public final boolean isJvmPackageNameSupported() {
        return this.isJvmPackageNameSupported;
    }

    @Override
    public final boolean getReadDeserializedContracts() {
        return this.readDeserializedContracts;
    }
}

