'''++

Copyright (C) 2019 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.0-develop.

Abstract: This is an autogenerated Python file in order to allow an easy
 use of the 3MF Library

Interface version: 2.3.0

'''


import ctypes
import platform
import enum
import os

name = "lib3mf"

'''Definition of domain specific exception
'''
class ELib3MFException(Exception):
	def __init__(self, code, message = ''):
		self._code = code
		self._message = message
	
	def __str__(self):
		if self._message:
			return 'Lib3MFException ' + str(self._code) + ': '+ str(self._message)
		return 'Lib3MFException ' + str(self._code)

'''Definition of binding API version
'''
class BindingVersion(enum.IntEnum):
	MAJOR = 2
	MINOR = 3
	MICRO = 0

'''Definition Error Codes
'''
class ErrorCodes(enum.IntEnum):
	SUCCESS = 0
	NOTIMPLEMENTED = 1
	INVALIDPARAM = 2
	INVALIDCAST = 3
	BUFFERTOOSMALL = 4
	GENERICEXCEPTION = 5
	COULDNOTLOADLIBRARY = 6
	COULDNOTFINDLIBRARYEXPORT = 7
	INCOMPATIBLEBINARYVERSION = 8
	CALCULATIONABORTED = 10
	SHOULDNOTBECALLED = 11
	READERCLASSUNKNOWN = 100
	WRITERCLASSUNKNOWN = 101
	ITERATORINVALIDINDEX = 102
	INVALIDMODELRESOURCE = 103
	RESOURCENOTFOUND = 104
	INVALIDMODEL = 105
	INVALIDOBJECT = 106
	INVALIDMESHOBJECT = 107
	INVALIDCOMPONENTSOBJECT = 108
	INVALIDCOMPONENT = 109
	INVALIDBUILDITEM = 110
	INVALIDBASEMATERIALGROUP = 111
	INVALIDSLICESTACKRESOURCE = 112
	INVALIDTEXTURERESOURCE = 113
	INVALIDCOLORGROUP = 114
	INVALIDTEXTURE2DGROUP = 115
	INVALIDCOMPOSITEMATERIALS = 116
	INVALIDMULTIPROPERTYGROUP = 117
	INVALIDRESOURCEINDEX = 120
	ATTACHMENTNOTFOUND = 121
	FORBIDDENCYCLICREFERENCE = 130
	INVALIDATTACHMENTSTREAM = 131
	INVALIDPROPERTYCOUNT = 132
	UNKOWNPROGRESSIDENTIFIER = 140
	ELEMENTCOUNTEXCEEDSLIMIT = 141
	INVALIDRESOURCE = 142
	BEAMLATTICE_INVALID_OBJECTTYPE = 2000
	INVALIDKEYSTORE = 3000
	INVALIDKEYSTORECONSUMER = 3001
	KEYSTORECONSUMERNOTFOUND = 3002
	KEYSTORERESOURCEDATANOTFOUND = 3003
	SECURECONTEXTNOTREGISTERED = 3004
	INVALIDKEYSIZE = 3005

'''Definition of Function Table
'''
class FunctionTable:
	lib3mf_getlibraryversion = None
	lib3mf_getprereleaseinformation = None
	lib3mf_getbuildinformation = None
	lib3mf_getspecificationversion = None
	lib3mf_createmodel = None
	lib3mf_release = None
	lib3mf_acquire = None
	lib3mf_setjournal = None
	lib3mf_getlasterror = None
	lib3mf_getsymbollookupmethod = None
	lib3mf_retrieveprogressmessage = None
	lib3mf_rgbatocolor = None
	lib3mf_floatrgbatocolor = None
	lib3mf_colortorgba = None
	lib3mf_colortofloatrgba = None
	lib3mf_getidentitytransform = None
	lib3mf_getuniformscaletransform = None
	lib3mf_getscaletransform = None
	lib3mf_gettranslationtransform = None
	lib3mf_base_classtypeid = None
	lib3mf_writer_writetofile = None
	lib3mf_writer_getstreamsize = None
	lib3mf_writer_writetobuffer = None
	lib3mf_writer_writetocallback = None
	lib3mf_writer_setprogresscallback = None
	lib3mf_writer_getdecimalprecision = None
	lib3mf_writer_setdecimalprecision = None
	lib3mf_writer_setstrictmodeactive = None
	lib3mf_writer_getstrictmodeactive = None
	lib3mf_writer_getwarning = None
	lib3mf_writer_getwarningcount = None
	lib3mf_writer_addkeywrappingcallback = None
	lib3mf_writer_setcontentencryptioncallback = None
	lib3mf_reader_readfromfile = None
	lib3mf_reader_readfrombuffer = None
	lib3mf_reader_readfromcallback = None
	lib3mf_reader_setprogresscallback = None
	lib3mf_reader_addrelationtoread = None
	lib3mf_reader_removerelationtoread = None
	lib3mf_reader_setstrictmodeactive = None
	lib3mf_reader_getstrictmodeactive = None
	lib3mf_reader_getwarning = None
	lib3mf_reader_getwarningcount = None
	lib3mf_reader_addkeywrappingcallback = None
	lib3mf_reader_setcontentencryptioncallback = None
	lib3mf_packagepart_getpath = None
	lib3mf_packagepart_setpath = None
	lib3mf_resource_getresourceid = None
	lib3mf_resource_getuniqueresourceid = None
	lib3mf_resource_packagepart = None
	lib3mf_resource_setpackagepart = None
	lib3mf_resource_getmodelresourceid = None
	lib3mf_resourceiterator_movenext = None
	lib3mf_resourceiterator_moveprevious = None
	lib3mf_resourceiterator_getcurrent = None
	lib3mf_resourceiterator_clone = None
	lib3mf_resourceiterator_count = None
	lib3mf_slicestackiterator_getcurrentslicestack = None
	lib3mf_objectiterator_getcurrentobject = None
	lib3mf_meshobjectiterator_getcurrentmeshobject = None
	lib3mf_componentsobjectiterator_getcurrentcomponentsobject = None
	lib3mf_texture2diterator_getcurrenttexture2d = None
	lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup = None
	lib3mf_colorgroupiterator_getcurrentcolorgroup = None
	lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup = None
	lib3mf_compositematerialsiterator_getcurrentcompositematerials = None
	lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup = None
	lib3mf_metadata_getnamespace = None
	lib3mf_metadata_setnamespace = None
	lib3mf_metadata_getname = None
	lib3mf_metadata_setname = None
	lib3mf_metadata_getkey = None
	lib3mf_metadata_getmustpreserve = None
	lib3mf_metadata_setmustpreserve = None
	lib3mf_metadata_gettype = None
	lib3mf_metadata_settype = None
	lib3mf_metadata_getvalue = None
	lib3mf_metadata_setvalue = None
	lib3mf_metadatagroup_getmetadatacount = None
	lib3mf_metadatagroup_getmetadata = None
	lib3mf_metadatagroup_getmetadatabykey = None
	lib3mf_metadatagroup_removemetadatabyindex = None
	lib3mf_metadatagroup_removemetadata = None
	lib3mf_metadatagroup_addmetadata = None
	lib3mf_object_gettype = None
	lib3mf_object_settype = None
	lib3mf_object_getname = None
	lib3mf_object_setname = None
	lib3mf_object_getpartnumber = None
	lib3mf_object_setpartnumber = None
	lib3mf_object_ismeshobject = None
	lib3mf_object_iscomponentsobject = None
	lib3mf_object_isvalid = None
	lib3mf_object_setattachmentasthumbnail = None
	lib3mf_object_getthumbnailattachment = None
	lib3mf_object_clearthumbnailattachment = None
	lib3mf_object_getoutbox = None
	lib3mf_object_getuuid = None
	lib3mf_object_setuuid = None
	lib3mf_object_getmetadatagroup = None
	lib3mf_object_setslicesmeshresolution = None
	lib3mf_object_getslicesmeshresolution = None
	lib3mf_object_hasslices = None
	lib3mf_object_clearslicestack = None
	lib3mf_object_getslicestack = None
	lib3mf_object_assignslicestack = None
	lib3mf_meshobject_getvertexcount = None
	lib3mf_meshobject_gettrianglecount = None
	lib3mf_meshobject_getvertex = None
	lib3mf_meshobject_setvertex = None
	lib3mf_meshobject_addvertex = None
	lib3mf_meshobject_getvertices = None
	lib3mf_meshobject_gettriangle = None
	lib3mf_meshobject_settriangle = None
	lib3mf_meshobject_addtriangle = None
	lib3mf_meshobject_gettriangleindices = None
	lib3mf_meshobject_setobjectlevelproperty = None
	lib3mf_meshobject_getobjectlevelproperty = None
	lib3mf_meshobject_settriangleproperties = None
	lib3mf_meshobject_gettriangleproperties = None
	lib3mf_meshobject_setalltriangleproperties = None
	lib3mf_meshobject_getalltriangleproperties = None
	lib3mf_meshobject_clearallproperties = None
	lib3mf_meshobject_setgeometry = None
	lib3mf_meshobject_ismanifoldandoriented = None
	lib3mf_meshobject_beamlattice = None
	lib3mf_beamlattice_getminlength = None
	lib3mf_beamlattice_setminlength = None
	lib3mf_beamlattice_getclipping = None
	lib3mf_beamlattice_setclipping = None
	lib3mf_beamlattice_getrepresentation = None
	lib3mf_beamlattice_setrepresentation = None
	lib3mf_beamlattice_getballoptions = None
	lib3mf_beamlattice_setballoptions = None
	lib3mf_beamlattice_getbeamcount = None
	lib3mf_beamlattice_getbeam = None
	lib3mf_beamlattice_addbeam = None
	lib3mf_beamlattice_setbeam = None
	lib3mf_beamlattice_setbeams = None
	lib3mf_beamlattice_getbeams = None
	lib3mf_beamlattice_getballcount = None
	lib3mf_beamlattice_getball = None
	lib3mf_beamlattice_addball = None
	lib3mf_beamlattice_setball = None
	lib3mf_beamlattice_setballs = None
	lib3mf_beamlattice_getballs = None
	lib3mf_beamlattice_getbeamsetcount = None
	lib3mf_beamlattice_addbeamset = None
	lib3mf_beamlattice_getbeamset = None
	lib3mf_component_getobjectresource = None
	lib3mf_component_getobjectresourceid = None
	lib3mf_component_getuuid = None
	lib3mf_component_setuuid = None
	lib3mf_component_hastransform = None
	lib3mf_component_gettransform = None
	lib3mf_component_settransform = None
	lib3mf_componentsobject_addcomponent = None
	lib3mf_componentsobject_getcomponent = None
	lib3mf_componentsobject_getcomponentcount = None
	lib3mf_beamset_setname = None
	lib3mf_beamset_getname = None
	lib3mf_beamset_setidentifier = None
	lib3mf_beamset_getidentifier = None
	lib3mf_beamset_getreferencecount = None
	lib3mf_beamset_setreferences = None
	lib3mf_beamset_getreferences = None
	lib3mf_beamset_getballreferencecount = None
	lib3mf_beamset_setballreferences = None
	lib3mf_beamset_getballreferences = None
	lib3mf_basematerialgroup_getcount = None
	lib3mf_basematerialgroup_getallpropertyids = None
	lib3mf_basematerialgroup_addmaterial = None
	lib3mf_basematerialgroup_removematerial = None
	lib3mf_basematerialgroup_getname = None
	lib3mf_basematerialgroup_setname = None
	lib3mf_basematerialgroup_setdisplaycolor = None
	lib3mf_basematerialgroup_getdisplaycolor = None
	lib3mf_colorgroup_getcount = None
	lib3mf_colorgroup_getallpropertyids = None
	lib3mf_colorgroup_addcolor = None
	lib3mf_colorgroup_removecolor = None
	lib3mf_colorgroup_setcolor = None
	lib3mf_colorgroup_getcolor = None
	lib3mf_texture2dgroup_getcount = None
	lib3mf_texture2dgroup_getallpropertyids = None
	lib3mf_texture2dgroup_addtex2coord = None
	lib3mf_texture2dgroup_gettex2coord = None
	lib3mf_texture2dgroup_removetex2coord = None
	lib3mf_texture2dgroup_gettexture2d = None
	lib3mf_compositematerials_getcount = None
	lib3mf_compositematerials_getallpropertyids = None
	lib3mf_compositematerials_getbasematerialgroup = None
	lib3mf_compositematerials_addcomposite = None
	lib3mf_compositematerials_removecomposite = None
	lib3mf_compositematerials_getcomposite = None
	lib3mf_multipropertygroup_getcount = None
	lib3mf_multipropertygroup_getallpropertyids = None
	lib3mf_multipropertygroup_addmultiproperty = None
	lib3mf_multipropertygroup_setmultiproperty = None
	lib3mf_multipropertygroup_getmultiproperty = None
	lib3mf_multipropertygroup_removemultiproperty = None
	lib3mf_multipropertygroup_getlayercount = None
	lib3mf_multipropertygroup_addlayer = None
	lib3mf_multipropertygroup_getlayer = None
	lib3mf_multipropertygroup_removelayer = None
	lib3mf_attachment_getpath = None
	lib3mf_attachment_setpath = None
	lib3mf_attachment_packagepart = None
	lib3mf_attachment_getrelationshiptype = None
	lib3mf_attachment_setrelationshiptype = None
	lib3mf_attachment_writetofile = None
	lib3mf_attachment_readfromfile = None
	lib3mf_attachment_readfromcallback = None
	lib3mf_attachment_getstreamsize = None
	lib3mf_attachment_writetobuffer = None
	lib3mf_attachment_readfrombuffer = None
	lib3mf_texture2d_getattachment = None
	lib3mf_texture2d_setattachment = None
	lib3mf_texture2d_getcontenttype = None
	lib3mf_texture2d_setcontenttype = None
	lib3mf_texture2d_gettilestyleuv = None
	lib3mf_texture2d_settilestyleuv = None
	lib3mf_texture2d_getfilter = None
	lib3mf_texture2d_setfilter = None
	lib3mf_builditem_getobjectresource = None
	lib3mf_builditem_getuuid = None
	lib3mf_builditem_setuuid = None
	lib3mf_builditem_getobjectresourceid = None
	lib3mf_builditem_hasobjecttransform = None
	lib3mf_builditem_getobjecttransform = None
	lib3mf_builditem_setobjecttransform = None
	lib3mf_builditem_getpartnumber = None
	lib3mf_builditem_setpartnumber = None
	lib3mf_builditem_getmetadatagroup = None
	lib3mf_builditem_getoutbox = None
	lib3mf_builditemiterator_movenext = None
	lib3mf_builditemiterator_moveprevious = None
	lib3mf_builditemiterator_getcurrent = None
	lib3mf_builditemiterator_clone = None
	lib3mf_builditemiterator_count = None
	lib3mf_slice_setvertices = None
	lib3mf_slice_getvertices = None
	lib3mf_slice_getvertexcount = None
	lib3mf_slice_addpolygon = None
	lib3mf_slice_getpolygoncount = None
	lib3mf_slice_setpolygonindices = None
	lib3mf_slice_getpolygonindices = None
	lib3mf_slice_getpolygonindexcount = None
	lib3mf_slice_getztop = None
	lib3mf_slicestack_getbottomz = None
	lib3mf_slicestack_getslicecount = None
	lib3mf_slicestack_getslice = None
	lib3mf_slicestack_addslice = None
	lib3mf_slicestack_getslicerefcount = None
	lib3mf_slicestack_addslicestackreference = None
	lib3mf_slicestack_getslicestackreference = None
	lib3mf_slicestack_collapseslicereferences = None
	lib3mf_slicestack_setownpath = None
	lib3mf_slicestack_getownpath = None
	lib3mf_consumer_getconsumerid = None
	lib3mf_consumer_getkeyid = None
	lib3mf_consumer_getkeyvalue = None
	lib3mf_accessright_getconsumer = None
	lib3mf_accessright_getwrappingalgorithm = None
	lib3mf_accessright_getmgfalgorithm = None
	lib3mf_accessright_getdigestmethod = None
	lib3mf_contentencryptionparams_getencryptionalgorithm = None
	lib3mf_contentencryptionparams_getkey = None
	lib3mf_contentencryptionparams_getinitializationvector = None
	lib3mf_contentencryptionparams_getauthenticationtag = None
	lib3mf_contentencryptionparams_setauthenticationtag = None
	lib3mf_contentencryptionparams_getadditionalauthenticationdata = None
	lib3mf_contentencryptionparams_getdescriptor = None
	lib3mf_contentencryptionparams_getkeyuuid = None
	lib3mf_resourcedata_getpath = None
	lib3mf_resourcedata_getencryptionalgorithm = None
	lib3mf_resourcedata_getcompression = None
	lib3mf_resourcedata_getadditionalauthenticationdata = None
	lib3mf_resourcedatagroup_getkeyuuid = None
	lib3mf_resourcedatagroup_addaccessright = None
	lib3mf_resourcedatagroup_findaccessrightbyconsumer = None
	lib3mf_resourcedatagroup_removeaccessright = None
	lib3mf_keystore_addconsumer = None
	lib3mf_keystore_getconsumercount = None
	lib3mf_keystore_getconsumer = None
	lib3mf_keystore_removeconsumer = None
	lib3mf_keystore_findconsumer = None
	lib3mf_keystore_getresourcedatagroupcount = None
	lib3mf_keystore_addresourcedatagroup = None
	lib3mf_keystore_getresourcedatagroup = None
	lib3mf_keystore_removeresourcedatagroup = None
	lib3mf_keystore_findresourcedatagroup = None
	lib3mf_keystore_addresourcedata = None
	lib3mf_keystore_removeresourcedata = None
	lib3mf_keystore_findresourcedata = None
	lib3mf_keystore_getresourcedatacount = None
	lib3mf_keystore_getresourcedata = None
	lib3mf_keystore_getuuid = None
	lib3mf_keystore_setuuid = None
	lib3mf_model_rootmodelpart = None
	lib3mf_model_findorcreatepackagepart = None
	lib3mf_model_setunit = None
	lib3mf_model_getunit = None
	lib3mf_model_getlanguage = None
	lib3mf_model_setlanguage = None
	lib3mf_model_querywriter = None
	lib3mf_model_queryreader = None
	lib3mf_model_getresourcebyid = None
	lib3mf_model_gettexture2dbyid = None
	lib3mf_model_getpropertytypebyid = None
	lib3mf_model_getbasematerialgroupbyid = None
	lib3mf_model_gettexture2dgroupbyid = None
	lib3mf_model_getcompositematerialsbyid = None
	lib3mf_model_getmultipropertygroupbyid = None
	lib3mf_model_getmeshobjectbyid = None
	lib3mf_model_getcomponentsobjectbyid = None
	lib3mf_model_getcolorgroupbyid = None
	lib3mf_model_getslicestackbyid = None
	lib3mf_model_getbuilduuid = None
	lib3mf_model_setbuilduuid = None
	lib3mf_model_getbuilditems = None
	lib3mf_model_getoutbox = None
	lib3mf_model_getresources = None
	lib3mf_model_getobjects = None
	lib3mf_model_getmeshobjects = None
	lib3mf_model_getcomponentsobjects = None
	lib3mf_model_gettexture2ds = None
	lib3mf_model_getbasematerialgroups = None
	lib3mf_model_getcolorgroups = None
	lib3mf_model_gettexture2dgroups = None
	lib3mf_model_getcompositematerials = None
	lib3mf_model_getmultipropertygroups = None
	lib3mf_model_getslicestacks = None
	lib3mf_model_mergetomodel = None
	lib3mf_model_addmeshobject = None
	lib3mf_model_addcomponentsobject = None
	lib3mf_model_addslicestack = None
	lib3mf_model_addtexture2dfromattachment = None
	lib3mf_model_addbasematerialgroup = None
	lib3mf_model_addcolorgroup = None
	lib3mf_model_addtexture2dgroup = None
	lib3mf_model_addcompositematerials = None
	lib3mf_model_addmultipropertygroup = None
	lib3mf_model_addbuilditem = None
	lib3mf_model_removebuilditem = None
	lib3mf_model_getmetadatagroup = None
	lib3mf_model_addattachment = None
	lib3mf_model_removeattachment = None
	lib3mf_model_getattachment = None
	lib3mf_model_findattachment = None
	lib3mf_model_getattachmentcount = None
	lib3mf_model_haspackagethumbnailattachment = None
	lib3mf_model_createpackagethumbnailattachment = None
	lib3mf_model_getpackagethumbnailattachment = None
	lib3mf_model_removepackagethumbnailattachment = None
	lib3mf_model_addcustomcontenttype = None
	lib3mf_model_removecustomcontenttype = None
	lib3mf_model_setrandomnumbercallback = None
	lib3mf_model_getkeystore = None

'''Definition of Enumerations
'''

'''Definition of base enumeration for ctypes
'''
class CTypesEnum(enum.IntEnum):
	def from_param(obj):
		return int(obj)

'''Definition of PropertyType
'''
class PropertyType(CTypesEnum):
	NoPropertyType = 0
	BaseMaterial = 1
	TexCoord = 2
	Colors = 3
	Composite = 4
	Multi = 5
'''Definition of SlicesMeshResolution
'''
class SlicesMeshResolution(CTypesEnum):
	Fullres = 0
	Lowres = 1
'''Definition of ModelUnit
'''
class ModelUnit(CTypesEnum):
	MicroMeter = 0
	MilliMeter = 1
	CentiMeter = 2
	Inch = 3
	Foot = 4
	Meter = 5
'''Definition of ObjectType
'''
class ObjectType(CTypesEnum):
	Other = 0
	Model = 1
	Support = 2
	SolidSupport = 3
'''Definition of TextureType
'''
class TextureType(CTypesEnum):
	Unknown = 0
	PNG = 1
	JPEG = 2
'''Definition of TextureTileStyle
'''
class TextureTileStyle(CTypesEnum):
	Wrap = 0
	Mirror = 1
	Clamp = 2
	NoTileStyle = 3
'''Definition of TextureFilter
'''
class TextureFilter(CTypesEnum):
	Auto = 0
	Linear = 1
	Nearest = 2
'''Definition of BeamLatticeCapMode
'''
class BeamLatticeCapMode(CTypesEnum):
	Sphere = 0
	HemiSphere = 1
	Butt = 2
'''Definition of BeamLatticeClipMode
'''
class BeamLatticeClipMode(CTypesEnum):
	NoClipMode = 0
	Inside = 1
	Outside = 2
'''Definition of BeamLatticeBallMode
'''
class BeamLatticeBallMode(CTypesEnum):
	BeamLatticeBallModeNone = 0
	Mixed = 1
	All = 2
'''Definition of ProgressIdentifier
'''
class ProgressIdentifier(CTypesEnum):
	QUERYCANCELED = 0
	DONE = 1
	CLEANUP = 2
	READSTREAM = 3
	EXTRACTOPCPACKAGE = 4
	READNONROOTMODELS = 5
	READROOTMODEL = 6
	READRESOURCES = 7
	READMESH = 8
	READSLICES = 9
	READBUILD = 10
	READCUSTOMATTACHMENT = 11
	READTEXTURETACHMENTS = 12
	CREATEOPCPACKAGE = 13
	WRITEMODELSTOSTREAM = 14
	WRITEROOTMODEL = 15
	WRITENONROOTMODELS = 16
	WRITEATTACHMENTS = 17
	WRITECONTENTTYPES = 18
	WRITENOBJECTS = 19
	WRITENODES = 20
	WRITETRIANGLES = 21
	WRITESLICES = 22
	WRITEKEYSTORE = 23
'''Definition of BlendMethod
'''
class BlendMethod(CTypesEnum):
	NoBlendMethod = 0
	Mix = 1
	Multiply = 2
'''Definition of EncryptionAlgorithm
'''
class EncryptionAlgorithm(CTypesEnum):
	AES256_GCM = 1
'''Definition of WrappingAlgorithm
'''
class WrappingAlgorithm(CTypesEnum):
	RSA_OAEP = 0
'''Definition of MgfAlgorithm
'''
class MgfAlgorithm(CTypesEnum):
	MGF1_SHA1 = 160
	MGF1_SHA224 = 224
	MGF1_SHA256 = 256
	MGF1_SHA384 = 384
	MGF1_SHA512 = 512
'''Definition of DigestMethod
'''
class DigestMethod(CTypesEnum):
	SHA1 = 160
	SHA256 = 256
'''Definition of Compression
'''
class Compression(CTypesEnum):
	NoCompression = 0
	Deflate = 1

'''Definition of Structs
'''
'''Definition of Triangle
'''
class Triangle(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("Indices", ctypes.c_uint32 * 3)
	]
'''Definition of TriangleProperties
'''
class TriangleProperties(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("ResourceID", ctypes.c_uint32), 
		("PropertyIDs", ctypes.c_uint32 * 3)
	]
'''Definition of Position
'''
class Position(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("Coordinates", ctypes.c_float * 3)
	]
'''Definition of Position2D
'''
class Position2D(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("Coordinates", ctypes.c_float * 2)
	]
'''Definition of CompositeConstituent
'''
class CompositeConstituent(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("PropertyID", ctypes.c_uint32), 
		("MixingRatio", ctypes.c_double)
	]
'''Definition of MultiPropertyLayer
'''
class MultiPropertyLayer(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("ResourceID", ctypes.c_uint32), 
		("TheBlendMethod", ctypes.c_int32)
	]
'''Definition of Tex2Coord
'''
class Tex2Coord(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("U", ctypes.c_double), 
		("V", ctypes.c_double)
	]
'''Definition of Transform
'''
class Transform(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("Fields", (ctypes.c_float * 3) * 4)
	]
'''Definition of Box
'''
class Box(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("MinCoordinate", ctypes.c_float * 3), 
		("MaxCoordinate", ctypes.c_float * 3)
	]
'''Definition of Color
'''
class Color(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("Red", ctypes.c_uint8), 
		("Green", ctypes.c_uint8), 
		("Blue", ctypes.c_uint8), 
		("Alpha", ctypes.c_uint8)
	]
'''Definition of Beam
'''
class Beam(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("Indices", ctypes.c_uint32 * 2), 
		("Radii", ctypes.c_double * 2), 
		("CapModes", ctypes.c_int32 * 2)
	]
'''Definition of Ball
'''
class Ball(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("Index", ctypes.c_uint32), 
		("Radius", ctypes.c_double)
	]

'''Definition of Function Types
'''
'''Definition of ProgressCallback
		A callback function
'''
ProgressCallback = ctypes.CFUNCTYPE(ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_double, ProgressIdentifier, ctypes.c_void_p)
'''Definition of WriteCallback
		Callback to call for writing a data chunk
'''
WriteCallback = ctypes.CFUNCTYPE(ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.c_void_p)
'''Definition of ReadCallback
		Callback to call for reading a data chunk
'''
ReadCallback = ctypes.CFUNCTYPE(ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.c_void_p)
'''Definition of SeekCallback
		Callback to call for seeking in the stream
'''
SeekCallback = ctypes.CFUNCTYPE(ctypes.c_void_p, ctypes.c_uint64, ctypes.c_void_p)
'''Definition of RandomNumberCallback
		Callback to generate random numbers
'''
RandomNumberCallback = ctypes.CFUNCTYPE(ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
'''Definition of KeyWrappingCallback
		A callback used to wrap (encrypt) the content key available in keystore resource group
'''
KeyWrappingCallback = ctypes.CFUNCTYPE(ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
'''Definition of ContentEncryptionCallback
		A callback to encrypt/decrypt content called on each resource encrypted. This might be called several times depending on content size. If Input is not available(either null or size is 0), clients must return the result of authenticated tag generation/validation.
'''
ContentEncryptionCallback = ctypes.CFUNCTYPE(ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))


'''Wrapper Class Implementation
'''
class Wrapper:

	def __init__(self, libraryName = None, symbolLookupMethodAddress = None):
		ending = ''
		if platform.system() == 'Windows':
			ending = 'dll'
		elif platform.system() == 'Linux':
			ending = 'so'
		elif platform.system() == 'Darwin':
			ending = 'dylib'
		else:
			raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY)
		
		if (not libraryName) and (not symbolLookupMethodAddress):
			libraryName = os.path.join(os.path.dirname(os.path.realpath(__file__)),'lib3mf')
		
		if libraryName is not None:
			path = libraryName + '.' + ending
			try:
				self.lib = ctypes.CDLL(path)
			except Exception as e:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(e) + '| "'+path + '"' )
			
			self._loadFunctionTable()
		elif symbolLookupMethodAddress is not None:
				self.lib = FunctionTable()
				self._loadFunctionTableFromMethod(symbolLookupMethodAddress)
		else:
			raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(e))
		
		self._checkBinaryVersion()
	
	def _loadFunctionTableFromMethod(self, symbolLookupMethodAddress):
		try:
			symbolLookupMethodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			symbolLookupMethod = symbolLookupMethodType(int(symbolLookupMethodAddress))
			
			methodAddress = ctypes.c_void_p()
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_getlibraryversion")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_getlibraryversion = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_getprereleaseinformation")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_getprereleaseinformation = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_getbuildinformation")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_getbuildinformation = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_getspecificationversion")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_char_p, ctypes.POINTER(ctypes.c_bool), ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_getspecificationversion = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_createmodel")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_createmodel = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_release")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_release = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_acquire")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_acquire = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_setjournal")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_char_p)
			self.lib.lib3mf_setjournal = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_getlasterror")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_getlasterror = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_getsymbollookupmethod")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_getsymbollookupmethod = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_retrieveprogressmessage")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ProgressIdentifier, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_retrieveprogressmessage = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_rgbatocolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_uint8, ctypes.c_uint8, ctypes.c_uint8, ctypes.c_uint8, ctypes.POINTER(Color))
			self.lib.lib3mf_rgbatocolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_floatrgbatocolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_float, ctypes.c_float, ctypes.c_float, ctypes.c_float, ctypes.POINTER(Color))
			self.lib.lib3mf_floatrgbatocolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_colortorgba")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(Color), ctypes.POINTER(ctypes.c_uint8), ctypes.POINTER(ctypes.c_uint8), ctypes.POINTER(ctypes.c_uint8), ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_colortorgba = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_colortofloatrgba")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(Color), ctypes.POINTER(ctypes.c_float), ctypes.POINTER(ctypes.c_float), ctypes.POINTER(ctypes.c_float), ctypes.POINTER(ctypes.c_float))
			self.lib.lib3mf_colortofloatrgba = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_getidentitytransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(Transform))
			self.lib.lib3mf_getidentitytransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_getuniformscaletransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_float, ctypes.POINTER(Transform))
			self.lib.lib3mf_getuniformscaletransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_getscaletransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_float, ctypes.c_float, ctypes.c_float, ctypes.POINTER(Transform))
			self.lib.lib3mf_getscaletransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_gettranslationtransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_float, ctypes.c_float, ctypes.c_float, ctypes.POINTER(Transform))
			self.lib.lib3mf_gettranslationtransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_base_classtypeid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_base_classtypeid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_writetofile")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_writer_writetofile = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_getstreamsize")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_writer_getstreamsize = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_writetobuffer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_writer_writetobuffer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_writetocallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, WriteCallback, SeekCallback, ctypes.c_void_p)
			self.lib.lib3mf_writer_writetocallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_setprogresscallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ProgressCallback, ctypes.c_void_p)
			self.lib.lib3mf_writer_setprogresscallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_getdecimalprecision")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_writer_getdecimalprecision = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_setdecimalprecision")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_writer_setdecimalprecision = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_setstrictmodeactive")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_bool)
			self.lib.lib3mf_writer_setstrictmodeactive = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_getstrictmodeactive")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_writer_getstrictmodeactive = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_getwarning")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_uint32), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_writer_getwarning = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_getwarningcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_writer_getwarningcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_addkeywrappingcallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, KeyWrappingCallback, ctypes.c_void_p)
			self.lib.lib3mf_writer_addkeywrappingcallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_setcontentencryptioncallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ContentEncryptionCallback, ctypes.c_void_p)
			self.lib.lib3mf_writer_setcontentencryptioncallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_readfromfile")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_reader_readfromfile = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_readfrombuffer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_reader_readfrombuffer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_readfromcallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ReadCallback, ctypes.c_uint64, SeekCallback, ctypes.c_void_p)
			self.lib.lib3mf_reader_readfromcallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_setprogresscallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ProgressCallback, ctypes.c_void_p)
			self.lib.lib3mf_reader_setprogresscallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_addrelationtoread")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_reader_addrelationtoread = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_removerelationtoread")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_reader_removerelationtoread = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_setstrictmodeactive")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_bool)
			self.lib.lib3mf_reader_setstrictmodeactive = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_getstrictmodeactive")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_reader_getstrictmodeactive = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_getwarning")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_uint32), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_reader_getwarning = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_getwarningcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_reader_getwarningcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_addkeywrappingcallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, KeyWrappingCallback, ctypes.c_void_p)
			self.lib.lib3mf_reader_addkeywrappingcallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_setcontentencryptioncallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ContentEncryptionCallback, ctypes.c_void_p)
			self.lib.lib3mf_reader_setcontentencryptioncallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_packagepart_getpath")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_packagepart_getpath = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_packagepart_setpath")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_packagepart_setpath = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resource_getresourceid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_resource_getresourceid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resource_getuniqueresourceid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_resource_getuniqueresourceid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resource_packagepart")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_resource_packagepart = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resource_setpackagepart")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_resource_setpackagepart = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resource_getmodelresourceid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_resource_getmodelresourceid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourceiterator_movenext")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_resourceiterator_movenext = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourceiterator_moveprevious")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_resourceiterator_moveprevious = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourceiterator_getcurrent")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_resourceiterator_getcurrent = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourceiterator_clone")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_resourceiterator_clone = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourceiterator_count")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_resourceiterator_count = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestackiterator_getcurrentslicestack")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_slicestackiterator_getcurrentslicestack = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_objectiterator_getcurrentobject")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_objectiterator_getcurrentobject = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobjectiterator_getcurrentmeshobject")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_meshobjectiterator_getcurrentmeshobject = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_componentsobjectiterator_getcurrentcomponentsobject")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_componentsobjectiterator_getcurrentcomponentsobject = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2diterator_getcurrenttexture2d")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_texture2diterator_getcurrenttexture2d = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_colorgroupiterator_getcurrentcolorgroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_colorgroupiterator_getcurrentcolorgroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_compositematerialsiterator_getcurrentcompositematerials")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_compositematerialsiterator_getcurrentcompositematerials = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_getnamespace")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_metadata_getnamespace = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_setnamespace")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_metadata_setnamespace = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_getname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_metadata_getname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_setname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_metadata_setname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_getkey")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_metadata_getkey = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_getmustpreserve")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_metadata_getmustpreserve = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_setmustpreserve")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_bool)
			self.lib.lib3mf_metadata_setmustpreserve = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_gettype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_metadata_gettype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_settype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_metadata_settype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_getvalue")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_metadata_getvalue = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_setvalue")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_metadata_setvalue = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadatagroup_getmetadatacount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_metadatagroup_getmetadatacount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadatagroup_getmetadata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_metadatagroup_getmetadata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadatagroup_getmetadatabykey")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_metadatagroup_getmetadatabykey = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadatagroup_removemetadatabyindex")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_metadatagroup_removemetadatabyindex = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadatagroup_removemetadata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_metadatagroup_removemetadata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadatagroup_addmetadata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_bool, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_metadatagroup_addmetadata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_gettype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_object_gettype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_settype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ObjectType)
			self.lib.lib3mf_object_settype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_getname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_object_getname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_setname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_object_setname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_getpartnumber")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_object_getpartnumber = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_setpartnumber")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_object_setpartnumber = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_ismeshobject")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_object_ismeshobject = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_iscomponentsobject")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_object_iscomponentsobject = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_isvalid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_object_isvalid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_setattachmentasthumbnail")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_object_setattachmentasthumbnail = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_getthumbnailattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_object_getthumbnailattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_clearthumbnailattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_object_clearthumbnailattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_getoutbox")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Box))
			self.lib.lib3mf_object_getoutbox = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_getuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_object_getuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_setuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_object_setuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_getmetadatagroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_object_getmetadatagroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_setslicesmeshresolution")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, SlicesMeshResolution)
			self.lib.lib3mf_object_setslicesmeshresolution = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_getslicesmeshresolution")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_object_getslicesmeshresolution = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_hasslices")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_bool, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_object_hasslices = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_clearslicestack")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_object_clearslicestack = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_getslicestack")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_object_getslicestack = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_assignslicestack")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_object_assignslicestack = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_getvertexcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_meshobject_getvertexcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_gettrianglecount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_meshobject_gettrianglecount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_getvertex")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Position))
			self.lib.lib3mf_meshobject_getvertex = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_setvertex")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Position))
			self.lib.lib3mf_meshobject_setvertex = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_addvertex")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Position), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_meshobject_addvertex = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_getvertices")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Position))
			self.lib.lib3mf_meshobject_getvertices = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_gettriangle")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Triangle))
			self.lib.lib3mf_meshobject_gettriangle = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_settriangle")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Triangle))
			self.lib.lib3mf_meshobject_settriangle = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_addtriangle")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Triangle), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_meshobject_addtriangle = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_gettriangleindices")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Triangle))
			self.lib.lib3mf_meshobject_gettriangleindices = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_setobjectlevelproperty")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint32)
			self.lib.lib3mf_meshobject_setobjectlevelproperty = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_getobjectlevelproperty")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_meshobject_getobjectlevelproperty = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_settriangleproperties")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(TriangleProperties))
			self.lib.lib3mf_meshobject_settriangleproperties = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_gettriangleproperties")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(TriangleProperties))
			self.lib.lib3mf_meshobject_gettriangleproperties = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_setalltriangleproperties")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(TriangleProperties))
			self.lib.lib3mf_meshobject_setalltriangleproperties = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_getalltriangleproperties")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(TriangleProperties))
			self.lib.lib3mf_meshobject_getalltriangleproperties = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_clearallproperties")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_meshobject_clearallproperties = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_setgeometry")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(Position), ctypes.c_uint64, ctypes.POINTER(Triangle))
			self.lib.lib3mf_meshobject_setgeometry = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_ismanifoldandoriented")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_meshobject_ismanifoldandoriented = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_beamlattice")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_meshobject_beamlattice = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getminlength")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_double))
			self.lib.lib3mf_beamlattice_getminlength = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_setminlength")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_double)
			self.lib.lib3mf_beamlattice_setminlength = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getclipping")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamlattice_getclipping = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_setclipping")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, BeamLatticeClipMode, ctypes.c_uint32)
			self.lib.lib3mf_beamlattice_setclipping = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getrepresentation")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamlattice_getrepresentation = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_setrepresentation")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_beamlattice_setrepresentation = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getballoptions")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32), ctypes.POINTER(ctypes.c_double))
			self.lib.lib3mf_beamlattice_getballoptions = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_setballoptions")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, BeamLatticeBallMode, ctypes.c_double)
			self.lib.lib3mf_beamlattice_setballoptions = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getbeamcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamlattice_getbeamcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getbeam")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Beam))
			self.lib.lib3mf_beamlattice_getbeam = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_addbeam")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Beam), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamlattice_addbeam = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_setbeam")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Beam))
			self.lib.lib3mf_beamlattice_setbeam = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_setbeams")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(Beam))
			self.lib.lib3mf_beamlattice_setbeams = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getbeams")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Beam))
			self.lib.lib3mf_beamlattice_getbeams = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getballcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamlattice_getballcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getball")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Ball))
			self.lib.lib3mf_beamlattice_getball = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_addball")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Ball), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamlattice_addball = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_setball")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Ball))
			self.lib.lib3mf_beamlattice_setball = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_setballs")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(Ball))
			self.lib.lib3mf_beamlattice_setballs = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getballs")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Ball))
			self.lib.lib3mf_beamlattice_getballs = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getbeamsetcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamlattice_getbeamsetcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_addbeamset")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_beamlattice_addbeamset = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getbeamset")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_beamlattice_getbeamset = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_component_getobjectresource")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_component_getobjectresource = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_component_getobjectresourceid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_component_getobjectresourceid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_component_getuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_component_getuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_component_setuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_component_setuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_component_hastransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_component_hastransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_component_gettransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Transform))
			self.lib.lib3mf_component_gettransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_component_settransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Transform))
			self.lib.lib3mf_component_settransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_componentsobject_addcomponent")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(Transform), ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_componentsobject_addcomponent = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_componentsobject_getcomponent")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_componentsobject_getcomponent = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_componentsobject_getcomponentcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_componentsobject_getcomponentcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_setname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_beamset_setname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_getname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_beamset_getname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_setidentifier")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_beamset_setidentifier = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_getidentifier")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_beamset_getidentifier = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_getreferencecount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamset_getreferencecount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_setreferences")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamset_setreferences = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_getreferences")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamset_getreferences = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_getballreferencecount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamset_getballreferencecount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_setballreferences")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamset_setballreferences = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_getballreferences")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamset_getballreferences = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_basematerialgroup_getcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_basematerialgroup_getcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_basematerialgroup_getallpropertyids")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_basematerialgroup_getallpropertyids = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_basematerialgroup_addmaterial")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(Color), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_basematerialgroup_addmaterial = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_basematerialgroup_removematerial")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_basematerialgroup_removematerial = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_basematerialgroup_getname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_basematerialgroup_getname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_basematerialgroup_setname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.c_char_p)
			self.lib.lib3mf_basematerialgroup_setname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_basematerialgroup_setdisplaycolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Color))
			self.lib.lib3mf_basematerialgroup_setdisplaycolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_basematerialgroup_getdisplaycolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Color))
			self.lib.lib3mf_basematerialgroup_getdisplaycolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_colorgroup_getcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_colorgroup_getcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_colorgroup_getallpropertyids")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_colorgroup_getallpropertyids = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_colorgroup_addcolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Color), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_colorgroup_addcolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_colorgroup_removecolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_colorgroup_removecolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_colorgroup_setcolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Color))
			self.lib.lib3mf_colorgroup_setcolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_colorgroup_getcolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Color))
			self.lib.lib3mf_colorgroup_getcolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2dgroup_getcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_texture2dgroup_getcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2dgroup_getallpropertyids")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_texture2dgroup_getallpropertyids = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2dgroup_addtex2coord")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Tex2Coord), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_texture2dgroup_addtex2coord = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2dgroup_gettex2coord")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Tex2Coord))
			self.lib.lib3mf_texture2dgroup_gettex2coord = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2dgroup_removetex2coord")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_texture2dgroup_removetex2coord = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2dgroup_gettexture2d")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_texture2dgroup_gettexture2d = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_compositematerials_getcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_compositematerials_getcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_compositematerials_getallpropertyids")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_compositematerials_getallpropertyids = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_compositematerials_getbasematerialgroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_compositematerials_getbasematerialgroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_compositematerials_addcomposite")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(CompositeConstituent), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_compositematerials_addcomposite = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_compositematerials_removecomposite")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_compositematerials_removecomposite = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_compositematerials_getcomposite")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(CompositeConstituent))
			self.lib.lib3mf_compositematerials_getcomposite = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_getcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_multipropertygroup_getcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_getallpropertyids")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_multipropertygroup_getallpropertyids = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_addmultiproperty")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_multipropertygroup_addmultiproperty = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_setmultiproperty")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_multipropertygroup_setmultiproperty = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_getmultiproperty")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_multipropertygroup_getmultiproperty = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_removemultiproperty")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_multipropertygroup_removemultiproperty = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_getlayercount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_multipropertygroup_getlayercount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_addlayer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(MultiPropertyLayer), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_multipropertygroup_addlayer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_getlayer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(MultiPropertyLayer))
			self.lib.lib3mf_multipropertygroup_getlayer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_removelayer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_multipropertygroup_removelayer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_getpath")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_attachment_getpath = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_setpath")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_attachment_setpath = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_packagepart")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_attachment_packagepart = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_getrelationshiptype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_attachment_getrelationshiptype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_setrelationshiptype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_attachment_setrelationshiptype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_writetofile")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_attachment_writetofile = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_readfromfile")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_attachment_readfromfile = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_readfromcallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ReadCallback, ctypes.c_uint64, SeekCallback, ctypes.c_void_p)
			self.lib.lib3mf_attachment_readfromcallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_getstreamsize")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_attachment_getstreamsize = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_writetobuffer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_attachment_writetobuffer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_readfrombuffer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_attachment_readfrombuffer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2d_getattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_texture2d_getattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2d_setattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_texture2d_setattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2d_getcontenttype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_texture2d_getcontenttype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2d_setcontenttype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, TextureType)
			self.lib.lib3mf_texture2d_setcontenttype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2d_gettilestyleuv")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32), ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_texture2d_gettilestyleuv = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2d_settilestyleuv")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, TextureTileStyle, TextureTileStyle)
			self.lib.lib3mf_texture2d_settilestyleuv = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2d_getfilter")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_texture2d_getfilter = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2d_setfilter")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, TextureFilter)
			self.lib.lib3mf_texture2d_setfilter = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_getobjectresource")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_builditem_getobjectresource = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_getuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_builditem_getuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_setuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_builditem_setuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_getobjectresourceid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_builditem_getobjectresourceid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_hasobjecttransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_builditem_hasobjecttransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_getobjecttransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Transform))
			self.lib.lib3mf_builditem_getobjecttransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_setobjecttransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Transform))
			self.lib.lib3mf_builditem_setobjecttransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_getpartnumber")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_builditem_getpartnumber = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_setpartnumber")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_builditem_setpartnumber = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_getmetadatagroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_builditem_getmetadatagroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_getoutbox")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Box))
			self.lib.lib3mf_builditem_getoutbox = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditemiterator_movenext")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_builditemiterator_movenext = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditemiterator_moveprevious")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_builditemiterator_moveprevious = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditemiterator_getcurrent")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_builditemiterator_getcurrent = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditemiterator_clone")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_builditemiterator_clone = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditemiterator_count")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_builditemiterator_count = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slice_setvertices")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(Position2D))
			self.lib.lib3mf_slice_setvertices = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slice_getvertices")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Position2D))
			self.lib.lib3mf_slice_getvertices = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slice_getvertexcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_slice_getvertexcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slice_addpolygon")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_slice_addpolygon = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slice_getpolygoncount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_slice_getpolygoncount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slice_setpolygonindices")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_slice_setpolygonindices = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slice_getpolygonindices")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_slice_getpolygonindices = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slice_getpolygonindexcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_slice_getpolygonindexcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slice_getztop")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_double))
			self.lib.lib3mf_slice_getztop = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_getbottomz")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_double))
			self.lib.lib3mf_slicestack_getbottomz = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_getslicecount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_slicestack_getslicecount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_getslice")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_slicestack_getslice = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_addslice")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_double, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_slicestack_addslice = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_getslicerefcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_slicestack_getslicerefcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_addslicestackreference")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_slicestack_addslicestackreference = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_getslicestackreference")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_slicestack_getslicestackreference = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_collapseslicereferences")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_slicestack_collapseslicereferences = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_setownpath")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_slicestack_setownpath = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_getownpath")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_slicestack_getownpath = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_consumer_getconsumerid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_consumer_getconsumerid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_consumer_getkeyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_consumer_getkeyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_consumer_getkeyvalue")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_consumer_getkeyvalue = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_accessright_getconsumer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_accessright_getconsumer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_accessright_getwrappingalgorithm")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_accessright_getwrappingalgorithm = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_accessright_getmgfalgorithm")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_accessright_getmgfalgorithm = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_accessright_getdigestmethod")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_accessright_getdigestmethod = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_contentencryptionparams_getencryptionalgorithm")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_contentencryptionparams_getencryptionalgorithm = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_contentencryptionparams_getkey")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_contentencryptionparams_getkey = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_contentencryptionparams_getinitializationvector")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_contentencryptionparams_getinitializationvector = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_contentencryptionparams_getauthenticationtag")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_contentencryptionparams_getauthenticationtag = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_contentencryptionparams_setauthenticationtag")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_contentencryptionparams_setauthenticationtag = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_contentencryptionparams_getadditionalauthenticationdata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_contentencryptionparams_getadditionalauthenticationdata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_contentencryptionparams_getdescriptor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_contentencryptionparams_getdescriptor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_contentencryptionparams_getkeyuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_contentencryptionparams_getkeyuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourcedata_getpath")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_resourcedata_getpath = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourcedata_getencryptionalgorithm")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_resourcedata_getencryptionalgorithm = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourcedata_getcompression")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_resourcedata_getcompression = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourcedata_getadditionalauthenticationdata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_resourcedata_getadditionalauthenticationdata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourcedatagroup_getkeyuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_resourcedatagroup_getkeyuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourcedatagroup_addaccessright")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, WrappingAlgorithm, MgfAlgorithm, DigestMethod, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_resourcedatagroup_addaccessright = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourcedatagroup_findaccessrightbyconsumer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_resourcedatagroup_findaccessrightbyconsumer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourcedatagroup_removeaccessright")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_resourcedatagroup_removeaccessright = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_addconsumer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_keystore_addconsumer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_getconsumercount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_keystore_getconsumercount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_getconsumer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_keystore_getconsumer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_removeconsumer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_keystore_removeconsumer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_findconsumer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_keystore_findconsumer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_getresourcedatagroupcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_keystore_getresourcedatagroupcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_addresourcedatagroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_keystore_addresourcedatagroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_getresourcedatagroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_keystore_getresourcedatagroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_removeresourcedatagroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_keystore_removeresourcedatagroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_findresourcedatagroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_keystore_findresourcedatagroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_addresourcedata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, EncryptionAlgorithm, Compression, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint8), ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_keystore_addresourcedata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_removeresourcedata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_keystore_removeresourcedata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_findresourcedata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_keystore_findresourcedata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_getresourcedatacount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_keystore_getresourcedatacount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_getresourcedata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_keystore_getresourcedata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_getuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_keystore_getuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_setuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_keystore_setuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_rootmodelpart")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_rootmodelpart = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_findorcreatepackagepart")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_findorcreatepackagepart = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_setunit")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ModelUnit)
			self.lib.lib3mf_model_setunit = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getunit")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_model_getunit = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getlanguage")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_model_getlanguage = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_setlanguage")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_model_setlanguage = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_querywriter")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_querywriter = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_queryreader")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_queryreader = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getresourcebyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getresourcebyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_gettexture2dbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_gettexture2dbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getpropertytypebyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_model_getpropertytypebyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getbasematerialgroupbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getbasematerialgroupbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_gettexture2dgroupbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_gettexture2dgroupbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getcompositematerialsbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getcompositematerialsbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getmultipropertygroupbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getmultipropertygroupbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getmeshobjectbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getmeshobjectbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getcomponentsobjectbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getcomponentsobjectbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getcolorgroupbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getcolorgroupbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getslicestackbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getslicestackbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getbuilduuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_model_getbuilduuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_setbuilduuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_model_setbuilduuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getbuilditems")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getbuilditems = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getoutbox")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Box))
			self.lib.lib3mf_model_getoutbox = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getresources")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getresources = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getobjects")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getobjects = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getmeshobjects")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getmeshobjects = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getcomponentsobjects")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getcomponentsobjects = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_gettexture2ds")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_gettexture2ds = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getbasematerialgroups")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getbasematerialgroups = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getcolorgroups")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getcolorgroups = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_gettexture2dgroups")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_gettexture2dgroups = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getcompositematerials")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getcompositematerials = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getmultipropertygroups")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getmultipropertygroups = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getslicestacks")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getslicestacks = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_mergetomodel")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_mergetomodel = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addmeshobject")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addmeshobject = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addcomponentsobject")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addcomponentsobject = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addslicestack")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_double, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addslicestack = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addtexture2dfromattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addtexture2dfromattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addbasematerialgroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addbasematerialgroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addcolorgroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addcolorgroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addtexture2dgroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addtexture2dgroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addcompositematerials")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addcompositematerials = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addmultipropertygroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addmultipropertygroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addbuilditem")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(Transform), ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addbuilditem = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_removebuilditem")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_model_removebuilditem = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getmetadatagroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getmetadatagroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_removeattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_model_removeattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_findattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_findattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getattachmentcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_model_getattachmentcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_haspackagethumbnailattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_model_haspackagethumbnailattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_createpackagethumbnailattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_createpackagethumbnailattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getpackagethumbnailattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getpackagethumbnailattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_removepackagethumbnailattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_model_removepackagethumbnailattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addcustomcontenttype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p)
			self.lib.lib3mf_model_addcustomcontenttype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_removecustomcontenttype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_model_removecustomcontenttype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_setrandomnumbercallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, RandomNumberCallback, ctypes.c_void_p)
			self.lib.lib3mf_model_setrandomnumbercallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getkeystore")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getkeystore = methodType(int(methodAddress.value))
			
		except AttributeError as ae:
			raise ELib3MFException(ErrorCodes.COULDNOTFINDLIBRARYEXPORT, ae.args[0])
		
	def _loadFunctionTable(self):
		try:
			self.lib.lib3mf_getlibraryversion.restype = ctypes.c_int32
			self.lib.lib3mf_getlibraryversion.argtypes = [ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_getprereleaseinformation.restype = ctypes.c_int32
			self.lib.lib3mf_getprereleaseinformation.argtypes = [ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_getbuildinformation.restype = ctypes.c_int32
			self.lib.lib3mf_getbuildinformation.argtypes = [ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_getspecificationversion.restype = ctypes.c_int32
			self.lib.lib3mf_getspecificationversion.argtypes = [ctypes.c_char_p, ctypes.POINTER(ctypes.c_bool), ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_createmodel.restype = ctypes.c_int32
			self.lib.lib3mf_createmodel.argtypes = [ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_release.restype = ctypes.c_int32
			self.lib.lib3mf_release.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_acquire.restype = ctypes.c_int32
			self.lib.lib3mf_acquire.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_setjournal.restype = ctypes.c_int32
			self.lib.lib3mf_setjournal.argtypes = [ctypes.c_char_p]
			
			self.lib.lib3mf_getlasterror.restype = ctypes.c_int32
			self.lib.lib3mf_getlasterror.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_getsymbollookupmethod.restype = ctypes.c_int32
			self.lib.lib3mf_getsymbollookupmethod.argtypes = [ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_retrieveprogressmessage.restype = ctypes.c_int32
			self.lib.lib3mf_retrieveprogressmessage.argtypes = [ProgressIdentifier, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_rgbatocolor.restype = ctypes.c_int32
			self.lib.lib3mf_rgbatocolor.argtypes = [ctypes.c_uint8, ctypes.c_uint8, ctypes.c_uint8, ctypes.c_uint8, ctypes.POINTER(Color)]
			
			self.lib.lib3mf_floatrgbatocolor.restype = ctypes.c_int32
			self.lib.lib3mf_floatrgbatocolor.argtypes = [ctypes.c_float, ctypes.c_float, ctypes.c_float, ctypes.c_float, ctypes.POINTER(Color)]
			
			self.lib.lib3mf_colortorgba.restype = ctypes.c_int32
			self.lib.lib3mf_colortorgba.argtypes = [ctypes.POINTER(Color), ctypes.POINTER(ctypes.c_uint8), ctypes.POINTER(ctypes.c_uint8), ctypes.POINTER(ctypes.c_uint8), ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_colortofloatrgba.restype = ctypes.c_int32
			self.lib.lib3mf_colortofloatrgba.argtypes = [ctypes.POINTER(Color), ctypes.POINTER(ctypes.c_float), ctypes.POINTER(ctypes.c_float), ctypes.POINTER(ctypes.c_float), ctypes.POINTER(ctypes.c_float)]
			
			self.lib.lib3mf_getidentitytransform.restype = ctypes.c_int32
			self.lib.lib3mf_getidentitytransform.argtypes = [ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_getuniformscaletransform.restype = ctypes.c_int32
			self.lib.lib3mf_getuniformscaletransform.argtypes = [ctypes.c_float, ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_getscaletransform.restype = ctypes.c_int32
			self.lib.lib3mf_getscaletransform.argtypes = [ctypes.c_float, ctypes.c_float, ctypes.c_float, ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_gettranslationtransform.restype = ctypes.c_int32
			self.lib.lib3mf_gettranslationtransform.argtypes = [ctypes.c_float, ctypes.c_float, ctypes.c_float, ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_base_classtypeid.restype = ctypes.c_int32
			self.lib.lib3mf_base_classtypeid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_writer_writetofile.restype = ctypes.c_int32
			self.lib.lib3mf_writer_writetofile.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_writer_getstreamsize.restype = ctypes.c_int32
			self.lib.lib3mf_writer_getstreamsize.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_writer_writetobuffer.restype = ctypes.c_int32
			self.lib.lib3mf_writer_writetobuffer.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_writer_writetocallback.restype = ctypes.c_int32
			self.lib.lib3mf_writer_writetocallback.argtypes = [ctypes.c_void_p, WriteCallback, SeekCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_writer_setprogresscallback.restype = ctypes.c_int32
			self.lib.lib3mf_writer_setprogresscallback.argtypes = [ctypes.c_void_p, ProgressCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_writer_getdecimalprecision.restype = ctypes.c_int32
			self.lib.lib3mf_writer_getdecimalprecision.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_writer_setdecimalprecision.restype = ctypes.c_int32
			self.lib.lib3mf_writer_setdecimalprecision.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_writer_setstrictmodeactive.restype = ctypes.c_int32
			self.lib.lib3mf_writer_setstrictmodeactive.argtypes = [ctypes.c_void_p, ctypes.c_bool]
			
			self.lib.lib3mf_writer_getstrictmodeactive.restype = ctypes.c_int32
			self.lib.lib3mf_writer_getstrictmodeactive.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_writer_getwarning.restype = ctypes.c_int32
			self.lib.lib3mf_writer_getwarning.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_uint32), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_writer_getwarningcount.restype = ctypes.c_int32
			self.lib.lib3mf_writer_getwarningcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_writer_addkeywrappingcallback.restype = ctypes.c_int32
			self.lib.lib3mf_writer_addkeywrappingcallback.argtypes = [ctypes.c_void_p, ctypes.c_char_p, KeyWrappingCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_writer_setcontentencryptioncallback.restype = ctypes.c_int32
			self.lib.lib3mf_writer_setcontentencryptioncallback.argtypes = [ctypes.c_void_p, ContentEncryptionCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_reader_readfromfile.restype = ctypes.c_int32
			self.lib.lib3mf_reader_readfromfile.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_reader_readfrombuffer.restype = ctypes.c_int32
			self.lib.lib3mf_reader_readfrombuffer.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_reader_readfromcallback.restype = ctypes.c_int32
			self.lib.lib3mf_reader_readfromcallback.argtypes = [ctypes.c_void_p, ReadCallback, ctypes.c_uint64, SeekCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_reader_setprogresscallback.restype = ctypes.c_int32
			self.lib.lib3mf_reader_setprogresscallback.argtypes = [ctypes.c_void_p, ProgressCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_reader_addrelationtoread.restype = ctypes.c_int32
			self.lib.lib3mf_reader_addrelationtoread.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_reader_removerelationtoread.restype = ctypes.c_int32
			self.lib.lib3mf_reader_removerelationtoread.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_reader_setstrictmodeactive.restype = ctypes.c_int32
			self.lib.lib3mf_reader_setstrictmodeactive.argtypes = [ctypes.c_void_p, ctypes.c_bool]
			
			self.lib.lib3mf_reader_getstrictmodeactive.restype = ctypes.c_int32
			self.lib.lib3mf_reader_getstrictmodeactive.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_reader_getwarning.restype = ctypes.c_int32
			self.lib.lib3mf_reader_getwarning.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_uint32), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_reader_getwarningcount.restype = ctypes.c_int32
			self.lib.lib3mf_reader_getwarningcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_reader_addkeywrappingcallback.restype = ctypes.c_int32
			self.lib.lib3mf_reader_addkeywrappingcallback.argtypes = [ctypes.c_void_p, ctypes.c_char_p, KeyWrappingCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_reader_setcontentencryptioncallback.restype = ctypes.c_int32
			self.lib.lib3mf_reader_setcontentencryptioncallback.argtypes = [ctypes.c_void_p, ContentEncryptionCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_packagepart_getpath.restype = ctypes.c_int32
			self.lib.lib3mf_packagepart_getpath.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_packagepart_setpath.restype = ctypes.c_int32
			self.lib.lib3mf_packagepart_setpath.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_resource_getresourceid.restype = ctypes.c_int32
			self.lib.lib3mf_resource_getresourceid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_resource_getuniqueresourceid.restype = ctypes.c_int32
			self.lib.lib3mf_resource_getuniqueresourceid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_resource_packagepart.restype = ctypes.c_int32
			self.lib.lib3mf_resource_packagepart.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_resource_setpackagepart.restype = ctypes.c_int32
			self.lib.lib3mf_resource_setpackagepart.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_resource_getmodelresourceid.restype = ctypes.c_int32
			self.lib.lib3mf_resource_getmodelresourceid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_resourceiterator_movenext.restype = ctypes.c_int32
			self.lib.lib3mf_resourceiterator_movenext.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_resourceiterator_moveprevious.restype = ctypes.c_int32
			self.lib.lib3mf_resourceiterator_moveprevious.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_resourceiterator_getcurrent.restype = ctypes.c_int32
			self.lib.lib3mf_resourceiterator_getcurrent.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_resourceiterator_clone.restype = ctypes.c_int32
			self.lib.lib3mf_resourceiterator_clone.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_resourceiterator_count.restype = ctypes.c_int32
			self.lib.lib3mf_resourceiterator_count.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_slicestackiterator_getcurrentslicestack.restype = ctypes.c_int32
			self.lib.lib3mf_slicestackiterator_getcurrentslicestack.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_objectiterator_getcurrentobject.restype = ctypes.c_int32
			self.lib.lib3mf_objectiterator_getcurrentobject.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_meshobjectiterator_getcurrentmeshobject.restype = ctypes.c_int32
			self.lib.lib3mf_meshobjectiterator_getcurrentmeshobject.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_componentsobjectiterator_getcurrentcomponentsobject.restype = ctypes.c_int32
			self.lib.lib3mf_componentsobjectiterator_getcurrentcomponentsobject.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_texture2diterator_getcurrenttexture2d.restype = ctypes.c_int32
			self.lib.lib3mf_texture2diterator_getcurrenttexture2d.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup.restype = ctypes.c_int32
			self.lib.lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_colorgroupiterator_getcurrentcolorgroup.restype = ctypes.c_int32
			self.lib.lib3mf_colorgroupiterator_getcurrentcolorgroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup.restype = ctypes.c_int32
			self.lib.lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_compositematerialsiterator_getcurrentcompositematerials.restype = ctypes.c_int32
			self.lib.lib3mf_compositematerialsiterator_getcurrentcompositematerials.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_metadata_getnamespace.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_getnamespace.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_metadata_setnamespace.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_setnamespace.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_metadata_getname.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_getname.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_metadata_setname.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_setname.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_metadata_getkey.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_getkey.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_metadata_getmustpreserve.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_getmustpreserve.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_metadata_setmustpreserve.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_setmustpreserve.argtypes = [ctypes.c_void_p, ctypes.c_bool]
			
			self.lib.lib3mf_metadata_gettype.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_gettype.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_metadata_settype.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_settype.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_metadata_getvalue.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_getvalue.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_metadata_setvalue.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_setvalue.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_metadatagroup_getmetadatacount.restype = ctypes.c_int32
			self.lib.lib3mf_metadatagroup_getmetadatacount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_metadatagroup_getmetadata.restype = ctypes.c_int32
			self.lib.lib3mf_metadatagroup_getmetadata.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_metadatagroup_getmetadatabykey.restype = ctypes.c_int32
			self.lib.lib3mf_metadatagroup_getmetadatabykey.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_metadatagroup_removemetadatabyindex.restype = ctypes.c_int32
			self.lib.lib3mf_metadatagroup_removemetadatabyindex.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_metadatagroup_removemetadata.restype = ctypes.c_int32
			self.lib.lib3mf_metadatagroup_removemetadata.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_metadatagroup_addmetadata.restype = ctypes.c_int32
			self.lib.lib3mf_metadatagroup_addmetadata.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_bool, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_object_gettype.restype = ctypes.c_int32
			self.lib.lib3mf_object_gettype.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_object_settype.restype = ctypes.c_int32
			self.lib.lib3mf_object_settype.argtypes = [ctypes.c_void_p, ObjectType]
			
			self.lib.lib3mf_object_getname.restype = ctypes.c_int32
			self.lib.lib3mf_object_getname.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_object_setname.restype = ctypes.c_int32
			self.lib.lib3mf_object_setname.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_object_getpartnumber.restype = ctypes.c_int32
			self.lib.lib3mf_object_getpartnumber.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_object_setpartnumber.restype = ctypes.c_int32
			self.lib.lib3mf_object_setpartnumber.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_object_ismeshobject.restype = ctypes.c_int32
			self.lib.lib3mf_object_ismeshobject.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_object_iscomponentsobject.restype = ctypes.c_int32
			self.lib.lib3mf_object_iscomponentsobject.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_object_isvalid.restype = ctypes.c_int32
			self.lib.lib3mf_object_isvalid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_object_setattachmentasthumbnail.restype = ctypes.c_int32
			self.lib.lib3mf_object_setattachmentasthumbnail.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_object_getthumbnailattachment.restype = ctypes.c_int32
			self.lib.lib3mf_object_getthumbnailattachment.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_object_clearthumbnailattachment.restype = ctypes.c_int32
			self.lib.lib3mf_object_clearthumbnailattachment.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_object_getoutbox.restype = ctypes.c_int32
			self.lib.lib3mf_object_getoutbox.argtypes = [ctypes.c_void_p, ctypes.POINTER(Box)]
			
			self.lib.lib3mf_object_getuuid.restype = ctypes.c_int32
			self.lib.lib3mf_object_getuuid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_object_setuuid.restype = ctypes.c_int32
			self.lib.lib3mf_object_setuuid.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_object_getmetadatagroup.restype = ctypes.c_int32
			self.lib.lib3mf_object_getmetadatagroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_object_setslicesmeshresolution.restype = ctypes.c_int32
			self.lib.lib3mf_object_setslicesmeshresolution.argtypes = [ctypes.c_void_p, SlicesMeshResolution]
			
			self.lib.lib3mf_object_getslicesmeshresolution.restype = ctypes.c_int32
			self.lib.lib3mf_object_getslicesmeshresolution.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_object_hasslices.restype = ctypes.c_int32
			self.lib.lib3mf_object_hasslices.argtypes = [ctypes.c_void_p, ctypes.c_bool, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_object_clearslicestack.restype = ctypes.c_int32
			self.lib.lib3mf_object_clearslicestack.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_object_getslicestack.restype = ctypes.c_int32
			self.lib.lib3mf_object_getslicestack.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_object_assignslicestack.restype = ctypes.c_int32
			self.lib.lib3mf_object_assignslicestack.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_meshobject_getvertexcount.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_getvertexcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_meshobject_gettrianglecount.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_gettrianglecount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_meshobject_getvertex.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_getvertex.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Position)]
			
			self.lib.lib3mf_meshobject_setvertex.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_setvertex.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Position)]
			
			self.lib.lib3mf_meshobject_addvertex.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_addvertex.argtypes = [ctypes.c_void_p, ctypes.POINTER(Position), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_meshobject_getvertices.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_getvertices.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Position)]
			
			self.lib.lib3mf_meshobject_gettriangle.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_gettriangle.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Triangle)]
			
			self.lib.lib3mf_meshobject_settriangle.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_settriangle.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Triangle)]
			
			self.lib.lib3mf_meshobject_addtriangle.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_addtriangle.argtypes = [ctypes.c_void_p, ctypes.POINTER(Triangle), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_meshobject_gettriangleindices.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_gettriangleindices.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Triangle)]
			
			self.lib.lib3mf_meshobject_setobjectlevelproperty.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_setobjectlevelproperty.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint32]
			
			self.lib.lib3mf_meshobject_getobjectlevelproperty.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_getobjectlevelproperty.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_meshobject_settriangleproperties.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_settriangleproperties.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(TriangleProperties)]
			
			self.lib.lib3mf_meshobject_gettriangleproperties.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_gettriangleproperties.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(TriangleProperties)]
			
			self.lib.lib3mf_meshobject_setalltriangleproperties.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_setalltriangleproperties.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(TriangleProperties)]
			
			self.lib.lib3mf_meshobject_getalltriangleproperties.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_getalltriangleproperties.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(TriangleProperties)]
			
			self.lib.lib3mf_meshobject_clearallproperties.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_clearallproperties.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_meshobject_setgeometry.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_setgeometry.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(Position), ctypes.c_uint64, ctypes.POINTER(Triangle)]
			
			self.lib.lib3mf_meshobject_ismanifoldandoriented.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_ismanifoldandoriented.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_meshobject_beamlattice.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_beamlattice.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_beamlattice_getminlength.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getminlength.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_double)]
			
			self.lib.lib3mf_beamlattice_setminlength.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_setminlength.argtypes = [ctypes.c_void_p, ctypes.c_double]
			
			self.lib.lib3mf_beamlattice_getclipping.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getclipping.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamlattice_setclipping.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_setclipping.argtypes = [ctypes.c_void_p, BeamLatticeClipMode, ctypes.c_uint32]
			
			self.lib.lib3mf_beamlattice_getrepresentation.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getrepresentation.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamlattice_setrepresentation.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_setrepresentation.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_beamlattice_getballoptions.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getballoptions.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32), ctypes.POINTER(ctypes.c_double)]
			
			self.lib.lib3mf_beamlattice_setballoptions.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_setballoptions.argtypes = [ctypes.c_void_p, BeamLatticeBallMode, ctypes.c_double]
			
			self.lib.lib3mf_beamlattice_getbeamcount.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getbeamcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamlattice_getbeam.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getbeam.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Beam)]
			
			self.lib.lib3mf_beamlattice_addbeam.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_addbeam.argtypes = [ctypes.c_void_p, ctypes.POINTER(Beam), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamlattice_setbeam.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_setbeam.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Beam)]
			
			self.lib.lib3mf_beamlattice_setbeams.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_setbeams.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(Beam)]
			
			self.lib.lib3mf_beamlattice_getbeams.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getbeams.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Beam)]
			
			self.lib.lib3mf_beamlattice_getballcount.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getballcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamlattice_getball.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getball.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Ball)]
			
			self.lib.lib3mf_beamlattice_addball.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_addball.argtypes = [ctypes.c_void_p, ctypes.POINTER(Ball), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamlattice_setball.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_setball.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Ball)]
			
			self.lib.lib3mf_beamlattice_setballs.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_setballs.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(Ball)]
			
			self.lib.lib3mf_beamlattice_getballs.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getballs.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Ball)]
			
			self.lib.lib3mf_beamlattice_getbeamsetcount.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getbeamsetcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamlattice_addbeamset.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_addbeamset.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_beamlattice_getbeamset.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getbeamset.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_component_getobjectresource.restype = ctypes.c_int32
			self.lib.lib3mf_component_getobjectresource.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_component_getobjectresourceid.restype = ctypes.c_int32
			self.lib.lib3mf_component_getobjectresourceid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_component_getuuid.restype = ctypes.c_int32
			self.lib.lib3mf_component_getuuid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_component_setuuid.restype = ctypes.c_int32
			self.lib.lib3mf_component_setuuid.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_component_hastransform.restype = ctypes.c_int32
			self.lib.lib3mf_component_hastransform.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_component_gettransform.restype = ctypes.c_int32
			self.lib.lib3mf_component_gettransform.argtypes = [ctypes.c_void_p, ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_component_settransform.restype = ctypes.c_int32
			self.lib.lib3mf_component_settransform.argtypes = [ctypes.c_void_p, ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_componentsobject_addcomponent.restype = ctypes.c_int32
			self.lib.lib3mf_componentsobject_addcomponent.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(Transform), ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_componentsobject_getcomponent.restype = ctypes.c_int32
			self.lib.lib3mf_componentsobject_getcomponent.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_componentsobject_getcomponentcount.restype = ctypes.c_int32
			self.lib.lib3mf_componentsobject_getcomponentcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamset_setname.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_setname.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_beamset_getname.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_getname.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_beamset_setidentifier.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_setidentifier.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_beamset_getidentifier.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_getidentifier.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_beamset_getreferencecount.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_getreferencecount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamset_setreferences.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_setreferences.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamset_getreferences.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_getreferences.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamset_getballreferencecount.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_getballreferencecount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamset_setballreferences.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_setballreferences.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamset_getballreferences.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_getballreferences.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_basematerialgroup_getcount.restype = ctypes.c_int32
			self.lib.lib3mf_basematerialgroup_getcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_basematerialgroup_getallpropertyids.restype = ctypes.c_int32
			self.lib.lib3mf_basematerialgroup_getallpropertyids.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_basematerialgroup_addmaterial.restype = ctypes.c_int32
			self.lib.lib3mf_basematerialgroup_addmaterial.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(Color), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_basematerialgroup_removematerial.restype = ctypes.c_int32
			self.lib.lib3mf_basematerialgroup_removematerial.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_basematerialgroup_getname.restype = ctypes.c_int32
			self.lib.lib3mf_basematerialgroup_getname.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_basematerialgroup_setname.restype = ctypes.c_int32
			self.lib.lib3mf_basematerialgroup_setname.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_char_p]
			
			self.lib.lib3mf_basematerialgroup_setdisplaycolor.restype = ctypes.c_int32
			self.lib.lib3mf_basematerialgroup_setdisplaycolor.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Color)]
			
			self.lib.lib3mf_basematerialgroup_getdisplaycolor.restype = ctypes.c_int32
			self.lib.lib3mf_basematerialgroup_getdisplaycolor.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Color)]
			
			self.lib.lib3mf_colorgroup_getcount.restype = ctypes.c_int32
			self.lib.lib3mf_colorgroup_getcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_colorgroup_getallpropertyids.restype = ctypes.c_int32
			self.lib.lib3mf_colorgroup_getallpropertyids.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_colorgroup_addcolor.restype = ctypes.c_int32
			self.lib.lib3mf_colorgroup_addcolor.argtypes = [ctypes.c_void_p, ctypes.POINTER(Color), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_colorgroup_removecolor.restype = ctypes.c_int32
			self.lib.lib3mf_colorgroup_removecolor.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_colorgroup_setcolor.restype = ctypes.c_int32
			self.lib.lib3mf_colorgroup_setcolor.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Color)]
			
			self.lib.lib3mf_colorgroup_getcolor.restype = ctypes.c_int32
			self.lib.lib3mf_colorgroup_getcolor.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Color)]
			
			self.lib.lib3mf_texture2dgroup_getcount.restype = ctypes.c_int32
			self.lib.lib3mf_texture2dgroup_getcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_texture2dgroup_getallpropertyids.restype = ctypes.c_int32
			self.lib.lib3mf_texture2dgroup_getallpropertyids.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_texture2dgroup_addtex2coord.restype = ctypes.c_int32
			self.lib.lib3mf_texture2dgroup_addtex2coord.argtypes = [ctypes.c_void_p, ctypes.POINTER(Tex2Coord), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_texture2dgroup_gettex2coord.restype = ctypes.c_int32
			self.lib.lib3mf_texture2dgroup_gettex2coord.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Tex2Coord)]
			
			self.lib.lib3mf_texture2dgroup_removetex2coord.restype = ctypes.c_int32
			self.lib.lib3mf_texture2dgroup_removetex2coord.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_texture2dgroup_gettexture2d.restype = ctypes.c_int32
			self.lib.lib3mf_texture2dgroup_gettexture2d.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_compositematerials_getcount.restype = ctypes.c_int32
			self.lib.lib3mf_compositematerials_getcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_compositematerials_getallpropertyids.restype = ctypes.c_int32
			self.lib.lib3mf_compositematerials_getallpropertyids.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_compositematerials_getbasematerialgroup.restype = ctypes.c_int32
			self.lib.lib3mf_compositematerials_getbasematerialgroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_compositematerials_addcomposite.restype = ctypes.c_int32
			self.lib.lib3mf_compositematerials_addcomposite.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(CompositeConstituent), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_compositematerials_removecomposite.restype = ctypes.c_int32
			self.lib.lib3mf_compositematerials_removecomposite.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_compositematerials_getcomposite.restype = ctypes.c_int32
			self.lib.lib3mf_compositematerials_getcomposite.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(CompositeConstituent)]
			
			self.lib.lib3mf_multipropertygroup_getcount.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_getcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_multipropertygroup_getallpropertyids.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_getallpropertyids.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_multipropertygroup_addmultiproperty.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_addmultiproperty.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_multipropertygroup_setmultiproperty.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_setmultiproperty.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_multipropertygroup_getmultiproperty.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_getmultiproperty.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_multipropertygroup_removemultiproperty.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_removemultiproperty.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_multipropertygroup_getlayercount.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_getlayercount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_multipropertygroup_addlayer.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_addlayer.argtypes = [ctypes.c_void_p, ctypes.POINTER(MultiPropertyLayer), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_multipropertygroup_getlayer.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_getlayer.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(MultiPropertyLayer)]
			
			self.lib.lib3mf_multipropertygroup_removelayer.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_removelayer.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_attachment_getpath.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_getpath.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_attachment_setpath.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_setpath.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_attachment_packagepart.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_packagepart.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_attachment_getrelationshiptype.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_getrelationshiptype.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_attachment_setrelationshiptype.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_setrelationshiptype.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_attachment_writetofile.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_writetofile.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_attachment_readfromfile.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_readfromfile.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_attachment_readfromcallback.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_readfromcallback.argtypes = [ctypes.c_void_p, ReadCallback, ctypes.c_uint64, SeekCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_attachment_getstreamsize.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_getstreamsize.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_attachment_writetobuffer.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_writetobuffer.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_attachment_readfrombuffer.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_readfrombuffer.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_texture2d_getattachment.restype = ctypes.c_int32
			self.lib.lib3mf_texture2d_getattachment.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_texture2d_setattachment.restype = ctypes.c_int32
			self.lib.lib3mf_texture2d_setattachment.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_texture2d_getcontenttype.restype = ctypes.c_int32
			self.lib.lib3mf_texture2d_getcontenttype.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_texture2d_setcontenttype.restype = ctypes.c_int32
			self.lib.lib3mf_texture2d_setcontenttype.argtypes = [ctypes.c_void_p, TextureType]
			
			self.lib.lib3mf_texture2d_gettilestyleuv.restype = ctypes.c_int32
			self.lib.lib3mf_texture2d_gettilestyleuv.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32), ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_texture2d_settilestyleuv.restype = ctypes.c_int32
			self.lib.lib3mf_texture2d_settilestyleuv.argtypes = [ctypes.c_void_p, TextureTileStyle, TextureTileStyle]
			
			self.lib.lib3mf_texture2d_getfilter.restype = ctypes.c_int32
			self.lib.lib3mf_texture2d_getfilter.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_texture2d_setfilter.restype = ctypes.c_int32
			self.lib.lib3mf_texture2d_setfilter.argtypes = [ctypes.c_void_p, TextureFilter]
			
			self.lib.lib3mf_builditem_getobjectresource.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_getobjectresource.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_builditem_getuuid.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_getuuid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_builditem_setuuid.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_setuuid.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_builditem_getobjectresourceid.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_getobjectresourceid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_builditem_hasobjecttransform.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_hasobjecttransform.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_builditem_getobjecttransform.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_getobjecttransform.argtypes = [ctypes.c_void_p, ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_builditem_setobjecttransform.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_setobjecttransform.argtypes = [ctypes.c_void_p, ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_builditem_getpartnumber.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_getpartnumber.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_builditem_setpartnumber.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_setpartnumber.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_builditem_getmetadatagroup.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_getmetadatagroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_builditem_getoutbox.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_getoutbox.argtypes = [ctypes.c_void_p, ctypes.POINTER(Box)]
			
			self.lib.lib3mf_builditemiterator_movenext.restype = ctypes.c_int32
			self.lib.lib3mf_builditemiterator_movenext.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_builditemiterator_moveprevious.restype = ctypes.c_int32
			self.lib.lib3mf_builditemiterator_moveprevious.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_builditemiterator_getcurrent.restype = ctypes.c_int32
			self.lib.lib3mf_builditemiterator_getcurrent.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_builditemiterator_clone.restype = ctypes.c_int32
			self.lib.lib3mf_builditemiterator_clone.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_builditemiterator_count.restype = ctypes.c_int32
			self.lib.lib3mf_builditemiterator_count.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_slice_setvertices.restype = ctypes.c_int32
			self.lib.lib3mf_slice_setvertices.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(Position2D)]
			
			self.lib.lib3mf_slice_getvertices.restype = ctypes.c_int32
			self.lib.lib3mf_slice_getvertices.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Position2D)]
			
			self.lib.lib3mf_slice_getvertexcount.restype = ctypes.c_int32
			self.lib.lib3mf_slice_getvertexcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_slice_addpolygon.restype = ctypes.c_int32
			self.lib.lib3mf_slice_addpolygon.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_slice_getpolygoncount.restype = ctypes.c_int32
			self.lib.lib3mf_slice_getpolygoncount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_slice_setpolygonindices.restype = ctypes.c_int32
			self.lib.lib3mf_slice_setpolygonindices.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_slice_getpolygonindices.restype = ctypes.c_int32
			self.lib.lib3mf_slice_getpolygonindices.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_slice_getpolygonindexcount.restype = ctypes.c_int32
			self.lib.lib3mf_slice_getpolygonindexcount.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_slice_getztop.restype = ctypes.c_int32
			self.lib.lib3mf_slice_getztop.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_double)]
			
			self.lib.lib3mf_slicestack_getbottomz.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_getbottomz.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_double)]
			
			self.lib.lib3mf_slicestack_getslicecount.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_getslicecount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_slicestack_getslice.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_getslice.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_slicestack_addslice.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_addslice.argtypes = [ctypes.c_void_p, ctypes.c_double, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_slicestack_getslicerefcount.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_getslicerefcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_slicestack_addslicestackreference.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_addslicestackreference.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_slicestack_getslicestackreference.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_getslicestackreference.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_slicestack_collapseslicereferences.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_collapseslicereferences.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_slicestack_setownpath.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_setownpath.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_slicestack_getownpath.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_getownpath.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_consumer_getconsumerid.restype = ctypes.c_int32
			self.lib.lib3mf_consumer_getconsumerid.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_consumer_getkeyid.restype = ctypes.c_int32
			self.lib.lib3mf_consumer_getkeyid.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_consumer_getkeyvalue.restype = ctypes.c_int32
			self.lib.lib3mf_consumer_getkeyvalue.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_accessright_getconsumer.restype = ctypes.c_int32
			self.lib.lib3mf_accessright_getconsumer.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_accessright_getwrappingalgorithm.restype = ctypes.c_int32
			self.lib.lib3mf_accessright_getwrappingalgorithm.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_accessright_getmgfalgorithm.restype = ctypes.c_int32
			self.lib.lib3mf_accessright_getmgfalgorithm.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_accessright_getdigestmethod.restype = ctypes.c_int32
			self.lib.lib3mf_accessright_getdigestmethod.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_contentencryptionparams_getencryptionalgorithm.restype = ctypes.c_int32
			self.lib.lib3mf_contentencryptionparams_getencryptionalgorithm.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_contentencryptionparams_getkey.restype = ctypes.c_int32
			self.lib.lib3mf_contentencryptionparams_getkey.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_contentencryptionparams_getinitializationvector.restype = ctypes.c_int32
			self.lib.lib3mf_contentencryptionparams_getinitializationvector.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_contentencryptionparams_getauthenticationtag.restype = ctypes.c_int32
			self.lib.lib3mf_contentencryptionparams_getauthenticationtag.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_contentencryptionparams_setauthenticationtag.restype = ctypes.c_int32
			self.lib.lib3mf_contentencryptionparams_setauthenticationtag.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_contentencryptionparams_getadditionalauthenticationdata.restype = ctypes.c_int32
			self.lib.lib3mf_contentencryptionparams_getadditionalauthenticationdata.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_contentencryptionparams_getdescriptor.restype = ctypes.c_int32
			self.lib.lib3mf_contentencryptionparams_getdescriptor.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_contentencryptionparams_getkeyuuid.restype = ctypes.c_int32
			self.lib.lib3mf_contentencryptionparams_getkeyuuid.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_resourcedata_getpath.restype = ctypes.c_int32
			self.lib.lib3mf_resourcedata_getpath.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_resourcedata_getencryptionalgorithm.restype = ctypes.c_int32
			self.lib.lib3mf_resourcedata_getencryptionalgorithm.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_resourcedata_getcompression.restype = ctypes.c_int32
			self.lib.lib3mf_resourcedata_getcompression.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_resourcedata_getadditionalauthenticationdata.restype = ctypes.c_int32
			self.lib.lib3mf_resourcedata_getadditionalauthenticationdata.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_resourcedatagroup_getkeyuuid.restype = ctypes.c_int32
			self.lib.lib3mf_resourcedatagroup_getkeyuuid.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_resourcedatagroup_addaccessright.restype = ctypes.c_int32
			self.lib.lib3mf_resourcedatagroup_addaccessright.argtypes = [ctypes.c_void_p, ctypes.c_void_p, WrappingAlgorithm, MgfAlgorithm, DigestMethod, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_resourcedatagroup_findaccessrightbyconsumer.restype = ctypes.c_int32
			self.lib.lib3mf_resourcedatagroup_findaccessrightbyconsumer.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_resourcedatagroup_removeaccessright.restype = ctypes.c_int32
			self.lib.lib3mf_resourcedatagroup_removeaccessright.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_keystore_addconsumer.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_addconsumer.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_keystore_getconsumercount.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_getconsumercount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_keystore_getconsumer.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_getconsumer.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_keystore_removeconsumer.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_removeconsumer.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_keystore_findconsumer.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_findconsumer.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_keystore_getresourcedatagroupcount.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_getresourcedatagroupcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_keystore_addresourcedatagroup.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_addresourcedatagroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_keystore_getresourcedatagroup.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_getresourcedatagroup.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_keystore_removeresourcedatagroup.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_removeresourcedatagroup.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_keystore_findresourcedatagroup.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_findresourcedatagroup.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_keystore_addresourcedata.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_addresourcedata.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, EncryptionAlgorithm, Compression, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint8), ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_keystore_removeresourcedata.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_removeresourcedata.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_keystore_findresourcedata.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_findresourcedata.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_keystore_getresourcedatacount.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_getresourcedatacount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_keystore_getresourcedata.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_getresourcedata.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_keystore_getuuid.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_getuuid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_keystore_setuuid.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_setuuid.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_model_rootmodelpart.restype = ctypes.c_int32
			self.lib.lib3mf_model_rootmodelpart.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_findorcreatepackagepart.restype = ctypes.c_int32
			self.lib.lib3mf_model_findorcreatepackagepart.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_setunit.restype = ctypes.c_int32
			self.lib.lib3mf_model_setunit.argtypes = [ctypes.c_void_p, ModelUnit]
			
			self.lib.lib3mf_model_getunit.restype = ctypes.c_int32
			self.lib.lib3mf_model_getunit.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_model_getlanguage.restype = ctypes.c_int32
			self.lib.lib3mf_model_getlanguage.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_model_setlanguage.restype = ctypes.c_int32
			self.lib.lib3mf_model_setlanguage.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_model_querywriter.restype = ctypes.c_int32
			self.lib.lib3mf_model_querywriter.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_queryreader.restype = ctypes.c_int32
			self.lib.lib3mf_model_queryreader.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getresourcebyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getresourcebyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_gettexture2dbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_gettexture2dbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getpropertytypebyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getpropertytypebyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_model_getbasematerialgroupbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getbasematerialgroupbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_gettexture2dgroupbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_gettexture2dgroupbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getcompositematerialsbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getcompositematerialsbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getmultipropertygroupbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getmultipropertygroupbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getmeshobjectbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getmeshobjectbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getcomponentsobjectbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getcomponentsobjectbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getcolorgroupbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getcolorgroupbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getslicestackbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getslicestackbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getbuilduuid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getbuilduuid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_model_setbuilduuid.restype = ctypes.c_int32
			self.lib.lib3mf_model_setbuilduuid.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_model_getbuilditems.restype = ctypes.c_int32
			self.lib.lib3mf_model_getbuilditems.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getoutbox.restype = ctypes.c_int32
			self.lib.lib3mf_model_getoutbox.argtypes = [ctypes.c_void_p, ctypes.POINTER(Box)]
			
			self.lib.lib3mf_model_getresources.restype = ctypes.c_int32
			self.lib.lib3mf_model_getresources.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getobjects.restype = ctypes.c_int32
			self.lib.lib3mf_model_getobjects.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getmeshobjects.restype = ctypes.c_int32
			self.lib.lib3mf_model_getmeshobjects.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getcomponentsobjects.restype = ctypes.c_int32
			self.lib.lib3mf_model_getcomponentsobjects.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_gettexture2ds.restype = ctypes.c_int32
			self.lib.lib3mf_model_gettexture2ds.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getbasematerialgroups.restype = ctypes.c_int32
			self.lib.lib3mf_model_getbasematerialgroups.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getcolorgroups.restype = ctypes.c_int32
			self.lib.lib3mf_model_getcolorgroups.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_gettexture2dgroups.restype = ctypes.c_int32
			self.lib.lib3mf_model_gettexture2dgroups.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getcompositematerials.restype = ctypes.c_int32
			self.lib.lib3mf_model_getcompositematerials.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getmultipropertygroups.restype = ctypes.c_int32
			self.lib.lib3mf_model_getmultipropertygroups.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getslicestacks.restype = ctypes.c_int32
			self.lib.lib3mf_model_getslicestacks.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_mergetomodel.restype = ctypes.c_int32
			self.lib.lib3mf_model_mergetomodel.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addmeshobject.restype = ctypes.c_int32
			self.lib.lib3mf_model_addmeshobject.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addcomponentsobject.restype = ctypes.c_int32
			self.lib.lib3mf_model_addcomponentsobject.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addslicestack.restype = ctypes.c_int32
			self.lib.lib3mf_model_addslicestack.argtypes = [ctypes.c_void_p, ctypes.c_double, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addtexture2dfromattachment.restype = ctypes.c_int32
			self.lib.lib3mf_model_addtexture2dfromattachment.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addbasematerialgroup.restype = ctypes.c_int32
			self.lib.lib3mf_model_addbasematerialgroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addcolorgroup.restype = ctypes.c_int32
			self.lib.lib3mf_model_addcolorgroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addtexture2dgroup.restype = ctypes.c_int32
			self.lib.lib3mf_model_addtexture2dgroup.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addcompositematerials.restype = ctypes.c_int32
			self.lib.lib3mf_model_addcompositematerials.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addmultipropertygroup.restype = ctypes.c_int32
			self.lib.lib3mf_model_addmultipropertygroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addbuilditem.restype = ctypes.c_int32
			self.lib.lib3mf_model_addbuilditem.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(Transform), ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_removebuilditem.restype = ctypes.c_int32
			self.lib.lib3mf_model_removebuilditem.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_model_getmetadatagroup.restype = ctypes.c_int32
			self.lib.lib3mf_model_getmetadatagroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addattachment.restype = ctypes.c_int32
			self.lib.lib3mf_model_addattachment.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_removeattachment.restype = ctypes.c_int32
			self.lib.lib3mf_model_removeattachment.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_model_getattachment.restype = ctypes.c_int32
			self.lib.lib3mf_model_getattachment.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_findattachment.restype = ctypes.c_int32
			self.lib.lib3mf_model_findattachment.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getattachmentcount.restype = ctypes.c_int32
			self.lib.lib3mf_model_getattachmentcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_model_haspackagethumbnailattachment.restype = ctypes.c_int32
			self.lib.lib3mf_model_haspackagethumbnailattachment.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_model_createpackagethumbnailattachment.restype = ctypes.c_int32
			self.lib.lib3mf_model_createpackagethumbnailattachment.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getpackagethumbnailattachment.restype = ctypes.c_int32
			self.lib.lib3mf_model_getpackagethumbnailattachment.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_removepackagethumbnailattachment.restype = ctypes.c_int32
			self.lib.lib3mf_model_removepackagethumbnailattachment.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_model_addcustomcontenttype.restype = ctypes.c_int32
			self.lib.lib3mf_model_addcustomcontenttype.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p]
			
			self.lib.lib3mf_model_removecustomcontenttype.restype = ctypes.c_int32
			self.lib.lib3mf_model_removecustomcontenttype.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_model_setrandomnumbercallback.restype = ctypes.c_int32
			self.lib.lib3mf_model_setrandomnumbercallback.argtypes = [ctypes.c_void_p, RandomNumberCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_model_getkeystore.restype = ctypes.c_int32
			self.lib.lib3mf_model_getkeystore.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
		except AttributeError as ae:
			raise ELib3MFException(ErrorCodes.COULDNOTFINDLIBRARYEXPORT, ae.args[0])
	
	def _checkBinaryVersion(self):
		nMajor, nMinor, _ = self.GetLibraryVersion()
		if (nMajor != BindingVersion.MAJOR) or (nMinor < BindingVersion.MINOR):
			raise ELib3MFException(ErrorCodes.INCOMPATIBLEBINARYVERSION)
	
	def checkError(self, instance, errorCode):
		if errorCode != ErrorCodes.SUCCESS.value:
			if instance:
				if instance._wrapper != self:
					raise ELib3MFException(ErrorCodes.INVALIDCAST, 'invalid wrapper call')
			message,_ = self.GetLastError(instance)
			raise ELib3MFException(errorCode, message)
	
	def GetLibraryVersion(self):
		pMajor = ctypes.c_uint32()
		pMinor = ctypes.c_uint32()
		pMicro = ctypes.c_uint32()
		self.checkError(None, self.lib.lib3mf_getlibraryversion(pMajor, pMinor, pMicro))
		
		return pMajor.value, pMinor.value, pMicro.value
	
	def GetPrereleaseInformation(self):
		pHasPrereleaseInfo = ctypes.c_bool()
		nPrereleaseInfoBufferSize = ctypes.c_uint64(0)
		nPrereleaseInfoNeededChars = ctypes.c_uint64(0)
		pPrereleaseInfoBuffer = ctypes.c_char_p(None)
		self.checkError(None, self.lib.lib3mf_getprereleaseinformation(pHasPrereleaseInfo, nPrereleaseInfoBufferSize, nPrereleaseInfoNeededChars, pPrereleaseInfoBuffer))
		nPrereleaseInfoBufferSize = ctypes.c_uint64(nPrereleaseInfoNeededChars.value)
		pPrereleaseInfoBuffer = (ctypes.c_char * (nPrereleaseInfoNeededChars.value))()
		self.checkError(None, self.lib.lib3mf_getprereleaseinformation(pHasPrereleaseInfo, nPrereleaseInfoBufferSize, nPrereleaseInfoNeededChars, pPrereleaseInfoBuffer))
		
		return pHasPrereleaseInfo.value, pPrereleaseInfoBuffer.value.decode()
	
	def GetBuildInformation(self):
		pHasBuildInfo = ctypes.c_bool()
		nBuildInformationBufferSize = ctypes.c_uint64(0)
		nBuildInformationNeededChars = ctypes.c_uint64(0)
		pBuildInformationBuffer = ctypes.c_char_p(None)
		self.checkError(None, self.lib.lib3mf_getbuildinformation(pHasBuildInfo, nBuildInformationBufferSize, nBuildInformationNeededChars, pBuildInformationBuffer))
		nBuildInformationBufferSize = ctypes.c_uint64(nBuildInformationNeededChars.value)
		pBuildInformationBuffer = (ctypes.c_char * (nBuildInformationNeededChars.value))()
		self.checkError(None, self.lib.lib3mf_getbuildinformation(pHasBuildInfo, nBuildInformationBufferSize, nBuildInformationNeededChars, pBuildInformationBuffer))
		
		return pHasBuildInfo.value, pBuildInformationBuffer.value.decode()
	
	def GetSpecificationVersion(self, SpecificationURL):
		pSpecificationURL = ctypes.c_char_p(str.encode(SpecificationURL))
		pIsSupported = ctypes.c_bool()
		pMajor = ctypes.c_uint32()
		pMinor = ctypes.c_uint32()
		pMicro = ctypes.c_uint32()
		self.checkError(None, self.lib.lib3mf_getspecificationversion(pSpecificationURL, pIsSupported, pMajor, pMinor, pMicro))
		
		return pIsSupported.value, pMajor.value, pMinor.value, pMicro.value
	
	def CreateModel(self):
		ModelHandle = ctypes.c_void_p()
		self.checkError(None, self.lib.lib3mf_createmodel(ModelHandle))
		if ModelHandle:
			ModelObject = self._polymorphicFactory(ModelHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ModelObject
	
	def Release(self, InstanceObject):
		InstanceHandle = None
		if InstanceObject:
			InstanceHandle = InstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self.checkError(None, self.lib.lib3mf_release(InstanceHandle))
		
	
	def Acquire(self, InstanceObject):
		InstanceHandle = None
		if InstanceObject:
			InstanceHandle = InstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self.checkError(None, self.lib.lib3mf_acquire(InstanceHandle))
		
	
	def SetJournal(self, JournalPath):
		pJournalPath = ctypes.c_char_p(str.encode(JournalPath))
		self.checkError(None, self.lib.lib3mf_setjournal(pJournalPath))
		
	
	def GetLastError(self, InstanceObject):
		InstanceHandle = None
		if InstanceObject:
			InstanceHandle = InstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		nLastErrorStringBufferSize = ctypes.c_uint64(0)
		nLastErrorStringNeededChars = ctypes.c_uint64(0)
		pLastErrorStringBuffer = ctypes.c_char_p(None)
		pHasLastError = ctypes.c_bool()
		self.checkError(None, self.lib.lib3mf_getlasterror(InstanceHandle, nLastErrorStringBufferSize, nLastErrorStringNeededChars, pLastErrorStringBuffer, pHasLastError))
		nLastErrorStringBufferSize = ctypes.c_uint64(nLastErrorStringNeededChars.value)
		pLastErrorStringBuffer = (ctypes.c_char * (nLastErrorStringNeededChars.value))()
		self.checkError(None, self.lib.lib3mf_getlasterror(InstanceHandle, nLastErrorStringBufferSize, nLastErrorStringNeededChars, pLastErrorStringBuffer, pHasLastError))
		
		return pLastErrorStringBuffer.value.decode(), pHasLastError.value
	
	def GetSymbolLookupMethod(self):
		pSymbolLookupMethod = ctypes.c_void_p()
		self.checkError(None, self.lib.lib3mf_getsymbollookupmethod(pSymbolLookupMethod))
		
		return pSymbolLookupMethod.value
	
	def RetrieveProgressMessage(self, TheProgressIdentifier):
		nProgressMessageBufferSize = ctypes.c_uint64(0)
		nProgressMessageNeededChars = ctypes.c_uint64(0)
		pProgressMessageBuffer = ctypes.c_char_p(None)
		self.checkError(None, self.lib.lib3mf_retrieveprogressmessage(TheProgressIdentifier, nProgressMessageBufferSize, nProgressMessageNeededChars, pProgressMessageBuffer))
		nProgressMessageBufferSize = ctypes.c_uint64(nProgressMessageNeededChars.value)
		pProgressMessageBuffer = (ctypes.c_char * (nProgressMessageNeededChars.value))()
		self.checkError(None, self.lib.lib3mf_retrieveprogressmessage(TheProgressIdentifier, nProgressMessageBufferSize, nProgressMessageNeededChars, pProgressMessageBuffer))
		
		return pProgressMessageBuffer.value.decode()
	
	def RGBAToColor(self, Red, Green, Blue, Alpha):
		nRed = ctypes.c_uint8(Red)
		nGreen = ctypes.c_uint8(Green)
		nBlue = ctypes.c_uint8(Blue)
		nAlpha = ctypes.c_uint8(Alpha)
		pTheColor = Color()
		self.checkError(None, self.lib.lib3mf_rgbatocolor(nRed, nGreen, nBlue, nAlpha, pTheColor))
		
		return pTheColor
	
	def FloatRGBAToColor(self, Red, Green, Blue, Alpha):
		fRed = ctypes.c_float(Red)
		fGreen = ctypes.c_float(Green)
		fBlue = ctypes.c_float(Blue)
		fAlpha = ctypes.c_float(Alpha)
		pTheColor = Color()
		self.checkError(None, self.lib.lib3mf_floatrgbatocolor(fRed, fGreen, fBlue, fAlpha, pTheColor))
		
		return pTheColor
	
	def ColorToRGBA(self, TheColor):
		pRed = ctypes.c_uint8()
		pGreen = ctypes.c_uint8()
		pBlue = ctypes.c_uint8()
		pAlpha = ctypes.c_uint8()
		self.checkError(None, self.lib.lib3mf_colortorgba(TheColor, pRed, pGreen, pBlue, pAlpha))
		
		return pRed.value, pGreen.value, pBlue.value, pAlpha.value
	
	def ColorToFloatRGBA(self, TheColor):
		pRed = ctypes.c_float()
		pGreen = ctypes.c_float()
		pBlue = ctypes.c_float()
		pAlpha = ctypes.c_float()
		self.checkError(None, self.lib.lib3mf_colortofloatrgba(TheColor, pRed, pGreen, pBlue, pAlpha))
		
		return pRed.value, pGreen.value, pBlue.value, pAlpha.value
	
	def GetIdentityTransform(self):
		pTransform = Transform()
		self.checkError(None, self.lib.lib3mf_getidentitytransform(pTransform))
		
		return pTransform
	
	def GetUniformScaleTransform(self, Factor):
		fFactor = ctypes.c_float(Factor)
		pTransform = Transform()
		self.checkError(None, self.lib.lib3mf_getuniformscaletransform(fFactor, pTransform))
		
		return pTransform
	
	def GetScaleTransform(self, FactorX, FactorY, FactorZ):
		fFactorX = ctypes.c_float(FactorX)
		fFactorY = ctypes.c_float(FactorY)
		fFactorZ = ctypes.c_float(FactorZ)
		pTransform = Transform()
		self.checkError(None, self.lib.lib3mf_getscaletransform(fFactorX, fFactorY, fFactorZ, pTransform))
		
		return pTransform
	
	def GetTranslationTransform(self, VectorX, VectorY, VectorZ):
		fVectorX = ctypes.c_float(VectorX)
		fVectorY = ctypes.c_float(VectorY)
		fVectorZ = ctypes.c_float(VectorZ)
		pTransform = Transform()
		self.checkError(None, self.lib.lib3mf_gettranslationtransform(fVectorX, fVectorY, fVectorZ, pTransform))
		
		return pTransform
	
	'''IMPORTANT: PolymorphicFactory method should not be used by application directly.
								It's designed to be used on Lib3MFHandle object only once.
								If it's used on any existing object as a form of dynamic cast then
								Wrapper.AcquireInstance(object) must be called after instantiating new object.
								This is important to keep reference count matching between application and library sides.
	'''
	def _polymorphicFactory(self, handle):
		class PolymorphicFactory():
			def getObjectById(self, classtypeid, handle, wrapper):
				methodName = 'getObjectById_' + format(classtypeid.value, '016X')
				method = getattr(self, methodName, lambda: 'Invalid class type id')
				return method(handle, wrapper)
			def getObjectById_856632D0BAF1D8B7(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Base"
				return Base(handle, wrapper)
			def getObjectById_E76F642F363FD7E9(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Writer"
				return Writer(handle, wrapper)
			def getObjectById_2D86831DA59FBE72(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Reader"
				return Reader(handle, wrapper)
			def getObjectById_0E55A826D377483E(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::PackagePart"
				return PackagePart(handle, wrapper)
			def getObjectById_DFE3889D1B269CBB(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Resource"
				return Resource(handle, wrapper)
			def getObjectById_460F3515E2621DBE(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ResourceIterator"
				return ResourceIterator(handle, wrapper)
			def getObjectById_69684DB99FA813F6(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::SliceStackIterator"
				return SliceStackIterator(handle, wrapper)
			def getObjectById_DE92510BD2112288(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ObjectIterator"
				return ObjectIterator(handle, wrapper)
			def getObjectById_F4196034E2B9FDE6(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MeshObjectIterator"
				return MeshObjectIterator(handle, wrapper)
			def getObjectById_564DE4217ED7614A(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ComponentsObjectIterator"
				return ComponentsObjectIterator(handle, wrapper)
			def getObjectById_4BD32B4870FFC03B(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Texture2DIterator"
				return Texture2DIterator(handle, wrapper)
			def getObjectById_65E6EDD9362C79CB(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::BaseMaterialGroupIterator"
				return BaseMaterialGroupIterator(handle, wrapper)
			def getObjectById_10274A1757C729C0(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ColorGroupIterator"
				return ColorGroupIterator(handle, wrapper)
			def getObjectById_30D55F4DB88FE0CA(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Texture2DGroupIterator"
				return Texture2DGroupIterator(handle, wrapper)
			def getObjectById_A99CC6C3F70FB6F9(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::CompositeMaterialsIterator"
				return CompositeMaterialsIterator(handle, wrapper)
			def getObjectById_C2BDF5D8CBBDB1F0(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MultiPropertyGroupIterator"
				return MultiPropertyGroupIterator(handle, wrapper)
			def getObjectById_D17716D063DE2C22(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MetaData"
				return MetaData(handle, wrapper)
			def getObjectById_0C3B85369E9B25D3(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MetaDataGroup"
				return MetaDataGroup(handle, wrapper)
			def getObjectById_2DA2136F577A779C(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Object"
				return Object(handle, wrapper)
			def getObjectById_3B3A6DC6EC610497(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MeshObject"
				return MeshObject(handle, wrapper)
			def getObjectById_63B3B461B30B4BA5(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::BeamLattice"
				return BeamLattice(handle, wrapper)
			def getObjectById_4ECDB6A6F69F2BEB(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Component"
				return Component(handle, wrapper)
			def getObjectById_6522CF04EB283FED(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ComponentsObject"
				return ComponentsObject(handle, wrapper)
			def getObjectById_30CCDBE90E00B55B(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::BeamSet"
				return BeamSet(handle, wrapper)
			def getObjectById_B27D4656E16609FA(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::BaseMaterialGroup"
				return BaseMaterialGroup(handle, wrapper)
			def getObjectById_D085FB2E49CDB5B1(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ColorGroup"
				return ColorGroup(handle, wrapper)
			def getObjectById_BC1208397E37055D(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Texture2DGroup"
				return Texture2DGroup(handle, wrapper)
			def getObjectById_CE16224D688B86F2(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::CompositeMaterials"
				return CompositeMaterials(handle, wrapper)
			def getObjectById_B989E02E43158FE6(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MultiPropertyGroup"
				return MultiPropertyGroup(handle, wrapper)
			def getObjectById_8CE7A1191A63A35D(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Attachment"
				return Attachment(handle, wrapper)
			def getObjectById_E0441CF976B36319(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Texture2D"
				return Texture2D(handle, wrapper)
			def getObjectById_68FB2D5FFC4BA12A(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::BuildItem"
				return BuildItem(handle, wrapper)
			def getObjectById_A7D21BD364910860(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::BuildItemIterator"
				return BuildItemIterator(handle, wrapper)
			def getObjectById_2198BCF4D8DF9C40(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Slice"
				return Slice(handle, wrapper)
			def getObjectById_6594B031B6096238(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::SliceStack"
				return SliceStack(handle, wrapper)
			def getObjectById_D9E46D5E6D8118EE(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Consumer"
				return Consumer(handle, wrapper)
			def getObjectById_385C42FC5609498A(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::AccessRight"
				return AccessRight(handle, wrapper)
			def getObjectById_7FB36B91D4CE4671(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ContentEncryptionParams"
				return ContentEncryptionParams(handle, wrapper)
			def getObjectById_1A47A5E258E22EF9(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ResourceData"
				return ResourceData(handle, wrapper)
			def getObjectById_D59067227E428AA4(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ResourceDataGroup"
				return ResourceDataGroup(handle, wrapper)
			def getObjectById_1CC9E0CC082253C6(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::KeyStore"
				return KeyStore(handle, wrapper)
			def getObjectById_5A8164ECEDB03F09(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Model"
				return Model(handle, wrapper)
		
		if not handle:
			return None
		pClassTypeId = ctypes.c_uint64()
		self.checkError(None, self.lib.lib3mf_base_classtypeid(handle, pClassTypeId))
		factory = PolymorphicFactory()
		return factory.getObjectById(pClassTypeId, handle, self)
	


''' Class Implementation for Base
'''
class Base:
	def __init__(self, handle, wrapper):
		if not handle or not wrapper:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM)
		self._handle = handle
		self._wrapper = wrapper
	
	def __del__(self):
		self._wrapper.Release(self)
	def ClassTypeId(self):
		pClassTypeId = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_base_classtypeid(self._handle, pClassTypeId))
		
		return pClassTypeId.value
	


''' Class Implementation for Writer
'''
class Writer(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def WriteToFile(self, Filename):
		pFilename = ctypes.c_char_p(str.encode(Filename))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_writetofile(self._handle, pFilename))
		
	
	def GetStreamSize(self):
		pStreamSize = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_getstreamsize(self._handle, pStreamSize))
		
		return pStreamSize.value
	
	def WriteToBuffer(self):
		nBufferCount = ctypes.c_uint64(0)
		nBufferNeededCount = ctypes.c_uint64(0)
		pBufferBuffer = (ctypes.c_uint8*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_writetobuffer(self._handle, nBufferCount, nBufferNeededCount, pBufferBuffer))
		nBufferCount = ctypes.c_uint64(nBufferNeededCount.value)
		pBufferBuffer = (ctypes.c_uint8 * nBufferNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_writetobuffer(self._handle, nBufferCount, nBufferNeededCount, pBufferBuffer))
		
		return [pBufferBuffer[i] for i in range(nBufferNeededCount.value)]
	
	def WriteToCallback(self, TheWriteCallbackFunc, TheSeekCallbackFunc, UserData):
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_writetocallback(self._handle, TheWriteCallbackFunc, TheSeekCallbackFunc, pUserData))
		
	
	def SetProgressCallback(self, ProgressCallbackFunc, UserData):
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_setprogresscallback(self._handle, ProgressCallbackFunc, pUserData))
		
	
	def GetDecimalPrecision(self):
		pDecimalPrecision = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_getdecimalprecision(self._handle, pDecimalPrecision))
		
		return pDecimalPrecision.value
	
	def SetDecimalPrecision(self, DecimalPrecision):
		nDecimalPrecision = ctypes.c_uint32(DecimalPrecision)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_setdecimalprecision(self._handle, nDecimalPrecision))
		
	
	def SetStrictModeActive(self, StrictModeActive):
		bStrictModeActive = ctypes.c_bool(StrictModeActive)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_setstrictmodeactive(self._handle, bStrictModeActive))
		
	
	def GetStrictModeActive(self):
		pStrictModeActive = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_getstrictmodeactive(self._handle, pStrictModeActive))
		
		return pStrictModeActive.value
	
	def GetWarning(self, Index):
		nIndex = ctypes.c_uint32(Index)
		pErrorCode = ctypes.c_uint32()
		nWarningBufferSize = ctypes.c_uint64(0)
		nWarningNeededChars = ctypes.c_uint64(0)
		pWarningBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_getwarning(self._handle, nIndex, pErrorCode, nWarningBufferSize, nWarningNeededChars, pWarningBuffer))
		nWarningBufferSize = ctypes.c_uint64(nWarningNeededChars.value)
		pWarningBuffer = (ctypes.c_char * (nWarningNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_getwarning(self._handle, nIndex, pErrorCode, nWarningBufferSize, nWarningNeededChars, pWarningBuffer))
		
		return pErrorCode.value, pWarningBuffer.value.decode()
	
	def GetWarningCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_getwarningcount(self._handle, pCount))
		
		return pCount.value
	
	def AddKeyWrappingCallback(self, ConsumerID, TheCallbackFunc, UserData):
		pConsumerID = ctypes.c_char_p(str.encode(ConsumerID))
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_addkeywrappingcallback(self._handle, pConsumerID, TheCallbackFunc, pUserData))
		
	
	def SetContentEncryptionCallback(self, TheCallbackFunc, UserData):
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_setcontentencryptioncallback(self._handle, TheCallbackFunc, pUserData))
		
	


''' Class Implementation for Reader
'''
class Reader(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def ReadFromFile(self, Filename):
		pFilename = ctypes.c_char_p(str.encode(Filename))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_readfromfile(self._handle, pFilename))
		
	
	def ReadFromBuffer(self, Buffer):
		nBufferCount = ctypes.c_uint64(len(Buffer))
		pBufferBuffer = (ctypes.c_uint8*len(Buffer))(*Buffer)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_readfrombuffer(self._handle, nBufferCount, pBufferBuffer))
		
	
	def ReadFromCallback(self, TheReadCallbackFunc, StreamSize, TheSeekCallbackFunc, UserData):
		nStreamSize = ctypes.c_uint64(StreamSize)
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_readfromcallback(self._handle, TheReadCallbackFunc, nStreamSize, TheSeekCallbackFunc, pUserData))
		
	
	def SetProgressCallback(self, ProgressCallbackFunc, UserData):
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_setprogresscallback(self._handle, ProgressCallbackFunc, pUserData))
		
	
	def AddRelationToRead(self, RelationShipType):
		pRelationShipType = ctypes.c_char_p(str.encode(RelationShipType))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_addrelationtoread(self._handle, pRelationShipType))
		
	
	def RemoveRelationToRead(self, RelationShipType):
		pRelationShipType = ctypes.c_char_p(str.encode(RelationShipType))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_removerelationtoread(self._handle, pRelationShipType))
		
	
	def SetStrictModeActive(self, StrictModeActive):
		bStrictModeActive = ctypes.c_bool(StrictModeActive)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_setstrictmodeactive(self._handle, bStrictModeActive))
		
	
	def GetStrictModeActive(self):
		pStrictModeActive = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_getstrictmodeactive(self._handle, pStrictModeActive))
		
		return pStrictModeActive.value
	
	def GetWarning(self, Index):
		nIndex = ctypes.c_uint32(Index)
		pErrorCode = ctypes.c_uint32()
		nWarningBufferSize = ctypes.c_uint64(0)
		nWarningNeededChars = ctypes.c_uint64(0)
		pWarningBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_getwarning(self._handle, nIndex, pErrorCode, nWarningBufferSize, nWarningNeededChars, pWarningBuffer))
		nWarningBufferSize = ctypes.c_uint64(nWarningNeededChars.value)
		pWarningBuffer = (ctypes.c_char * (nWarningNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_getwarning(self._handle, nIndex, pErrorCode, nWarningBufferSize, nWarningNeededChars, pWarningBuffer))
		
		return pErrorCode.value, pWarningBuffer.value.decode()
	
	def GetWarningCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_getwarningcount(self._handle, pCount))
		
		return pCount.value
	
	def AddKeyWrappingCallback(self, ConsumerID, TheCallbackFunc, UserData):
		pConsumerID = ctypes.c_char_p(str.encode(ConsumerID))
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_addkeywrappingcallback(self._handle, pConsumerID, TheCallbackFunc, pUserData))
		
	
	def SetContentEncryptionCallback(self, TheCallbackFunc, UserData):
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_setcontentencryptioncallback(self._handle, TheCallbackFunc, pUserData))
		
	


''' Class Implementation for PackagePart
'''
class PackagePart(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetPath(self):
		nPathBufferSize = ctypes.c_uint64(0)
		nPathNeededChars = ctypes.c_uint64(0)
		pPathBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_packagepart_getpath(self._handle, nPathBufferSize, nPathNeededChars, pPathBuffer))
		nPathBufferSize = ctypes.c_uint64(nPathNeededChars.value)
		pPathBuffer = (ctypes.c_char * (nPathNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_packagepart_getpath(self._handle, nPathBufferSize, nPathNeededChars, pPathBuffer))
		
		return pPathBuffer.value.decode()
	
	def SetPath(self, Path):
		pPath = ctypes.c_char_p(str.encode(Path))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_packagepart_setpath(self._handle, pPath))
		
	


''' Class Implementation for Resource
'''
class Resource(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetResourceID(self):
		pUniqueResourceID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resource_getresourceid(self._handle, pUniqueResourceID))
		
		return pUniqueResourceID.value
	
	def GetUniqueResourceID(self):
		pUniqueResourceID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resource_getuniqueresourceid(self._handle, pUniqueResourceID))
		
		return pUniqueResourceID.value
	
	def PackagePart(self):
		PackagePartHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resource_packagepart(self._handle, PackagePartHandle))
		if PackagePartHandle:
			PackagePartObject = self._wrapper._polymorphicFactory(PackagePartHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return PackagePartObject
	
	def SetPackagePart(self, PackagePartObject):
		PackagePartHandle = None
		if PackagePartObject:
			PackagePartHandle = PackagePartObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resource_setpackagepart(self._handle, PackagePartHandle))
		
	
	def GetModelResourceID(self):
		pModelResourceId = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resource_getmodelresourceid(self._handle, pModelResourceId))
		
		return pModelResourceId.value
	


''' Class Implementation for ResourceIterator
'''
class ResourceIterator(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def MoveNext(self):
		pHasNext = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourceiterator_movenext(self._handle, pHasNext))
		
		return pHasNext.value
	
	def MovePrevious(self):
		pHasPrevious = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourceiterator_moveprevious(self._handle, pHasPrevious))
		
		return pHasPrevious.value
	
	def GetCurrent(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourceiterator_getcurrent(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	
	def Clone(self):
		OutResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourceiterator_clone(self._handle, OutResourceIteratorHandle))
		if OutResourceIteratorHandle:
			OutResourceIteratorObject = self._wrapper._polymorphicFactory(OutResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return OutResourceIteratorObject
	
	def Count(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourceiterator_count(self._handle, pCount))
		
		return pCount.value
	


''' Class Implementation for SliceStackIterator
'''
class SliceStackIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentSliceStack(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestackiterator_getcurrentslicestack(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for ObjectIterator
'''
class ObjectIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentObject(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_objectiterator_getcurrentobject(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for MeshObjectIterator
'''
class MeshObjectIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentMeshObject(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobjectiterator_getcurrentmeshobject(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for ComponentsObjectIterator
'''
class ComponentsObjectIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentComponentsObject(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_componentsobjectiterator_getcurrentcomponentsobject(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for Texture2DIterator
'''
class Texture2DIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentTexture2D(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2diterator_getcurrenttexture2d(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for BaseMaterialGroupIterator
'''
class BaseMaterialGroupIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentBaseMaterialGroup(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for ColorGroupIterator
'''
class ColorGroupIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentColorGroup(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_colorgroupiterator_getcurrentcolorgroup(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for Texture2DGroupIterator
'''
class Texture2DGroupIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentTexture2DGroup(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for CompositeMaterialsIterator
'''
class CompositeMaterialsIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentCompositeMaterials(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_compositematerialsiterator_getcurrentcompositematerials(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for MultiPropertyGroupIterator
'''
class MultiPropertyGroupIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentMultiPropertyGroup(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for MetaData
'''
class MetaData(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetNameSpace(self):
		nNameSpaceBufferSize = ctypes.c_uint64(0)
		nNameSpaceNeededChars = ctypes.c_uint64(0)
		pNameSpaceBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_getnamespace(self._handle, nNameSpaceBufferSize, nNameSpaceNeededChars, pNameSpaceBuffer))
		nNameSpaceBufferSize = ctypes.c_uint64(nNameSpaceNeededChars.value)
		pNameSpaceBuffer = (ctypes.c_char * (nNameSpaceNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_getnamespace(self._handle, nNameSpaceBufferSize, nNameSpaceNeededChars, pNameSpaceBuffer))
		
		return pNameSpaceBuffer.value.decode()
	
	def SetNameSpace(self, NameSpace):
		pNameSpace = ctypes.c_char_p(str.encode(NameSpace))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_setnamespace(self._handle, pNameSpace))
		
	
	def GetName(self):
		nNameBufferSize = ctypes.c_uint64(0)
		nNameNeededChars = ctypes.c_uint64(0)
		pNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_getname(self._handle, nNameBufferSize, nNameNeededChars, pNameBuffer))
		nNameBufferSize = ctypes.c_uint64(nNameNeededChars.value)
		pNameBuffer = (ctypes.c_char * (nNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_getname(self._handle, nNameBufferSize, nNameNeededChars, pNameBuffer))
		
		return pNameBuffer.value.decode()
	
	def SetName(self, Name):
		pName = ctypes.c_char_p(str.encode(Name))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_setname(self._handle, pName))
		
	
	def GetKey(self):
		nKeyBufferSize = ctypes.c_uint64(0)
		nKeyNeededChars = ctypes.c_uint64(0)
		pKeyBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_getkey(self._handle, nKeyBufferSize, nKeyNeededChars, pKeyBuffer))
		nKeyBufferSize = ctypes.c_uint64(nKeyNeededChars.value)
		pKeyBuffer = (ctypes.c_char * (nKeyNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_getkey(self._handle, nKeyBufferSize, nKeyNeededChars, pKeyBuffer))
		
		return pKeyBuffer.value.decode()
	
	def GetMustPreserve(self):
		pMustPreserve = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_getmustpreserve(self._handle, pMustPreserve))
		
		return pMustPreserve.value
	
	def SetMustPreserve(self, MustPreserve):
		bMustPreserve = ctypes.c_bool(MustPreserve)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_setmustpreserve(self._handle, bMustPreserve))
		
	
	def GetType(self):
		nTypeBufferSize = ctypes.c_uint64(0)
		nTypeNeededChars = ctypes.c_uint64(0)
		pTypeBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_gettype(self._handle, nTypeBufferSize, nTypeNeededChars, pTypeBuffer))
		nTypeBufferSize = ctypes.c_uint64(nTypeNeededChars.value)
		pTypeBuffer = (ctypes.c_char * (nTypeNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_gettype(self._handle, nTypeBufferSize, nTypeNeededChars, pTypeBuffer))
		
		return pTypeBuffer.value.decode()
	
	def SetType(self, Type):
		pType = ctypes.c_char_p(str.encode(Type))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_settype(self._handle, pType))
		
	
	def GetValue(self):
		nValueBufferSize = ctypes.c_uint64(0)
		nValueNeededChars = ctypes.c_uint64(0)
		pValueBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_getvalue(self._handle, nValueBufferSize, nValueNeededChars, pValueBuffer))
		nValueBufferSize = ctypes.c_uint64(nValueNeededChars.value)
		pValueBuffer = (ctypes.c_char * (nValueNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_getvalue(self._handle, nValueBufferSize, nValueNeededChars, pValueBuffer))
		
		return pValueBuffer.value.decode()
	
	def SetValue(self, Value):
		pValue = ctypes.c_char_p(str.encode(Value))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_setvalue(self._handle, pValue))
		
	


''' Class Implementation for MetaDataGroup
'''
class MetaDataGroup(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetMetaDataCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadatagroup_getmetadatacount(self._handle, pCount))
		
		return pCount.value
	
	def GetMetaData(self, Index):
		nIndex = ctypes.c_uint32(Index)
		MetaDataHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadatagroup_getmetadata(self._handle, nIndex, MetaDataHandle))
		if MetaDataHandle:
			MetaDataObject = self._wrapper._polymorphicFactory(MetaDataHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MetaDataObject
	
	def GetMetaDataByKey(self, NameSpace, Name):
		pNameSpace = ctypes.c_char_p(str.encode(NameSpace))
		pName = ctypes.c_char_p(str.encode(Name))
		MetaDataHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadatagroup_getmetadatabykey(self._handle, pNameSpace, pName, MetaDataHandle))
		if MetaDataHandle:
			MetaDataObject = self._wrapper._polymorphicFactory(MetaDataHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MetaDataObject
	
	def RemoveMetaDataByIndex(self, Index):
		nIndex = ctypes.c_uint32(Index)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadatagroup_removemetadatabyindex(self._handle, nIndex))
		
	
	def RemoveMetaData(self, TheMetaDataObject):
		TheMetaDataHandle = None
		if TheMetaDataObject:
			TheMetaDataHandle = TheMetaDataObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadatagroup_removemetadata(self._handle, TheMetaDataHandle))
		
	
	def AddMetaData(self, NameSpace, Name, Value, Type, MustPreserve):
		pNameSpace = ctypes.c_char_p(str.encode(NameSpace))
		pName = ctypes.c_char_p(str.encode(Name))
		pValue = ctypes.c_char_p(str.encode(Value))
		pType = ctypes.c_char_p(str.encode(Type))
		bMustPreserve = ctypes.c_bool(MustPreserve)
		MetaDataHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadatagroup_addmetadata(self._handle, pNameSpace, pName, pValue, pType, bMustPreserve, MetaDataHandle))
		if MetaDataHandle:
			MetaDataObject = self._wrapper._polymorphicFactory(MetaDataHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MetaDataObject
	


''' Class Implementation for Object
'''
class Object(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetType(self):
		pObjectType = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_gettype(self._handle, pObjectType))
		
		return ObjectType(pObjectType.value)
	
	def SetType(self, ObjectType):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_settype(self._handle, ObjectType))
		
	
	def GetName(self):
		nNameBufferSize = ctypes.c_uint64(0)
		nNameNeededChars = ctypes.c_uint64(0)
		pNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getname(self._handle, nNameBufferSize, nNameNeededChars, pNameBuffer))
		nNameBufferSize = ctypes.c_uint64(nNameNeededChars.value)
		pNameBuffer = (ctypes.c_char * (nNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getname(self._handle, nNameBufferSize, nNameNeededChars, pNameBuffer))
		
		return pNameBuffer.value.decode()
	
	def SetName(self, Name):
		pName = ctypes.c_char_p(str.encode(Name))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_setname(self._handle, pName))
		
	
	def GetPartNumber(self):
		nPartNumberBufferSize = ctypes.c_uint64(0)
		nPartNumberNeededChars = ctypes.c_uint64(0)
		pPartNumberBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getpartnumber(self._handle, nPartNumberBufferSize, nPartNumberNeededChars, pPartNumberBuffer))
		nPartNumberBufferSize = ctypes.c_uint64(nPartNumberNeededChars.value)
		pPartNumberBuffer = (ctypes.c_char * (nPartNumberNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getpartnumber(self._handle, nPartNumberBufferSize, nPartNumberNeededChars, pPartNumberBuffer))
		
		return pPartNumberBuffer.value.decode()
	
	def SetPartNumber(self, PartNumber):
		pPartNumber = ctypes.c_char_p(str.encode(PartNumber))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_setpartnumber(self._handle, pPartNumber))
		
	
	def IsMeshObject(self):
		pIsMeshObject = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_ismeshobject(self._handle, pIsMeshObject))
		
		return pIsMeshObject.value
	
	def IsComponentsObject(self):
		pIsComponentsObject = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_iscomponentsobject(self._handle, pIsComponentsObject))
		
		return pIsComponentsObject.value
	
	def IsValid(self):
		pIsValid = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_isvalid(self._handle, pIsValid))
		
		return pIsValid.value
	
	def SetAttachmentAsThumbnail(self, AttachmentObject):
		AttachmentHandle = None
		if AttachmentObject:
			AttachmentHandle = AttachmentObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_setattachmentasthumbnail(self._handle, AttachmentHandle))
		
	
	def GetThumbnailAttachment(self):
		AttachmentHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getthumbnailattachment(self._handle, AttachmentHandle))
		if AttachmentHandle:
			AttachmentObject = self._wrapper._polymorphicFactory(AttachmentHandle)
		else:
			AttachmentObject = None
		
		return AttachmentObject
	
	def ClearThumbnailAttachment(self):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_clearthumbnailattachment(self._handle))
		
	
	def GetOutbox(self):
		pOutbox = Box()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getoutbox(self._handle, pOutbox))
		
		return pOutbox
	
	def GetUUID(self):
		pHasUUID = ctypes.c_bool()
		nUUIDBufferSize = ctypes.c_uint64(0)
		nUUIDNeededChars = ctypes.c_uint64(0)
		pUUIDBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getuuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		nUUIDBufferSize = ctypes.c_uint64(nUUIDNeededChars.value)
		pUUIDBuffer = (ctypes.c_char * (nUUIDNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getuuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		
		return pHasUUID.value, pUUIDBuffer.value.decode()
	
	def SetUUID(self, UUID):
		pUUID = ctypes.c_char_p(str.encode(UUID))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_setuuid(self._handle, pUUID))
		
	
	def GetMetaDataGroup(self):
		MetaDataGroupHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getmetadatagroup(self._handle, MetaDataGroupHandle))
		if MetaDataGroupHandle:
			MetaDataGroupObject = self._wrapper._polymorphicFactory(MetaDataGroupHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MetaDataGroupObject
	
	def SetSlicesMeshResolution(self, MeshResolution):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_setslicesmeshresolution(self._handle, MeshResolution))
		
	
	def GetSlicesMeshResolution(self):
		pMeshResolution = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getslicesmeshresolution(self._handle, pMeshResolution))
		
		return SlicesMeshResolution(pMeshResolution.value)
	
	def HasSlices(self, Recursive):
		bRecursive = ctypes.c_bool(Recursive)
		pHasSlices = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_hasslices(self._handle, bRecursive, pHasSlices))
		
		return pHasSlices.value
	
	def ClearSliceStack(self):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_clearslicestack(self._handle))
		
	
	def GetSliceStack(self):
		SliceStackInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getslicestack(self._handle, SliceStackInstanceHandle))
		if SliceStackInstanceHandle:
			SliceStackInstanceObject = self._wrapper._polymorphicFactory(SliceStackInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return SliceStackInstanceObject
	
	def AssignSliceStack(self, SliceStackInstanceObject):
		SliceStackInstanceHandle = None
		if SliceStackInstanceObject:
			SliceStackInstanceHandle = SliceStackInstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_assignslicestack(self._handle, SliceStackInstanceHandle))
		
	


''' Class Implementation for MeshObject
'''
class MeshObject(Object):
	def __init__(self, handle, wrapper):
		Object.__init__(self, handle, wrapper)
	def GetVertexCount(self):
		pVertexCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_getvertexcount(self._handle, pVertexCount))
		
		return pVertexCount.value
	
	def GetTriangleCount(self):
		pVertexCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_gettrianglecount(self._handle, pVertexCount))
		
		return pVertexCount.value
	
	def GetVertex(self, Index):
		nIndex = ctypes.c_uint32(Index)
		pCoordinates = Position()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_getvertex(self._handle, nIndex, pCoordinates))
		
		return pCoordinates
	
	def SetVertex(self, Index, Coordinates):
		nIndex = ctypes.c_uint32(Index)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_setvertex(self._handle, nIndex, Coordinates))
		
	
	def AddVertex(self, Coordinates):
		pNewIndex = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_addvertex(self._handle, Coordinates, pNewIndex))
		
		return pNewIndex.value
	
	def GetVertices(self):
		nVerticesCount = ctypes.c_uint64(0)
		nVerticesNeededCount = ctypes.c_uint64(0)
		pVerticesBuffer = (Position*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_getvertices(self._handle, nVerticesCount, nVerticesNeededCount, pVerticesBuffer))
		nVerticesCount = ctypes.c_uint64(nVerticesNeededCount.value)
		pVerticesBuffer = (Position * nVerticesNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_getvertices(self._handle, nVerticesCount, nVerticesNeededCount, pVerticesBuffer))
		
		return [pVerticesBuffer[i] for i in range(nVerticesNeededCount.value)]
	
	def GetTriangle(self, Index):
		nIndex = ctypes.c_uint32(Index)
		pIndices = Triangle()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_gettriangle(self._handle, nIndex, pIndices))
		
		return pIndices
	
	def SetTriangle(self, Index, Indices):
		nIndex = ctypes.c_uint32(Index)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_settriangle(self._handle, nIndex, Indices))
		
	
	def AddTriangle(self, Indices):
		pNewIndex = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_addtriangle(self._handle, Indices, pNewIndex))
		
		return pNewIndex.value
	
	def GetTriangleIndices(self):
		nIndicesCount = ctypes.c_uint64(0)
		nIndicesNeededCount = ctypes.c_uint64(0)
		pIndicesBuffer = (Triangle*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_gettriangleindices(self._handle, nIndicesCount, nIndicesNeededCount, pIndicesBuffer))
		nIndicesCount = ctypes.c_uint64(nIndicesNeededCount.value)
		pIndicesBuffer = (Triangle * nIndicesNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_gettriangleindices(self._handle, nIndicesCount, nIndicesNeededCount, pIndicesBuffer))
		
		return [pIndicesBuffer[i] for i in range(nIndicesNeededCount.value)]
	
	def SetObjectLevelProperty(self, UniqueResourceID, PropertyID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		nPropertyID = ctypes.c_uint32(PropertyID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_setobjectlevelproperty(self._handle, nUniqueResourceID, nPropertyID))
		
	
	def GetObjectLevelProperty(self):
		pUniqueResourceID = ctypes.c_uint32()
		pPropertyID = ctypes.c_uint32()
		pHasObjectLevelProperty = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_getobjectlevelproperty(self._handle, pUniqueResourceID, pPropertyID, pHasObjectLevelProperty))
		
		return pUniqueResourceID.value, pPropertyID.value, pHasObjectLevelProperty.value
	
	def SetTriangleProperties(self, Index, Properties):
		nIndex = ctypes.c_uint32(Index)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_settriangleproperties(self._handle, nIndex, Properties))
		
	
	def GetTriangleProperties(self, Index):
		nIndex = ctypes.c_uint32(Index)
		pProperty = TriangleProperties()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_gettriangleproperties(self._handle, nIndex, pProperty))
		
		return pProperty
	
	def SetAllTriangleProperties(self, PropertiesArray):
		nPropertiesArrayCount = ctypes.c_uint64(len(PropertiesArray))
		pPropertiesArrayBuffer = (TriangleProperties*len(PropertiesArray))(*PropertiesArray)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_setalltriangleproperties(self._handle, nPropertiesArrayCount, pPropertiesArrayBuffer))
		
	
	def GetAllTriangleProperties(self):
		nPropertiesArrayCount = ctypes.c_uint64(0)
		nPropertiesArrayNeededCount = ctypes.c_uint64(0)
		pPropertiesArrayBuffer = (TriangleProperties*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_getalltriangleproperties(self._handle, nPropertiesArrayCount, nPropertiesArrayNeededCount, pPropertiesArrayBuffer))
		nPropertiesArrayCount = ctypes.c_uint64(nPropertiesArrayNeededCount.value)
		pPropertiesArrayBuffer = (TriangleProperties * nPropertiesArrayNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_getalltriangleproperties(self._handle, nPropertiesArrayCount, nPropertiesArrayNeededCount, pPropertiesArrayBuffer))
		
		return [pPropertiesArrayBuffer[i] for i in range(nPropertiesArrayNeededCount.value)]
	
	def ClearAllProperties(self):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_clearallproperties(self._handle))
		
	
	def SetGeometry(self, Vertices, Indices):
		nVerticesCount = ctypes.c_uint64(len(Vertices))
		pVerticesBuffer = (Position*len(Vertices))(*Vertices)
		nIndicesCount = ctypes.c_uint64(len(Indices))
		pIndicesBuffer = (Triangle*len(Indices))(*Indices)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_setgeometry(self._handle, nVerticesCount, pVerticesBuffer, nIndicesCount, pIndicesBuffer))
		
	
	def IsManifoldAndOriented(self):
		pIsManifoldAndOriented = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_ismanifoldandoriented(self._handle, pIsManifoldAndOriented))
		
		return pIsManifoldAndOriented.value
	
	def BeamLattice(self):
		TheBeamLatticeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_beamlattice(self._handle, TheBeamLatticeHandle))
		if TheBeamLatticeHandle:
			TheBeamLatticeObject = self._wrapper._polymorphicFactory(TheBeamLatticeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheBeamLatticeObject
	


''' Class Implementation for BeamLattice
'''
class BeamLattice(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetMinLength(self):
		pMinLength = ctypes.c_double()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getminlength(self._handle, pMinLength))
		
		return pMinLength.value
	
	def SetMinLength(self, MinLength):
		dMinLength = ctypes.c_double(MinLength)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_setminlength(self._handle, dMinLength))
		
	
	def GetClipping(self):
		pClipMode = ctypes.c_int32()
		pUniqueResourceID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getclipping(self._handle, pClipMode, pUniqueResourceID))
		
		return BeamLatticeClipMode(pClipMode.value), pUniqueResourceID.value
	
	def SetClipping(self, ClipMode, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_setclipping(self._handle, ClipMode, nUniqueResourceID))
		
	
	def GetRepresentation(self):
		pHasRepresentation = ctypes.c_bool()
		pUniqueResourceID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getrepresentation(self._handle, pHasRepresentation, pUniqueResourceID))
		
		return pHasRepresentation.value, pUniqueResourceID.value
	
	def SetRepresentation(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_setrepresentation(self._handle, nUniqueResourceID))
		
	
	def GetBallOptions(self):
		pBallMode = ctypes.c_int32()
		pBallRadius = ctypes.c_double()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getballoptions(self._handle, pBallMode, pBallRadius))
		
		return BeamLatticeBallMode(pBallMode.value), pBallRadius.value
	
	def SetBallOptions(self, BallMode, BallRadius):
		dBallRadius = ctypes.c_double(BallRadius)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_setballoptions(self._handle, BallMode, dBallRadius))
		
	
	def GetBeamCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getbeamcount(self._handle, pCount))
		
		return pCount.value
	
	def GetBeam(self, Index):
		nIndex = ctypes.c_uint32(Index)
		pBeamInfo = Beam()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getbeam(self._handle, nIndex, pBeamInfo))
		
		return pBeamInfo
	
	def AddBeam(self, BeamInfo):
		pIndex = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_addbeam(self._handle, BeamInfo, pIndex))
		
		return pIndex.value
	
	def SetBeam(self, Index, BeamInfo):
		nIndex = ctypes.c_uint32(Index)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_setbeam(self._handle, nIndex, BeamInfo))
		
	
	def SetBeams(self, BeamInfo):
		nBeamInfoCount = ctypes.c_uint64(len(BeamInfo))
		pBeamInfoBuffer = (Beam*len(BeamInfo))(*BeamInfo)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_setbeams(self._handle, nBeamInfoCount, pBeamInfoBuffer))
		
	
	def GetBeams(self):
		nBeamInfoCount = ctypes.c_uint64(0)
		nBeamInfoNeededCount = ctypes.c_uint64(0)
		pBeamInfoBuffer = (Beam*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getbeams(self._handle, nBeamInfoCount, nBeamInfoNeededCount, pBeamInfoBuffer))
		nBeamInfoCount = ctypes.c_uint64(nBeamInfoNeededCount.value)
		pBeamInfoBuffer = (Beam * nBeamInfoNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getbeams(self._handle, nBeamInfoCount, nBeamInfoNeededCount, pBeamInfoBuffer))
		
		return [pBeamInfoBuffer[i] for i in range(nBeamInfoNeededCount.value)]
	
	def GetBallCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getballcount(self._handle, pCount))
		
		return pCount.value
	
	def GetBall(self, Index):
		nIndex = ctypes.c_uint32(Index)
		pBallInfo = Ball()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getball(self._handle, nIndex, pBallInfo))
		
		return pBallInfo
	
	def AddBall(self, BallInfo):
		pIndex = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_addball(self._handle, BallInfo, pIndex))
		
		return pIndex.value
	
	def SetBall(self, Index, BallInfo):
		nIndex = ctypes.c_uint32(Index)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_setball(self._handle, nIndex, BallInfo))
		
	
	def SetBalls(self, BallInfo):
		nBallInfoCount = ctypes.c_uint64(len(BallInfo))
		pBallInfoBuffer = (Ball*len(BallInfo))(*BallInfo)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_setballs(self._handle, nBallInfoCount, pBallInfoBuffer))
		
	
	def GetBalls(self):
		nBallInfoCount = ctypes.c_uint64(0)
		nBallInfoNeededCount = ctypes.c_uint64(0)
		pBallInfoBuffer = (Ball*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getballs(self._handle, nBallInfoCount, nBallInfoNeededCount, pBallInfoBuffer))
		nBallInfoCount = ctypes.c_uint64(nBallInfoNeededCount.value)
		pBallInfoBuffer = (Ball * nBallInfoNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getballs(self._handle, nBallInfoCount, nBallInfoNeededCount, pBallInfoBuffer))
		
		return [pBallInfoBuffer[i] for i in range(nBallInfoNeededCount.value)]
	
	def GetBeamSetCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getbeamsetcount(self._handle, pCount))
		
		return pCount.value
	
	def AddBeamSet(self):
		BeamSetHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_addbeamset(self._handle, BeamSetHandle))
		if BeamSetHandle:
			BeamSetObject = self._wrapper._polymorphicFactory(BeamSetHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BeamSetObject
	
	def GetBeamSet(self, Index):
		nIndex = ctypes.c_uint32(Index)
		BeamSetHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getbeamset(self._handle, nIndex, BeamSetHandle))
		if BeamSetHandle:
			BeamSetObject = self._wrapper._polymorphicFactory(BeamSetHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BeamSetObject
	


''' Class Implementation for Component
'''
class Component(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetObjectResource(self):
		ObjectResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_component_getobjectresource(self._handle, ObjectResourceHandle))
		if ObjectResourceHandle:
			ObjectResourceObject = self._wrapper._polymorphicFactory(ObjectResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ObjectResourceObject
	
	def GetObjectResourceID(self):
		pUniqueResourceID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_component_getobjectresourceid(self._handle, pUniqueResourceID))
		
		return pUniqueResourceID.value
	
	def GetUUID(self):
		pHasUUID = ctypes.c_bool()
		nUUIDBufferSize = ctypes.c_uint64(0)
		nUUIDNeededChars = ctypes.c_uint64(0)
		pUUIDBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_component_getuuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		nUUIDBufferSize = ctypes.c_uint64(nUUIDNeededChars.value)
		pUUIDBuffer = (ctypes.c_char * (nUUIDNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_component_getuuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		
		return pHasUUID.value, pUUIDBuffer.value.decode()
	
	def SetUUID(self, UUID):
		pUUID = ctypes.c_char_p(str.encode(UUID))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_component_setuuid(self._handle, pUUID))
		
	
	def HasTransform(self):
		pHasTransform = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_component_hastransform(self._handle, pHasTransform))
		
		return pHasTransform.value
	
	def GetTransform(self):
		pTransform = Transform()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_component_gettransform(self._handle, pTransform))
		
		return pTransform
	
	def SetTransform(self, Transform):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_component_settransform(self._handle, Transform))
		
	


''' Class Implementation for ComponentsObject
'''
class ComponentsObject(Object):
	def __init__(self, handle, wrapper):
		Object.__init__(self, handle, wrapper)
	def AddComponent(self, ObjectResourceObject, Transform):
		ObjectResourceHandle = None
		if ObjectResourceObject:
			ObjectResourceHandle = ObjectResourceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		ComponentInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_componentsobject_addcomponent(self._handle, ObjectResourceHandle, Transform, ComponentInstanceHandle))
		if ComponentInstanceHandle:
			ComponentInstanceObject = self._wrapper._polymorphicFactory(ComponentInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ComponentInstanceObject
	
	def GetComponent(self, Index):
		nIndex = ctypes.c_uint32(Index)
		ComponentInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_componentsobject_getcomponent(self._handle, nIndex, ComponentInstanceHandle))
		if ComponentInstanceHandle:
			ComponentInstanceObject = self._wrapper._polymorphicFactory(ComponentInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ComponentInstanceObject
	
	def GetComponentCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_componentsobject_getcomponentcount(self._handle, pCount))
		
		return pCount.value
	


''' Class Implementation for BeamSet
'''
class BeamSet(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def SetName(self, Name):
		pName = ctypes.c_char_p(str.encode(Name))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_setname(self._handle, pName))
		
	
	def GetName(self):
		nNameBufferSize = ctypes.c_uint64(0)
		nNameNeededChars = ctypes.c_uint64(0)
		pNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getname(self._handle, nNameBufferSize, nNameNeededChars, pNameBuffer))
		nNameBufferSize = ctypes.c_uint64(nNameNeededChars.value)
		pNameBuffer = (ctypes.c_char * (nNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getname(self._handle, nNameBufferSize, nNameNeededChars, pNameBuffer))
		
		return pNameBuffer.value.decode()
	
	def SetIdentifier(self, Identifier):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_setidentifier(self._handle, pIdentifier))
		
	
	def GetIdentifier(self):
		nIdentifierBufferSize = ctypes.c_uint64(0)
		nIdentifierNeededChars = ctypes.c_uint64(0)
		pIdentifierBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getidentifier(self._handle, nIdentifierBufferSize, nIdentifierNeededChars, pIdentifierBuffer))
		nIdentifierBufferSize = ctypes.c_uint64(nIdentifierNeededChars.value)
		pIdentifierBuffer = (ctypes.c_char * (nIdentifierNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getidentifier(self._handle, nIdentifierBufferSize, nIdentifierNeededChars, pIdentifierBuffer))
		
		return pIdentifierBuffer.value.decode()
	
	def GetReferenceCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getreferencecount(self._handle, pCount))
		
		return pCount.value
	
	def SetReferences(self, References):
		nReferencesCount = ctypes.c_uint64(len(References))
		pReferencesBuffer = (ctypes.c_uint32*len(References))(*References)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_setreferences(self._handle, nReferencesCount, pReferencesBuffer))
		
	
	def GetReferences(self):
		nReferencesCount = ctypes.c_uint64(0)
		nReferencesNeededCount = ctypes.c_uint64(0)
		pReferencesBuffer = (ctypes.c_uint32*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getreferences(self._handle, nReferencesCount, nReferencesNeededCount, pReferencesBuffer))
		nReferencesCount = ctypes.c_uint64(nReferencesNeededCount.value)
		pReferencesBuffer = (ctypes.c_uint32 * nReferencesNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getreferences(self._handle, nReferencesCount, nReferencesNeededCount, pReferencesBuffer))
		
		return [pReferencesBuffer[i] for i in range(nReferencesNeededCount.value)]
	
	def GetBallReferenceCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getballreferencecount(self._handle, pCount))
		
		return pCount.value
	
	def SetBallReferences(self, BallReferences):
		nBallReferencesCount = ctypes.c_uint64(len(BallReferences))
		pBallReferencesBuffer = (ctypes.c_uint32*len(BallReferences))(*BallReferences)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_setballreferences(self._handle, nBallReferencesCount, pBallReferencesBuffer))
		
	
	def GetBallReferences(self):
		nBallReferencesCount = ctypes.c_uint64(0)
		nBallReferencesNeededCount = ctypes.c_uint64(0)
		pBallReferencesBuffer = (ctypes.c_uint32*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getballreferences(self._handle, nBallReferencesCount, nBallReferencesNeededCount, pBallReferencesBuffer))
		nBallReferencesCount = ctypes.c_uint64(nBallReferencesNeededCount.value)
		pBallReferencesBuffer = (ctypes.c_uint32 * nBallReferencesNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getballreferences(self._handle, nBallReferencesCount, nBallReferencesNeededCount, pBallReferencesBuffer))
		
		return [pBallReferencesBuffer[i] for i in range(nBallReferencesNeededCount.value)]
	


''' Class Implementation for BaseMaterialGroup
'''
class BaseMaterialGroup(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_getcount(self._handle, pCount))
		
		return pCount.value
	
	def GetAllPropertyIDs(self):
		nPropertyIDsCount = ctypes.c_uint64(0)
		nPropertyIDsNeededCount = ctypes.c_uint64(0)
		pPropertyIDsBuffer = (ctypes.c_uint32*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		nPropertyIDsCount = ctypes.c_uint64(nPropertyIDsNeededCount.value)
		pPropertyIDsBuffer = (ctypes.c_uint32 * nPropertyIDsNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		
		return [pPropertyIDsBuffer[i] for i in range(nPropertyIDsNeededCount.value)]
	
	def AddMaterial(self, Name, DisplayColor):
		pName = ctypes.c_char_p(str.encode(Name))
		pPropertyID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_addmaterial(self._handle, pName, DisplayColor, pPropertyID))
		
		return pPropertyID.value
	
	def RemoveMaterial(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_removematerial(self._handle, nPropertyID))
		
	
	def GetName(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		nNameBufferSize = ctypes.c_uint64(0)
		nNameNeededChars = ctypes.c_uint64(0)
		pNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_getname(self._handle, nPropertyID, nNameBufferSize, nNameNeededChars, pNameBuffer))
		nNameBufferSize = ctypes.c_uint64(nNameNeededChars.value)
		pNameBuffer = (ctypes.c_char * (nNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_getname(self._handle, nPropertyID, nNameBufferSize, nNameNeededChars, pNameBuffer))
		
		return pNameBuffer.value.decode()
	
	def SetName(self, PropertyID, Name):
		nPropertyID = ctypes.c_uint32(PropertyID)
		pName = ctypes.c_char_p(str.encode(Name))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_setname(self._handle, nPropertyID, pName))
		
	
	def SetDisplayColor(self, PropertyID, TheColor):
		nPropertyID = ctypes.c_uint32(PropertyID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_setdisplaycolor(self._handle, nPropertyID, TheColor))
		
	
	def GetDisplayColor(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		pTheColor = Color()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_getdisplaycolor(self._handle, nPropertyID, pTheColor))
		
		return pTheColor
	


''' Class Implementation for ColorGroup
'''
class ColorGroup(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_colorgroup_getcount(self._handle, pCount))
		
		return pCount.value
	
	def GetAllPropertyIDs(self):
		nPropertyIDsCount = ctypes.c_uint64(0)
		nPropertyIDsNeededCount = ctypes.c_uint64(0)
		pPropertyIDsBuffer = (ctypes.c_uint32*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_colorgroup_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		nPropertyIDsCount = ctypes.c_uint64(nPropertyIDsNeededCount.value)
		pPropertyIDsBuffer = (ctypes.c_uint32 * nPropertyIDsNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_colorgroup_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		
		return [pPropertyIDsBuffer[i] for i in range(nPropertyIDsNeededCount.value)]
	
	def AddColor(self, TheColor):
		pPropertyID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_colorgroup_addcolor(self._handle, TheColor, pPropertyID))
		
		return pPropertyID.value
	
	def RemoveColor(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_colorgroup_removecolor(self._handle, nPropertyID))
		
	
	def SetColor(self, PropertyID, TheColor):
		nPropertyID = ctypes.c_uint32(PropertyID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_colorgroup_setcolor(self._handle, nPropertyID, TheColor))
		
	
	def GetColor(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		pTheColor = Color()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_colorgroup_getcolor(self._handle, nPropertyID, pTheColor))
		
		return pTheColor
	


''' Class Implementation for Texture2DGroup
'''
class Texture2DGroup(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2dgroup_getcount(self._handle, pCount))
		
		return pCount.value
	
	def GetAllPropertyIDs(self):
		nPropertyIDsCount = ctypes.c_uint64(0)
		nPropertyIDsNeededCount = ctypes.c_uint64(0)
		pPropertyIDsBuffer = (ctypes.c_uint32*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2dgroup_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		nPropertyIDsCount = ctypes.c_uint64(nPropertyIDsNeededCount.value)
		pPropertyIDsBuffer = (ctypes.c_uint32 * nPropertyIDsNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2dgroup_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		
		return [pPropertyIDsBuffer[i] for i in range(nPropertyIDsNeededCount.value)]
	
	def AddTex2Coord(self, UVCoordinate):
		pPropertyID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2dgroup_addtex2coord(self._handle, UVCoordinate, pPropertyID))
		
		return pPropertyID.value
	
	def GetTex2Coord(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		pUVCoordinate = Tex2Coord()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2dgroup_gettex2coord(self._handle, nPropertyID, pUVCoordinate))
		
		return pUVCoordinate
	
	def RemoveTex2Coord(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2dgroup_removetex2coord(self._handle, nPropertyID))
		
	
	def GetTexture2D(self):
		Texture2DInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2dgroup_gettexture2d(self._handle, Texture2DInstanceHandle))
		if Texture2DInstanceHandle:
			Texture2DInstanceObject = self._wrapper._polymorphicFactory(Texture2DInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return Texture2DInstanceObject
	


''' Class Implementation for CompositeMaterials
'''
class CompositeMaterials(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_compositematerials_getcount(self._handle, pCount))
		
		return pCount.value
	
	def GetAllPropertyIDs(self):
		nPropertyIDsCount = ctypes.c_uint64(0)
		nPropertyIDsNeededCount = ctypes.c_uint64(0)
		pPropertyIDsBuffer = (ctypes.c_uint32*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_compositematerials_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		nPropertyIDsCount = ctypes.c_uint64(nPropertyIDsNeededCount.value)
		pPropertyIDsBuffer = (ctypes.c_uint32 * nPropertyIDsNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_compositematerials_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		
		return [pPropertyIDsBuffer[i] for i in range(nPropertyIDsNeededCount.value)]
	
	def GetBaseMaterialGroup(self):
		BaseMaterialGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_compositematerials_getbasematerialgroup(self._handle, BaseMaterialGroupInstanceHandle))
		if BaseMaterialGroupInstanceHandle:
			BaseMaterialGroupInstanceObject = self._wrapper._polymorphicFactory(BaseMaterialGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BaseMaterialGroupInstanceObject
	
	def AddComposite(self, Composite):
		nCompositeCount = ctypes.c_uint64(len(Composite))
		pCompositeBuffer = (CompositeConstituent*len(Composite))(*Composite)
		pPropertyID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_compositematerials_addcomposite(self._handle, nCompositeCount, pCompositeBuffer, pPropertyID))
		
		return pPropertyID.value
	
	def RemoveComposite(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_compositematerials_removecomposite(self._handle, nPropertyID))
		
	
	def GetComposite(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		nCompositeCount = ctypes.c_uint64(0)
		nCompositeNeededCount = ctypes.c_uint64(0)
		pCompositeBuffer = (CompositeConstituent*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_compositematerials_getcomposite(self._handle, nPropertyID, nCompositeCount, nCompositeNeededCount, pCompositeBuffer))
		nCompositeCount = ctypes.c_uint64(nCompositeNeededCount.value)
		pCompositeBuffer = (CompositeConstituent * nCompositeNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_compositematerials_getcomposite(self._handle, nPropertyID, nCompositeCount, nCompositeNeededCount, pCompositeBuffer))
		
		return [pCompositeBuffer[i] for i in range(nCompositeNeededCount.value)]
	


''' Class Implementation for MultiPropertyGroup
'''
class MultiPropertyGroup(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_getcount(self._handle, pCount))
		
		return pCount.value
	
	def GetAllPropertyIDs(self):
		nPropertyIDsCount = ctypes.c_uint64(0)
		nPropertyIDsNeededCount = ctypes.c_uint64(0)
		pPropertyIDsBuffer = (ctypes.c_uint32*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		nPropertyIDsCount = ctypes.c_uint64(nPropertyIDsNeededCount.value)
		pPropertyIDsBuffer = (ctypes.c_uint32 * nPropertyIDsNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		
		return [pPropertyIDsBuffer[i] for i in range(nPropertyIDsNeededCount.value)]
	
	def AddMultiProperty(self, PropertyIDs):
		nPropertyIDsCount = ctypes.c_uint64(len(PropertyIDs))
		pPropertyIDsBuffer = (ctypes.c_uint32*len(PropertyIDs))(*PropertyIDs)
		pPropertyID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_addmultiproperty(self._handle, nPropertyIDsCount, pPropertyIDsBuffer, pPropertyID))
		
		return pPropertyID.value
	
	def SetMultiProperty(self, PropertyID, PropertyIDs):
		nPropertyID = ctypes.c_uint32(PropertyID)
		nPropertyIDsCount = ctypes.c_uint64(len(PropertyIDs))
		pPropertyIDsBuffer = (ctypes.c_uint32*len(PropertyIDs))(*PropertyIDs)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_setmultiproperty(self._handle, nPropertyID, nPropertyIDsCount, pPropertyIDsBuffer))
		
	
	def GetMultiProperty(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		nPropertyIDsCount = ctypes.c_uint64(0)
		nPropertyIDsNeededCount = ctypes.c_uint64(0)
		pPropertyIDsBuffer = (ctypes.c_uint32*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_getmultiproperty(self._handle, nPropertyID, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		nPropertyIDsCount = ctypes.c_uint64(nPropertyIDsNeededCount.value)
		pPropertyIDsBuffer = (ctypes.c_uint32 * nPropertyIDsNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_getmultiproperty(self._handle, nPropertyID, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		
		return [pPropertyIDsBuffer[i] for i in range(nPropertyIDsNeededCount.value)]
	
	def RemoveMultiProperty(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_removemultiproperty(self._handle, nPropertyID))
		
	
	def GetLayerCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_getlayercount(self._handle, pCount))
		
		return pCount.value
	
	def AddLayer(self, TheLayer):
		pLayerIndex = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_addlayer(self._handle, TheLayer, pLayerIndex))
		
		return pLayerIndex.value
	
	def GetLayer(self, LayerIndex):
		nLayerIndex = ctypes.c_uint32(LayerIndex)
		pTheLayer = MultiPropertyLayer()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_getlayer(self._handle, nLayerIndex, pTheLayer))
		
		return pTheLayer
	
	def RemoveLayer(self, LayerIndex):
		nLayerIndex = ctypes.c_uint32(LayerIndex)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_removelayer(self._handle, nLayerIndex))
		
	


''' Class Implementation for Attachment
'''
class Attachment(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetPath(self):
		nPathBufferSize = ctypes.c_uint64(0)
		nPathNeededChars = ctypes.c_uint64(0)
		pPathBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_getpath(self._handle, nPathBufferSize, nPathNeededChars, pPathBuffer))
		nPathBufferSize = ctypes.c_uint64(nPathNeededChars.value)
		pPathBuffer = (ctypes.c_char * (nPathNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_getpath(self._handle, nPathBufferSize, nPathNeededChars, pPathBuffer))
		
		return pPathBuffer.value.decode()
	
	def SetPath(self, Path):
		pPath = ctypes.c_char_p(str.encode(Path))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_setpath(self._handle, pPath))
		
	
	def PackagePart(self):
		PackagePartHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_packagepart(self._handle, PackagePartHandle))
		if PackagePartHandle:
			PackagePartObject = self._wrapper._polymorphicFactory(PackagePartHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return PackagePartObject
	
	def GetRelationShipType(self):
		nPathBufferSize = ctypes.c_uint64(0)
		nPathNeededChars = ctypes.c_uint64(0)
		pPathBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_getrelationshiptype(self._handle, nPathBufferSize, nPathNeededChars, pPathBuffer))
		nPathBufferSize = ctypes.c_uint64(nPathNeededChars.value)
		pPathBuffer = (ctypes.c_char * (nPathNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_getrelationshiptype(self._handle, nPathBufferSize, nPathNeededChars, pPathBuffer))
		
		return pPathBuffer.value.decode()
	
	def SetRelationShipType(self, Path):
		pPath = ctypes.c_char_p(str.encode(Path))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_setrelationshiptype(self._handle, pPath))
		
	
	def WriteToFile(self, FileName):
		pFileName = ctypes.c_char_p(str.encode(FileName))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_writetofile(self._handle, pFileName))
		
	
	def ReadFromFile(self, FileName):
		pFileName = ctypes.c_char_p(str.encode(FileName))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_readfromfile(self._handle, pFileName))
		
	
	def ReadFromCallback(self, TheReadCallbackFunc, StreamSize, TheSeekCallbackFunc, UserData):
		nStreamSize = ctypes.c_uint64(StreamSize)
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_readfromcallback(self._handle, TheReadCallbackFunc, nStreamSize, TheSeekCallbackFunc, pUserData))
		
	
	def GetStreamSize(self):
		pStreamSize = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_getstreamsize(self._handle, pStreamSize))
		
		return pStreamSize.value
	
	def WriteToBuffer(self):
		nBufferCount = ctypes.c_uint64(0)
		nBufferNeededCount = ctypes.c_uint64(0)
		pBufferBuffer = (ctypes.c_uint8*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_writetobuffer(self._handle, nBufferCount, nBufferNeededCount, pBufferBuffer))
		nBufferCount = ctypes.c_uint64(nBufferNeededCount.value)
		pBufferBuffer = (ctypes.c_uint8 * nBufferNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_writetobuffer(self._handle, nBufferCount, nBufferNeededCount, pBufferBuffer))
		
		return [pBufferBuffer[i] for i in range(nBufferNeededCount.value)]
	
	def ReadFromBuffer(self, Buffer):
		nBufferCount = ctypes.c_uint64(len(Buffer))
		pBufferBuffer = (ctypes.c_uint8*len(Buffer))(*Buffer)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_readfrombuffer(self._handle, nBufferCount, pBufferBuffer))
		
	


''' Class Implementation for Texture2D
'''
class Texture2D(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetAttachment(self):
		AttachmentHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2d_getattachment(self._handle, AttachmentHandle))
		if AttachmentHandle:
			AttachmentObject = self._wrapper._polymorphicFactory(AttachmentHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return AttachmentObject
	
	def SetAttachment(self, AttachmentObject):
		AttachmentHandle = None
		if AttachmentObject:
			AttachmentHandle = AttachmentObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2d_setattachment(self._handle, AttachmentHandle))
		
	
	def GetContentType(self):
		pContentType = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2d_getcontenttype(self._handle, pContentType))
		
		return TextureType(pContentType.value)
	
	def SetContentType(self, ContentType):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2d_setcontenttype(self._handle, ContentType))
		
	
	def GetTileStyleUV(self):
		pTileStyleU = ctypes.c_int32()
		pTileStyleV = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2d_gettilestyleuv(self._handle, pTileStyleU, pTileStyleV))
		
		return TextureTileStyle(pTileStyleU.value), TextureTileStyle(pTileStyleV.value)
	
	def SetTileStyleUV(self, TileStyleU, TileStyleV):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2d_settilestyleuv(self._handle, TileStyleU, TileStyleV))
		
	
	def GetFilter(self):
		pFilter = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2d_getfilter(self._handle, pFilter))
		
		return TextureFilter(pFilter.value)
	
	def SetFilter(self, Filter):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2d_setfilter(self._handle, Filter))
		
	


''' Class Implementation for BuildItem
'''
class BuildItem(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetObjectResource(self):
		ObjectResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_getobjectresource(self._handle, ObjectResourceHandle))
		if ObjectResourceHandle:
			ObjectResourceObject = self._wrapper._polymorphicFactory(ObjectResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ObjectResourceObject
	
	def GetUUID(self):
		pHasUUID = ctypes.c_bool()
		nUUIDBufferSize = ctypes.c_uint64(0)
		nUUIDNeededChars = ctypes.c_uint64(0)
		pUUIDBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_getuuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		nUUIDBufferSize = ctypes.c_uint64(nUUIDNeededChars.value)
		pUUIDBuffer = (ctypes.c_char * (nUUIDNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_getuuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		
		return pHasUUID.value, pUUIDBuffer.value.decode()
	
	def SetUUID(self, UUID):
		pUUID = ctypes.c_char_p(str.encode(UUID))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_setuuid(self._handle, pUUID))
		
	
	def GetObjectResourceID(self):
		pUniqueResourceID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_getobjectresourceid(self._handle, pUniqueResourceID))
		
		return pUniqueResourceID.value
	
	def HasObjectTransform(self):
		pHasTransform = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_hasobjecttransform(self._handle, pHasTransform))
		
		return pHasTransform.value
	
	def GetObjectTransform(self):
		pTransform = Transform()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_getobjecttransform(self._handle, pTransform))
		
		return pTransform
	
	def SetObjectTransform(self, Transform):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_setobjecttransform(self._handle, Transform))
		
	
	def GetPartNumber(self):
		nPartNumberBufferSize = ctypes.c_uint64(0)
		nPartNumberNeededChars = ctypes.c_uint64(0)
		pPartNumberBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_getpartnumber(self._handle, nPartNumberBufferSize, nPartNumberNeededChars, pPartNumberBuffer))
		nPartNumberBufferSize = ctypes.c_uint64(nPartNumberNeededChars.value)
		pPartNumberBuffer = (ctypes.c_char * (nPartNumberNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_getpartnumber(self._handle, nPartNumberBufferSize, nPartNumberNeededChars, pPartNumberBuffer))
		
		return pPartNumberBuffer.value.decode()
	
	def SetPartNumber(self, SetPartnumber):
		pSetPartnumber = ctypes.c_char_p(str.encode(SetPartnumber))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_setpartnumber(self._handle, pSetPartnumber))
		
	
	def GetMetaDataGroup(self):
		MetaDataGroupHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_getmetadatagroup(self._handle, MetaDataGroupHandle))
		if MetaDataGroupHandle:
			MetaDataGroupObject = self._wrapper._polymorphicFactory(MetaDataGroupHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MetaDataGroupObject
	
	def GetOutbox(self):
		pOutbox = Box()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_getoutbox(self._handle, pOutbox))
		
		return pOutbox
	


''' Class Implementation for BuildItemIterator
'''
class BuildItemIterator(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def MoveNext(self):
		pHasNext = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditemiterator_movenext(self._handle, pHasNext))
		
		return pHasNext.value
	
	def MovePrevious(self):
		pHasPrevious = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditemiterator_moveprevious(self._handle, pHasPrevious))
		
		return pHasPrevious.value
	
	def GetCurrent(self):
		BuildItemHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditemiterator_getcurrent(self._handle, BuildItemHandle))
		if BuildItemHandle:
			BuildItemObject = self._wrapper._polymorphicFactory(BuildItemHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BuildItemObject
	
	def Clone(self):
		OutBuildItemIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditemiterator_clone(self._handle, OutBuildItemIteratorHandle))
		if OutBuildItemIteratorHandle:
			OutBuildItemIteratorObject = self._wrapper._polymorphicFactory(OutBuildItemIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return OutBuildItemIteratorObject
	
	def Count(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditemiterator_count(self._handle, pCount))
		
		return pCount.value
	


''' Class Implementation for Slice
'''
class Slice(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def SetVertices(self, Vertices):
		nVerticesCount = ctypes.c_uint64(len(Vertices))
		pVerticesBuffer = (Position2D*len(Vertices))(*Vertices)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_setvertices(self._handle, nVerticesCount, pVerticesBuffer))
		
	
	def GetVertices(self):
		nVerticesCount = ctypes.c_uint64(0)
		nVerticesNeededCount = ctypes.c_uint64(0)
		pVerticesBuffer = (Position2D*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_getvertices(self._handle, nVerticesCount, nVerticesNeededCount, pVerticesBuffer))
		nVerticesCount = ctypes.c_uint64(nVerticesNeededCount.value)
		pVerticesBuffer = (Position2D * nVerticesNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_getvertices(self._handle, nVerticesCount, nVerticesNeededCount, pVerticesBuffer))
		
		return [pVerticesBuffer[i] for i in range(nVerticesNeededCount.value)]
	
	def GetVertexCount(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_getvertexcount(self._handle, pCount))
		
		return pCount.value
	
	def AddPolygon(self, Indices):
		nIndicesCount = ctypes.c_uint64(len(Indices))
		pIndicesBuffer = (ctypes.c_uint32*len(Indices))(*Indices)
		pIndex = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_addpolygon(self._handle, nIndicesCount, pIndicesBuffer, pIndex))
		
		return pIndex.value
	
	def GetPolygonCount(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_getpolygoncount(self._handle, pCount))
		
		return pCount.value
	
	def SetPolygonIndices(self, Index, Indices):
		nIndex = ctypes.c_uint64(Index)
		nIndicesCount = ctypes.c_uint64(len(Indices))
		pIndicesBuffer = (ctypes.c_uint32*len(Indices))(*Indices)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_setpolygonindices(self._handle, nIndex, nIndicesCount, pIndicesBuffer))
		
	
	def GetPolygonIndices(self, Index):
		nIndex = ctypes.c_uint64(Index)
		nIndicesCount = ctypes.c_uint64(0)
		nIndicesNeededCount = ctypes.c_uint64(0)
		pIndicesBuffer = (ctypes.c_uint32*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_getpolygonindices(self._handle, nIndex, nIndicesCount, nIndicesNeededCount, pIndicesBuffer))
		nIndicesCount = ctypes.c_uint64(nIndicesNeededCount.value)
		pIndicesBuffer = (ctypes.c_uint32 * nIndicesNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_getpolygonindices(self._handle, nIndex, nIndicesCount, nIndicesNeededCount, pIndicesBuffer))
		
		return [pIndicesBuffer[i] for i in range(nIndicesNeededCount.value)]
	
	def GetPolygonIndexCount(self, Index):
		nIndex = ctypes.c_uint64(Index)
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_getpolygonindexcount(self._handle, nIndex, pCount))
		
		return pCount.value
	
	def GetZTop(self):
		pZTop = ctypes.c_double()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_getztop(self._handle, pZTop))
		
		return pZTop.value
	


''' Class Implementation for SliceStack
'''
class SliceStack(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetBottomZ(self):
		pZBottom = ctypes.c_double()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_getbottomz(self._handle, pZBottom))
		
		return pZBottom.value
	
	def GetSliceCount(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_getslicecount(self._handle, pCount))
		
		return pCount.value
	
	def GetSlice(self, SliceIndex):
		nSliceIndex = ctypes.c_uint64(SliceIndex)
		TheSliceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_getslice(self._handle, nSliceIndex, TheSliceHandle))
		if TheSliceHandle:
			TheSliceObject = self._wrapper._polymorphicFactory(TheSliceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheSliceObject
	
	def AddSlice(self, ZTop):
		dZTop = ctypes.c_double(ZTop)
		TheSliceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_addslice(self._handle, dZTop, TheSliceHandle))
		if TheSliceHandle:
			TheSliceObject = self._wrapper._polymorphicFactory(TheSliceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheSliceObject
	
	def GetSliceRefCount(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_getslicerefcount(self._handle, pCount))
		
		return pCount.value
	
	def AddSliceStackReference(self, TheSliceStackObject):
		TheSliceStackHandle = None
		if TheSliceStackObject:
			TheSliceStackHandle = TheSliceStackObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_addslicestackreference(self._handle, TheSliceStackHandle))
		
	
	def GetSliceStackReference(self, SliceRefIndex):
		nSliceRefIndex = ctypes.c_uint64(SliceRefIndex)
		TheSliceStackHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_getslicestackreference(self._handle, nSliceRefIndex, TheSliceStackHandle))
		if TheSliceStackHandle:
			TheSliceStackObject = self._wrapper._polymorphicFactory(TheSliceStackHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheSliceStackObject
	
	def CollapseSliceReferences(self):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_collapseslicereferences(self._handle))
		
	
	def SetOwnPath(self, Path):
		pPath = ctypes.c_char_p(str.encode(Path))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_setownpath(self._handle, pPath))
		
	
	def GetOwnPath(self):
		nPathBufferSize = ctypes.c_uint64(0)
		nPathNeededChars = ctypes.c_uint64(0)
		pPathBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_getownpath(self._handle, nPathBufferSize, nPathNeededChars, pPathBuffer))
		nPathBufferSize = ctypes.c_uint64(nPathNeededChars.value)
		pPathBuffer = (ctypes.c_char * (nPathNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_getownpath(self._handle, nPathBufferSize, nPathNeededChars, pPathBuffer))
		
		return pPathBuffer.value.decode()
	


''' Class Implementation for Consumer
'''
class Consumer(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetConsumerID(self):
		nConsumerIDBufferSize = ctypes.c_uint64(0)
		nConsumerIDNeededChars = ctypes.c_uint64(0)
		pConsumerIDBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_consumer_getconsumerid(self._handle, nConsumerIDBufferSize, nConsumerIDNeededChars, pConsumerIDBuffer))
		nConsumerIDBufferSize = ctypes.c_uint64(nConsumerIDNeededChars.value)
		pConsumerIDBuffer = (ctypes.c_char * (nConsumerIDNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_consumer_getconsumerid(self._handle, nConsumerIDBufferSize, nConsumerIDNeededChars, pConsumerIDBuffer))
		
		return pConsumerIDBuffer.value.decode()
	
	def GetKeyID(self):
		nKeyIDBufferSize = ctypes.c_uint64(0)
		nKeyIDNeededChars = ctypes.c_uint64(0)
		pKeyIDBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_consumer_getkeyid(self._handle, nKeyIDBufferSize, nKeyIDNeededChars, pKeyIDBuffer))
		nKeyIDBufferSize = ctypes.c_uint64(nKeyIDNeededChars.value)
		pKeyIDBuffer = (ctypes.c_char * (nKeyIDNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_consumer_getkeyid(self._handle, nKeyIDBufferSize, nKeyIDNeededChars, pKeyIDBuffer))
		
		return pKeyIDBuffer.value.decode()
	
	def GetKeyValue(self):
		nKeyValueBufferSize = ctypes.c_uint64(0)
		nKeyValueNeededChars = ctypes.c_uint64(0)
		pKeyValueBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_consumer_getkeyvalue(self._handle, nKeyValueBufferSize, nKeyValueNeededChars, pKeyValueBuffer))
		nKeyValueBufferSize = ctypes.c_uint64(nKeyValueNeededChars.value)
		pKeyValueBuffer = (ctypes.c_char * (nKeyValueNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_consumer_getkeyvalue(self._handle, nKeyValueBufferSize, nKeyValueNeededChars, pKeyValueBuffer))
		
		return pKeyValueBuffer.value.decode()
	


''' Class Implementation for AccessRight
'''
class AccessRight(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetConsumer(self):
		ConsumerHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_accessright_getconsumer(self._handle, ConsumerHandle))
		if ConsumerHandle:
			ConsumerObject = self._wrapper._polymorphicFactory(ConsumerHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ConsumerObject
	
	def GetWrappingAlgorithm(self):
		pAlgorithm = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_accessright_getwrappingalgorithm(self._handle, pAlgorithm))
		
		return WrappingAlgorithm(pAlgorithm.value)
	
	def GetMgfAlgorithm(self):
		pAlgorithm = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_accessright_getmgfalgorithm(self._handle, pAlgorithm))
		
		return MgfAlgorithm(pAlgorithm.value)
	
	def GetDigestMethod(self):
		pAlgorithm = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_accessright_getdigestmethod(self._handle, pAlgorithm))
		
		return DigestMethod(pAlgorithm.value)
	


''' Class Implementation for ContentEncryptionParams
'''
class ContentEncryptionParams(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetEncryptionAlgorithm(self):
		pAlgorithm = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getencryptionalgorithm(self._handle, pAlgorithm))
		
		return EncryptionAlgorithm(pAlgorithm.value)
	
	def GetKey(self):
		nByteDataCount = ctypes.c_uint64(0)
		nByteDataNeededCount = ctypes.c_uint64(0)
		pByteDataBuffer = (ctypes.c_uint8*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getkey(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		nByteDataCount = ctypes.c_uint64(nByteDataNeededCount.value)
		pByteDataBuffer = (ctypes.c_uint8 * nByteDataNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getkey(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		
		return [pByteDataBuffer[i] for i in range(nByteDataNeededCount.value)]
	
	def GetInitializationVector(self):
		nByteDataCount = ctypes.c_uint64(0)
		nByteDataNeededCount = ctypes.c_uint64(0)
		pByteDataBuffer = (ctypes.c_uint8*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getinitializationvector(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		nByteDataCount = ctypes.c_uint64(nByteDataNeededCount.value)
		pByteDataBuffer = (ctypes.c_uint8 * nByteDataNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getinitializationvector(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		
		return [pByteDataBuffer[i] for i in range(nByteDataNeededCount.value)]
	
	def GetAuthenticationTag(self):
		nByteDataCount = ctypes.c_uint64(0)
		nByteDataNeededCount = ctypes.c_uint64(0)
		pByteDataBuffer = (ctypes.c_uint8*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getauthenticationtag(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		nByteDataCount = ctypes.c_uint64(nByteDataNeededCount.value)
		pByteDataBuffer = (ctypes.c_uint8 * nByteDataNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getauthenticationtag(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		
		return [pByteDataBuffer[i] for i in range(nByteDataNeededCount.value)]
	
	def SetAuthenticationTag(self, ByteData):
		nByteDataCount = ctypes.c_uint64(len(ByteData))
		pByteDataBuffer = (ctypes.c_uint8*len(ByteData))(*ByteData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_setauthenticationtag(self._handle, nByteDataCount, pByteDataBuffer))
		
	
	def GetAdditionalAuthenticationData(self):
		nByteDataCount = ctypes.c_uint64(0)
		nByteDataNeededCount = ctypes.c_uint64(0)
		pByteDataBuffer = (ctypes.c_uint8*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getadditionalauthenticationdata(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		nByteDataCount = ctypes.c_uint64(nByteDataNeededCount.value)
		pByteDataBuffer = (ctypes.c_uint8 * nByteDataNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getadditionalauthenticationdata(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		
		return [pByteDataBuffer[i] for i in range(nByteDataNeededCount.value)]
	
	def GetDescriptor(self):
		pDescriptor = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getdescriptor(self._handle, pDescriptor))
		
		return pDescriptor.value
	
	def GetKeyUUID(self):
		nUUIDBufferSize = ctypes.c_uint64(0)
		nUUIDNeededChars = ctypes.c_uint64(0)
		pUUIDBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getkeyuuid(self._handle, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		nUUIDBufferSize = ctypes.c_uint64(nUUIDNeededChars.value)
		pUUIDBuffer = (ctypes.c_char * (nUUIDNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getkeyuuid(self._handle, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		
		return pUUIDBuffer.value.decode()
	


''' Class Implementation for ResourceData
'''
class ResourceData(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetPath(self):
		PathHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedata_getpath(self._handle, PathHandle))
		if PathHandle:
			PathObject = self._wrapper._polymorphicFactory(PathHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return PathObject
	
	def GetEncryptionAlgorithm(self):
		pEncryptionAlgorithm = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedata_getencryptionalgorithm(self._handle, pEncryptionAlgorithm))
		
		return EncryptionAlgorithm(pEncryptionAlgorithm.value)
	
	def GetCompression(self):
		pCompression = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedata_getcompression(self._handle, pCompression))
		
		return Compression(pCompression.value)
	
	def GetAdditionalAuthenticationData(self):
		nByteDataCount = ctypes.c_uint64(0)
		nByteDataNeededCount = ctypes.c_uint64(0)
		pByteDataBuffer = (ctypes.c_uint8*0)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedata_getadditionalauthenticationdata(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		nByteDataCount = ctypes.c_uint64(nByteDataNeededCount.value)
		pByteDataBuffer = (ctypes.c_uint8 * nByteDataNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedata_getadditionalauthenticationdata(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		
		return [pByteDataBuffer[i] for i in range(nByteDataNeededCount.value)]
	


''' Class Implementation for ResourceDataGroup
'''
class ResourceDataGroup(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetKeyUUID(self):
		nUUIDBufferSize = ctypes.c_uint64(0)
		nUUIDNeededChars = ctypes.c_uint64(0)
		pUUIDBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedatagroup_getkeyuuid(self._handle, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		nUUIDBufferSize = ctypes.c_uint64(nUUIDNeededChars.value)
		pUUIDBuffer = (ctypes.c_char * (nUUIDNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedatagroup_getkeyuuid(self._handle, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		
		return pUUIDBuffer.value.decode()
	
	def AddAccessRight(self, ConsumerObject, WrappingAlgorithm, MgfAlgorithm, DigestMethod):
		ConsumerHandle = None
		if ConsumerObject:
			ConsumerHandle = ConsumerObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		TheAccessRightHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedatagroup_addaccessright(self._handle, ConsumerHandle, WrappingAlgorithm, MgfAlgorithm, DigestMethod, TheAccessRightHandle))
		if TheAccessRightHandle:
			TheAccessRightObject = self._wrapper._polymorphicFactory(TheAccessRightHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheAccessRightObject
	
	def FindAccessRightByConsumer(self, ConsumerObject):
		ConsumerHandle = None
		if ConsumerObject:
			ConsumerHandle = ConsumerObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		TheAccessRightHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedatagroup_findaccessrightbyconsumer(self._handle, ConsumerHandle, TheAccessRightHandle))
		if TheAccessRightHandle:
			TheAccessRightObject = self._wrapper._polymorphicFactory(TheAccessRightHandle)
		else:
			TheAccessRightObject = None
		
		return TheAccessRightObject
	
	def RemoveAccessRight(self, ConsumerObject):
		ConsumerHandle = None
		if ConsumerObject:
			ConsumerHandle = ConsumerObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedatagroup_removeaccessright(self._handle, ConsumerHandle))
		
	


''' Class Implementation for KeyStore
'''
class KeyStore(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def AddConsumer(self, ConsumerID, KeyID, KeyValue):
		pConsumerID = ctypes.c_char_p(str.encode(ConsumerID))
		pKeyID = ctypes.c_char_p(str.encode(KeyID))
		pKeyValue = ctypes.c_char_p(str.encode(KeyValue))
		ConsumerHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_addconsumer(self._handle, pConsumerID, pKeyID, pKeyValue, ConsumerHandle))
		if ConsumerHandle:
			ConsumerObject = self._wrapper._polymorphicFactory(ConsumerHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ConsumerObject
	
	def GetConsumerCount(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_getconsumercount(self._handle, pCount))
		
		return pCount.value
	
	def GetConsumer(self, ConsumerIndex):
		nConsumerIndex = ctypes.c_uint64(ConsumerIndex)
		ConsumerHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_getconsumer(self._handle, nConsumerIndex, ConsumerHandle))
		if ConsumerHandle:
			ConsumerObject = self._wrapper._polymorphicFactory(ConsumerHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ConsumerObject
	
	def RemoveConsumer(self, ConsumerObject):
		ConsumerHandle = None
		if ConsumerObject:
			ConsumerHandle = ConsumerObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_removeconsumer(self._handle, ConsumerHandle))
		
	
	def FindConsumer(self, ConsumerID):
		pConsumerID = ctypes.c_char_p(str.encode(ConsumerID))
		ConsumerHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_findconsumer(self._handle, pConsumerID, ConsumerHandle))
		if ConsumerHandle:
			ConsumerObject = self._wrapper._polymorphicFactory(ConsumerHandle)
		else:
			ConsumerObject = None
		
		return ConsumerObject
	
	def GetResourceDataGroupCount(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_getresourcedatagroupcount(self._handle, pCount))
		
		return pCount.value
	
	def AddResourceDataGroup(self):
		ResourceDataGroupHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_addresourcedatagroup(self._handle, ResourceDataGroupHandle))
		if ResourceDataGroupHandle:
			ResourceDataGroupObject = self._wrapper._polymorphicFactory(ResourceDataGroupHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceDataGroupObject
	
	def GetResourceDataGroup(self, ResourceDataIndex):
		nResourceDataIndex = ctypes.c_uint64(ResourceDataIndex)
		ResourceDataGroupHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_getresourcedatagroup(self._handle, nResourceDataIndex, ResourceDataGroupHandle))
		if ResourceDataGroupHandle:
			ResourceDataGroupObject = self._wrapper._polymorphicFactory(ResourceDataGroupHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceDataGroupObject
	
	def RemoveResourceDataGroup(self, ResourceDataGroupObject):
		ResourceDataGroupHandle = None
		if ResourceDataGroupObject:
			ResourceDataGroupHandle = ResourceDataGroupObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_removeresourcedatagroup(self._handle, ResourceDataGroupHandle))
		
	
	def FindResourceDataGroup(self, PartPathObject):
		PartPathHandle = None
		if PartPathObject:
			PartPathHandle = PartPathObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		ResourceDataGroupHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_findresourcedatagroup(self._handle, PartPathHandle, ResourceDataGroupHandle))
		if ResourceDataGroupHandle:
			ResourceDataGroupObject = self._wrapper._polymorphicFactory(ResourceDataGroupHandle)
		else:
			ResourceDataGroupObject = None
		
		return ResourceDataGroupObject
	
	def AddResourceData(self, ResourceDataGroupObject, PartPathObject, Algorithm, Compression, AdditionalAuthenticationData):
		ResourceDataGroupHandle = None
		if ResourceDataGroupObject:
			ResourceDataGroupHandle = ResourceDataGroupObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		PartPathHandle = None
		if PartPathObject:
			PartPathHandle = PartPathObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		nAdditionalAuthenticationDataCount = ctypes.c_uint64(len(AdditionalAuthenticationData))
		pAdditionalAuthenticationDataBuffer = (ctypes.c_uint8*len(AdditionalAuthenticationData))(*AdditionalAuthenticationData)
		ResourceDataHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_addresourcedata(self._handle, ResourceDataGroupHandle, PartPathHandle, Algorithm, Compression, nAdditionalAuthenticationDataCount, pAdditionalAuthenticationDataBuffer, ResourceDataHandle))
		if ResourceDataHandle:
			ResourceDataObject = self._wrapper._polymorphicFactory(ResourceDataHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceDataObject
	
	def RemoveResourceData(self, ResourceDataObject):
		ResourceDataHandle = None
		if ResourceDataObject:
			ResourceDataHandle = ResourceDataObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_removeresourcedata(self._handle, ResourceDataHandle))
		
	
	def FindResourceData(self, ResourcePathObject):
		ResourcePathHandle = None
		if ResourcePathObject:
			ResourcePathHandle = ResourcePathObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		ResourceDataHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_findresourcedata(self._handle, ResourcePathHandle, ResourceDataHandle))
		if ResourceDataHandle:
			ResourceDataObject = self._wrapper._polymorphicFactory(ResourceDataHandle)
		else:
			ResourceDataObject = None
		
		return ResourceDataObject
	
	def GetResourceDataCount(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_getresourcedatacount(self._handle, pCount))
		
		return pCount.value
	
	def GetResourceData(self, ResourceDataIndex):
		nResourceDataIndex = ctypes.c_uint64(ResourceDataIndex)
		ResourceDataHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_getresourcedata(self._handle, nResourceDataIndex, ResourceDataHandle))
		if ResourceDataHandle:
			ResourceDataObject = self._wrapper._polymorphicFactory(ResourceDataHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceDataObject
	
	def GetUUID(self):
		pHasUUID = ctypes.c_bool()
		nUUIDBufferSize = ctypes.c_uint64(0)
		nUUIDNeededChars = ctypes.c_uint64(0)
		pUUIDBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_getuuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		nUUIDBufferSize = ctypes.c_uint64(nUUIDNeededChars.value)
		pUUIDBuffer = (ctypes.c_char * (nUUIDNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_getuuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		
		return pHasUUID.value, pUUIDBuffer.value.decode()
	
	def SetUUID(self, UUID):
		pUUID = ctypes.c_char_p(str.encode(UUID))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_setuuid(self._handle, pUUID))
		
	


''' Class Implementation for Model
'''
class Model(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def RootModelPart(self):
		RootModelPartHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_rootmodelpart(self._handle, RootModelPartHandle))
		if RootModelPartHandle:
			RootModelPartObject = self._wrapper._polymorphicFactory(RootModelPartHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return RootModelPartObject
	
	def FindOrCreatePackagePart(self, AbsolutePath):
		pAbsolutePath = ctypes.c_char_p(str.encode(AbsolutePath))
		ModelPartHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_findorcreatepackagepart(self._handle, pAbsolutePath, ModelPartHandle))
		if ModelPartHandle:
			ModelPartObject = self._wrapper._polymorphicFactory(ModelPartHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ModelPartObject
	
	def SetUnit(self, Unit):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_setunit(self._handle, Unit))
		
	
	def GetUnit(self):
		pUnit = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getunit(self._handle, pUnit))
		
		return ModelUnit(pUnit.value)
	
	def GetLanguage(self):
		nLanguageBufferSize = ctypes.c_uint64(0)
		nLanguageNeededChars = ctypes.c_uint64(0)
		pLanguageBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getlanguage(self._handle, nLanguageBufferSize, nLanguageNeededChars, pLanguageBuffer))
		nLanguageBufferSize = ctypes.c_uint64(nLanguageNeededChars.value)
		pLanguageBuffer = (ctypes.c_char * (nLanguageNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getlanguage(self._handle, nLanguageBufferSize, nLanguageNeededChars, pLanguageBuffer))
		
		return pLanguageBuffer.value.decode()
	
	def SetLanguage(self, Language):
		pLanguage = ctypes.c_char_p(str.encode(Language))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_setlanguage(self._handle, pLanguage))
		
	
	def QueryWriter(self, WriterClass):
		pWriterClass = ctypes.c_char_p(str.encode(WriterClass))
		WriterInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_querywriter(self._handle, pWriterClass, WriterInstanceHandle))
		if WriterInstanceHandle:
			WriterInstanceObject = self._wrapper._polymorphicFactory(WriterInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return WriterInstanceObject
	
	def QueryReader(self, ReaderClass):
		pReaderClass = ctypes.c_char_p(str.encode(ReaderClass))
		ReaderInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_queryreader(self._handle, pReaderClass, ReaderInstanceHandle))
		if ReaderInstanceHandle:
			ReaderInstanceObject = self._wrapper._polymorphicFactory(ReaderInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ReaderInstanceObject
	
	def GetResourceByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getresourcebyid(self._handle, nUniqueResourceID, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	
	def GetTexture2DByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		TextureInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_gettexture2dbyid(self._handle, nUniqueResourceID, TextureInstanceHandle))
		if TextureInstanceHandle:
			TextureInstanceObject = self._wrapper._polymorphicFactory(TextureInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TextureInstanceObject
	
	def GetPropertyTypeByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		pThePropertyType = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getpropertytypebyid(self._handle, nUniqueResourceID, pThePropertyType))
		
		return PropertyType(pThePropertyType.value)
	
	def GetBaseMaterialGroupByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		BaseMaterialGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getbasematerialgroupbyid(self._handle, nUniqueResourceID, BaseMaterialGroupInstanceHandle))
		if BaseMaterialGroupInstanceHandle:
			BaseMaterialGroupInstanceObject = self._wrapper._polymorphicFactory(BaseMaterialGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BaseMaterialGroupInstanceObject
	
	def GetTexture2DGroupByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		Texture2DGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_gettexture2dgroupbyid(self._handle, nUniqueResourceID, Texture2DGroupInstanceHandle))
		if Texture2DGroupInstanceHandle:
			Texture2DGroupInstanceObject = self._wrapper._polymorphicFactory(Texture2DGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return Texture2DGroupInstanceObject
	
	def GetCompositeMaterialsByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		CompositeMaterialsInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getcompositematerialsbyid(self._handle, nUniqueResourceID, CompositeMaterialsInstanceHandle))
		if CompositeMaterialsInstanceHandle:
			CompositeMaterialsInstanceObject = self._wrapper._polymorphicFactory(CompositeMaterialsInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return CompositeMaterialsInstanceObject
	
	def GetMultiPropertyGroupByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		MultiPropertyGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getmultipropertygroupbyid(self._handle, nUniqueResourceID, MultiPropertyGroupInstanceHandle))
		if MultiPropertyGroupInstanceHandle:
			MultiPropertyGroupInstanceObject = self._wrapper._polymorphicFactory(MultiPropertyGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MultiPropertyGroupInstanceObject
	
	def GetMeshObjectByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		MeshObjectInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getmeshobjectbyid(self._handle, nUniqueResourceID, MeshObjectInstanceHandle))
		if MeshObjectInstanceHandle:
			MeshObjectInstanceObject = self._wrapper._polymorphicFactory(MeshObjectInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MeshObjectInstanceObject
	
	def GetComponentsObjectByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		ComponentsObjectInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getcomponentsobjectbyid(self._handle, nUniqueResourceID, ComponentsObjectInstanceHandle))
		if ComponentsObjectInstanceHandle:
			ComponentsObjectInstanceObject = self._wrapper._polymorphicFactory(ComponentsObjectInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ComponentsObjectInstanceObject
	
	def GetColorGroupByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		ColorGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getcolorgroupbyid(self._handle, nUniqueResourceID, ColorGroupInstanceHandle))
		if ColorGroupInstanceHandle:
			ColorGroupInstanceObject = self._wrapper._polymorphicFactory(ColorGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ColorGroupInstanceObject
	
	def GetSliceStackByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		SliceStacInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getslicestackbyid(self._handle, nUniqueResourceID, SliceStacInstanceHandle))
		if SliceStacInstanceHandle:
			SliceStacInstanceObject = self._wrapper._polymorphicFactory(SliceStacInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return SliceStacInstanceObject
	
	def GetBuildUUID(self):
		pHasUUID = ctypes.c_bool()
		nUUIDBufferSize = ctypes.c_uint64(0)
		nUUIDNeededChars = ctypes.c_uint64(0)
		pUUIDBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getbuilduuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		nUUIDBufferSize = ctypes.c_uint64(nUUIDNeededChars.value)
		pUUIDBuffer = (ctypes.c_char * (nUUIDNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getbuilduuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		
		return pHasUUID.value, pUUIDBuffer.value.decode()
	
	def SetBuildUUID(self, UUID):
		pUUID = ctypes.c_char_p(str.encode(UUID))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_setbuilduuid(self._handle, pUUID))
		
	
	def GetBuildItems(self):
		BuildItemIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getbuilditems(self._handle, BuildItemIteratorHandle))
		if BuildItemIteratorHandle:
			BuildItemIteratorObject = self._wrapper._polymorphicFactory(BuildItemIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BuildItemIteratorObject
	
	def GetOutbox(self):
		pOutbox = Box()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getoutbox(self._handle, pOutbox))
		
		return pOutbox
	
	def GetResources(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getresources(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetObjects(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getobjects(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetMeshObjects(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getmeshobjects(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetComponentsObjects(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getcomponentsobjects(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetTexture2Ds(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_gettexture2ds(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetBaseMaterialGroups(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getbasematerialgroups(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetColorGroups(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getcolorgroups(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetTexture2DGroups(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_gettexture2dgroups(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetCompositeMaterials(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getcompositematerials(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetMultiPropertyGroups(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getmultipropertygroups(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetSliceStacks(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getslicestacks(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def MergeToModel(self):
		MergedModelInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_mergetomodel(self._handle, MergedModelInstanceHandle))
		if MergedModelInstanceHandle:
			MergedModelInstanceObject = self._wrapper._polymorphicFactory(MergedModelInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MergedModelInstanceObject
	
	def AddMeshObject(self):
		MeshObjectInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addmeshobject(self._handle, MeshObjectInstanceHandle))
		if MeshObjectInstanceHandle:
			MeshObjectInstanceObject = self._wrapper._polymorphicFactory(MeshObjectInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MeshObjectInstanceObject
	
	def AddComponentsObject(self):
		ComponentsObjectInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addcomponentsobject(self._handle, ComponentsObjectInstanceHandle))
		if ComponentsObjectInstanceHandle:
			ComponentsObjectInstanceObject = self._wrapper._polymorphicFactory(ComponentsObjectInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ComponentsObjectInstanceObject
	
	def AddSliceStack(self, ZBottom):
		dZBottom = ctypes.c_double(ZBottom)
		SliceStackInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addslicestack(self._handle, dZBottom, SliceStackInstanceHandle))
		if SliceStackInstanceHandle:
			SliceStackInstanceObject = self._wrapper._polymorphicFactory(SliceStackInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return SliceStackInstanceObject
	
	def AddTexture2DFromAttachment(self, TextureAttachmentObject):
		TextureAttachmentHandle = None
		if TextureAttachmentObject:
			TextureAttachmentHandle = TextureAttachmentObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		Texture2DInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addtexture2dfromattachment(self._handle, TextureAttachmentHandle, Texture2DInstanceHandle))
		if Texture2DInstanceHandle:
			Texture2DInstanceObject = self._wrapper._polymorphicFactory(Texture2DInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return Texture2DInstanceObject
	
	def AddBaseMaterialGroup(self):
		BaseMaterialGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addbasematerialgroup(self._handle, BaseMaterialGroupInstanceHandle))
		if BaseMaterialGroupInstanceHandle:
			BaseMaterialGroupInstanceObject = self._wrapper._polymorphicFactory(BaseMaterialGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BaseMaterialGroupInstanceObject
	
	def AddColorGroup(self):
		ColorGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addcolorgroup(self._handle, ColorGroupInstanceHandle))
		if ColorGroupInstanceHandle:
			ColorGroupInstanceObject = self._wrapper._polymorphicFactory(ColorGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ColorGroupInstanceObject
	
	def AddTexture2DGroup(self, Texture2DInstanceObject):
		Texture2DInstanceHandle = None
		if Texture2DInstanceObject:
			Texture2DInstanceHandle = Texture2DInstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		Texture2DGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addtexture2dgroup(self._handle, Texture2DInstanceHandle, Texture2DGroupInstanceHandle))
		if Texture2DGroupInstanceHandle:
			Texture2DGroupInstanceObject = self._wrapper._polymorphicFactory(Texture2DGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return Texture2DGroupInstanceObject
	
	def AddCompositeMaterials(self, BaseMaterialGroupInstanceObject):
		BaseMaterialGroupInstanceHandle = None
		if BaseMaterialGroupInstanceObject:
			BaseMaterialGroupInstanceHandle = BaseMaterialGroupInstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		CompositeMaterialsInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addcompositematerials(self._handle, BaseMaterialGroupInstanceHandle, CompositeMaterialsInstanceHandle))
		if CompositeMaterialsInstanceHandle:
			CompositeMaterialsInstanceObject = self._wrapper._polymorphicFactory(CompositeMaterialsInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return CompositeMaterialsInstanceObject
	
	def AddMultiPropertyGroup(self):
		MultiPropertyGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addmultipropertygroup(self._handle, MultiPropertyGroupInstanceHandle))
		if MultiPropertyGroupInstanceHandle:
			MultiPropertyGroupInstanceObject = self._wrapper._polymorphicFactory(MultiPropertyGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MultiPropertyGroupInstanceObject
	
	def AddBuildItem(self, ObjectObject, Transform):
		ObjectHandle = None
		if ObjectObject:
			ObjectHandle = ObjectObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		BuildItemInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addbuilditem(self._handle, ObjectHandle, Transform, BuildItemInstanceHandle))
		if BuildItemInstanceHandle:
			BuildItemInstanceObject = self._wrapper._polymorphicFactory(BuildItemInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BuildItemInstanceObject
	
	def RemoveBuildItem(self, BuildItemInstanceObject):
		BuildItemInstanceHandle = None
		if BuildItemInstanceObject:
			BuildItemInstanceHandle = BuildItemInstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_removebuilditem(self._handle, BuildItemInstanceHandle))
		
	
	def GetMetaDataGroup(self):
		TheMetaDataGroupHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getmetadatagroup(self._handle, TheMetaDataGroupHandle))
		if TheMetaDataGroupHandle:
			TheMetaDataGroupObject = self._wrapper._polymorphicFactory(TheMetaDataGroupHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheMetaDataGroupObject
	
	def AddAttachment(self, URI, RelationShipType):
		pURI = ctypes.c_char_p(str.encode(URI))
		pRelationShipType = ctypes.c_char_p(str.encode(RelationShipType))
		AttachmentInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addattachment(self._handle, pURI, pRelationShipType, AttachmentInstanceHandle))
		if AttachmentInstanceHandle:
			AttachmentInstanceObject = self._wrapper._polymorphicFactory(AttachmentInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return AttachmentInstanceObject
	
	def RemoveAttachment(self, AttachmentInstanceObject):
		AttachmentInstanceHandle = None
		if AttachmentInstanceObject:
			AttachmentInstanceHandle = AttachmentInstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_removeattachment(self._handle, AttachmentInstanceHandle))
		
	
	def GetAttachment(self, Index):
		nIndex = ctypes.c_uint32(Index)
		AttachmentInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getattachment(self._handle, nIndex, AttachmentInstanceHandle))
		if AttachmentInstanceHandle:
			AttachmentInstanceObject = self._wrapper._polymorphicFactory(AttachmentInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return AttachmentInstanceObject
	
	def FindAttachment(self, URI):
		pURI = ctypes.c_char_p(str.encode(URI))
		AttachmentInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_findattachment(self._handle, pURI, AttachmentInstanceHandle))
		if AttachmentInstanceHandle:
			AttachmentInstanceObject = self._wrapper._polymorphicFactory(AttachmentInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return AttachmentInstanceObject
	
	def GetAttachmentCount(self):
		pAttachmentCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getattachmentcount(self._handle, pAttachmentCount))
		
		return pAttachmentCount.value
	
	def HasPackageThumbnailAttachment(self):
		pHasThumbnail = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_haspackagethumbnailattachment(self._handle, pHasThumbnail))
		
		return pHasThumbnail.value
	
	def CreatePackageThumbnailAttachment(self):
		AttachmentHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_createpackagethumbnailattachment(self._handle, AttachmentHandle))
		if AttachmentHandle:
			AttachmentObject = self._wrapper._polymorphicFactory(AttachmentHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return AttachmentObject
	
	def GetPackageThumbnailAttachment(self):
		AttachmentHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getpackagethumbnailattachment(self._handle, AttachmentHandle))
		if AttachmentHandle:
			AttachmentObject = self._wrapper._polymorphicFactory(AttachmentHandle)
		else:
			AttachmentObject = None
		
		return AttachmentObject
	
	def RemovePackageThumbnailAttachment(self):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_removepackagethumbnailattachment(self._handle))
		
	
	def AddCustomContentType(self, Extension, ContentType):
		pExtension = ctypes.c_char_p(str.encode(Extension))
		pContentType = ctypes.c_char_p(str.encode(ContentType))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addcustomcontenttype(self._handle, pExtension, pContentType))
		
	
	def RemoveCustomContentType(self, Extension):
		pExtension = ctypes.c_char_p(str.encode(Extension))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_removecustomcontenttype(self._handle, pExtension))
		
	
	def SetRandomNumberCallback(self, TheCallbackFunc, UserData):
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_setrandomnumbercallback(self._handle, TheCallbackFunc, pUserData))
		
	
	def GetKeyStore(self):
		KeyStoreHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getkeystore(self._handle, KeyStoreHandle))
		if KeyStoreHandle:
			KeyStoreObject = self._wrapper._polymorphicFactory(KeyStoreHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return KeyStoreObject
	
		
