/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import java.util.Map;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NAlias;
import org.python.indexer.ast.NImport;
import org.python.indexer.ast.NModule;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NQname;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class NImportFrom
extends NNode {
    static final long serialVersionUID = 5070549408963950138L;
    public String module;
    public NQname qname;
    public List<NAlias> aliases;

    public NImportFrom(String module, NQname qname, List<NAlias> aliases) {
        this(module, qname, aliases, 0, 1);
    }

    public NImportFrom(String module, NQname qname, List<NAlias> aliases, int start, int end) {
        super(start, end);
        this.module = module;
        this.qname = qname;
        this.aliases = aliases;
        this.addChildren(qname);
        this.addChildren(aliases);
    }

    @Override
    public boolean bindsName() {
        return true;
    }

    @Override
    protected void bindNames(Scope s) throws Exception {
        if (this.isImportStar()) {
            return;
        }
        NImport.bindAliases(s, this.aliases);
    }

    @Override
    public NType resolve(Scope s) throws Exception {
        Scope scope = s.getScopeSymtab();
        NImportFrom.resolveExpr(this.qname, s);
        NType bottomType = this.qname.getBottom().getType();
        if (!bottomType.isModuleType()) {
            return this.setType(new NUnknownType());
        }
        NModuleType mt = (NModuleType)bottomType;
        this.setType(mt);
        NImport.addReferences(s, this.qname, false);
        if (this.isImportStar()) {
            this.importStar(s, mt);
            return this.getType();
        }
        for (NAlias a : this.aliases) {
            this.resolveAlias(scope, mt, a);
        }
        return this.getType();
    }

    public boolean isImportStar() {
        return this.aliases.size() == 1 && "*".equals(this.aliases.get((int)0).name);
    }

    private void resolveAlias(Scope scope, NModuleType mt, NAlias a) throws Exception {
        String mqname;
        NModuleType mt2;
        NBinding entry = mt.getTable().lookup(a.name);
        if (entry == null && (mt2 = Indexer.idx.loadModule(mqname = this.qname.toQname() + "." + a.qname.toQname())) != null) {
            entry = Indexer.idx.lookupQname(mt2.getTable().getPath());
        }
        if (entry == null) {
            this.addError(a, "name " + a.qname.getName().id + " not found in module " + this.module);
            return;
        }
        String qname = a.qname.getName().id;
        String aname = a.aname != null ? a.aname.id : null;
        Indexer.idx.putLocation(a.qname.getName(), entry);
        if (aname != null) {
            Indexer.idx.putLocation(a.aname, entry);
            scope.put(aname, entry);
        } else {
            scope.put(qname, entry);
        }
    }

    private void importStar(Scope s, NModuleType mt) throws Exception {
        if (mt == null || mt.getFile() == null) {
            return;
        }
        NModule mod2 = Indexer.idx.getAstForFile(mt.getFile());
        if (mod2 == null) {
            return;
        }
        List<String> names = mod2.getExportedNames();
        if (!names.isEmpty()) {
            for (String name : names) {
                NBinding nb = mt.getTable().lookupLocal(name);
                if (nb == null) continue;
                s.put(name, nb);
            }
        } else {
            for (Map.Entry<String, NBinding> e : mt.getTable().entrySet()) {
                if (e.getKey().startsWith("_")) continue;
                s.put(e.getKey(), e.getValue());
            }
        }
    }

    public String toString() {
        return "<FromImport:" + this.module + ":" + this.aliases + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNode(this.qname, v);
            this.visitNodeList(this.aliases, v);
        }
    }
}

