/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.listeners;

import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.transport.grpc.proto.response.document.bulk.BulkResponseProtoUtils;
import org.opensearch.transport.grpc.util.GrpcErrorHandler;

public class BulkRequestActionListener
implements ActionListener<BulkResponse> {
    private static final Logger logger = LogManager.getLogger(BulkRequestActionListener.class);
    private final StreamObserver<org.opensearch.protobufs.BulkResponse> responseObserver;

    public BulkRequestActionListener(StreamObserver<org.opensearch.protobufs.BulkResponse> responseObserver) {
        this.responseObserver = responseObserver;
    }

    public void onResponse(BulkResponse response) {
        try {
            org.opensearch.protobufs.BulkResponse protoResponse = BulkResponseProtoUtils.toProto(response);
            this.responseObserver.onNext((Object)protoResponse);
            this.responseObserver.onCompleted();
        }
        catch (IOException | RuntimeException e) {
            logger.error("Failed to convert bulk response to protobuf: " + e.getMessage());
            StatusRuntimeException grpcError = GrpcErrorHandler.convertToGrpcError(e);
            this.responseObserver.onError((Throwable)grpcError);
        }
    }

    public void onFailure(Exception e) {
        logger.error("BulkRequestActionListener failed to process bulk request: " + e.getMessage());
        StatusRuntimeException grpcError = GrpcErrorHandler.convertToGrpcError(e);
        this.responseObserver.onError((Throwable)grpcError);
    }
}

