/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.event_process;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.commons.config.PluginSettings;
import org.opensearch.performanceanalyzer.commons.event_process.Event;
import org.opensearch.performanceanalyzer.commons.event_process.EventDispatcher;

public class EventLog {
    private int metricLocPathLength;
    private static final Logger LOG = LogManager.getLogger(EventLog.class);
    private static final char startMarker = '^';
    private static final char endMarker = '$';
    private static final char[] separator = System.lineSeparator().toCharArray();
    private Ret ret;

    public EventLog() {
        if (separator.length > 1) {
            throw new IllegalStateException("separator cannot be multi-byte");
        }
        this.metricLocPathLength = Paths.get(PluginSettings.instance().getMetricsLocation(), new String[0]).toString().length();
        this.metricLocPathLength += String.valueOf(System.currentTimeMillis()).length();
        this.metricLocPathLength += 2;
    }

    public byte[] write(Event metric) {
        StringBuilder sb = new StringBuilder();
        sb.append('^').append(metric.key.substring(this.metricLocPathLength)).append(separator).append(metric.value.toCharArray()).append('$').append(separator);
        return sb.toString().getBytes();
    }

    void read(ByteBuffer byteBuffer, EventDispatcher processor) {
        if (this.ret == null) {
            this.ret = new Ret(new char[byteBuffer.limit()]);
        }
        while (byteBuffer.hasRemaining()) {
            char b = (char)byteBuffer.get();
            this.ret = EventLog.processByte(b, this.ret, processor);
        }
    }

    private static Ret processByte(char b, Ret arg, EventDispatcher processor) {
        if (b == separator[0] && arg.key.isEmpty()) {
            arg.key = new String(arg.bytes, 0, arg.byteIdx);
            arg.byteIdx = 0;
        } else if (b == '$') {
            arg.value = new String(arg.bytes, 0, arg.byteIdx);
            int indexOfFirstPathSep = arg.key.indexOf(File.separatorChar);
            if (indexOfFirstPathSep == -1) {
                String mapKey = arg.key;
            } else {
                String mapKey = arg.key.substring(0, indexOfFirstPathSep);
            }
            Event event = new Event(arg.key, arg.value, 0L);
            processor.processEvent(event);
        } else if (b == '^') {
            arg.key = "";
            arg.byteIdx = 0;
        } else {
            arg.bytes[arg.byteIdx] = b;
            ++arg.byteIdx;
            if (arg.byteIdx == arg.bytes.length) {
                char[] newBytes = new char[arg.bytes.length * 2];
                int i = 0;
                char[] cArray = arg.bytes;
                int n = cArray.length;
                for (int j = 0; j < n; ++j) {
                    char c;
                    newBytes[i] = c = cArray[j];
                    ++i;
                }
                arg.bytes = newBytes;
            }
        }
        return arg;
    }

    public void clear() {
        this.ret = null;
    }

    static class Ret {
        String key = "";
        String value = "";
        int byteIdx = 0;
        char[] bytes;

        Ret(char[] bytes) {
            this.bytes = bytes;
        }
    }
}

