import * as LSP from 'vscode-languageserver/node';
import { TextDocument } from 'vscode-languageserver-textdocument';
/**
 * The BashServer glues together the separate components to implement
 * the various parts of the Language Server Protocol.
 */
export default class BashServer {
    private analyzer;
    private clientCapabilities;
    private config;
    private connection;
    private documents;
    private executables;
    private linter?;
    private workspaceFolder;
    private uriToCodeActions;
    private constructor();
    /**
     * Initialize the server based on a connection to the client and the protocols
     * initialization parameters.
     */
    static initialize(connection: LSP.Connection, { rootPath, rootUri, capabilities }: LSP.InitializeParams): Promise<BashServer>;
    /**
     * The parts of the Language Server Protocol that we are currently supporting.
     */
    capabilities(): LSP.ServerCapabilities;
    /**
     * Register handlers for the events from the Language Server Protocol that we
     * care about.
     */
    register(connection: LSP.Connection): void;
    private startBackgroundAnalysis;
    private updateConfiguration;
    /**
     * Analyze and lint the given document.
     */
    analyzeAndLintDocument(document: TextDocument): Promise<void>;
    private logRequest;
    private getCompletionItemsForSymbols;
    private getDocumentationForSymbol;
    private onCodeAction;
    private onCompletion;
    private onCompletionResolve;
    private onDefinition;
    private onDocumentHighlight;
    private onDocumentSymbol;
    private onHover;
    private onReferences;
    private onWorkspaceSymbol;
}
export declare function getCommandOptions(name: string, word: string): string[];
