/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Implements a fast rectangular mean filter using the accumulator
approach.


This code was contributed in the Insight Journal paper: "Efficient
implementation of kernel filtering" by Beare R., Lehmann G https://doi.org/10.54294/igq8fn


Richard Beare

See:
 itk::simple::BoxMean for the procedural interface

 itk::BoxMeanImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBoxMeanImageFilter.h
*/
public class BoxMeanImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BoxMeanImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BoxMeanImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BoxMeanImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BoxMeanImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BoxMeanImageFilter::~BoxMeanImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BoxMeanImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BoxMeanImageFilter::BoxMeanImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BoxMeanImageFilter() {
    this(SimpleITKJNI.new_BoxMeanImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BoxMeanImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(VectorUInt32 Radius) {
    SimpleITKJNI.BoxMeanImageFilter_setRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(Radius), Radius);
  }

  /**
Self&amp; itk::simple::BoxMeanImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(long value) {
    SimpleITKJNI.BoxMeanImageFilter_setRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::BoxMeanImageFilter::GetRadius() const
*/
public  VectorUInt32 getRadius() {
    return new VectorUInt32(SimpleITKJNI.BoxMeanImageFilter_getRadius(swigCPtr, this), true);
  }

  /**
std::string itk::simple::BoxMeanImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BoxMeanImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BoxMeanImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BoxMeanImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BoxMeanImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BoxMeanImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
