/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Calculate the local noise in an image.


Computes an image where a given pixel is the standard deviation of the
pixels in a neighborhood about the corresponding input pixel. This
serves as an estimate of the local noise (or texture) in an image.
Currently, this noise estimate assume a piecewise constant image. This
filter should be extended to fitting a (hyper) plane to the
neighborhood and calculating the standard deviation of the residuals
to this (hyper) plane.


See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator

 itk::simple::Noise for the procedural interface

 itk::NoiseImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkNoiseImageFilter.h
*/
public class NoiseImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected NoiseImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.NoiseImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(NoiseImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(NoiseImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::NoiseImageFilter::~NoiseImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_NoiseImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::NoiseImageFilter::NoiseImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  NoiseImageFilter() {
    this(SimpleITKJNI.new_NoiseImageFilter(), true);
  }

  /**
Self&amp; itk::simple::NoiseImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(VectorUInt32 Radius) {
    SimpleITKJNI.NoiseImageFilter_setRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(Radius), Radius);
  }

  /**
Self&amp; itk::simple::NoiseImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(long value) {
    SimpleITKJNI.NoiseImageFilter_setRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::NoiseImageFilter::GetRadius() const
*/
public  VectorUInt32 getRadius() {
    return new VectorUInt32(SimpleITKJNI.NoiseImageFilter_getRadius(swigCPtr, this), true);
  }

  /**
std::string itk::simple::NoiseImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.NoiseImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::NoiseImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.NoiseImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::NoiseImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.NoiseImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
