/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.posix;

import java.io.IOException;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DataSource;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.UnmappedAddressException;

class AddressDataSource
implements DataSource {
    private Address addr;
    private long offset;

    AddressDataSource(Address addr) {
        this.addr = addr;
        this.offset = 0L;
    }

    @Override
    public byte readByte() throws IOException {
        try {
            byte res = (byte)this.addr.getCIntegerAt(this.offset, 1L, false);
            ++this.offset;
            return res;
        }
        catch (UnmappedAddressException e) {
            throw (IOException)new IOException("Unmapped address at 0x" + Long.toHexString(e.getAddress())).initCause(e);
        }
        catch (DebuggerException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    @Override
    public short readShort() throws IOException {
        int b1 = this.readByte() & 0xFF;
        int b2 = this.readByte() & 0xFF;
        return (short)(b1 << 8 | b2);
    }

    @Override
    public int readInt() throws IOException {
        int b1 = this.readByte() & 0xFF;
        int b2 = this.readByte() & 0xFF;
        int b3 = this.readByte() & 0xFF;
        int b4 = this.readByte() & 0xFF;
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }

    @Override
    public long readLong() throws IOException {
        long b1 = (long)this.readByte() & 0xFFL;
        long b2 = (long)this.readByte() & 0xFFL;
        long b3 = (long)this.readByte() & 0xFFL;
        long b4 = (long)this.readByte() & 0xFFL;
        long b5 = (long)this.readByte() & 0xFFL;
        long b6 = (long)this.readByte() & 0xFFL;
        long b7 = (long)this.readByte() & 0xFFL;
        long b8 = (long)this.readByte() & 0xFFL;
        return (b1 << 24 | b2 << 16 | b3 << 8 | b4) << 32 | (b5 << 24 | b6 << 16 | b7 << 8 | b8);
    }

    @Override
    public int read(byte[] b) throws IOException {
        for (int i = 0; i < b.length; ++i) {
            b[i] = this.readByte();
        }
        return b.length;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.offset = pos;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.offset;
    }

    @Override
    public void close() throws IOException {
    }
}

