/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.plexus.binders;

import com.google.inject.AbstractModule;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeListener;
import java.util.ArrayList;
import java.util.Collection;
import org.sonatype.guice.bean.inject.BeanBinder;
import org.sonatype.guice.bean.inject.BeanListener;
import org.sonatype.guice.plexus.binders.PlexusBeanBinder;
import org.sonatype.guice.plexus.binders.PlexusBeanManager;
import org.sonatype.guice.plexus.config.PlexusBeanModule;
import org.sonatype.guice.plexus.config.PlexusBeanSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlexusBindingModule
extends AbstractModule {
    private final PlexusBeanManager manager;
    private final PlexusBeanModule[] modules;

    public PlexusBindingModule(PlexusBeanManager manager, PlexusBeanModule ... modules) {
        this.manager = manager;
        this.modules = (PlexusBeanModule[])modules.clone();
    }

    public PlexusBindingModule(PlexusBeanManager manager, Collection<PlexusBeanModule> modules) {
        this.manager = manager;
        this.modules = modules.toArray(new PlexusBeanModule[modules.size()]);
    }

    protected void configure() {
        ArrayList<PlexusBeanSource> sources = new ArrayList<PlexusBeanSource>(this.modules.length);
        for (PlexusBeanModule module : this.modules) {
            PlexusBeanSource source = module.configure(this.binder());
            if (null == source) continue;
            sources.add(source);
        }
        this.bindListener(Matchers.any(), (TypeListener)new BeanListener((BeanBinder)new PlexusBeanBinder(this.manager, sources)));
    }
}

