/*
 * Decompiled with CFR 0.152.
 */
package javax.media.bean.playerbean;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Panel;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerListener;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;
import net.sf.fmj.utility.LoggerSingleton;

public class MediaPlayer
extends Container
implements Player,
Externalizable {
    private static final Logger logger = LoggerSingleton.logger;
    private boolean panelVisible;
    private boolean cachingVisible;
    private boolean looping;
    transient Player player;
    transient Panel panel;
    transient Panel vPanel;
    transient Panel newPanel;
    transient Component visualComponent;
    transient Component controlComponent;
    transient Component cachingComponent;
    private transient int controlPanelHeight;
    private transient int urlFieldHeight;
    protected transient GainControl gainControl;
    protected transient String curVolumeLevel;
    protected transient float curVolumeValue;
    protected transient String curZoomLevel;
    protected transient float curZoomValue;
    protected transient Time mediaTime;
    private boolean displayURL;

    @Override
    public void addController(Controller newController) throws IncompatibleTimeBaseException {
        if (this.player == null) {
            return;
        }
        this.player.addController(newController);
    }

    @Override
    public void addControllerListener(ControllerListener listener) {
        if (this.player == null) {
            return;
        }
        this.player.addControllerListener(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.player == null) {
            return;
        }
        this.player.close();
    }

    @Override
    public void deallocate() {
        if (this.player == null) {
            return;
        }
        this.player.deallocate();
    }

    @Override
    public Control getControl(String forName) {
        if (this.player == null) {
            return null;
        }
        return this.player.getControl(forName);
    }

    @Override
    public Component getControlPanelComponent() {
        if (this.player == null) {
            return null;
        }
        return this.player.getControlPanelComponent();
    }

    public int getControlPanelHeight() {
        return this.controlPanelHeight;
    }

    @Override
    public Control[] getControls() {
        if (this.player == null) {
            return new Control[0];
        }
        return this.player.getControls();
    }

    @Override
    public Time getDuration() {
        if (this.player == null) {
            return DURATION_UNKNOWN;
        }
        return this.player.getDuration();
    }

    @Override
    public GainControl getGainControl() {
        if (this.player == null) {
            return null;
        }
        return this.player.getGainControl();
    }

    public String getMediaLocation() {
        if (this.player == null) {
            return " ";
        }
        throw new UnsupportedOperationException();
    }

    public int getMediaLocationHeight() {
        return this.urlFieldHeight;
    }

    protected MediaLocator getMediaLocator(String filename) {
        return new MediaLocator("file://" + filename);
    }

    @Override
    public long getMediaNanoseconds() {
        if (this.player == null) {
            return Long.MAX_VALUE;
        }
        return this.player.getMediaNanoseconds();
    }

    @Override
    public Time getMediaTime() {
        if (this.player == null) {
            return new Time(Long.MAX_VALUE);
        }
        return this.player.getMediaTime();
    }

    public boolean getPlaybackLoop() {
        return this.looping;
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public Dimension getPreferredSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getRate() {
        if (this.player == null) {
            return 0.0f;
        }
        return this.player.getRate();
    }

    @Override
    public Time getStartLatency() {
        if (this.player == null) {
            return new Time(Long.MAX_VALUE);
        }
        return this.player.getStartLatency();
    }

    @Override
    public int getState() {
        if (this.player == null) {
            return 100;
        }
        return this.player.getState();
    }

    @Override
    public Time getStopTime() {
        if (this.player == null) {
            return null;
        }
        return this.player.getStopTime();
    }

    @Override
    public Time getSyncTime() {
        if (this.player == null) {
            return new Time(Long.MAX_VALUE);
        }
        return this.player.getSyncTime();
    }

    @Override
    public int getTargetState() {
        if (this.player == null) {
            return 100;
        }
        return this.player.getTargetState();
    }

    @Override
    public TimeBase getTimeBase() {
        if (this.player == null) {
            return null;
        }
        return this.player.getTimeBase();
    }

    @Override
    public Component getVisualComponent() {
        if (this.player == null) {
            return null;
        }
        return this.player.getVisualComponent();
    }

    public String getVolumeLevel() {
        return this.curVolumeLevel;
    }

    public String getZoomTo() {
        return this.curZoomLevel;
    }

    public boolean isCachingControlVisible() {
        return this.cachingVisible;
    }

    public boolean isControlPanelVisible() {
        return this.panelVisible;
    }

    public boolean isFixedAspectRatio() {
        throw new UnsupportedOperationException();
    }

    public boolean isMediaLocationVisible() {
        return this.displayURL;
    }

    public boolean isPlayBackLoop() {
        return this.looping;
    }

    @Override
    public Time mapToTimeBase(Time t) throws ClockStoppedException {
        if (this.player == null) {
            return new Time(Long.MAX_VALUE);
        }
        return this.player.mapToTimeBase(t);
    }

    @Override
    public void prefetch() {
        if (this.player == null) {
            return;
        }
        this.player.prefetch();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void realize() {
        if (this.player == null) {
            return;
        }
        this.player.realize();
    }

    @Override
    public void removeController(Controller oldController) {
        if (this.player == null) {
            return;
        }
        this.player.removeController(oldController);
    }

    @Override
    public void removeControllerListener(ControllerListener listener) {
        if (this.player == null) {
            return;
        }
        this.player.removeControllerListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener c) {
        throw new UnsupportedOperationException();
    }

    public void restoreMediaTime() {
        throw new UnsupportedOperationException();
    }

    public void saveMediaTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        throw new UnsupportedOperationException();
    }

    public void setCachingControlVisible(boolean isVisible) {
        this.cachingVisible = isVisible;
    }

    public void setCodeBase(URL cb) {
    }

    public void setControlPanelVisible(boolean isVisible) {
        this.panelVisible = isVisible;
    }

    public void setDataSource(DataSource ds) {
        try {
            this.player = Manager.createPlayer(ds);
        }
        catch (NoPlayerException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
    }

    public void setFixedAspectRatio(boolean isFixed) {
        throw new UnsupportedOperationException();
    }

    public void setMediaLocation(String location) {
        throw new UnsupportedOperationException();
    }

    public void setMediaLocationVisible(boolean val) {
        this.displayURL = val;
    }

    public void setMediaLocator(MediaLocator locator) {
        try {
            this.player = Manager.createPlayer(locator);
        }
        catch (NoPlayerException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
    }

    @Override
    public void setMediaTime(Time now) {
        if (this.player == null) {
            return;
        }
        this.player.setMediaTime(now);
    }

    public void setPlaybackLoop(boolean val) {
        this.looping = val;
    }

    public void setPlayer(Player newPlayer) {
        this.player = newPlayer;
    }

    public void setPopupActive(boolean isActive) {
    }

    @Override
    public float setRate(float factor) {
        if (this.player == null) {
            return 0.0f;
        }
        return this.player.setRate(factor);
    }

    @Override
    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (this.player == null) {
            return;
        }
        this.player.setSource(source);
    }

    @Override
    public void setStopTime(Time stopTime) {
        if (this.player == null) {
            return;
        }
        this.player.setStopTime(stopTime);
    }

    @Override
    public void setTimeBase(TimeBase master) throws IncompatibleTimeBaseException {
        if (this.player == null) {
            return;
        }
        this.player.setTimeBase(master);
    }

    public void setVolumeLevel(String volumeString) {
        this.curVolumeLevel = volumeString;
    }

    public void setZoomTo(String scale) {
        this.curZoomLevel = scale;
    }

    @Override
    public void start() {
        if (this.player == null) {
            return;
        }
        this.player.start();
    }

    @Override
    public void stop() {
        if (this.player == null) {
            return;
        }
        this.player.stop();
    }

    public void stopAndDeallocate() {
        this.stop();
        this.deallocate();
    }

    @Override
    public void syncStart(Time at) {
        if (this.player == null) {
            return;
        }
        this.player.syncStart(at);
    }

    public synchronized void waitForState(int s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }
}

