/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.sipaccregwizz;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.TrimTextField;
import net.java.sip.communicator.plugin.sipaccregwizz.Resources;
import net.java.sip.communicator.plugin.sipaccregwizz.SIPAccRegWizzActivator;
import net.java.sip.communicator.plugin.sipaccregwizz.SIPAccountCreationFormService;
import net.java.sip.communicator.plugin.sipaccregwizz.SIPAccountRegistrationForm;
import net.java.sip.communicator.plugin.sipaccregwizz.ValidatingPanel;
import net.java.sip.communicator.util.Logger;

public class AccountPanel
extends TransparentPanel
implements DocumentListener,
ValidatingPanel {
    private static final long serialVersionUID = 0L;
    private final Logger logger = Logger.getLogger(AccountPanel.class);
    private final JPanel labelsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
    private final JPanel valuesPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
    private final JPanel emptyPanel = new TransparentPanel();
    private final JTextField userIDField = new TrimTextField();
    private final JPasswordField passField = new JPasswordField();
    private final JTextField displayNameField = new JTextField();
    private final JCheckBox rememberPassBox = new SIPCommCheckBox(Resources.getString("service.gui.REMEMBER_PASSWORD"));
    private final JLabel displayNameLabel = new JLabel(Resources.getString("plugin.sipaccregwizz.DISPLAY_NAME"));
    private final JRadioButton existingAccountButton;
    private final JRadioButton createAccountButton;
    private final JPanel uinPassPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private final JPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
    private final SIPAccountRegistrationForm regform;
    private Component registrationForm;
    private boolean isSimpleForm;
    private Component registerChoicePanel;

    public AccountPanel(SIPAccountRegistrationForm regform) {
        super((LayoutManager)new BorderLayout());
        this.regform = regform;
        this.regform.addValidatingPanel(this);
        this.userIDField.getDocument().addDocumentListener(this);
        this.rememberPassBox.setSelected(true);
        this.existingAccountButton = new JRadioButton(regform.getExistingAccountLabel());
        this.createAccountButton = new JRadioButton(regform.getCreateAccountLabel());
        JLabel uinExampleLabel = new JLabel(regform.getUsernameExample());
        uinExampleLabel.setForeground(Color.GRAY);
        uinExampleLabel.setFont(uinExampleLabel.getFont().deriveFont(8));
        this.emptyPanel.setMaximumSize(new Dimension(40, 35));
        uinExampleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        JLabel uinLabel = new JLabel(regform.getUsernameLabel());
        JLabel passLabel = new JLabel(Resources.getString("service.gui.PASSWORD"));
        this.labelsPanel.add(uinLabel);
        this.labelsPanel.add(this.emptyPanel);
        this.labelsPanel.add(passLabel);
        this.valuesPanel.add(this.userIDField);
        this.valuesPanel.add(uinExampleLabel);
        this.valuesPanel.add(this.passField);
        TransparentPanel southPanel = new TransparentPanel((LayoutManager)new GridLayout(1, 2));
        this.uinPassPanel.add((Component)this.labelsPanel, "West");
        this.uinPassPanel.add((Component)this.valuesPanel, "Center");
        this.uinPassPanel.add((Component)southPanel, "South");
        southPanel.add((Component)this.rememberPassBox);
        String webSignupLinkText = regform.getWebSignupLinkName();
        if (webSignupLinkText != null && webSignupLinkText.length() > 0) {
            southPanel.add(this.createWebSignupLabel(webSignupLinkText));
        } else {
            String forgotPassLinkText = regform.getForgotPasswordLinkName();
            if (forgotPassLinkText != null && forgotPassLinkText.length() > 0) {
                southPanel.add(this.createForgotPasswordLabel(forgotPassLinkText));
            }
        }
        this.uinPassPanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.sipaccregwizz.USERNAME_AND_PASSWORD")));
        SIPAccountCreationFormService createAccountService = regform.getCreateAccountService();
        if (createAccountService != null && this.isSimpleForm) {
            this.registrationForm = createAccountService.getForm();
            this.registerChoicePanel = this.createRegisterChoicePanel();
            this.mainPanel.add(this.registerChoicePanel, "North");
        } else {
            this.mainPanel.add((Component)this.uinPassPanel, "North");
        }
        this.add(this.mainPanel, "North");
    }

    void initAdvancedForm() {
        if (this.displayNameLabel.getParent() == null) {
            this.labelsPanel.add(this.displayNameLabel);
        }
        if (this.displayNameField.getParent() == null) {
            this.valuesPanel.add(this.displayNameField);
        }
        this.existingAccountButton.setSelected(true);
        this.setSimpleForm(false);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.regform.setServerFieldAccordingToUIN(this.userIDField.getText());
        this.regform.reValidateInput();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.regform.setServerFieldAccordingToUIN(this.userIDField.getText());
        this.regform.reValidateInput();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    String getUserID() {
        String userID = this.userIDField.getText();
        if (userID.startsWith("sip:")) {
            return userID.substring(4);
        }
        return userID;
    }

    char[] getPassword() {
        return this.passField.getPassword();
    }

    boolean isRememberPassword() {
        return this.rememberPassBox.isSelected();
    }

    String getDisplayName() {
        return this.displayNameField.getText();
    }

    void setDisplayName(String displayName) {
        this.displayNameField.setText(displayName);
    }

    void setUserIDEnabled(boolean isEnabled) {
        this.userIDField.setEnabled(isEnabled);
    }

    void setUserID(String userID) {
        this.userIDField.setText(userID);
        this.regform.reValidateInput();
    }

    void setPassword(String password) {
        this.passField.setText(password);
    }

    void setRememberPassword(boolean isRememberPassword) {
        this.rememberPassBox.setSelected(isRememberPassword);
    }

    private Component createWebSignupLabel(String linkName) {
        JLabel subscribeLabel = new JLabel("<html><a href=''>" + linkName + "</a></html>", 4);
        subscribeLabel.setCursor(new Cursor(12));
        subscribeLabel.setToolTipText(Resources.getString("plugin.simpleaccregwizz.SPECIAL_SIGNUP"));
        subscribeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                try {
                    AccountPanel.this.regform.webSignup();
                }
                catch (UnsupportedOperationException ex) {
                    AccountPanel.this.logger.error((Object)"The web sign up is not supported.", (Throwable)ex);
                }
            }
        });
        return subscribeLabel;
    }

    private Component createForgotPasswordLabel(String linkName) {
        JLabel subscribeLabel = new JLabel("<html><a href=''>" + linkName + "</a></html>", 4);
        subscribeLabel.setCursor(new Cursor(12));
        subscribeLabel.setToolTipText(Resources.getString("plugin.simpleaccregwizz.FORGOT_PASSWORD"));
        subscribeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                try {
                    SIPAccRegWizzActivator.getBrowserLauncher().openURL(AccountPanel.this.regform.getForgotPasswordLink());
                }
                catch (UnsupportedOperationException ex) {
                    AccountPanel.this.logger.error((Object)"The web sign up is not supported.", (Throwable)ex);
                }
            }
        });
        return subscribeLabel;
    }

    private Component createRegisterChoicePanel() {
        TransparentPanel registerChoicePanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
        this.existingAccountButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AccountPanel.this.existingAccountButton.isSelected()) {
                    AccountPanel.this.mainPanel.remove(AccountPanel.this.registrationForm);
                    AccountPanel.this.mainPanel.add((Component)AccountPanel.this.uinPassPanel, "Center");
                    Window window = SwingUtilities.getWindowAncestor((Component)((Object)AccountPanel.this));
                    if (window != null) {
                        window.pack();
                    }
                }
            }
        });
        this.createAccountButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AccountPanel.this.createAccountButton.isSelected()) {
                    AccountPanel.this.mainPanel.remove(AccountPanel.this.uinPassPanel);
                    AccountPanel.this.mainPanel.add(AccountPanel.this.registrationForm, "Center");
                    SwingUtilities.getWindowAncestor((Component)((Object)AccountPanel.this)).pack();
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        this.existingAccountButton.setOpaque(false);
        this.createAccountButton.setOpaque(false);
        buttonGroup.add(this.existingAccountButton);
        buttonGroup.add(this.createAccountButton);
        registerChoicePanel.add(this.existingAccountButton);
        registerChoicePanel.add(this.createAccountButton);
        this.existingAccountButton.setSelected(true);
        return registerChoicePanel;
    }

    boolean isCreateAccount() {
        return this.createAccountButton.isSelected();
    }

    @Override
    public boolean isValidated() {
        return this.userIDField.getText() != null && this.userIDField.getText().length() > 0;
    }

    void setSimpleForm(boolean isSimpleForm) {
        this.isSimpleForm = isSimpleForm;
        SIPAccountCreationFormService createAccountService = this.regform.getCreateAccountService();
        if (createAccountService != null && isSimpleForm) {
            this.registrationForm = createAccountService.getForm();
            if (this.uinPassPanel != null) {
                this.mainPanel.remove(this.uinPassPanel);
            }
            this.registerChoicePanel = this.createRegisterChoicePanel();
            this.mainPanel.add(this.registerChoicePanel, "North");
        } else {
            if (this.registerChoicePanel != null) {
                this.mainPanel.remove(this.registerChoicePanel);
            }
            this.mainPanel.add((Component)this.uinPassPanel, "North");
        }
    }

    boolean isSimpleForm() {
        return this.isSimpleForm;
    }

    void setCreateButtonSelected() {
        this.createAccountButton.setSelected(true);
    }
}

