/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.history;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Vector;
import net.java.sip.communicator.service.history.HistoryQuery;
import net.java.sip.communicator.service.history.event.HistoryQueryListener;
import net.java.sip.communicator.service.history.event.HistoryQueryStatusEvent;
import net.java.sip.communicator.service.history.event.HistoryRecordEvent;
import net.java.sip.communicator.service.history.records.HistoryRecord;

public class HistoryQueryImpl
implements HistoryQuery {
    private final Collection<HistoryQueryListener> queryListeners = new LinkedList<HistoryQueryListener>();
    private final Collection<HistoryRecord> historyRecords = new Vector<HistoryRecord>();
    private boolean isCanceled = false;
    private final String queryString;

    public HistoryQueryImpl(String queryString) {
        this.queryString = queryString;
    }

    @Override
    public void cancel() {
        this.isCanceled = true;
    }

    boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public Collection<HistoryRecord> getHistoryRecords() {
        return new Vector<HistoryRecord>(this.historyRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHistoryRecordsListener(HistoryQueryListener l) {
        Collection<HistoryQueryListener> collection = this.queryListeners;
        synchronized (collection) {
            this.queryListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHistoryRecordsListener(HistoryQueryListener l) {
        Collection<HistoryQueryListener> collection = this.queryListeners;
        synchronized (collection) {
            this.queryListeners.remove(l);
        }
    }

    void addHistoryRecord(HistoryRecord record) {
        this.historyRecords.add(record);
        this.fireQueryEvent(record);
    }

    void setStatus(int queryStatus) {
        this.fireQueryStatusEvent(queryStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueryEvent(HistoryRecord record) {
        HistoryRecordEvent event = new HistoryRecordEvent(this, record);
        Collection<HistoryQueryListener> collection = this.queryListeners;
        synchronized (collection) {
            for (HistoryQueryListener l : this.queryListeners) {
                l.historyRecordReceived(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueryStatusEvent(int newStatus) {
        HistoryQueryStatusEvent event = new HistoryQueryStatusEvent(this, newStatus);
        Collection<HistoryQueryListener> collection = this.queryListeners;
        synchronized (collection) {
            for (HistoryQueryListener l : this.queryListeners) {
                l.queryStatusChanged(event);
            }
        }
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }
}

