/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.awt.Dimension;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.device.DeviceConfiguration;
import org.jitsi.service.neomedia.QualityControl;
import org.jitsi.service.neomedia.QualityPreset;
import org.jitsi.util.Logger;

class QualityControlImpl
implements QualityControl {
    private static final Logger logger = Logger.getLogger(QualityControlImpl.class);
    private QualityPreset localSettingsPreset;
    private QualityPreset maxPreset;
    private QualityPreset preset;

    QualityControlImpl() {
    }

    private void setRemoteReceivePreset(QualityPreset preset) {
        QualityPreset preferredSendPreset = this.getPreferredSendPreset();
        if (preset.compareTo(preferredSendPreset) > 0) {
            this.preset = preferredSendPreset;
        } else {
            Dimension resolution;
            this.preset = preset;
            if (logger.isInfoEnabled() && preset != null && (resolution = preset.getResolution()) != null) {
                logger.info("video send resolution: " + resolution.width + "x" + resolution.height);
            }
        }
    }

    @Override
    public QualityPreset getRemoteReceivePreset() {
        return this.preset;
    }

    @Override
    public QualityPreset getRemoteSendMinPreset() {
        return null;
    }

    @Override
    public QualityPreset getRemoteSendMaxPreset() {
        return this.maxPreset;
    }

    @Override
    public void setPreferredRemoteSendMaxPreset(QualityPreset preset) {
        this.setRemoteSendMaxPreset(preset);
    }

    @Override
    public void setRemoteSendMaxPreset(QualityPreset preset) {
        this.maxPreset = preset;
    }

    private QualityPreset getPreferredSendPreset() {
        if (this.localSettingsPreset == null) {
            DeviceConfiguration devCfg = NeomediaServiceUtils.getMediaServiceImpl().getDeviceConfiguration();
            this.localSettingsPreset = new QualityPreset(devCfg.getVideoSize(), devCfg.getFrameRate());
        }
        return this.localSettingsPreset;
    }

    public void setRemoteReceiveResolution(Dimension res) {
        this.setRemoteReceivePreset(new QualityPreset(res));
    }
}

