/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.otr;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.security.PublicKey;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import net.java.otr4j.OtrPolicy;
import net.java.sip.communicator.plugin.desktoputil.AnimatedImage;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.plugin.otr.OtrActivator;
import net.java.sip.communicator.plugin.otr.OtrContactManager;
import net.java.sip.communicator.plugin.otr.OtrWeakListener;
import net.java.sip.communicator.plugin.otr.ScOtrEngineListener;
import net.java.sip.communicator.plugin.otr.ScOtrKeyManagerListener;
import net.java.sip.communicator.plugin.otr.ScSessionStatus;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.gui.AbstractPluginComponent;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.util.Logger;

public class OtrMetaContactButton
extends AbstractPluginComponent
implements ScOtrEngineListener,
ScOtrKeyManagerListener {
    private final Logger logger = Logger.getLogger(OtrMetaContactButton.class);
    private SIPCommButton button;
    private OtrContactManager.OtrContact otrContact;
    private AnimatedImage animatedPadlockImage;
    private Image finishedPadlockImage;
    private Image verifiedLockedPadlockImage;
    private Image unverifiedLockedPadlockImage;
    private Image unlockedPadlockImage;
    private Image timedoutPadlockImage;

    @Override
    public void sessionStatusChanged(OtrContactManager.OtrContact otrContact) {
        if (otrContact.equals(this.otrContact)) {
            this.setStatus(OtrActivator.scOtrEngine.getSessionStatus(otrContact));
        }
    }

    @Override
    public void contactPolicyChanged(Contact contact) {
        if (this.otrContact != null && contact.equals(this.otrContact.contact)) {
            this.setPolicy(OtrActivator.scOtrEngine.getContactPolicy(contact));
        }
    }

    @Override
    public void globalPolicyChanged() {
        if (this.otrContact != null) {
            this.setPolicy(OtrActivator.scOtrEngine.getContactPolicy(this.otrContact.contact));
        }
    }

    @Override
    public void contactVerificationStatusChanged(OtrContactManager.OtrContact otrContact) {
        if (otrContact.equals(this.otrContact)) {
            this.setStatus(OtrActivator.scOtrEngine.getSessionStatus(otrContact));
        }
    }

    public OtrMetaContactButton(Container container, PluginComponentFactory parentFactory) {
        super(container, parentFactory);
        new OtrWeakListener<OtrMetaContactButton>(this, OtrActivator.scOtrEngine, OtrActivator.scOtrKeyManager);
    }

    private SIPCommButton getButton() {
        if (this.button == null) {
            this.button = new SIPCommButton(null, null);
            this.button.setEnabled(false);
            this.button.setPreferredSize(new Dimension(25, 25));
            this.button.setToolTipText(OtrActivator.resourceService.getI18NString("plugin.otr.menu.OTR_TOOLTIP"));
            BufferedImage i1 = null;
            BufferedImage i2 = null;
            BufferedImage i3 = null;
            try {
                i1 = ImageIO.read(OtrActivator.resourceService.getImageURL("plugin.otr.LOADING_ICON1_22x22"));
                i2 = ImageIO.read(OtrActivator.resourceService.getImageURL("plugin.otr.LOADING_ICON2_22x22"));
                i3 = ImageIO.read(OtrActivator.resourceService.getImageURL("plugin.otr.LOADING_ICON3_22x22"));
                this.finishedPadlockImage = ImageIO.read(OtrActivator.resourceService.getImageURL("plugin.otr.FINISHED_ICON_22x22"));
                this.verifiedLockedPadlockImage = ImageIO.read(OtrActivator.resourceService.getImageURL("plugin.otr.ENCRYPTED_ICON_22x22"));
                this.unverifiedLockedPadlockImage = ImageIO.read(OtrActivator.resourceService.getImageURL("plugin.otr.ENCRYPTED_UNVERIFIED_ICON_22x22"));
                this.unlockedPadlockImage = ImageIO.read(OtrActivator.resourceService.getImageURL("plugin.otr.PLAINTEXT_ICON_22x22"));
                this.timedoutPadlockImage = ImageIO.read(OtrActivator.resourceService.getImageURL("plugin.otr.BROKEN_ICON_22x22"));
            }
            catch (IOException e) {
                this.logger.debug((Object)"Failed to load padlock image");
            }
            this.animatedPadlockImage = new AnimatedImage((JComponent)this.button, new Image[]{i1, i2, i3});
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (OtrMetaContactButton.this.otrContact == null) {
                        return;
                    }
                    switch (OtrActivator.scOtrEngine.getSessionStatus(OtrMetaContactButton.this.otrContact)) {
                        case ENCRYPTED: {
                            OtrPolicy policy = OtrActivator.scOtrEngine.getContactPolicy(((OtrMetaContactButton)OtrMetaContactButton.this).otrContact.contact);
                            policy.setSendWhitespaceTag(false);
                            OtrActivator.scOtrEngine.setContactPolicy(((OtrMetaContactButton)OtrMetaContactButton.this).otrContact.contact, policy);
                        }
                        case FINISHED: 
                        case LOADING: {
                            OtrActivator.scOtrEngine.endSession(OtrMetaContactButton.this.otrContact);
                            break;
                        }
                        case TIMED_OUT: 
                        case PLAINTEXT: {
                            OtrPolicy policy = OtrActivator.scOtrEngine.getContactPolicy(((OtrMetaContactButton)OtrMetaContactButton.this).otrContact.contact);
                            OtrPolicy globalPolicy = OtrActivator.scOtrEngine.getGlobalPolicy();
                            policy.setSendWhitespaceTag(globalPolicy.getSendWhitespaceTag());
                            OtrActivator.scOtrEngine.setContactPolicy(((OtrMetaContactButton)OtrMetaContactButton.this).otrContact.contact, policy);
                            OtrActivator.scOtrEngine.startSession(OtrMetaContactButton.this.otrContact);
                        }
                    }
                }
            });
        }
        return this.button;
    }

    public Object getComponent() {
        return this.getButton();
    }

    public String getName() {
        return "";
    }

    public void setCurrentContact(Contact contact) {
        this.setCurrentContact(contact, null);
    }

    public void setCurrentContact(Contact contact, String resourceName) {
        if (contact == null) {
            this.otrContact = null;
            this.setPolicy(null);
            this.setStatus(ScSessionStatus.PLAINTEXT);
            return;
        }
        if (resourceName == null) {
            OtrContactManager.OtrContact otrContact = OtrContactManager.getOtrContact(contact, null);
            if (this.otrContact == otrContact) {
                return;
            }
            this.otrContact = otrContact;
            this.setStatus(OtrActivator.scOtrEngine.getSessionStatus(otrContact));
            this.setPolicy(OtrActivator.scOtrEngine.getContactPolicy(contact));
            return;
        }
        for (ContactResource resource : contact.getResources()) {
            if (!resource.getResourceName().equals(resourceName)) continue;
            OtrContactManager.OtrContact otrContact = OtrContactManager.getOtrContact(contact, resource);
            if (this.otrContact == otrContact) {
                return;
            }
            this.otrContact = otrContact;
            this.setStatus(OtrActivator.scOtrEngine.getSessionStatus(otrContact));
            this.setPolicy(OtrActivator.scOtrEngine.getContactPolicy(contact));
            return;
        }
        this.logger.debug((Object)("Could not find resource for contact " + contact));
    }

    public void setCurrentContact(MetaContact metaContact) {
        this.setCurrentContact(metaContact == null ? null : metaContact.getDefaultContact());
    }

    private void setPolicy(OtrPolicy contactPolicy) {
        this.getButton().setEnabled(contactPolicy != null && contactPolicy.getEnableManual());
    }

    private void setStatus(ScSessionStatus status) {
        String tipKey;
        Image image;
        this.animatedPadlockImage.pause();
        switch (status) {
            case ENCRYPTED: {
                PublicKey pubKey = OtrActivator.scOtrEngine.getRemotePublicKey(this.otrContact);
                String fingerprint = OtrActivator.scOtrKeyManager.getFingerprintFromPublicKey(pubKey);
                image = OtrActivator.scOtrKeyManager.isVerified(this.otrContact.contact, fingerprint) ? this.verifiedLockedPadlockImage : this.unverifiedLockedPadlockImage;
                tipKey = OtrActivator.scOtrKeyManager.isVerified(this.otrContact.contact, fingerprint) ? "plugin.otr.menu.VERIFIED" : "plugin.otr.menu.UNVERIFIED";
                break;
            }
            case FINISHED: {
                image = this.finishedPadlockImage;
                tipKey = "plugin.otr.menu.FINISHED";
                break;
            }
            case PLAINTEXT: {
                image = this.unlockedPadlockImage;
                tipKey = "plugin.otr.menu.START_OTR";
                break;
            }
            case LOADING: {
                image = this.animatedPadlockImage;
                this.animatedPadlockImage.start();
                tipKey = "plugin.otr.menu.LOADING_OTR";
                break;
            }
            case TIMED_OUT: {
                image = this.timedoutPadlockImage;
                tipKey = "plugin.otr.menu.TIMED_OUT";
                break;
            }
            default: {
                return;
            }
        }
        SIPCommButton button = this.getButton();
        button.setIconImage(image);
        button.setToolTipText(OtrActivator.resourceService.getI18NString(tipKey));
        button.repaint();
    }

    @Override
    public void multipleInstancesDetected(OtrContactManager.OtrContact contact) {
    }

    @Override
    public void outgoingSessionChanged(OtrContactManager.OtrContact otrContact) {
        if (otrContact.equals(this.otrContact)) {
            this.setStatus(OtrActivator.scOtrEngine.getSessionStatus(otrContact));
        }
    }
}

