/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.pluginmanager;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import net.java.sip.communicator.plugin.pluginmanager.PluginManagerPanel;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.LazyConfigurationForm;
import net.java.sip.communicator.service.gui.UIService;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class PluginManagerActivator
implements BundleActivator {
    public static BundleContext bundleContext;
    private static UIService uiService;
    private static ConfigurationService configService;
    private static final String DISABLED_PROP = "net.java.sip.communicator.plugin.pluginconfig.DISABLED";
    private static final String SYSTEM_BUNDLES_PROP = "net.java.sip.communicator.plugin.pluginmanager.SYSTEM_BUNDLES";
    private static List<String> systemBundleNames;

    public void start(BundleContext bc) throws Exception {
        bundleContext = bc;
        if (!PluginManagerActivator.getConfigurationService().getBoolean(DISABLED_PROP, false)) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("FORM_TYPE", "ADVANCED_TYPE");
            bundleContext.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm(PluginManagerPanel.class.getName(), this.getClass().getClassLoader(), "plugin.pluginmanager.PLUGIN_ICON", "plugin.pluginmanager.PLUGINS", 1000, true), properties);
        }
        systemBundleNames = Arrays.asList(PluginManagerActivator.getConfigurationService().getString(SYSTEM_BUNDLES_PROP).split("\\s*,\\s*"));
    }

    public void stop(BundleContext bc) throws Exception {
    }

    public static UIService getUIService() {
        if (uiService == null) {
            ServiceReference uiReference = bundleContext.getServiceReference(UIService.class.getName());
            uiService = (UIService)bundleContext.getService(uiReference);
        }
        return uiService;
    }

    public static ConfigurationService getConfigurationService() {
        if (configService == null) {
            ServiceReference configReference = bundleContext.getServiceReference(ConfigurationService.class.getName());
            configService = (ConfigurationService)bundleContext.getService(configReference);
        }
        return configService;
    }

    public static boolean isSystemBundle(Bundle bundle) {
        if (bundle.getBundleId() <= 1L) {
            return true;
        }
        return systemBundleNames.contains(bundle.getSymbolicName());
    }
}

