/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.AsYouTypeFormatter;
import com.google.i18n.phonenumbers.CountryCodeToRegionCodeMap;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberMatch;
import com.google.i18n.phonenumbers.PhoneNumberMatcher;
import com.google.i18n.phonenumbers.Phonemetadata;
import com.google.i18n.phonenumbers.Phonenumber;
import com.google.i18n.phonenumbers.RegexCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhoneNumberUtil {
    private static final Logger logger = Logger.getLogger(PhoneNumberUtil.class.getName());
    static final int REGEX_FLAGS = 66;
    private static final int MIN_LENGTH_FOR_NSN = 2;
    static final int MAX_LENGTH_FOR_NSN = 16;
    static final int MAX_LENGTH_COUNTRY_CODE = 3;
    private static final int MAX_INPUT_STRING_LENGTH = 250;
    static final String META_DATA_FILE_PREFIX = "/com/google/i18n/phonenumbers/data/PhoneNumberMetadataProto";
    private static final String UNKNOWN_REGION = "ZZ";
    private static final int NANPA_COUNTRY_CODE = 1;
    private static final String COLOMBIA_MOBILE_TO_FIXED_LINE_PREFIX = "3";
    private static final Map<Integer, String> MOBILE_TOKEN_MAPPINGS;
    static final char PLUS_SIGN = '+';
    private static final char STAR_SIGN = '*';
    private static final String RFC3966_EXTN_PREFIX = ";ext=";
    private static final String RFC3966_PREFIX = "tel:";
    private static final String RFC3966_PHONE_CONTEXT = ";phone-context=";
    private static final String RFC3966_ISDN_SUBADDRESS = ";isub=";
    private static final Map<Character, Character> DIALLABLE_CHAR_MAPPINGS;
    private static final Map<Character, Character> ALPHA_MAPPINGS;
    private static final Map<Character, Character> ALPHA_PHONE_MAPPINGS;
    private static final Map<Character, Character> ALL_PLUS_NUMBER_GROUPING_SYMBOLS;
    private static final Pattern UNIQUE_INTERNATIONAL_PREFIX;
    static final String VALID_PUNCTUATION = "-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u00ad\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e";
    private static final String DIGITS = "\\p{Nd}";
    private static final String VALID_ALPHA;
    static final String PLUS_CHARS = "+\uff0b";
    static final Pattern PLUS_CHARS_PATTERN;
    private static final Pattern SEPARATOR_PATTERN;
    private static final Pattern CAPTURING_DIGIT_PATTERN;
    private static final String VALID_START_CHAR = "[+\uff0b\\p{Nd}]";
    private static final Pattern VALID_START_CHAR_PATTERN;
    private static final String SECOND_NUMBER_START = "[\\\\/] *x";
    static final Pattern SECOND_NUMBER_START_PATTERN;
    private static final String UNWANTED_END_CHARS = "[[\\P{N}&&\\P{L}]&&[^#]]+$";
    static final Pattern UNWANTED_END_CHAR_PATTERN;
    private static final Pattern VALID_ALPHA_PHONE_PATTERN;
    private static final String VALID_PHONE_NUMBER;
    private static final String DEFAULT_EXTN_PREFIX = " ext. ";
    private static final String CAPTURING_EXTN_DIGITS = "(\\p{Nd}{1,7})";
    private static final String EXTN_PATTERNS_FOR_PARSING;
    static final String EXTN_PATTERNS_FOR_MATCHING;
    private static final Pattern EXTN_PATTERN;
    private static final Pattern VALID_PHONE_NUMBER_PATTERN;
    static final Pattern NON_DIGITS_PATTERN;
    private static final Pattern FIRST_GROUP_PATTERN;
    private static final Pattern NP_PATTERN;
    private static final Pattern FG_PATTERN;
    private static final Pattern CC_PATTERN;
    private static final Pattern FIRST_GROUP_ONLY_PREFIX_PATTERN;
    private static PhoneNumberUtil instance;
    public static final String REGION_CODE_FOR_NON_GEO_ENTITY = "001";
    private final Map<Integer, List<String>> countryCallingCodeToRegionCodeMap;
    private final Set<String> nanpaRegions = new HashSet<String>(35);
    private final Map<String, Phonemetadata.PhoneMetadata> regionToMetadataMap = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, Phonemetadata.PhoneMetadata> countryCodeToNonGeographicalMetadataMap = Collections.synchronizedMap(new HashMap());
    private final RegexCache regexCache = new RegexCache(100);
    private final Set<String> supportedRegions = new HashSet<String>(320);
    private final Set<Integer> countryCodesForNonGeographicalRegion = new HashSet<Integer>();
    private final String currentFilePrefix;

    private static String createExtnPattern(String singleExtnSymbols) {
        return ";ext=(\\p{Nd}{1,7})|[ \u00a0\\t,]*(?:e?xt(?:ensi(?:o\u0301?|\u00f3))?n?|\uff45?\uff58\uff54\uff4e?|[" + singleExtnSymbols + "]|int|anexo|\uff49\uff4e\uff54)" + "[:\\.\uff0e]?[ \u00a0\\t,-]*" + CAPTURING_EXTN_DIGITS + "#?|" + "[- ]+(" + DIGITS + "{1,5})#";
    }

    private PhoneNumberUtil(String filePrefix, Map<Integer, List<String>> countryCallingCodeToRegionCodeMap) {
        this.currentFilePrefix = filePrefix;
        this.countryCallingCodeToRegionCodeMap = countryCallingCodeToRegionCodeMap;
        for (Map.Entry<Integer, List<String>> entry : countryCallingCodeToRegionCodeMap.entrySet()) {
            List<String> regionCodes = entry.getValue();
            if (regionCodes.size() == 1 && REGION_CODE_FOR_NON_GEO_ENTITY.equals(regionCodes.get(0))) {
                this.countryCodesForNonGeographicalRegion.add(entry.getKey());
                continue;
            }
            this.supportedRegions.addAll(regionCodes);
        }
        if (this.supportedRegions.remove(REGION_CODE_FOR_NON_GEO_ENTITY)) {
            logger.log(Level.WARNING, "invalid metadata (country calling code was mapped to the non-geo entity as well as specific region(s))");
        }
        this.nanpaRegions.addAll((Collection<String>)countryCallingCodeToRegionCodeMap.get(1));
    }

    void loadMetadataFromFile(String filePrefix, String regionCode, int countryCallingCode) {
        boolean isNonGeoRegion = REGION_CODE_FOR_NON_GEO_ENTITY.equals(regionCode);
        String fileName = filePrefix + "_" + (isNonGeoRegion ? String.valueOf(countryCallingCode) : regionCode);
        InputStream source = PhoneNumberUtil.class.getResourceAsStream(fileName);
        if (source == null) {
            logger.log(Level.SEVERE, "missing metadata: " + fileName);
            throw new IllegalStateException("missing metadata: " + fileName);
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(source);
            Phonemetadata.PhoneMetadataCollection metadataCollection = PhoneNumberUtil.loadMetadataAndCloseInput(in);
            List<Phonemetadata.PhoneMetadata> metadataList = metadataCollection.getMetadataList();
            if (metadataList.isEmpty()) {
                logger.log(Level.SEVERE, "empty metadata: " + fileName);
                throw new IllegalStateException("empty metadata: " + fileName);
            }
            if (metadataList.size() > 1) {
                logger.log(Level.WARNING, "invalid metadata (too many entries): " + fileName);
            }
            Phonemetadata.PhoneMetadata metadata = metadataList.get(0);
            if (isNonGeoRegion) {
                this.countryCodeToNonGeographicalMetadataMap.put(countryCallingCode, metadata);
            } else {
                this.regionToMetadataMap.put(regionCode, metadata);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "cannot load/parse metadata: " + fileName, e);
            throw new RuntimeException("cannot load/parse metadata: " + fileName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Phonemetadata.PhoneMetadataCollection loadMetadataAndCloseInput(ObjectInput source) {
        Phonemetadata.PhoneMetadataCollection metadataCollection = new Phonemetadata.PhoneMetadataCollection();
        try {
            metadataCollection.readExternal(source);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "error reading input (ignored)", e);
        }
        finally {
            try {
                try {
                    source.close();
                    return metadataCollection;
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "error closing input stream (ignored)", e);
                    return metadataCollection;
                }
            }
            catch (Throwable throwable) {
                return metadataCollection;
            }
        }
    }

    static String extractPossibleNumber(String number) {
        Matcher m = VALID_START_CHAR_PATTERN.matcher(number);
        if (m.find()) {
            Matcher secondNumber;
            Matcher trailingCharsMatcher = UNWANTED_END_CHAR_PATTERN.matcher(number = number.substring(m.start()));
            if (trailingCharsMatcher.find()) {
                number = number.substring(0, trailingCharsMatcher.start());
                logger.log(Level.FINER, "Stripped trailing characters: " + number);
            }
            if ((secondNumber = SECOND_NUMBER_START_PATTERN.matcher(number)).find()) {
                number = number.substring(0, secondNumber.start());
            }
            return number;
        }
        return "";
    }

    static boolean isViablePhoneNumber(String number) {
        if (number.length() < 2) {
            return false;
        }
        Matcher m = VALID_PHONE_NUMBER_PATTERN.matcher(number);
        return m.matches();
    }

    static String normalize(String number) {
        Matcher m = VALID_ALPHA_PHONE_PATTERN.matcher(number);
        if (m.matches()) {
            return PhoneNumberUtil.normalizeHelper(number, ALPHA_PHONE_MAPPINGS, true);
        }
        return PhoneNumberUtil.normalizeDigitsOnly(number);
    }

    static void normalize(StringBuilder number) {
        String normalizedNumber = PhoneNumberUtil.normalize(number.toString());
        number.replace(0, number.length(), normalizedNumber);
    }

    public static String normalizeDigitsOnly(String number) {
        return PhoneNumberUtil.normalizeDigits(number, false).toString();
    }

    static StringBuilder normalizeDigits(String number, boolean keepNonDigits) {
        StringBuilder normalizedDigits = new StringBuilder(number.length());
        for (char c : number.toCharArray()) {
            int digit = Character.digit(c, 10);
            if (digit != -1) {
                normalizedDigits.append(digit);
                continue;
            }
            if (!keepNonDigits) continue;
            normalizedDigits.append(c);
        }
        return normalizedDigits;
    }

    static String normalizeDiallableCharsOnly(String number) {
        return PhoneNumberUtil.normalizeHelper(number, DIALLABLE_CHAR_MAPPINGS, true);
    }

    public static String convertAlphaCharactersInNumber(String number) {
        return PhoneNumberUtil.normalizeHelper(number, ALPHA_PHONE_MAPPINGS, false);
    }

    public int getLengthOfGeographicalAreaCode(Phonenumber.PhoneNumber number) {
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegion(this.getRegionCodeForNumber(number));
        if (metadata == null) {
            return 0;
        }
        if (!metadata.hasNationalPrefix() && !number.isItalianLeadingZero()) {
            return 0;
        }
        if (!this.isNumberGeographical(number)) {
            return 0;
        }
        return this.getLengthOfNationalDestinationCode(number);
    }

    public int getLengthOfNationalDestinationCode(Phonenumber.PhoneNumber number) {
        String mobileToken;
        Phonenumber.PhoneNumber copiedProto;
        if (number.hasExtension()) {
            copiedProto = new Phonenumber.PhoneNumber();
            copiedProto.mergeFrom(number);
            copiedProto.clearExtension();
        } else {
            copiedProto = number;
        }
        String nationalSignificantNumber = this.format(copiedProto, PhoneNumberFormat.INTERNATIONAL);
        String[] numberGroups = NON_DIGITS_PATTERN.split(nationalSignificantNumber);
        if (numberGroups.length <= 3) {
            return 0;
        }
        if (this.getNumberType(number) == PhoneNumberType.MOBILE && !(mobileToken = PhoneNumberUtil.getCountryMobileToken(number.getCountryCode())).equals("")) {
            return numberGroups[2].length() + numberGroups[3].length();
        }
        return numberGroups[2].length();
    }

    public static String getCountryMobileToken(int countryCallingCode) {
        if (MOBILE_TOKEN_MAPPINGS.containsKey(countryCallingCode)) {
            return MOBILE_TOKEN_MAPPINGS.get(countryCallingCode);
        }
        return "";
    }

    private static String normalizeHelper(String number, Map<Character, Character> normalizationReplacements, boolean removeNonMatches) {
        StringBuilder normalizedNumber = new StringBuilder(number.length());
        for (int i = 0; i < number.length(); ++i) {
            char character = number.charAt(i);
            Character newDigit = normalizationReplacements.get(Character.valueOf(Character.toUpperCase(character)));
            if (newDigit != null) {
                normalizedNumber.append(newDigit);
                continue;
            }
            if (removeNonMatches) continue;
            normalizedNumber.append(character);
        }
        return normalizedNumber.toString();
    }

    static synchronized PhoneNumberUtil getInstance(String baseFileLocation, Map<Integer, List<String>> countryCallingCodeToRegionCodeMap) {
        if (instance != null) {
            throw new IllegalStateException("PhoneNumberUtil instance is already set (you should call resetInstance() first)");
        }
        instance = new PhoneNumberUtil(baseFileLocation, countryCallingCodeToRegionCodeMap);
        return instance;
    }

    static synchronized void resetInstance() {
        instance = null;
    }

    public Set<String> getSupportedRegions() {
        return Collections.unmodifiableSet(this.supportedRegions);
    }

    public Set<Integer> getSupportedGlobalNetworkCallingCodes() {
        return Collections.unmodifiableSet(this.countryCodesForNonGeographicalRegion);
    }

    public static synchronized PhoneNumberUtil getInstance() {
        if (instance == null) {
            return PhoneNumberUtil.getInstance(META_DATA_FILE_PREFIX, CountryCodeToRegionCodeMap.getCountryCodeToRegionCodeMap());
        }
        return instance;
    }

    static boolean formattingRuleHasFirstGroupOnly(String nationalPrefixFormattingRule) {
        return nationalPrefixFormattingRule.length() == 0 || FIRST_GROUP_ONLY_PREFIX_PATTERN.matcher(nationalPrefixFormattingRule).matches();
    }

    boolean isNumberGeographical(Phonenumber.PhoneNumber phoneNumber) {
        PhoneNumberType numberType = this.getNumberType(phoneNumber);
        return numberType == PhoneNumberType.FIXED_LINE || numberType == PhoneNumberType.FIXED_LINE_OR_MOBILE;
    }

    private boolean isValidRegionCode(String regionCode) {
        return regionCode != null && this.supportedRegions.contains(regionCode);
    }

    private boolean hasValidCountryCallingCode(int countryCallingCode) {
        return this.countryCallingCodeToRegionCodeMap.containsKey(countryCallingCode);
    }

    public String format(Phonenumber.PhoneNumber number, PhoneNumberFormat numberFormat) {
        String rawInput;
        if (number.getNationalNumber() == 0L && number.hasRawInput() && (rawInput = number.getRawInput()).length() > 0) {
            return rawInput;
        }
        StringBuilder formattedNumber = new StringBuilder(20);
        this.format(number, numberFormat, formattedNumber);
        return formattedNumber.toString();
    }

    public void format(Phonenumber.PhoneNumber number, PhoneNumberFormat numberFormat, StringBuilder formattedNumber) {
        formattedNumber.setLength(0);
        int countryCallingCode = number.getCountryCode();
        String nationalSignificantNumber = this.getNationalSignificantNumber(number);
        if (numberFormat == PhoneNumberFormat.E164) {
            formattedNumber.append(nationalSignificantNumber);
            this.prefixNumberWithCountryCallingCode(countryCallingCode, PhoneNumberFormat.E164, formattedNumber);
            return;
        }
        if (!this.hasValidCountryCallingCode(countryCallingCode)) {
            formattedNumber.append(nationalSignificantNumber);
            return;
        }
        String regionCode = this.getRegionCodeForCountryCode(countryCallingCode);
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegionOrCallingCode(countryCallingCode, regionCode);
        formattedNumber.append(this.formatNsn(nationalSignificantNumber, metadata, numberFormat));
        this.maybeAppendFormattedExtension(number, metadata, numberFormat, formattedNumber);
        this.prefixNumberWithCountryCallingCode(countryCallingCode, numberFormat, formattedNumber);
    }

    public String formatByPattern(Phonenumber.PhoneNumber number, PhoneNumberFormat numberFormat, List<Phonemetadata.NumberFormat> userDefinedFormats) {
        int countryCallingCode = number.getCountryCode();
        String nationalSignificantNumber = this.getNationalSignificantNumber(number);
        if (!this.hasValidCountryCallingCode(countryCallingCode)) {
            return nationalSignificantNumber;
        }
        String regionCode = this.getRegionCodeForCountryCode(countryCallingCode);
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegionOrCallingCode(countryCallingCode, regionCode);
        StringBuilder formattedNumber = new StringBuilder(20);
        Phonemetadata.NumberFormat formattingPattern = this.chooseFormattingPatternForNumber(userDefinedFormats, nationalSignificantNumber);
        if (formattingPattern == null) {
            formattedNumber.append(nationalSignificantNumber);
        } else {
            Phonemetadata.NumberFormat numFormatCopy = new Phonemetadata.NumberFormat();
            numFormatCopy.mergeFrom(formattingPattern);
            String nationalPrefixFormattingRule = formattingPattern.getNationalPrefixFormattingRule();
            if (nationalPrefixFormattingRule.length() > 0) {
                String nationalPrefix = metadata.getNationalPrefix();
                if (nationalPrefix.length() > 0) {
                    nationalPrefixFormattingRule = NP_PATTERN.matcher(nationalPrefixFormattingRule).replaceFirst(nationalPrefix);
                    nationalPrefixFormattingRule = FG_PATTERN.matcher(nationalPrefixFormattingRule).replaceFirst("\\$1");
                    numFormatCopy.setNationalPrefixFormattingRule(nationalPrefixFormattingRule);
                } else {
                    numFormatCopy.clearNationalPrefixFormattingRule();
                }
            }
            formattedNumber.append(this.formatNsnUsingPattern(nationalSignificantNumber, numFormatCopy, numberFormat));
        }
        this.maybeAppendFormattedExtension(number, metadata, numberFormat, formattedNumber);
        this.prefixNumberWithCountryCallingCode(countryCallingCode, numberFormat, formattedNumber);
        return formattedNumber.toString();
    }

    public String formatNationalNumberWithCarrierCode(Phonenumber.PhoneNumber number, String carrierCode) {
        int countryCallingCode = number.getCountryCode();
        String nationalSignificantNumber = this.getNationalSignificantNumber(number);
        if (!this.hasValidCountryCallingCode(countryCallingCode)) {
            return nationalSignificantNumber;
        }
        String regionCode = this.getRegionCodeForCountryCode(countryCallingCode);
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegionOrCallingCode(countryCallingCode, regionCode);
        StringBuilder formattedNumber = new StringBuilder(20);
        formattedNumber.append(this.formatNsn(nationalSignificantNumber, metadata, PhoneNumberFormat.NATIONAL, carrierCode));
        this.maybeAppendFormattedExtension(number, metadata, PhoneNumberFormat.NATIONAL, formattedNumber);
        this.prefixNumberWithCountryCallingCode(countryCallingCode, PhoneNumberFormat.NATIONAL, formattedNumber);
        return formattedNumber.toString();
    }

    private Phonemetadata.PhoneMetadata getMetadataForRegionOrCallingCode(int countryCallingCode, String regionCode) {
        return REGION_CODE_FOR_NON_GEO_ENTITY.equals(regionCode) ? this.getMetadataForNonGeographicalRegion(countryCallingCode) : this.getMetadataForRegion(regionCode);
    }

    public String formatNationalNumberWithPreferredCarrierCode(Phonenumber.PhoneNumber number, String fallbackCarrierCode) {
        return this.formatNationalNumberWithCarrierCode(number, number.hasPreferredDomesticCarrierCode() ? number.getPreferredDomesticCarrierCode() : fallbackCarrierCode);
    }

    public String formatNumberForMobileDialing(Phonenumber.PhoneNumber number, String regionCallingFrom, boolean withFormatting) {
        boolean isValidNumber;
        int countryCallingCode = number.getCountryCode();
        if (!this.hasValidCountryCallingCode(countryCallingCode)) {
            return number.hasRawInput() ? number.getRawInput() : "";
        }
        String formattedNumber = "";
        Phonenumber.PhoneNumber numberNoExt = new Phonenumber.PhoneNumber().mergeFrom(number).clearExtension();
        String regionCode = this.getRegionCodeForCountryCode(countryCallingCode);
        PhoneNumberType numberType = this.getNumberType(numberNoExt);
        boolean bl = isValidNumber = numberType != PhoneNumberType.UNKNOWN;
        if (regionCallingFrom.equals(regionCode)) {
            boolean isFixedLineOrMobile;
            boolean bl2 = isFixedLineOrMobile = numberType == PhoneNumberType.FIXED_LINE || numberType == PhoneNumberType.MOBILE || numberType == PhoneNumberType.FIXED_LINE_OR_MOBILE;
            if (regionCode.equals("CO") && numberType == PhoneNumberType.FIXED_LINE) {
                formattedNumber = this.formatNationalNumberWithCarrierCode(numberNoExt, COLOMBIA_MOBILE_TO_FIXED_LINE_PREFIX);
            } else if (regionCode.equals("BR") && isFixedLineOrMobile) {
                formattedNumber = numberNoExt.hasPreferredDomesticCarrierCode() ? (formattedNumber = this.formatNationalNumberWithPreferredCarrierCode(numberNoExt, "")) : "";
            } else if (isValidNumber && regionCode.equals("HU")) {
                formattedNumber = this.getNddPrefixForRegion(regionCode, true) + " " + this.format(numberNoExt, PhoneNumberFormat.NATIONAL);
            } else if (countryCallingCode == 1) {
                Phonemetadata.PhoneMetadata regionMetadata = this.getMetadataForRegion(regionCallingFrom);
                formattedNumber = this.canBeInternationallyDialled(numberNoExt) && !this.isShorterThanPossibleNormalNumber(regionMetadata, this.getNationalSignificantNumber(numberNoExt)) ? this.format(numberNoExt, PhoneNumberFormat.INTERNATIONAL) : this.format(numberNoExt, PhoneNumberFormat.NATIONAL);
            } else {
                formattedNumber = (regionCode.equals(REGION_CODE_FOR_NON_GEO_ENTITY) || (regionCode.equals("MX") || regionCode.equals("CL")) && isFixedLineOrMobile) && this.canBeInternationallyDialled(numberNoExt) ? this.format(numberNoExt, PhoneNumberFormat.INTERNATIONAL) : this.format(numberNoExt, PhoneNumberFormat.NATIONAL);
            }
        } else if (isValidNumber && this.canBeInternationallyDialled(numberNoExt)) {
            return withFormatting ? this.format(numberNoExt, PhoneNumberFormat.INTERNATIONAL) : this.format(numberNoExt, PhoneNumberFormat.E164);
        }
        return withFormatting ? formattedNumber : PhoneNumberUtil.normalizeDiallableCharsOnly(formattedNumber);
    }

    public String formatOutOfCountryCallingNumber(Phonenumber.PhoneNumber number, String regionCallingFrom) {
        if (!this.isValidRegionCode(regionCallingFrom)) {
            logger.log(Level.WARNING, "Trying to format number from invalid region " + regionCallingFrom + ". International formatting applied.");
            return this.format(number, PhoneNumberFormat.INTERNATIONAL);
        }
        int countryCallingCode = number.getCountryCode();
        String nationalSignificantNumber = this.getNationalSignificantNumber(number);
        if (!this.hasValidCountryCallingCode(countryCallingCode)) {
            return nationalSignificantNumber;
        }
        if (countryCallingCode == 1) {
            if (this.isNANPACountry(regionCallingFrom)) {
                return countryCallingCode + " " + this.format(number, PhoneNumberFormat.NATIONAL);
            }
        } else if (countryCallingCode == this.getCountryCodeForValidRegion(regionCallingFrom)) {
            return this.format(number, PhoneNumberFormat.NATIONAL);
        }
        Phonemetadata.PhoneMetadata metadataForRegionCallingFrom = this.getMetadataForRegion(regionCallingFrom);
        String internationalPrefix = metadataForRegionCallingFrom.getInternationalPrefix();
        String internationalPrefixForFormatting = "";
        if (UNIQUE_INTERNATIONAL_PREFIX.matcher(internationalPrefix).matches()) {
            internationalPrefixForFormatting = internationalPrefix;
        } else if (metadataForRegionCallingFrom.hasPreferredInternationalPrefix()) {
            internationalPrefixForFormatting = metadataForRegionCallingFrom.getPreferredInternationalPrefix();
        }
        String regionCode = this.getRegionCodeForCountryCode(countryCallingCode);
        Phonemetadata.PhoneMetadata metadataForRegion = this.getMetadataForRegionOrCallingCode(countryCallingCode, regionCode);
        String formattedNationalNumber = this.formatNsn(nationalSignificantNumber, metadataForRegion, PhoneNumberFormat.INTERNATIONAL);
        StringBuilder formattedNumber = new StringBuilder(formattedNationalNumber);
        this.maybeAppendFormattedExtension(number, metadataForRegion, PhoneNumberFormat.INTERNATIONAL, formattedNumber);
        if (internationalPrefixForFormatting.length() > 0) {
            formattedNumber.insert(0, " ").insert(0, countryCallingCode).insert(0, " ").insert(0, internationalPrefixForFormatting);
        } else {
            this.prefixNumberWithCountryCallingCode(countryCallingCode, PhoneNumberFormat.INTERNATIONAL, formattedNumber);
        }
        return formattedNumber.toString();
    }

    public String formatInOriginalFormat(Phonenumber.PhoneNumber number, String regionCallingFrom) {
        String normalizedRawInput;
        String normalizedFormattedNumber;
        String formattedNumber;
        if (number.hasRawInput() && (this.hasUnexpectedItalianLeadingZero(number) || !this.hasFormattingPatternForNumber(number))) {
            return number.getRawInput();
        }
        if (!number.hasCountryCodeSource()) {
            return this.format(number, PhoneNumberFormat.NATIONAL);
        }
        switch (number.getCountryCodeSource()) {
            case FROM_NUMBER_WITH_PLUS_SIGN: {
                formattedNumber = this.format(number, PhoneNumberFormat.INTERNATIONAL);
                break;
            }
            case FROM_NUMBER_WITH_IDD: {
                formattedNumber = this.formatOutOfCountryCallingNumber(number, regionCallingFrom);
                break;
            }
            case FROM_NUMBER_WITHOUT_PLUS_SIGN: {
                formattedNumber = this.format(number, PhoneNumberFormat.INTERNATIONAL).substring(1);
                break;
            }
            default: {
                String regionCode = this.getRegionCodeForCountryCode(number.getCountryCode());
                String nationalPrefix = this.getNddPrefixForRegion(regionCode, true);
                String nationalFormat = this.format(number, PhoneNumberFormat.NATIONAL);
                if (nationalPrefix == null || nationalPrefix.length() == 0) {
                    formattedNumber = nationalFormat;
                    break;
                }
                if (this.rawInputContainsNationalPrefix(number.getRawInput(), nationalPrefix, regionCode)) {
                    formattedNumber = nationalFormat;
                    break;
                }
                Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegion(regionCode);
                String nationalNumber = this.getNationalSignificantNumber(number);
                Phonemetadata.NumberFormat formatRule = this.chooseFormattingPatternForNumber(metadata.numberFormats(), nationalNumber);
                if (formatRule == null) {
                    formattedNumber = nationalFormat;
                    break;
                }
                String candidateNationalPrefixRule = formatRule.getNationalPrefixFormattingRule();
                int indexOfFirstGroup = candidateNationalPrefixRule.indexOf("$1");
                if (indexOfFirstGroup <= 0) {
                    formattedNumber = nationalFormat;
                    break;
                }
                candidateNationalPrefixRule = candidateNationalPrefixRule.substring(0, indexOfFirstGroup);
                if ((candidateNationalPrefixRule = PhoneNumberUtil.normalizeDigitsOnly(candidateNationalPrefixRule)).length() == 0) {
                    formattedNumber = nationalFormat;
                    break;
                }
                Phonemetadata.NumberFormat numFormatCopy = new Phonemetadata.NumberFormat();
                numFormatCopy.mergeFrom(formatRule);
                numFormatCopy.clearNationalPrefixFormattingRule();
                ArrayList<Phonemetadata.NumberFormat> numberFormats = new ArrayList<Phonemetadata.NumberFormat>(1);
                numberFormats.add(numFormatCopy);
                formattedNumber = this.formatByPattern(number, PhoneNumberFormat.NATIONAL, numberFormats);
            }
        }
        String rawInput = number.getRawInput();
        if (formattedNumber != null && rawInput.length() > 0 && !(normalizedFormattedNumber = PhoneNumberUtil.normalizeDiallableCharsOnly(formattedNumber)).equals(normalizedRawInput = PhoneNumberUtil.normalizeDiallableCharsOnly(rawInput))) {
            formattedNumber = rawInput;
        }
        return formattedNumber;
    }

    private boolean rawInputContainsNationalPrefix(String rawInput, String nationalPrefix, String regionCode) {
        String normalizedNationalNumber = PhoneNumberUtil.normalizeDigitsOnly(rawInput);
        if (normalizedNationalNumber.startsWith(nationalPrefix)) {
            try {
                return this.isValidNumber(this.parse(normalizedNationalNumber.substring(nationalPrefix.length()), regionCode));
            }
            catch (NumberParseException e) {
                return false;
            }
        }
        return false;
    }

    private boolean hasUnexpectedItalianLeadingZero(Phonenumber.PhoneNumber number) {
        return number.isItalianLeadingZero() && !this.isLeadingZeroPossible(number.getCountryCode());
    }

    private boolean hasFormattingPatternForNumber(Phonenumber.PhoneNumber number) {
        String phoneNumberRegion;
        int countryCallingCode = number.getCountryCode();
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegionOrCallingCode(countryCallingCode, phoneNumberRegion = this.getRegionCodeForCountryCode(countryCallingCode));
        if (metadata == null) {
            return false;
        }
        String nationalNumber = this.getNationalSignificantNumber(number);
        Phonemetadata.NumberFormat formatRule = this.chooseFormattingPatternForNumber(metadata.numberFormats(), nationalNumber);
        return formatRule != null;
    }

    public String formatOutOfCountryKeepingAlphaChars(Phonenumber.PhoneNumber number, String regionCallingFrom) {
        int firstNationalNumberDigit;
        String rawInput = number.getRawInput();
        if (rawInput.length() == 0) {
            return this.formatOutOfCountryCallingNumber(number, regionCallingFrom);
        }
        int countryCode = number.getCountryCode();
        if (!this.hasValidCountryCallingCode(countryCode)) {
            return rawInput;
        }
        rawInput = PhoneNumberUtil.normalizeHelper(rawInput, ALL_PLUS_NUMBER_GROUPING_SYMBOLS, true);
        String nationalNumber = this.getNationalSignificantNumber(number);
        if (nationalNumber.length() > 3 && (firstNationalNumberDigit = rawInput.indexOf(nationalNumber.substring(0, 3))) != -1) {
            rawInput = rawInput.substring(firstNationalNumberDigit);
        }
        Phonemetadata.PhoneMetadata metadataForRegionCallingFrom = this.getMetadataForRegion(regionCallingFrom);
        if (countryCode == 1) {
            if (this.isNANPACountry(regionCallingFrom)) {
                return countryCode + " " + rawInput;
            }
        } else if (metadataForRegionCallingFrom != null && countryCode == this.getCountryCodeForValidRegion(regionCallingFrom)) {
            Phonemetadata.NumberFormat formattingPattern = this.chooseFormattingPatternForNumber(metadataForRegionCallingFrom.numberFormats(), nationalNumber);
            if (formattingPattern == null) {
                return rawInput;
            }
            Phonemetadata.NumberFormat newFormat = new Phonemetadata.NumberFormat();
            newFormat.mergeFrom(formattingPattern);
            newFormat.setPattern("(\\d+)(.*)");
            newFormat.setFormat("$1$2");
            return this.formatNsnUsingPattern(rawInput, newFormat, PhoneNumberFormat.NATIONAL);
        }
        String internationalPrefixForFormatting = "";
        if (metadataForRegionCallingFrom != null) {
            String internationalPrefix = metadataForRegionCallingFrom.getInternationalPrefix();
            internationalPrefixForFormatting = UNIQUE_INTERNATIONAL_PREFIX.matcher(internationalPrefix).matches() ? internationalPrefix : metadataForRegionCallingFrom.getPreferredInternationalPrefix();
        }
        StringBuilder formattedNumber = new StringBuilder(rawInput);
        String regionCode = this.getRegionCodeForCountryCode(countryCode);
        Phonemetadata.PhoneMetadata metadataForRegion = this.getMetadataForRegionOrCallingCode(countryCode, regionCode);
        this.maybeAppendFormattedExtension(number, metadataForRegion, PhoneNumberFormat.INTERNATIONAL, formattedNumber);
        if (internationalPrefixForFormatting.length() > 0) {
            formattedNumber.insert(0, " ").insert(0, countryCode).insert(0, " ").insert(0, internationalPrefixForFormatting);
        } else {
            logger.log(Level.WARNING, "Trying to format number from invalid region " + regionCallingFrom + ". International formatting applied.");
            this.prefixNumberWithCountryCallingCode(countryCode, PhoneNumberFormat.INTERNATIONAL, formattedNumber);
        }
        return formattedNumber.toString();
    }

    public String getNationalSignificantNumber(Phonenumber.PhoneNumber number) {
        StringBuilder nationalNumber = new StringBuilder();
        if (number.isItalianLeadingZero()) {
            char[] zeros = new char[number.getNumberOfLeadingZeros()];
            Arrays.fill(zeros, '0');
            nationalNumber.append(new String(zeros));
        }
        nationalNumber.append(number.getNationalNumber());
        return nationalNumber.toString();
    }

    private void prefixNumberWithCountryCallingCode(int countryCallingCode, PhoneNumberFormat numberFormat, StringBuilder formattedNumber) {
        switch (numberFormat) {
            case E164: {
                formattedNumber.insert(0, countryCallingCode).insert(0, '+');
                return;
            }
            case INTERNATIONAL: {
                formattedNumber.insert(0, " ").insert(0, countryCallingCode).insert(0, '+');
                return;
            }
            case RFC3966: {
                formattedNumber.insert(0, "-").insert(0, countryCallingCode).insert(0, '+').insert(0, RFC3966_PREFIX);
                return;
            }
        }
    }

    private String formatNsn(String number, Phonemetadata.PhoneMetadata metadata, PhoneNumberFormat numberFormat) {
        return this.formatNsn(number, metadata, numberFormat, null);
    }

    private String formatNsn(String number, Phonemetadata.PhoneMetadata metadata, PhoneNumberFormat numberFormat, String carrierCode) {
        List<Phonemetadata.NumberFormat> intlNumberFormats = metadata.intlNumberFormats();
        List<Phonemetadata.NumberFormat> availableFormats = intlNumberFormats.size() == 0 || numberFormat == PhoneNumberFormat.NATIONAL ? metadata.numberFormats() : metadata.intlNumberFormats();
        Phonemetadata.NumberFormat formattingPattern = this.chooseFormattingPatternForNumber(availableFormats, number);
        return formattingPattern == null ? number : this.formatNsnUsingPattern(number, formattingPattern, numberFormat, carrierCode);
    }

    Phonemetadata.NumberFormat chooseFormattingPatternForNumber(List<Phonemetadata.NumberFormat> availableFormats, String nationalNumber) {
        for (Phonemetadata.NumberFormat numFormat : availableFormats) {
            Matcher m;
            int size = numFormat.leadingDigitsPatternSize();
            if (size != 0 && !this.regexCache.getPatternForRegex(numFormat.getLeadingDigitsPattern(size - 1)).matcher(nationalNumber).lookingAt() || !(m = this.regexCache.getPatternForRegex(numFormat.getPattern()).matcher(nationalNumber)).matches()) continue;
            return numFormat;
        }
        return null;
    }

    String formatNsnUsingPattern(String nationalNumber, Phonemetadata.NumberFormat formattingPattern, PhoneNumberFormat numberFormat) {
        return this.formatNsnUsingPattern(nationalNumber, formattingPattern, numberFormat, null);
    }

    private String formatNsnUsingPattern(String nationalNumber, Phonemetadata.NumberFormat formattingPattern, PhoneNumberFormat numberFormat, String carrierCode) {
        String numberFormatRule = formattingPattern.getFormat();
        Matcher m = this.regexCache.getPatternForRegex(formattingPattern.getPattern()).matcher(nationalNumber);
        String formattedNationalNumber = "";
        if (numberFormat == PhoneNumberFormat.NATIONAL && carrierCode != null && carrierCode.length() > 0 && formattingPattern.getDomesticCarrierCodeFormattingRule().length() > 0) {
            String carrierCodeFormattingRule = formattingPattern.getDomesticCarrierCodeFormattingRule();
            carrierCodeFormattingRule = CC_PATTERN.matcher(carrierCodeFormattingRule).replaceFirst(carrierCode);
            numberFormatRule = FIRST_GROUP_PATTERN.matcher(numberFormatRule).replaceFirst(carrierCodeFormattingRule);
            formattedNationalNumber = m.replaceAll(numberFormatRule);
        } else {
            String nationalPrefixFormattingRule = formattingPattern.getNationalPrefixFormattingRule();
            if (numberFormat == PhoneNumberFormat.NATIONAL && nationalPrefixFormattingRule != null && nationalPrefixFormattingRule.length() > 0) {
                Matcher firstGroupMatcher = FIRST_GROUP_PATTERN.matcher(numberFormatRule);
                formattedNationalNumber = m.replaceAll(firstGroupMatcher.replaceFirst(nationalPrefixFormattingRule));
            } else {
                formattedNationalNumber = m.replaceAll(numberFormatRule);
            }
        }
        if (numberFormat == PhoneNumberFormat.RFC3966) {
            Matcher matcher = SEPARATOR_PATTERN.matcher(formattedNationalNumber);
            if (matcher.lookingAt()) {
                formattedNationalNumber = matcher.replaceFirst("");
            }
            formattedNationalNumber = matcher.reset(formattedNationalNumber).replaceAll("-");
        }
        return formattedNationalNumber;
    }

    public Phonenumber.PhoneNumber getExampleNumber(String regionCode) {
        return this.getExampleNumberForType(regionCode, PhoneNumberType.FIXED_LINE);
    }

    public Phonenumber.PhoneNumber getExampleNumberForType(String regionCode, PhoneNumberType type) {
        if (!this.isValidRegionCode(regionCode)) {
            logger.log(Level.WARNING, "Invalid or unknown region code provided: " + regionCode);
            return null;
        }
        Phonemetadata.PhoneNumberDesc desc = this.getNumberDescByType(this.getMetadataForRegion(regionCode), type);
        try {
            if (desc.hasExampleNumber()) {
                return this.parse(desc.getExampleNumber(), regionCode);
            }
        }
        catch (NumberParseException e) {
            logger.log(Level.SEVERE, e.toString());
        }
        return null;
    }

    public Phonenumber.PhoneNumber getExampleNumberForNonGeoEntity(int countryCallingCode) {
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForNonGeographicalRegion(countryCallingCode);
        if (metadata != null) {
            Phonemetadata.PhoneNumberDesc desc = metadata.getGeneralDesc();
            try {
                if (desc.hasExampleNumber()) {
                    return this.parse("+" + countryCallingCode + desc.getExampleNumber(), UNKNOWN_REGION);
                }
            }
            catch (NumberParseException e) {
                logger.log(Level.SEVERE, e.toString());
            }
        } else {
            logger.log(Level.WARNING, "Invalid or unknown country calling code provided: " + countryCallingCode);
        }
        return null;
    }

    private void maybeAppendFormattedExtension(Phonenumber.PhoneNumber number, Phonemetadata.PhoneMetadata metadata, PhoneNumberFormat numberFormat, StringBuilder formattedNumber) {
        if (number.hasExtension() && number.getExtension().length() > 0) {
            if (numberFormat == PhoneNumberFormat.RFC3966) {
                formattedNumber.append(RFC3966_EXTN_PREFIX).append(number.getExtension());
            } else if (metadata.hasPreferredExtnPrefix()) {
                formattedNumber.append(metadata.getPreferredExtnPrefix()).append(number.getExtension());
            } else {
                formattedNumber.append(DEFAULT_EXTN_PREFIX).append(number.getExtension());
            }
        }
    }

    Phonemetadata.PhoneNumberDesc getNumberDescByType(Phonemetadata.PhoneMetadata metadata, PhoneNumberType type) {
        switch (type) {
            case PREMIUM_RATE: {
                return metadata.getPremiumRate();
            }
            case TOLL_FREE: {
                return metadata.getTollFree();
            }
            case MOBILE: {
                return metadata.getMobile();
            }
            case FIXED_LINE: 
            case FIXED_LINE_OR_MOBILE: {
                return metadata.getFixedLine();
            }
            case SHARED_COST: {
                return metadata.getSharedCost();
            }
            case VOIP: {
                return metadata.getVoip();
            }
            case PERSONAL_NUMBER: {
                return metadata.getPersonalNumber();
            }
            case PAGER: {
                return metadata.getPager();
            }
            case UAN: {
                return metadata.getUan();
            }
            case VOICEMAIL: {
                return metadata.getVoicemail();
            }
        }
        return metadata.getGeneralDesc();
    }

    public PhoneNumberType getNumberType(Phonenumber.PhoneNumber number) {
        String regionCode = this.getRegionCodeForNumber(number);
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegionOrCallingCode(number.getCountryCode(), regionCode);
        if (metadata == null) {
            return PhoneNumberType.UNKNOWN;
        }
        String nationalSignificantNumber = this.getNationalSignificantNumber(number);
        return this.getNumberTypeHelper(nationalSignificantNumber, metadata);
    }

    private PhoneNumberType getNumberTypeHelper(String nationalNumber, Phonemetadata.PhoneMetadata metadata) {
        Phonemetadata.PhoneNumberDesc generalNumberDesc = metadata.getGeneralDesc();
        if (!generalNumberDesc.hasNationalNumberPattern() || !this.isNumberMatchingDesc(nationalNumber, generalNumberDesc)) {
            return PhoneNumberType.UNKNOWN;
        }
        if (this.isNumberMatchingDesc(nationalNumber, metadata.getPremiumRate())) {
            return PhoneNumberType.PREMIUM_RATE;
        }
        if (this.isNumberMatchingDesc(nationalNumber, metadata.getTollFree())) {
            return PhoneNumberType.TOLL_FREE;
        }
        if (this.isNumberMatchingDesc(nationalNumber, metadata.getSharedCost())) {
            return PhoneNumberType.SHARED_COST;
        }
        if (this.isNumberMatchingDesc(nationalNumber, metadata.getVoip())) {
            return PhoneNumberType.VOIP;
        }
        if (this.isNumberMatchingDesc(nationalNumber, metadata.getPersonalNumber())) {
            return PhoneNumberType.PERSONAL_NUMBER;
        }
        if (this.isNumberMatchingDesc(nationalNumber, metadata.getPager())) {
            return PhoneNumberType.PAGER;
        }
        if (this.isNumberMatchingDesc(nationalNumber, metadata.getUan())) {
            return PhoneNumberType.UAN;
        }
        if (this.isNumberMatchingDesc(nationalNumber, metadata.getVoicemail())) {
            return PhoneNumberType.VOICEMAIL;
        }
        boolean isFixedLine = this.isNumberMatchingDesc(nationalNumber, metadata.getFixedLine());
        if (isFixedLine) {
            if (metadata.isSameMobileAndFixedLinePattern()) {
                return PhoneNumberType.FIXED_LINE_OR_MOBILE;
            }
            if (this.isNumberMatchingDesc(nationalNumber, metadata.getMobile())) {
                return PhoneNumberType.FIXED_LINE_OR_MOBILE;
            }
            return PhoneNumberType.FIXED_LINE;
        }
        if (!metadata.isSameMobileAndFixedLinePattern() && this.isNumberMatchingDesc(nationalNumber, metadata.getMobile())) {
            return PhoneNumberType.MOBILE;
        }
        return PhoneNumberType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Phonemetadata.PhoneMetadata getMetadataForRegion(String regionCode) {
        if (!this.isValidRegionCode(regionCode)) {
            return null;
        }
        Map<String, Phonemetadata.PhoneMetadata> map = this.regionToMetadataMap;
        synchronized (map) {
            if (!this.regionToMetadataMap.containsKey(regionCode)) {
                this.loadMetadataFromFile(this.currentFilePrefix, regionCode, 0);
            }
        }
        return this.regionToMetadataMap.get(regionCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Phonemetadata.PhoneMetadata getMetadataForNonGeographicalRegion(int countryCallingCode) {
        Map<Integer, Phonemetadata.PhoneMetadata> map = this.countryCodeToNonGeographicalMetadataMap;
        synchronized (map) {
            if (!this.countryCallingCodeToRegionCodeMap.containsKey(countryCallingCode)) {
                return null;
            }
            if (!this.countryCodeToNonGeographicalMetadataMap.containsKey(countryCallingCode)) {
                this.loadMetadataFromFile(this.currentFilePrefix, REGION_CODE_FOR_NON_GEO_ENTITY, countryCallingCode);
            }
        }
        return this.countryCodeToNonGeographicalMetadataMap.get(countryCallingCode);
    }

    boolean isNumberPossibleForDesc(String nationalNumber, Phonemetadata.PhoneNumberDesc numberDesc) {
        Matcher possibleNumberPatternMatcher = this.regexCache.getPatternForRegex(numberDesc.getPossibleNumberPattern()).matcher(nationalNumber);
        return possibleNumberPatternMatcher.matches();
    }

    boolean isNumberMatchingDesc(String nationalNumber, Phonemetadata.PhoneNumberDesc numberDesc) {
        Matcher nationalNumberPatternMatcher = this.regexCache.getPatternForRegex(numberDesc.getNationalNumberPattern()).matcher(nationalNumber);
        return this.isNumberPossibleForDesc(nationalNumber, numberDesc) && nationalNumberPatternMatcher.matches();
    }

    public boolean isValidNumber(Phonenumber.PhoneNumber number) {
        String regionCode = this.getRegionCodeForNumber(number);
        return this.isValidNumberForRegion(number, regionCode);
    }

    public boolean isValidNumberForRegion(Phonenumber.PhoneNumber number, String regionCode) {
        int countryCode = number.getCountryCode();
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegionOrCallingCode(countryCode, regionCode);
        if (metadata == null || !REGION_CODE_FOR_NON_GEO_ENTITY.equals(regionCode) && countryCode != this.getCountryCodeForValidRegion(regionCode)) {
            return false;
        }
        Phonemetadata.PhoneNumberDesc generalNumDesc = metadata.getGeneralDesc();
        String nationalSignificantNumber = this.getNationalSignificantNumber(number);
        if (!generalNumDesc.hasNationalNumberPattern()) {
            int numberLength = nationalSignificantNumber.length();
            return numberLength > 2 && numberLength <= 16;
        }
        return this.getNumberTypeHelper(nationalSignificantNumber, metadata) != PhoneNumberType.UNKNOWN;
    }

    public String getRegionCodeForNumber(Phonenumber.PhoneNumber number) {
        int countryCode = number.getCountryCode();
        List<String> regions = this.countryCallingCodeToRegionCodeMap.get(countryCode);
        if (regions == null) {
            String numberString = this.getNationalSignificantNumber(number);
            logger.log(Level.WARNING, "Missing/invalid country_code (" + countryCode + ") for number " + numberString);
            return null;
        }
        if (regions.size() == 1) {
            return regions.get(0);
        }
        return this.getRegionCodeForNumberFromRegionList(number, regions);
    }

    private String getRegionCodeForNumberFromRegionList(Phonenumber.PhoneNumber number, List<String> regionCodes) {
        String nationalNumber = this.getNationalSignificantNumber(number);
        for (String regionCode : regionCodes) {
            Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegion(regionCode);
            if (!(metadata.hasLeadingDigits() ? this.regexCache.getPatternForRegex(metadata.getLeadingDigits()).matcher(nationalNumber).lookingAt() : this.getNumberTypeHelper(nationalNumber, metadata) != PhoneNumberType.UNKNOWN)) continue;
            return regionCode;
        }
        return null;
    }

    public String getRegionCodeForCountryCode(int countryCallingCode) {
        List<String> regionCodes = this.countryCallingCodeToRegionCodeMap.get(countryCallingCode);
        return regionCodes == null ? UNKNOWN_REGION : regionCodes.get(0);
    }

    public List<String> getRegionCodesForCountryCode(int countryCallingCode) {
        ArrayList regionCodes = this.countryCallingCodeToRegionCodeMap.get(countryCallingCode);
        return Collections.unmodifiableList(regionCodes == null ? new ArrayList(0) : regionCodes);
    }

    public int getCountryCodeForRegion(String regionCode) {
        if (!this.isValidRegionCode(regionCode)) {
            logger.log(Level.WARNING, "Invalid or missing region code (" + (regionCode == null ? "null" : regionCode) + ") provided.");
            return 0;
        }
        return this.getCountryCodeForValidRegion(regionCode);
    }

    private int getCountryCodeForValidRegion(String regionCode) {
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegion(regionCode);
        if (metadata == null) {
            throw new IllegalArgumentException("Invalid region code: " + regionCode);
        }
        return metadata.getCountryCode();
    }

    public String getNddPrefixForRegion(String regionCode, boolean stripNonDigits) {
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegion(regionCode);
        if (metadata == null) {
            logger.log(Level.WARNING, "Invalid or missing region code (" + (regionCode == null ? "null" : regionCode) + ") provided.");
            return null;
        }
        String nationalPrefix = metadata.getNationalPrefix();
        if (nationalPrefix.length() == 0) {
            return null;
        }
        if (stripNonDigits) {
            nationalPrefix = nationalPrefix.replace("~", "");
        }
        return nationalPrefix;
    }

    public boolean isNANPACountry(String regionCode) {
        return this.nanpaRegions.contains(regionCode);
    }

    boolean isLeadingZeroPossible(int countryCallingCode) {
        Phonemetadata.PhoneMetadata mainMetadataForCallingCode = this.getMetadataForRegionOrCallingCode(countryCallingCode, this.getRegionCodeForCountryCode(countryCallingCode));
        if (mainMetadataForCallingCode == null) {
            return false;
        }
        return mainMetadataForCallingCode.isLeadingZeroPossible();
    }

    public boolean isAlphaNumber(String number) {
        if (!PhoneNumberUtil.isViablePhoneNumber(number)) {
            return false;
        }
        StringBuilder strippedNumber = new StringBuilder(number);
        this.maybeStripExtension(strippedNumber);
        return VALID_ALPHA_PHONE_PATTERN.matcher(strippedNumber).matches();
    }

    public boolean isPossibleNumber(Phonenumber.PhoneNumber number) {
        return this.isPossibleNumberWithReason(number) == ValidationResult.IS_POSSIBLE;
    }

    private ValidationResult testNumberLengthAgainstPattern(Pattern numberPattern, String number) {
        Matcher numberMatcher = numberPattern.matcher(number);
        if (numberMatcher.matches()) {
            return ValidationResult.IS_POSSIBLE;
        }
        if (numberMatcher.lookingAt()) {
            return ValidationResult.TOO_LONG;
        }
        return ValidationResult.TOO_SHORT;
    }

    private boolean isShorterThanPossibleNormalNumber(Phonemetadata.PhoneMetadata regionMetadata, String number) {
        Pattern possibleNumberPattern = this.regexCache.getPatternForRegex(regionMetadata.getGeneralDesc().getPossibleNumberPattern());
        return this.testNumberLengthAgainstPattern(possibleNumberPattern, number) == ValidationResult.TOO_SHORT;
    }

    public ValidationResult isPossibleNumberWithReason(Phonenumber.PhoneNumber number) {
        String nationalNumber = this.getNationalSignificantNumber(number);
        int countryCode = number.getCountryCode();
        if (!this.hasValidCountryCallingCode(countryCode)) {
            return ValidationResult.INVALID_COUNTRY_CODE;
        }
        String regionCode = this.getRegionCodeForCountryCode(countryCode);
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegionOrCallingCode(countryCode, regionCode);
        Phonemetadata.PhoneNumberDesc generalNumDesc = metadata.getGeneralDesc();
        if (!generalNumDesc.hasNationalNumberPattern()) {
            logger.log(Level.FINER, "Checking if number is possible with incomplete metadata.");
            int numberLength = nationalNumber.length();
            if (numberLength < 2) {
                return ValidationResult.TOO_SHORT;
            }
            if (numberLength > 16) {
                return ValidationResult.TOO_LONG;
            }
            return ValidationResult.IS_POSSIBLE;
        }
        Pattern possibleNumberPattern = this.regexCache.getPatternForRegex(generalNumDesc.getPossibleNumberPattern());
        return this.testNumberLengthAgainstPattern(possibleNumberPattern, nationalNumber);
    }

    public boolean isPossibleNumber(String number, String regionDialingFrom) {
        try {
            return this.isPossibleNumber(this.parse(number, regionDialingFrom));
        }
        catch (NumberParseException e) {
            return false;
        }
    }

    public boolean truncateTooLongNumber(Phonenumber.PhoneNumber number) {
        if (this.isValidNumber(number)) {
            return true;
        }
        Phonenumber.PhoneNumber numberCopy = new Phonenumber.PhoneNumber();
        numberCopy.mergeFrom(number);
        long nationalNumber = number.getNationalNumber();
        do {
            numberCopy.setNationalNumber(nationalNumber /= 10L);
            if (this.isPossibleNumberWithReason(numberCopy) != ValidationResult.TOO_SHORT && nationalNumber != 0L) continue;
            return false;
        } while (!this.isValidNumber(numberCopy));
        number.setNationalNumber(nationalNumber);
        return true;
    }

    public AsYouTypeFormatter getAsYouTypeFormatter(String regionCode) {
        return new AsYouTypeFormatter(regionCode);
    }

    int extractCountryCode(StringBuilder fullNumber, StringBuilder nationalNumber) {
        if (fullNumber.length() == 0 || fullNumber.charAt(0) == '0') {
            return 0;
        }
        int numberLength = fullNumber.length();
        for (int i = 1; i <= 3 && i <= numberLength; ++i) {
            int potentialCountryCode = Integer.parseInt(fullNumber.substring(0, i));
            if (!this.countryCallingCodeToRegionCodeMap.containsKey(potentialCountryCode)) continue;
            nationalNumber.append(fullNumber.substring(i));
            return potentialCountryCode;
        }
        return 0;
    }

    int maybeExtractCountryCode(String number, Phonemetadata.PhoneMetadata defaultRegionMetadata, StringBuilder nationalNumber, boolean keepRawInput, Phonenumber.PhoneNumber phoneNumber) throws NumberParseException {
        if (number.length() == 0) {
            return 0;
        }
        StringBuilder fullNumber = new StringBuilder(number);
        String possibleCountryIddPrefix = "NonMatch";
        if (defaultRegionMetadata != null) {
            possibleCountryIddPrefix = defaultRegionMetadata.getInternationalPrefix();
        }
        Phonenumber.PhoneNumber.CountryCodeSource countryCodeSource = this.maybeStripInternationalPrefixAndNormalize(fullNumber, possibleCountryIddPrefix);
        if (keepRawInput) {
            phoneNumber.setCountryCodeSource(countryCodeSource);
        }
        if (countryCodeSource != Phonenumber.PhoneNumber.CountryCodeSource.FROM_DEFAULT_COUNTRY) {
            if (fullNumber.length() <= 2) {
                throw new NumberParseException(NumberParseException.ErrorType.TOO_SHORT_AFTER_IDD, "Phone number had an IDD, but after this was not long enough to be a viable phone number.");
            }
            int potentialCountryCode = this.extractCountryCode(fullNumber, nationalNumber);
            if (potentialCountryCode != 0) {
                phoneNumber.setCountryCode(potentialCountryCode);
                return potentialCountryCode;
            }
            throw new NumberParseException(NumberParseException.ErrorType.INVALID_COUNTRY_CODE, "Country calling code supplied was not recognised.");
        }
        if (defaultRegionMetadata != null) {
            int defaultCountryCode = defaultRegionMetadata.getCountryCode();
            String defaultCountryCodeString = String.valueOf(defaultCountryCode);
            String normalizedNumber = fullNumber.toString();
            if (normalizedNumber.startsWith(defaultCountryCodeString)) {
                StringBuilder potentialNationalNumber = new StringBuilder(normalizedNumber.substring(defaultCountryCodeString.length()));
                Phonemetadata.PhoneNumberDesc generalDesc = defaultRegionMetadata.getGeneralDesc();
                Pattern validNumberPattern = this.regexCache.getPatternForRegex(generalDesc.getNationalNumberPattern());
                this.maybeStripNationalPrefixAndCarrierCode(potentialNationalNumber, defaultRegionMetadata, null);
                Pattern possibleNumberPattern = this.regexCache.getPatternForRegex(generalDesc.getPossibleNumberPattern());
                if (!validNumberPattern.matcher(fullNumber).matches() && validNumberPattern.matcher(potentialNationalNumber).matches() || this.testNumberLengthAgainstPattern(possibleNumberPattern, fullNumber.toString()) == ValidationResult.TOO_LONG) {
                    nationalNumber.append((CharSequence)potentialNationalNumber);
                    if (keepRawInput) {
                        phoneNumber.setCountryCodeSource(Phonenumber.PhoneNumber.CountryCodeSource.FROM_NUMBER_WITHOUT_PLUS_SIGN);
                    }
                    phoneNumber.setCountryCode(defaultCountryCode);
                    return defaultCountryCode;
                }
            }
        }
        phoneNumber.setCountryCode(0);
        return 0;
    }

    private boolean parsePrefixAsIdd(Pattern iddPattern, StringBuilder number) {
        Matcher m = iddPattern.matcher(number);
        if (m.lookingAt()) {
            String normalizedGroup;
            int matchEnd = m.end();
            Matcher digitMatcher = CAPTURING_DIGIT_PATTERN.matcher(number.substring(matchEnd));
            if (digitMatcher.find() && (normalizedGroup = PhoneNumberUtil.normalizeDigitsOnly(digitMatcher.group(1))).equals("0")) {
                return false;
            }
            number.delete(0, matchEnd);
            return true;
        }
        return false;
    }

    Phonenumber.PhoneNumber.CountryCodeSource maybeStripInternationalPrefixAndNormalize(StringBuilder number, String possibleIddPrefix) {
        if (number.length() == 0) {
            return Phonenumber.PhoneNumber.CountryCodeSource.FROM_DEFAULT_COUNTRY;
        }
        Matcher m = PLUS_CHARS_PATTERN.matcher(number);
        if (m.lookingAt()) {
            number.delete(0, m.end());
            PhoneNumberUtil.normalize(number);
            return Phonenumber.PhoneNumber.CountryCodeSource.FROM_NUMBER_WITH_PLUS_SIGN;
        }
        Pattern iddPattern = this.regexCache.getPatternForRegex(possibleIddPrefix);
        PhoneNumberUtil.normalize(number);
        return this.parsePrefixAsIdd(iddPattern, number) ? Phonenumber.PhoneNumber.CountryCodeSource.FROM_NUMBER_WITH_IDD : Phonenumber.PhoneNumber.CountryCodeSource.FROM_DEFAULT_COUNTRY;
    }

    boolean maybeStripNationalPrefixAndCarrierCode(StringBuilder number, Phonemetadata.PhoneMetadata metadata, StringBuilder carrierCode) {
        int numberLength = number.length();
        String possibleNationalPrefix = metadata.getNationalPrefixForParsing();
        if (numberLength == 0 || possibleNationalPrefix.length() == 0) {
            return false;
        }
        Matcher prefixMatcher = this.regexCache.getPatternForRegex(possibleNationalPrefix).matcher(number);
        if (prefixMatcher.lookingAt()) {
            Pattern nationalNumberRule = this.regexCache.getPatternForRegex(metadata.getGeneralDesc().getNationalNumberPattern());
            boolean isViableOriginalNumber = nationalNumberRule.matcher(number).matches();
            int numOfGroups = prefixMatcher.groupCount();
            String transformRule = metadata.getNationalPrefixTransformRule();
            if (transformRule == null || transformRule.length() == 0 || prefixMatcher.group(numOfGroups) == null) {
                if (isViableOriginalNumber && !nationalNumberRule.matcher(number.substring(prefixMatcher.end())).matches()) {
                    return false;
                }
                if (carrierCode != null && numOfGroups > 0 && prefixMatcher.group(numOfGroups) != null) {
                    carrierCode.append(prefixMatcher.group(1));
                }
                number.delete(0, prefixMatcher.end());
                return true;
            }
            StringBuilder transformedNumber = new StringBuilder(number);
            transformedNumber.replace(0, numberLength, prefixMatcher.replaceFirst(transformRule));
            if (isViableOriginalNumber && !nationalNumberRule.matcher(transformedNumber.toString()).matches()) {
                return false;
            }
            if (carrierCode != null && numOfGroups > 1) {
                carrierCode.append(prefixMatcher.group(1));
            }
            number.replace(0, number.length(), transformedNumber.toString());
            return true;
        }
        return false;
    }

    String maybeStripExtension(StringBuilder number) {
        Matcher m = EXTN_PATTERN.matcher(number);
        if (m.find() && PhoneNumberUtil.isViablePhoneNumber(number.substring(0, m.start()))) {
            int length = m.groupCount();
            for (int i = 1; i <= length; ++i) {
                if (m.group(i) == null) continue;
                String extension = m.group(i);
                number.delete(m.start(), number.length());
                return extension;
            }
        }
        return "";
    }

    private boolean checkRegionForParsing(String numberToParse, String defaultRegion) {
        return this.isValidRegionCode(defaultRegion) || numberToParse != null && numberToParse.length() != 0 && PLUS_CHARS_PATTERN.matcher(numberToParse).lookingAt();
    }

    public Phonenumber.PhoneNumber parse(String numberToParse, String defaultRegion) throws NumberParseException {
        Phonenumber.PhoneNumber phoneNumber = new Phonenumber.PhoneNumber();
        this.parse(numberToParse, defaultRegion, phoneNumber);
        return phoneNumber;
    }

    public void parse(String numberToParse, String defaultRegion, Phonenumber.PhoneNumber phoneNumber) throws NumberParseException {
        this.parseHelper(numberToParse, defaultRegion, false, true, phoneNumber);
    }

    public Phonenumber.PhoneNumber parseAndKeepRawInput(String numberToParse, String defaultRegion) throws NumberParseException {
        Phonenumber.PhoneNumber phoneNumber = new Phonenumber.PhoneNumber();
        this.parseAndKeepRawInput(numberToParse, defaultRegion, phoneNumber);
        return phoneNumber;
    }

    public void parseAndKeepRawInput(String numberToParse, String defaultRegion, Phonenumber.PhoneNumber phoneNumber) throws NumberParseException {
        this.parseHelper(numberToParse, defaultRegion, true, true, phoneNumber);
    }

    public Iterable<PhoneNumberMatch> findNumbers(CharSequence text, String defaultRegion) {
        return this.findNumbers(text, defaultRegion, Leniency.VALID, Long.MAX_VALUE);
    }

    public Iterable<PhoneNumberMatch> findNumbers(final CharSequence text, final String defaultRegion, final Leniency leniency, final long maxTries) {
        return new Iterable<PhoneNumberMatch>(){

            @Override
            public Iterator<PhoneNumberMatch> iterator() {
                return new PhoneNumberMatcher(PhoneNumberUtil.this, text, defaultRegion, leniency, maxTries);
            }
        };
    }

    static void setItalianLeadingZerosForPhoneNumber(String nationalNumber, Phonenumber.PhoneNumber phoneNumber) {
        if (nationalNumber.length() > 1 && nationalNumber.charAt(0) == '0') {
            int numberOfLeadingZeros;
            phoneNumber.setItalianLeadingZero(true);
            for (numberOfLeadingZeros = 1; numberOfLeadingZeros < nationalNumber.length() - 1 && nationalNumber.charAt(numberOfLeadingZeros) == '0'; ++numberOfLeadingZeros) {
            }
            if (numberOfLeadingZeros != 1) {
                phoneNumber.setNumberOfLeadingZeros(numberOfLeadingZeros);
            }
        }
    }

    private void parseHelper(String numberToParse, String defaultRegion, boolean keepRawInput, boolean checkRegion, Phonenumber.PhoneNumber phoneNumber) throws NumberParseException {
        int lengthOfNationalNumber;
        String extension;
        if (numberToParse == null) {
            throw new NumberParseException(NumberParseException.ErrorType.NOT_A_NUMBER, "The phone number supplied was null.");
        }
        if (numberToParse.length() > 250) {
            throw new NumberParseException(NumberParseException.ErrorType.TOO_LONG, "The string supplied was too long to parse.");
        }
        StringBuilder nationalNumber = new StringBuilder();
        this.buildNationalNumberForParsing(numberToParse, nationalNumber);
        if (!PhoneNumberUtil.isViablePhoneNumber(nationalNumber.toString())) {
            throw new NumberParseException(NumberParseException.ErrorType.NOT_A_NUMBER, "The string supplied did not seem to be a phone number.");
        }
        if (checkRegion && !this.checkRegionForParsing(nationalNumber.toString(), defaultRegion)) {
            throw new NumberParseException(NumberParseException.ErrorType.INVALID_COUNTRY_CODE, "Missing or invalid default region.");
        }
        if (keepRawInput) {
            phoneNumber.setRawInput(numberToParse);
        }
        if ((extension = this.maybeStripExtension(nationalNumber)).length() > 0) {
            phoneNumber.setExtension(extension);
        }
        Phonemetadata.PhoneMetadata regionMetadata = this.getMetadataForRegion(defaultRegion);
        StringBuilder normalizedNationalNumber = new StringBuilder();
        int countryCode = 0;
        try {
            countryCode = this.maybeExtractCountryCode(nationalNumber.toString(), regionMetadata, normalizedNationalNumber, keepRawInput, phoneNumber);
        }
        catch (NumberParseException e) {
            Matcher matcher = PLUS_CHARS_PATTERN.matcher(nationalNumber.toString());
            if (e.getErrorType() == NumberParseException.ErrorType.INVALID_COUNTRY_CODE && matcher.lookingAt()) {
                countryCode = this.maybeExtractCountryCode(nationalNumber.substring(matcher.end()), regionMetadata, normalizedNationalNumber, keepRawInput, phoneNumber);
                if (countryCode == 0) {
                    throw new NumberParseException(NumberParseException.ErrorType.INVALID_COUNTRY_CODE, "Could not interpret numbers after plus-sign.");
                }
            }
            throw new NumberParseException(e.getErrorType(), e.getMessage());
        }
        if (countryCode != 0) {
            String phoneNumberRegion = this.getRegionCodeForCountryCode(countryCode);
            if (!phoneNumberRegion.equals(defaultRegion)) {
                regionMetadata = this.getMetadataForRegionOrCallingCode(countryCode, phoneNumberRegion);
            }
        } else {
            PhoneNumberUtil.normalize(nationalNumber);
            normalizedNationalNumber.append((CharSequence)nationalNumber);
            if (defaultRegion != null) {
                countryCode = regionMetadata.getCountryCode();
                phoneNumber.setCountryCode(countryCode);
            } else if (keepRawInput) {
                phoneNumber.clearCountryCodeSource();
            }
        }
        if (normalizedNationalNumber.length() < 2) {
            throw new NumberParseException(NumberParseException.ErrorType.TOO_SHORT_NSN, "The string supplied is too short to be a phone number.");
        }
        if (regionMetadata != null) {
            StringBuilder carrierCode = new StringBuilder();
            StringBuilder potentialNationalNumber = new StringBuilder(normalizedNationalNumber);
            this.maybeStripNationalPrefixAndCarrierCode(potentialNationalNumber, regionMetadata, carrierCode);
            if (!this.isShorterThanPossibleNormalNumber(regionMetadata, potentialNationalNumber.toString())) {
                normalizedNationalNumber = potentialNationalNumber;
                if (keepRawInput) {
                    phoneNumber.setPreferredDomesticCarrierCode(carrierCode.toString());
                }
            }
        }
        if ((lengthOfNationalNumber = normalizedNationalNumber.length()) < 2) {
            throw new NumberParseException(NumberParseException.ErrorType.TOO_SHORT_NSN, "The string supplied is too short to be a phone number.");
        }
        if (lengthOfNationalNumber > 16) {
            throw new NumberParseException(NumberParseException.ErrorType.TOO_LONG, "The string supplied is too long to be a phone number.");
        }
        PhoneNumberUtil.setItalianLeadingZerosForPhoneNumber(normalizedNationalNumber.toString(), phoneNumber);
        phoneNumber.setNationalNumber(Long.parseLong(normalizedNationalNumber.toString()));
    }

    private void buildNationalNumberForParsing(String numberToParse, StringBuilder nationalNumber) {
        int indexOfPhoneContext = numberToParse.indexOf(RFC3966_PHONE_CONTEXT);
        if (indexOfPhoneContext > 0) {
            int phoneContextStart = indexOfPhoneContext + RFC3966_PHONE_CONTEXT.length();
            if (numberToParse.charAt(phoneContextStart) == '+') {
                int phoneContextEnd = numberToParse.indexOf(59, phoneContextStart);
                if (phoneContextEnd > 0) {
                    nationalNumber.append(numberToParse.substring(phoneContextStart, phoneContextEnd));
                } else {
                    nationalNumber.append(numberToParse.substring(phoneContextStart));
                }
            }
            nationalNumber.append(numberToParse.substring(numberToParse.indexOf(RFC3966_PREFIX) + RFC3966_PREFIX.length(), indexOfPhoneContext));
        } else {
            nationalNumber.append(PhoneNumberUtil.extractPossibleNumber(numberToParse));
        }
        int indexOfIsdn = nationalNumber.indexOf(RFC3966_ISDN_SUBADDRESS);
        if (indexOfIsdn > 0) {
            nationalNumber.delete(indexOfIsdn, nationalNumber.length());
        }
    }

    public MatchType isNumberMatch(Phonenumber.PhoneNumber firstNumberIn, Phonenumber.PhoneNumber secondNumberIn) {
        Phonenumber.PhoneNumber firstNumber = new Phonenumber.PhoneNumber();
        firstNumber.mergeFrom(firstNumberIn);
        Phonenumber.PhoneNumber secondNumber = new Phonenumber.PhoneNumber();
        secondNumber.mergeFrom(secondNumberIn);
        firstNumber.clearRawInput();
        firstNumber.clearCountryCodeSource();
        firstNumber.clearPreferredDomesticCarrierCode();
        secondNumber.clearRawInput();
        secondNumber.clearCountryCodeSource();
        secondNumber.clearPreferredDomesticCarrierCode();
        if (firstNumber.hasExtension() && firstNumber.getExtension().length() == 0) {
            firstNumber.clearExtension();
        }
        if (secondNumber.hasExtension() && secondNumber.getExtension().length() == 0) {
            secondNumber.clearExtension();
        }
        if (firstNumber.hasExtension() && secondNumber.hasExtension() && !firstNumber.getExtension().equals(secondNumber.getExtension())) {
            return MatchType.NO_MATCH;
        }
        int firstNumberCountryCode = firstNumber.getCountryCode();
        int secondNumberCountryCode = secondNumber.getCountryCode();
        if (firstNumberCountryCode != 0 && secondNumberCountryCode != 0) {
            if (firstNumber.exactlySameAs(secondNumber)) {
                return MatchType.EXACT_MATCH;
            }
            if (firstNumberCountryCode == secondNumberCountryCode && this.isNationalNumberSuffixOfTheOther(firstNumber, secondNumber)) {
                return MatchType.SHORT_NSN_MATCH;
            }
            return MatchType.NO_MATCH;
        }
        firstNumber.setCountryCode(secondNumberCountryCode);
        if (firstNumber.exactlySameAs(secondNumber)) {
            return MatchType.NSN_MATCH;
        }
        if (this.isNationalNumberSuffixOfTheOther(firstNumber, secondNumber)) {
            return MatchType.SHORT_NSN_MATCH;
        }
        return MatchType.NO_MATCH;
    }

    private boolean isNationalNumberSuffixOfTheOther(Phonenumber.PhoneNumber firstNumber, Phonenumber.PhoneNumber secondNumber) {
        String secondNumberNationalNumber;
        String firstNumberNationalNumber = String.valueOf(firstNumber.getNationalNumber());
        return firstNumberNationalNumber.endsWith(secondNumberNationalNumber = String.valueOf(secondNumber.getNationalNumber())) || secondNumberNationalNumber.endsWith(firstNumberNationalNumber);
    }

    public MatchType isNumberMatch(String firstNumber, String secondNumber) {
        try {
            Phonenumber.PhoneNumber firstNumberAsProto = this.parse(firstNumber, UNKNOWN_REGION);
            return this.isNumberMatch(firstNumberAsProto, secondNumber);
        }
        catch (NumberParseException e) {
            block7: {
                if (e.getErrorType() == NumberParseException.ErrorType.INVALID_COUNTRY_CODE) {
                    try {
                        Phonenumber.PhoneNumber secondNumberAsProto = this.parse(secondNumber, UNKNOWN_REGION);
                        return this.isNumberMatch(secondNumberAsProto, firstNumber);
                    }
                    catch (NumberParseException e2) {
                        if (e2.getErrorType() != NumberParseException.ErrorType.INVALID_COUNTRY_CODE) break block7;
                        try {
                            Phonenumber.PhoneNumber firstNumberProto = new Phonenumber.PhoneNumber();
                            Phonenumber.PhoneNumber secondNumberProto = new Phonenumber.PhoneNumber();
                            this.parseHelper(firstNumber, null, false, false, firstNumberProto);
                            this.parseHelper(secondNumber, null, false, false, secondNumberProto);
                            return this.isNumberMatch(firstNumberProto, secondNumberProto);
                        }
                        catch (NumberParseException e3) {
                            // empty catch block
                        }
                    }
                }
            }
            return MatchType.NOT_A_NUMBER;
        }
    }

    public MatchType isNumberMatch(Phonenumber.PhoneNumber firstNumber, String secondNumber) {
        try {
            Phonenumber.PhoneNumber secondNumberAsProto = this.parse(secondNumber, UNKNOWN_REGION);
            return this.isNumberMatch(firstNumber, secondNumberAsProto);
        }
        catch (NumberParseException e) {
            if (e.getErrorType() == NumberParseException.ErrorType.INVALID_COUNTRY_CODE) {
                String firstNumberRegion = this.getRegionCodeForCountryCode(firstNumber.getCountryCode());
                try {
                    if (!firstNumberRegion.equals(UNKNOWN_REGION)) {
                        Phonenumber.PhoneNumber secondNumberWithFirstNumberRegion = this.parse(secondNumber, firstNumberRegion);
                        MatchType match = this.isNumberMatch(firstNumber, secondNumberWithFirstNumberRegion);
                        if (match == MatchType.EXACT_MATCH) {
                            return MatchType.NSN_MATCH;
                        }
                        return match;
                    }
                    Phonenumber.PhoneNumber secondNumberProto = new Phonenumber.PhoneNumber();
                    this.parseHelper(secondNumber, null, false, false, secondNumberProto);
                    return this.isNumberMatch(firstNumber, secondNumberProto);
                }
                catch (NumberParseException e2) {
                    // empty catch block
                }
            }
            return MatchType.NOT_A_NUMBER;
        }
    }

    boolean canBeInternationallyDialled(Phonenumber.PhoneNumber number) {
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegion(this.getRegionCodeForNumber(number));
        if (metadata == null) {
            return true;
        }
        String nationalSignificantNumber = this.getNationalSignificantNumber(number);
        return !this.isNumberMatchingDesc(nationalSignificantNumber, metadata.getNoInternationalDialling());
    }

    public boolean isMobileNumberPortableRegion(String regionCode) {
        Phonemetadata.PhoneMetadata metadata = this.getMetadataForRegion(regionCode);
        if (metadata == null) {
            logger.log(Level.WARNING, "Invalid or unknown region code provided: " + regionCode);
            return false;
        }
        return metadata.isMobileNumberPortableRegion();
    }

    static {
        HashMap<Integer, String> mobileTokenMap = new HashMap<Integer, String>();
        mobileTokenMap.put(52, "1");
        mobileTokenMap.put(54, "9");
        MOBILE_TOKEN_MAPPINGS = Collections.unmodifiableMap(mobileTokenMap);
        HashMap<Character, Character> asciiDigitMappings = new HashMap<Character, Character>();
        asciiDigitMappings.put(Character.valueOf('0'), Character.valueOf('0'));
        asciiDigitMappings.put(Character.valueOf('1'), Character.valueOf('1'));
        asciiDigitMappings.put(Character.valueOf('2'), Character.valueOf('2'));
        asciiDigitMappings.put(Character.valueOf('3'), Character.valueOf('3'));
        asciiDigitMappings.put(Character.valueOf('4'), Character.valueOf('4'));
        asciiDigitMappings.put(Character.valueOf('5'), Character.valueOf('5'));
        asciiDigitMappings.put(Character.valueOf('6'), Character.valueOf('6'));
        asciiDigitMappings.put(Character.valueOf('7'), Character.valueOf('7'));
        asciiDigitMappings.put(Character.valueOf('8'), Character.valueOf('8'));
        asciiDigitMappings.put(Character.valueOf('9'), Character.valueOf('9'));
        HashMap<Character, Character> alphaMap = new HashMap<Character, Character>(40);
        alphaMap.put(Character.valueOf('A'), Character.valueOf('2'));
        alphaMap.put(Character.valueOf('B'), Character.valueOf('2'));
        alphaMap.put(Character.valueOf('C'), Character.valueOf('2'));
        alphaMap.put(Character.valueOf('D'), Character.valueOf('3'));
        alphaMap.put(Character.valueOf('E'), Character.valueOf('3'));
        alphaMap.put(Character.valueOf('F'), Character.valueOf('3'));
        alphaMap.put(Character.valueOf('G'), Character.valueOf('4'));
        alphaMap.put(Character.valueOf('H'), Character.valueOf('4'));
        alphaMap.put(Character.valueOf('I'), Character.valueOf('4'));
        alphaMap.put(Character.valueOf('J'), Character.valueOf('5'));
        alphaMap.put(Character.valueOf('K'), Character.valueOf('5'));
        alphaMap.put(Character.valueOf('L'), Character.valueOf('5'));
        alphaMap.put(Character.valueOf('M'), Character.valueOf('6'));
        alphaMap.put(Character.valueOf('N'), Character.valueOf('6'));
        alphaMap.put(Character.valueOf('O'), Character.valueOf('6'));
        alphaMap.put(Character.valueOf('P'), Character.valueOf('7'));
        alphaMap.put(Character.valueOf('Q'), Character.valueOf('7'));
        alphaMap.put(Character.valueOf('R'), Character.valueOf('7'));
        alphaMap.put(Character.valueOf('S'), Character.valueOf('7'));
        alphaMap.put(Character.valueOf('T'), Character.valueOf('8'));
        alphaMap.put(Character.valueOf('U'), Character.valueOf('8'));
        alphaMap.put(Character.valueOf('V'), Character.valueOf('8'));
        alphaMap.put(Character.valueOf('W'), Character.valueOf('9'));
        alphaMap.put(Character.valueOf('X'), Character.valueOf('9'));
        alphaMap.put(Character.valueOf('Y'), Character.valueOf('9'));
        alphaMap.put(Character.valueOf('Z'), Character.valueOf('9'));
        ALPHA_MAPPINGS = Collections.unmodifiableMap(alphaMap);
        HashMap<Character, Character> combinedMap = new HashMap<Character, Character>(100);
        combinedMap.putAll(ALPHA_MAPPINGS);
        combinedMap.putAll(asciiDigitMappings);
        ALPHA_PHONE_MAPPINGS = Collections.unmodifiableMap(combinedMap);
        HashMap<Character, Character> diallableCharMap = new HashMap<Character, Character>();
        diallableCharMap.putAll(asciiDigitMappings);
        diallableCharMap.put(Character.valueOf('+'), Character.valueOf('+'));
        diallableCharMap.put(Character.valueOf('*'), Character.valueOf('*'));
        DIALLABLE_CHAR_MAPPINGS = Collections.unmodifiableMap(diallableCharMap);
        HashMap<Character, Character> allPlusNumberGroupings = new HashMap<Character, Character>();
        for (char c : ALPHA_MAPPINGS.keySet()) {
            allPlusNumberGroupings.put(Character.valueOf(Character.toLowerCase(c)), Character.valueOf(c));
            allPlusNumberGroupings.put(Character.valueOf(c), Character.valueOf(c));
        }
        allPlusNumberGroupings.putAll(asciiDigitMappings);
        allPlusNumberGroupings.put(Character.valueOf('-'), Character.valueOf('-'));
        allPlusNumberGroupings.put(Character.valueOf('\uff0d'), Character.valueOf('-'));
        allPlusNumberGroupings.put(Character.valueOf('\u2010'), Character.valueOf('-'));
        allPlusNumberGroupings.put(Character.valueOf('\u2011'), Character.valueOf('-'));
        allPlusNumberGroupings.put(Character.valueOf('\u2012'), Character.valueOf('-'));
        allPlusNumberGroupings.put(Character.valueOf('\u2013'), Character.valueOf('-'));
        allPlusNumberGroupings.put(Character.valueOf('\u2014'), Character.valueOf('-'));
        allPlusNumberGroupings.put(Character.valueOf('\u2015'), Character.valueOf('-'));
        allPlusNumberGroupings.put(Character.valueOf('\u2212'), Character.valueOf('-'));
        allPlusNumberGroupings.put(Character.valueOf('/'), Character.valueOf('/'));
        allPlusNumberGroupings.put(Character.valueOf('\uff0f'), Character.valueOf('/'));
        allPlusNumberGroupings.put(Character.valueOf(' '), Character.valueOf(' '));
        allPlusNumberGroupings.put(Character.valueOf('\u3000'), Character.valueOf(' '));
        allPlusNumberGroupings.put(Character.valueOf('\u2060'), Character.valueOf(' '));
        allPlusNumberGroupings.put(Character.valueOf('.'), Character.valueOf('.'));
        allPlusNumberGroupings.put(Character.valueOf('\uff0e'), Character.valueOf('.'));
        ALL_PLUS_NUMBER_GROUPING_SYMBOLS = Collections.unmodifiableMap(allPlusNumberGroupings);
        UNIQUE_INTERNATIONAL_PREFIX = Pattern.compile("[\\d]+(?:[~\u2053\u223c\uff5e][\\d]+)?");
        VALID_ALPHA = Arrays.toString(ALPHA_MAPPINGS.keySet().toArray()).replaceAll("[, \\[\\]]", "") + Arrays.toString(ALPHA_MAPPINGS.keySet().toArray()).toLowerCase().replaceAll("[, \\[\\]]", "");
        PLUS_CHARS_PATTERN = Pattern.compile("[+\uff0b]+");
        SEPARATOR_PATTERN = Pattern.compile("[-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u00ad\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e]+");
        CAPTURING_DIGIT_PATTERN = Pattern.compile("(\\p{Nd})");
        VALID_START_CHAR_PATTERN = Pattern.compile(VALID_START_CHAR);
        SECOND_NUMBER_START_PATTERN = Pattern.compile(SECOND_NUMBER_START);
        UNWANTED_END_CHAR_PATTERN = Pattern.compile(UNWANTED_END_CHARS);
        VALID_ALPHA_PHONE_PATTERN = Pattern.compile("(?:.*?[A-Za-z]){3}.*");
        VALID_PHONE_NUMBER = "\\p{Nd}{2}|[+\uff0b]*+(?:[-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u00ad\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e*]*\\p{Nd}){3,}[-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u00ad\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e*" + VALID_ALPHA + DIGITS + "]*";
        String singleExtnSymbolsForMatching = "x\uff58#\uff03~\uff5e";
        String singleExtnSymbolsForParsing = "," + singleExtnSymbolsForMatching;
        EXTN_PATTERNS_FOR_PARSING = PhoneNumberUtil.createExtnPattern(singleExtnSymbolsForParsing);
        EXTN_PATTERNS_FOR_MATCHING = PhoneNumberUtil.createExtnPattern(singleExtnSymbolsForMatching);
        EXTN_PATTERN = Pattern.compile("(?:" + EXTN_PATTERNS_FOR_PARSING + ")$", 66);
        VALID_PHONE_NUMBER_PATTERN = Pattern.compile(VALID_PHONE_NUMBER + "(?:" + EXTN_PATTERNS_FOR_PARSING + ")?", 66);
        NON_DIGITS_PATTERN = Pattern.compile("(\\D+)");
        FIRST_GROUP_PATTERN = Pattern.compile("(\\$\\d)");
        NP_PATTERN = Pattern.compile("\\$NP");
        FG_PATTERN = Pattern.compile("\\$FG");
        CC_PATTERN = Pattern.compile("\\$CC");
        FIRST_GROUP_ONLY_PREFIX_PATTERN = Pattern.compile("\\(?\\$1\\)?");
        instance = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Leniency {
        POSSIBLE{

            boolean verify(Phonenumber.PhoneNumber number, String candidate, PhoneNumberUtil util) {
                return util.isPossibleNumber(number);
            }
        }
        ,
        VALID{

            boolean verify(Phonenumber.PhoneNumber number, String candidate, PhoneNumberUtil util) {
                if (!util.isValidNumber(number) || !PhoneNumberMatcher.containsOnlyValidXChars(number, candidate, util)) {
                    return false;
                }
                return PhoneNumberMatcher.isNationalPrefixPresentIfRequired(number, util);
            }
        }
        ,
        STRICT_GROUPING{

            boolean verify(Phonenumber.PhoneNumber number, String candidate, PhoneNumberUtil util) {
                if (!util.isValidNumber(number) || !PhoneNumberMatcher.containsOnlyValidXChars(number, candidate, util) || PhoneNumberMatcher.containsMoreThanOneSlashInNationalNumber(number, candidate) || !PhoneNumberMatcher.isNationalPrefixPresentIfRequired(number, util)) {
                    return false;
                }
                return PhoneNumberMatcher.checkNumberGroupingIsValid(number, candidate, util, new PhoneNumberMatcher.NumberGroupingChecker(){

                    public boolean checkGroups(PhoneNumberUtil util, Phonenumber.PhoneNumber number, StringBuilder normalizedCandidate, String[] expectedNumberGroups) {
                        return PhoneNumberMatcher.allNumberGroupsRemainGrouped(util, number, normalizedCandidate, expectedNumberGroups);
                    }
                });
            }
        }
        ,
        EXACT_GROUPING{

            boolean verify(Phonenumber.PhoneNumber number, String candidate, PhoneNumberUtil util) {
                if (!util.isValidNumber(number) || !PhoneNumberMatcher.containsOnlyValidXChars(number, candidate, util) || PhoneNumberMatcher.containsMoreThanOneSlashInNationalNumber(number, candidate) || !PhoneNumberMatcher.isNationalPrefixPresentIfRequired(number, util)) {
                    return false;
                }
                return PhoneNumberMatcher.checkNumberGroupingIsValid(number, candidate, util, new PhoneNumberMatcher.NumberGroupingChecker(){

                    public boolean checkGroups(PhoneNumberUtil util, Phonenumber.PhoneNumber number, StringBuilder normalizedCandidate, String[] expectedNumberGroups) {
                        return PhoneNumberMatcher.allNumberGroupsAreExactlyPresent(util, number, normalizedCandidate, expectedNumberGroups);
                    }
                });
            }
        };


        abstract boolean verify(Phonenumber.PhoneNumber var1, String var2, PhoneNumberUtil var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValidationResult {
        IS_POSSIBLE,
        INVALID_COUNTRY_CODE,
        TOO_SHORT,
        TOO_LONG;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MatchType {
        NOT_A_NUMBER,
        NO_MATCH,
        SHORT_NSN_MATCH,
        NSN_MATCH,
        EXACT_MATCH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PhoneNumberType {
        FIXED_LINE,
        MOBILE,
        FIXED_LINE_OR_MOBILE,
        TOLL_FREE,
        PREMIUM_RATE,
        SHARED_COST,
        VOIP,
        PERSONAL_NUMBER,
        PAGER,
        UAN,
        VOICEMAIL,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PhoneNumberFormat {
        E164,
        INTERNATIONAL,
        NATIONAL,
        RFC3966;

    }
}

