/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.java.sip.communicator.impl.gui.main.UINotification;
import net.java.sip.communicator.impl.gui.main.UINotificationManager;

public class UINotificationGroup {
    private Collection<UINotification> unreadNotifications = new ArrayList<UINotification>();
    private final String groupName;
    private final String groupDisplayName;

    public UINotificationGroup(String groupName, String groupDisplayName) {
        this.groupName = groupName;
        this.groupDisplayName = groupDisplayName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroupDisplayName() {
        return this.groupDisplayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotification(UINotification notification) {
        Collection<UINotification> collection = this.unreadNotifications;
        synchronized (collection) {
            this.unreadNotifications.remove(notification);
            this.unreadNotifications.add(notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllNotifications() {
        Collection<UINotification> collection = this.unreadNotifications;
        synchronized (collection) {
            ArrayList<UINotification> copy = new ArrayList<UINotification>(this.unreadNotifications);
            this.unreadNotifications.clear();
            for (UINotification n : copy) {
                UINotificationManager.fireClearedEvent(n);
            }
        }
    }

    public Iterator<UINotification> getUnreadNotifications() {
        return new ArrayList<UINotification>(this.unreadNotifications).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnreadNotificationsCount() {
        Collection<UINotification> collection = this.unreadNotifications;
        synchronized (collection) {
            int count = 0;
            for (UINotification n : this.unreadNotifications) {
                count += n.getUnreadObjects();
            }
            return count;
        }
    }
}

