/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call.conference;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.event.ConferencePeerViewEvent;
import net.java.sip.communicator.impl.gui.main.call.CallPanel;
import net.java.sip.communicator.impl.gui.main.call.ConferenceCallPeerRenderer;
import net.java.sip.communicator.impl.gui.main.call.SwingCallPeerRenderer;
import net.java.sip.communicator.impl.gui.main.call.SwingCallRenderer;
import net.java.sip.communicator.impl.gui.main.call.conference.ConferencePeerViewListener;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceAdapter;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceListener;
import net.java.sip.communicator.service.protocol.event.CallPeerEvent;

public abstract class BasicConferenceCallPanel
extends JPanel
implements SwingCallRenderer {
    protected final CallPanel callPanel;
    protected final CallConference callConference;
    private final CallConferenceListener callConferenceListener = new CallConferenceListener();
    private final Map<CallPeer, ConferenceCallPeerRenderer> callPeerPanels = new HashMap<CallPeer, ConferenceCallPeerRenderer>();
    private Map<CallPeer, Timer> delayedCallPeers = new HashMap<CallPeer, Timer>();
    private boolean disposed = false;
    private List<ConferencePeerViewListener> peerViewListeners = new ArrayList<ConferencePeerViewListener>();
    private final Runnable updateViewFromModelInEventDispatchThread = new Runnable(){

        @Override
        public void run() {
            if (!BasicConferenceCallPanel.this.disposed) {
                BasicConferenceCallPanel.this.updateViewFromModelInEventDispatchThread();
            }
        }
    };

    protected BasicConferenceCallPanel(CallPanel callPanel, CallConference callConference) {
        super(new BorderLayout());
        this.callPanel = callPanel;
        this.callConference = callConference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDelayedCallPeer(final CallPeer peer) {
        Timer timer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                BasicConferenceCallPanel.this.removeDelayedCallPeer(peer, false);
                BasicConferenceCallPanel.this.updateViewFromModel();
            }
        });
        Map<CallPeer, Timer> map = this.delayedCallPeers;
        synchronized (map) {
            this.delayedCallPeers.put(peer, timer);
        }
        timer.setRepeats(false);
        timer.start();
    }

    public void addPeerViewlListener(ConferencePeerViewListener listener) {
        if (!this.peerViewListeners.contains(listener)) {
            this.peerViewListeners.add(listener);
        }
    }

    protected void callPeerAdded(CallPeerEvent ev) {
        this.updateViewFromModel();
    }

    protected void callPeerRemoved(CallPeerEvent ev) {
        CallPeer peer = ev.getSourceCallPeer();
        if (ev.isDelayed()) {
            this.addDelayedCallPeer(peer);
        } else {
            if (this.delayedCallPeers.containsKey(peer)) {
                this.removeDelayedCallPeer(peer, false);
            }
            this.updateViewFromModel();
        }
    }

    protected void callStateChanged(CallChangeEvent ev) {
        this.updateViewFromModel();
    }

    protected void conferenceFocusChanged(CallPeerConferenceEvent ev) {
        this.updateViewFromModel();
    }

    protected void conferenceMemberAdded(CallPeerConferenceEvent ev) {
        this.updateViewFromModel();
    }

    protected void conferenceMemberErrorReceived(CallPeerConferenceEvent ev) {
        CallPeer callPeer = ev.getSourceCallPeer();
        this.callPeerPanels.get(callPeer).setErrorReason(GuiActivator.getResources().getI18NString("service.gui.PROBLEMS_ENCOUNTERED"));
        GuiActivator.getAlertUIService().showAlertPopup(GuiActivator.getResources().getI18NString("service.gui.ERROR_RECEIVED_FROM", new String[]{callPeer.getDisplayName()}), ev.getErrorString());
    }

    protected void conferenceMemberRemoved(CallPeerConferenceEvent ev) {
        this.updateViewFromModel();
    }

    public void dispose() {
        this.disposed = true;
        this.callConference.removeCallChangeListener((CallChangeListener)this.callConferenceListener);
        this.callConference.removeCallPeerConferenceListener((CallPeerConferenceListener)this.callConferenceListener);
        for (ConferenceCallPeerRenderer callPeerPanel : this.callPeerPanels.values()) {
            callPeerPanel.dispose();
        }
    }

    public void fireConferencePeerViewEvent(int eventID, CallPeer callPeer, ConferenceCallPeerRenderer callPeerView) {
        for (ConferencePeerViewListener listener : this.peerViewListeners) {
            listener.peerViewRemoved(new ConferencePeerViewEvent(eventID, callPeer, callPeerView));
        }
    }

    @Override
    public CallPanel getCallContainer() {
        return this.callPanel;
    }

    public SwingCallPeerRenderer getCallPeerRenderer(CallPeer callPeer) {
        return this.callPeerPanels.get(callPeer);
    }

    public boolean hasDelayedCallPeers() {
        return !this.delayedCallPeers.isEmpty();
    }

    protected void initializeComplete() {
        this.callConference.addCallChangeListener((CallChangeListener)this.callConferenceListener);
        this.callConference.addCallPeerConferenceListener((CallPeerConferenceListener)this.callConferenceListener);
        this.updateViewFromModel();
    }

    protected final boolean isDisposed() {
        return this.disposed;
    }

    protected void onCallPeerConferenceEvent(CallPeerConferenceEvent ev) {
        switch (ev.getEventID()) {
            case 1: {
                this.conferenceFocusChanged(ev);
                break;
            }
            case 2: {
                this.conferenceMemberAdded(ev);
                break;
            }
            case 3: {
                this.conferenceMemberRemoved(ev);
                break;
            }
            default: {
                throw new IllegalArgumentException("CallPeerConferenceEvent.getEventID");
            }
        }
    }

    protected void onCallPeerEvent(CallPeerEvent ev) {
        switch (ev.getEventID()) {
            case 1: {
                this.callPeerAdded(ev);
                break;
            }
            case 2: {
                this.callPeerRemoved(ev);
                break;
            }
            default: {
                throw new IllegalArgumentException("CallPeerEvent.getEventID");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDelayedCallPeer(CallPeer peer, boolean stopTimer) {
        Timer timer;
        if (stopTimer && (timer = this.delayedCallPeers.get(peer)) != null) {
            timer.stop();
        }
        Map<CallPeer, Timer> map = this.delayedCallPeers;
        synchronized (map) {
            this.delayedCallPeers.remove(peer);
        }
    }

    public void removePeerViewListener(ConferencePeerViewListener listener) {
        this.peerViewListeners.remove(listener);
    }

    protected void updateViewFromModel() {
        if (!this.disposed) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.updateViewFromModelInEventDispatchThread();
            } else {
                SwingUtilities.invokeLater(this.updateViewFromModelInEventDispatchThread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateViewFromModel(CallPeer callPeer) {
        ConferenceCallPeerRenderer newCallPeerPanel;
        ConferenceCallPeerRenderer oldCallPeerPanel = this.callPeerPanels.get(callPeer);
        if (oldCallPeerPanel != (newCallPeerPanel = this.updateViewFromModel(oldCallPeerPanel, callPeer))) {
            if (oldCallPeerPanel != null) {
                this.callPeerPanels.remove(callPeer);
                try {
                    this.viewForModelRemoved(oldCallPeerPanel, callPeer);
                }
                finally {
                    oldCallPeerPanel.dispose();
                }
            }
            if (newCallPeerPanel != null) {
                this.callPeerPanels.put(callPeer, newCallPeerPanel);
                this.viewForModelAdded(newCallPeerPanel, callPeer);
            }
        }
    }

    protected abstract ConferenceCallPeerRenderer updateViewFromModel(ConferenceCallPeerRenderer var1, CallPeer var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateViewFromModelInEventDispatchThread() {
        if (this.disposed) {
            return;
        }
        this.updateViewFromModel(null);
        List callPeers = this.callConference.getCallPeers();
        Iterator<Map.Entry<CallPeer, ConferenceCallPeerRenderer>> entryIter = this.callPeerPanels.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry<CallPeer, ConferenceCallPeerRenderer> entry = entryIter.next();
            CallPeer callPeer = entry.getKey();
            if (callPeer == null || callPeers.contains(callPeer) || this.delayedCallPeers.containsKey(callPeer)) continue;
            ConferenceCallPeerRenderer callPeerPanel = entry.getValue();
            entryIter.remove();
            this.fireConferencePeerViewEvent(2, callPeer, callPeerPanel);
            try {
                this.viewForModelRemoved(callPeerPanel, callPeer);
            }
            finally {
                callPeerPanel.dispose();
            }
        }
        for (CallPeer callPeer : callPeers) {
            this.updateViewFromModel(callPeer);
        }
    }

    protected abstract void viewForModelAdded(ConferenceCallPeerRenderer var1, CallPeer var2);

    protected abstract void viewForModelRemoved(ConferenceCallPeerRenderer var1, CallPeer var2);

    public void startCallTimer() {
        this.callPanel.startCallTimer();
    }

    public void stopCallTimer() {
        this.callPanel.stopCallTimer();
    }

    public boolean isCallTimerStarted() {
        return this.callPanel.isCallTimerStarted();
    }

    public void updateHoldButtonState() {
        this.callPanel.updateHoldButtonState();
    }

    private class CallConferenceListener
    extends CallPeerConferenceAdapter
    implements CallChangeListener {
        private CallConferenceListener() {
        }

        public void callPeerAdded(CallPeerEvent ev) {
            BasicConferenceCallPanel.this.onCallPeerEvent(ev);
        }

        public void callPeerRemoved(CallPeerEvent ev) {
            BasicConferenceCallPanel.this.onCallPeerEvent(ev);
        }

        public void callStateChanged(CallChangeEvent ev) {
            BasicConferenceCallPanel.this.callStateChanged(ev);
        }

        public void conferenceMemberErrorReceived(CallPeerConferenceEvent ev) {
            BasicConferenceCallPanel.this.conferenceMemberErrorReceived(ev);
        }

        protected void onCallPeerConferenceEvent(CallPeerConferenceEvent ev) {
            BasicConferenceCallPanel.this.onCallPeerConferenceEvent(ev);
        }
    }
}

