/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.util.Hashtable;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipAccountIDImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ProtocolProviderFactorySipImpl
extends ProtocolProviderFactory {
    private static final Logger logger = Logger.getLogger(ProtocolProviderFactorySipImpl.class);

    public ProtocolProviderFactorySipImpl() {
        super(SipActivator.getBundleContext(), "SIP");
    }

    protected void storeAccount(AccountID accountID) {
        this.storeXCapPassword(accountID);
        super.storeAccount(accountID);
    }

    private void storeXCapPassword(AccountID accountID) {
        String password = accountID.getAccountPropertyString((Object)"OPT_CLIST_PASSWORD");
        if (password != null) {
            CredentialsStorageService credentialsStorage = (CredentialsStorageService)ServiceUtils.getService((BundleContext)this.getBundleContext(), CredentialsStorageService.class);
            String accountPrefix = accountID.getAccountUniqueID() + ".xcap";
            credentialsStorage.storePassword(accountPrefix, password);
            accountID.removeAccountProperty("OPT_CLIST_PASSWORD");
        }
    }

    public AccountID installAccount(String userIDStr, Map<String, String> accountProperties) {
        AccountID accountID;
        BundleContext context = SipActivator.getBundleContext();
        if (context == null) {
            throw new NullPointerException("The specified BundleContext was null");
        }
        if (userIDStr == null) {
            throw new NullPointerException("The specified AccountID was null");
        }
        if (accountProperties == null) {
            throw new NullPointerException("The specified property map was null");
        }
        accountProperties.put("USER_ID", userIDStr);
        if (!accountProperties.containsKey("PROTOCOL_NAME")) {
            accountProperties.put("PROTOCOL_NAME", "SIP");
        }
        if (this.registeredAccounts.containsKey(accountID = this.createAccountID(userIDStr, accountProperties))) {
            throw new IllegalStateException("An account for id " + userIDStr + " was already installed!");
        }
        this.storeAccount(accountID, false);
        try {
            accountID = this.loadAccount(accountProperties);
        }
        catch (RuntimeException exc) {
            this.removeStoredAccount(accountID);
            throw exc;
        }
        return accountID;
    }

    public void modifyAccount(ProtocolProviderService protocolProvider, Map<String, String> accountProperties) {
        BundleContext context = SipActivator.getBundleContext();
        if (context == null) {
            throw new NullPointerException("The specified BundleContext was null");
        }
        if (protocolProvider == null) {
            throw new NullPointerException("The specified Protocol Provider was null");
        }
        SipAccountIDImpl accountID = (SipAccountIDImpl)protocolProvider.getAccountID();
        if (!this.registeredAccounts.containsKey((Object)accountID)) {
            return;
        }
        ServiceRegistration registration = (ServiceRegistration)this.registeredAccounts.get((Object)accountID);
        if (registration != null) {
            try {
                protocolProvider.shutdown();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            registration.unregister();
        }
        if (accountProperties == null) {
            throw new NullPointerException("The specified property map was null");
        }
        if (!accountProperties.containsKey("PROTOCOL_NAME")) {
            accountProperties.put("PROTOCOL_NAME", "SIP");
        }
        Map oldAcccountProps = accountID.getAccountProperties();
        accountID.setAccountProperties(accountProperties);
        this.storeAccount((AccountID)accountID);
        String userIDStr = accountProperties.get("USER_ID");
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("PROTOCOL_NAME", "SIP");
        properties.put("USER_ID", userIDStr);
        try {
            Exception initializationException = null;
            try {
                ((ProtocolProviderServiceSipImpl)protocolProvider).initialize(userIDStr, accountID);
            }
            catch (Exception ex) {
                initializationException = ex;
                accountID.setAccountProperties(oldAcccountProps);
            }
            this.storeAccount((AccountID)accountID);
            registration = context.registerService(ProtocolProviderService.class.getName(), (Object)protocolProvider, properties);
            this.registeredAccounts.put(accountID, registration);
            if (initializationException != null) {
                throw initializationException;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to initialize account", (Throwable)ex);
            throw new IllegalArgumentException("Failed to initialize account. " + ex.getMessage());
        }
    }

    protected AccountID createAccountID(String userID, Map<String, String> accountProperties) {
        String serverAddress = accountProperties.get("SERVER_ADDRESS");
        return new SipAccountIDImpl(userID, accountProperties, serverAddress);
    }

    protected ProtocolProviderService createService(String userID, AccountID accountID) {
        ProtocolProviderServiceSipImpl service = new ProtocolProviderServiceSipImpl();
        try {
            service.initialize(userID, (SipAccountIDImpl)accountID);
            this.storeAccount(accountID);
        }
        catch (OperationFailedException ex) {
            logger.error((Object)"Failed to initialize account", (Throwable)ex);
            throw new IllegalArgumentException("Failed to initialize account" + ex.getMessage());
        }
        return service;
    }
}

