/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.irc.ChatRoomMemberIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.MessageIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.Mode;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.exception.BadCommandException;
import net.java.sip.communicator.impl.protocol.irc.exception.BadCommandInvocationException;
import net.java.sip.communicator.impl.protocol.irc.exception.UnsupportedCommandException;
import net.java.sip.communicator.service.protocol.AbstractChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomConfigurationForm;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPresenceListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPropertyChangeListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberRoleChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomPropertyChangeFailedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomPropertyChangeListener;
import net.java.sip.communicator.util.Logger;

public class ChatRoomIrcImpl
extends AbstractChatRoom {
    private static final char DEFAULT_CHANNEL_PREFIX = '#';
    private static final int MAXIMUM_LENGTH_OF_CHANNEL_NAME = 200;
    private static final Logger LOGGER = Logger.getLogger(ChatRoomIrcImpl.class);
    private final ProtocolProviderServiceIrcImpl parentProvider;
    private final String chatRoomName;
    private String chatSubject = "";
    private final Hashtable<String, ChatRoomMember> chatRoomMembers = new Hashtable();
    private final Vector<ChatRoomMemberPresenceListener> memberListeners = new Vector();
    private final Vector<ChatRoomMemberRoleListener> memberRoleListeners = new Vector();
    private final Vector<ChatRoomLocalUserRoleListener> localUserRoleListeners = new Vector();
    private final Vector<ChatRoomMessageListener> messageListeners = new Vector();
    private final Vector<ChatRoomPropertyChangeListener> propertyChangeListeners = new Vector();
    private final Vector<ChatRoomMemberPropertyChangeListener> memberPropChangeListeners = new Vector();
    private ArrayList<ChatRoomMember> bannedMembers = new ArrayList();
    private boolean isSystem = false;
    private ChatRoomMemberIrcImpl user = null;

    public ChatRoomIrcImpl(String chatRoomName, ProtocolProviderServiceIrcImpl parentProvider) {
        this(chatRoomName, parentProvider, false);
    }

    public ChatRoomIrcImpl(String chatRoomName, ProtocolProviderServiceIrcImpl parentProvider, boolean isSystem) {
        if (parentProvider == null) {
            throw new IllegalArgumentException("parentProvider cannot be null");
        }
        this.parentProvider = parentProvider;
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        this.chatRoomName = ChatRoomIrcImpl.verifyName(connection.getChannelManager().getChannelTypes(), chatRoomName);
        this.isSystem = isSystem;
    }

    private static String verifyName(Set<Character> channelTypes, String name) {
        if (name == null || name.isEmpty() || name.length() > 200) {
            throw new IllegalArgumentException("Invalid chat room name.");
        }
        char prefix = name.charAt(0);
        if (channelTypes.contains(Character.valueOf(prefix)) || prefix == '#') {
            for (char c : IrcConnection.SPECIAL_CHARACTERS) {
                if (!name.contains("" + c)) continue;
                throw new IllegalArgumentException("chat room identifier contains illegal character: " + c);
            }
            return name;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"Automatically added # channel prefix.");
        }
        return ChatRoomIrcImpl.verifyName(channelTypes, '#' + name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.chatRoomName.hashCode();
        result = 31 * result + ((Object)((Object)this.parentProvider)).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ChatRoomIrcImpl other = (ChatRoomIrcImpl)((Object)obj);
        if (!((Object)((Object)this.parentProvider)).equals((Object)other.parentProvider)) {
            return false;
        }
        return this.chatRoomName.equals(other.chatRoomName);
    }

    public String getName() {
        return this.chatRoomName;
    }

    public String getIdentifier() {
        return this.chatRoomName;
    }

    protected void addChatRoomMember(String memberID, ChatRoomMember member) {
        this.chatRoomMembers.put(memberID, member);
    }

    protected void removeChatRoomMember(String memberID) {
        this.chatRoomMembers.remove(memberID);
    }

    public void join() throws OperationFailedException {
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null || !connection.isConnected()) {
            throw new OperationFailedException("We are currently not connected to the server.", 2);
        }
        if (connection.getChannelManager().isJoined(this)) {
            throw new OperationFailedException("Channel is already joined.", 5);
        }
        try {
            connection.getChannelManager().join(this);
        }
        catch (IllegalArgumentException e) {
            throw new OperationFailedException(e.getMessage(), 14, (Throwable)e);
        }
    }

    public void join(byte[] password) throws OperationFailedException {
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null) {
            throw new OperationFailedException("We are currently not connected to the server.", 2);
        }
        if (connection.getChannelManager().isJoined(this)) {
            throw new OperationFailedException("Channel is already joined.", 5);
        }
        try {
            connection.getChannelManager().join(this, password.toString());
        }
        catch (IllegalArgumentException e) {
            throw new OperationFailedException(e.getMessage(), 14, (Throwable)e);
        }
    }

    public void joinAs(String nickname) throws OperationFailedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Not setting nick name upon chat room join, since a nick change is not limited to a single chat room.");
        }
        this.join();
    }

    public void joinAs(String nickname, byte[] password) throws OperationFailedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Not setting nick name upon chat room join, since a nick change is not limited to a single chat room.");
        }
        this.join(password);
    }

    public boolean isJoined() {
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        return connection != null && connection.getChannelManager().isJoined(this);
    }

    public void leave() {
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null) {
            return;
        }
        connection.getChannelManager().leave(this);
        this.chatRoomMembers.clear();
    }

    public Iterator<ChatRoomMember> getBanList() throws OperationFailedException {
        return this.bannedMembers.iterator();
    }

    public void banParticipant(ChatRoomMember chatRoomMember, String reason) throws OperationFailedException {
        if (!(chatRoomMember instanceof ChatRoomMemberIrcImpl)) {
            LOGGER.trace((Object)("Cannot ban chat room member that is not an instance of " + ChatRoomMemberIrcImpl.class.getCanonicalName()));
            return;
        }
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        connection.getChannelManager().banParticipant(this, (ChatRoomMemberIrcImpl)chatRoomMember, reason);
    }

    public void kickParticipant(ChatRoomMember chatRoomMember, String reason) throws OperationFailedException {
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        connection.getChannelManager().kickParticipant(this, chatRoomMember, reason);
    }

    public ChatRoomConfigurationForm getConfigurationForm() throws OperationFailedException {
        throw new OperationFailedException("The configuration form is not yet implemented for irc.", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(ChatRoomPropertyChangeListener listener) {
        Vector<ChatRoomPropertyChangeListener> vector = this.propertyChangeListeners;
        synchronized (vector) {
            if (!this.propertyChangeListeners.contains(listener)) {
                this.propertyChangeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(ChatRoomPropertyChangeListener listener) {
        Vector<ChatRoomPropertyChangeListener> vector = this.propertyChangeListeners;
        synchronized (vector) {
            this.propertyChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberPropertyChangeListener(ChatRoomMemberPropertyChangeListener listener) {
        Vector<ChatRoomMemberPropertyChangeListener> vector = this.memberPropChangeListeners;
        synchronized (vector) {
            if (!this.memberPropChangeListeners.contains(listener)) {
                this.memberPropChangeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberPropertyChangeListener(ChatRoomMemberPropertyChangeListener listener) {
        Vector<ChatRoomMemberPropertyChangeListener> vector = this.memberPropChangeListeners;
        synchronized (vector) {
            this.memberPropChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberRoleListener(ChatRoomMemberRoleListener listener) {
        Vector<ChatRoomMemberRoleListener> vector = this.memberRoleListeners;
        synchronized (vector) {
            if (!this.memberRoleListeners.contains(listener)) {
                this.memberRoleListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberRoleListener(ChatRoomMemberRoleListener listener) {
        Vector<ChatRoomMemberRoleListener> vector = this.memberRoleListeners;
        synchronized (vector) {
            if (this.memberRoleListeners.contains(listener)) {
                this.memberRoleListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalUserRoleListener(ChatRoomLocalUserRoleListener listener) {
        Vector<ChatRoomLocalUserRoleListener> vector = this.localUserRoleListeners;
        synchronized (vector) {
            if (!this.localUserRoleListeners.contains(listener)) {
                this.localUserRoleListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removelocalUserRoleListener(ChatRoomLocalUserRoleListener listener) {
        Vector<ChatRoomLocalUserRoleListener> vector = this.localUserRoleListeners;
        synchronized (vector) {
            if (this.localUserRoleListeners.contains(listener)) {
                this.localUserRoleListeners.remove(listener);
            }
        }
    }

    public String getSubject() {
        return this.chatSubject;
    }

    public void setSubject(String subject) throws OperationFailedException {
        try {
            IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
            if (connection == null) {
                throw new IllegalStateException("Connection is not available.");
            }
            connection.getChannelManager().setSubject(this, subject);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw new OperationFailedException("Failed to change subject.", 2, e.getCause());
            }
            throw new OperationFailedException("Failed to change subject.", 1, (Throwable)e);
        }
    }

    public String getUserNickname() {
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        return connection.getIdentityManager().getNick();
    }

    public void setUserNickname(String nickName) throws OperationFailedException {
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null) {
            throw new OperationFailedException("IRC connection is not established.", 2);
        }
        connection.getIdentityManager().setNick(nickName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberPresenceListener(ChatRoomMemberPresenceListener listener) {
        Vector<ChatRoomMemberPresenceListener> vector = this.memberListeners;
        synchronized (vector) {
            if (!this.memberListeners.contains(listener)) {
                this.memberListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberPresenceListener(ChatRoomMemberPresenceListener listener) {
        Vector<ChatRoomMemberPresenceListener> vector = this.memberListeners;
        synchronized (vector) {
            this.memberListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(ChatRoomMessageListener listener) {
        Vector<ChatRoomMessageListener> vector = this.messageListeners;
        synchronized (vector) {
            if (!this.messageListeners.contains(listener)) {
                this.messageListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(ChatRoomMessageListener listener) {
        Vector<ChatRoomMessageListener> vector = this.messageListeners;
        synchronized (vector) {
            if (this.messageListeners.contains(listener)) {
                this.messageListeners.remove(this.messageListeners.indexOf(listener));
            }
        }
    }

    public ChatRoomMember getChatRoomMember(String memberID) {
        return this.chatRoomMembers.get(memberID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearChatRoomMemberList() {
        Hashtable<String, ChatRoomMember> hashtable = this.chatRoomMembers;
        synchronized (hashtable) {
            this.chatRoomMembers.clear();
        }
    }

    public void invite(String userAddress, String reason) {
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        connection.getChannelManager().invite(userAddress, this);
    }

    public List<ChatRoomMember> getMembers() {
        return new ArrayList<ChatRoomMember>(this.chatRoomMembers.values());
    }

    public int getMembersCount() {
        return this.chatRoomMembers.size();
    }

    public Message createMessage(byte[] content, String contentType, String contentEncoding, String subject) {
        MessageIrcImpl msg = new MessageIrcImpl(new String(content), contentType, contentEncoding, subject);
        return msg;
    }

    public Message createMessage(String messageText) {
        MessageIrcImpl mess = new MessageIrcImpl(messageText, "text/plain", "UTF-8", null);
        return mess;
    }

    public void sendMessage(Message message) throws OperationFailedException {
        this.assertConnected();
        String[] splitMessages = message.getContent().split("\n");
        String messagePortion = null;
        for (int i = 0; i < splitMessages.length; ++i) {
            messagePortion = splitMessages[i];
            if (messagePortion.equals("\n") || messagePortion.matches("[\\ ]*")) continue;
            IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
            if (connection == null) {
                throw new IllegalStateException("Connection is not available.");
            }
            if (((MessageIrcImpl)message).isCommand()) {
                try {
                    connection.getMessageManager().command(this, messagePortion);
                    this.fireMessageReceivedEvent(message, this.user, new Date(), 3);
                }
                catch (UnsupportedCommandException e) {
                    this.fireMessageDeliveryFailedEvent(7, e.getMessage(), new Date(), message);
                }
                catch (BadCommandException e) {
                    LOGGER.error((Object)("An error occurred while constructing the command. This is most likely due to a bug in the implementation of the command. Message: " + message + "'"), (Throwable)e);
                    this.fireMessageDeliveryFailedEvent(4, "Command cannot be executed. This is most likely due to a bug in the implementation.", new Date(), message);
                }
                catch (BadCommandInvocationException e) {
                    StringBuilder helpText = new StringBuilder();
                    if (e.getCause() != null) {
                        helpText.append(e.getCause().getMessage());
                        helpText.append('\n');
                    }
                    helpText.append(e.getHelp());
                    MessageIrcImpl helpMessage = new MessageIrcImpl(helpText.toString(), "text/plain", "UTF-8", "Command usage:");
                    this.fireMessageReceivedEvent((Message)helpMessage, this.user, new Date(), 2);
                }
                continue;
            }
            connection.getMessageManager().message(this, messagePortion);
            this.fireMessageDeliveredEvent((Message)new MessageIrcImpl(messagePortion, message.getContentType(), message.getEncoding(), message.getSubject()));
        }
    }

    public ProtocolProviderService getParentProvider() {
        return this.parentProvider;
    }

    private void assertConnected() throws IllegalStateException {
        if (this.parentProvider == null) {
            throw new IllegalStateException("The provider must be non-null and signed on the service before being able to communicate.");
        }
        if (!this.parentProvider.isRegistered()) {
            throw new IllegalStateException("The provider must be signed on the service before being able to communicate.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageDeliveredEvent(Message message) {
        ArrayList<ChatRoomMessageListener> listeners;
        int eventType = 1;
        MessageIrcImpl msg = (MessageIrcImpl)message;
        if (msg.isAction()) {
            eventType = 2;
            if (msg.getContent().indexOf(32) != -1) {
                msg.setContent(msg.getContent().substring(message.getContent().indexOf(32)));
            }
        }
        ChatRoomMessageDeliveredEvent msgDeliveredEvt = new ChatRoomMessageDeliveredEvent((ChatRoom)this, new Date(), (Message)msg, eventType);
        Vector<ChatRoomMessageListener> vector = this.messageListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomMessageListener>(this.messageListeners);
        }
        for (ChatRoomMessageListener listener : listeners) {
            try {
                listener.messageDelivered(msgDeliveredEvt);
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)String.format("Listener '%s' threw a runtime exception during execution. This is probably due to a bug in the listener's implementation.", listener.getClass().getCanonicalName()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireMessageReceivedEvent(Message message, ChatRoomMember fromMember, Date date, int eventType) {
        ArrayList<ChatRoomMessageListener> listeners;
        ChatRoomMessageReceivedEvent event = new ChatRoomMessageReceivedEvent((ChatRoom)this, fromMember, date, message, eventType);
        Vector<ChatRoomMessageListener> vector = this.messageListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomMessageListener>(this.messageListeners);
        }
        for (ChatRoomMessageListener listener : listeners) {
            try {
                listener.messageReceived(event);
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)String.format("Listener '%s' threw a runtime exception during execution. This is probably due to a bug in the listener's implementation.", listener.getClass().getCanonicalName()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireMessageDeliveryFailedEvent(int errorCode, String reason, Date date, Message message) {
        ArrayList<ChatRoomMessageListener> listeners;
        ChatRoomMessageDeliveryFailedEvent event = new ChatRoomMessageDeliveryFailedEvent((ChatRoom)this, null, errorCode, reason, date, message);
        Vector<ChatRoomMessageListener> vector = this.messageListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomMessageListener>(this.messageListeners);
        }
        for (ChatRoomMessageListener listener : listeners) {
            try {
                listener.messageDeliveryFailed(event);
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)String.format("Listener '%s' threw a runtime exception during execution. This is probably due to a bug in the listener's implementation.", listener.getClass().getCanonicalName()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChangeEvent(PropertyChangeEvent evt) {
        ArrayList<ChatRoomPropertyChangeListener> listeners;
        Vector<ChatRoomPropertyChangeListener> vector = this.propertyChangeListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomPropertyChangeListener>(this.propertyChangeListeners);
        }
        for (ChatRoomPropertyChangeListener listener : listeners) {
            if (evt instanceof ChatRoomPropertyChangeEvent) {
                listener.chatRoomPropertyChanged((ChatRoomPropertyChangeEvent)evt);
                continue;
            }
            if (!(evt instanceof ChatRoomPropertyChangeFailedEvent)) continue;
            listener.chatRoomPropertyChangeFailed((ChatRoomPropertyChangeFailedEvent)evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireMemberPropertyChangeEvent(ChatRoomMemberPropertyChangeEvent evt) {
        ArrayList<ChatRoomMemberPropertyChangeListener> listeners;
        Vector<ChatRoomMemberPropertyChangeListener> vector = this.memberPropChangeListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomMemberPropertyChangeListener>(this.memberPropChangeListeners);
        }
        for (ChatRoomMemberPropertyChangeListener listener : listeners) {
            listener.chatRoomPropertyChanged(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireMemberPresenceEvent(ChatRoomMember member, ChatRoomMember actorMember, String eventID, String eventReason) {
        ArrayList<ChatRoomMemberPresenceListener> listeners;
        if (eventID == "MemberJoined") {
            this.addChatRoomMember(member.getContactAddress(), member);
        } else {
            this.removeChatRoomMember(member.getContactAddress());
        }
        ChatRoomMemberPresenceChangeEvent evt = actorMember != null ? new ChatRoomMemberPresenceChangeEvent((ChatRoom)this, member, actorMember, eventID, eventReason) : new ChatRoomMemberPresenceChangeEvent((ChatRoom)this, member, eventID, eventReason);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Will dispatch the following ChatRoom event: " + evt));
        }
        Vector<ChatRoomMemberPresenceListener> vector = this.memberListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomMemberPresenceListener>(this.memberListeners);
        }
        for (ChatRoomMemberPresenceListener listener : listeners) {
            listener.memberPresenceChanged(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireMemberRoleEvent(ChatRoomMember member, ChatRoomMemberRole newRole) {
        ArrayList<ChatRoomMemberRoleListener> listeners;
        member.setRole(newRole);
        ChatRoomMemberRole previousRole = member.getRole();
        ChatRoomMemberRoleChangeEvent evt = new ChatRoomMemberRoleChangeEvent((ChatRoom)this, member, previousRole, newRole);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Will dispatch the following ChatRoom event: " + evt));
        }
        Vector<ChatRoomMemberRoleListener> vector = this.memberRoleListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomMemberRoleListener>(this.memberRoleListeners);
        }
        for (ChatRoomMemberRoleListener listener : listeners) {
            listener.memberRoleChanged(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireLocalUserRoleChangedEvent(ChatRoomLocalUserRoleChangeEvent event) {
        ArrayList<ChatRoomLocalUserRoleListener> listeners;
        Vector<ChatRoomLocalUserRoleListener> vector = this.localUserRoleListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomLocalUserRoleListener>(this.localUserRoleListeners);
        }
        for (ChatRoomLocalUserRoleListener listener : listeners) {
            listener.localUserRoleChanged(event);
        }
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    protected void setSystem(boolean isSystem) {
        this.isSystem = isSystem;
    }

    protected void setSubjectFromServer(String subject) {
        this.chatSubject = subject;
    }

    public boolean isPersistent() {
        return true;
    }

    public ChatRoomMemberRole getUserRole() {
        if (this.user == null) {
            LOGGER.trace((Object)"User's chat room member instance is not set yet. Assuming default role SILENT_MEMBER.");
            return ChatRoomMemberRole.SILENT_MEMBER;
        }
        return this.user.getRole();
    }

    void setLocalUser(ChatRoomMemberIrcImpl user) {
        if (user == null) {
            throw new IllegalArgumentException("user cannot be null");
        }
        this.user = user;
    }

    public void setLocalUserRole(ChatRoomMemberRole role) throws OperationFailedException {
    }

    public void grantAdmin(String address) {
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        connection.getChannelManager().grant(this, address, Mode.OPERATOR);
    }

    public void grantMembership(String address) {
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        connection.getChannelManager().grant(this, address, Mode.VOICE);
    }

    public void grantModerator(String address) {
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        connection.getChannelManager().grant(this, address, Mode.HALFOP);
    }

    public void grantOwnership(String address) {
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        connection.getChannelManager().grant(this, address, Mode.OWNER);
    }

    public void grantVoice(String address) {
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        connection.getChannelManager().grant(this, address, Mode.VOICE);
    }

    public void revokeAdmin(String address) {
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        connection.getChannelManager().revoke(this, address, Mode.OPERATOR);
    }

    public void revokeMembership(String address) {
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        connection.getChannelManager().revoke(this, address, Mode.VOICE);
    }

    public void revokeModerator(String address) {
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        connection.getChannelManager().revoke(this, address, Mode.HALFOP);
    }

    public void revokeOwnership(String address) {
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        connection.getChannelManager().revoke(this, address, Mode.OWNER);
    }

    public void revokeVoice(String address) {
        IrcConnection connection = this.parentProvider.getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        connection.getChannelManager().revoke(this, address, Mode.VOICE);
    }

    public ConferenceDescription publishConference(ConferenceDescription cd, String name) {
        return null;
    }

    public Contact getPrivateContactByNickname(String name) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Getting private contact for nick name '" + name + "'."));
        }
        return this.parentProvider.getPersistentPresence().findOrCreateContactByID(name);
    }

    public void updatePrivateContactPresenceStatus(String nickname) {
    }

    public void updatePrivateContactPresenceStatus(Contact sourceContact) {
    }

    public boolean destroy(String reason, String alternateAddress) {
        return true;
    }

    public List<String> getMembersWhiteList() {
        return new ArrayList<String>();
    }

    public void setMembersWhiteList(List<String> members) {
    }

    void updateSubject(String subject) {
        if (this.chatSubject.equals(subject)) {
            return;
        }
        String previous = this.chatSubject == null ? "" : this.chatSubject;
        this.chatSubject = subject;
        ChatRoomPropertyChangeEvent topicChangeEvent = new ChatRoomPropertyChangeEvent((ChatRoom)this, "ChatRoomSubject", (Object)previous, (Object)subject);
        this.firePropertyChangeEvent((PropertyChangeEvent)topicChangeEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateChatRoomMemberName(String oldName) {
        Hashtable<String, ChatRoomMember> hashtable = this.chatRoomMembers;
        synchronized (hashtable) {
            ChatRoomMember member = this.chatRoomMembers.remove(oldName);
            if (member != null) {
                this.chatRoomMembers.put(member.getContactAddress(), member);
            }
        }
    }
}

