/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import net.java.sip.communicator.impl.protocol.irc.exception.UnknownModeException;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;

public enum Mode {
    UNKNOWN('?', null),
    OWNER('O', ChatRoomMemberRole.OWNER),
    OPERATOR('o', ChatRoomMemberRole.ADMINISTRATOR),
    HALFOP('h', ChatRoomMemberRole.MODERATOR),
    VOICE('v', ChatRoomMemberRole.MEMBER),
    LIMIT('l', null),
    PRIVATE('p', null),
    SECRET('s', null),
    INVITE('i', null),
    BAN('b', null);

    private final char symbol;
    private final ChatRoomMemberRole role;

    public static Mode bySymbol(char symbol) throws UnknownModeException {
        for (Mode mode : Mode.values()) {
            if (mode.getSymbol() != symbol) continue;
            return mode;
        }
        throw new UnknownModeException(symbol);
    }

    private Mode(char symbol, ChatRoomMemberRole role) {
        this.symbol = symbol;
        this.role = role;
    }

    public char getSymbol() {
        return this.symbol;
    }

    public ChatRoomMemberRole getRole() {
        return this.role;
    }
}

