/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import java.util.Collection;
import org.jmock.core.Constraint;
import org.jmock.core.VerifyingTestCase;
import org.jmock.core.constraint.And;
import org.jmock.core.constraint.HasProperty;
import org.jmock.core.constraint.HasPropertyWithValue;
import org.jmock.core.constraint.HasToString;
import org.jmock.core.constraint.IsAnything;
import org.jmock.core.constraint.IsArrayContaining;
import org.jmock.core.constraint.IsCloseTo;
import org.jmock.core.constraint.IsCollectionContaining;
import org.jmock.core.constraint.IsCompatibleType;
import org.jmock.core.constraint.IsEqual;
import org.jmock.core.constraint.IsIn;
import org.jmock.core.constraint.IsInstanceOf;
import org.jmock.core.constraint.IsMapContaining;
import org.jmock.core.constraint.IsNot;
import org.jmock.core.constraint.IsNull;
import org.jmock.core.constraint.IsSame;
import org.jmock.core.constraint.Or;
import org.jmock.core.constraint.StringContains;
import org.jmock.core.constraint.StringEndsWith;
import org.jmock.core.constraint.StringStartsWith;
import org.jmock.util.Dummy;

public abstract class MockObjectSupportTestCase
extends VerifyingTestCase {
    public static final Constraint ANYTHING = new IsAnything();
    public static final Constraint NULL = new IsNull();
    public static final Constraint NOT_NULL = new IsNot(NULL);

    public MockObjectSupportTestCase() {
    }

    public MockObjectSupportTestCase(String string) {
        super(string);
    }

    public IsEqual eq(Object object) {
        return new IsEqual(object);
    }

    public IsEqual eq(boolean bl) {
        return this.eq(new Boolean(bl));
    }

    public IsEqual eq(byte by) {
        return this.eq(new Byte(by));
    }

    public IsEqual eq(short s) {
        return this.eq(new Short(s));
    }

    public IsEqual eq(char c) {
        return this.eq(new Character(c));
    }

    public IsEqual eq(int n) {
        return this.eq(new Integer(n));
    }

    public IsEqual eq(long l) {
        return this.eq(new Long(l));
    }

    public IsEqual eq(float f) {
        return this.eq(new Float(f));
    }

    public IsEqual eq(double d) {
        return this.eq(new Double(d));
    }

    public IsCloseTo eq(double d, double d2) {
        return new IsCloseTo(d, d2);
    }

    public IsSame same(Object object) {
        return new IsSame(object);
    }

    public IsInstanceOf isA(Class clazz) {
        return new IsInstanceOf(clazz);
    }

    public StringContains stringContains(String string) {
        return new StringContains(string);
    }

    public StringContains contains(String string) {
        return this.stringContains(string);
    }

    public StringStartsWith startsWith(String string) {
        return new StringStartsWith(string);
    }

    public StringEndsWith endsWith(String string) {
        return new StringEndsWith(string);
    }

    public IsNot not(Constraint constraint) {
        return new IsNot(constraint);
    }

    public And and(Constraint constraint, Constraint constraint2) {
        return new And(constraint, constraint2);
    }

    public Or or(Constraint constraint, Constraint constraint2) {
        return new Or(constraint, constraint2);
    }

    public Object newDummy(Class clazz) {
        return Dummy.newDummy(clazz);
    }

    public Object newDummy(Class clazz, String string) {
        return Dummy.newDummy(clazz, string);
    }

    public Object newDummy(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }

    public void assertThat(Object object, Constraint constraint) {
        if (!constraint.eval(object)) {
            StringBuffer stringBuffer = new StringBuffer("\nExpected: ");
            constraint.describeTo(stringBuffer);
            stringBuffer.append("\n    got : ").append(object).append('\n');
            MockObjectSupportTestCase.fail((String)stringBuffer.toString());
        }
    }

    public void assertThat(boolean bl, Constraint constraint) {
        this.assertThat(new Boolean(bl), constraint);
    }

    public void assertThat(byte by, Constraint constraint) {
        this.assertThat(new Byte(by), constraint);
    }

    public void assertThat(short s, Constraint constraint) {
        this.assertThat(new Short(s), constraint);
    }

    public void assertThat(char c, Constraint constraint) {
        this.assertThat(new Character(c), constraint);
    }

    public void assertThat(int n, Constraint constraint) {
        this.assertThat(new Integer(n), constraint);
    }

    public void assertThat(long l, Constraint constraint) {
        this.assertThat(new Long(l), constraint);
    }

    public void assertThat(float f, Constraint constraint) {
        this.assertThat(new Float(f), constraint);
    }

    public void assertThat(double d, Constraint constraint) {
        this.assertThat(new Double(d), constraint);
    }

    public HasPropertyWithValue hasProperty(String string, Constraint constraint) {
        return new HasPropertyWithValue(string, constraint);
    }

    public HasProperty hasProperty(String string) {
        return new HasProperty(string);
    }

    public HasToString toString(Constraint constraint) {
        return new HasToString(constraint);
    }

    public IsCompatibleType compatibleType(Class clazz) {
        return new IsCompatibleType(clazz);
    }

    public IsIn isIn(Collection collection) {
        return new IsIn(collection);
    }

    public IsIn isIn(Object[] objectArray) {
        return new IsIn(objectArray);
    }

    public IsCollectionContaining collectionContaining(Constraint constraint) {
        return new IsCollectionContaining(constraint);
    }

    public IsCollectionContaining collectionContaining(Object object) {
        return this.collectionContaining(this.eq(object));
    }

    public IsArrayContaining arrayContaining(Constraint constraint) {
        return new IsArrayContaining(constraint);
    }

    public IsArrayContaining arrayContaining(Object object) {
        return this.arrayContaining(this.eq(object));
    }

    public IsArrayContaining arrayContaining(boolean bl) {
        return this.arrayContaining(new Boolean(bl));
    }

    public IsArrayContaining arrayContaining(byte by) {
        return this.arrayContaining(new Byte(by));
    }

    public IsArrayContaining arrayContaining(short s) {
        return this.arrayContaining(new Short(s));
    }

    public IsArrayContaining arrayContaining(char c) {
        return this.arrayContaining(new Character(c));
    }

    public IsArrayContaining arrayContaining(int n) {
        return this.arrayContaining(new Integer(n));
    }

    public IsArrayContaining arrayContaining(long l) {
        return this.arrayContaining(new Long(l));
    }

    public IsArrayContaining arrayContaining(float f) {
        return this.arrayContaining(new Float(f));
    }

    public IsArrayContaining arrayContaining(double d) {
        return this.arrayContaining(new Double(d));
    }

    public IsMapContaining mapContaining(Constraint constraint, Constraint constraint2) {
        return new IsMapContaining(constraint, constraint2);
    }

    public IsMapContaining mapContaining(Object object, Object object2) {
        return this.mapContaining(this.eq(object), this.eq(object2));
    }

    public IsMapContaining mapWithKey(Object object) {
        return this.mapWithKey(this.eq(object));
    }

    public IsMapContaining mapWithKey(Constraint constraint) {
        return new IsMapContaining(constraint, ANYTHING);
    }

    public IsMapContaining mapWithValue(Object object) {
        return this.mapWithValue(this.eq(object));
    }

    public IsMapContaining mapWithValue(Constraint constraint) {
        return new IsMapContaining(ANYTHING, constraint);
    }
}

