/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.focusabletip;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.html.HTMLDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;

public class TipUtil {
    private TipUtil() {
    }

    private static final String getHexString(Color color) {
        if (color == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("#");
        int n = color.getRed();
        if (n < 16) {
            stringBuilder.append('0');
        }
        stringBuilder.append(Integer.toHexString(n));
        int n2 = color.getGreen();
        if (n2 < 16) {
            stringBuilder.append('0');
        }
        stringBuilder.append(Integer.toHexString(n2));
        int n3 = color.getBlue();
        if (n3 < 16) {
            stringBuilder.append('0');
        }
        stringBuilder.append(Integer.toHexString(n3));
        return stringBuilder.toString();
    }

    public static Rectangle getScreenBoundsForPoint(int n, int n2) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDeviceArray[i].getConfigurations();
            for (int j = 0; j < graphicsConfigurationArray.length; ++j) {
                Rectangle rectangle = graphicsConfigurationArray[j].getBounds();
                if (!rectangle.contains(n, n2)) continue;
                return rectangle;
            }
        }
        return graphicsEnvironment.getMaximumWindowBounds();
    }

    public static Color getToolTipBackground() {
        Color color = UIManager.getColor("ToolTip.background");
        boolean bl = TipUtil.isNimbusLookAndFeel();
        if ((color == null || bl) && ((color = UIManager.getColor("info")) == null || bl && TipUtil.isDerivedColor(color))) {
            color = SystemColor.info;
        }
        if (color instanceof ColorUIResource) {
            color = new Color(color.getRGB());
        }
        return color;
    }

    public static Border getToolTipBorder() {
        Border border = UIManager.getBorder("ToolTip.border");
        if ((border == null || TipUtil.isNimbusLookAndFeel()) && (border = UIManager.getBorder("nimbusBorder")) == null) {
            border = BorderFactory.createLineBorder(SystemColor.controlDkShadow);
        }
        return border;
    }

    private static final boolean isDerivedColor(Color color) {
        return color != null && color.getClass().getName().endsWith(".DerivedColor");
    }

    private static final boolean isNimbusLookAndFeel() {
        return UIManager.getLookAndFeel().getName().equals("Nimbus");
    }

    public static void tweakTipEditorPane(JEditorPane jEditorPane) {
        Serializable serializable;
        Color color;
        boolean bl = TipUtil.isNimbusLookAndFeel();
        if (bl) {
            color = jEditorPane.getSelectionColor();
            serializable = jEditorPane.getSelectedTextColor();
            jEditorPane.setUI(new BasicEditorPaneUI());
            jEditorPane.setSelectedTextColor((Color)serializable);
            jEditorPane.setSelectionColor(color);
        }
        jEditorPane.setEditable(false);
        jEditorPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jEditorPane.getCaret().setSelectionVisible(true);
        color = UIManager.getColor("Label.foreground");
        if (color == null || bl && TipUtil.isDerivedColor(color)) {
            color = SystemColor.textText;
        }
        jEditorPane.setForeground(color);
        jEditorPane.setBackground(TipUtil.getToolTipBackground());
        serializable = UIManager.getFont("Label.font");
        if (serializable == null) {
            serializable = new Font("SansSerif", 0, 12);
        }
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        hTMLDocument.getStyleSheet().addRule("body { font-family: " + ((Font)serializable).getFamily() + "; font-size: " + ((Font)serializable).getSize() + "pt" + "; color: " + TipUtil.getHexString(color) + "; }");
        Color color2 = RSyntaxUtilities.getHyperlinkForeground();
        hTMLDocument.getStyleSheet().addRule("a { color: " + TipUtil.getHexString(color2) + "; }");
    }
}

