/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.parser;

import java.awt.Color;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;

public class DefaultParserNotice
implements ParserNotice {
    private Parser parser;
    private ParserNotice.Level level;
    private int line;
    private int offset;
    private int length;
    private boolean showInEditor;
    private Color color;
    private String message;
    private String toolTipText;
    private static final Color[] DEFAULT_COLORS = new Color[]{new Color(255, 0, 128), new Color(244, 200, 45), Color.gray};

    public DefaultParserNotice(Parser parser, String string, int n) {
        this(parser, string, n, -1, -1);
    }

    public DefaultParserNotice(Parser parser, String string, int n, int n2, int n3) {
        this.parser = parser;
        this.message = string;
        this.line = n;
        this.offset = n2;
        this.length = n3;
        this.setLevel(ParserNotice.Level.ERROR);
        this.setShowInEditor(true);
    }

    @Override
    public int compareTo(ParserNotice parserNotice) {
        int n = -1;
        if (parserNotice != null && (n = this.level.getNumericValue() - parserNotice.getLevel().getNumericValue()) == 0 && (n = this.line - parserNotice.getLine()) == 0) {
            n = this.message.compareTo(parserNotice.getMessage());
        }
        return n;
    }

    @Override
    public boolean containsPosition(int n) {
        return this.offset <= n && n < this.offset + this.length;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ParserNotice)) {
            return false;
        }
        return this.compareTo((ParserNotice)object) == 0;
    }

    @Override
    public Color getColor() {
        Color color = this.color;
        if (color == null) {
            color = DEFAULT_COLORS[this.getLevel().getNumericValue()];
        }
        return color;
    }

    @Override
    public boolean getKnowsOffsetAndLength() {
        return this.offset >= 0 && this.length >= 0;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public ParserNotice.Level getLevel() {
        return this.level;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public Parser getParser() {
        return this.parser;
    }

    @Override
    public boolean getShowInEditor() {
        return this.showInEditor;
    }

    @Override
    public String getToolTipText() {
        return this.toolTipText != null ? this.toolTipText : this.getMessage();
    }

    public int hashCode() {
        return this.line << 16 | this.offset;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setLevel(ParserNotice.Level level) {
        if (level == null) {
            level = ParserNotice.Level.ERROR;
        }
        this.level = level;
    }

    public void setShowInEditor(boolean bl) {
        this.showInEditor = bl;
    }

    public void setToolTipText(String string) {
        this.toolTipText = string;
    }

    public String toString() {
        return "Line " + this.getLine() + ": " + this.getMessage();
    }
}

