/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.Caret;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipUtil;
import org.fife.ui.rtextarea.ClipboardHistory;
import org.fife.ui.rtextarea.ConfigurableCaret;
import org.fife.ui.rtextarea.RTextArea;

class ClipboardHistoryPopup
extends JWindow {
    private RTextArea textArea;
    private ChoiceList list;
    private Listener listener;
    private boolean prevCaretAlwaysVisible;
    private static final int VERTICAL_SPACE = 1;
    private static final String MSG = "org.fife.ui.rtextarea.RTextArea";

    public ClipboardHistoryPopup(Window window, RTextArea rTextArea) {
        super(window);
        this.textArea = rTextArea;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(TipUtil.getToolTipBorder(), BorderFactory.createEmptyBorder(2, 5, 5, 5)));
        jPanel.setBackground(TipUtil.getToolTipBackground());
        this.setContentPane(jPanel);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(MSG);
        JLabel jLabel = new JLabel(resourceBundle.getString("Action.ClipboardHistory.Popup.Label"));
        jPanel.add((Component)jLabel, "North");
        this.list = new ChoiceList();
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel.add(jScrollPane);
        this.installKeyBindings();
        this.listener = new Listener();
        this.setLocation();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension.width = Math.min(dimension.width, 300);
            dimension.width = Math.max(dimension.width, 200);
        }
        return dimension;
    }

    private void insertSelectedItem() {
        Object e = this.list.getSelectedValue();
        if (e != null) {
            this.listener.uninstallAndHide();
            String string = ((LabelValuePair)e).value;
            this.textArea.replaceSelection(string);
            ClipboardHistory.get().add(string);
        }
    }

    private void installKeyBindings() {
        InputMap inputMap = this.getRootPane().getInputMap(1);
        ActionMap actionMap = this.getRootPane().getActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        inputMap.put(keyStroke, "onEscape");
        actionMap.put("onEscape", new EscapeAction());
        this.list.getInputMap().remove(keyStroke);
    }

    public void setContents(List<String> list) {
        this.list.setContents(list);
        this.pack();
    }

    private void setLocation() {
        Rectangle rectangle = null;
        try {
            rectangle = this.textArea.modelToView(this.textArea.getCaretPosition());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(point, this.textArea);
        rectangle.x = point.x;
        rectangle.y = point.y;
        Rectangle rectangle2 = TipUtil.getScreenBoundsForPoint(rectangle.x, rectangle.y);
        int n = this.getHeight();
        int n2 = rectangle.y + rectangle.height + 1;
        if (n2 + n > rectangle2.height) {
            n2 = rectangle.y - 1 - this.getHeight();
        }
        int n3 = rectangle.x;
        if (!this.textArea.getComponentOrientation().isLeftToRight()) {
            n3 -= this.getWidth();
        }
        if (n3 < rectangle2.x) {
            n3 = rectangle2.x;
        } else if (n3 + this.getWidth() > rectangle2.x + rectangle2.width) {
            n3 = rectangle2.x + rectangle2.width - this.getWidth();
        }
        this.setLocation(n3, n2);
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.list.getModel().getSize() == 0) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.textArea);
            return;
        }
        super.setVisible(bl);
        this.updateTextAreaCaret(bl);
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClipboardHistoryPopup.this.requestFocus();
                    if (ClipboardHistoryPopup.this.list.getModel().getSize() > 0) {
                        ClipboardHistoryPopup.this.list.setSelectedIndex(0);
                    }
                    ClipboardHistoryPopup.this.list.requestFocusInWindow();
                }
            });
        }
    }

    private void updateTextAreaCaret(boolean bl) {
        Caret caret = this.textArea.getCaret();
        if (caret instanceof ConfigurableCaret) {
            ConfigurableCaret configurableCaret = (ConfigurableCaret)caret;
            if (bl) {
                this.prevCaretAlwaysVisible = configurableCaret.isAlwaysVisible();
                configurableCaret.setAlwaysVisible(true);
            } else {
                configurableCaret.setAlwaysVisible(this.prevCaretAlwaysVisible);
            }
        }
    }

    private static class LabelValuePair {
        public String label;
        public String value;
        private static final int LABEL_MAX_LENGTH = 50;

        public LabelValuePair(String string) {
            this.label = this.value = string;
            int n = this.label.indexOf(10);
            boolean bl = false;
            if (n > -1) {
                this.label = this.label.substring(0, n);
                bl = true;
            }
            if (this.label.length() > 50) {
                this.label = this.label.substring(0, 50) + "...";
            } else if (bl) {
                int n2 = 3 - (50 - this.label.length());
                if (n2 > 0) {
                    this.label = this.label.substring(0, this.label.length() - n2);
                }
                this.label = this.label + "...";
            }
        }

        public String toString() {
            return this.label;
        }
    }

    private static class ChoiceList
    extends JList {
        private ChoiceList() {
            super(new DefaultListModel());
            this.setSelectionMode(0);
            this.installKeyboardActions();
        }

        private void installKeyboardActions() {
            InputMap inputMap = this.getInputMap();
            ActionMap actionMap = this.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke(40, 0), "onDown");
            actionMap.put("onDown", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = (ChoiceList.this.getSelectedIndex() + 1) % ChoiceList.this.getModel().getSize();
                    ChoiceList.this.ensureIndexIsVisible(n);
                    ChoiceList.this.setSelectedIndex(n);
                }
            });
            inputMap.put(KeyStroke.getKeyStroke(38, 0), "onUp");
            actionMap.put("onUp", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ChoiceList.this.getSelectedIndex() - 1;
                    if (n < 0) {
                        n += ChoiceList.this.getModel().getSize();
                    }
                    ChoiceList.this.ensureIndexIsVisible(n);
                    ChoiceList.this.setSelectedIndex(n);
                }
            });
        }

        private void setContents(List<String> list) {
            DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
            defaultListModel.clear();
            for (String string : list) {
                defaultListModel.addElement(new LabelValuePair(string));
            }
            this.setVisibleRowCount(Math.min(defaultListModel.getSize(), 8));
        }
    }

    private class Listener
    extends WindowAdapter
    implements ComponentListener {
        public Listener() {
            ClipboardHistoryPopup.this.addWindowFocusListener(this);
            ClipboardHistoryPopup.this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        ClipboardHistoryPopup.this.insertSelectedItem();
                    }
                }
            });
            ClipboardHistoryPopup.this.list.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "onEnter");
            ClipboardHistoryPopup.this.list.getActionMap().put("onEnter", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ClipboardHistoryPopup.this.insertSelectedItem();
                }
            });
            Window window = (Window)ClipboardHistoryPopup.this.getParent();
            window.addWindowFocusListener(this);
            window.addWindowListener(this);
            window.addComponentListener(this);
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.uninstallAndHide();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            this.uninstallAndHide();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            this.uninstallAndHide();
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            this.uninstallAndHide();
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            this.checkForParentWindowEvent(windowEvent);
        }

        @Override
        public void windowLostFocus(WindowEvent windowEvent) {
            if (windowEvent.getSource() == ClipboardHistoryPopup.this) {
                this.uninstallAndHide();
            }
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            this.checkForParentWindowEvent(windowEvent);
        }

        private boolean checkForParentWindowEvent(WindowEvent windowEvent) {
            if (windowEvent.getSource() == ClipboardHistoryPopup.this.getParent()) {
                this.uninstallAndHide();
                return true;
            }
            return false;
        }

        private void uninstallAndHide() {
            Window window = (Window)ClipboardHistoryPopup.this.getParent();
            window.removeWindowFocusListener(this);
            window.removeWindowListener(this);
            window.removeComponentListener(this);
            ClipboardHistoryPopup.this.removeWindowFocusListener(this);
            ClipboardHistoryPopup.this.setVisible(false);
            ClipboardHistoryPopup.this.dispose();
        }
    }

    private class EscapeAction
    extends AbstractAction {
        private EscapeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ClipboardHistoryPopup.this.listener.uninstallAndHide();
        }
    }
}

