/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.VolatileImage;
import org.fife.ui.rtextarea.ImageBackgroundPainterStrategy;
import org.fife.ui.rtextarea.RTextAreaBase;

public class VolatileImageBackgroundPainterStrategy
extends ImageBackgroundPainterStrategy {
    private VolatileImage bgImage;

    public VolatileImageBackgroundPainterStrategy(RTextAreaBase rTextAreaBase) {
        super(rTextAreaBase);
    }

    @Override
    protected void paintImage(Graphics graphics, int n, int n2) {
        if (this.bgImage != null) {
            do {
                int n3;
                if ((n3 = this.bgImage.validate(null)) == 1) {
                    this.renderImage(this.bgImage.getWidth(), this.bgImage.getHeight(), this.getScalingHint());
                }
                graphics.drawImage(this.bgImage, n, n2, null);
            } while (this.bgImage.contentsLost());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderImage(int n, int n2, int n3) {
        Image image = this.getMasterImage();
        if (image != null) {
            do {
                Image image2 = image.getScaledInstance(n, n2, n3);
                this.tracker.addImage(image2, 1);
                try {
                    this.tracker.waitForID(1);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    this.bgImage = null;
                    return;
                }
                finally {
                    this.tracker.removeImage(image2, 1);
                }
                this.bgImage.getGraphics().drawImage(image2, 0, 0, null);
                this.tracker.addImage(this.bgImage, 0);
                try {
                    this.tracker.waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    this.bgImage = null;
                    return;
                }
                finally {
                    this.tracker.removeImage(this.bgImage, 0);
                }
            } while (this.bgImage.contentsLost());
        } else {
            this.bgImage = null;
        }
    }

    @Override
    protected void rescaleImage(int n, int n2, int n3) {
        this.bgImage = this.getRTextAreaBase().createVolatileImage(n, n2);
        if (this.bgImage != null) {
            this.renderImage(n, n2, n3);
        }
    }
}

