/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.net.ftp.FTPFileEntryParserImpl;

public abstract class RegexFTPFileEntryParserImpl
extends FTPFileEntryParserImpl {
    private Pattern pattern = null;
    private MatchResult result = null;
    protected Matcher _matcher_ = null;

    public RegexFTPFileEntryParserImpl(String string) {
        this.compileRegex(string, 0);
    }

    public RegexFTPFileEntryParserImpl(String string, int n) {
        this.compileRegex(string, n);
    }

    public boolean matches(String string) {
        this.result = null;
        this._matcher_ = this.pattern.matcher(string);
        if (this._matcher_.matches()) {
            this.result = this._matcher_.toMatchResult();
        }
        return null != this.result;
    }

    public int getGroupCnt() {
        if (this.result == null) {
            return 0;
        }
        return this.result.groupCount();
    }

    public String group(int n) {
        if (this.result == null) {
            return null;
        }
        return this.result.group(n);
    }

    public String getGroupsAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i <= this.result.groupCount(); ++i) {
            stringBuilder.append(i).append(") ").append(this.result.group(i)).append(System.getProperty("line.separator"));
        }
        return stringBuilder.toString();
    }

    public boolean setRegex(String string) {
        this.compileRegex(string, 0);
        return true;
    }

    public boolean setRegex(String string, int n) {
        this.compileRegex(string, n);
        return true;
    }

    private void compileRegex(String string, int n) {
        try {
            this.pattern = Pattern.compile(string, n);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Unparseable regex supplied: " + string);
        }
    }
}

