/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.javascript;

import java.util.List;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObjectPreviewPlugin;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObjectPropertyPlugin;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptNodes;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptObjectProperties;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptType;
import org.graalvm.visualvm.heapviewer.ui.HeapViewPlugin;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.openide.util.Lookup;

final class JavaScriptViewPlugins {
    JavaScriptViewPlugins() {
    }

    public static class ReferencesPluginProvider
    extends HeapViewPlugin.Provider {
        public HeapViewPlugin createPlugin(HeapContext context, HeapViewerActions actions, String viewID) {
            if (!JavaScriptHeapFragment.isJavaScriptHeap(context)) {
                return null;
            }
            JavaScriptObjectProperties.ReferencesProvider fieldsProvider = (JavaScriptObjectProperties.ReferencesProvider)((Object)Lookup.getDefault().lookup(JavaScriptObjectProperties.ReferencesProvider.class));
            return new TruffleObjectPropertyPlugin<JavaScriptObject, JavaScriptType, JavaScriptHeapFragment, JavaScriptLanguage>(Bundle.JavaScriptViewPlugins_ReferencesName(), Bundle.JavaScriptViewPlugins_ReferencesDescription(), Icons.getIcon((String)"ProfilerIcons.NodeReverse"), "javascript_objects_references", context, actions, fieldsProvider);
        }
    }

    public static class FieldsPluginProvider
    extends HeapViewPlugin.Provider {
        public HeapViewPlugin createPlugin(HeapContext context, HeapViewerActions actions, String viewID) {
            if (!JavaScriptHeapFragment.isJavaScriptHeap(context)) {
                return null;
            }
            JavaScriptObjectProperties.FieldsProvider fieldsProvider = (JavaScriptObjectProperties.FieldsProvider)((Object)Lookup.getDefault().lookup(JavaScriptObjectProperties.FieldsProvider.class));
            return new TruffleObjectPropertyPlugin<JavaScriptObject, JavaScriptType, JavaScriptHeapFragment, JavaScriptLanguage>(Bundle.JavaScriptViewPlugins_PropertiesName(), Bundle.JavaScriptViewPlugins_PropertiesDescription(), Icons.getIcon((String)"ProfilerIcons.NodeForward"), "javascript_objects_fields", context, actions, fieldsProvider);
        }
    }

    public static class PreviewPluginProvider
    extends HeapViewPlugin.Provider {
        public HeapViewPlugin createPlugin(HeapContext context, HeapViewerActions actions, String viewID) {
            if (JavaScriptHeapFragment.isJavaScriptHeap(context)) {
                return new PreviewPlugin(context);
            }
            return null;
        }
    }

    static class PreviewPlugin
    extends TruffleObjectPreviewPlugin {
        PreviewPlugin(HeapContext context) {
            super(context);
        }

        @Override
        protected boolean supportsNode(HeapViewerNode node) {
            return node instanceof JavaScriptNodes.JavaScriptObjectNode;
        }

        @Override
        protected Instance getPreviewInstance(HeapViewerNode node) {
            JavaScriptNodes.JavaScriptObjectNode jsnode = (JavaScriptNodes.JavaScriptObjectNode)node;
            if ("Function".equals(jsnode.getTypeName()) || "JSFunction".equals(jsnode.getTypeName())) {
                Instance data;
                JavaScriptObject jsobj = (JavaScriptObject)jsnode.getTruffleObject();
                FieldValue dataField = jsobj.getFieldValue("functionData (hidden)");
                Instance instance = data = dataField instanceof ObjectFieldValue ? ((ObjectFieldValue)dataField).getInstance() : null;
                if (data == null) {
                    return null;
                }
                Object rootNode = data.getValueOfField("lazyInit");
                if (!(rootNode instanceof Instance)) {
                    Object callTarget = data.getValueOfField("callTarget");
                    if (!(callTarget instanceof Instance)) {
                        return null;
                    }
                    rootNode = ((Instance)callTarget).getValueOfField("rootNode");
                    if (!(rootNode instanceof Instance)) {
                        return null;
                    }
                }
                Instance sourceSection = null;
                List rootNodeFields = ((Instance)rootNode).getFieldValues();
                for (FieldValue field : rootNodeFields) {
                    Instance instance2;
                    if (!"sourceSection".equals(field.getField().getName()) || !(field instanceof ObjectFieldValue) || (instance2 = ((ObjectFieldValue)field).getInstance()) == null) continue;
                    sourceSection = instance2;
                    break;
                }
                if (!(sourceSection instanceof Instance)) {
                    Object nnode = ((Instance)rootNode).getValueOfField("node");
                    if (!(nnode instanceof Instance)) {
                        return null;
                    }
                    Object ssourceSection = ((Instance)nnode).getValueOfField("source");
                    if (!(ssourceSection instanceof Instance)) {
                        return null;
                    }
                    sourceSection = (Instance)ssourceSection;
                }
                return sourceSection;
            }
            return null;
        }
    }
}

